if UnitFactionGroup("player")~="Horde" then return end
local ZygorGuidesViewer=ZygorGuidesViewer
if not ZygorGuidesViewer then return end
if ZGV:DoMutex("IncludesH") then return end



--------------------------------------------------------------------------------------------------------------------------------------
-- Hearth Includes
--------------------------------------------------------------------------------------------------------------------------------------

ZygorGuidesViewer:RegisterInclude("home_ValleyofStrength",[[
		goto Orgrimmar,53.6,78.8
		.talk Innkeeper Gryshka##6929
		.home Valley of Strength
]])

ZygorGuidesViewer:RegisterInclude("home_ValleyofHonor",[[
		goto Orgrimmar,70.5,49.2
		.talk Innkeeper Nufa##46642
		.home Valley of Honor
]])

ZygorGuidesViewer:RegisterInclude("home_UC",[[
		goto Undercity,67.7,37.9
		.talk Innkeeper Norman##6741
		.home Trade Quarter
]])

ZygorGuidesViewer:RegisterInclude("Spirt_Harmony",[[
		goto Vale of Eternal Blossoms/0 61.7,21.7
		.talk Danky##66685
]])

--------------------------------------------------------------------------------------------------------------------------------------
-- Portal Includes
--------------------------------------------------------------------------------------------------------------------------------------

--Opening up the portal to Pandaria--
ZygorGuidesViewer:RegisterInclude("h_begin_pandaria",[[
	step
		.' In order to get to Pandaria for the first time, you must complete the opening questline to The Jade Forest.
		|confirm
	step
		goto Orgrimmar 49.8,75.3
		..accept The Art of War##29612
		.' Report to Grommash Hold |q 29612/1
	step
		goto Orgrimmar 48.6,70.6
		.talk General Nazgrim##54870
		..turnin The Art of War##29612
		..accept All Aboard!##31853
	step
		goto Kalimdor 61.2,44.6
		' Look for a ship in the air. You have to use a flying mount to get to General Nazgrim.
		.talk General Nazgrim##55054
		..turnin All Aboard!##31853
		..accept Into the Mists##29690
	step
		.talk General Nazgrim##55054
		.' Tell him you're ready to go!
		.' Discover Pandaria |q 29690/1
	step
		goto The Jade Forest 30.8,10.2
		.talk General Nazgrim##55135
		..turnin Into the Mists##29690
		..accept Paint it Red!##31765
	step
		.' Follow the steps down here. |goto 31.4,11.3 <5 |c
	step
		.clicknpc Gunship Turret##67032
		|invehicle
	step
		.' Use your abilities on your action bar.
		.kill 80 Thunder Hold Troops |q 31765/1
		.kill 9 Thunder Hold Cannons |q 31765/2 
		|modelnpc 66203
		|modelnpc 66348
		|modelnpc 66506
		|modelnpc 66291
	step
		goto 31.0,11.0
		.talk Rivett Clutchpop##67250
		..turnin Paint it Red!##31765
		..accept Touching Ground##31766
	step
		  goto 31.5,11.1
		  .click Rappelling Rope##7548
		  .' Rappel into Honeydew Glade |q 31766/1
	step
		goto 31.6,11.3
		.talk General Nazgrim##55135
		..turnin Touching Ground##31766
]])



--------------------------------------------------------------------------------------------------------------------------------------
-- EVENTS
--------------------------------------------------------------------------------------------------------------------------------------
--Darkmoon Faire--
ZygorGuidesViewer:RegisterInclude("H_Darkmoon_Faire_Dailies",[[
	step
		goto Darkmoon Island,54.3,53.1
		.talk Zina Sharpworth##55266
		.buy Sack o' Tokens##78909 |n
		.' Open your Sack o' Tokens in your bags |use Sack o' Tokens##78909
		.collect 20 Darkmoon Faire Game Tokens##71083
	step
		goto Darkmoon Island,53.3,54.4
		.talk Mola##54601
		..accept It's Hammer Time##29463
	step
		goto Darkmoon Island,53.3,54.4
		.talk Mola##54601
		.' Tell her:
		.' <Ready to whack!> |havebuff Interface\Icons\inv_hammer_32
	step
		.' Use the _Whack!_ on your bar and whack the Gnolls in the Barrels
		.' The Gnolls  will pop up in the Barrels, but be careful not to hit the _Doll_ or you will get stunned.
		.' Whack 30 Gnolls |q 29463/1
	step
		goto Darkmoon Island,53.3,54.4
		.talk Mola##54601
		..turnin It's Hammer Time##29463
	step
		goto Darkmoon Island,52.5,56.2
		.talk Maxima Blastenheimer##15303
		..accept The Humanoid Cannonball##29436
		|next "quest"
	step
	label	"target"
		goto Darkmoon Island,57.1,89.6
		.talk Teleportologist Fozlebub##57850
		.' Tell him:
		.' <Teleport me to the cannon.> |goto 52.7,56.0,1 |noway |c
	step
	label	"quest"
		goto Darkmoon Island,52.5,56.2
		.talk Maxima Blastenheimer##15303
		.' Tell her:
		.' <Launch me!>
		'Wait for the Cannon to Launch you |havebuff Interface\Icons\Spell_Magic_FeatherFall
	step
		goto Darkmoon Island,56.4,93.3
		.' You will be launched throught the air. 
		.' You the __ to drop in the water in the target. You will gain more points for getting closer to the middle.
		.' Earn 5 Target Points |q 29436/1
		.' Click here to try again |confirm |next "target"
	step
		goto Darkmoon Island,57.1,89.6
		.talk Teleportologist Fozlebub##57850
		.' Tell him:
		.' <Teleport me to the cannon.> |goto 52.7,56.0,1 |noway |c
	step
		goto Darkmoon Island,52.5,56.2
		.talk Maxima Blastenheimer##15303
		..turnin The Humanoid Cannonball##29436
	step
		goto 49.3,60.8
		.talk Rinling##14841
		..accept He Shoots, He Scores!##29438
	step
		goto 49.3,60.8
		.talk Rinling##14841	
		.' Tell him:
		.' <Let's shoot!> |havebuff Interface\Icons\INV_Weapon_Rifle_05
	step
		'Shoot at the 3 targets. 
		.' When you see a green marker appear over a target, make sure that you are aimed at it and _shoot_ |tip To aim, simply move the camera to face your current target.
		.' Shoot 25 Targets |q 29438/1
	step
		goto 49.3,60.8
		.talk Rinling##14841
		..turnin He Shoots, He Scores!##29438
	step
		goto Darkmoon Island,50.7,65.1
		.talk Finlay Coolshot##54605
		..accept Tonk Commander##29434
	step
		goto Darkmoon Island,50.7,65.1
		.talk Finlay Coolshot##54605
		.' Tell him:
		.' <Ready to Play.> |invehicle |c
	step
		'Use your _Cannon_ ability to shoot _Tonk Targets_.
		.from Tonk Target##33081+
		.' Destroy 30 Tonk Targets |q 29434/1
	step
		goto Darkmoon Island,50.7,65.1
		.talk Finlay Coolshot##54605
		..turnin Tonk Commander##29434
	step
		goto 51.6,77.8
		.talk Jessica Rogers##54485
		..accept Target: Turtle##29455
	step
		goto 51.6,77.8
		.talk Jessica Rogers##54485
		.' Tell her: 
		.' <Ready to play!> |havebuff Interface\Icons\INV_Jewelry_Ring_03
	step
		'Use your _Ring Toss_ ability to throw rings on the turtle.  |tip When aiming, move the marker over the middle of the turtle.
		.' Land 3 Rings on Dubenko |q 29455/1
		'|modelnpc 54490
	step
		goto 51.6,77.8
		.talk Jessica Rogers##54485
		..turnin Target: Turtle##29455
]])

ZygorGuidesViewer:RegisterInclude("H_Darkmoon_Faire_Quests",[[ 
	step
		goto Mulgore,46.8,60.4
		.talk Innkeeper Kauth##6747
		.buy 5 Moonberry Juice##1645
		|only if skill("Alchemy")>74 and not completedq(29506)
	step
		goto Thunder Bluff 40.6,62.6
		.talk Shadi Mistrunner##8363
		.buy 5 Simple Flour##30817
		|only if skill("Cooking")>74 and not completedq(29509)
	step
		goto Thunder Bluff 40.6,62.6
		.talk Shadi Mistrunner##8363
		.buy 1 Coarse Thread##2320
		.buy 1 Blue Dye##6260
		.buy 1 Red Dye##2604
		|only if skill("Tailoring")>74 and not completedq(29520)
	step
		goto Thunder Bluff 40.6,62.6
		.talk Shadi Mistrunner##8363
		.buy 5 Coarse Thread##2320
		.buy 5 Blue Dye##6260
		.buy 10 Red Dye##2604
		|only if skill("Leatherworking")>74 and not completedq(29517)
	step
		goto Darkmoon Island 55.4,54.8
		.talk Selina Dourman##10445
		..accept Banners, Banners Everywhere!##29520
		|only if skill("Tailoring")>74
	step
		goto Darkmoon Island,49.3,60.8
		.talk Rinling##14841
		..accept Talkin' Tonks##29511
		|only if skill("Engineering")>74
	step
		goto Darkmoon Island,49.3,60.7
		.talk Rinling##14841
		..accept Rearm, Reuse, Recycle##29518
		|only if skill("Mining")>74
	step
		goto 49.3,60.9
		.talk Rinling##14841
		..accept Eyes on the Prizes##29517
		|only if skill("Leatherworking")>74
	step
		goto Darkmoon Island,52.9,68.0
		.talk Stamp Thunderhorn##14845
		..accept Putting the Crunch in the Frog##29509
		|only if skill("Cooking")>74
	step
		goto Darkmoon Island,52.9,68.0
		.talk Stamp Thunderhorn##14845		
		..accept Spoilin' for Salty Sea Dogs##29513
		|only if skill("Fishing")>74
	step
		goto Darkmoon Island 53.2,75.8
		.talk Sayge##14822
		..accept Writing the Future##29515
		|only if skill("Inscription")>74
	step
		goto Darkmoon Island,55.0,70.8
		.talk Chronos##14833
		..accept Putting the Carnies Back Together Again##29512
		|only if skill("First Aid")>74
	step
		goto Darkmoon Island,55.0,70.8
		.talk Chronos##14833
		..accept Tan My Hide##29519
		|only if skill("Skinning")>74
	step
		goto Darkmoon Island,55.0,70.8
		.talk Chronos##14833
		..accept Herbs for Healing##29514
		|only if skill("Herbalism")>74
	step
		goto 50.5,69.6
		.talk Sylannia##14844
		..accept A Fizzy Fusion##29506
		|only if skill("Alchemy")>74
	step
		goto 55.0,70.8
		.talk Chronos##14833
		..accept Keeping the Faire Sparkling##29516
		|only if skill("Jewelcrafting")>74
	step
		goto Darkmoon Island,53.2,75.8
		.talk Sayge##14822
		..accept Putting Trash to Good Use##29510
		|only if skill("Enchanting")>74
	step
		goto Darkmoon Island,51.1,82.0
		.talk Yebb Neblegear##14829
		..accept Baby Needs Two Pair of Shoes##29508
		|only if skill("Blacksmithing")>74
	step
		goto 52.5,88.7
		.buy Fishing Pole##6256
		|only if skill("Fishing")>74
	step
		goto Darkmoon Island,51.7,91.6
		.' Equip your Fishing Pole |equipped Fishing Pole##6256 |use Fishing Pole##6256 |q 29513
		.' Use your Fishing ability to catch _Sea Herrings_ |cast Fishing##7620
		.' Catch 5 Great Sea Herring |q 29513/1
		|only if skill("Fishing")>74
	step
		goto Darkmoon Island,47.9,74.5
		.' Use your Darkmoon Bandage on Injured Carnies |use Darkmoon Bandage##71978
		.' Heal 4 Injured Carnies |q 29512/1
		'|modelnpc 54518
		|only if skill("First Aid")>74
	step
		'All around the Island
		.' Click Discarded Weapons
		.collect 6 Discarded Weapon##72018 |n
		.' Disenchant the Discarded Weapons |use Discarded Weapon##72018
		.' Collect 6 Soothsayer's Dust |q 29510/1
		|modeldisplay Discarded Weapon##10777
		|only if skill("Enchanting")>74
	step
		'All around the Island
		.click Tonk Scrap##6314
		.' Collect 6 pieces of Tonk Scrap |q 29518/1
		|only if skill("Mining")>74
		'|model 7975
	step
		'All around the Island
		.click Bits of Glass##238
		.collect 5 Bits of Glass##72052 |n
		.' Click the Bits of Glass in your bags |use Bit of Glass##72052
		.' Make 5 Sparkling Gemstones |q 29516/1
		|only if skill("Jewelcrafting")>74
	step
		.' All around the Island
		.' Use your Battered Wrench to repair Damaged Tonk's |use Battered Wrench##72110
		.' Repair 5 Damaged Tonk's |q 29511/1
		'|modelnpc 54504
		|only if skill("Engineering")>74
	step
		.' All around the Island
		.click Darkblossom##209284
		.' Gather 6 Darkblossom |q 29514/1
		|only if skill("Herbalism")>74
	step
		.' All around the Island
		.' Click Staked Skins
		.' Scrape 4 Staked Skins |q 29519/1
		|modeldisplay Staked Skins##10750
	step
		goto 50.5,69.6
		.talk Sylannia##14844
		.buy 5 Fizzy Faire Drink##19299 |q 29506
		|only if skill("Alchemy")>74
	step
		goto Darkmoon Island,50.4,69.5
		.' Use the Cocktail Shaker in your bags to make Moonberry Fizz |use Cocktail Shaker##72043
		.' Create 5 Sevings of Moonberry Fizz |q 29506/1
		|only if skill("Alchemy")>74
	step
		goto Darkmoon Island 50.0,66.2
		.' Use the Darkmoon Banner Kit in your bags to plant a banner here. |use Darkmoon Banner Kit##72048
		.' Plant a Darkmoon Banner |q 29520/1
	step
		goto Darkmoon Island,52.7,68.1
		.' Click the Plump Frogs in your bags |use Plump Frogs##72056
		.collect 5 Breaded Frog##72057 |n
		.' Throw the Breaded Frogs in the cauldron |use Breaded Frog##72057
		.' Fry 5 Crunchy Frogs |q 29509/1
		|only if skill("Cooking")>74
	step
		goto 55.3,71.7
		.' Use the Iron Stock in your bags to make Horseshoes |use Iron Stock##71964
		.collect 4 Horseshoes##71967 |q 29508
		|only if skill("Blacksmithing")>74
	step
		.' Use the Bundle of Exotic Herbs in your bags to create Prophetic Ink |use Bundle of Exotic Herbs##71971
		.collect Prophetic Ink##71972 |n
		.' Use Prophetic Ink to create Fortunes |use Prophetic Ink##71972 |tip Each one requires 1 Light Parchment to create.
		.get 5 Fortune##71974+ |q 29515/1
		|only if skill("Inscription")>74
	step
		'Use the _Darkmoon Craftsman's Kit_ in your bags to create Darkmoon Prizes |use Darkmoon Craftsman's Kit##71977
		.collect 5 Darkmoon Prize##71976 |q 29517/1
		|only if skill("Leatherworking")>74
	step
		goto Darkmoon Island,52.9,68.0
		.talk Stamp Thunderhorn##14845
		..turnin Putting the Crunch in the Frog##29509
		|only if skill("Cooking")>74
	step
		goto Darkmoon Island,52.9,68.0
		.talk Stamp Thunderhorn##14845		
		..turnin Spoilin' for Salty Sea Dogs##29513
		|only if skill("Fishing")>74
	step
		goto Darkmoon Island 53.2,75.8
		.talk Sayge##14822
		..turnin Writing the Future##29515
		|only if skill("Inscription")>74
	step
		goto Darkmoon Island,55.0,70.8
		.talk Chronos##14833
		..turnin Putting the Carnies Back Together Again##29512
		|only if skill("First Aid")>74
	step
		goto Darkmoon Island,55.0,70.8
		.talk Chronos##14833
		..turnin Tan My Hide##29519
		|only if skill("Skinning")>74
	step
		goto 55.0,70.8
		.talk Chronos##14833
		..turnin Keeping the Faire Sparkling##29516
		|only if skill("Jewelcrafting")>74
	step
		goto 49.3,60.9
		.talk Rinling##14841
		..turnin Eyes on the Prizes##29517
		|only if skill("Leatherworking")>74
	step
		goto Darkmoon Island,49.3,60.8
		.talk Rinling##14841
		..turnin Talkin' Tonks##29511
		|only if skill("Engineering")>74
	step
		goto Darkmoon Island,55.0,70.8
		.talk Chronos##14833
		..turnin Herbs for Healing##29514
		|only if skill("Herbalism")>74
	step
		goto 50.5,69.6
		.talk Sylannia##14844
		..turnin A Fizzy Fusion##29506
		|only if skill("Alchemy")>74
	step
		goto Darkmoon Island 55.4,54.8
		.talk Selina Dourman##10445
		..turnin Banners, Banners Everywhere!##29520
		|only if skill("Tailoring")>74
	step
		goto Darkmoon Island,49.3,60.7
		.talk Rinling##14841
		..turnin Rearm, Reuse, Recycle##29518
		|only if skill("Mining")>74
	step
		goto Darkmoon Island,53.2,75.8
		.talk Sayge##14822
		..turnin Putting Trash to Good Use##29510
		|only if skill("Enchanting")>74
	step
		goto Darkmoon Island,51.3,81.8
		.' Use the Horshoes in your bag on Baby|use Horseshoe##71967
		.' Put New Horshoes On Baby |q 29508/1
		|only if skill("Blacksmithing")>74
		'|modelnpc 54510
	step
		goto Darkmoon Island,51.1,82.0
		.talk Yebb Neblegear##14829
		..turnin Baby Needs Two Pair of Shoes##29508
		|only if skill("Blacksmithing")>74
]])

ZygorGuidesViewer:RegisterInclude("H_Darkmoon_Faire_Achievements",[[
	step
	label	"main"
		'To earn Achievements for the Darkmoon Faire, you will need to complete Dailies, Quests and other things. 
		.' Click here to do the Dailies Achievments |confirm always |next "dailies" |or
		.' or
		.' Click here to do the Profession Quests Achievements |confirm always |next "professions" |or
		.' or
		.' Click here for the Non-Questing Achievements |confirm always |next "no_quest" |or
	step
	label	"dailies"
		'You have earned the Achievement Bullseye! |achieve 6021 |only if achieved(6021)
		.' You still need to earn the Achievement Bullseye! |achieve 6021 |only if not achieved(6021)
		.' You have earned the Achievement Quick Shot! |achieve 6022 |only if achieved(6022)
		.' You still need to earn the Achievement Quick Shot! |achieve 6022 |only if not achieved(6022)
		.' You have earned the Achievement Step Right Up! |achieve 6020 |only if achieved(6020)
		.' You still need to earn the Achievement Step Right Up! |achieve 6020 |only if not achieved(6020)
		|confirm always
	step
		goto Darkmoon Island,54.3,53.1
		.talk Zina Sharpworth##55266
		.buy Sack o' Tokens##78909 |n
		.' Open your Sack o' Tokens in your bags |use Sack o' Tokens##78909
		.collect 20 Darkmoon Faire Game Tokens##71083
	step
		goto Darkmoon Island,53.3,54.4
		.talk Mola##54601
		..accept It's Hammer Time##29463
	step
		goto Darkmoon Island,53.3,54.4
		.talk Mola##54601
		.' Tell her:
		.' <Ready to whack!> |havebuff Interface\Icons\inv_hammer_32
	step
		.' Use the _Whack!_ on your bar and whack the Gnolls in the Barrels
		.' The Gnolls  will pop up in the Barrels, but be careful not to hit the _Doll_ or you will get stunned.
		.' Whack 30 Gnolls |q 29463/1
	step
		goto Darkmoon Island,53.3,54.4
		.talk Mola##54601
		..turnin It's Hammer Time##29463
	step
		goto Darkmoon Island,52.5,56.2
		.talk Maxima Blastenheimer##15303
		..accept The Humanoid Cannonball##29436
		|next "quest"
	step
	label	"target"
		goto Darkmoon Island,57.1,89.6
		.talk Teleportologist Fozlebub##57850
		.' Tell him:
		.' <Teleport me to the cannon.> |goto 52.7,56.0,1 |noway |c
	step
	label	"quest"
		goto Darkmoon Island,52.5,56.2
		.talk Maxima Blastenheimer##15303
		.' Tell her:
		.' <Launch me!>
		'Wait for the Cannon to Launch you |havebuff Interface\Icons\Spell_Magic_FeatherFall
	step
		goto Darkmoon Island,56.4,93.3
		.' You will be launched throught the air. 
		.' You the __ to drop in the water in the target. You will gain more points for getting closer to the middle.
		.' Earn 5 Target Points |q 29436/1
		.' Score a Bullseye by landing in the middle of the target
		.' Earn the Achievement Bullseye! |achieve 6021
		.' Click here to try again |confirm |next "target"
	step
		goto Darkmoon Island,57.1,89.6
		.talk Teleportologist Fozlebub##57850
		.' Tell him:
		.' <Teleport me to the cannon.> |goto 52.7,56.0,1 |noway |c
	step
		goto Darkmoon Island,52.5,56.2
		.talk Maxima Blastenheimer##15303
		..turnin The Humanoid Cannonball##29436
	step
		goto 49.3,60.8
		.talk Rinling##14841
		..accept He Shoots, He Scores!##29438
	step
		goto 49.3,60.8
		.talk Rinling##14841	
		.' Tell him:
		.' <Let's shoot!> |havebuff Interface\Icons\INV_Weapon_Rifle_05
	step
		'Shoot at the 3 targets. 
		.' When you see a green marker appear over a target, make sure that you are aimed at it and _shoot_ |tip To aim, simply move the camera to face your current target.
		.' Shoot 25 Targets |q 29438/1
		.' Shoot your gunt and hit a target very fast
		.' Earn the Achievement Quick Shot! |achieve 6022
	step
		goto 49.3,60.8
		.talk Rinling##14841
		..turnin He Shoots, He Scores!##29438
	step
		goto Darkmoon Island,50.7,65.1
		.talk Finlay Coolshot##54605
		..accept Tonk Commander##29434
	step
		goto Darkmoon Island,50.7,65.1
		.talk Finlay Coolshot##54605
		.' Tell him:
		.' <Ready to Play.> |invehicle |c
	step
		'Use your _Cannon_ ability to shoot _Tonk Targets_.
		.from Tonk Target##33081+
		.' Destroy 30 Tonk Targets |q 29434/1
	step
		goto Darkmoon Island,50.7,65.1
		.talk Finlay Coolshot##54605
		..turnin Tonk Commander##29434
	step
		goto 51.6,77.8
		.talk Jessica Rogers##54485
		..accept Target: Turtle##29455
	step
		goto 51.6,77.8
		.talk Jessica Rogers##54485
		.' Tell her: 
		.' <Ready to play!> |havebuff Interface\Icons\INV_Jewelry_Ring_03
	step
		'Use your _Ring Toss_ ability to throw rings on the turtle.  |tip When aiming, move the marker over the middle of the turtle.
		.' Land 3 Rings on Dubenko |q 29455/1
		.' Earn the Achievement Step Right Up! |achieve 6020
		'|modelnpc 54490
	step
		goto 51.6,77.8
		.talk Jessica Rogers##54485
		..turnin Target: Turtle##29455
		|next "main"
	step
	label	"professions"
		'You have earned the Achievement Faire Favors |achieve 6032 |only if achieved(6032)
		.' You still need to earn the Achievement Faire Favors |achieve 6032 |only if not achieved(6032)
		.' You have earned the Achievement Darkmoon Dungeoneer |achieve 6027 |only if achieved(6027)
		.' You still need to earn the Achievement Darkmoon Dungeoneer |achieve 6027 |only if not achieved(6027)
		.' You have earned the Achievement Darkmoon Defender |achieve 6028 |only if achieved(6028)
		.' You still need to earn the Achievement Darkmoon Defender |achieve 6028 |only if not achieved(6028)
		.' You have earned the Achievement Darkmoon Despoiler |achieve 6029 |only if achieved(6029)
		.' You still need to earn the Achievement Darkmoon Despoiler |achieve 6029 |only if not achieved(6029)   
		|confirm always
	step
		goto Darkmoon Island 55.4,54.8
		.talk Selina Dourman##10445
		..accept Banners, Banners Everywhere!##29520
		|only if skill("Tailoring")>74
	step
		goto Darkmoon Island,51.9,60.9
		.talk Professor Thaddeus Paleo##14847
		..accept Fun for the Little Ones##29507
		|only if skill("Archaeology")>74
	step
		goto Darkmoon Island,49.3,60.8
		.talk Rinling##14841
		..accept Talkin' Tonks##29511
		|only if skill("Engineering")>74
	step
		goto Darkmoon Island,49.3,60.7
		.talk Rinling##14841
		..accept Rearm, Reuse, Recycle##29518
		|only if skill("Mining")>74
	step
		goto 49.3,60.9
		.talk Rinling##14841
		..accept Eyes on the Prizes##29517
		|only if skill("Leatherworking")>74
	step
		goto Darkmoon Island,52.9,68.0
		.talk Stamp Thunderhorn##14845
		..accept Putting the Crunch in the Frog##29509
		|only if skill("Cooking")>74
	step
		goto Darkmoon Island,52.9,68.0
		.talk Stamp Thunderhorn##14845		
		..accept Spoilin' for Salty Sea Dogs##29513
		|only if skill("Fishing")>74
	step
		goto Darkmoon Island,55.0,70.8
		.talk Chronos##14833
		..accept Putting the Carnies Back Together Again##29512
		|only if skill("First Aid")>74
	step
		goto Darkmoon Island,55.0,70.8
		.talk Chronos##14833
		..accept Tan My Hide##29519
		|only if skill("Skinning")>74
	step
		goto Darkmoon Island,55.0,70.8
		.talk Chronos##14833
		..accept Herbs for Healing##29514
		|only if skill("Herbalism")>74
	step
		goto 50.5,69.6
		.talk Sylannia##14844
		..accept A Fizzy Fusion##29506
		|only if skill("Alchemy")>74
	step
		goto 55.0,70.8
		.talk Chronos##14833
		..accept Keeping the Faire Sparkling##29516
		|only if skill("Jewelcrafting")>74
	step
		goto Darkmoon Island,53.2,75.8
		.talk Sayge##14822
		..accept Putting Trash to Good Use##29510
		|only if skill("Enchanting")>74
	step
		goto Darkmoon Island,51.1,82.0
		.talk Yebb Neblegear##14829
		..accept Baby Needs Two Pair of Shoes##29508
		|only if skill("Blacksmithing")>74
	step
		goto 52.5,88.7
		.buy Fishing Pole##6256
		|only if skill("Fishing")>74
	step
		goto Darkmoon Island,51.7,91.6
		.' Equip your Fishing Pole |equipped Fishing Pole##6256 |use Fishing Pole##6256 |q 29513
		.' Use your Fishing ability to catch _Sea Herrings_ |cast Fishing##7620
		.' Catch 5 Great Sea Herring |q 29513/1
		|only if skill("Fishing")>74
	step
		goto Darkmoon Island,47.9,74.5
		.' Use your Darkmoon Bandage on Injured Carnies |use Darkmoon Bandage##71978
		.' Heal 4 Injured Carnies |q 29512/1
		'|modelnpc 54518
		|only if skill("First Aid")>74
	step
		'All around the Island
		.click Discarded Weapon##10777+
		.collect 6 Discarded Weapon##72018 |n
		.' Disenchant the Discarded Weapons |use Discarded Weapon##72018
		.' Collect 6 Soothsayer's Dust |q 29510/1
		|only if skill("Enchanting")>74
	step
		'All around the Island
		.click Tonk Scrap##6314
		.' Collect 6 pieces of Tonk Scrap |q 29518/1
		|only if skill("Mining")>74
		'|model 7975
	step
		'All around the Island
		.click Bits of Glass##238
		.collect 5 Bits of Glass##72052 |n
		.' Click the Bits of Glass in your bags |use Bit of Glass##72052
		.' Make 5 Sparkling Gemstones |q 29516/1
		|only if skill("Jewelcrafting")>74
	step
		.' All around the Island
		.' Use your Battered Wrench to repair Damaged Tonk's |use Battered Wrench##72110
		.' Repair 5 Damaged Tonk's |q 29511/1
		'|modelnpc 54504
		|only if skill("Engineering")>74
	step
		.' All around the Island
		.click Darkblossom##209284
		.' Gather 6 Darkblossom |q 29514/1
		|only if skill("Herbalism")>74
	step
		.' All around the Island
		.click Staked Skins##10750
		.' Scrape 4 Staked Skins |q 29519/1
	step
		goto 50.5,69.6
		.talk Sylannia##14844
		.buy 5 Fizzy Faire Drink##19299 |q 29506
		|only if skill("Alchemy")>74
	step
		goto Darkmoon Island,50.5,90.8
		.click Portal to Mulgore##4397
		.' Teleport to Mulgore |goto Mulgore |noway |c
		|only if skill("Cooking")>74 or skill("Alchemy")>74 or skill("Archaeology")>74
	step
		'Open your world map, find dig sites in Kalimdor and go to them |tip They look like small shovel icons on your world map that spawn in random places.  Once you get to the zone where the dig site is located, you will see the dig site on your map as a red highlighted area.
		.' You can find _Fossil Fragments_ in these locations: 
		.' Desolace
		.' Dustwallow Marsh
		.' Stonetalon Mountains
		.' Southern Barrens
		.' Tanaris
		.' Un'Goro Crater
		.' Use your Survey ability inside the dig site area and follow the Telesope until you find a fragment |cast Survey##80451
		.earn 15 Fossil Fragments##393 |q 29507
		|only if skill("Archaeology")>74
	step
		goto Darkmoon Island,50.5,90.8
		.click Portal to Mulgore##4397
		.' Teleport to Mulgore |goto Mulgore |noway |c
		|only if skill("Alchemy")>74
	step
		goto Mulgore,46.8,60.4
		.talk Innkeeper Kauth##6747
		.buy 5 Moonberry Juice##1645 |q 29506
		|only if skill("Alchemy")>74
	step
		goto Thunder Bluff 40.6,62.6
		.talk Shadi Mistrunner##8363
		.buy 5 Simple Flour##30817 |q 29509
		|only if skill("Cooking")>74
	step
		goto Thunder Bluff 43.8,44.6
		.talk Mahu##3005
		.buy 1 Coarse Thread##2320
		.buy 1 Blue Dye##6260
		.buy 1 Red Dye##2604
		|only if skill("Tailoring")>74
	step
		goto Mulgore,36.8,35.8
		.click Portal to Darkmoon Island
		.' Telport to Darkmoon Island |goto Darkmoon Island |noway |c
		|only if skill("Cooking")>74 or skill("Alchemy")>74 or skill("Archaeology")>74 or skill("Tailoring")>74
	step
		goto Darkmoon Island,56.0,52.9 |n
		.' Follow the Path to the Darkmoon Faire |goto Darkmoon Island,56.0,52.9,1 |noway |c
		|only if skill("Cooking")>74 or skill("Alchemy")>74 or skill("Archaeology")>74
	step
		goto Darkmoon Island,50.4,69.5
		.' Use the Cocktail Shaker in your bags to make Moonberry Fizz |use Cocktail Shaker##72043
		.' Create 5 Sevings of Moonberry Fizz |q 29506/1
		|only if skill("Alchemy")>74
	step
		goto Darkmoon Island 50.0,66.2
		.' Use the Darkmoon Banner Kit in your bags to plant a banner here. |use Darkmoon Banner Kit##72048
		.' Plant a Darkmoon Banner |q 29520/1
		|only if skill("Tailoring")>74
	step
		goto Darkmoon Island,52.7,68.1
		.' Click the Plump Frogs in your bags |use Plump Frogs##72056
		.collect 5 Breaded Frog##72057 |n
		.' Throw the Breaded Frogs in the cauldron |use Breaded Frog##72057
		.' Fry 5 Crunchy Frogs |q 29509/1
		|only if skill("Cooking")>74
	step
		goto 55.3,71.7
		.' Use the Iron Stock in your bags to make Horseshoes |use Iron Stock##71964
		.collect 4 Horseshoes##71967 |q 29508
		|only if skill("Blacksmithing")>74
	step
		goto Darkmoon Island,51.9,60.9
		.talk Professor Thaddeus Paleo##14847
		..turnin Fun for the Little Ones##29507
		|only if skill("Archaeology")>74
	step
		goto Darkmoon Island,52.9,68.0
		.talk Stamp Thunderhorn##14845
		..turnin Putting the Crunch in the Frog##29509
		|only if skill("Cooking")>74
	step
		goto Darkmoon Island,52.9,68.0
		.talk Stamp Thunderhorn##14845		
		..turnin Spoilin' for Salty Sea Dogs##29513
		|only if skill("Fishing")>74
	step
		goto Darkmoon Island,55.0,70.8
		.talk Chronos##14833
		..turnin Putting the Carnies Back Together Again##29512
		|only if skill("First Aid")>74
	step
		goto Darkmoon Island,55.0,70.8
		.talk Chronos##14833
		..turnin Tan My Hide##29519
		|only if skill("Skinning")>74
	step
		goto 55.0,70.8
		.talk Chronos##14833
		..turnin Keeping the Faire Sparkling##29516
		|only if skill("Jewelcrafting")>74
	step
		goto Darkmoon Island,49.3,60.8
		.talk Rinling##14841
		..turnin Talkin' Tonks##29511
		|only if skill("Engineering")>74
	step
		goto Darkmoon Island,55.0,70.8
		.talk Chronos##14833
		..turnin Herbs for Healing##29514
		|only if skill("Herbalism")>74
	step
		goto 50.5,69.6
		.talk Sylannia##14844
		..turnin A Fizzy Fusion##29506
		|only if skill("Alchemy")>74
	step
		goto Darkmoon Island 55.4,54.8
		.talk Selina Dourman##10445
		..turnin Banners, Banners Everywhere!##29520
		|only if skill("Tailoring")>74
	step
		goto Darkmoon Island,49.3,60.7
		.talk Rinling##14841
		..turnin Rearm, Reuse, Recycle##29518
		|only if skill("Mining")>74
	step
		goto Darkmoon Island,53.2,75.8
		.talk Sayge##14822
		..turnin Putting Trash to Good Use##29510
		|only if skill("Enchanting")>74
	step
		goto Darkmoon Island,51.3,81.8
		.' Use the Horshoes in your bag on Baby|use Horseshoe##71967
		.' Put New Horshoes On Baby |q 29508/1
		|only if skill("Blacksmithing")>74
		'|modelnpc 54510
	step
		goto Darkmoon Island,51.1,82.0
		.talk Yebb Neblegear##14829
		..turnin Baby Needs Two Pair of Shoes##29508
		|only if skill("Blacksmithing")>74
	step
		goto Darkmoon Island,47.9,67.1
		.talk Kerri Hicks##14832
		..accept Test Your Strength##29433
	step
		goto Darkmoon Island,55.6,55.0
		.talk Selina Dourman##10445
		.' Tell her:
		.' <Darkmoon Adventurer's Guide?>
		.collect Darkmoon Adventurer's Guide##71634 |q 29433
	step
		'These next 3 items have to be _obtained from Battlegrounds_
		.' When you kill an opponent, _loot_ their body for a chance to get _each item_.
		.collect Adventurer's Journal##71953 |n
		.accept The Captured Journal##29458 |use Adventurer's Journal##71953
		.collect Banner of the Fallen##71951 |n
		.accept A Captured Banner##29456 |use Banner of the Fallen##71951
		.collect Captured Insignia##71952 |n
		.accept The Enemy's Insignia##29457 |use Captured Insignia##71952
	step
		'These next 5 items have to be _obtained from Dungeons_ listed below
		.collect Mysterious Grimoire##71637 |n |tip You can get this in Heroic Scholomance from Darkmaster Gandling
		..accept An Inriguing Grimoire##29445 |use Mysterious Grimoire##71637
		.collect Monstrous Egg##71636 |n |tip You can get this in Stormstout Brewery from Hoptallus
		..accept An Exotic Egg##29444 |use Monstrous Egg##71636
		.collect A Treatise on Strategy##7175 |n |tip You can get this in Stormstout Brewery from Hoptallus
		..accept The Master Strategist##29451 |use A Treatise on Strategy##7175
		.collect Ornate Weapon##71638 |n |tip You can get this in Heroic Scarlet Monastery from Brother Korloff
		..accept A Wondrous Weapon##29446 |use Ornate Weapon##71638
		.collect Imbued Crystal##71635 |n |tip You can get this in Heroic Scarlet Monastery from High Inquisitor Whitemane
		..accept A Curious Crystal##29443 |use Imbued Crystal##71635
	step
		'The next item can only be obtained from any 10 man Cataclysm Raid Boss
		.collect Soothsayer's Runes##71716 |n
		..accept Tools of Divination##29464 |use Soothsayer's Runes##71716
	step
		.' Kill any Creature Player or NPC that gives _experience or honor_ to gain Grisly Trophies |tip You need to leave Darkmoon Island to find anything to kill.
		.' Collect 250 Grisly Trophy's |q 29433/1
	step
		goto Darkmoon Island,47.9,67.1
		.talk Kerri Hicks##14832
		..turnin Test Your Strength##29433
	step
		goto Darkmoon Island 51.9,60.9
		.talk Professor Thaddeus Paleo##14847
		..turnin The Captured Journal##29458
		..turnin A Captured Banner##29456
		..turnin The Enemy's Insignia##29457
		..turnin The Master Strategist##29451
		..turnin A Wondrous Weapon##29446
		..turnin A Curious Crystal##29443
		..turnin Tools of Divination##29464
	step
		goto Darkmoon Island 51.0,81.2
		.talk Yebb Neblegear##14829
		..turnin An Exotic Egg##29444
	step
		goto Darkmoon Island 53.6,76.0
		.talk Sayge##14822
		..turnin An Intriguing Grimoire##29445
		.' Earn the Achievement Darkmoon Dungeoneer |achieve 6027
		.' Earn the Achievement Darkmoon Defender |achieve 6028
		.' Earn the Achievement Darkmoon Despoiler |achieve 6029
		|next "main"
	step
	label	"no_quest"
		'You have earned the Achievement Darkmoon Duelist! |achieve 6023 |only if achieved(6023)
		.' You still need to earn the Achievement Darkmoon Duelist! |achieve 6023 |only if not achieved(6023)
		'You have earned the Achievement Fairegoer's Feast! |achieve 6026 |only if achieved(6026)
		.' You still need to earn the Achievement Fairegoer's Feast! |achieve 6026 |only if not achieved(6026)
		'You have earned the Achievement Taking the Show on the Road! |achieve 6031 |only if achieved(6031)
		.' You still need to earn the Taking the Show on the Road! |achieve 6031 |only if not achieved(6031)
		'You have earned the Achievement I Was Promised a Pony! |achieve 6025 |only if achieved(6025)
		.' You still need to earn the I Was Promised a Pony! |achieve 6025 |only if not achieved(6025)    
		|confirm always
	step
		goto Darkmoon Island,50.5,69.5
		.talk Sylannia##14844
		.buy Cheap Beer##19222 |n
		.' Drink Cheap Beer |achieve 6026/12 |use Cheap Beer##19222
		.buy Darkmoon Special Reserve##19221 |n
		.' Drink Darkmoon Special Reserve |achieve 6026/13 |use Special Reserve##19221
		.buy Fizzy Faire Drink##19299 |n
		.' Drink Fizzy Faire Drink |achieve 6026/14 |use Fizzy Faire Drink##19299
		.buy Bottled Winterspring Water##19300 |n
		.' Drink Bottled Winterspring Water |achieve 6026/11 |use Bottled Winterspring Water##19300
		.buy Iced Berry Slush##33234 |n
		.' Drink Iced Berry Slush |achieve 6026/17 |use Iced Berry Slush##33234
		.buy Fizzy Faire Drink "Classic"##33236 |n
		.' Drink Fizzy Faire Drink "Classic" |achieve 6026/15 |use Fizzy Faire Drink "Classic"##33236
		.buy Fresh-Squeezed Limeade##44941 |n
		.' Drink Fresh-Squeezed Limeade |achieve 6026/16 |use Fresh-Squeezed Limeade##44941
		.buy Sasparilla Sinker##74822 |n
		.' Drink Sasparilla Sinker |achieve 6026/18 |use Sasparilla Sinker##74822
	step
		goto Darkmoon Island,52.8,68.0
		.talk Stamp Thunderhorn##14845
		.buy Darkmoon Dog##19223 |n
		.' Eat Darkmoon Dog |achieve 6026/3 |use Darkmoon Dog##19223
		.buy Spiced Beef Jerky##19304 |n
		.' Eat Spiced Beef Jerky |achieve 6026/10 |use Spiced Beef Jerky##19304
		.buy Pickled Kodo Foot##19305 |n
		.' Eat Pickled Kodo Foot |achieve 6026/7 |use Pickled Kodo Foot##19305
		.buy Red Hot Wings##19224 |n
		.' Eat Red Hot Wings |achieve 6026/8 |use Red Hot Wings##19224
		.buy Crunchy Frog##19306 |n
		.' Eat Crunchy Frog |achieve 6026/2 |use Crunchy Frog##19306
		.buy Deep Fried Candybar##19225 |n
		.' Eat Deep Fried Candybar |achieve 6026/4 |use Deep Fried Candybar##19225
		.buy Funnel Cake##33246 |n
		.' Eat Funnel Cake |achieve 6026/6 |use Funnel Cake##33246 
		.buy Forest Strider Drumstick##33254 |n
		.' Eat Forest Strider Drumstick |achieve 6026/5 |use Forest Strider Drumstick##33254
		.buy Corn-Breaded Sausage##44940 |n
		.' Eat Corn-Breaded Sausage |achieve 6026/1 |use Corn-Breaded Sausage##44940
		.buy Salty Sea Dog##73260 |n
		.' Eat Salty Sea Dog |achieve 6026/9 |use Salty Sea Dog##73260
		.' Earn the Achievement Fairegoer's Feast |achieve 6026
	step
		goto Darkmoon Island,56.8,81.4
		.clicknpc Darkmoon Pony##55715
		.' Earn the Achievement I Was Promised a Pony |achieve 6025
	step
		goto Darkmoon Island,48.4,71.9
		.talk Boomie Sparks##55278
		.buy 6 Darkmoon Firework##74142 |future |achieve 6031
	step
		goto Darkmoon Island,50.5,90.8
		.click Portal to Mulgore##4397
		.' Teleport to Mulgore |goto Mulgore |noway |c
	step
		goto Thunder Bluff,32.2,67.0
		.' Use your Darkmoon Firework |achieve 6031/5 |use Darkmoon Firework##74142
	step
		goto Orgrimmar,49.2,59.3
		.' Use your Darkmoon Firework |achieve 6031/2 |use Darkmoon Firework##74142
	step
		goto Undercity,66.3,2.2
		.' Use your Darkmoon Firework |achieve 6031/6 |use Darkmoon Firework##74142
	step
		goto Silvermoon City,50.7,16.4
		.' Use your Darkmoon Firework |achieve 6031/4 |use Darkmoon Firework##74142	
	step
		goto Tirisfal Glades,59.1,59.0 |n
		.' Ride the Zeplin to Howling Fjord |goto Howling Fjord |noway |c
	step
		goto Dalaran,72.5,45.5
		.' Use your Darkmoon Firework |achieve 6031/1 |use Darkmoon Firework##74142
	step
		goto Dalaran,55.4,25.5
		.click Dalaran Portal to Orgrimmar##04395
		.' Teleport to Orgrimmar |goto Orgrimmar/2 |noway |c
	step
		goto Shattrath City,63.8,41.7
		.' Use your Darkmoon Firework |achieve 6031/3 |use Darkmoon Firework##74142
		.' Earn the Achievement Taking the Show on the Road! |achieve 6031
	step
		goto Darkmoon Island,56.0,52.9 |n
		.' Follow the Path to the Darkmoon Faire |goto Darkmoon Island,56.0,52.9,1 |noway |c
	step
		goto Darkmoon Island,46.8,78.8
		.' Click Darkmoon Deathmatch Gate and enter the Deathmatch Arena
		.' Once inside, you will need to fight anyone inside, if you win, you will earn an achievement.
		.' Earn the Achievement Darkmoon Duelist! |achieve 6023
		.' Deafeat 12 combatants in the Deathmatch Arena
		.' Earn the Achievement Darkmoon Dominator |achieve 6024
]])

-- Lunar Festival --
ZygorGuidesViewer:RegisterInclude("H_Lunar_Festival_Quests",[[
	step
		goto Orgrimmar,49.9,81.2
		.talk Lunar Festival Herald##15891
		..accept The Lunar Festival##8873
	step
		goto 52.4,58.5
		.talk Lunar Festival Harbinger##15895
		..turnin The Lunar Festival##8873
		..accept Lunar Fireworks##8867
	step
		goto 52.9,56.3
		.talk Lunar Festival Vendor##47897
		.buy 8 Small Blue Rocket##21558 |q 8867
		.buy 2 Blue Rocket Cluster##21571 |q 8867
	step
		goto 52.4,57.5
		.' Use Small Blue Rockets|use Small Blue Rocket##21558
		.' Use Blue Rocket Clusters|use Blue Rocket Cluster##21571
		.' Fire 8 Lunar Fireworks|q 8867/1
		.' Fire 2 Lunar Fireworks Clusters|q 8867/2
	step
		goto 52.4,58.5
		.talk Lunar Festival Harbinger##15895
		..turnin Lunar Fireworks##8867
		..accept Valadar Starsong##8883
	step
		goto 52.4,57.4
		.' Use the Lunar Festival Invitation while standing in the beam of light |use Lunar Festival Invitation##21711
		.' Go to Moonglade |goto Moonglade |c |q 8883
	step
		goto Moonglade,53.6,35.3
		.talk Valadar Starsong##15864
		..turnin Valadar Starsong##8883
]])
ZygorGuidesViewer:RegisterInclude("H_Lunar_Festival_Elders",[[
	step
		goto Silverpine Forest,45.0,41.1
		.talk Elder Obsidian##15561
		..accept Obsidian the Elder##8645 |instant
	step
		goto Tirisfal Glades,61.9,53.9
		.talk Elder Graveborn##15568
		..accept Graveborn the Elder##8652 |instant
	step
		goto Undercity,66.6,38.2
		.talk Elder Darkcore##15564
		..accept Darkcore the Elder##8648 |instant
	step
		goto Western Plaguelands,69.0,73.0
		.talk Elder Moonstrike##15594
		..accept Moonstrike the Elder##8714 |instant
	step
		goto 64.8,38.7 |n
		.' Enter this cave |goto 64.8,38.7,0.5 |noway |c
	step
		goto 63.5,36.1
		.talk Elder Meadowrun##15602
		..accept Meadowrun the Elder##8722 |instant
	step
		goto Eastern Plaguelands,35.6,68.8
		.talk Elder Windrun##15592
		..accept Windrun the Elder##8688 |instant
	step
		goto 27.7,11.7|n
		.' Enter the swirling portal to Stratholme. |goto Stratholme |noway|c
	step
		goto Stratholme/1 78.8,21.9
		.talk Elder Farwhisper##15607
		..accept Farwhisper the Elder##8727
	step
		goto Stratholme,68.8,88.6 |n
		.' Leave Stratholme. |goto Eastern Plaguelands|noway|c
	step
		goto 75.7,54.6
		.talk Elder Snowcrown##15566
		..accept Snowcrown the Elder##8650 |instant
	step
		goto The Hinterlands,50.0,48.0
		.talk Elder Highpeak##15559
		.accept Highpeak the Elder##8643 |instant
	step
		goto Loch Modan,33.3,46.5
		.talk Elder Silvervein##15558
		..accept Silvervein the Elder##8642 |instant
	step
		goto Ironforge,28.1,17.0
		.talk Elder Bronzebeard##15871
		..accept Bronzebeard the Elder##8866 |instant |tip If you die trying to leave Ironforge, just resurrect at the spirit healer you get sent to.
	step
		goto Dun Morogh,53.9,49.9
		.talk Elder Goldwell##15569
		..accept Goldwell the Elder##8653 |instant
	step
		goto Searing Gorge,21.3,79.1
		.talk Elder Ironband##15567
		..accept Ironband the Elder##8651 |instant
	step
		.' Enter Blackrock Mountain. |goto Searing Gorge,34.8,85.1 |c
	step
		goto Blackrock Spire/3 62.0,40.0
		.talk Elder Stonefort##15560
		..accept Stonefort the Elder##8644
	step
		map Blackrock Spire/3
		path follow loose;loop off;ants straight
		path 62.6,42.7		57.5,42.0	 54.6,37.5
		path 50.4,39.7
		.' Follow the ramp up to the Hall of Blackhand. |goto Blackrock Spire/4|noway|c
	step
		map Blackrock Spire/4
		path follow loose;loop off;ants straight
		path 40.9,45.4		37.5,48.0
		.' Jump off the ledge here. |goto Burning Steppes |noway|c
	step
		goto Burning Steppes,18.5,25.2
		.' Fly down to this point, or use the chains to traverse to here.
		|confirm
	step
		goto Searing Gorge 26.9,72.6 |n
		.' Enter Blackrock Depths here |goto Blackrock Depths |noway |c
	step
		map Blackrock Depths
		path follow loose;loop off;ants straight
		path 37.9,76.3		42.9,74.4	 47.8,72.4
		path 51.5,69.8		50.5,62.9
		.' Follow the path to _Elder Morndeep_.
		.talk Elder Morndeep##15549
		..accept Morndeep the Elder##8619
	step
		goto Burning Steppes/0 52.4,24.0
		.talk Elder Dawnstrider##15585
		..accept Dawnstrider the Elder##8683 |instant
	step
		goto 70.1,45.4
		.talk Elder Rumblerock##15557
		..accept Rumblerock the Elder##8636 |instant
	step
		goto Elwynn Forest,39.8,63.7
		.talk Elder Stormbrow##15565
		..accept Stormbrow the Elder##8649 |instant
	step
		goto 34.6,50.4
		.talk Elder Hammershout##15562
		..accept Hammershout the Elder##8646 |instant |tip If you die trying to leave Stormwind City, just resurrect at the spirit healer you get sent to.
	step
		goto Westfall,56.6,47.1
		.talk Elder Skychaser##15577
		..accept Skychaser the Elder##8675 |instant
	step
		goto Swamp of Sorrows,69.7,54.1
		.' Follow the steps down and go to the swirling portal at [76.1,45.2]
		.' Enter the Swirling Portal to The Temple of Atal'Hakkar|goto The Temple of Atal'Hakkar|noway|c
	step
		goto The Temple of Atal'Hakkar,62.9,34.4
		.talk Elder Starsong##15593
		..accept Starsong the Elder##8713
	step
		goto 50.0,14.5
		.' Leave the instance. |goto Swamp of Sorrows|noway|c
	step
		goto Blasted Lands,54.3,49.5
		.talk Elder Bellowrage##15563
		..accept Bellowrage the Elder##8647 |instant
	step
		goto Northern Stranglethorn,71.0,34.3
		.talk Elder Starglade##15596
		..accept Starglade the Elder##8716 |instant
	step
		goto The Cape of Stranglethorn,40.0,72.5
		.talk Elder Winterhoof##15576
		..accept Winterhoof the Elder##8674 |instant
// KALIMDOR
	step
		goto Northern Barrens,68.4,70.0
		.talk Elder Windtotem##15582
		..accept Windtotem the Elder##8680 |instant
	step
		goto 48.5,59.3
		.talk Elder Moonwarden##15597
		..accept Moonwarden the Elder##8717 |instant
	step
		goto Southern Barrens,41.5,47.5
		.talk Elder High Mountain##15588
		..accept High Mountain the Elder##8686 |instant
	step
		goto Mulgore,48.5,53.2
		.talk Elder Bloodhoof##15575
		..accept Bloodhoof the Elder##8673 |instant
	step
		goto Thunder Bluff,73.0,23.3
		.talk Elder Ezra Wheathoof##15580
		..accept Wheathoof the Elder##8678 |instant
	step
		goto Desolace,29.1,62.5 |n
		.' Enter the doorway to Maraudon. |goto Desolace,29.1,62.5 |noway|c
	step
		map Desolace
		path follow strict; loop off; ants straight
		path	28.3,63.0	27.9,64.3	27.6,62.9
		path	29.0,62.6	30.1,62.6	29.9,60.3
		.' Follow this path |goto Maraudon/2 |noway |c
	step
		map Maraudon/2
		path follow strict;loop off;ants straight
		path	29.4,46.0	32.0,60.3	35.5,57.5
		path	41.0,60.5	45.6,58.5	44.8,54.1
		path	43.0,57.6	41.5,63.9	45.6,67.2
		path	44.8,76.2	44.6,83.9	45.2,89.5
		path	51.5,93.8
		.talk Elder Splitrock##15556
		..accept Splitrock the Elder##8635
	step
		goto Feralas,76.7,37.9
		.talk Elder Grimtotem##15581
		..accept Grimtotem the Elder##8679 |instant
	step
		goto 62.6,31.1
		.talk Elder Mistwalker##15587
		..accept Mistwalker the Elder##8685 |instant
	step
		goto Silithus,53.0,35.5
		.talk Elder Bladesing##15599
		..accept Bladesing the Elder##8719 |instant
	step
		goto 30.8,13.3
		.talk Elder Primestone##15570
		..accept Primestone the Elder##8654 |instant
	step
		goto Un'Goro Crater,50.4,76.2
		.talk Elder Thunderhorn##15583
		..accept Thunderhorn the Elder##8681 |instant
	step
		goto Tanaris,37.2,79.1
		.talk Elder Ragetotem##15573
		..accept Ragetotem the Elder##8671 |instant
	step
		goto 51.4,28.8
		.talk Elder Dreamseer##15586
		..accept Dreamseer the Elder##8684 |instant
	step
		goto Zul'Farrak,34.5,39.4
		.talk Elder Wildmane##15578
		..accept Wildmane the Elder##8676
	step
		goto Thousand Needles,77.1,75.6
		.talk Elder Morningdew##15604
		..accept Morningdew the Elder##8724 |instant
	step
		goto 46.3,51.0
		.talk Elder Skyseer##15584
		..accept Skyseer the Elder##8682 |instant
	step
		goto Durotar,53.2,43.6
		.talk Elder Runetotem##15572
		..accept Runetotem the Elder##8670 |instant
	step
		goto Orgrimmar,52.3,60.0
		.talk Elder Darkhorn##15579
		..accept Darkhorn the Elder##8677 |instant
	step
		goto Azshara,64.7,79.3
		.talk Elder Skygleam##15600
		..accept Skygleam the Elder##8720 |instant
	step
		goto Winterspring,60.0,49.9
		.talk Elder Stonespire##15574
		..accept Stonespire the Elder##8672 |instant
	step
		goto 53.2,56.6
		.talk Elder Brightspear##15606
		..accept Brightspear the Elder##8726 |instant
	step
		goto Ashenvale,35.4,48.9
		.talk Elder Riversong##15605
		..accept Riversong the Elder##8725 |instant
	step
		goto Felwood,38.4,52.9
		.talk Elder Nightwind##15603
		..accept Nightwind the Elder##8723 |instant
	step
		goto Darkshore,49.5,18.9
		.talk Elder Starweave##15601
		..accept Starweave the Elder##8721 |instant
	step
		goto Teldrassil,56.9,53.1
		.talk Elder Bladeleaf##15595
		..accept Bladeleaf the Elder##8715 |instant
	step
		goto Darnassus,38.8,32.3
		.talk Elder Bladeswift##15598
		..accept Bladeswift the Elder##8718 |instant
	step
		goto Darnassus,38.0,30.5
		.' Use the Lunar Festival Invitation while standing in the beam of light |use Lunar Festival Invitation##21711
		.' Go to Moonglade |goto Moonglade |noway |c
// NORTHREND
	step
		goto Borean Tundra,42.9,49.6
		.talk Elder Pamuya##30371
		..accept Pamuya the Elder##13029 |instant
	step
		goto 33.8,34.4
		.talk Elder Northal##30360
		..accept Northal the Elder##13016 |instant
	step
		goto 59.1,65.6
		.talk Elder Sardis##30348
		..accept Sardis the Elder##13012 |instant
	step
		goto 57.4,43.7
		.talk Elder Arp##30364
		..accept Arp the Elder##13033 |instant
	step
		goto Sholazar Basin,49.8,63.6
		.talk Elder Sandrene##30362
		..accept Sandrene the Elder##13018 |instant
	step
		goto 63.8,49.0
		.talk Elder Wanikaya##30365
		..accept Wanikaya the Elder##13024 |instant
	step
		goto Wintergrasp 49.0,13.9
		.talk Elder Bluewolf##30368 |tip You can only get to this NPC when your faction controls Wintergrasp.
		..accept Bluewolf the Elder##13026 |instant
		.' If your faction does not control Wintergrasp, click here to continue. |confirm
	step
		goto Dragonblight,35.1,48.3
		.talk Elder Skywarden##30373
		..accept Skywarden the Elder##13031 |instant
	step
		goto 29.7,55.9
		.talk Elder Morthie##30358
		..accept Morthie the Elder##13014 |instant
	step
		goto 48.8,78.2
		.talk Elder Thoim##30363
		..accept Thoim the Elder##13019 |instant
	step
		goto Grizzly Hills,64.2,47.0
		.talk Elder Whurain##30372
		..accept Whurain the Elder##13030 |instant
	step
		goto 80.5,37.1
		.talk Elder Lunaro##30367
		..accept Lunaro the Elder##13025 |instant
	step
		goto 60.6,27.7
		.talk Elder Beldak##30357
		..accept Beldak the Elder##13013 |instant
	step
		goto Zul'Drak,58.9,56.0
		.talk Elder Tauros##30369
		..accept Tauros the Elder##13027 |instant
	step
		goto The Storm Peaks,41.2,84.7
		.talk Elder Graymane##30370
		..accept Graymane the Elder##13028 |instant
	step
		goto 28.9,73.7
		.talk Elder Fargal##30359
		..accept Fargal the Elder##13015 |instant
	step
		goto The Storm Peaks/0 30.6,37.0 |n
		.' Enter the building here. |goto The Storm Peaks/0 30.6,37.0 |noway |c
	step
		goto 31.3,37.6
		.talk Elder Stonebeard##30375
		..accept Stonebeard the Elder##13020 |instant
	step
		goto 64.6,51.3
		.talk Elder Muraco##30374
		..accept Muraco the Elder##13032 |instant

	step
		goto Mount Hyjal 62.5,22.8
		.talk Elder Evershade##55227
		..accept Evershade the Elder##29740 |instant
	step
		goto 26.7,62.0
		.talk Elder Windsong##55224
		..accept Windsong the Elder##29739 |instant
	step
		goto Deepholm 49.7,54.9
		.talk Elder Stonebrand##55217
		..accept Stonebrand the Elder##29735 |instant
	step
		goto 27.7,69.2
		.talk Elder Deepforge##55216
		..accept Deepforge the Elder##29734 |instant
	step
		#include "home_ValleyofHonor"
	step
		goto Shimmering Expanse 57.3,86.2
		.talk Elder Moonlance##55228
		..accept Moonlance the Elder##29738 |instant
	step
		goto Twilight Highlands,50.9,70.5
		.talk Elder Firebeard##55219
		..accept Firebeard the Elder##29737 |instant
	step
		goto Twilight Highlands 51.9,33.1
		.talk Elder Darkfeather##55218
		..accept Darkfeather the Elder##29736 |instant
	step
		goto Uldum 31.6,63.0
		.talk Elder Sekhemi##55210
		..accept Sekhemi the Elder##29741 |instant
	step
		goto 65.5,18.7
		.talk Elder Menkhaf##55211
		..accept Menkhaf the Elder##29742 |instant
	step
		goto The Nexus/1 55.5,64.9
		.talk Elder Igasho##30536
		..accept Igasho the Elder##13021
	step
		goto Dragonblight 26.0,50.9 |n
		.' Enter Azjol-Nerub here |goto Azjol-Nerub/3 |noway |c
	step
		goto Azjol-Nerub/3 72.6,30.9
		.' Follow this path down |goto Azjol-Nerub/2 |noway |c
	step
		goto Azjol-Nerub/2 51.1,61.8
		.' Jump down this hole into the water below |goto Azjol-Nerub |noway |c
	step
		goto 21.8,43.6
		.talk Elder Nurgen##30533
		..accept Nurgen the Elder##13022
	step
		goto Halls of Stone,29.4,62.1
		.talk Elder Yurauk##30535
		..accept Yurauk the Elder##13066
	step
		map Gundrak
		path loop off
		path	 59.1,49.2	58.2,68.5	50.9,73.6
		path	45.6,61.5
		.talk Elder Ohanzee##30537
		..accept Ohanzee the Elder##13065
	step
		goto Drak'Tharon Keep 68.9,79.1
		.talk Elder Kilias##30534
		..accept Kilias the Elder##13023 |instant
	step
		goto Howling Fjord 58.0,50.0 |n
		.' Enter the Utgarde Keep building here |goto Howling Fjord,58.0,50.0,0.5 |noway |c
	step
		goto Utgarde Keep/1 47.5,70.0
		.talk Elder Jarten##30531
		..accept Jarten the Elder##13017 |instant
	step
		goto Howling Fjord,57.3,46.7 |n
		.' Enter the swirling portal to Utgarde Pinnacle. |goto Utgarde Pinnacle/2 |noway|c
	step
		map Utgarde Pinnacle/2
		path loop off
		path 44.5,17.0		44.2,29.8	 38.5,35.9
		path 33.7,49.0		33.5,64.4	 35.5,69.1
		path 39.1,75.8
		.' Take the stairs down. |goto Utgarde Pinnacle |noway|c
	step
		map Utgarde Pinnacle
		path loop off
		path 35.9,77.9		36.2,86.9	 41.7,86.2
		path 46.1,81.9
		.' Go up the stairs. |goto Utgarde Pinnacle/2 |noway|c
	step
		map Utgarde Pinnacle/2
		path loop off
		path 54.0,77.0		51.8,76.2	51.8,81.4
		path 56.8,84.4		60.6,84.3	63.7,69.7
		path 68.3,68.4		 68.8,56.4	68.9,36.1
		.' Follow the path, clicking here to continue. |confirm
	step
		goto Utgarde Pinnacle,48.7,23.1 
		.talk Elder Chogan'gada##30538
		..accept Chogan'gada the Elder##13067
]])

ZygorGuidesViewer:RegisterInclude("H_Lunar_Festival_Achievements",[[
	step
		goto Orgrimmar 52.4,58.5
		.talk Lunar Festival Harbinger##15895
		.' <I'd like a new invitation to the Lunar Festival.>
		.collect Lunar Festival Invitation##21711
	step
		goto Orgrimmar 52.4,57.4
		.' Use the Lunar Festival Invitation while standing in the beam of light |use Lunar Festival Invitation##21711
		.' Go to Moonglade |goto Moonglade |c |q 8883
	step
		goto Moonglade,53.6,35.3
		.talk Valadar Starsong##15864
		..turnin Valadar Starsong##8883
	step
		 goto 36.6,58.1
		.talk Lunar Festival Vendor##15898
		.buy 10 Festival Firecracker##21747
		.buy 10 Red Rocket Cluster##21576
		.buy 36 Green Rocket Cluster##21574
	step
		goto 36.0,57.7
		.' Use the _Festival Firecrackers_ as fast as you can.
		.' You will need to use 10 in 30 seconds.
		.' You can drag the Festival Firecrackers onto your action bar. You will need to click the ground where you want to throw them.
		.use Festival Firecracker##21747
		.' Earn the _Frienzied Firecracker_ Achievement. |achieve 1552
	step
		goto 30.6,18.9
		.' Drag the _Red Rocket Clusters_ to you action bar.
		.' You will need to use 10 in 25 seconds.
		.' You will need to spam whatever button the Red Rocket Cluster is assigned to.
		.use Red Rocket Cluster##21576
		.' Earn _The Rockets Red Glare_ Achievement. |achieve 1281
	step
		goto 53.6,35.3
		.talk Valadar Starsong##15864
		..accept Elune's Blessing##8868
	step
		goto 63.7,62.4
		.' Use your Green Rocket Clusters until Omen spawns |use Green Rocket Cluster##21574
		.from Omen##15467 |tip You will need a group of 4 or 5 to beat him.
		.' Receive Elune's Blessing|q 8868/1
	step
		goto Moonglade 53.6,35.3
		.talk Valadar Starsong##15864
		..turnin Elune's Blessing##8868
	step
		goto 53.6,35.3
		.talk Valadar Starsong##15864 |tip You only need to buy one of these.
		.buy Festive Pink Dress##21538 |or
		.buy Festive Purple Dress##21539 |or
		.buy Festive Black Pant Suit##21541 |or
		.buy Festive Blue Pant Suit##21544 |or
		.buy Festive Teal Pant Suit##21543 |or
		.buy Festive Green Dress##21157 |or
		.' Earn the Achievment Lunar Festival Finery |achieve 626
	step
		Congratulations! You know how To Honor One's Elders!
]])
-- Love Is In The Air --
ZygorGuidesViewer:RegisterInclude("H_Love_Is_In_The_Air_Main_Questline",[[
	step
		goto Orgrimmar,50.8,75.2
		.talk Detective Snap Snagglebolt##37172
		..accept Something Stinks##24536
	step
		goto 51.9,76.3
		.' Use Snagglebolt's Air Analyzer on pink glowing Orgrimmar Grunts around this area |use Snagglebolt's Air Analyzer##50131
		.' Analyze 6 Perfumed Guards |q 24536/1
		'|talk Orgrimmar Grunt##3296
	step
		goto 50.8,75.2
		.talk Detective Snap Snagglebolt##37172
		..turnin Something Stinks##24536
		..accept Pilfering Perfume##24541
	step
		goto Durotar,47.7,11.8
		.' Get the Crown Chemical Co. Package |havebuff INV_Crate_03 |q 24541 |tip To get the package, run outside the gates of Orgrimmar and take an immediate left.  Keep close to the wall, you will eventually get to a small camp where two Undead NPCs are standing next to a pile of boxes.  Get close to them in order to get the package.
	step
		goto Orgrimmar,50.8,75.2
		.' Return the Crown Chemical Co. Package |tip Simply walk next to Detective Snap Snagglebolt to return the package to him. |condition ZGV.questsbyid[24541] and ZGV.questsbyid[24541].complete |q 24541
		.' If you lose your disguise, ask the Detective for another one and repeat the run.
	step
		goto Orgrimmar,50.8,75.2
		.' Return the Crown Chemical Co. Package |tip Simply walk next to Detective Snap Snagglebolt to return the package to him.
		.talk Detective Snap Snagglebolt##37172
		..turnin Pilfering Perfume##24541
		..accept Snivel's Sweetheart##24850
	step
		goto 57.6,60.8
		.talk Roka##38328
		..turnin Snivel's Sweetheart##24850
		..accept Hot On The Trail##24851
	step
		goto 53.8,73.5
		.' Search the Orgrimmar Auction House |q 24851/2
	step
		goto 48.7,83.6
		.' Search the Orgrimmar Bank |q 24851/1
	step
		goto 40.1,60.5
		.' Search the Orgrimmar Barber Shop |q 24851/3
	step
		goto 57.6,60.8
		.talk Roka##38328
		..turnin Hot On The Trail##24851
		..accept A Friendly Chat...##24576
	step
		goto 51.6,56.7
		.talk Snivel Rustrocket##37715
		..' Tell him you have a rocket with his mark on it.
		..get Snivel's Ledger |q 24576/1
	step
		goto Orgrimmar,50.8,75.2
		.talk Detective Snap Snagglebolt##37172
		..turnin A Friendly Chat...##24576
]])

ZygorGuidesViewer:RegisterInclude("H_Love_Is_In_The_Air_Dailies",[[
	daily
	step
		goto Orgrimmar,50.8,75.3
		.talk Detective Snap Snagglebolt##37172
		..' You have to be at least level 5 to accept a quest from him
		..accept Crushing the Crown##24638 |only if level >= 5 and level < 14
		..accept Crushing the Crown##24645 |only if level >= 14 and level < 23
		..accept Crushing the Crown##24647 |only if level >= 23 and level < 32
		..accept Crushing the Crown##24648 |only if level >= 32 and level < 41
		..accept Crushing the Crown##24649 |only if level >= 41 and level < 51
		..accept Crushing the Crown##24650 |only if level >= 51 and level < 61
		..accept Crushing the Crown##24651 |only if level >= 61 and level < 71
		..accept Crushing the Crown##24652 |only if level >= 71 and level <81
		..accept Crushing the Crown##28935 |only if level >= 81
	step
		goto 53.1,77.2
		.talk Public Relations Agent##37675
		.' You will only be able to accept, and turn in, 1 of these 3 daily quests per day:
		..accept A Cloudlet of Classy Cologne##24635 |or
		..accept A Perfect Puff of Perfume##24629 |or
		..accept Bonbon Blitz##24636 |or
	step
		goto 53.0,76.8
		.talk Kwee Q. Peddlefeet##38042
		..accept A Gift for the Warchief##24612
	step
		'Run around Orgrimmar and:
		.' Use your Crown Cologne Sprayer on NPCs and other players without a red heart over their head |use Crown Cologne Sprayer##49669
		.' Give 10 Cologne Samples |q 24635/1
	step
		'Run around Orgrimmar and:
		.' Use your Crown Perfume Sprayer on NPCs and other players without a red heart over their head |use Crown Perfume Sprayer##49668
		.' Give 10 Perfume Samples |q 24629/1
	step
		'Run around Orgrimmar and:
		.' Use your Crown Chocolate Sampler on NPCs and other players without a red heart over their head |use Crown Chocolate Sampler##49670
		.' Give 10 Chocolate Samples |q 24636/1
	step
		goto Durotar,40.2,15.4
		.kill 5 Crown Lackey |q 24638/2
		.' Use Snagglebolt's Khorium Bomb next to the big shaking Chemical Wagon |use Snagglebolt's Khorium Bomb##50130
		.' Destroy the Chemical Wagon |q 24638/1
		only if level >= 5 and level < 14
	step
		goto Thunder Bluff,44.0,52.6
		.talk Kwee Q. Peddlefeet##38042
		..accept A Gift for the High Chieftain##24614
	step
		goto 43.6,52.9
		.talk Public Relations Agent##37675
		.' You will only be able to accept, and turn in, 1 of these 3 daily quests per day:
		..turnin A Cloudlet of Classy Cologne##24635
		..turnin A Perfect Puff of Perfume##24629
		..turnin Bonbon Blitz##24636
	step
		 goto Uldum,67.8,19.8
		.kill 5 Crown Technicians |q 28935/2
		.' Use Snagglebolt's Khorium Bomb next to the big shaking Chemical Wagon |use Snagglebolt's Khorium Bomb##50130
		.' Destroy the Chemical Wagon |q 28935/1
		only if level >= 81
	step
		goto Undercity,66.5,38.6
		.talk Kwee Q. Peddlefeet##38042 |tip He is in the Ruins of Lordaeron.
		..accept A Gift for the Banshee Queen##24613
	step
		goto Silverpine Forest,54.7,61.3
		.kill 5 Crown Thug |q 24645/2
		.' Use Snagglebolt's Khorium Bomb next to the big shaking Chemical Wagon |use Snagglebolt's Khorium Bomb##50130
		.' Destroy the Chemical Wagon |q 24645/1
		only if level >= 14 and level < 23
	step
		goto Hillsbrad Foothills,34.5,58.4
		.kill 5 Crown Duster |q 24647/2
		.' Use Snagglebolt's Khorium Bomb next to the big shaking Chemical Wagon |use Snagglebolt's Khorium Bomb##50130
		.' Destroy the Chemical Wagon |q 24647/1
		only if level >= 23 and level < 32
	step
		goto The Hinterlands,23.6,53.7
		.kill 5 Crown Agent |q 24649/2
		.' Use Snagglebolt's Khorium Bomb next to the big shaking Chemical Wagon |use Snagglebolt's Khorium Bomb##50130
		.' Destroy the Chemical Wagon |q 24649/1
		only if level >= 41 and level < 51
	step
		goto Silvermoon City,64.4,66.5
		.talk Kwee Q. Peddlefeet##38042
		..accept A Gift for the Regent Lord of Quel'Thalas##24615
	step
		'This step depends on your character's level and what you want to do.  
		.' If you don't have a lot of money, or don't want to spend any more, do this: |tip Go to a place where the mobs are at least green to you, they cannot be grey to you, or they won't drop the items you need.  Now, just kill the mobs until you collect 40 Lovely Charms.  You won't get a Lovely Charm from every mob you kill, so be prepared to grind for a while.
		..collect 40 Lovely Charm##49655 |n
		.' If you have a lot of money, or don't care about spending money and just want to do the quests very quickly, do this: |tip Go to the Auction House and buy 4 Lovely Charm Bracelets.
		.' If you chose to kill mobs, use your Lovely Charms to create 4 Lovely Charm Bracelets |use Lovely Charm##49655
		.collect 4 Lovely Charm Bracelet##49916 |future |q 24614
	step
		goto Silvermoon City,53.8,20.2
		.talk Lor'themar Theron##16802
		..turnin A Gift for the Regent Lord of Quel'Thalas##24615
	step
		goto Undercity,58.1,91.8
		.talk Lady Sylvanas Windrunner##10181
		..turnin A Gift for the Banshee Queen##24613
	step
		goto Thunder Bluff,60.3,51.7
		.talk Baine Bloodhoof##36648
		..turnin A Gift for the High Chieftain##24614
	step
		goto Crystalsong Forest,46.3,50.8
		.kill 5 Crown Sprayer |q 24652/2
		.' Use Snagglebolt's Khorium Bomb next to the big shaking Chemical Wagon |use Snagglebolt's Khorium Bomb##50130
		.' Destroy the Chemical Wagon |q 24652/1
		only if level >= 71 and level < 81
	step
		goto Dustwallow Marsh,60.7,38.3
		.kill 5 Crown Hoodlum |q 24648/2
		.' Use Snagglebolt's Khorium Bomb next to the big shaking Chemical Wagon |use Snagglebolt's Khorium Bomb##50130
		.' Destroy the Chemical Wagon |q 24648/1
		only if level >= 32 and level < 41
	step
		goto Winterspring,63.6,49.4
		.kill 5 Crown Sprinkler |q 24650/2 |tip They are on top of this big hill.
		.' Use Snagglebolt's Khorium Bomb next to the big shaking Chemical Wagon |use Snagglebolt's Khorium Bomb##50130
		.' Destroy the Chemical Wagon |q 24650/1
		only if level >= 51 and level < 61
	step
		goto Terokkar Forest,41.4,22.4
		.kill 5 Crown Underling |q 24651/2
		.' Use Snagglebolt's Khorium Bomb next to the big shaking Chemical Wagon |use Snagglebolt's Khorium Bomb##50130
		.' Destroy the Chemical Wagon |q 24651/1
		only if level >= 61 and level < 71
	step
		goto Orgrimmar,48.1,70.5
		.talk Garrosh Hellscream##39605
		..turnin A Gift for the Warchief##24612
	step
		goto 50.8,75.3
		.talk Detective Snap Snagglebolt##37172
		..' You have to be at least level 5 to accept a quest from him
		..turnin Crushing the Crown##24638 |only if level >= 5 and level < 14
		..turnin Crushing the Crown##24645 |only if level >= 14 and level < 23
		..turnin Crushing the Crown##24647 |only if level >= 23 and level < 32
		..turnin Crushing the Crown##24648 |only if level >= 32 and level < 41
		..turnin Crushing the Crown##24649 |only if level >= 41 and level < 51
		..turnin Crushing the Crown##24650 |only if level >= 51 and level < 61
		..turnin Crushing the Crown##24651 |only if level >= 61 and level < 71
		..turnin Crushing the Crown##24652 |only if level >= 71 and level < 81
		..turnin Crushing the Crown##28935 |only if level >= 85
]])

ZygorGuidesViewer:RegisterInclude("H_Love_Is_In_The_Air_Achievements",[[
	step
		'You will need _Love Tokens_ in order to purchase items from vendors in this guide section. |tip You can get Love Tokens by completing the dailies in the Love is in the Air Dailies section. 
		|confirm always
	step
		goto Orgrimmar,53.1,77.0
		.talk Lovely Merchant##37674
		.buy Bag of Heart Candies##21813 |n
		.' Get the 8 different types of Heart Candy:
		.' Be Mine! |collect 1 Heart Candy##21816
		.' I'll follow you all around Azeroth. |collect 1 Heart Candy##21818
		.' All yours. |collect 1 Heart Candy##21819
		.' I'm all yours! |collect 1 Heart Candy##21821
		.' Hot Lips. |collect 1 Heart Candy##21823
		.' You're Mine! |collect 1 Heart Candy##21822
		.' You're the best! |collect 1 Heart Candy##21820
		.' I LOVE YOU |collect 1 Heart Candy##21817
	step
		'Eat the 8 different type of Heart Candy:
		.' Be Mine! |achieve 1701/1 |use 1 Heart Candy##21816
		.' I'll follow you all around Azeroth. |achieve 1701/2 |use 1 Heart Candy##21818
		.' All yours. |achieve 1701/3 |use 1 Heart Candy##21819
		.' I'm all yours! |achieve 1701/4 |use 1 Heart Candy##21821
		.' Hot Lips. |achieve 1701/5 |use 1 Heart Candy##21823
		.' You're Mine! |achieve 1701/6 |use 1 Heart Candy##21822
		.' You're the best! |achieve 1701/7 |use 1 Heart Candy##21820
		.' I LOVE YOU |achieve 1701/8 |use 1 Heart Candy##21817
	step
		goto 53.1,77.0
		.talk Lovely Merchant##37674
		.buy 10 Silver Shafted Arrow##22200 |n
		.' Use your Silver Shafted Arrows on 10 players inside Orgrimmar |use Silver Shafted Arrow##22200
		.' Shoot 10 Players with the Silver Shafted Arrow |achieve 1188
	step
		goto 53.1,77.0
		.talk Lovely Merchant##37674
		.buy 1 Box of Chocolates##49909 |n
		.' Use your Box of Chocolates and get all the chocolate contained inside of it |use Box of Chocolates##49909
		.' Eat each type of chocolate:
		.' Sweet Surprise |achieve 1702/3 |use Sweet Surprise##22239
		.' Very Berry Cream |achieve 1702/4 |use Very Berry Cream##22238
		.' Buttermilk Delight |achieve 1702/1 |use Buttermilk Delight##22236 |tip Save the remaining Buttermilk Delights for a later achievement.
		.' Dark Desire |achieve 1702/2 |use Dark Desire##22237
	step
		goto 53.1,77.0
		.talk Lovely Merchant##37674
		.buy 10 Love Rocket##34258 |n
		.' Spam use your Love Rockets |use Love Rocket##34258
		.' Shoot off 10 Love Rockets in 20 seconds or less |achieve 1696
	step
		goto 53.1,77.0
		.talk Lovely Merchant##37674
		.buy 15 Handful of Rose Petals##22218 |achieve 1699
		.buy 1 Romantic Picnic Basket##34480 |achieve 1291
		.buy 1 "VICTORY" Perfume##49856 |achieve 1280
		.buy 5 Love Fool##22261 |achieve 1704
	step
		goto 54.8,78.0
		.talk Barkeep Morag##5611
		.buy 6 Cup of Frog Venom Brew##44573 |achieve 1280
	step
		goto Orgrimmar |n
		.' Use your Handful of Rose Petals on the follow race/class combinations: |use Handful of Rose Petals##22218 |tip Save any extra Handfuls of Rose Petals you have, you'll need one later.
		.' Gnome Warlock |achieve 1699/1
		.' Orc Death Knight |achieve 1699/2
		.' Human Death Knight |achieve 1699/3
		.' Night Elf Priest |achieve 1699/4
		.' Orc Shaman |achieve 1699/5
		.' Tauren Druid |achieve 1699/6
		.' Undead Warrior |achieve 1699/7
		.' Troll Rogue |achieve 1699/8
		.' Blood Elf Mage |achieve 1699/9
		.' Draenei Paladin |achieve 1699/10
		.' Dwarf Hunter |achieve 1699/11
		.' For the Alliance races, you can either go to Dalaran or Vale of Eternal Blossoms. While doing your dailies keep an eye out for the races you need.
	step
		'In Dalaran:
		.' Find a player to have a picnic with you
		.' Use your Romantic Picnic Basket |use Romantic Picnic Basket##34480
		.' While having a picnic, use your Buttermilk Delight |use Buttermilk Delight##22236
		.' Enjoy a Buttermilk Delight with someone in Dalaran at a Romantic Picnic |achieve 1291
	step
		'Go to Wintergrasp in Northrend:
		.' Use your Love Fool anywhere inside Wintergrasp |use Love Fool##22261
		.' Target the Love Fool and Pity it |script DoEmote("PITY") |achieve 1704/1
	step
		goto Undercity,67.6,44.1
		.' Do the following exactly in order from top to bottom in the step:
		.' Use all 6 of your Cups of Frog Venom Brew to get Completely Smashed |use Cup of Frog Venom Brew##44573
		.' Use your "VICTORY" Perfume |use "VICTORY" Perfume##49856
		.' Use your Handful of Rose Petals on Jeremiah Payson |use Handful of Rose Petals##22218 |achieve 1280/1
		.' Kiss Jeremiah Payson |script DoEmote("KISS") |achieve 1280/2
	step
		'Go to the Gurubashi Arena in The Cape of Stranglethorn: |tip The Cape of Stranglethorn is the southern-most zone on the Eastern Kingdoms continent.
		.' Use your Love Fool anywhere inside the Gurubashi Arena |use Love Fool##22261
		.' Target the Love Fool and Pity it |script DoEmote("PITY") |achieve 1704/2
	step
		'Enter the Arathi Basin PvP Battleground:
		.' Use your Love Fool inside the Blacksmith subzone inside Arathi Basin |use Love Fool##22261
		.' Target the Love Fool and Pity it |script DoEmote("PITY") |achieve 1704/3
	step
		'Enter the Culling of Stratholme dungeon:
		.' Use your Love Fool anywhere inside the Culling of Stratholme dungeon |use Love Fool##22261
		.' Target the Love Fool and Pity it |script DoEmote("PITY") |achieve 1704/4
	step
		'Enter the Naxxramas raid:
		.' Use your Love Fool anywhere inside the Naxxramas raid |use Love Fool##22261
		.' Target the Love Fool and Pity it |script DoEmote("PITY") |achieve 1704/5
	step
		'Go to a place where the mobs are at least green to you, they cannot be grey to you, or they won't drop the items you need.
		.' Kill the mobs until you collect 120 Lovely Charms.  |tip You won't get a Lovely Charm from every mob you kill, so be prepared to grind for a while.
		.collect 120 Lovely Charm##49655 |n
		.' Use your Lovely Charms to create 12 Lovely Charm Bracelets |use Lovely Charm##49655
		.' Create 12 Lovely Charm Bracelets |achieve 260
	step
		'Kill these certain bosses in any of the following dungeons: |tip You can enter either Normal or Heroic difficulty, it doesn't matter.
		.' _Drahga Shadowburner_ in Grim Batol: 
		.' _Corla, Herald of Twilight_ in Blackrock Caverns: 
		.' _High Priestess_ Azil in The Stonecore:
		.' _Admiral Ripsnarl_ in Deadmines: And
		.' _Lord Godfrey_ in Shadowfang Keep
		.' Get either of these 2 items as a random drop from these bosses:
		.collect 1 Bouquet of Red Roses##22206 |n
		.collect 1 Bouquet of Ebon Roses##44731 |n
		.' Obtain a Bouquet of Red or Ebon Roses during the Love is in the Air celebration |achieve 1703 
	step
		'Congratulations, you are a Fool For Love!
]])
--Noblegarden--
ZygorGuidesViewer:RegisterInclude("H_Noblegarden_Achievements",[[
	step
		'You may be unable to complete some of the achievements if you are lower level.  So, if you find you cannot do something in this guide, simply skip it and do what you can
		|confirm
	step
		goto Mulgore,47.2,59.3
		.click Brightly Colored Eggs##1407+ 
		|tip There is at least one available at all times. If Bloodhoof Village is too crowded with other players looking for eggs, you can also find them at Razor Hill, Falconwing Square, and Brill.
		.collect Brightly Colored Egg##45072+ |n
		.' Click Brightly Colored Eggs in your bags |use Brightly Colored Egg##45072
		.collect 100 Noblegarden Chocolate##44791+ |n
		.' Eat 100 Noblegarden Chocolates |achieve 2418 |use Noblegarden Chocolate##44791
		.' Discover a White Tuxedo Shirt by opening Brightly Colored Eggs |achieve 248/1
		.' Discover Black Tuxedo Pants by opening Brightly Colored Eggs |achieve 248/2
		.' Discover an Elegant Dress by opening Brightly Colored Eggs |achieve 249                                              
		.' If you've eaten 100 chocolates and want to buy these items to continue, click here to continue |confirm
	step
		'If you don't already have these items, collect Noblegarden Chocolates and purchase them from the Noblegarden Merchant at [47.1,59.9]:
		.collect Noblegarden Egg##44818 |achieve 2420 |tip It costs 5 Noblegarden Chocolates.
		.collect Blossoming Branch##44792 |achieve 2416 |tip It costs 10 Noblegarden Chocolates.
		.collect Spring Flowers##45073 |achieve 2422 |tip It costs 50 Noblegarden Chocolates.
		.collect Spring Robes##44800 |achieve 2436 |tip It costs 50 Noblegarden Chocolates.
		.collect Spring Rabbit's Foot##44794 |achieve 2497 |tip It costs 100 Noblegarden Chocolates.
	step
		goto 47.2,59.3
		.' Use your Spring Rabbit's Foot in your bags to get a Spring Rabbit companion |use Spring Rabbit's Foot##44794
		.' Bring out your Spring Rabbit companion |tip Press P to bring up your Spellbook and click on the Companions ribbon, then click the Spring Rabbit icon.
		.' Find a player with a Spring Rabbit next to them around Bloodhoof Village  
		.' Find your Spring Rabbit another one to love in Bloodhoof Village |achieve 2497/1
		|modelnpc Spring Rabbit##32791
	step
		goto Desolace 57.0,53.5
		'Equip your Spring Robes in your bags |equipped Spring Robes##44800 |use Spring Robes##44800
		.' Use your Spring Robes' ability to plant a flower |use Spring Robes##44800
		.' Plant a flower in Desolace |achieve 2436/2
	step
		goto Silithus 53.0,34.7
		'Equip your Spring Robes in your bags |equipped Spring Robes##44800 |use Spring Robes##44800
		.' Use your Spring Robes' ability to plant a flower |use Spring Robes##44800
		.' Plant a flower in Silithus |achieve 2436/3
	step
		goto Un'Goro Crater,35.8,50.7
		.' Change into a bunny |tip You will need a friend to do this, or at least another player.  There should be plenty of players trying to do this achievement at the same time, so it should be easy to find help.  Have your friend, or other player, use their Blossoming Branch on you to turn you into a rabbit.
		.' Stand still until you lay an egg
		.' Lay a Noblegarden Egg in the Golakka Hot Springs |achieve 2416
	step
		goto Tanaris 52.1,27.5
		'Equip your Spring Robes in your bags |equipped Spring Robes##44800 |use Spring Robes##44800
		.' Use your Spring Robes' ability to plant a flower |use Spring Robes##44800
		.' Plant a flower in Tanaris |achieve 2436/4
	step
		goto Thousand Needles,90.3,72.8
		'Equip your Spring Robes in your bags |equipped Spring Robes##44800 |use Spring Robes##44800
		.' Use your Spring Robes' ability to plant a flower |use Spring Robes##44800
		.' Plant a flower in Thousand Needles |achieve 2436/5
	step
		goto Durotar,52.5,42.7
		.' Bring out your Spring Rabbit companion |tip Press P to bring up your Spellbook and click on the Companions ribbon, then click the Spring Rabbit icon.
		.' Find a player with a Spring Rabbit next to them around Razor Hill 
		.' Find your Spring Rabbit another one to love in Razor Hill |achieve 2497/4
		|modelnpc Spring Rabbit##32791
	step
		goto Tirisfal Glades,61.0,52.7
		.' Bring out your Spring Rabbit companion |tip Press P to bring up your Spellbook and click on the Companions ribbon, then click the Spring Rabbit icon.
		.' Find a player with a Spring Rabbit next to them around Brill 
		.' Find your Spring Rabbit another one to love in Brill |achieve 2497/2
		|modelnpc Spring Rabbit##32791
	step
		goto Silvermoon City 60.3,28.0
		'Use your Noblegarden Egg anywhere in Silvermoon City |use Noblegarden Egg##44818
		.' Hide a Brightly Colored Egg in Silvermoon City |achieve 2420
	step
		goto Eversong Woods,47.5,46.5
		.' Bring out your Spring Rabbit companion |tip Press P to bring up your Spellbook and click on the Companions ribbon, then click the Spring Rabbit icon.
		.' Find a player with a Spring Rabbit next to them around Falconwing Square 
		.' Find your Spring Rabbit another one to love in Falconwing Square |achieve 2497/3
		|modelnpc Spring Rabbit##32791
	step
		goto Badlands 65.2,35.4
		'Equip your Spring Robes in your bags |equipped Spring Robes##44800 |use Spring Robes##44800
		.' Use your Spring Robes' ability to plant a flower |use Spring Robes##44800
		.' Plant a flower in The Badlands |achieve 2436/1
	step
		'Equip your Black Tuxedo Pants |equipped Black Tuxedo Pants##6835 |use Black Tuxedo Pants##6835
		'Equip your White Tuxedo Shirt |equipped White Tuxedo Shirt##6833 |use White Tuxedo Shirt##6833
		.' Find another player who is wearing the Elegant Dress and perform the Kiss emote on them |script DoEmote("KISS") |tip The Elegant Dress looks like a long pink dress when worn.
		.' Kiss someone wearing an Elegant Dress while wearing a White Tuxedo Shirt and Black Tuxedo Pants |achieve 2576
	step
		'Find a female character of every race that are at least level 18 and do the following: |tip The best places to try and find them would be Dalaran, Shattrath, Stormwind, and Orgrimmar
		.' Use your Spring Flowers on them |equipped Spring Flowers##45073 |use Spring Flowers##45073
		.' Place bunny ears on a Blood Elf |achieve 2422/1
		.' Place bunny ears on a Human |achieve 2422/6
		.' Place bunny ears on a Troll |achieve 2422/10
		.' Place bunny ears on a Draenei |achieve 2422/2
		.' Place bunny ears on a Night Elf |achieve 2422/7
		.' Place bunny ears on an Undead |achieve 2422/11
		.' Place bunny ears on a Dwarf |achieve 2422/3
		.' Place bunny ears on a Orc |achieve 2422/8
		.' Place bunny ears on a Gnome |achieve 2422/4
		.' Place bunny ears on a Tauren |achieve 2422/9
		.' Place bunny ears on a Goblin |achieve 2422/5
		.' Place bunny ears on a Worgen |achieve 2422/12
	step
		'Congratulations, you are now a Noble Gardener!
]])

ZygorGuidesViewer:RegisterInclude("H_Noblegarden_Quests_Dailies",[[
	step
		goto Thunder Bluff,40.8,56.1
		.talk Tauren Commoner##19176
		..accept Spring Gatherers##13483
	step
		goto Mulgore,46.9,59.5
		.talk Spring Gatherer##32798
		..turnin Spring Gatherers##13483
		..accept The Great Egg Hunt##13479
	step
		goto 47.1,59.9
		.talk Noblegarden Merchant##32837
		..accept A Tisket, a Tasket, a Noblegarden Basket##13503
	step
		'Search around Bloodhoof Village for Brightly Colored Eggs and click them:
		.click Brightly Colored Egg##1407+ 
		|tip There is at least one available at all times. If Bloodhoof Village is too crowded with other players looking for eggs, you can also find them at Razor Hill, Falconwing Square, and Brill.
		.collect Brightly Colored Egg##45072+ |n
		.' Click Brightly Colored Eggs in your bags |use Brightly Colored Egg##45072
		.get 20 Brightly Colored Shell Fragment |q 13479/1
		.get 10 Noblegarden Chocolate |q 13503/1
	step
		goto 47.1,59.9
		.talk Noblegarden Merchant##32837
		..turnin A Tisket, a Tasket, a Noblegarden Basket##13503
	step
		goto 46.9,59.5
		.talk Spring Gatherer##32798
		..turnin The Great Egg Hunt##13479
]])

--CHILDREN'S VEIL--

ZygorGuidesViewer:RegisterInclude("H_Children's_Week_Ogrimmar_Quests",[[
	step
		goto Orgrimmar,58.0,57.6
		.talk Orphan Matron Battlewail##51989 |tip This npc may walk around, so some searching may be required.
		..accept Children's Week##172
	step
		'Use your Orcish Orphan Whistle to summon your Orcish Orphan |use Orcish Orphan Whistle##18597
		.talk Orcish Orphan##14444
		..turnin Children's Week##172
		..accept Ridin' the Rocketway##29146
		..accept The Fallen Chieftain##29176
		..accept The Banshee Queen##29167
	step
		goto Azshara 50.7,73.9
		.clicknpc Redhound Two-Seater##52583
		.' Take Your Orphan to Ride the Rocketway |q 29146/1
	step
		'Use your Orcish Orphan Whistle to summon your Orcish Orphan |use Orcish Orphan Whistle##18597
		.talk Orcish Orphan##14444
		..turnin Ridin' the Rocketway##29146
	step
		goto Mulgore,60.7,23.1
		.' Use your Human Orphan Whistle to summon your Human Orphan |use Human Orphan Whistle##18597
		.' Take Your Orphan to Visit Red Rocks |q 29176/1
	step
		'Use your Orcish Orphan Whistle to summon your Orcish Orphan |use Orcish Orphan Whistle##18597
		.talk Orcish Orphan##14444
		..turnin The Fallen Chieftain##29176
	step
		goto Undercity 58.1,91.8
		.' Use your Human Orphan Whistle to summon your Human Orphan |use Human Orphan Whistle##18597
		.' Take Your Orphan to a Meeting with Lady Sylvanas Windrunner |q 29167/1
	step
		'Use your Orcish Orphan Whistle to summon your Orcish Orphan |use Orcish Orphan Whistle##18597
		.talk Orcish Orphan##14444
		..turnin The Banshee Queen##29167
		..accept Let's Go Fly a Kite##29190
		..accept You Scream, I Scream...##29191
	step
		goto Orgrimmar,58.3,55.0
		.talk Blax Bottlerocket##52809
		.buy 1 Dragon Kite 2-Pack##69231 |q 29190
	step
		'Use your Orcish Orphan Whistle to summon your Orcish Orphan |use Orcish Orphan Whistle##18597
		.' When your orphan is next to you:
		.' Use your Dragon Kite 2-Pack |use Dragon Kite 2-Pack##69231
		.' Fly Dragon Kites with Your Orphan |q 29190/1
	step
		'Use your Orcish Orphan Whistle to summon your Orcish Orphan |use Orcish Orphan Whistle##18597
		.talk Orcish Orphan##14444
		..turnin Let's Go Fly a Kite##29190
	step
		goto 38.8,87.0
		.talk Snixx Quickfreeze##52818
		.buy 1 Cone of Cold##69233 |q 29191
	step
		'Use your Orcish Orphan Whistle to summon your Orcish Orphan |use Orcish Orphan Whistle##18597
		.' When your orphan is next to you:
		.' Use your Cone of Cold |use Cone of Cold##69233
		.' Take Your Orphan Out for Ice Cream |q 29191/1
	step
		'Use your Orcish Orphan Whistle to summon your Orcish Orphan |use Orcish Orphan Whistle##18597
		.talk Orcish Orphan##14444
		..turnin You Scream, I Scream...##29191
		..accept A Warden of the Horde##5502
	step
		goto 58.3,55.0
		.talk Blax Bottlerocket##52809
		.buy 1 Foam Sword Rack##69057 |q 5502/1
	step
		goto 58.0,57.6
		.talk Orphan Matron Battlewail##51989
		..turnin A Warden of the Horde##5502 |tip You will be able to choose from 3 pet companions or a 5 gold reward.  If you already have all 3 pets, choose the gold.  You will be able to do this quest each year, so you will be able to collect all 3 pets, eventually.
]])
ZygorGuidesViewer:RegisterInclude("H_Children's_Week_Shattrath_Quests",[[
	step
		goto Shattrath City,74.9,47.9
		.talk Orphan Matron Mercy##22819
		..accept Children's Week##10942
	step
		'Use your Blood Elf Orphan Whistle to summon your Blood Elf Orphan |use Blood Elf Orphan Whistle##31880
		.talk Blood Elf Orphan##22817
		..turnin Children's Week##10942
		..accept Hch'uu and the Mushroom People##10945
		..accept A Trip to the Dark Portal##10951
		..accept Visit the Throne of the Elements##10953 
	step
		goto Nagrand,60.7,22.3
		.' Use your Blood Elf Orphan Whistle to summon your Blood Elf Orphan |use Blood Elf Orphan Whistle##31880
		.' Take Salandria to the Throne of the Elements |q 10953/1
	step
		goto Nagrand,60.7,22.1
		.talk Elementalist Sharvak##18072
		..turnin Visit the Throne of the Elements##10953
	step
		goto Zangarmarsh,19.3,51.3
		.' Use your Blood Elf Orphan Whistle to summon your Blood Elf Orphan |use Blood Elf Orphan Whistle##31880
		.' Take Salandria to Sporeggar |q 10945/1
	step
		goto Zangarmarsh,19.3,51.3
		.talk Hch'uu##22823
		..turnin Hch'uu and the Mushroom People##10945
	step
		goto Hellfire Peninsula,89.6,50.2
		.' Use your Blood Elf Orphan Whistle to summon your Blood Elf Orphan |use Blood Elf Orphan Whistle##31880
		.' Take Salandria to the Dark Portal |q 10951/1
	step
		'Use your Blood Elf Orphan Whistle to summon your Blood Elf Orphan |use Blood Elf Orphan Whistle##31880
		.talk Blood Elf Orphan##22817
		..turnin A Trip to the Dark Portal##10951
		..accept Now, When I Grow Up...##11975
		..accept Time to Visit the Caverns##10963
	step
		goto Tanaris,61.5,50.6 |n
		.' The path to Zaladormu starts here |goto Tanaris,61.5,50.6,1 |noway |c
	step
		goto Tanaris,64.9,50.0 |n
		.' Enter the Caverns of Time here |goto Tanaris,64.9,50.0,0.5 |noway |c
	step
		'Follow the path down to 60.0,57.0 |goto Tanaris,60.0,57.0 |tip You will end up underground, in the Caverns of Time, next to a big dragon named Zaladormu, who is laying on a big platform.
		.' Use your Blood Elf Orphan Whistle to summon your Blood Elf Orphan |use Blood Elf Orphan Whistle##31880
		.' Take Salandria to the Caverns of Time |q 10963/1
	step
		goto Tanaris,63.0,57.3
		.talk Alurmi##21643
		.buy 1 Toy Dragon##31951 |q 10963/2
	step
		'Use your Blood Elf Orphan Whistle to summon your Blood Elf Orphan |use Blood Elf Orphan Whistle##31880
		.talk Blood Elf Orphan##22817
		..turnin Time to Visit the Caverns##10963
	step
		goto Silvermoon City,76.7,80.7
		.' Use your Blood Elf Orphan Whistle to summon your Blood Elf Orphan |use Blood Elf Orphan Whistle##31880
		.' Take Salandria to see the Elite Tauren Chieftain in Silvermoon City's Walk of Elders
		.talk Blood Elf Orphan##22817
		..turnin Now, When I Grow Up...##11975
		..accept Back to the Orphanage##10967
	step
		goto Shattrath City,74.9,47.9
		.talk Orphan Matron Mercy##22819
		..turnin Back to the Orphanage##10967 |tip You will be able to choose from 4 pet companions. Only Egbert's Egg, Elekk Training Collar, and Sleepy Willy count toward an achievement.
]])
ZygorGuidesViewer:RegisterInclude("H_Children's_Week_Oracle_Quests",[[
	step
		goto Dalaran,49.4,63.2
		.talk Orphan Matron Aria##34365
		..accept Little Orphan Roo Of The Oracles##13926
		..' Ask about the orphans
		..' Speak to Orphan Matron Aria and accept to care for the Oracle Orphan |q 13926/1
	step
		'Use your Oracle Orphan Whistle to summon your Oracle Orphan |use Oracle Orphan Whistle##46397
		.talk Oracle Orphan##33533
		..turnin Little Orphan Roo Of The Oracles##13926
		..accept The Biggest Tree Ever!##13929
		..accept The Bronze Dragonshrine##13933
		..accept Playmates!##13950 
	step
		goto Grizzly Hills,50.8,42.8
		.' Use your Oracle Orphan Whistle to summon your Oracle Orphan |use Oracle Orphan Whistle##46397
		.' Take Roo to visit Grizzlemaw |q 13929/1
	step
		'Use your Oracle Orphan Whistle to summon your Oracle Orphan |use Oracle Orphan Whistle##46397
		.talk Oracle Orphan##33533
		..turnin The Biggest Tree Ever!##13929
	step
		goto Dragonblight,72.5,36.9
		.' Use your Oracle Orphan Whistle to summon your Oracle Orphan |use Oracle Orphan Whistle##46397
		.' Take Roo to visit the Bronze Dragonshrine |q 13933/1
	step
		'Use your Oracle Orphan Whistle to summon your Oracle Orphan |use Oracle Orphan Whistle##46397
		.talk Oracle Orphan##33533
		..turnin The Bronze Dragonshrine##13933
	step
		goto Borean Tundra,43.5,13.7
		.' Use your Oracle Orphan Whistle to summon your Oracle Orphan |use Oracle Orphan Whistle##46397
		.' Take Roo to visit Winterfin Retreat |q 13950/1
	step
		'Use your Oracle Orphan Whistle to summon your Oracle Orphan |use Oracle Orphan Whistle##46397
		.talk Oracle Orphan##33533
		..turnin Playmates!##13950
		..accept The Dragon Queen##13954
		..accept Meeting a Great One##13956
	step
		goto Un'Goro Crater,47.5,9.2
		.' Use your Oracle Orphan Whistle to summon your Oracle Orphan |use Oracle Orphan Whistle##46397
		.' Take Roo to visit The Etymidian |q 13956/1
	step
		'Use your Oracle Orphan Whistle to summon your Oracle Orphan |use Oracle Orphan Whistle##46397
		.talk Oracle Orphan##33533
		..turnin Meeting a Great One##13956
	step
		goto Dragonblight,59.8,54.7
		.' Use your Oracle Orphan Whistle to summon your Oracle Orphan |use Oracle Orphan Whistle##46397
		.' Take Roo to visit Alexstrasza the Life-Binder |q 13954/1 |tip Alexstrasza the Life-Binder is at the top of Wyrmrest Temple.
	step
		'Use your Oracle Orphan Whistle to summon your Oracle Orphan |use Oracle Orphan Whistle##46397
		.talk Oracle Orphan##33533
		..turnin The Dragon Queen##13954
		..accept A Trip To The Wonderworks##13937
	step
		goto Dalaran,44.9,45.6
		.talk Jepetto Joybuzz##29478
		.buy 1 Small Paper Zeppelin##46693
	step
		'Use your Oracle Orphan Whistle to summon your Oracle Orphan |use Oracle Orphan Whistle##46397
		.' Use your Small Paper Zeppelin on your Oracle Orphan |use Small Paper Zeppelin##46693
		.' Throw the Small Paper Zeppelin to Roo |q 13937/1
	step
		'Use your Oracle Orphan Whistle to summon your Oracle Orphan |use Oracle Orphan Whistle##46397
		.talk Oracle Orphan##33533
		..turnin A Trip To The Wonderworks##13937
		..accept Back To The Orphanage##13959
	step
		goto Dalaran,49.4,63.2
		.talk Orphan Matron Aria##34365
		..turnin Back To The Orphanage##13959 |tip You will receive a Curious Oracle Hatchling pet companion in the mail.
]])
ZygorGuidesViewer:RegisterInclude("H_Children's_Week_Wolvar_Quests",[[
	step
		goto Dalaran,49.4,63.2
		.talk Orphan Matron Aria##34365
		..accept Little Orphan Kekek Of The Wolvar##13927
		..' Ask about the orphans
		..' Speak to Orphan Matron Aria and accept to care for the Wolvar Orphan |q 13927/1
	step
		'Use your Wolvar Orphan Whistle to summon your Wolvar Orphan |use Wolvar Orphan Whistle##46396
		.talk Wolvar Orphan##33532
		..turnin Little Orphan Kekek Of The Wolvar##13927
		..accept Home Of The Bear-Men##13930
		..accept The Bronze Dragonshrine##13934
		..accept Playmates!##13951 
	step
		goto Grizzly Hills,50.8,42.8
		.' Use your Wolvar Orphan Whistle to summon your Wolvar Orphan |use Wolvar Orphan Whistle##46396
		.' Take Kekek to visit Grizzlemaw |q 13930/1
	step
		'Use your Wolvar Orphan Whistle to summon your Wolvar Orphan |use Wolvar Orphan Whistle##46396
		.talk Wolvar Orphan##33532
		..turnin Home Of The Bear-Men##13930
	step
		goto Dragonblight,72.5,36.9
		.' Use your Wolvar Orphan Whistle to summon your Wolvar Orphan |use Wolvar Orphan Whistle##46396
		.' Take Kekek to visit the Bronze Dragonshrine |q 13934/1
	step
		'Use your Wolvar Orphan Whistle to summon your Wolvar Orphan |use Wolvar Orphan Whistle##46396
		.talk Wolvar Orphan##33532
		..turnin The Bronze Dragonshrine##13934
	step
		goto Dragonblight,45.3,63.3
		.' Use your Wolvar Orphan Whistle to summon your Wolvar Orphan |use Wolvar Orphan Whistle##46396
		.' Take Kekek to visit Snowfall Glade |q 13951/1
	step
		'Use your Wolvar Orphan Whistle to summon your Wolvar Orphan |use Wolvar Orphan Whistle##46396
		.talk Wolvar Orphan##33532
		..turnin Playmates!##13951
		..accept The Dragon Queen##13955
		..accept The Mighty Hemet Nesingwary##13957
	step
		goto Dragonblight,59.8,54.7
		.' Use your Wolvar Orphan Whistle to summon your Wolvar Orphan |use Wolvar Orphan Whistle##46396
		.' Take Kekek to visit Alexstrasza the Life-Binder |q 13955/1 |tip Alexstrasza the Life-Binder is at the top of Wyrmrest Temple.
	step
		'Use your Wolvar Orphan Whistle to summon your Wolvar Orphan |use Wolvar Orphan Whistle##46396
		.talk Wolvar Orphan##33532
		..turnin The Dragon Queen##13955
	step
		goto Sholazar Basin,27.1,58.7
		.' Use your Wolvar Orphan Whistle to summon your Wolvar Orphan |use Wolvar Orphan Whistle##46396
		.' Take Kekek to visit Hemet Nesingwary |q 13957/1
	step
		'Use your Wolvar Orphan Whistle to summon your Wolvar Orphan |use Wolvar Orphan Whistle##46396
		.talk Wolvar Orphan##33532
		..turnin The Mighty Hemet Nesingwary##13957	
		..accept A Trip To The Wonderworks##13938
	step
		goto Dalaran,44.9,45.6
		.talk Jepetto Joybuzz##29478
		.buy 1 Small Paper Zeppelin##46693
	step
		'Use your Wolvar Orphan Whistle to summon your Wolvar Orphan |use Wolvar Orphan Whistle##46396
		.' Use your Small Paper Zeppelin on your Wolvar Orphan |use Small Paper Zeppelin##46693
		.' Throw the Small Paper Zeppelin to Kekek |q 13938/1
	step
		'Use your Wolvar Orphan Whistle to summon your Wolvar Orphan |use Wolvar Orphan Whistle##46396
		.talk Wolvar Orphan##33532
		..turnin A Trip To The Wonderworks##13938
		..accept Back To The Orphanage##13960
	step
		goto Dalaran,49.4,63.2
		.talk Orphan Matron Aria##34365
		..turnin Back To The Orphanage##13960 |tip You will receive a Curious Wolvar Pup pet companion in the mail.
]])
ZygorGuidesViewer:RegisterInclude("H_Children's_Week_Achievements",[[
	step
		goto Orgrimmar 58.1,57.4
		.talk Orphan Matron Battlewail##14451
		..' Ask her for another Orphan Whistle |collect 1 Orcish Orphan Whistle##18597
	step
		'Complete any 5 daily quests of your choice: |tip Make sure your orphan is standing next to you when turning in the daily quests, or you won't get credit for this achievement.
		.' Get the Daily Chores Achievement |achieve 1789
	step
		goto Orgrimmar 53.2,79.2
		.talk Alowicious Czervik##14480
		..buy 1 Tigule and Foror's Strawberry Ice Cream##7228 |achieve 1788
	step
		'Purchase the follow items from the Auction House, or use your Cooking ability to create them, if you'd like:
		.collect 1 Tasty Cupcake##43490 |achieve 1788
		.collect 1 Delicious Chocolate Cake##33924 |achieve 1788
	step
		goto Dalaran,51.2,29.1
		.talk Aimee##29548
		..buy 1 Red Velvet Cupcake##42429 |achieve 1788
		..buy 1 Lovely Cake##42438 |achieve 1788
		..buy 1 Dalaran Doughnut##42430 |achieve 1788
		..buy 1 Dalaran Brownie##42431 |achieve 1788
	step
		'Use your Lovely Cake in your bags to place a cake on the ground |use Lovely Cake##42438
		.' Click the Lovely Cake
		.collect 1 Lovely Cake Slice##42434 |achieve 1788
	step
		'Use whichever Orphan Whistle you currently have to summon your Orphan, so that the Orphan is standing next to you:
		.' Eat Tigule and Foror's Strawberry Ice Cream |achieve 1788/1 |use Tigule and Foror's Strawberry Ice Cream##7228
		.' Eat Tasty Cupcake |achieve 1788/2 |use Tasty Cupcake##43490
		.' Eat Red Velvet Cupcake |achieve 1788/3 |use Red Velvet Cupcake##42429
		.' Eat Delicious Chocolate Cake |achieve 1788/4 |use Delicious Chocolate Cake##33924
		.' Eat Lovely Cake Slice |achieve 1788/5 |use Lovely Cake Slice##42434
		.' Eat Dalaran Brownie |achieve 1788/6 |use Dalaran Brownie##42431
		.' Eat Dalaran Doughnut |achieve 1788/7 |use Dalaran Doughnut##42430
	step
		'Use your Hearthstone while your Orphan is standing next to you |use Hearthstone##6948
		.' Get the Home Alone Achievement |achieve 1791
	step
		'The following achievements are a little more dynamic, so we cannot walk you step-by-step through getting them. 
		|confirm
	step
		'Find a group, run the Utgarde Pinnacle dungeon, and defeat King Ymiron |tip Make sure your Orphan is standing next to you when you defeat King Ymiron, or else you won't get credit for the achievement.
		.' Get the Hail To The King, Baby Achievement |achieve 1790
	step
		'Enter the Eye of the Storm battleground and capture the flag |tip Make sure your Orphan is standing next to you when you capture the flag, or else you won't get credit for the achievement.
		.' Capture the flag in Eye of the Storm |achieve 1786/1
	step
		'Enter the Alterac Valley battleground and assault a tower |tip Make sure your Orphan is standing next to you when you assault the tower, or else you won't get credit for the achievement.
		.' Assault a tower in Alterac Valley |achieve 1786/2
	step
		'Enter the Arathi Basin battleground and assault a flag |tip Make sure your Orphan is standing next to you when you assault the flag, or else you won't get credit for the achievement.
		.' Assault a flag in Arathi Basin |achieve 1786/3
	step
		'Enter the Warsong Gulch battleground and return a fallen flag |tip Make sure your Orphan is standing next to you when you return the fallen flag, or else you won't get credit for the achievement.
		.' Return a fallen flag in Warsong Gulch |achieve 1786/4
	step
		'Congratulations, you do it For The Children! |achieve 1793/1 
]])
-- WINTERS VEIL --

ZygorGuidesViewer:RegisterInclude("H_Winterveil_Quests",[[
	step
		goto Orgrimmar,52.7,77.3
		.talk Kaymard Copperpinch##13418
		..accept Great-father Winter is Here!##6961
		..accept You're a Mean One...##6983 |only if level>=80
	step
		goto 49.6,78.0
		.talk Great-father Winter##13445
		..turnin Great-father Winter is Here!##6961
		..accept Treats for Great-father Winter##6962
	step
		goto 51.0,71.0
		.talk Furmund##9550
		..accept The Reason for the Season##6964
	step
		goto 56.1,61.7
		.talk Arugi##46709
		.' Learn the Apprentice Cooking skill.
		|only if skill("Cooking")<=1
	step
		goto 39.5,47.3
		.talk Sagorne Creststrider##13417
		..turnin The Reason for the Season##6964
		..accept The Feast of Winter Veil##7061
	step
		goto 52.5,76.8
		.talk Penney Copperpinch##13420
		.buy 1 Recipe: Gingerbread Cookie##17200 |n
		.buy 5 Holiday Spices##17194 |q 6962
		.' Click the Recipe: Gingerbread Cookie recipe in your bags |use Recipe: Gingerbread Cookie##17200
		.learn Gingerbread Cookie##21143
		|confirm
	step
		'Buy 5 Small Eggs from the Auction House:
		.collect 5 Small Egg##6889 |q 6962
		.' If you would rather farm these from mobs, click here |confirm |next
		|next "cook" |only if default
	step
		goto Eversong Woods 43.4,56.6
		.from Feral Dragonhawk Hatchling##15649, Crazed Dragonhawk##15650+
		.collect 5 Small Egg##6889 |q 6962
	step
	label "cook"
		goto Orgrimmar 53.8,84.7
		.create Gingerbread Cookie##21143,Cooking,5 total |q 6962/1
	step
		goto 53.6,78.8
		.talk Innkeeper Gryshka##6929
		.buy Ice Cold Milk##1179 |future |q 6962
	step
		goto 53.6,78.8
		.talk Innkeeper Gryshka##6929
		.home Orgrimmar
	step
		goto 49.6,78.0
		.talk Great-father Winter##13445
		..turnin Treats for Great-father Winter##6962
	step
		goto Hillsbrad Foothills,42.3,41.1
		.talk Strange Snowman##13636
		..accept You're a Mean One...##6983 
		|only if level>=80 and not havequest(6983)
	step
		goto Hillsbrad Foothills,43.6,39.0
		.from The Abominable Greench##13602 |tip This will require a group to kill, but you do not have to be in a party.
		.' Free Metzen the Reindeer |q 6983/2
		.get Stolen Treats |q 6983/1 |tip You can pick this up if someone has killed The Abominable Grinch recently.
		|only if level>=80 and havequest(6983)
	step
		goto Thunder Bluff,60.3,51.7
		.talk Baine Bloodhoof##36648
		..turnin The Feast of Winter Veil##7061
	step
		goto Orgrimmar,52.6,77.4
		.talk Kaymard Copperpinch##13418
		..turnin You're a Mean One...##6983 |only if level>=80 and havequest(6983)
		..accept A Smokywood Pastures' Thank You!##6984
	step
		goto 49.6,78.0
		.talk Great-father Winter##13445
		..turnin A Smokywood Pastures' Thank You!##6984	
]])

ZygorGuidesViewer:RegisterInclude("H_Winterveil_Achievements",[[
	step
		goto Orgrimmar,54.5,77.8
		.' Kiss a Winter Reveler every hour |script DoEmote("KISS") |tip You can only use this once per hour. The items you get are random.
		.collect 5 Handful of Snowflakes##34191 |n
		.collect 3 Mistletoe##21519 |n
		.collect 1 Preserved Holly##21213 |n
		|confirm always
	step
		'Use a Handful of Snowflakes on the following race/class combinations |use Handful of Snowflakes##34191 |tip The best place to complete this is in major cities, but it can be done anywhere in the world.
		.' You can get more snowflakes by using /kiss on Winter Revelers at [54.5,77.8]
		.' Orc Death Knight |achieve 1687/1
		.' Human Warrior |achieve 1687/2
		.' Tauren Shaman |achieve 1687/3
		.' Night Elf Druid |achieve 1687/4
		.' Undead Rogue |achieve 1687/5
		.' Troll Hunter |achieve 1687/6
		.' Gnome Mage |achieve 1687/7
		.' Dwarf Paladin |achieve 1687/8
		.' Blood Elf Warlock |achieve 1687/9
		.' Draenei Priest |achieve 1687/10
	step
		'Use the Cooking profession to create Egg Nog and Hot Apple Cider
		.' You can get the recipes for these items from Penney Copperpinch at [52.5,76.8]
		.create Egg Nog##21144,Cooking,1 total |achieve 1688/2
		.create 1 Hot Apple Cider##45022,Cooking,1 total |achieve 1688/3 |tip Requires a cooking skill of 325
	step
		'Use the Tailoring profession or pay a tailor to create Green Winter Clothes
		.' You can buy the pattern from Penney Copperpinch at [52.5,76.8]
		.collect Green Winter Clothes##34087 |future |achieve 277 |or
		.' or
		.collect Red Winter Clothes##34085 |future |achieve 277 |or
	step
		'Use the Leatherworking profession or pay a leatherworker to create Winter Boots
		.' You can buy the pattern from Penney Copperpinch at [52.5,76.8]
		.collect Winter Boots##34086 |future |achieve 277
	step
		.' The Winter Hat will drop from any of these dungeons
		.' _Deadmines (Heroic)_ - Admiral Ripsnarl
		.' _The Stone Core (Normal + Heroic)_ - High Priestess Azil
		.' -Blackrock Caverns (Normal + Heroic)_ - Corla, Herald of Twilight
		.' _Shadowfang Keep (Heroic)_ - Lord Godfrey
		.' _Grim Batol (Normal + Heroic)_ - Drahga Shadowburner
		.collect 1 Green Winter Hat##21525 |future |achieve 277 |or
		.' or
		.collect 1 Red Winter Hat##21524 |future |achieve 277 |or
	step
		'Get the Smokywood Pastures Sampler from your mailbox |tip It should arrive within 24 hours after completing the Feast of Winter Veil quest section of this guide.
		.' Click the Smokywood Pastures Sampler in your bag |use Smokywood Pastures Sampler##17685
		.collect 1 Graccu's Mince Meat Fruitcake##21215 |future |achieve 277
		.' Equip the Green Winter Clothes |equipped Green Winter Clothes##34087 |use Green Winter Clothes##34087 |future |achieve 277
		.' or
		.' Equip the Red Winter Clothes |equipped Red Winter Clothes##34085 |use Red Winter Clothes##34085 |future |achieve 277
		.' Equip the Winter Boots |equipped  Winter Boots##34086 |use Winter Boots##34086 |future |achieve 277
		.' Equip the Green Winter Hat |equipped Winter Hat##21525 |use Winter Hat##21525 |future |achieve 277
		.' or
		.' Equip the Red Winter Hat |equipped Red Winter Hat##21524 |use Red Winter Hat##21524 |future |achieve 277
		.' During the Feast of Winter Veil, wear 3 pieces of winter clothing and eat Graccu's Mince Meat Fruitcake. |achieve 277 |use Graccu's Mince Meat Fruitcake##21215
	step
		goto Orgrimmar,50.2,62.1
		.' Use the Winter Wondervolt machine to turn into a Little Helper. If you don't have the buff active while killing players, you won't get credit.
		.' Do any type of PvP of your choice |tip You must be killing players that give you honor.
		.' Earn 50 honorable kills as a Little Helper from the Winter Wondervolt machine |achieve 252
	step
		'Make sure you have the following in your bags:
		.collect 3 Mistletoe##21519 |future |achieve 1282
		.collect 1 Preserved Holly##21213 |future |achieve 1282
	step
		goto 52.5,76.8
		.talk Penney Copperpinch##13420
		.buy 1 Snowball##17202 |future |achieve 259
	step
		goto 53.6,78.8
		.talk Innkeeper Gryshka##6929
		.home Orgrimmar
	step
		goto Thunder Bluff,60.3,51.7
		.' Use a snowball on Baine Bloodhoof |use Snowball##17202 |n
		.' Throw a snowball at Baine Bloodhoof during the Feast of Winter Veil |achieve 259
	step
		goto Undercity,50.8,21.7
		.' Use your Mistletoe on Brother Malach |use Mistletoe##21519 |modelnpc 5661
		.' Use Mistletoe on Brother Malach in the Undercity |achieve 1685/1
	step
		.' The following achievements require a level 70 or higher character.
		|confirm
	//UNLOCK DAILIES
	step
		goto Blade's Edge Mountains,28.7,57.4
		.talk Chu'a'lor##23233
		..accept The Trouble Below##11057
		..accept The Crystals##11025
	step
		goto 29.2,53.7
		.from Apexis Flayer##22175+
		.get 5 Apexis Shard |q 11025/1
	step
		goto 28.8,57.4
		.talk Chu'a'lor##23233
		..turnin The Crystals##11025
		..accept An Apexis Relic##11058
	step
		goto 28.4,57.6
		.talk Torkus##23316
		..accept Our Boy Wants To Be A Skyguard Ranger##11030
	step
		goto 33.1,52.3
		.from Gan'arg Analyzer##23386+
		.collect Apexis Shard##32569 |n
		.' Click an Apexis Relic |tip It looks like a small multi-colored crystal floating in the air.
		..' Insert an Apexis Shard to begin.
		.' Stand on the white globe and watch as the crystal floating above you casts a beam on the surrounding clusters
		.' Click the clusters in the same color pattern as the crystal |tip You must do this eight times. If you mess up you will be given a few chances to correct yourself before you have to start the process over.
		.' Attain the Apexis Emanations |q 11058/1
	step
		goto 51.1,15.6
		.from Bash'ir Arcanist##22243+, Bash'ir Spell-Thief##22242+, Bash'ir Raider##22241+
		.collect 10 Apexis Shard##32569 
	step
		goto 32.8,40.5
		.' Click the Fel Crystalforge |tip It looks like a big metal machine with green smoke coming out of it.
		.' Purchase 1 Unstable Flask of the Beast
		.get Unstable Flask of the Beast |q 11030/1
	step
		goto 28.8,57.4
		.talk Chu'a'lor##23233
		..turnin An Apexis Relic##11058
		..accept The Relic's Emanation##11080
	step
		goto 28.4,57.7
		.talk Torkus##23316
		..turnin Our Boy Wants To Be A Skyguard Ranger##11030
	step
		goto 27.7,68.1
		.from Gan'arg Analyzer##23386+
		.collect Apexis Shard##32569 |n
		.' Click an Apexis Relic |tip It looks like a small multi-colored crystal floating in the air.
		.' Insert an Apexis Shard to begin.
		.' Stand on the white globe and watch as the crystal floating above you casts a beam on the surrounding clusters
		.' Click the clusters in the same color pattern as the crystal |tip You must do this six times. If you mess up you will be given a few chances to correct yourself before you have to start the process over.
		.' Attain the Apexis Vibrations |q 11080/1
	step
		goto 28.8,57.4
		.talk Chu'a'lor##23233
		..turnin The Relic's Emanation##11080
		..accept The Skyguard Outpost##11062
	step
		goto 27.4,52.7
		.talk Sky Commander Keller##23334
		..turnin The Skyguard Outpost##11062
	//END UNLOCKING DAILIES
	step
		goto 27.6,52.9
		.talk Sky Sergeant Vanderlip##23120
		..accept Bombing Run##11010
	step
		goto 36.8,39.4
		.' While on your flying mount, use the Skyguard Bombs on Fel Cannonball Stacks |use Skyguard Bombs##32456
		.' Destroy 15 Fel Cannonball Stacks |q 11010/1
	step
		goto 27.6,52.9
		.talk Sky Sergeant Vanderlip##23120
		..turnin Bombing Run##11010
		..accept Bomb Them Again!##11023
	step
		'Use Preserved Holly while riding your flying mount |havebuff Interface\Icons\INV_Misc_Plant_03 |use Preserved Holly##21213
	step
		goto 36.8,39.4
		.' While on riding the Reindeer Mount, use the Skyguard Bombs on Fel Cannonball Stacks |use Skyguard Bombs##32456
		.' Destroy 15 Fel Cannonball Stacks |q 11023/1
	step
		goto 27.6,52.9
		.talk Sky Sergeant Vanderlip##23120
		..turnin Bomb Them Again!##11023 |tip You have to be on your mount when turning in the quest.
		.' Complete the Bomb Them Again! quest while mounted on a flying reindeer during the Feast of Winter Veil |achieve 1282
	//DALARAN
	step
		goto Borean Tundra 40.2,55.0
		.' Use your Mistletoe on Durkot Wolfbrother |use Mistletoe##21519
		.' Use Mistletoe on Durkot Wolfbrother in Warsong Hold |achieve 1685/2
		'|modelnpc 26044
	step
		goto Icecrown 60.6,34.9
		'Orgrim's Hammer flies in a triangular pattern using these points:
		.' Point 1: [60.6,34.9]
		.' Point 2: [68.0,52.5]
		.' Point 3: [68.9,27.0]
		.'Find Orgrim's Hammer flying around in the sky |tip On you world map, it looks like a ship icon with 2 long red-ish ballons on either side of it.
		.' Use your Mistletoe on Brother Keltan |use Mistletoe##21519 |tip He is a blood elf with gray hair and walks all around the Orgrim's Hammer airship.
		.' Use Mistletoe on Brother Keltan in Icecrown |achieve 1685/3
		'|modelnpc 31261
	step
		goto Dalaran,50.3,63.2
		.' Get the Winter Veil Disguise Kit from your mailbox |tip It should arrive within 24 hours after completing the Feast of Winter Veil quest section of this guide.
		.' Equip the Winter Veil Disguise Kit in your bag |use Winter Veil Disguise Kit##17712
		.' Dance with another player wearing their snowman costume |script DoEmote("DANCE")
		.' During the Feast of Winter Veil, use your Winter Veil Disguise kit to become a snowman and then dance with another snowman in Dalaran |achieve 1690
	step
		goto Orgrimmar,49.6,78.1
		.' This step can only be completed by logging into the server on December 25th.
		.' Click a present underneath the tree.
		.' Open one of the presents underneath the Winter Veil tree once they are available. |achieve 1689
		.' Earn the Achievement and Title Merrymaker! |achieve 1691
	step
		.' Click the presents under the tree on _December 25th_ and receive 
		.collect Gaudy Winter Veil Sweater##70923 |future |achieve 5854
		.' Go to Stormwind, use your Sweater to sing carol's |achieve 5854/4
		.' Go to Ironforge, use your Sweater to sing carol's |achieve 5854/3
		.' Go to The Exodar, use your Sweater to sing carol's |achieve 5854/2
		.' Go to Darnassus, use your Sweater to sing carol's |achieve 5854/1
	step
		.' Click the presents under the tree on _December 25th_ and receive 
		.' Crashin' Thrashin' Racer. 
		.' Gain 25 crashes with your racer |achieve 1295
]])


-- HALLOWS END --
ZygorGuidesViewer:RegisterInclude("Hallows_End_Quests_Horde",[[
	step
		goto Undercity,63.3,47.6
		.talk Forsaken Commoner##19178
		..accept A Season for Celebration##29400
		..accept Masked Orphan Matron##11357 |tip You may not be able to accept this quest.
	step
		goto Undercity,67.4,6.6
		.talk Spoops##15309 |tip He's up above the Undercity in the Ruins.
		..accept Hallow's End Treats for Spoops!##8312
	step
		goto Undercity,67.4,13.1
		.talk Darkcaller Yanka##15197
		..turnin A Season for Celebration##29400
	step
		goto 68.8,7.9
		.talk Candace Fenlow##53763
		..accept A Friend in Need##29431
	step
		goto Undercity,67.7,37.9
		.talk Innkeeper Norman##6741 |tip Back underneath in the Undercity.
		..accept Chicken Clucking for a Mint##8354
	step
		goto 67.7,37.9
		.' While targeting Innkeeper Norman:
		.' Cluck like a Chicken for Innkeeper Norman |script DoEmote("CHICKEN") |q 8354/1
	step
		goto 67.7,37.9
		.talk Innkeeper Norman##6741
		..turnin Chicken Clucking for a Mint##8354
	step
		goto Orgrimmar,32.9,65.1
		.talk Kali Remik##11814
		..accept Incoming Gumdrop##8358
	step
		goto 32.9,65.1
		.' While targeting Kali Remik:
		.' Make Train sounds for Kali Remik |script DoEmote("TRAIN") |q 8358/1
	step
		goto 32.9,65.1
		.talk Kali Remik##11814
		..turnin Incoming Gumdrop##8358
	step
		goto 53.6,78.8
		.talk Innkeeper Gryshka##6929
		..accept Flexing for Nougat##8359
	step
		goto 53.6,78.8
		.' While targeting Innkeeper Gryshka:
		.' Flex for Innkeeper Gryshka |script DoEmote("FLEX") |q 8359/1
	step
		goto 53.6,78.8
		.talk Innkeeper Gryshka##6929
		..turnin Flexing for Nougat##8359
	step
		goto Orgrimmar,54.4,77.6
		.talk Edgar Goodwin##54141
		..turnin A Friend in Need##29431
		..accept Missing Heirlooms##29415
	step
		goto Durotar,57.4,9.0
		.talk Hired Courier##54142
		..turnin Missing Heirlooms##29415
		..accept Fencing the Goods##29416
	step
		goto Orgrimmar,54.1,73.4
		.talk Auctioneer Drezmit##44866
		.' Follow the Thief's Trail and Question Auctioneer Drezmit |q 29416/1
	step
		goto 54.1,73.4
		.talk Auctioneer Drezmit##44866
		..turnin Fencing the Goods##29416
		..accept Shopping Around##29425
	step
		  goto 58.0,48.0
		.' Listen to the Dialogue
		.' Investigate Droffers and Son |q 29425/1
	step
		goto 58.0,48.4
		.talk Delian Sunshade##54146
		..turnin Shopping Around##29425
		..accept Taking Precautions##29426
	step
		goto 46.0,49.3
		.click Blood Nettle##10249
		.get 5 Blood Nettle |q 29426/3
		.' You can find more Blood Nettles here: [43.6,48.8]
	step
		goto 55.2,45.9
		.talk Kor'geld##3348
		.buy 5 Crystal Vial##3371 |q 29426/2
	step
		#include "auctioneer"
		.buy 2 Strange Dust##10940 |q 29426/1
	step
		goto 58.0,48.4
		.talk Delian Sunshade##54146
		..turnin Taking Precautions##29426
		..accept The Collector's Agent##29427
	step
		goto Thunder Bluff 45.8,64.7
		.talk Innkeeper Pala##6746
		..accept Dancing for Marzipan##8360
	step
		goto 45.8,64.7
		.' While targeting Innkeeper Pala:
		.' Dance for Innkeeper Pala |script DoEmote("DANCE") |q 8360/1
	step
		goto 45.8,64.7
		.talk Innkeeper Pala##6746
		..turnin Dancing for Marzipan##8360
	step
		goto Durotar,52.6,41.2
		.talk Masked Orphan Matron##23973
		..turnin Masked Orphan Matron##11357
		..accept Fire Training##11361
	step
		goto 52.5,41.3
		.' Click the Water Barrel |tip It looks like a huge bucket of water.
		.collect Water Bucket##32971 |q 11361
	step
		goto 49.3,43.5
		.' Use your Water Bucket on the burning scarecrows |use Water Bucket##32971
		.' Fight 5 Fires |q 11361/1
		.' Collect more Water Buckets from the Water Barrel at [49.2,44.5]
	step
		goto 52.6,41.2
		.talk Masked Orphan Matron##23973
		..' You will only be able to accept 1 of the 2 daily quests
		..turnin Fire Training##11361
		..accept Stop the Fires!##11219 |or
		..accept "Let the Fires Come!"##12139|or
	step
		goto 52.5,41.3
		.' Click the Water Barrel |tip It looks like a huge bucket of water.
		.collect Water Bucket##32971 |q 11219
	step
		goto 52.5,41.3
		.' Click the Water Barrel |tip It looks like a huge bucket of water.
		.collect Water Bucket##32971 |q 12139
	step
		goto 52.2,42.6
		.' Use your Water Bucket on the fires all around this area |use Water Bucket##32971
		.' Put Out the Fires |q 11219/1 |tip You will need a group of people to complete this quest.  It is best to do this quest at peak hours.
		.' Collect more Water Buckets from the Water Barrel at [52.5,41.3]
	step
		goto 52.2,42.6
		.' Wait until the fires appear on the buildings in Razor Hill
		.' Use your Water Bucket on the fires all around this area |use Water Bucket##32971
		.' Put Out the Fires |q 12139/1 |tip You will need a group of people to complete this quest.  It is best to do this quest at peak hours.
		.' Collect more Water Buckets from the Water Barrel at [52.5,41.3]
	step
		goto 52.6,42.4
		.' Click the Large Jack-o'-Lantern |tip It's a burning pumpkin laying in the road.
		..accept Smash the Pumpkin##12155
	step
		goto 52.6,41.2
		.talk Masked Orphan Matron##23973
		..' You will only be able to accept 1 of the 2 daily quests
		..turnin Stop the Fires!##11219 |or
		..turnin "Let the Fires Come!"##12139 |or
		..turnin Smash the Pumpkin##12155
	step
		goto Undercity,67.4,6.6
		.talk Spoops##15309 |tip He's up above the Undercity in the Ruins.
		..turnin Hallow's End Treats for Spoops!##8312
	step
		goto Tirisfal Glades,65.5,75.1
		.' This is in the Ruins, not below in Undercity
		.' Disrupt the Meeting |q 29427/1 |tip You will have to fight a Void Walkers here.
	step
		goto 65.8,74.8
		.click Stolen Crate##335
		..turnin The Collector's Agent##29427
		..accept What Now?##29428
	step
		goto Orgrimmar,54.4,77.6
		.talk Edgar Goodwin##54141
		..turnin What Now?##29428
	step
		goto 54.5,77.5
		.click Edgar's Crate##335
		..turnin The Creepy Crate##29429
		.' You will receive _Creepy Crate_ companion
		.collect 1 Creepy Crate##71076 |use Creepy Crate##71076 |n
		.learnpet Creepy Crate##54128
]])

ZygorGuidesViewer:RegisterInclude("Hallows_End_Dailies_Horde",[[
	step
		goto Durotar,52.6,41.2
		.talk Masked Orphan Matron##23973
		..' You will only be able to accept 1 of the 2 daily quests
		..accept Stop the Fires!##11219 |or
		..accept "Let the Fires Come!"##12139 |or
	step
		goto 52.5,41.3
		.' Click the Water Barrel |tip It looks like a huge bucket of water.
		.collect Water Bucket##32971 |q 11219
	step
		goto 52.2,42.6
		.' Use your Water Bucket on the fires all around this area |use Water Bucket##32971
		.' Put Out the Fires |q 11219/1 |tip You will need a group of people to complete this quest.  It is best to do this quest at peak hours.
		.' Collect more Water Buckets from the Water Barrel at [52.5,41.3]
	step
		goto 52.5,41.3
		.' Click the Water Barrel |tip It looks like a huge bucket of water.
		.collect Water Bucket##32971 |q 12139
	step
		goto 52.2,42.6
		.' Wait until the fires appear on the buildings in Razor Hill
		.' Use your Water Bucket on the fires all around this area |use Water Bucket##32971
		.' Put Out the Fires |q 12139/1 |tip You will need a group of people to complete this quest.  It is best to do this quest at peak hours.
		.' Collect more Water Buckets from the Water Barrel at [52.5,41.3]
	step
		goto 52.6,42.4
		.' Click the Large Jack-o'-Lantern |tip It's a burning pumpkin laying in the road.
		..accept Smash the Pumpkin##12155
	step
		goto 52.6,41.2
		.talk Masked Orphan Matron##23973
		..' You will only be able to accept 1 of the 2 daily quests
		..turnin Stop the Fires!##11219
		..turnin "Let the Fires Come!"##12139
		..turnin Smash the Pumpkin##12155
	step
		goto Undercity,67.4,13.0
		.talk Darkcaller Yanka##15197
		..accept A Time to Build Up##29376
		..accept A Time to Break Down##29377
	step
		goto 67.7,14.5
		.click Bonfire##200
		.' Use the Bonfire |q 29376/1
		.click Wickerman Ashes##06421
		.' Use the Wickerman Ashes |q 29376/2
	step
		goto 67.3,13.1
		.talk Darkcaller Yanka##15197
		..turnin A Time to Build Up##29376
	step
		goto 68.8,7.8
		.talk Candace Fenlow##53763
		..accept Clean Up in Undercity##29375
		..accept Stink Bombs Away!##29374  
	step
		'All around Undercity
		Run to the Orange Smoke and clean up the stink bombs |use Arcane Cleanser##70727
		.' Remove 10 Stink Bombs |q 29375/1
	step
		goto 68.8,7.9
		.talk Candace Fenlow##53763
		..turnin Clean Up in Undercity##29375
	step
		goto 67.5,9.2
		.talk Crina Fenlow##53764
		.' I'm ready to attack Stormwind! |invehicle
	step
		.' Use the _Toss Stink Bomb_ ability on your action bar all around _Stormwind_
		.' Drop 25 Stink Bombs |q 29374/1
		.' Click the _Return Home_ button on your action bar |outvehicle
	step
		goto 68.8,7.8
		.talk Candace Fenlow##53763
		..turnin Stink Bombs Away!##29374
	step
		goto Elwynn Forest,33.6,48.2
		.' Use the Dousing Agent in your Bags on the _Wickerman_ when you fly in front of _Stormwind_ |use Dousing Agent##68647
		.' Douse the Alliance's Wickerman |q 29377/1
	step
		goto Undercity,67.4,13.0
		.talk Darkcaller Yanka##15197
		..turnin A Time to Break Down##29377
	step
		'Congratulations,  you have earned the Achievement _Rotten Hollow_ |achieve 1041
]])

ZygorGuidesViewer:RegisterInclude("Hallows_End_Achievements_Horde",[[
	step
		goto Durotar,51.5,41.6
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Candy item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Durotar, Razor Hill |achieve 965/8
	step
		goto Orgrimmar,53.9,79.0
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Candy item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Orgrimmar, Valley of Strength |achieve 965/20
	step
		goto Azshara,57.1,50.2
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Candy item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Azshara, Bilgewater Harbor |achieve 965/5
	step
		goto Winterspring,59.8,51.2
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Candy item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Winterspring, Everlook |achieve 965/30
	step
		goto Felwood,44.7,29.0
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Candy item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Felwood, Whisperwind Grove |achieve 965/11
	step
		goto Ashenvale,74.0,60.6
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Candy item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Ashenvale, Splintertree Post |achieve 965/3
	step
		 goto Ashenvale,50.2,67.3
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Candy item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Ashenvale, Silverwind Refuge |achieve 965/2
	step
		goto Ashenvale,38.6,42.3
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Candy item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Ashenvale, Hellscream's Watch |achieve 965/1
	step
		 goto Ashenvale,13.0,34.1
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Candy item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Ashenvale, Zoram'gar Outpost |achieve 965/4
	step
		goto Stonetalon Mountains,50.4,63.8
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Candy item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Stonetalon Mountains, Sun Rock Retreat |achieve 965/25
	step
		goto Stonetalon Mountains,66.5,64.2
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Candy item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Stonetalon Mountains, Krom'gar Fortress |achieve 965/24
	step
		goto Northern Barrens,62.5,16.6
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Candy item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Stonetalon Mountains, Nozzlepot's Outpost |achieve 965/18
	step
		goto Northern Barrens,56.2,40.0
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Candy item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Stonetalon Mountains, Grol'dom Farm |achieve 965/17 |use Handful of Treats##37586
	step
		goto Northern Barrens,49.5,57.9 
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Candy item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Barrens, The Crossroads |achieve 965/16
	step
		  goto Northern Barrens,67.4,74.7
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Candy item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Barrens, Ratchet |achieve 965/19
	step
		goto Thunder Bluff,45.6,65.0
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Candy item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Thunder Bluff, Lower Rise |achieve 965/28
	step
		goto Mulgore,46.6,61.0
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Candy item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Mulgore, Bloodhoof Village |achieve 965/15
	step
		goto Southern Barrens,40.7,69.3
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Candy item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Southern Barrens, Desolation Hold |achieve 965/22
	step
		goto Southern Barrens,39.2,20.0
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Candy item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Southern Barrens, Hunter's Hill |achieve 965/23
	step
		goto Desolace,56.7,50.1
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Candy item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Desolace, Karnum's Glade |achieve 965/6
	step
		goto Desolace,24.1,68.3
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Candy item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Desolace, Shadowprey Village |achieve 965/7
	step
		goto Feralas,41.5,15.7
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Candy item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Feralas, Camp Ataya |achieve 965/12
	step
		goto Feralas,52.0,47.6
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Candy item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Feralas, Stonemaul Hold |achieve 965/14
	step
		goto Feralas,74.8,45.1
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Candy item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Desolace, Camp Mojache |achieve 965/13
	step
		goto Silithus,55.5,36.8
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Candy item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Silithus, Cenarion Hold |achieve 965/21
	step
		goto Un'Goro Crater,55.3,62.1
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Candy item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Un'Goro Crater, Marshal's Stand |achieve 965/29
	step
		goto Tanaris,52.6,27.1
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Candy item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Tanaris, Gadgetzan |achieve 965/27
	step
		 goto Tanaris,55.8,60.9
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Candy item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Tanaris, Bootlegger Outpost |achieve 965/26
	step
		goto Dustwallow Marsh 55.9,49.6
		.talk Zidormi##63546
		.' Ask her to show you Theramore before it's destruction.
		|confirm
	step
		goto Dustwallow Marsh,36.8,32.4
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Candy item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Dustwallow Marsh, Brackenwall Village |achieve 965/9
	step
		goto 41.9,74.1
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Candy item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Dustwallow Marsh, Mudsprocket |achieve 965/10
	step
		goto The Cape of Stranglethorn,40.9,74.0
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Candy item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in The Cape of Stranglethorn, Booty Bay |achieve 967/5
	step
		goto The Cape of Stranglethorn,35.0,27.2
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Candy item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in The Cape of Stranglethorn, Hardwrench Hideaway |achieve 967/6
	step
		goto Northern Stranglethorn,37.4,51.8
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Candy item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Stranglethorn Vale, Grom'gol Base Camp |achieve 967/15
	step
		goto Swamp of Sorrows,46.9,56.9
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Candy item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Swamp of Sorrows, Stonard |achieve 967/22
	step
		goto Swamp of Sorrows,71.6,13.8
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Candy item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Swamp of Sorrows, Bogpaddle |achieve 967/21
	step
		goto Badlands,18.4,42.7
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Candy item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Badlands, New Kargath |achieve 967/3
	step
		goto Badlands,65.8,35.6
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Candy item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Badlands, Fuselight |achieve 967/2
	step
		goto Searing Gorge,39.4,66.1
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Candy item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Searing Gorge, Iron Summit |achieve 967/16
	step
		goto Arathi Highlands,69.0,33.3
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Candy item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Arathi Highlands, Hammerfall |achieve 967/1
	step
		goto The Hinterlands,78.2,81.5
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Candy item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in The Hinterlands, Revantusk Village |achieve 967/14
	step
		goto The Hinterlands,31.8,57.9
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Candy item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Hinterlands, Hiri'watha Research Station |achieve 967/13
	step
		goto Eastern Plaguelands,75.6,52.3
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Candy item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Eastern Plaguelands, Light's Hope Chapel |achieve 967/7
	step
		goto Western Plaguelands,48.3,63.8
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Candy item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Western Plaguelands, Andorhal |achieve 967/26
	step
		goto Ghostlands,48.7,31.9
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Candy item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Ghostlands, Tranquillien |achieve 967/10
	step
		goto Eversong Woods,43.7,71.0
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Candy item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Eversong Woods, Fairbreeze Village |achieve 967/8
	step
		goto 48.2,47.9
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Candy item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Eversong Woods, Falconwing Square |achieve 967/9
	step
		goto Silvermoon City,67.6,72.9
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Candy item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Silvermoon, The Bazaar |achieve 967/17
	step
		goto 79.4,57.7
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Candy item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Silvermoon, The Royal Exchange |achieve 967/18
	step
		goto Undercity,67.8,37.4
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Candy item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Undercity, The Trade Quarter |achieve 967/25
	step
		goto Tirisfal Glades,61.0,51.4
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Candy item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Tirisfal Glades, Brill |achieve 967/23
	step
		goto Tirisfal Glades,83.0,72.1
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Candy item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Tirisfal Glades, The Bulwark |achieve 967/24
	step
		goto Silverpine Forest,44.3,20.3
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Candy item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Silverpine Forest, The Forsaken Rear Guard |achieve 967/19
	step
		goto Silverpine Forest,46.5,42.9
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Candy item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Silverpine Forest, The Sepulcher |achieve 967/20
	step
		goto Hillsbrad Foothills,57.9,47.3
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Candy item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Hillsbrad Foothills, Tarren Mill |achieve 967/12
	step
		goto Hillsbrad Foothills,60.3,63.7
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Candy item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Hillsbrad Foothills, Eastpoint Tower |achieve 967/11
	step
		goto Blasted Lands,40.4,11.3
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Candy item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Blasted Lands, Dreadmaul Hold |achieve 967/4
	step
		goto Hellfire Peninsula,56.8,37.4
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Candy item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Hellfire Peninsula, Thrallmar |achieve 968/5
	step
		goto 26.9,59.5
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Candy item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Hellfire Peninsula, Falcon Watch |achieve 968/4
	step
		goto Shattrath City,56.3,81.9
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Candy item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Shattrath City, Scryer's Tier |achieve 968/11
		only if rep ('The Scryers')>=Neutral
	step
		goto Shattrath City,28.2,49.1
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Candy item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Shattrath City, Aldor Rise |achieve 968/11
		only if rep ('The Aldor')>=Neutral
	step
		goto Terokkar Forest,48.7,45.2
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Candy item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Terokkar Forest, Stonebreaker Hold |achieve 968/12
	step
		goto Shadowmoon Valley,30.3,27.7
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Candy item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Shadowmoon Valley, Shadowmoon Village |achieve 968/10
	step
		goto 56.4,59.8
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Candy item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Shadowmoon Valley, Sanctum of the Stars |achieve 968/9
		only if rep ('The Scryers')>=Neutral
	step
		goto 61.0,28.2
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Candy item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Shadowmoon Valley, Altar of Sha'tar |achieve 968/9
		only if rep ('The Aldor')>=Neutral
	step
		goto Nagrand,56.7,34.5
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Candy item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Nagrand, Garadar |achieve 968/6
	step
		goto Zangarmarsh,30.6,50.9
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Candy item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Zangarmarsh, Zabra'jin |achieve 968/13
	step
		goto 78.5,62.9
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Candy item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Zangarmarsh, Cenarion Refuge |achieve 968/14
	step
		goto Blade's Edge Mountains,76.2,60.4
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Candy item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Blade's Edge Mountains, Mok'Nathal Village |achieve 968/2
	step
		goto 53.4,55.5
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Candy item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Blade's Edge Mountains, Thunderlord Stronghold |achieve 968/3
	step
		goto 62.9,38.3
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Candy item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Blade's Edge Mountains, Evergrove |achieve 968/1
	step
		goto Netherstorm,32.0,64.4
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Candy item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Netherstorm, Area 52 |achieve 968/7
	step
		goto 43.3,36.1
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Candy item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Netherstorm, The Stormspire |achieve 968/8
	step
		goto Borean Tundra 41.8,54.4
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Candy item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Borean Tundrea, Warsong Hold |achieve 5835/4
	step
		goto Borean Tundra 78.4,49.2
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Candy item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Borean Tundrea, Unu'pe |achieve 5835/3
	step
		goto Borean Tundra 76.7,37.4
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Candy item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Borean Tundrea, Taunka'le Village |achieve 5835/2
	step
		goto Borean Tundra 49.7,10.0
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Candy item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Borean Tundrea, Bor'gorok Outpost |achieve 5835/1
	step
		goto Sholazar Basin 26.6,59.2
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Candy item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Sholazar Basin, Nesingwary Base Camp |achieve 5835/18
	step
		goto Dragonblight 37.8,46.5
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Candy item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Dragonblight, Agmar's Hammer |achieve 5835/8
	step
		goto Dragonblight 48.1,74.7
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Candy item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Dragonblight, Moa'ki Harbor |achieve 5835/9
	step
		goto Dragonblight 76.8,63.2
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Candy item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Dragonblight, Venomspite |achieve 5835/10
	step
		goto Dragonblight 60.1,53.5
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Candy item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Dragonblight, Wyrmrest Temple |achieve 5835/11
	step
		goto Dalaran 48.3,41.1
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Candy item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Dalaran, The Legerdemain Lounge |achieve 5835/5
	step
		goto Dalaran 66.7,29.8
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Candy item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Dalaran, Sunreaver's Sanctuary |achieve 5835/6
	step
		'Enter The Underbelly here. |goto Dalaran 34.7,45.5 |c
	step
		goto Dalaran/2 38.0,60.1
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Candy item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Dalaran, The Underbelly |achieve 5835/7
	step
		Exit The Underbelly. |goto Dalaran/1 34.7,45.5 |c
	step
		goto The Storm Peaks 41.1,85.9
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Candy item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Storm Peaks, K3 |achieve 5835/22
	step
		goto The Storm Peaks 37.1,49.5
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Candy item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Storm Peaks, Grom'arsh Crash Site |achieve 5835/21
	step
		goto The Storm Peaks 30.9,37.2
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Candy item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Storm Peaks, Bouldercrag's Refuge |achieve 5835/19
	step
		goto The Storm Peaks 67.6,50.7
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Candy item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Storm Peaks, Camp Tunka'lo |achieve 5835/20
	step
		goto Zul'Drak 59.3,57.1
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Candy item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Zul'Drak, Zim'Torga |achieve 5835/24
	step
		goto Zul'Drak 40.8,65.9
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Candy item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Zul'Drak, The Argent Stand |achieve 5835/23
	step
		goto Grizzly Hills 20.9,64.7
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Candy item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Grizzly Hills, Conquest Hold |achieve 5835/13
	step
		goto Grizzly Hills 65.4,47.0
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Candy item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Grizzly Hills, Camp Oneqwah |achieve 5835/12
	step
		goto Howling Fjord 49.5,10.8
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Candy item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Howling Fjord, Camp Winterhoof |achieve 5835/14
	step
		goto Howling Fjord 79.2,30.6
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Candy item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Howling Fjord, Vengeance Landing |achieve 5835/17
	step
		goto Howling Fjord 52.1,66.2
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Candy item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Howling Fjord, New Agamand |achieve 5835/16
	step
		goto Howling Fjord 25.4,59.8
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Candy item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Howling Fjord, Kamagua |achieve 5835/15
	step
		goto Abyssal Depths 51.3,60.6
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Candy item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Vashj'ir, Tenebrous Cavern |achieve 5838/13
	step
		goto Shimmering Expanse 51.5,62.4
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Candy item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Vashj'ir, Legion's Rest |achieve 5838/11
	step
		goto Shimmering Expanse 49.2,41.9
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Candy item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Vashj'ir, Silver Tide Hollow |achieve 5838/12
	step
		goto Kelp'thar Forest 63.4,60.2
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Candy item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Vashj'ir, Deepmist Grotto |achieve 5838/10
	step
		goto Deepholm 51.1,50.0
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Candy item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Deepholm, Temple of Earth |achieve 5838/1
	step
		goto Mount Hyjal 63.0,24.1
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Candy item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Mount Hyjal, Nordrassil |achieve 5838/3
	step
		goto Mount Hyjal 42.7,45.6
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Candy item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Mount Hyjal, Shrine of Aviana |achieve 5838/4
	step
		goto Mount Hyjal 18.7,37.3
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Candy item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Mount Hyjal, Grove of Aessina |achieve 5838/2
	step
		goto Twilight Highlands 45.1,76.7
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Candy item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Twilight Highlands, Crushblow |achieve 5838/6
	step
		goto Twilight Highlands 53.4,42.9
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Candy item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Twilight Highlands, Bloodgulch |achieve 5838/5
	step
		goto Twilight Highlands 75.4,16.5
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Candy item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Twilight Highlands, The Krazzworks |achieve 5838/7
	step
		goto Uldum 54.7,33.0
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Candy item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Uldum, Ramkahen |achieve 5838/9
	step
		goto Uldum 26.6,7.3
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Candy item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Uldum, Oasis of Vir'sar |achieve 5838/8
	step
		'You must be at least level 90 to complete this step:
		.' Use the Dungeon Finder to queue for The Headless Horseman
		.from Headless Horseman##23682
		.' Complete the Bring Me The Head of... Oh Wait achievement |achieve 255
	step
		'Use your Tricky Treats 5 times in a row quickly |use Tricky Treat##33226 |tip You can get these by killing The Headless Horseman in the previous guide step, or from Hallow's End Candy Buckets.
		.' You will start puking :-)
		.' Complete the Out With It achievement |achieve 288
	step
		goto Undercity 67.7,6.5
		.talk Chub##53757
		.buy Tooth Pick##37604 |n
		.' Use your Tooth Pick |use Tooth Pick##37604
		.' Show off your sparkling smile by using a Tooth Pick |achieve 981
	step
		'Use your Weighted Jack-o'-Lanterns on the following races: |use Weighted Jack-o'-Lantern##34068 |tip You receive Weighted Jack-o'-Lanterns by doing the Hallow's End daily quests.  Make sure the player doesn't already have a jack-o-lantern on their head or you won't get credit.  The best place to complete this is in Dalaran, but it can be done anywhere in the world.
		.' Blood Elf |achieve 291/1
		.' Draenei |achieve 291/2
		.' Dwarf |achieve 291/3
		.' Gnome |achieve 291/4
		.' Goblin |achieve 291/5
		.' Human |achieve 291/6
		.' Night Elf |achieve 291/7
		.' Orc |achieve 291/8
		.' Tauren |achieve 291/9
		.' Troll |achieve 291/10
		.' Undead |achieve 291/11
		.' Worgen |achieve 291/12
	step
		'Have other players use Hallowed Wands on you while in a party to transform into the following:
		.' Transform into a Bat |achieve 283/1
		.' Transform into a Ghost |achieve 283/2
		.' Transform into a Leper Gnome |achieve 283/3
		.' Transform into a Ninja |achieve 283/4
		.' Transform into a Pirate |achieve 283/5
		.' Transform into a Skeleton |achieve 283/6
		.' Transform into a Wisp |achieve 283/7
	step
		goto Undercity 67.7,6.5
		.talk Chub##53757
		.buy 1 Sinister Squashling##33154 |n
		.buy 1 Hallowed Helm##33292 |n
		.' Use the Sinister Squashling |use Sinister Squashling##33154
		.' Obtain a Sinister Squashling pet |achieve 292/1
		.' Obtain a Hallowed Helm |achieve 292/2
	step
		'Use your G.N.E.R.D.S. |use G.N.E.R.D.S.##37583 |tip Use them every 30 minutes while PvPing to keep the buff on.  If you don't have the buff active while killing players, you won't get credit.
		.' Do any type of PvP of your choice |tip You must be killing players that give you honor.
		.' Earn 10 honorable kills while under the influence of the G.N.E.R.D. buff |achieve 1261
	step
		'Congratulations, you are now one of The Hallowed!
]])

ZygorGuidesViewer:RegisterInclude("Hallows_End_Achievements_Horde_Pandaria",[[
	step
		goto The Jade Forest 55.7,24.4
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Candy item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in The Jade Forest, Sri-La Village |achieve 7602/8
	step
		goto The Jade Forest 41.7,23.2
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Candy item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in The Jade Forest, Tian Monastery |achieve 7602/9
	step
		goto The Jade Forest 28.5,13.3
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Candy item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in The Jade Forest, Honeydew Village |achieve 7602/6
	step
		goto The Jade Forest 28.0,47.4
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Candy item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in The Jade Forest, Grookin Hill |achieve 7602/5
	step
		goto The Jade Forest 45.8,43.6
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Candy item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in The Jade Forest, Dawn's Blossom |achieve 7602/3
	step
		goto The Jade Forest 48.1,34.6
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Candy item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in The Jade Forest, Greenstone Village |achieve 7602/4
	step
		goto The Jade Forest 54.6,63.3
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Candy item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in The Jade Forest, Jade Temple Grounds |achieve 7602/7
	step
		goto Krasarang Wilds 75.9,6.9
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Candy item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Krasarang Wilds, Zhu's Watch |achieve 7602/13
	step
		goto Krasarang Wilds 61.0,25.1
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Candy item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Krasarang Wilds, Thunder Cleft |achieve 7602/12
	step
		goto Krasarang Wilds 51.4,77.3
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Candy item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Krasarang Wilds, Marista |achieve 7602/11
	step
		goto Krasarang Wilds 28.3,50.7
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Candy item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Krasarang Wilds, Dawnchaser Retreat |achieve 7602/10
	step
		goto Dread Wastes 55.2,71.2
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Candy item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Dread Wastes, Soggy's Gamble |achieve 7602/2
	step
		goto Dread Wastes 55.9,32.3
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Candy item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Dread Wastes, Klaxxi'vess |achieve 7602/1
	step
		goto Townlong Steppes 71.1,57.8
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Candy item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Townlong Steppes, Longying Outpost |achieve 7602/20
	step
		goto Kun-Lai Summit 72.7,92.3
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Treats item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Kun-Lai Summit, Binan Village |achieve 7602/14
	step
		goto Kun-Lai Summit 62.7,80.5
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Treats item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Kun-Lai Summit, Eastwind Rest |achieve 7602/15
	step
		goto Kun-Lai Summit 57.5,60.0
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Treats item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Kun-Lai Summit, One Keg |achieve 7602/17
	step
		goto Kun-Lai Summit 64.2,61.3
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Treats item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Kun-Lai Summit, The Grummle Bazaar |achieve 7602/16
	step
		goto Kun-Lai Summit 62.5,28.9
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Treats item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Kun-Lai Summit, Zouchin Village |achieve 7602/18
	step
		goto Shrine of Two Moons/2 58.4,77.3
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Treats item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Vale of Eternal Blossoms, Shrine of Two Moons |achieve 7602/22
	step
		goto Vale of Eternal Blossoms 35.1,77.7
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Treats item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Vale of Eternal Blossoms, Mistfall Village |achieve 7602/21
	step
		goto Valley of the Four Winds 19.9,55.8
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Treats item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Valley of the Four Winds, Stoneplow |achieve 7602/24
	step
		goto Valley of the Four Winds 83.7,20.2
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Treats item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Valley of the Four Winds, Pang's Stead |achieve 7602/23
	step
		 goto The Veiled Stair 55.0,72.2
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Treats item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in The Veiled Stair, Tavern in the Mists |achieve 7602/19
]])

-- PILGRIM'S BOUNTY --
ZygorGuidesViewer:RegisterInclude("Pilgrims_Bounty_Quests_Horde",[[
	step
		It's suggested that you have at least _300 skill level in Cooking_ before you begin the quests for this. Please refer to _Zygor's Cooking Guide_ for assistance in leveling up to 300 in Cooking.
		|confirm
	step
		goto Undercity,65.6,8.1
		.talk Bountiful Feast Hostess##34654
		..accept Sharing a Bountiful Feast##14065
	step
		goto 64.7,7.9
		.clicknpc The Turkey Chair##34812
		.' Use the first ability on your hotbar to Pass the food to other players who are sitting at the table |tip You must target the other players and use the Pass the Food ability.  Do this repeatedly until you get an achievement.
		.' Start a Food Fight! |achieve 3579
		.' Use the other abilities on your hotbar to eat the food |tip You will only be able to eat certain foods at each place on the table.  Once you eat the foods available to your spot 5 times, click the red arrow above your action bar to get out of the Turkey Chair.  Then, go sit in another Turkey Chair that has a type of food you haven't eaten yet.
		.' Eat each type of food 5 times in a row |tip You can see how many times you've eaten the food by looking at it's buff that it gives you next to your mini map.
		.' Gain the Spirit of Sharing |q 14065/1
	step
		goto 65.6,8.1
		.talk Bountiful Feast Hostess##34654
		..turnin Sharing a Bountiful Feast##14065
	step
		goto 63.2,8.9
		.talk Roberta Carter##34712
		.skillmax Cooking,75
		.learn Spice Bread##37836
	step
		goto 63.9,11.1
		.talk Rose Standish##34683
		.buy Bountiful Cookbook##46810
	step
		'Use your Bountiful Cookbook |use Bountiful Cookbook##46810
		.collect Recipe: Spice Bread Stuffing##46803
		.collect Recipe: Pumpkin Pie##46804
		.collect Recipe: Cranberry Chutney##46805
		.collect Recipe: Candied Sweet Potato##46806
		.collect Recipe: Slow-Roasted Turkey##46807
	step
		.' Use your Recipe: Spice Bread Stuffing to learn the recipe |use Recipe: Spice Bread Stuffing##46803
		.learn Spice Bread Stuffing##66038
	step
		goto 63.9,11.5
		.talk Miles Standish##34677
		..accept Spice Bread Stuffing##14037
	step
		goto 63.9,11.1
		.talk Rose Standish##34683
		.buy 10 Simple Flour##30817
		.buy 10 Mild Spices##2678
		.buy 10 Autumnal Herbs##44835
	step
		goto Undercity,63.2,8.3
		.' Cook next to the Pilgrim's Bounty Cooking Fire
		.create 10 Spice Bread##37836,Cooking,10 total
	step
		goto Undercity,63.2,8.3
		.' Cook next to the Pilgrim's Bounty Cooking Fire
		.create 10 Spice Bread Stuffing##66038,Cooking,10 total |q 14037/1
		.get 10 Spice Bread Stuffing |q 14037/2
	step
		|skill Cooking,100
		.' If you need to train your Cooking skill to allow a higher max level, talk to Roberta Carter at [63.2,8.9]
		|confirm
	step
		.' Use your Recipe: Pumpkin Pie to learn the recipe |use Recipe: Pumpkin Pie##46804 |tip You will need to be at least 100 in Cooking to learn this.
		.learn Pumpkin Pie##66036
	step
		goto 65.3,14.3
		.talk William Mullins##34768
		..turnin Spice Bread Stuffing##14037
		..accept Pumpkin Pie##14040
	step
		goto 63.9,11.1
		.talk Rose Standish##34683
		.buy 5 Ripe Tirisfal Pumpkin##46796+
		.buy 5 Honey##44853
	step
		goto Undercity,63.2,8.3
		.' Cook next to the Pilgrim's Bounty Cooking Fire
		.create 5 Pumpkin Pie##66036,Cooking,5 total |q 14040/1
		.get 5 Pumpkin Pie |q 14040/2
	step
		|skill Cooking,160
		.' If you need to train your Cooking skill to allow a higher max level, talk to Roberta Carter at [63.2,8.9]
		|confirm
	step
		.' Use your Recipe: Cranberry Chutney to learn the recipe |use Recipe: Cranberry Chutney##46805 |tip You will need to be at least 160 in Cooking to learn this.
		.learn Cranberry Chutney##66035
	step
		goto Durotar 46.6,13.8
		.talk Francis Eaton##34679
		..turnin Pumpkin Pie##14040
		..accept Cranberry Chutney##14041
	step
		goto 46.6,13.8
		.talk Dalni Tallgrass##34685
		.buy 10 Tangy Southfury Cranberries##46793+
		.buy 10 Honey##44853
	step
		goto Durotar,46.4,13.8
		.' Cook next to the Pilgrim's Bounty Cooking Fire
		.create 10 Cranberry Chutney##66035,Cooking,10 total |q 14041/1
		.get 10 Cranberry Chutney |q 14041/2
	step
		.clicknpc The Turkey Chair##34812
		.' Eat each type of food 5 times in a row |tip You can see how many times you've eaten the food by looking at it's buff that it gives you next to your mini map.
		.' Gain the Spirit of Sharing |achieve 3557/1
	step
		goto Thunder Bluff,30.9,63.7
		.talk Dokin Farplain##34678
		..turnin Cranberry Chutney##14041
		..accept Candied Sweet Potatoes##14043
	step
		|skill Cooking,220
		.' If you need to train your Cooking skill to allow a higher max level, talk to Mahara Goldwheat at [30.8,69.6]
		|confirm
	step
		.' Use your Recipe: Candied Sweet Potatoes to learn the recipe |use Recipe: Candied Sweet Potatoes##46806 |tip You will need to be at least 160 in Cooking to learn this.
		.learn Candied Sweet Potatoes##66034
	step
		goto 31.1,63.4
		.talk Laha Farplain##34684
		.buy 5 Mulgore Sweet Potato##46797
		.buy 5 Honey##44853
		.buy 5 Autumnal Herbs##44835
	step
		goto Thunder Bluff,30.5,70.1
		.' Cook next to the Pilgrim's Bounty Cooking Fire
		.create 5 Candied Sweet Potatoes##66034,Cooking,5 total |q 14043/1
		.get 5 Candied Sweet Potatoes |q 14043/2
	step
		|skill Cooking,280
		.' If you need to train your Cooking skill to allow a higher max level, talk to Mahara Goldwheat at [31.0,69.8]
		|confirm
	step
		.' Use your Recipe: Slow-roasted Turkey to learn the recipe |use Recipe: Candied Sweet Potatoes##46807 |tip You will need to be at least 160 in Cooking to learn this.
		.learn Slow-Roasted Turkey##66037
	step
		goto 29.9,62.7
		.clicknpc The Turkey Chair##34812
		.' Eat each type of food 5 times in a row |tip You can see how many times you've eaten the food by looking at it's buff that it gives you next to your mini map.
		.' Gain the Spirit of Sharing |achieve 3557/3
	step
		goto Durotar,46.6,13.8
		.talk Francis Eaton##34679
		..turnin Candied Sweet Potatoes##14043
		..accept Undersupplied in the Undercity##14044
	step
		goto Undercity,63.9,11.5
		.talk Miles Standish##34677
		..turnin Undersupplied in the Undercity##14044
		..accept Slow-roasted Turkey##14047
	step
		goto Tirisfal Glades,62.2,56.4
		.from Wild Turkey##32820+ |tip You can find these all around Tirisfal Glades, so you are not limited to staying in this area.  Ride around Tirisfal Glades and look for Wild Turkeys, you should be able to find them easily if you ride around.
		.collect 20 Wild Turkey##44834 |q 14047
	step
		goto Undercity,63.9,11.1
		.talk Rose Standish##34683
		.buy 10 Honey##44853
		.buy 5 Autumnal Herbs##44835
	step
		goto Undercity,63.1,8.3
		.' Cook next to the Pilgrim's Bounty Cooking Fire
		.create 5 Slow-Roasted Turkey##66037,Cooking,5 total |q 14047/1
		.get 5 Slow-Roasted Turkey |q 14047/2
		|skill Cooking,300
		.' If you need to train your Cooking skill to allow a higher max level, talk to Roberta Carter at [63.2,8.9]
	step
		goto Durotar,46.6,13.8
		.talk Francis Eaton##34679
		..turnin Slow-roasted Turkey##14047
]])

ZygorGuidesViewer:RegisterInclude("Pilgrims_Bounty_Achievements_Horde",[[
	step
	label start
		goto Eversong Woods,55.7,53.2
		.clicknpc The Turkey Chair##34812
		.' Eat each type of food 5 times in a row |tip You can see how many times you've eaten the food by looking at it's buff that it gives you next to your mini map.
		.' Gain the Spirit of Sharing |achieve 3557/2
		.' Earn the Pilgrim's Paunch Achievement. |achieve 3557/2
	step
		'While still at the table, go to each of the chairs.
		.' While in each of the chairs, press 1.
		.' Pass the Candied Sweet Potatoes. |achieve 3558/1
		.' Pass the Cranberry Chutney. |achieve 3558/2
		.' Pass the Pumpkin Pie. |achieve 3558/3
		.' Pass the Slow-Roasted Turkey. |achieve 3558/4
		.' Pass the Spice Bread Stuffing. |achieve 3558/5
		.' Earn the Sharing is Caring Achievement. |achieve 3558
	step
		goto Undercity,65.2,14.2
		.talk William Mullins##34768
		.accept She Says Potato##14058
	step
		goto Undercity,63.2,9.0
		.talk Roberta Carter##34712
		.accept We're Out of Cranberry Chutney Again?##14059
	step
		goto 63.9,11.1
		.talk Rose Standish##34683
		.buy 20 Ripe Tirisfal Pumpkin##46796 
		.buy 20 Simple Flour##30817
		.buy 20 Mild Spices##2678 
		.buy 20 Autumnal Herbs##44835
	step
		goto Tirisfal Glades,62.2,56.4
		.from Wild Turkey##32820+ |tip You can find these all around Tirisfal Glades, so you are not limited to staying in this area.  Ride around Tirisfal Glades and look for Wild Turkeys, you should be able to find them easily if you ride around.
		.collect 20 Wild Turkey##44834
	step
		goto Durotar,46.4,13.9
		.talk Ondani Greatmill##34713
		.accept Can't Get Enough Turkey##14061
		.accept Don't Forget The Stuffing!##14062
	step
		goto Durotar,46.6,13.8
		.talk Dalni Tallgrass##34685
		.buy 20 Tangy Southfury Cranberries##46793
	step
		goto Thunder Bluff,31.0,63.3
		.talk Laha Farplain##34684
		.buy 20 Mulgore Sweet Potato##46797
		.buy 20 Honey##44853
	step
		goto Thunder Bluff,30.9,69.7
		.talk Mahara Goldwheat##34714
		.accept Easy As Pie##14060
	step
		goto Thunder Bluff,30.5,70.2
		.' Cook next to the Pilgrim's Bounty Cooking Fire
		.create 20 Pumpkin Pie##66036,Cooking,20 total |q 14060/1
	step
		goto Thunder Bluff,30.9,69.7
		.talk Mahara Goldwheat##34714
		.turnin Easy As Pie##14060 |achieve 3597/3
		..collect Pilgrim's Hat##46723
		..' You need the hat for a later achievement.
	step
		goto Durotar,46.4,13.9
		.' Cook next to the Pilgrim's Bounty Cooking Fire
		.create 20 Spice Bread##37836,Cooking,20 total |n
		.create 20 Spice Bread Stuffing##66038,Cooking,20 total |q 14062/1
	step
		goto Durotar,46.6,13.8
		.talk Dalni Tallgrass##34685
		.buy 40 Honey##44853
		.buy 20 Autumnal Herbs##44835
	step
		goto 46.4,13.9
		.' Cook next to the Pilgrim's Bounty Cooking Fire
		.create 20 Slow-Roasted Turkey##66037+,Cooking,20 total |q 14061/1
	step
		goto Durotar,46.4,13.9
		.talk Ondani Greatmill##34713
		.turnin Can't Get Enough Turkey##14061 |achieve 3597/1
		..collect Pilgrim's Attire##46800 |tip You only need this, the Dress or the Robes, not all 3. |or
		..collect Pilgrim's Dress##44785 |tip You only need this, the Attire or the Robes, not all 3. |or
		..collect Pilgrim's Robe##46824 |tip You only need this, the Attire or the Dress, not all 3. |or
	step
		goto Durotar,46.4,13.9
		.talk Ondani Greatmill##34713
		.turnin Don't Forget The Stuffing!##14062 |achieve 3597/2
		..collect Turkey Shooter##44812 |tip Collect Turkey Shooters.  You will need at least 8 for an Achievement.
	step
		goto Undercity,63.9,11.1
		.talk Rose Standish##34683
		.buy 40 Honey##44853
		.buy 20 Autumnal Herbs##44835
	step
		goto Undercity,63.2,8.4
		.' Cook next to the Pilgrim's Bounty Cooking Fire
		.create 20 Candied Sweet Potato##66034,Cooking,20 total |q 14058/1
	step
		goto Undercity,63.2,8.4
		.' Cook next to the Pilgrim's Bounty Cooking Fire
		.create 20 Cranberry Chutney##66035,Cooking,20 total |q 14059/1
	step
		goto Undercity,63.2,8.9
		.talk Roberta Carter##34712
		.turnin We're Out of Cranberry Chutney Again?##14059 |achieve 3597/5
		..collect Turkey Shooter##44812 |tip Collect Turkey Shooters.  You will need at least 8 for an Achievement.
	step
		goto 65.2,14.2
		.talk William Mullins##34768
		.turnin She Says Potato##14058 |achieve 3597/4
		..collect Turkey Shooter##44812 |tip Collect Turkey Shooters.  You will need at least 8 for an Achievement.
	step
		.' Earn the Pilgrim's Progress Achievement. |achieve 3597
	step
		goto Tirisfal Glades,62.5,57.8
		.' You will need to fly around Tirisfal Glades.  You have to kill 40 turkeys without letting your Turkey Tracker Buff expire.  You will be given 30 seconds for each kill to find a new turkey.
		.kill Wild Turkey##32820+ |n
		.' Earn the Turkinator Achievement. |achieve 3578
	step
		goto Terokkar Forest,44.9,65.6 |n
		.' Fly down to the lower level of the ring
		.' Go through the swirling portal. |goto Sethekk Halls|noway|c
	step
		.' Fight to the end of the Instance.
		.' Before Engaging Talon King Ikiss, equip
		.' Equip Pilgrim's Attire |equipped Pilgrim's Attire##46800 |use Pilgrim's Attire##46800 |or 
		.' Equip Pilgrim's Dress |equipped Pilgrim's Dress##44785 |use Pilgrim's Dress##44785 |or
		.' Equip Pilgrim's Robe |equipped Pilgrim's Robe##46824 |use Pilgrim's Robe##46824  |or
		.' Equip Pilgrim's Hat |equipped Pilgrim's Hat##46723 |use Pilgrim's Hat##46723
		.' Kill Talon King Ikiss while wearing these items.
		|modelnpc Talon King Ikiss##18473
		.' Earn the Terokkar Turkey Time Achievement. |achieve 3582
	step
		goto Durotar 46.4,14.6
		.' Equip Pilgrim's Attire |equipped Pilgrim's Attire##46800 |use Pilgrim's Attire##46800 |or 
		.' Equip Pilgrim's Dress |equipped Pilgrim's Dress##44785 |use Pilgrim's Dress##44785 |or
		.' Equip Pilgrim's Robe |equipped Pilgrim's Robe##46824 |use Pilgrim's Robe##46824  |or
		.clicknpc The Turkey Chair##34812
		.' Take a seat at a Orgrimmar Bountiful Table. |achieve 3557/1
	step
		goto Thunder Bluff,29.1,62.5
		.' Equip Pilgrim's Attire |equipped Pilgrim's Attire##46800 |use Pilgrim's Attire##46800 |or 
		.' Equip Pilgrim's Dress |equipped Pilgrim's Dress##44785 |use Pilgrim's Dress##44785 |or
		.' Equip Pilgrim's Robe |equipped Pilgrim's Robe##46824 |use Pilgrim's Robe##46824  |or
		.clicknpc The Turkey Chair##34812
		.' Take a seat at the Thunder Bluff Bountiful Table. |achieve 3557/3
	step
		goto Eversong Woods/0 55.5,53.1
		.' Equip Pilgrim's Attire |equipped Pilgrim's Attire##46800 |use Pilgrim's Attire##46800 |or 
		.' Equip Pilgrim's Dress |equipped Pilgrim's Dress##44785 |use Pilgrim's Dress##44785 |or
		.' Equip Pilgrim's Robe |equipped Pilgrim's Robe##46824 |use Pilgrim's Robe##46824  |or
		.clicknpc The Turkey Chair##34812
		.' Take a seat at the Silvermoon City Bountiful Table. |achieve 3557/2
	step
		goto Undercity/0 67.6,14.5
		.' Equip Pilgrim's Attire |equipped Pilgrim's Attire##46800 |use Pilgrim's Attire##46800 |or 
		.' Equip Pilgrim's Dress |equipped Pilgrim's Dress##44785 |use Pilgrim's Dress##44785 |or
		.' Equip Pilgrim's Robe |equipped Pilgrim's Robe##46824 |use Pilgrim's Robe##46824  |or
		.clicknpc The Turkey Chair##34812
		.' Take a seat at the Undercity Bountiful Table. |achieve 3557/4
	step
		.' Earn the Pilgrim's Paunch Achievement. |achieve 3557
	step
		.' You should have a few _Turkey Shooters_ from your daily quests, if you don't, you will need to do more daily's when possible for more.
		.' While in Dun Morogh, shoot Alliance Rogues with your Turkey Shooter. |use Turkey Shooter##44812
		.' Shoot a Dwarf Rogue |achieve 3559/2
		.' Shoot a Gnome Rogue |achieve 3559/3
		.' Shoot a Human Rogue |achieve 3559/5
		.' Shoot a Night Elf Rogue |achieve 3559/6
		.' Shoot a Worgen Rogue |achieve 3559/10
	step
		goto Durotar,46.2,15.1
		'You should have a few _Turkey Shooters_ from your daily quests, if you don't, you will need to do more daily's when possible for more.
		.' While in Durotar, shoot Horde Rogues with your Turkey Shooter. |use Turkey Shooter##44812
		.' Shoot a Blood Elf Rogue |achieve 3559/1
		.' Shoot a Orc Rogue |achieve 3559/7
		.' Shoot a Troll Rogue |achieve 3559/8
		.' Shoot a Undead Rogue |achieve 3559/9
		.' Shoot a Goblin Rogue |achieve 3559/4
	step
		.' You have reached the End of this guide, you can only do the Dailies Once per day.
		Click here to continue. |confirm always
		|next "end" |only if achieved(3656)
		|next "start" |only if not achieved(3656)
	step
	label	"end"
		.' Congratualtions, you have earned the Pilgrim Achievement!
]])

ZygorGuidesViewer:RegisterInclude("Pilgrims_Bounty_Dailies",[[
	step
	label daily
		goto Undercity,65.2,14.2
		.talk William Mullins##34768
		.accept She Says Potato##14058
	step
		goto Undercity,63.2,9.0
		.talk Roberta Carter##34712
		.accept We're Out of Cranberry Chutney Again?##14059
	step
		goto 63.9,11.1
		.talk Rose Standish##34683
		.buy 20 Ripe Tirisfal Pumpkin##46796
		.buy 20 Simple Flour##30817
		.buy 20 Mild Spices##2678
		.buy 20 Autumnal Herbs##44835
		|confirm always
	step
		goto Tirisfal Glades,62.2,56.4
		.from Wild Turkey##32820+ |tip You can find these all around Tirisfal Glades, so you are not limited to staying in this area.  Ride around Tirisfal Glades and look for Wild Turkeys, you should be able to find them easily if you ride around.
		.collect 20 Wild Turkey##44834 |n
		|confirm always
	step
		goto Durotar,46.4,13.9
		.talk Ondani Greatmill##34713
		.accept Can't Get Enough Turkey##14061
		..accept Don't Forget The Stuffing!##14062
	step
		goto Durotar,46.6,13.8
		.talk Dalni Tallgrass##34685
		.buy 20 Tangy Southfury Cranberries##46793
	step
		goto Thunder Bluff,31.0,63.3
		.talk Laha Farplain##34684
		.buy 20 Mulgore Sweet Potato##46797
		.buy 20 Honey##44853
	step
		goto Thunder Bluff,30.9,69.7
		.talk Mahara Goldwheat##34714
		.accept Easy As Pie##14060
	step
		.create 20 Pumpkin Pie##66036,Cooking,20 total |q 14060/1
	step
		goto Thunder Bluff,30.9,69.7
		.talk Mahara Goldwheat##34714
		.turnin Easy As Pie##14060
		..collect Turkey Shooter##44812 |tip Collect Turkey Shooters.  You will need at least 8 for an Achievement.
	step
		goto Durotar,46.4,13.9
		.create 20 Spice Bread##37836,Cooking,20 total |n
		.create 20 Spice Bread Stuffing##66038,Cooking,20 total |q 14062/1
	step
		goto Durotar,46.6,13.8
		.talk Dalni Tallgrass##34685
		.buy 40 Honey##44853
		.buy 20 Autumnal Herbs##44835
	step
		goto 46.4,13.9
		.create 20 Slow-Roasted Turkey##66037+,Cooking,20 total |q 14061/1
	step
		goto Durotar,46.4,13.9
		.talk Ondani Greatmill##34713
		.turnin Can't Get Enough Turkey##14061 |achieve 3597/1
		..collect Turkey Shooter##44812 |tip Collect Turkey Shooters.  You will need at least 8 for an Achievement.
	step
		goto Durotar,46.4,13.9
		.talk Ondani Greatmill##34713
		.turnin Don't Forget The Stuffing!##14062 |achieve 3597/2
		..collect Turkey Shooter##44812 |tip Collect Turkey Shooters.  You will need at least 8 for an Achievement.
	step
		.' Go into Orgrimmar. |goto Orgrimmar|noway |c
	step
		goto Undercity,63.9,11.1
		.talk Rose Standish##34683
		.buy 40 Honey##44853
		.buy 20 Autumnal Herbs##44835
	step
		goto Undercity,63.2,8.4
		.create 20 Candied Sweet Potato##66034,Cooking,20 total |q 14058/1
	step
		.create 20 Cranberry Chutney##66035,Cooking,20 total |q 14059/1
	step
		goto Undercity,63.2,8.9
		.talk Roberta Carter##34712
		.turnin We're Out of Cranberry Chutney Again?##14059 |achieve 3597/5
		..collect Turkey Shooter##44812 |tip Collect Turkey Shooters.  You will need at least 8 for an Achievement.
	step
		goto 65.2,14.2
		.talk William Mullins##34768
		.turnin She Says Potato##14058 |achieve 3597/4
		..collect Turkey Shooter##44812 |tip Collect Turkey Shooters.  You will need at least 8 for an Achievement.
	step
		goto Elwynn Forest,34.7,50.6
		.' For the achievement Turkey Lurkey, you have to hit 8 difference races of rogues with the Turkey shooter.
		.use Turkey Shooter##44812
		.' Shoot a Dwarf Rogue |achieve 3559/2
		.' Shoot a Gnome Rogue |achieve 3559/3
		.' Shoot a Human Rogue |achieve 3559/4
		.' Shoot a Night Elf Rogue |achieve 3559/5
		.' You can look for the get a maximum of 5 Turkey Shooters per day, so it will take 2 days to do this if you don't have any already.
	step
		goto Durotar,46.5,14.6
		.' For the achievement Turkey Lurkey, you have to hit 8 difference races of rogues with the Turkey shooter.
		.' Shoot a Blood Elf Rogue |achieve 3559/1
		.' Shoot a Orc Rogue |achieve 3559/6
		.' Shoot a Troll Rogue |achieve 3559/7
		.' Shoot an Undead Rogue |achieve 3559/8
		.' You can look for the get a maximum of 5 Turkey Shooters per day, so it will take 2 days to do this if you don't have any already.
		.' Click here to go to the start of the Daily quests. |next "daily" |confirm |only if not achieved(3559)
		|next "finish" |only if achieved(3656)
	step
	label finish
		'Congratulations, you have completed the Pilgrim achievement!
]])

-- MIDSUMMER --
ZygorGuidesViewer:RegisterInclude("Midsummer_Quests",[[
	step
		goto Orgrimmar 53.6,78.8
		.talk Innkeeper Gryshka##6929
		.home Orgrimmar
	step
		goto Mulgore 51.8,59.3
		.talk Mulgore Flame Keeper##25936
		..accept Honor the Flame##11852 |instant
	step
		goto 51.7,59.5
		.talk Flame Eater##25994
		..accept Playing with Fire##11915
	step
		goto Thunder Bluff 40.8,56.1
		.talk Tauren Commoner##19176
		..accept The Spinner of Summer Tales##11971
	step
		goto 21.6,27.7
		.talk Festival Talespinner##16818
		..turnin The Spinner of Summer Tales##11971
		..accept Incense for the Festival Scorchlings##11966
	step
		goto 21.0,26.4
		.talk Master Flame Eater##26113
		..turnin Playing with Fire##11915
		..accept Torch Tossing##11922
	step
		'Use your Practice Torches in your bags and throw them at the Torch Target Braziers nearby |use Practice Torches##34862 |tip You must throw the torches at the correct braziers.  Throw the torches at the Torch Target Braziers when they have a floating red arrow point down above them.
		.' Hit 8 braziers |q 11922/1
	step
		goto 21.0,26.4
		.talk Master Flame Eater##26113
		..turnin Torch Tossing##11922
		..accept Torch Catching##11923
	step
		goto 21.8,27.3
		.' Use your Unlit Torches in your bags next to the bonfire |use Unlit Torches##34833
		.' As soon as you light torch, it will fly in the air.  There will be a small round shadow on the ground indicating where the torch is flying.  Follow that shadow and catch the torch.  When you catch the torch, it will be thrown in the air again.  Follow the shadow again and catch the torch.  Do this until you've caught the torch 4 times in a row without it hitting the ground.
		.' Catch 4 torches in a row. |q 11923/1
	step
		goto 21.0,26.4
		.talk Master Flame Eater##26113
		..turnin Torch Catching##11923
	step
		goto 21.2,24.0
		.talk Earthen Ring Elder##26221
		..accept Unusual Activity##11886
	step
		goto Southern Barrens,40.9,67.8
		.talk Southern Barrens Flame Keeper##51587
		..accept Honor the Flame##28927 |instant
	step
		goto 48.3,72.4
 		.click Alliance Bonfire##7734 
		..accept Desecrate this Fire!##28913 |instant
	step
		goto Dustwallow Marsh 33.5,30.9
		.talk Festival Scorchling##26520
		..turnin Incense for the Festival Scorchlings##11966
	step
		goto 33.4,30.9
		.talk Dustwallow Marsh Flame Keeper##25930
		..accept Honor the Flame##11847 |instant
	step
		goto 62.1,40.3
		.click Alliance Bonfire##7734 
		..accept Desecrate this Fire!##11744 |instant
	step
		goto Tanaris 49.8,27.9
		.talk Tanaris Flame Keeper##25921
		..accept Honor the Flame##11838 |instant
	step
		goto 52.7,30.1
 		.click Alliance Bonfire##7734 
		..accept Desecrate this Fire!##11762 |instant
	step
		goto Un'Goro Crater 60.0,62.9
		.click Alliance Bonfire##7734
		..accept Desecrate this Fire!##28921 |instant
	step
		goto Un'Goro Crater 56.0,66.0
		.talk Un'Goro Flame Keeper##51607
		..accept Honor the Flame##28933 |instant
	step
		goto Silithus,50.9,41.3
		.talk Silithus Flame Keeper##25919
		..accept Honor the Flame##11836 |instant
	step
		goto 60.6,33.2
 		.click Alliance Bonfire##7734 
		..accept Desecrate this Fire!##11760 |instant
	step
		goto Feralas 72.4,47.8
		.talk Feralas Flame Keeper##25932
		..accept Honor the Flame##11849 |instant
	step
		goto 46.6,43.8
 		.click Alliance Bonfire##7734 
		..accept Desecrate this Fire!##11746 |instant
	step
		goto Desolace,26.2,76.9
		.talk Desolace Flame Keeper##25928
		..accept Honor the Flame##11845 |instant
	step
		goto 65.8,16.9
 		.click Alliance Bonfire##7734 
		..accept Desecrate this Fire!##11741 |instant
	step
		goto Stonetalon Mountains,38.2,68.3 |n
		.' The path up to Sun Rock Retreat starts here |goto Stonetalon Mountains,42.5,68.6,0.5 |noway |c
	step
		goto 52.9,62.5
		.talk Stonetalon Flame Keeper##25940
		..accept Honor the Flame##11856 |instant
	step
		goto Northern Barrens 50.0,54.6
		.talk The Northern Barrens Flame Keeper##25943
		..accept Honor the Flame##11859 |instant
	step
		goto Durotar 52.2,47.3
		.talk Durotar Flame Keeper##25929
		..accept Honor the Flame##11846 |instant
	step
		goto Winterspring 58.1,47.5
		.talk Winterspring Flame Keeper##25922
		..accept Honor the Flame##11839 |instant
	step
		goto 61.3,47.1
 		.click Alliance Bonfire##7734 
		..accept Desecrate this Fire!##11763 |instant
	step
		 goto Ashenvale 51.4,66.2
		.talk Ashenvale Flame Keeper##25884
		..accept Honor the Flame##11841 |instant
	step
		goto 86.8,41.4
 		.click Alliance Bonfire##7734 
		..accept Desecrate this Fire!##11734 |instant
	step
		goto Ashenvale 15.3,20.1
		.from Twilight Firesworn##25863+, Twilight Flameguard##25866+
		.get Twilight Correspondence |q 11886/1
	step
		goto 15.7,20.3
		.' Use your Totemic Beacon next to the blue bonfire |use Totemic Beacon##35828
		.talk Earthen Ring Guide##25324
		..turnin Unusual Activity##11886
		..accept An Innocent Disguise##11891
	step
		goto 9.6,13.2
		.' Use your Orb of the Crawler in this spot |use Orb of the Crawler##35237
		.' Get the Crab Disguise |havebuff Interface\Icons\Ability_Hunter_Pet_Crab
		|confirm
	step
		goto 9.2,12.6
		'While in the crab disguise follow this path.
		.' Listen to the plan of the Twilight Cultists |q 11891/1
	step
		goto 9.7,13.3
		.' Use your Totemic Beacon next to the blue bonfire |use Totemic Beacon##35828
		.talk Earthen Ring Guide##25324
		..turnin An Innocent Disguise##11891
		..accept Inform the Elder##12012
	step
		goto Darkshore 48.9,22.6
 		.click Alliance Bonfire##7734 
		..accept Desecrate this Fire!##11740 |instant
	step
		goto 40.0,12.7 |noway
		.' You'll need to fly across the ocean here, you will get fatigued.
		goto Teldrassil,57.6,89.6 |c
	step
		goto Teldrassil 54.7,52.9
 		.click Alliance Bonfire##7734 
		..accept Desecrate this Fire!##11753 |instant
	step
		goto Darnassus 64,47.1
		.click Flame of Darnassus##6756
		.collect Flame of Darnassus##23184 |n
		.' Click the Flame of Darnassus in your bags |use Flame of Darnassus##23184
		..accept Stealing Darnassus's Flame##9332 |tip It is recommended that you be level 80 when attempting to complete this guide step.
	step
		goto The Exodar 41.6,26.9
		.click Flame of the Exodar##6756
		.collect Flame of the Exodar##35569 |n
		.' Click the Flame of the Exodar in your bags |use Flame of the Exodar##35569
		..accept Stealing the Exodar's Flame##11933 |tip It is recommended that you be level 80 when attempting to complete this guide step.
	step
		goto Azuremyst Isle 44.7,52.7
 		.click Alliance Bonfire##7734 
		..accept Desecrate this Fire!##11735 |instant
	step
		goto Bloodmyst Isle 55.9,68.6
 		.click Alliance Bonfire##7734 
		..accept Desecrate this Fire!##11738 |instant
	step
		goto The Cape of Stranglethorn 50.4,70.4
		.talk Stranglethorn Vale Flame Keeper##25920
		..accept Honor the Flame##11837 |instant
	step
		goto 51.8,67.4
 		.click Alliance Bonfire##7734 
		..accept Desecrate this Fire!##11761 |instant
	step
		goto Northern Stranglethorn 40.6,50.9
		.talk Northern Stranglethorn Vale Flame Keeper##51582
		..accept Honor the Flame##28924 |instant
	step
		goto 51.7,63.3
 		.click Alliance Bonfire##7734 
		..accept Desecrate this Fire!##28910 |instant
	step
		goto Blasted Lands 55.3,15.2
 		.click Alliance Bonfire##7734 
		..accept Desecrate this Fire!##11737 |instant
	step
		goto Blasted Lands 46.2,13.8
		.talk Blasted Lands Flame Keeper##51603
		..accept Honor the Flame##28930 |instant
	step
		goto Swamp of Sorrows 76.3,13.8
		.talk Swamp of Sorrows Flame Keeper##25941
		..accept Honor the Flame##11857 |instant
	step
		goto 70.3,14.4
 		.click Alliance Bonfire##7734 
		..accept Desecrate this Fire!##28916 |instant
	step
		goto Duskwood 73.4,55.0
 		.click Alliance Bonfire##7734 
		..accept Desecrate this Fire!##11743 |instant
	step
		goto Westfall 45.1,62.3
 		.click Alliance Bonfire##7734 
		..accept Desecrate this Fire!##11581 |instant
	step
		goto Elwynn Forest 43.1,63.0
 		.click Alliance Bonfire##7734 
		..accept Desecrate this Fire!##11745 |instant
	step
		goto Stormwind City 50.0,72.6
		.click Flame of Stormwind##6756
		.collect Flame of Stormwind##23182 |n
		.' Click the Flame of Stormwind in your bags |use Flame of Stormwind##23182
		..accept Stealing Stormwind's Flame##9330 |tip It is recommended that you be level 80 when attempting to complete this guide step.
	step
		goto Redridge Mountains 24.5,53.8
 		.click Alliance Bonfire##7734 
		..accept Desecrate this Fire!##11751 |instant
	step
		goto Burning Steppes 68.7,60.1
 		.click Alliance Bonfire##7734 
		..accept Desecrate this Fire!##11739 |instant
	step
		goto 51.1,29.2
		.talk Burning Steppes Flame Keeper##25927
		..accept Honor the Flame##11844 |instant
	step
		goto Badlands 18.7,56.0
 		.click Alliance Bonfire##7734 
		..accept Desecrate this Fire!##28912 |instant
	step
		goto 23.1,37.4
		.talk Badlands Flame Keeper##25925
		..accept Honor the Flame##11842 |instant
	step
		goto Loch Modan 32.4,40.2
 		.click Alliance Bonfire##7734 
		..accept Desecrate this Fire!##11749 |instant
	step
		goto Dun Morogh 53.6,44.8
 		.click Alliance Bonfire##7734 
		..accept Desecrate this Fire!##11742 |instant
	step
		goto Ironforge 64.3,26.0
		.click Flame of Ironforge##6756
		.collect Flame of Ironforge##23183 |n
		.' Click the Flame of Ironforge in your bags |use Flame of Ironforge##23183
		..accept Stealing Ironforge's Flame##9331 |tip It is recommended that you be level 80 when attempting to complete this guide step.
	step
		goto Wetlands 13.2,47.1
 		.click Alliance Bonfire##7734 
		..accept Desecrate this Fire!##11757 |instant
	step
		goto Arathi Highlands 44.6,46.1
 		.click Alliance Bonfire##7734 
		..accept Desecrate this Fire!##11732 |instant
	step
		goto 69.3,42.6
		.talk Arathi Flame Keeper##25923
		..accept Honor the Flame##11840 |instant
	step
		goto Hillsbrad Foothills 54.7,50.1
		.talk Hillsbrad Flame Keeper##25935
		..accept Honor the Flame##11853 |instant
	step
		goto Silverpine Forest 49.6,38.2
		.talk Silverpine Forest Flame Keeper##25939
		..accept Honor the Flame##11584 |instant
	step
		goto Undercity 66.9,13.5
		.talk Earthen Ring Elder##26221
		..turnin Inform the Elder##12012
	step
		goto 67.7,8.3
		.talk Festival Talespinner##16818
		..turnin Stealing Darnassus's Flame##9332
		..turnin Stealing the Exodar's Flame##11933
		..turnin Stealing Stormwind's Flame##9330
		..turnin Stealing Ironforge's Flame##9331
		..accept A Thief's Reward##9339 |instant
	step
		goto Eversong Woods 46.4,50.6
		.talk Eversong Woods Flame Keeper##25931
		..accept Honor the Flame##11848 |instant
	step
		goto Ghostlands 46.9,26.3
		.talk Ghostlands Flame Keeper##25933
		..accept Honor the Flame##11850 |instant
	step
		goto The Hinterlands 76.7,75.0
		.talk The Hinterlands Flame Keeper##25944
		..accept Honor the Flame##11860 |instant
	step
		goto 14.5,49.9
 		.click Alliance Bonfire##7734 
		..accept Desecrate this Fire!##11755 |instant
	step
		goto Western Plaguelands 43.6,82.5
		.click Alliance Bonfire##7734 
		..accept Desecrate this Fire!##11756 |instant
	step
		goto Western Plaguelands 29.2,57.4
		.talk Western Plaguelands Flame Keeper##51604
		..accept Honor the Flame##28931 |instant
	step
		goto Tirisfal Glades 57.2,51.7
		.talk Tirisfal Glades Flame Keeper##25946
		..accept Honor the Flame##11862 |instant
	step
		goto Hellfire Peninsula 61.9,58.5
 		.click Alliance Bonfire##7734 
		..accept Desecrate this Fire!##11747 |instant
	step
		goto Hellfire Peninsula 57.1,42.0
		.talk Hellfire Peninsula Flame Keeper##25934
		..accept Honor the Flame##11851 |instant
	step
		goto Netherstorm 32.1,68.3
		.talk Netherstorm Flame Keeper##25918
		..accept Honor the Flame##11835 |instant
	step
		goto Netherstorm 31.1,62.9
 		.click Alliance Bonfire##7734 
		..accept Desecrate this Fire!##11759 |instant
	step
		goto Blade's Edge Mountains 49.9,58.7
		.talk Blade's Edge Flame Keeper##25926
		..accept Honor the Flame##11843 |instant
	step
		goto Blade's Edge Mountains 41.8,66.0
 		.click Alliance Bonfire##7734 
		..accept Desecrate this Fire!##11736 |instant
	step
		goto Zangarmarsh 35.4,51.6
		.talk Zangarmarsh Flame Keeper##25947
		..accept Honor the Flame##11863 |instant
	step
		goto Zangarmarsh 68.6,52.1
 		.click Alliance Bonfire##7734 
		..accept Desecrate this Fire!##11758 |instant
	step
		goto Nagrand 50.9,34.1
		.talk Nagrand Flame Keeper##25937
		..accept Honor the Flame##11854 |instant
	step
		goto Nagrand 49.7,69.7
 		.click Alliance Bonfire##7734 
		..accept Desecrate this Fire!##11750 |instant
	step
		goto Terokkar Forest 52.0,42.9
		.talk Terokkar Forest Flame Keeper##25942
		..accept Honor the Flame##11858 |instant
	step
		goto Terokkar Forest 54.2,55.5
 		.click Alliance Bonfire##7734 
		..accept Desecrate this Fire!##11754 |instant
	step
		goto Shadowmoon Valley 33.4,30.5
		.talk Shadowmoon Valley Flame Keeper##25938
		..accept Honor the Flame##11855 |instant
	step
		goto Shadowmoon Valley 39.5,54.4
 		.click Alliance Bonfire##7734 
		..accept Desecrate this Fire!##11752 |instant
	step
		goto Borean Tundra 55.2,20.2
 		.click Alliance Bonfire##7734 
		..accept Desecrate this Fire!##13440 |instant
	step
		goto Borean Tundra 51.1,11.5
		.talk Borean Tundra Flame Keeper##32809
		..accept Honor the Flame##13493 |instant
	step
		goto Sholazar Basin 47.9,66.2
 		.click Alliance Bonfire##7734 
		..accept Desecrate this Fire!##13442 |instant
	step
		goto Sholazar Basin 47.1,61.5
		.talk Sholazar Basin Flame Keeper##32810
		..accept Honor the Flame##13494 |instant
	step
		goto Dragonblight 38.3,48.5
		.talk Dragonblight Flame Keeper##32811
		..accept Honor the Flame##13495 |instant
	step
		goto Dragonblight 75.1,43.8
 		.click Alliance Bonfire##7734 
		..accept Desecrate this Fire!##13443 |instant
	step
		goto Crystalsong Forest 77.6,75.2
 		.click Alliance Bonfire##7734 
		..accept Desecrate this Fire!##13447 |instant
	step
		goto Crystalsong Forest 80.0,53.2
		.talk Crystalsong Forest Flame Keeper##32815
		..accept Honor the Flame##13499 |instant
	step
		goto The Storm Peaks 40.3,85.3
		.talk Storm Peaks Flame Keeper##32814
		..accept Honor the Flame##13498 |instant
	step
		goto The Storm Peaks 41.4,87.0
 		.click Alliance Bonfire##7734 
		..accept Desecrate this Fire!##13446 |instant
	step
		goto Zul'Drak 40.5,61.0
 		.click Alliance Bonfire##7734 
		..accept Desecrate this Fire!##13449 |instant
	step
		goto Zul'Drak 43.4,71.7
		.talk Zul'Drak Flame Keeper##32816
		..accept Honor the Flame##13500 |instant
	step
		goto Grizzly Hills 19.3,61.2
		.talk Grizzly Hills Flame Keeper##32813
		..accept Honor the Flame##13497 |instant
	step
		goto Grizzly Hills 34.2,60.6
 		.click Alliance Bonfire##7734 
		..accept Desecrate this Fire!##13445 |instant
	step
		goto Howling Fjord 48.6,13.1
		.talk Howling Fjord Flame Keeper##32812
		..accept Honor the Flame##13496 |instant
	step
		goto Howling Fjord 57.8,15.8
		.click Alliance Bonfire##7734 
		..accept Desecrate this Fire!##13444 |instant
	step
		goto Shimmering Expanse 49.4,42.0
		.talk Vashj'ir Flame Guardian##51697
		..accept Honor the Flame##29031
	step
		goto Shimmering Expanse 49.4,41.9
		.click Earthen Ring Bonfire##7734
		..turnin Honor the Flame##29031
	step
		'Fly east to Twilight Highlands |goto Twilight Highlands |noway |c
	step
		goto Twilight Highlands 53.1,46.2
		.talk Twilight Highlands Flame Keeper##51651
		..accept Honor the Flame##28946 |instant
	step
		goto 47.3,28.3
		.click Alliance Bonfire##7734
		..accept Desecrate this Fire!##28943 |instant
	step
		goto Deepholm 49.3,51.4
		.talk Deepholm Flame Guardian##51698
		..accept Honor the Flame##29036
	step
		goto Deepholm 49.3,51.4
		.click Earthen Ring Bonfire##7734
		..turnin Honor the Flame##29036
	step
		goto Mount Hyjal 62.8,22.7
		.talk Hyjal Flame Guardian##51682
		..accept Honor the Flame##29030
	step
		goto 62.8,22.8
		.click Earthen Ring Bonfire##7734
		..turnin Honor the Flame##29030
	step
		goto Uldum 53.1,34.5
		.talk Uldum Flame Keeper##51652
		..accept Honor the Flame##28949 |instant
	step
		goto 53.5,32.0
		.click Alliance Bonfire##7734
		..accept Desecrate this Fire!##28947 |instant
]])

ZygorGuidesViewer:RegisterInclude("Midsummer_Achievements",[[
	step
		'Complete the Midsummer Fire Festival Quests guide section before doing this guide section.
		|confirm
	step
		' Open up your Dungeon Finder [I], and queue for The Frost Lord Ahune battle. |tip You must be at least level 89 to fight Lord Ahune.
		.from Lord Ahune##25740
		..' Complete the Ice the Frost Lord Achievement |achieve 263
	step "start"
		'Choose what city you would like to complete the Burning Hot Pole Dance Achievement
		'Click here to goto Orgrimmar |confirm |next "orgrimmar"
		'Click here to goto Thunder Bluff |confirm |next "thunderbluff"
		'Click here to goto Silvermoon City |confirm |next "silvermoon"
		'Click here to goto Undercity |confirm |next "undercity"
	step "orgrimmar"
		goto Orgrimmar,47.5,38.1
		.talk Midsummer Merchant##26124
		.buy 15 Juggling Torch##34599
		.buy 1 Mantle of the Fire Festival##23324
		.buy 1 Vestment of Summer##34685
		.buy 1 Sandals of Summer##34683
	step
		goto Orgrimmar,47.8,36.3
		.' Equip your Mantle of the Fire Festival |use Mantle of the Fire Festival##23324
		'
		.' Equip your Vestment of Summer |use Vestment of Summer##34685
		'
		.' Equip your Sandals of Summer |use Sandals of Summer##34683
		.' Click the Ribbon Pole |tip It looks like a tall metal pole with a small fire on top of it.
		.' Let your character spin around for 1 minute
		.' Complete the Burning Hot Pole Dance Achievement |achieve 271
	step
		'Don't forget to put your regular gear back on
		|confirm |next "daljuggle"
	step "thunderbluff"
		goto Thunder Bluff,20.0,24.2
		.talk Midsummer Merchant##26124
		.buy 15 Juggling Torch##34599
		.buy 1 Mantle of the Fire Festival##23324
		.buy 1 Vestment of Summer##34685
		.buy 1 Sandals of Summer##34683
	step
		goto Thunder Bluff,18.7,20.5
		.' Equip your Mantle of the Fire Festival |use Mantle of the Fire Festival##23324
		'
		.' Equip your Vestment of Summer |use Vestment of Summer##34685
		'
		.' Equip your Sandals of Summer |use Sandals of Summer##34683
		.' Click the Ribbon Pole |tip It looks like a tall metal pole with a small fire on top of it.
		.' Let your character spin around for 1 minute
		.' Complete the Burning Hot Pole Dance Achievement |achieve 271
	step
		'Don't forget to put your regular gear back on
		|confirm |next "daljuggle"
	step "silvermoon"
		goto Silvermoon City,70.4,44.3
		.talk Midsummer Merchant##26124
		.buy 15 Juggling Torch##34599
		.buy 1 Mantle of the Fire Festival##23324
		.buy 1 Vestment of Summer##34685
		.buy 1 Sandals of Summer##34683
	step 
		goto Silvermoon City,70.6,43.2
		.' Equip your Mantle of the Fire Festival |use Mantle of the Fire Festival##23324
		'
		.' Equip your Vestment of Summer |use Vestment of Summer##34685
		'
		.' Equip your Sandals of Summer |use Sandals of Summer##34683
		.' Click the Ribbon Pole |tip It looks like a tall metal pole with a small fire on top of it.
		.' Let your character spin around for 1 minute
		.' Complete the Burning Hot Pole Dance Achievement |achieve 271
	step
		'Don't forget to put your regular gear back on
		|confirm |next "daljuggle"
	step "undercity"
		goto Undercity,68.1,11.2
		.talk Midsummer Merchant##26124
		.buy 15 Juggling Torch##34599
		.buy 1 Mantle of the Fire Festival##23324
		.buy 1 Vestment of Summer##34685
		.buy 1 Sandals of Summer##34683
	step
		goto Undercity,68.0,14.4
		.' Equip your Mantle of the Fire Festival |use Mantle of the Fire Festival##23324
		'
		.' Equip your Vestment of Summer |use Vestment of Summer##34685
		'
		.' Equip your Sandals of Summer |use Sandals of Summer##34683
		.' Click the Ribbon Pole |tip It looks like a tall metal pole with a small fire on top of it.
		.' Let your character spin around for 1 minute
		.' Complete the Burning Hot Pole Dance Achievement |achieve 271
	step
		'Don't forget to put your regular gear back on
		|confirm |next "daljuggle"
	step
	label "daljuggle"
		goto Dalaran,36.8,44.1
		.' Use your 40 Juggling Torches as fast as you can |tip You must juggle them all in under 15 seconds.  The best way to do this is to place your Juggling Torches on your hotbar.  Press the hotbar key and click the ground at the same time.  Keep spamming the hotbar key and clicking the ground at the same time as fast as possible and dont stop until you get the achievement.
		.' Complete the Torch Juggler Achievement |achieve 272
	step
		'Congratulations, you are now The Flame Warden!
]])

-- BREWFEST --

ZygorGuidesViewer:RegisterInclude("H_Brewfest_Quests",[[
	step
		goto Durotar/0 41.6,18.5
		.talk Tapper Swindlekeg##24711
		..accept Welcome to Brewfest!##11447 |instant
	step
		goto Durotar,42.6,17.8
		.talk Ram Master Ray##24497
		..accept Now This is Ram Racing... Almost.##11409
	step
		'As you run around on the ram:
		.' Use your Ram Racing Reins |use Ram Racing Reins##33306 |tip The ram runs slow by default.  You have to use the Ram Racing Reins to make it run at certain speeds for 8 seconds.  The make the ram Trot for 8 seconds, use the Ram Racing Reins every 2 seconds or so to keep the ram running at the speed just above the slow default speed.  To make the Ram Canter for 8 seconds, use the Ram Racing Reins a little more often than when you made the Ram Trot.  To make the Ram Gallop, just spam use the Ram Racing Reins.
		.' Maintain a Trot for 8 seconds |q 11409/1
		.' Maintain a Canter for 8 seconds |q 11409/2
		.' Maintain a Gallop for 8 seconds |q 11409/3
	step
		goto Durotar,42.6,17.9
		.talk Ram Master Ray##24497
		..turnin Now This is Ram Racing... Almost.##11409
		..accept There and Back Again##11412
	step
		goto 50.6,13.5
		.' Use your Ram Racing Reins as you run |use Ram Racing Reins##33306 |tip Run as fast as you can without making your Ram stop from being too tired.  Stop at every bucket of apples you see on the side of the road to refresh your Ram's fatigue level, allowing the Ram to run faster for longer.
		.' Bok Dropcertain will throw you a keg when you get close
		.' Once you have a keg, run back and turn it in to Driz Tumblequick at [42.6,17.7] |tip Just get near him and you will throw the keg to him.
		.' Deliver 3 Kegs |q 11412/1
	step
		goto Durotar,42.6,17.8
		.talk Ram Master Ray##24497
		..turnin There and Back Again##11412
	step
		goto Durotar,42.7,17.7
		.talk Driz Tumblequick##24510
		..accept A New Supplier of Souvenirs##29396 |or
		..accept Another Year, Another Souvenir.##13931 |or
	step
		goto Durotar,41.5,17.6
		.talk Bizzle Quicklift##27216
		..accept Chug and Chuck!##12191
	step
		goto Durotar,41.5,17.5
		.' Click the Complimentary Brewfest Samplers |tip They looks like mugs of beer on the small tables on either side of you.
		.' Use your Complimentary Brewfest Samplers |use Complimentary Brewfest Sampler##33096
		.' Hit S.T.O.U.T. 5 Times |q 12191/1
	step
		goto 41.5,17.5
		.talk Bizzle Quicklift##27216
		..turnin Chug and Chuck!##12191
	step
		goto 41.2,18.5
		.' NOTE: If you are on an EU server, you will be unable to accept these 2 quests. |tip So, just skip them, and also skip the guide steps where you complete the quest goals for these quests.
		.talk Glodrak Huntsniper##24657
		..accept Catch the Wild Wolpertinger!##11431
		..accept Pink Elekks On Parade##11120
	step
		goto 41.2,18.5
		.talk Glodrak Huntsniper##24657
		..' Ask him if there's another way you can help out if you don't like drinking, then ask for a pair of Synthebrew Goggles
		.collect Synthebrew Goggles##46735 |q 11431
	step
		goto 40.3,17.9
		.talk Blix Fixwidget##24495
		..turnin A New Supplier of Souvenirs##29396 |or
		..turnin Another Year, Another Souvenir.##13931 |or
	step
		'Use your Synthebrew Goggles |use Synthebrew Goggles##46735
		.' Equip the Synthebrew Goggles |havebuff Interface\Icons\Spell_Holy_SpiritualGuidence |q 11431
	step
		goto Durotar,41.2,18.1
		.' Use your Wolpertinger Net on Wild Wolpertingers |use Wolpertinger Net##32907 |tip They look like rabbits with antlers and wings running around on the ground around this area.
		.get 5 Stunned Wolpertinger |q 11431/1
		'|modelnpc Wild Wolpertinger##23487+
	step
		goto Durotar,41.2,18.5
		.talk Glodrak Huntsniper##24657
		..turnin Catch the Wild Wolpertinger!##11431
		.' Earn Does Your Wolpertinger Linger? achievement |achieve 1683/6
	step
		goto Undercity,70.5,12.0
		.' Use your Elekk Dispersion Ray on Tirisfal Pink Elekks |use Elekk Dispersion Ray##32960
		.kill 3 Tirisfal Pink Elekk |q 11120/3
	step
		goto Eversong Woods,57.0,53.1
		.' Use your Elekk Dispersion Ray on Eversong Pink Elekks |use Elekk Dispersion Ray##32960
		.kill 3 Eversong Pink Elekk |q 11120/1
	step
		goto Thunder Bluff,34.7,74.7
		.' Go down the lifts
		.' Use your Elekk Dispersion Ray on Mulgore Pink Elekks |use Elekk Dispersion Ray##32960
		.kill 3 Mulgore Pink Elekk |q 11120/2
	step
		goto Durotar,41.2,18.5
		.talk Glodrak Huntsniper##24657
		..turnin Pink Elekks On Parade##11120
	step
		'Use the Dungeon Finder (press I) to queue for Coren Direbrew |tip You must be level 89 do complete this quest.
		.' You will fight Coren Direbrew
		.from Coren Direbrew##23872
		.collect Direbrew's Dire Brew##38281 |n
		.' Click Direbrew's Dire Brew in your bags |use Direbrew's Dire Brew##38281
		..accept Direbrew's Dire Brew##12492
		.' Kill Coren  Direbrew |achieve 1683/3
	step
		goto Durotar,41.6,18.5
		.talk Tapper Swindlekeg##24711
		..turnin Direbrew's Dire Brew##12492
]])

ZygorGuidesViewer:RegisterInclude("H_Brewfest_Dailies",[[
	daily
	step
		goto Durotar,40.6,18.2
		.talk Cort Gorestein##24498
		..accept Bark for Drohn's Distillery!##11407 |or
		.' Go to [Durotar,40.2,17.1]
		.talk Ja'ron##24499
		..accept Bark for T'chali's Voodoo Brewery!##11408 |or
		.' You will only be able to accept one of these quests per day.
	step
		'Ride your ram into Orgrimmar |goto Orgrimmar |noway |c |q 11407
		.' Use your Ram Racing Reins as you run |use Ram Racing Reins##33306 |tip Just keep a Trot pace most of the time, and only sometimes keep a Canter pace.  If you go too much faster than that, your ram will get tired and you will run out of time.
	step
		'Ride your ram into Orgrimmar |goto Orgrimmar |noway |c |q 11294
		.' Use your Ram Racing Reins as you run |use Ram Racing Reins##33306 |tip Just keep a Trot pace most of the time, and only sometimes keep a Canter pace.  If you go too much faster than that, your ram will get tired and you will run out of time.
	step
		goto Orgrimmar,52.1,75.0
		.' Use your Ram Racing Reins as you run |use Ram Racing Reins##33306 |tip Just keep a Trot pace most of the time, and only sometimes keep a Canter pace.  If you go too much faster than that, your ram will get tired and you will run out of time.
		.' Go to this spot
		.' Bark Outside the Auction House |q 11407/1
	step
		goto 67.0,48.2
		.' Use your Ram Racing Reins as you run |use Ram Racing Reins##33306 |tip Just keep a Trot pace most of the time, and only sometimes keep a Canter pace.  If you go too much faster than that, your ram will get tired and you will run out of time.
		.' Go to this spot
		.' Bark in the Valley of Honor |q 11407/2
	step
		goto 44.3,49.1
		.' Use your Ram Racing Reins as you run |use Ram Racing Reins##33306 |tip Just keep a Trot pace most of the time, and only sometimes keep a Canter pace.  If you go too much faster than that, your ram will get tired and you will run out of time.
		.' Go to this spot
		.' Bark in the Valley of Wisdom |q 11407/3
	step
		goto 38.0,75.6
		.' Use your Ram Racing Reins as you run |use Ram Racing Reins##33306 |tip Just keep a Trot pace most of the time, and only sometimes keep a Canter pace.  If you go too much faster than that, your ram will get tired and you will run out of time.
		.' Go to this spot
		.' Bark in the Valley of Spirits |q 11407/4
	step
		goto Orgrimmar,52.9,66.5 
		.' Use your Ram Racing Reins as you run |use Ram Racing Reins##33306 |tip Just keep a Trot pace most of the time, and only sometimes keep a Canter pace.  If you go too much faster than that, your ram will get tired and you will run out of time.
		.' Go to this spot
		.' Bark Outside the Auction House |q 11408/1
	step
		goto 71.5,34.8 
		.' Use your Ram Racing Reins as you run |use Ram Racing Reins##33306 |tip Just keep a Trot pace most of the time, and only sometimes keep a Canter pace.  If you go too much faster than that, your ram will get tired and you will run out of time.
		.' Go to this spot
		.' Bark in the Valley of Honor |q 11408/2
	step
		goto 43.8,36.5 
		.' Use your Ram Racing Reins as you run |use Ram Racing Reins##33306 |tip Just keep a Trot pace most of the time, and only sometimes keep a Canter pace.  If you go too much faster than that, your ram will get tired and you will run out of time.
		.' Go to this spot
		.' Bark in the Valley of Wisdom |q 11408/3
	step
		goto 37.0,74.3 
		.' Use your Ram Racing Reins as you run |use Ram Racing Reins##33306 |tip Just keep a Trot pace most of the time, and only sometimes keep a Canter pace.  If you go too much faster than that, your ram will get tired and you will run out of time.
		.' Go to this spot
		.' Bark in the Valley of Spirits |q 11408/4
	step
		goto Durotar,40.6,18.2
		.talk Cort Gorestein##24498
		..turnin Bark for Drohn's Distillery!##11407
	step
		goto Durotar,43.6,17.6
		.talk Ja'ron##24499
		..turnin Bark for T'chali's Voodoo Brewery!##11408
	step
		goto 40.8,17.5
		.' Click Dark Iron Mole Machine Wreckage |tip You have to defend the three kegs at these locations in order for it to show up.
		.' Click the Complimentary Brewfest Sampler here [40.2,17.4]
		.' Click the Complimentary Brewfest Sampler here [40.4,16.8]
		.' Thow the Sampler's at the Dark Iron Dwarves and the Mole Machines. |use Complimentary Brewfest Sampler##33096
		..accept This One Time, When I Was Drunk...##12192
	step
		goto 41.5,17.6
		.talk Bizzle Quicklift##27216
		..turnin This One Time, When I Was Drunk...##12192
		.' Earn the Down With the Dark Iron achievement |achieve 1683/4
	step
		goto 42.7,17.6
		.talk Ram Master Ray##24497
		..accept Brew For Brewfest##29393 |instant
		.' On your Ram, run to Bok Dropcertain at [50.6,13.5] |tip Bok Dropcertain will throw you a keg when you get close.
		.' Deliver as many kegs as you can within 4 minutes |tip You get 2 Brewfest Prize Tokens for each keg you deliver, so this is a good way to get some Brewfest Prize Tokens to join the Brew of the Month Club.
]])

ZygorGuidesViewer:RegisterInclude("H_Brewfest_Achievements",[[
	step
		goto Durotar,41.0,18.3
		.talk Uta Roughdough##23603
		.buy The Essential Brewfest Pretzel##33043 |achieve 1185
	step
		'Click The Essential Brewfest Pretzels in your bags |use The Essential Brewfest Pretzel##33043
		.' Eat The Essential Brewfest Pretzels |achieve 1185/7
	step
		goto 40.2,17.7
		.talk Agnes Farwithers##23604
		.buy Spiced Onion Cheese##34065 |achieve 1185
	step
		'Click the Spiced Onion Cheese in your bags |use Spiced Onion Cheese##34065
		.' Eat the Spiced Onion Cheese |achieve 1185/4
	step
		goto 41.2,17.3
		.talk Bron##23605
		.buy Dried Sausage##34063 |achieve 1185
		.buy Succulent Sausage##34064 |achieve 1185
		.buy Savory Sausage##33023 |achieve 1185
		.buy Pickled Sausage##33024 |achieve 1185
		.buy Spicy Smoked Sausage##33025 |achieve 1185
		.buy The Golden Link##33026 |achieve 1185
	step
		'Do the following:
		.' Click the Dried Sausage in your bags |use Dried Sausage##34063
		.' Eat the Dried Sausage |achieve 1185/1
		.' Click the Succulent Sausage in your bags |use Succulent Sausage##34064
		.' Eat the Succulent Sausage |achieve 1185/6
		.' Click the Savory Sausage in your bags |use Savory Sausage##33023
		.' Eat the Savory Sausage |achieve 1185/3
		.' Click the Pickled Sausage in your bags |use Pickled Sausage##33024
		.' Eat the Pickled Sausage |achieve 1185/2
		.' Click the Spicy Smoked Sausage in your bags |use Spicy Smoked Sausage##33025
		.' Eat Spicy Smoked Sausage |achieve 1185/5
		.' Click the The Golden Link in your bags |use The Golden Link##33026
		.' Eat The Golden Link |achieve 1185/8
		.' Earn The Brewfest Diet |achieve 1683/1
	step
		goto 40.3,17.9
		.talk Blix Fixwidget##24495
		.buy Fresh Brewfest Hops##37750 |achieve 303 |tip You must be at least level 20 to buy these.
	step
		'Use your Fresh Brewfest Hops |use Fresh Brewfest Hops##37750
		.' Make your Mount Festive for Brewfest! |achieve 303
		.' Earn Have Keg, Will Travel |achieve 1683/5
	step
		'Complete the Brewfest daily quests each day until you have 200 Brewfest Prize Tokens
		.collect 200 Brewfest Prize Token##37829 |achieve 2796
	step
		goto 40.3,17.9
		.talk Blix Fixwidget##24495
		.buy "Brew of the Month" Club Membership Form##37599 |n
		.' Click the "Brew of the Month" Club Membership Form in your bags |use "Brew of the Month" Club Membership Form##37599
		..accept Brew of the Month Club##12306
		.' Buy the Wolpertinger's Tankard and click it to learn it. |achieve 1683/6
	step
		'Go inside Orgrimmar |goto Orgrimmar |noway |c
	step
		goto Orgrimmar,50.4,73.5
		.talk Ray'ma##27489
		..turnin Brew of the Month Club##12306
		.' Earn the Brew of the Month achievement |achieve 1683/2
	step
		'Congratulations, you are a Brewmaster! |achieve 1683
]])

--------------------------------------------------------------------------------------------------------------------------------------
-- Professions Cooking
--------------------------------------------------------------------------------------------------------------------------------------
ZygorGuidesViewer:RegisterInclude("H_Org_Cooking_Dailies",[[
	step
	label "start"
		goto Orgrimmar,56.5,62.5
		.talk Marogg##42506
		..' You will only be able to complete 1 of the following quests per day
		..accept Careful, This Fruit Bites Back##26227 |or
		..accept Crawfish Creole##26226 |or
		..accept Even Thieves Get Hungry##26235 |or
		..accept Everything Is Better with Bacon##26220 |or
		..accept Stealing From Our Own##26234 |or |only Troll
		..accept Stealing From Our Own##26233 |or |only Orc,Scourge,Tauren,BloodElf,Goblin,Pandaren
	step
		goto 52.7,62.1
		.' Click Prickly Pear Fruits |tip They look like smaller cactus plants with red round fruit on top of them all around Orgrimmar.  They are usually found next to walls.
		.get 8 Prickly Pear Fruit |q 26227/1
	step
		goto 65.3,43.5
		.' Click Muddy Crawfish |tip They look like tiny lobsters in the water around this area.
		.get 10 Muddy Crawfish |q 26226/1
	step
		goto 66.2,39.4
		.' Get near the piles of wooden crates |tip They are all around Orgrimmar, so you can walk around and find them everywhere.
		.from Orgrimmar Thief##42594+ |tip They are stealthed next to the crates, trying to steal them.  They won't be next to every pile of crates, so you'll need to search for them.
		.get 3 Horde Infantry Rations |q 26235/1
	step
		goto Durotar,48.7,16.0
		.from Mature Swine##42504+, Wild Mature Swine##42859+
		.get 6 Swine Belly |q 26220/1
	step
		goto Orgrimmar,40.3,80.0
		.' Click Barrels of Kezan Rice |tip They look like light brown wooden barrels around this area.
		.get 6 Barrel of Kezan Rice |q 26234/1
		only Troll
	step
		goto 34.5,69.8
		.' Click Barrels of Darkspear Rice |tip They looks like dark brown wooden barrels around this area.
		.get 6 Barrel of Darkspear Rice |q 26233/1
		only Orc,Scourge,Tauren,BloodElf,Goblin
	step
		goto 56.5,62.5
		.talk Marogg##42506
		..' You will only be able to complete 1 of the following quests per day
		..turnin Careful, This Fruit Bites Back##26227
		..turnin Crawfish Creole##26226
		..turnin Even Thieves Get Hungry##26235
		..turnin Everything Is Better with Bacon##26220
		..turnin Stealing From Our Own##26234 |only Troll
		..turnin Stealing From Our Own##26233 |only Orc,Scourge,Tauren,BloodElf,Goblin,Pandaren
]])

ZygorGuidesViewer:RegisterInclude("H_TB_Cooking_Dailies",[[
	step
	label "dailies"
		goto Thunder Bluff,51.0,52.8
		.talk Aska Mistrunner##3026
		..accept Pining for Nuts##29358 |or
		..accept "Magic" Mushrooms##29362 |or
		..accept Mulgore Spice Bread##29363 |or
		..accept Corn Mash##29364 |or
		..accept Perfectly Pickled Portions##29365 |or
	step
		goto 48.4,62.2
		'Click on the Mulgore Pine Cones on the ground |tip They look like sparkling pine cones on the ground, next to the base of moss trees in Thunder Bluff
		.' Create a Cooking Fire |cast 818
		.' Cook the Mulgore Pine Cones over a cooking fire to release Pine Nuts. |use Mulgore Pine Cones##69990
		.get 30 Pine Nut##69988 |q 29358/1
		|only if havequest(29358)
	step
		goto 26.3,23.6
		'Click on the "Magic" Mushrooms on the gorund in this cave |tip They look like white glowing mushrooms along the walls
		.get 6 "Magic" Mushroom##69994 |q 29362/1
		|only if havequest(29362)
	step
		goto Thunder Bluff,51.1,52.7 |q 29363
		.talk Naal Mistrunner##3027 |q 29363
		.buy 5 Simple Flour##30817 |q 29363
		.buy 5 Mild Spices##2678 |q 29363
		|only if havequest(29363)
	step
		.create Spice Bread##37836,Cooking,5 total |q 29363
		.collect 5 Spice Bread##30816 |q 29363
		|only if havequest(29363)
	step
		'Use the Mulgore Spices in your bags to make Fresh Mulgore Spice Bread |use Mulgore Spices##69997
		.get 5 Fresh Mulgore Spice Bread##69996 |q 29363/1
		|only if havequest(29363)
	step
		goto Thunder Bluff,52.1,45.6
		'Click on the bowls of Corn Kernels |tip They look like little bowls of yellow corn in almost all the huts in Thunderbluff
		.' Grind 6 Bowls of Corn Kernels |q 29364/1
		|only if havequest(29364)
	step
		 goto 47.7,42.3
		.get Succulent Sweet Potatoes##70000 |q 29365/1 |tip They look like baskets in this little hut
		|only if havequest(29365)
	step
		goto 49.7,41.5
		.get Savory Spices##70001 |q 29365/2 |tip It looks like a bag with weeds in it
		|only if havequest(29365)
	step
		goto 56.1,44.9 
		.get Fresh-Caught Fish##70002 |q 29365/3 |tip It looks like a rope hanging down with a bunch of fish on it
		.get Fresh-Hunted Fowl##70003 |q 29365/4
		|only if havequest(29365)
	step
		goto Thunder Bluff,51.0,52.8
		.talk Aska Mistrunner##3026
		..turnin Pining for Nuts##29358 |or
		..turnin "Magic" Mushrooms##29362 |or
		..turnin Mulgore Spice Bread##29363 |or
		..turnin Corn Mash##29364 |or
		..turnin Perfectly Pickled Portions##29365 |or
		.' Click here to go back to the beginning of the dailies |confirm |next "dailies"
]])

ZygorGuidesViewer:RegisterInclude("H_UC_Cooking_Dailies",[[
	step
		goto Undercity 62.1,44.9
		.talk Eunice Burch##4552
		..accept Roach Coach##29334 |or
		..accept Escargot A Go-Go##29333 |or
		..accept Would You Like Some Flies With That?##29360 |or
	step
		'All around Undercity:
		.click Cockrach Cabin##336
		|tip Look in corners and behind crates. They are hidden all around Undercity.
		.get 20 Plump Cockroach |q 29334/1
	step
		goto Undercity 68.7,53.7
		|tip You will find the fly meat around the wagons in this area.
		.click Fly Covered "Meat"##295
		.get 25 Bloated Fly |q 29360/1
		.' You can find more here[goto Undercity 57.0,17.2]
	step
		goto Tirisfal Glades 70.5,39.6
		.clicknpc Brightwater Snail##53526+
		|tip They are underneath the water in this lake.
		.get 8 Brightwater Snail |q 29333/1
	step
		goto Undercity 62.6,35.5
		.talk Chef Audrey##53528
		..turnin Roach Coach##29334
	step
		goto Undercity 62.1,44.9
		.talk Eunice Burch##4552
		..turnin Escargot A Go-Go##29333
		..turnin Would You Like Some Flies With That?##29360
]])

ZygorGuidesViewer:RegisterInclude("H_The_Northrend_Gourmet",[[
	step
	title +Wrath of the Lich King Recipes
		#include trainCooking
		.learn Dalaran Clam Chowder##58065 
		.learn Grilled Sculpin##45563 
		.learn Mammoth Meal##45549 
		.learn Pickled Fangtooth##45566 
		.learn Poached Nettlefish##45565 
		.learn Rhino Dogs##45553 
		.learn Roasted Worg##45552 
	step
		#include trainCooking
		.learn Shoveltusk Steak##45550 
		.learn Smoked Salmon##45564 
		.learn Worm Delight##45551 
		.learn Fisherman's Feast##42302 
		.learn Hot Buttered Trout##42305 
		.learn Great Feast##45554 
		.learn Black Jelly##64358 
		.learn Darkbrew Lager##88015 
		.learn Blackened Surprise##88006
	step
		//alliance
		//goto 57.8,71.4
		//.talk Rollick MacKreel##26989
		//..accept Northern Cooking##13088
		//horde
		goto Borean Tundra 42,54.2
		.talk Orn Tenderhoof##26972
		..accept Northern Cooking##13090
	step
		goto 45,47.4
		.from Wooly Rhino Matriarch##25487+,Wooly Rhino Calf##25488+
		.get 4 Chilled Meat##43013 |q 13090
		//alliance
		//.get 4 Chilled Meat##43013 |q 13088
	step
		//alliance
		//goto 57.8,71.4
		//.talk Rollick MacKreel##26989
		//..turnin Northern Cooking##13088
		//horde
		goto 42,54.2
		.talk Orn Tenderhoof##26972
		..turnin Northern Cooking##13090
		.learn Northern Stew##57421
	//Emotions food
	step
		goto 54.6,70.0
		.from Crypt Crawler##25227 |tip You can also farm any Northrend Dungeon for a higher drop percentage.
		.collect 1 Recipe: Bad Clams##43509
		.collect 1 Recipe: Last Week's Mammoth##43508
		.collect 1 Recipe: Haunted Herring##43510
		.collect 1 Recipe: Tasty Cupcake##43507
	step
		.learn Bad Clams##58523 |use Recipe: Bad Clams##43509
		.learn Haunted Herring##58525 |use Recipe: Haunted Herring##43510
		.learn Last Week's Mammoth##58521 |use Recipe: Last Week's Mammoth##43508
		.learn Tasty Cupcake##58512 |use Recipe: Tasty Cupcake##43507
	step
		fly Nesingwary Base Camp
	step
		goto Sholazar Basin 26.8,60.1
		.talk Grimbooze Thunderbrew##29157
		..accept Some Make Lemonade, Some Make Liquor##12634
	step
		goto 37.6,61.8
		.click Sturdy Vine##8129
		.' Click the fruit that falls to the ground or talk to the dwarf that falls
		.get Orange |q 12634/1
		.get 2 Banana Bunch|q 12634/2
		.get Papaya |q 12634/3
	step
		goto 26.8,60.1
		.talk Grimbooze Thunderbrew##29157
		..turnin Some Make Lemonade, Some Make Liquor##12634
		..accept Still At It##12644
	step
		goto 26.7,60
		.talk "Tipsy" McManus##28566
		..'Tell him you are ready to start the distillation process
		.' Click the items on the ground or on the machine that he yells at you during the process, it's random
		.' Click the barrel on the ground when the process is done
		.get Thunderbrew's Jungle Punch|q 12644/1
	step
		goto 26.8,60.1
		.talk Grimbooze Thunderbrew##29157
		..turnin Still At It##12644
		..accept The Taste Test##12645
	step
		goto 27.4,59.4
		.' Use your Jungle Punch Sample on Hadrius Harlowe|use Jungle Punch Sample##38697|tip Standing next to a tiki torch.
		.' Complete Hadrius' taste test |q 12645/2
	step
		goto 27.1,58.6
		.' Use your Jungle Punch Sample on Hemet Nesingwary|use Jungle Punch Sample##38697|tip Standing in front of a tent.
		.' Complete Hemet's taste test |q 12645/1
	step
		goto 26.8,60.1
		.talk Grimbooze Thunderbrew##29157
		..turnin The Taste Test##12645
	step
		goto Dalaran/2 44.2,25.6
		.talk Washed-Up Mage##32516
		..accept Fletcher's Lost and Found##13571 |instant
	step
		'You can use the Professions section of this guide to get to 450 cooking |only if skill("Cooking")<450
		'You can use the Dalaran Cooking Dailies section of this guide to earn Dalaran Cooking Awards to buy the following recipes: |tip You will need a total of 74 Dalaran Cooking Awards to get all of the recipes
		goto Dalaran,70.1,38.2 
		.talk Misensi##31031 
		.buy 1 Recipe: Mega Mammoth Meal##43018 
		.buy 1 Recipe: Tender Shoveltusk Steak##43019 
		.buy 1 Recipe: Spiced Worm Burger##43020 
		.buy 1 Recipe: Very Burnt Worg##43021 
		.buy 1 Recipe: Worg Tartare##44954 
		.buy 1 Recipe: Mighty Rhino Dogs##43022 
		.buy 1 Recipe: Poached Northern Sculpin##43023 //50
		.buy 1 Recipe: Firecracker Salmon##43024 
		.buy 1 Recipe: Spicy Blue Nettlefish##43025 
		.buy 1 Recipe: Imperial Manta Steak##43026 
		.buy 1 Recipe: Spicy Fried Herring##43027 
		.buy 1 Recipe: Rhinolicious Wormsteak##43028
	step
		'Use the Professions section of this guide to get to 450 cooking |only if skill("Cooking")<450
		.learn Mega Mammoth Meal##45555 |use Recipe: Mega Mammoth Meal##43018 
		.learn Tender Shoveltusk Steak##45556 |use Recipe: Tender Shoveltusk Steak##43019
		.learn Spiced Worm Burger##45557 |use Recipe: Spiced Worm Burger##43020
		.learn Very Burnt Worg##45558 |use Recipe: Very Burnt Worg##43021
		.learn Worg Tartare##62350 |use Recipe: Worg Tartare##44954
		.learn Mighty Rhino Dogs##45559 |use Recipe: Mighty Rhino Dogs##43022
		.learn Poached Northern Sculpin##45567 |use Recipe: Poached Northern Sculpin##43023
		.learn Firecracker Salmon##45568 |use Recipe: Firecracker Salmon##43024
		.learn Spicy Blue Nettlefish##45571 |use Recipe: Spicy Blue Nettlefish##43025
		.learn Imperial Manta Steak##45570 |use Recipe: Imperial Manta Steak##43026
		.learn Spicy Fried Herring##57433 |use Recipe: Spicy Fried Herring##43027
		.learn Rhinolicious Wormsteak##57434 |use  Recipe: Rhinolicious Wormsteak##43028
	step
		'Use the Professions section of this guide to get to 450 cooking |only if skill("Cooking")<450
		'Use the Dalaran Cooking Dailies section of this guide to earn Dalaran Cooking Awards to buy the following recipes: |tip You will need a total of 74 Dalaran Cooking Awards to get all of the recipes
		goto Dalaran,70.1,38.2 
		.talk Misensi##31031 
		.buy 1 Recipe: Critter Bites##43029 
		.buy 1 Recipe: Hearty Rhino##43030 
		.buy 1 Recipe: Snapper Extreme##43031 
		.buy 1 Recipe: Blackened Worg Steak##43032 
		.buy 1 Recipe: Cuttlesteak##43033 
		.buy 1 Recipe: Spiced Mammoth Treats##43034 
		.buy 1 Recipe: Blackened Dragonfin##43035 
		.buy 1 Recipe: Dragonfin Fillet##43036 
		.buy 1 Recipe: Tracker Snacks##43037 
		.buy 1 Recipe: Gigantic Feast##43505 
		.buy 1 Recipe: Small Feast##43506 
		.buy 1 Recipe: Fish Feast##43017 
	step
		'Use the Professions section of this guide to get to 450 cooking |only if skill("Cooking")<450
		.learn Critter Bites##57435 |use Recipe: Critter Bites##43029
		.learn Hearty Rhino##57436 |use Recipe: Hearty Rhino##43030
		.learn Snapper Extreme##57437 |use Recipe: Snapper Extreme##43031
		.learn Blackened Worg Steak##57438 |use Recipe: Blackened Worg Steak##43032
		.learn Cuttlesteak##57439 |use Recipe: Cuttlesteak##43033
		.learn Spiced Mammoth Treats##57440 |use Recipe: Spiced Mammoth Treats##43034
		.learn Blackened Dragonfin##57441 |use Recipe: Blackened Dragonfin##43035
		.learn Dragonfin Fillet##57442 |use Recipe: Dragonfin Fillet##43036
		.learn Tracker Snacks##57443 |use Recipe: Tracker Snacks##43037
		.learn Gigantic Feast##58527 |use Recipe: Gigantic Feast##43505
		.learn Small Feast##58528 |use Recipe: Small Feast##43506 
		.learn Fish Feast##57423 |use Recipe: Fish Feast##43017
	step
		'You can either buy these from the Auction House or farm them
		.collect 1 Barrelhead Goby##41812
		.collect 4 Bonescale Snapper##41808
		.collect 5 Chilled Meat##43013
		.collect 8 Chunk o' Mammoth##34736
		.collect 2 Deep Sea Monsterbelly##41800
		.collect 2 Dragonfin Angelfish##41807
		.collect 1 Essence of Undeath##12808
		.collect 2 Fangtooth Herring##41810
		.collect 6 Glacial Salmon##41809
		.collect 2 Imperial Manta Ray##41809
		.collect 1 Moonglow Cuttlefish##41801
		.collect 1 Mote of Shadow##22577
		.collect 4 Musselback Sculpin##41806
		.collect 6 Nettlefish##51813
		.collect 1 Northern Egg##43501
		.collect 23 Northern Spices##43007
		.collect 7 Rhino Meat##43012
		.collect 3 Rockfin Grouper##41803
		.collect 4 Shoveltusk Flank##43009
		.collect 3 Succulent Clam Meat##36782
		.collect 5 Worg Haunch##43011
		.collect 5 Worm Meat##43010
	step
		goto Orgrimmar,56.5,61.2
		.talk Suja##46708
		.buy 2 Simple Flour##30817
	step
		goto Orgrimmar,50.8,74.6
		.talk Shan'ti##3342
		.buy 2 Tundra Berries##35949
		.buy 1 Savory Snowplum##35948
	step
		'Build a Basic Campfire |cast Basic Campfire##818
		.create Bad Clams##58523,Cooking,1 total
		.' Cook Bad Clams |achieve 1777/1
		.' Eat Bad Clams |achieve 1780/1 |use Bad Clams##43491
	step
		.create Baked Manta Ray##45569,Cooking,1 total
		.' Cook Baked Manta Ray |achieve 1777/2
	step
		.create Blackened Dragonfin##57441,Cooking,1 total
		.' Cook Blackened Dragonfin |achieve 1777/3
	step
		.create Blackened Worg Steak##57438,Cooking,1 total
		.' Cook Blackened Worg Steak |achieve 1777/4
	step
		.create Critter Bites##57435,Cooking,1 total
		.' Cook Critter Bites |achieve 1777/5
	step
		.create Cuttlesteak##57439,Cooking,1 total
		.' Cook Cuttlesteak |achieve 1777/6
	step
		.create Dalaran Clam Chowder##58065,Cooking,1 total
		.' Cook Dalaran Clam Chowder |achieve 1777/7
	step
		.create Dragonfin Filet##57442,Cooking,1 total
		.' Cook Dragonfin Filet |achieve 1777/8
	step
		.create Firecracker Salmon##45568,Cooking,1 total
		.' Cook Firecracker Salmon |achieve 1777/9
	step
		.create Fish Feast##57423,Cooking,1 total
		.' Cook Fish Feast |achieve 1777/10
	step
		.create Gigantic Feast##58527,Cooking,1 total
		.' Cook Gigantic Feast |achieve 1777/11
	step
		.create Great Feast##45554,Cooking,1 total
		.' Cook Great Feast |achieve 1777/12
	step
		.create Grilled Bonescale##45561,Cooking,1 total
		.' Cook Grilled Bonescale |achieve 1777/13
	step
		.create Grilled Sculpin##45563,Cooking,1 total
		.' Cook Grilled Sculpin |achieve 1777/14
	step
		.create Haunted Herring##58525,Cooking,1 total
		.' Cook Haunted Herring |achieve 1777/15
		.' Eat Haunted Herring |achieve 1780/2|use Haunted Herring##43492
	step
		.create Hearty Rhino##57436,Cooking,1 total
		.' Cook Hearty Rhino |achieve 1778/16
	step
		.create Imperial Manta Steak##45570,Cooking,1 total
		.' Cook Imperial Manta Steak |achieve 1778/17
	step
		.create Kungaloosh##53056,Cooking,1 total
		.' Cook Kungaloosh |achieve 1778/18
	step
		.create Last Week's Mammoth##58521,Cooking,1 total
		.' Cook Last Week's Mammoth |achieve 1778/19
		.' Eat Last Week's Mammoth |achieve 1780/3 |use Last Week's Mammoth##43488
	step
		.create Mammoth Meal##45549,Cooking,1 total
		.' Cook Mammoth Meal |achieve 1778/20
	step
		.create Mega Mammoth Meal##45555,Cooking,1 total
		.' Cook Mega Mammoth Meal |achieve 1778/21
	step
		.create Mighty Rhino Dogs##45559,Cooking,1 total
		.' Cook Mighty Rhino Dogs |achieve 1778/22
	step
		.create Northern Stew##57421,Cooking,1 total
		.' Cook Northern Stew |achieve 1778/23
	step
		.create Pickeled Fangtooth##45566,Cooking,1 total
		.' Cook Pickeled Fangtooth |achieve 1778/24
	step
		.create Poached Nettlefish##45565,Cooking,1 total
		.' Cook Poached Nettlefish |achieve 1778/25
	step
		.create Poached Northern Sculpin##45567,Cooking,1 total
		.' Cook Poached Northern Sculpin |achieve 1778/26
	step
		.create Rhino Dogs##45553,Cooking,1 total
		.' Cook Rhino Dogs |achieve 1778/27
	step
		.create Rhinolicious Wormsteak##57434,Cooking,1 total
		.' Cook Rhinolicious Wormsteak |achieve 1778/28
	step
		.create Roasted Worg##45552,Cooking,1 total
		.' Cook Roasted Worg |achieve 1778/29
	step
		.create Sauteed Goby##45562,Cooking,1 total
		.' Cook Sauteed Goby |achieve 1778/30
	step
		.create Shoveltusk Steak##45550,Cooking,1 total
		.' Cook Shoveltusk Steak |achieve 1779/31
	step
		.create Small Feast##58528,Cooking,1 total
		.' Cook Small Feast |achieve 1779/32
	step
		.create Smoked Rockfin##45560,Cooking,1 total
		.' Cook Smoked Rockfin |achieve 1779/33
	step
		.create Smoked Salmon##45564,Cooking,1 total
		.' Cook Smoked Salmon |achieve 1779/34
	step
		.create Snapper Extreme##57437,Cooking,1 total
		.' Cook Snapper Extreme |achieve 1779/35
	step
		.create Spiced Mammoth Treats##57440,Cooking,1 total
		.' Cook Spiced Mammoth |achieve 1779/36
	step
		.create Spiced Worm Burger##45557,Cooking,1 total
		.' Cook Spiced Worm Burger |achieve 1779/37
	step
		.create Spicy Blue Nettlefish##45571,Cooking,1 total
		.' Cook Spicy Blue Nettlefish |achieve 1779/38
	step
		.create Spicy Fried Herring##57433,Cooking,1 total
		.' Cook Spicy Fried Herring |achieve 1779/39
	step
		.create Tasty Cupcake##58512,Cooking,1 total
		.' Cook Tasty Cupcake |achieve 1779/40
		.' Eat Tasty Cupcake |achieve 1780/4 |use Tasty Cupcake##43490
	step
		.create Tender Shoveltusk Steak##45556,Cooking,1 total
		.' Cook Tender Shoveltusk Steak |achieve 1779/41
	step
		.create Tracker Snacks##57443,Cooking,1 total
		.' Cook Tracker Snacks |achieve 1779/42
	step
		.create Very Burnt Worg##45558,Cooking,1 total
		.' Cook Very Burnt Worg |achieve 1779/43
	step
		.create Worg Tartare##62350,Cooking,1 total
		.' Cook Worg Tartare |achieve 1779/44
	step
		.create Worm Delight##45551,Cooking,1 total
		.' Cook Worm Delight |achieve 1779/45
		.' Cook 45 of the Northrend recipes |achieve 1779
	step
		'Congratulations! You've earned the Northrend Gourment achievement!
]])

ZygorGuidesViewer:RegisterInclude("H_The_Outland_Gourmet",[[
	step
	title +The Burning Crusade Recipes
		#include trainCooking
		.learn Stewed Trout##42296 		
		.learn Fisherman's Feast##42302 
		.learn Hot Buttered Trout##42305 
	//300 Buzzard Bites TBC
	step
		goto Hellfire Peninsula,49.2,74.8
		.talk Legassi##19344
		..accept Ravager Egg Roundup##9349
	step
		goto 39.0,88.4
		.from Razorfang Hatchling##16932+,Razorfang Ravager##16933+
		.get 12 Ravager Egg##23217 |q 9349/1
	step
		goto Hellfire Peninsula,49.2,74.8
		.talk Legassi##19344
		..turnin Ravager Egg Roundup##9349
	step
		goto Hellfire Peninsula,49.2,74.8
		.talk Legassi##19344
		..accept Helboar, the Other White Meat##9361
	step
		goto 51.2,69.8
		.from Deranged Helboar##16863
		.collect 8 Tainted Helboar Meat##23270
	step
		'Use the Purification Mixture on the Tainted Meat |use Purification Mixture##23268
		.get 8 Purified Helboar Meat##23248 |q 9361/1
	step
		goto Hellfire Peninsula,49.2,74.8
		.talk Legassi##19344
		..turnin Helboar, the Other White Meat##9361
	step
		goto Hellfire Peninsula,49.2,74.8
		.talk Legassi##19344
		..accept Smooth as Butter##9356
	step
		goto 61.0,66.6
		.from Bonestripper Buzzard##16972
		.get 12 Plump Buzzard Wing |q 9356/1
	step
		goto Hellfire Peninsula,49.2,74.8
		.talk Legassi##19344
		..accept Smooth as Butter##9356
		.collect 1 Recipe: Buzzard Bites##27684 |n
		.learn Buzzard Bites##33279 |use Recipe: Buzzard Bites##27684
		//300 Ravager Dog TBC
	step
		//alliance: 
		//goto Hellfire Peninsula,54.2,63.6
		//.talk Sid Limbardi##16826
		//horde:
		goto Hellfire Peninsula,54.6,41.0
		.talk Cookie One-Eye##16585
		.buy 1 Recipe: Ravager Dog##27688 |n
		.learn Ravager Dog##33284 |use Recipe: Ravager Dog##27688
	//300 Feltail Delight TBC blackened trout
	step
		//alliance:
		//goto Zangarmarsh,42.2,27.8
		//.talk Doba##20028
		//horde:
		goto Zangarmarsh,85.2,54.6
		.talk Zurai##18011
		.buy 1 Recipe Feltail Delight##27695 |n
		.learn Feltail Delight##33291 |use Recipe Feltail Delight##27695
	step
		goto Zangarmarsh 31.6,49.2
		.talk Gambarinka##18015
		.buy Recipe: Blackened Trout##27694 |n
		.learn Blackened Trout##33290 |use Recipe: Blackened Trout##27694 
	//300 Clam Bar TBC
	step
		goto Zangarmarsh,17.8,51.2
		.talk Mycah##18382
		.buy 1 Recipe: Clam Bar##30156 |n
		.learn Clam Bar##36210 |use Recipe: Clam Bar##30156
	//310 Blackened Sporefish TBC
	step
		//both
		goto Zangarmarsh,78.0,66.0
		.talk Juno Dufrain##18911
		.buy 1 Recipe: Blackened Sporefish##27696 |n
		.learn Blackened Sporefish##33292 |use Recipe: Blackened Sporefish##27696
	//310 Sporeling Snack TBC --help
	//320 Grilled Mudfish TBC, poached bluefish, talbuk steak. roasted clefthoof
	step
		//alliance
		//goto Nagrand,56.2,73.2
		//.talk Uriku##20096
		//horde
		goto Nagrand,58.0,35.6 
		.talk Nula the Butcher##20097
		.buy 1 Recipe: Grilled Mudfish##27697
		.buy 1 Recipe: Talbuk Steak##27693
		.buy 1 Recipe: Poached Bluefish##27698
		.buy 1 Recipe: Roasted Clefthoof##27691
	step
		.learn Talbuk Steak##33289 |use Recipe: Talbuk Steak##27693
		.learn Grilled Mudfish##33293 |use Recipe: Grilled Mudfish##27697
		.learn Poached Bluefish##33294 |use Recipe: Poached Bluefish##27698
		.learn Roasted Clefthoof##33287 |use Recipe: Roasted Clefthoof##27691
	//325 Golden Fish Sticks TBC + Spicy Crawdad TBC
	step
		//alliance
		//goto Terokkar Forest,56.6,53.2
		//.talk Biribi##19296
		//horde
		goto Terokkar Forest,48.8,46.0
		.talk Rungor##18960
		.buy 1 Recipe: Golden Fish Sticks##27699 |n
		.buy 1 Recipe: Spicy Crawdad##27700 |n
		.learn Golden Fish Sticks##33295 |use Recipe: Golden Fish Sticks##27699
		.learn Spicy Crawdad##33296 |use Recipe: Spicy Crawdad##27700 
	//315 Blackened Basilisk TBC + warp burger
	step
		//allaince
		//goto Terokkar Forest,55.8,53.0
		//.talk Supply Officer Mills##19038
		//horde
		goto Terokkar Forest,48.8,45.0
		.talk Innkeeper Grilka##18957
		.buy 1 Recipe Blackened Basilisk##27690 |n
		.buy 1 Recipe: Warp Burger##27692 |n
		.learn Blackened Basilisk##33286 |use Recipe Blackened Basilisk##27690
		.learn Warp Burger##33288 |use Recipe: Warp Burger##27692
	//325 Warp Burger TBC
	//335 Crunchy Serpent TBC + Mok'Nathal Shortribs TBC
	step
		goto Blade's Edge Mountains,62.4,40.2
		.talk Xerintha Ravenoak##20916
		.buy 1 Recipe: Mok'Nathal Shortribs##31675 |n
		.buy 1 Recipe: Crunchy Serpent##31674 |n
		.learn Mok'Nathal Shortribs##38867 |use Recipe: Mok'Nathal Shortribs##31675
		.learn Crunchy Serpent##38868 |use Recipe: Crunchy Serpent##31674
	step
		'Use the Shattrath Cooking Dailies section of this guide to get these recipes: |tip It's not always guarenteed to come from these daily prizes so be patient
		'Make sure to choose the Crate of Meat
		.collect 1 Recipe: Spicy Hot Talbuk##33873
	step
		.learn Spicy Hot Talbuk##43765 |use Recipe: Spicy Hot Talbuk##33873
	//300 Broiled Bloodfin TBC + Skullfish Soup TBC
	step
		//Barrel of fish 
		'Use the Shattrath Cooking Dailies section of this guide to get these recipes: |tip It's not always guarenteed to come from these daily prizes so be patient
		'Make sure to choose the Barrel of Fish
		.collect 1 Recipe: Broiled Bloodfin##33869
		.collect 1 Recipe: Skullfish Soup##33870
	step
		.learn Broiled Bloodfin##43761 |use Recipe: Broiled Bloodfin##33869
		.learn Skullfish Soup##43707 |use Recipe: Skullfish Soup##33870
	//300 Kibler's Bits TBC
	step
		'Use the Shattrath Cooking Dailies section of this guide to get this recipe: |tip It's not always guarenteed to come from these daily prizes so be patient
		'You can choose either the Crate of Meat of Barrel of Fish 
		.collect 1 Recipe: Kibler's Bits##33875
	step
		.learn Kibler's Bits##43772 |use Recipe: Kibler's Bits##33875
	//300 Stormchops TBC
	step
		'Use the Shattrath Cooking Dailies or Dalaran Cooking Dailies section of this guide to get these recipes: |tip It's not always guarenteed to come from these daily prizes so be patient
		'You can choose either Crate of Meat, Barrel of Fish, or Small Spice Bag
		.collect 1 Recipe: Stormchops##33871
		.collect 1 Recipe: Delicious Chocolate Cake##33925
	step
		.learn Stormchops##43758 |use Recipe: Stormchops##33871
		.learn Delicious Chocolate Cake##43779 |use Recipe: Delicious Chocolate Cake##33925
	step
		'You can either purchase these items from the Acution House or farm them
		.collect 8 Small Eggs##6889
		.collect 2 Buzzard Meat##27671
		.collect 2 Clefthoof Meat##27678
		.collect 2 Jaggal Clam Meat##24477
		.collect 2 Talbuk Venison##27682
		.collect 1 Chunk o' Basilisk##27677
		.collect 1 Raptor Ribs##31670
		.collect 1 Ravager Flesh##27674
		.collect 1 Serpent Flesh##31671
		.collect 1 Strange Spores##27676
		.collect 1 Warped Flesh##27681
		.collect 3 Mageroyal##785
	step
		'You can either purchase these items from the Auction House or fish for them
		.collect 2 Barbed Gill Trout##27422
		.collect 1 Bloodfin Catfish##33823
		.collect 1 Crescent-Tail Skullfish##33824
		.collect 1 Enormous Barbed Gill Trout##27516
		.collect 1 Figluster's Mudfish##27435
		.collect 1 Golden Darter##27438
		.collect 1 Huge Spotted Feltail##27515
		.collect 1 Icefin Bluefish##27437
		.collect 1 Lightning Eel##13757
		.collect 1 Spotted Feltail##27425
		.collect 1 Zangarian Sporefish##27429
	step
		goto Orgrimmar,50.8,74.6
		.talk Shan'ti##3342
		.buy 5 Goldenbark Apple##4539
	step
		goto Orgrimmar,53.6,78.8
		.talk Innkeeper Gryshka##6929
		.buy 4 Ice Cold Milk##1179
	step
		goto Orgrimmar,56.5,61.2
		.talk Suja##46708
		.buy 8 Simple Flour##30817
		.buy 4 Mild Spices##2678 
	step
		fly Fizzle & Pozzik's Speedbarge
	step
		goto Thousand Needles 76.5,74.8
		.talk Daisy##40832
		.buy 1 Flask of Port##2593
	step
		'Build a Basic Campfire |cast Basic Campfire##818
		.create Delicious Chocolate Cake##43779,Cooking,1 total
		.' Cook Delicious Chocolate Cake |achieve 1800/1
	step
		.create Blackened Trout##33290,Cooking,1 total
		.' Cook Blackened Trout |achieve 1800/2
	step
		.create Buzzard Bites##33279,Cooking,1 total
		.' Cook Buzzard Bites |achieve 1800/3
	step
		.create Clam Bar##36210,Cooking,1 total
		.' Cook Clam Bar |achieve 1800/4
	step
		.create Feltail Delight##33291,Cooking,1 total
		.' Cook Feltail Delight |achieve 1800/5
	step
		.create Ravager Dog##33284,Cooking,1 total
		.' Cook Ravager Dog |achieve 1800/6
	step
		.create Stormchops##43758,Cooking,1 total
		.' Cook Stormchops |achieve 1800/7
	step
		.create Blackened Sporefish##33292,Cooking,1 total
		.' Cook Blackened Sporefish |achieve 1800/8
	step
		.create Blackened Basilisk##33286,Cooking,1 total
		.' Cook Blackened Basilisk |achieve 1800/9
	step
		.create Grilled Mudfish##33293,Cooking,1 total
		.' Cook Grilled Mudfish |achieve 1800/10
	step
		.create Poached Bluefish##33294,Cooking,1 total
		.' Cook Poached Bluefish |achieve 1800/11
	step
		.create Broiled Bloodfin##43761,Cooking,1 total
		.' Cook Broiled Bloodfin |achieve 1800/12
	step
		.create Golden Fish Sticks##33295,Cooking,1 total
		.' Cook Golden Fish Sticks |achieve 1800/13
	step
		.create Kibler's Bits##43772,Cooking,1 total
		.' Cook Kibler's Bits |achieve 1800/14
	step
		.create Roasted Clefthoof##33287,Cooking,1 total
		.' Cook Roasted Clefthoof |achieve 1800/15
	step
		.create Talbuk Steak##33289,Cooking,1 total
		.' Cook Talbuk Steak |achieve 1800/16
	step
		.create Warp Burger##33288,Cooking,1 total
		.' Cook Warp Burger |achieve 1800/17
	step
		.create Crunchy Serpent##38868,Cooking,1 total
		.' Cook Crunchy Serpent |achieve 1800/18
	step
		.create Mok'Nathal Shortribs##38867,Cooking,1 total
		.' Cook Mok'Nathal |achieve 1800/19
	step
		.create Fisherman's Feast##42302,Cooking,1 total
		.' Cook Fisherman's Feast |achieve 1800/20
	step
		.create Hot Buttered Trout##42305,Cooking,1 total
		.' Cook Hot Buttered Trout |achieve 1800/21
	step
		.create Skullfish Soup##43707,Cooking,1 total
		.' Cook Skullfish Soup |achieve 1800/22
	step
		.create Spicy Crawdad##33296,Cooking,1 total
		.' Cook Spicy Crawdad |achieve 1800/23
	step
		.create Spicy Hot Talbuk##43765,Cooking,1 total
		.' Cook Spicy Hot Talbuk |achieve 1800/24
	step
		.create Stewed Trout##42296,Cooking,1 total
		.' Cook Stewed Trout |achieve 1800/25
	step
		.' Cook each of the Outland cooking recipes |achieve 1800
	step
		Congratulations! You're earned The Outland Gourmet achievement!
]])

ZygorGuidesViewer:RegisterInclude("H_Kickin'_It_Up_a_Notch",[[ 
	step
	label "warning"
		.' The following quests are random and you can only do one per day. Click to proceed. |confirm always
	step
	label "hub"
		goto Shattrath City,61.8,15.6
		.talk The Rokk##24393
		.' You will only be able to accept one of these daily quests per day
		..accept Soup for the Soul##11381 |or
		..accept Super Hot Stew##11379 |or
		..accept Manalicious##11380 |or
		..accept Revenge is Tasty##11377 |or
	step
		goto Nagrand,58.0,35.6
		.talk Nula the Butcher##20097
		.buy Recipe: Roasted Clefthoof##27691 |n
		.' Click the Recipe: Roasted Clefthoof in your bags |use Recipe: Roasted Clefthoof##27691
		.learn Roasted Clefthoof##33287 |q 11381
	step
		goto Nagrand,47.0,64.7
		.from Clefthoof##18205+, Clefthoof Calf##19183+
		.collect 4 Clefthoof Meat##27678 |q 11381
		.' You can find more Clefthooves at [45.5,72.7]
	step
		.' Build a Basic Campfire |cast Basic Campfire##818
		.create Roasted Clefthoof##33287,Cooking,4 total |q 11381
	step
		goto 25.9,59.5
		.' Use your Cooking Pot to Cook up some Spiritual Soup |use Cooking Pot##33851
		.' Cook a Spiritual Soup |q 11381/1
	step
		goto Blade's Edge Mountains,62.5,40.3
		.talk Xerintha Ravenoak##20916
		.buy Recipe: Mok'Nathal Shortribs##31675 |n
		.' Click the Recipe: Mok'Nathal Shortribs in your bags |use Recipe: Mok'Nathal Shortribs##31675
		.learn Mok'Nathal Shortribs##38867 |q 11379
		.buy Recipe: Crunchy Serpent##31674 |n
		.' Click the Recipe: Crunchy Serpent in your bags |use Recipe: Mok'Nathal Shortribs##31674
		.learn Crunchy Serpent##38868 |q 11379
	step
		goto Blade's Edge Mountains,49.6,46.2
		.from Daggermaw Blackhide##22052+, Bladespire Raptor##20728+
		.collect 2 Raptor Ribs##31670+ |q 11379
	step
		goto 68.2,63.2
		.from Scalewing Serpent##20749+, Felsworn Scalewing##21123+
		.collect 1 Serpent Flesh##31671 |q 11379
	step
		.' Build a Basic Campfire |cast Basic Campfire##818
		.create 2 Mok'Nathal Shortribs##38867,Cooking,2 total |q 11379
	step
		.' Build a Basic Campfire |cast Basic Campfire##818
		.create 1 Crunchy Serpent##38868,Cooking,1 total |q 11379
	step
		goto 29.0,84.5
		.from Abyssal Flamebringer##19973+
		.' Use your Cooking Pot next to the Abyssal Flamebringer corpse to Cook up some Demon Broiled Surprise |use Cooking Pot##33852
		.get Demon Broiled Surprise |q 11379/1
	step
		goto Netherstorm,45.6,54.2
		.click Mana Berry Bush##28+
		.get 15 Mana Berry##33849+ |q 11380/1
	step
		goto Terokkar Forest,48.8,45.0
		.talk Innkeeper Grilka##18957
		.buy Recipe: Warp Burger##27692 |n
		.' Click the Recipe: Warp Burger in your bags |use Recipe: Warp Burger##27692
		.learn Warp Burger##33288 |q 11377
	step
		goto 64.0,83.5
		.from Blackwind Warp Chaser##23219+
		.collect 3 Warped Flesh##27681 |q 11377
	step
		goto 67.6,74.7
		.from Monstrous Kaliri##23051+ |tip They fly around in the sky close to the tree outposts and bridges.
		.collect Giant Kaliri Wing##33838 |q 11377
	step
		goto 25.9,59.5
		.' Build a Basic Campfire |cast Basic Campfire##818
		.create Warp Burger##33288,Cooking,3 total |q 11377
		.' Use your Cooking Pot to Cook up some Kaliri Stew |use Cooking Pot##33837
		.create Kaliri Stew##43718,Cooking,1 total |q 11377/1
	step
		goto Shattrath City,61.8,15.6
		.talk The Rokk##24393
		..turnin Soup for the Soul##11381
		..turnin Super Hot Stew##11379
		..turnin Manalicious##11380 
		..turnin Revenge is Tasty##11377
	step
		'You've completed all the dailies you can do today. Click to go back to the dailies hub. |confirm |next "-warning" |only if not step:Find("+check"):IsComplete()
		'Checking achievements |next |only if default
	step
	label "check"
		.' Daily Completed "Revenge is Tasty" |achieve 906/1
		.' Daily Completed "Super Hot Stew" |achieve 906/2
		.' Daily Completed "Manalicious" |achieve 906/3
		.' Daily Completed "Soup for the Soul" |achieve 906/4
		.' Earn the Kickin' It Up a Notch Achievement |achieve 906
	step
		'Congratulations!  You've earned "Kickin' It Up a Notch" Achievement.
]])

ZygorGuidesViewer:RegisterInclude("H_Our_Daily_Bread",[[
	step
	title +Dalaran Cooking Dailies
		goto Dalaran,70.0,39.0
		.talk Awilo Lon'gomba##29631
		.' You will only be able to accept, and turn in, 1 of these 5 daily quests per day, and they all require you have 350+ Cooking skill:
		..accept Cheese for Glowergold##13115 |or
		..accept Convention at the Legerdemain##13113 |or
		..accept Infused Mushroom Meatloaf##13112 |or
		..accept Mustard Dogs!##13116 |or
		..accept Sewer Stew##13114 |or
	step
		goto 54.7,31.5
		.' Click the Aged Dalaran Limburger |tip They look like piles and pieces of yellow cheese on the tables inside this building.
		.collect 1 Aged Dalaran Limburger##43137 |q 13115
		.' Click the Half Full Glasses of Wine |tip They look like small blue-ish wine glasses sitting on tables, and on the ground, inside this building.  They spawn in random locations.
		.collect 6 Half Full Dalaran Wine Glass##43138 |q 13115
		.' You can find more Half Full Glasses of Wine inside the building at [49.4,39.3]
	step
		'Use your Empty Cheese Serving Platter in your bags |use Empty Cheese Serving Platter##43139
		.get 1 Wine and Cheese Platter |q 13115/1
	step
		goto 55.0,30.8
		.' Click a Full Jug of Wine |tip They look like small blue-ish green jugs sitting on the ground inside this building.  They spawn in random locations.
		.get 1 Jug of Wine |q 13113/2
	step
		goto Dragonblight,30.0,49.8
		.from Rabid Grizzly##26643+, Blighted Elk##26616+
		.collect 10 Chilled Meat##43013 |q 13113
	step
		'Create a basic campfire |cast Basic Campfire##818
		.create 4 Northern Stew##57421,Cooking,4 total
		.get 4 Northern Stew |q 13113/1
	step
		'The entrance to the Dalaran sewers starts here |goto Dalaran,60.2,47.7,0.3 |c |q 13112
	step
		goto 59.5,43.6
		.from Underbelly Rat##32428+
		.collect 4 Infused Mushroom##43100 |q 13112
	step
		'Leave the Dalaran sewers |goto Dalaran,60.2,47.7,0.3|c|q 13112
	step
		goto Dragonblight,30.0,49.8
		.from Rabid Grizzly##26643+, Blighted Elk##26616+
		.collect 2 Chilled Meat##43013 |q 13112
	step
		'Create a basic campfire |cast Basic Campfire##818
		'Use your Meatloaf Pan in your bags |use Meatloaf Pan##43101 |tip You will need a cooking fire to do this.
		.get 1 Infused Mushroom Meatloaf |q 13112/1
	step
		goto Dalaran,67.7,40.0
		.click the Wild Mustard##8340
		.collect 4 Wild Mustard##43143 |q 13116
		.' You can find more Wild Mustard flowers:
		..' at [50.3,48.3]
		..' at [37.2,43.9]
	step
		goto Borean Tundra,46.7,43.6
		.from Wooly Rhino Calf##25488+, Wooly Rhino Matriarch##25487+, Wooly Rhino Bull##25489+
		.collect 4 Rhino Meat##43012 |q 13116
	step
		'Create a basic campfire |cast Basic Campfire##818
		.create Rhino Dog##45553,Cooking,4 total |q 13116
		.collect 4 Rhino Dogs##34752 |q 13116
	step
		'Use your Empty Picnic Basket in your bags|use Empty Picnic Basket##43142
		.get 1 Mustard Dog Basket! |q 13116/1
	step
		goto Crystalsong Forest,26.7,44.1
		.click Crystalsong Carrot##4652+ 
		.collect 4 Crystalsong Carrot##43148 |q 13114
	step
		'Create a basic campfire |cast Basic Campfire##818
		'Use your Stew Cookpot in your bags |use Stew Cookpot##43147
		.get 1 Vegetable Stew |q 13114/1
	step
		goto Dalaran,36.6,27.8
		.talk Ranid Glowergold##28718
		..turnin Cheese for Glowergold##13115
		.' Completed Daily "Cheese for Glowergold" |achieve 1783/4
	step
		goto Dalaran,48.6,37.5
		.talk Arille Azuregaze##29049
		..turnin Convention at the Legerdemain##13113 
		.' Completed Daily "Conventrion at the Legermain" |achieve 1783/2
	step
		goto Dalaran,52.3,55.6
		.talk Orton Bennet##29527
		..turnin Infused Mushroom Meatloaf##13112
		.' Completed Daily "Infused Mushroom Meatloaf" |achieve 1783/1
	step
		goto Dalaran,68.6,42.0
		.talk Archmage Pentarus##28160
		..turnin Mustard Dogs!##13116
		.' Completed Daily "Mustard Dogs!" |achieve 1783/5
	step
		'The entrance to the Dalaran sewers starts here |goto Dalaran,60.2,47.7,0.3 |c |q 13114
	step
		goto Dalaran,35.5,57.6
		.talk Ajay Green##29532
		..turnin Sewer Stew##13114
		.' Completed Daily "Sewer Stew" |achieve 1783/3
	step
		'Congratulations! You've earned the Our Daily Bread achievement! |achieve 1783
]])

ZygorGuidesViewer:RegisterInclude("H_Captain_Rumsey's_Lager",[[
	step
		'Use the Shattrath or Dalaran Cooking Dailies, or the Fishing Dailies of this guide to get this recipe: |tip It's not always guarenteed to come from these daily prizes so be patient
		.collect 1 Recipe: Captain Rumsey's Lager##34834
	step
		.learn Captain Rumsey's Lager##45695 |use Recipe: Captain Rumsey's Lager##34834
	step
		'Congratulation, you have earned the achievement Captain Rumsey's Lager! |achieve 1801
]])

ZygorGuidesViewer:RegisterInclude("H_Critter_Gitter",[[
	step
		'You can either buy these from the Auction House or farm them
		.collect 10 Critter Bites##43004
		.' Click here to go farm for these |confirm |next "farm1"
		|next "gitter"
	step
	label farm1
		'You can either buy these from the Auction House or farm them
		.collect 20 Chilled Meat##43013
		.collect 10 Northern Spices##43007
		.' Click here to go farm for these |confirm |next "farm2"
		|next "recipe"
	step
	label farm2
	title +Chilled Meat
		goto Borean Tundra,78.2,24.0
		.from Scourged Mammoth##25452+
		.collect 20 Chilled Meat##43013
	step
	title +Northern Spices
		'Use the Dalaran Cooking Dailies section of this guide to get Small Spice Bags
		.collect Spice Bag##44113 |n
		.collect 10 Northern Spices##43007
	step
	label make
	title +Critter Gitter
		'Get someone to make your 10 Critter Bites |tip Ask in your guild or in trade for someone to make these. Be sure to tip well! 
		.' Or... |only if skill("Cooking")>=400
		'Build a Basic Campfire |cast Basic Campfire##818 |only if skill("Cooking")>=400
		.create Critter Bites##57435,Cooking,10 total |only if skill("Cooking")>=400
		.collect 10 Critter Bites##43004
		.' Click here if you don't have the recipe |confirm |next "recipe" |only if skill("Cooking")>=400
		|next "gitter"
	step
	label recipe
		'Use the Dalaran Cooking Dailies section of this guide to earn 3 Dalaran Cooking Awards
		.earn 3 Dalaran Cooking Award##81 
	step
		goto Dalaran,70.2,37.2
		.talk Misensi##31031
		.buy 1 Recipe: Critter Bites##43029
	step
		.learn Critter Bites##57435
	step
		'Build a Basic Campfire |cast Basic Campfire##818 
		.create Critter Bites##57435,Cooking,10 total 
		.collect 10 Critter Bites##43004
	step
	label gitter
		goto Eastern Plaguelands,4.7,35.5
		'Target the Beetles, Scorpions, and Cockroaches and use the Critter Bites on them |use Critter Bites##43004
		|tip Use all 10 Critter Bites as quick as possible. These critters are scattered all throughout the tunnel.
		.' Coerce 10 critters to be your pet within 3 minutes or less |achieve 1781
	step
		'Congratulations! You've earned the Critter Gitter achievement!
]])

ZygorGuidesViewer:RegisterInclude("H_Dinner_Impossible",[[
	step
		'You can either buy these items from the auction house or use the Cooking professions guide to reach level 375 Cooking, otherwise you cannot complete this achievement. |only if skill("Cooking")<375
		'You can either buy these items from the auction house or farm them |only if skill("Cooking")>=375
		.collect 5 Great Feast##34753
		.' Click here to go farm these materials |confirm |next "farm1"
		|next usefeast
	step
		#include trainCooking
		.learn Great Feast##45554
	step
	label farm1
		'You can either buy these items from the auction house or farm them 
		.collect 5 Chunk o'Mammoth##34736 
		.collect 5 Shoveltusk Flank##43009 
		.collect 5 Worm Meat##43010 
		.collect 10 Chilled Meat##43013 
		.' Click here to go farm these materials |confirm |next "farm2"
		|next makefeast
	step
	label farm2
		goto Borean Tundra 78.2,24.0
		.from Scourged Mammoth##25452+
		.collect 5 Chunk o'Mammoth##34736 
		.collect 10 Chilled Meat##43013 
	step
		goto 76.2,23.0
		.from Tundra Crawler##25454+
		.collect 5 Worm Meat##43010 
	step
		fly Vengeance Landing
	step
		goto Howling Fjord 73.6,40.0
		.from Shoveltusk##23690+
		.collect 5 Shoveltusk Flank##43009 
	step
	label makefeast
		'Have someone make the Great Feasts for you |tip Ask in your guild or in trade for someone to make these |only if skill("Cooking")<375
		'Create a basic campfire |cast Basic Campfire##818 |only if skill("Cooking")>=375
		.create 5 Great Feast##45554,Cooking,5 total |only if skill("Cooking")>=375
		.collect 5 Great Feast##34753
	step
	label usefeast
		'Push [H] on your keyboard to open your Player vs. Player interface 
		.' Click on Alterac Valley and then click on the Join Battle button on the lower left-hand corner of the Player vs. Player interface
		..' Wait for the que to pop-up in the middle of your screen and click on accept	
		..' Go to Alterac Valley |goto Alterac Valley |noway |c
	step
		'Use one of your Great Feasts |use Great Feast##34753 
		.' Present a Great Feast in Alterac Valley |achieve 1784/1 |tip You can leave the battleground now, but you will have to wait 15 minutes to complete the next step
	step
		'Push [H] on your keyboard to open your Player vs. Player interface 
		.' Click on Arathi Basin and then click on the Join Battle button on the lower left-hand corner of the Player vs. Player interface
		..' Wait for the que to pop-up in the middle of your screen and click on accept	
		..' Go to Arathi Basin |goto Arathi Basin |noway |c
	step
		'Use one of your Great Feasts |use Great Feast##34753 
		.' Present a Great Feast in Arathi Basin |achieve 1784/2 |tip You can leave the battleground now, but you will have to wait 15 minutes to complete the next step
	step
		'Push the [H] key on your keyboard to open your Player vs. Player interface 
		.' Click on Warsong Gulch and then click on the Join Battle button on the lower left-hand corner of the Player vs. Player interface
		..' Wait for the que to pop-up in the middle of your screen and click on accept	
		..' Go to Warsong Gulch |goto Warsong Gulch |noway |c
	step
		'Use one of your Great Feasts |use Great Feast##34753 
		.' Present a Great Feast in Warsong Gulch |achieve 1784/3 |tip You can leave the battleground now, but you will have to wait 15 minutes to complete the next step
	step
		'Push [H] on your keyboard to open your Player vs. Player interface 
		.' Click on Strand of the Ancients and then click on the Join Battle button on the lower left-hand corner of the Player vs. Player interface
		..' Wait for the que to pop-up in the middle of your screen and click on accept	
		..' Go to Strand of the Ancients |goto Strand of the Ancients |noway |c
	step
		'Use one of your Great Feasts |use Great Feast##34753 
		.' Present a Great Feast in Strand of the Ancients |achieve 1784/4 |tip You can leave the battleground now, but you will have to wait 15 minutes to complete the next step
	step
		'Push [H] on your keyboard to open your Player vs. Player interface 
		.' Click on Arathi Basin and then click on the Join Battle button on the lower left-hand corner of the Player vs. Player interface
		..' Wait for the que to pop-up in the middle of your screen and click on accept	
		..' Go to Eye of the Storm |goto Arathi Basin |noway |c
	step
		'Use one of your Great Feasts |use Great Feast##34753 
		.' Present a Great Feast in Eye of the Storm |achieve 1784/5 
	step
		Congratulations! You've earned the Dinner Impossible achievement!
]])

ZygorGuidesViewer:RegisterInclude("H_Dalaran_Cooking_Dailies",[[
	daily
		goto Dalaran,70.0,39.0
		.talk Awilo Lon'gomba##29631
		.' You will only be able to accept, and turn in, 1 of these 5 daily quests per day, and they all require you have 350+ Cooking skill:
		..accept Cheese for Glowergold##13115 |or
		..accept Convention at the Legerdemain##13113 |or
		..accept Infused Mushroom Meatloaf##13112 |or
		..accept Mustard Dogs!##13116 |or
		..accept Sewer Stew##13114 |or
	step
		goto 54.7,31.5
		.' Click the Aged Dalaran Limburger|tip They look like piles and pieces of yellow cheese on the tables inside this building.
		.collect 1 Aged Dalaran Limburger##43137 |q 13115
		.' Click the Half Full Glasses of Wine|tip They look like small blue-ish wine glasses sitting on tables, and on the ground, inside this building.  They spawn in random locations.
		.collect 6 Half Full Dalaran Wine Glass##43138 |q 13115
		.' You can find more Half Full Glasses of Wine inside the building at [49.4,39.3]
	step
		'Use your Empty Cheese Serving Platter in your bags|use Empty Cheese Serving Platter##43139
		.get 1 Wine and Cheese Platter |q 13115/1
	step
		goto 55.0,30.8
		.' Click a Full Jug of Wine|tip They look like small blue-ish green jugs sitting on the ground inside this building.  They spawn in random locations.
		.get 1 Jug of Wine |q 13113/2
	step
		goto Dragonblight,30.0,49.8
		.from Rabid Grizzly##26643+, Blighted Elk##26616+
		.collect 4 Chilled Meat##43013 |q 13113
	step
		'Use your Cooking ability to cook 4 Northern Stew|tip You will need a cooking fire to do this.
		.get 4 Northern Stew |q 13113/1
	step
		'The entrance to the Dalaran sewers starts here|goto Dalaran,60.2,47.7,0.3|c|q 13112
	step
		 goto Dalaran/2 51.6,41.6
		.click Infused Mushroom##359+
		.collect 4 Infused Mushroom##43100 |q 13112
	step
		'Leave the Dalaran sewers|goto Dalaran,60.2,47.7,0.3|c|q 13112
	step
		goto Dragonblight,30.0,49.8
		.from Rabid Grizzly##26643+, Blighted Elk##26616+
		.collect 2 Chilled Meat##43013 |q 13112
	step
		'Use your Meatloaf Pan in your bags|use Meatloaf Pan##43101|tip You will need a cooking fire to do this.
		.get 1 Infused Mushroom Meatloaf |q 13112/1
	step
		goto Dalaran,67.7,40.0
		.click Wild Mustard##8340
		|tip They look like small, and kind of hard to see, bushy yellow flowers on the ground around this area.  They spawn randomly in grassy areas.
		.collect 4 Wild Mustard##43143 |q 13116
		.' You can find more Wild Mustard flowers:
		..' at [50.3,48.3]
		..' at [37.2,43.9]
	step
		goto Borean Tundra,46.7,43.6
		.from Wooly Rhino Calf##25488+, Wooly Rhino Matriarch##25487+, Wooly Rhino Bull##25489+
		.collect 4 Rhino Meat##43012 |q 13116
	step
		.create 4 Rhino Dogs##45553,Cooking,4 total |n
		'Use your Cooking ability to cook 4 Rhino Dogs|tip You will need a cooking fire to do this.
		.collect 4 Rhino Dogs##34752 |q 13116
	step
		'Use your Empty Picnic Basket in your bags|use Empty Picnic Basket##43142
		.get 1 Mustard Dog Basket! |q 13116/1
	step
		goto Crystalsong Forest,26.9,45.5
		.' Click the Crystalsong Carrots|tip they look like carrots sticking out of the ground, at the base of trees around this area underneath Dalaran.  They spawn in random locations around this area.
		.collect 4 Crystalsong Carrot##43148 |q 13114
	step
		goto Dragonblight,30.0,49.8
		.from Rabid Grizzly##26643+, Blighted Elk##26616+
		.collect 4 Chilled Meat##43013 |q 13114
	step
		'Use your Stew Cookpot in your bags|use Stew Cookpot##43147|tip You will need a cooking fire to do this.
		.get 1 Vegetable Stew |q 13114/1
	step
		goto Dalaran,36.6,27.8
		.talk Ranid Glowergold##28718
		..turnin Cheese for Glowergold##13115
	step
		goto Dalaran,48.6,37.5
		.talk Arille Azuregaze##29049
		..turnin Convention at the Legerdemain##13113
	step
		goto Dalaran,52.3,55.6
		.talk Orton Bennet##29527
		..turnin Infused Mushroom Meatloaf##13112
	step
		goto Dalaran,68.6,42.0
		.talk Archmage Pentarus##28160
		..turnin Mustard Dogs!##13116
	step
		'The entrance to the Dalaran sewers starts here|goto Dalaran,60.2,47.7,0.3|c|q 13114
	step
		goto Dalaran,35.5,57.6
		.talk Ajay Green##29532
		..turnin Sewer Stew##13114
]])

ZygorGuidesViewer:RegisterInclude("H_MOP_Cooking_Dailies",[[
		'Proceeding to Cooking School Bell |only if completedq(31521)
		'Proceeding to Cooking Dailies |only if not completedq(31521) |next dailies
	step
		'Use the Cooking School Bell in your Bags |use Cooking School Bell##86425
		'If you do not have this yet, you can buy it from Nam Ironpaw here: [Valley of the Four Winds 53.6,51.2]
		.talk Nomi##64337
		..accept Lesson 1: Sliced Peaches##31332
		'|modelnpc Nam Ironpaw##64395
	step
		goto Valley of the Four Winds 53.6,51.2
		.talk Sungshin Ironpaw##64231
		.buy 5 Pandaren Peach##74660 |q 31332/1
	step
		'Use the Cooking School Bell in your Bags |use Cooking School Bell##86425
		.talk Nomi##64337
		..turnin Lesson 1: Sliced Peaches##31332
	step
	label	dailies
		goto Valley of the Four Winds 53.4,51.6
		.talk Jian Ironpaw##58716
		..accept The Truffle Shuffle##30330
		.'_
		.' Click here if this quest is not available today |confirm
	step
		goto 53.0,51.3
		.talk Kol Ironpaw##58712
		..accept Fatty Goatsteak##30332
		.'_
		.' Click here if this quest is not available today |confirm
	step
		goto 52.5,51.7
		.talk Yan Ironpaw##58715
		..accept The Thousand-Year Dumpling##30328
		.'_
		.' Click here if this quest is not available today |confirm
	step
		goto 52.8,51.8
		.talk Anthea Ironpaw##58713
		..accept Cindergut Peppers##30329
		.'_
		.' Click here if this quest is not available today |confirm
	step
		goto 52.6,51.6
		.talk Mei Mei Ironpaw##58714
		..accept The Mile-High Grub##30331
		.'_
		.' Click here if this quest is not available today |confirm
	step
		goto 32.5,23.9
		.' Use the _Master's Pot_ in your bags next to the bonfire. |use Master's Pot##79895
		.' Create 20 Mushan Tail Stew |q 30331/1
		|only if havequest(30331)
	step
		goto 31.2,36.0
		.from Kunzen Hunter##59121+, Kunzen Herdskeeper##59122+, Kunzen Ritualist##+59123, Kunzen Rockflinger##59120+,Kunzen Collector##59124+
		.collect 4 Cindergut Pepper##79864
		|only if havequest(30329)
	step
		goto 44.0,22.2 |n
		.' Enter the cave here |goto 44.0,22.2 <5 |noway |c
		|only if havequest(30328)
	step
		.click Preserved Vegetable##11054+
		.get 7 Preserved Vegetables |q 30328/1
		|only if havequest(30328)
	step
		goto 28.5,33.3
		.click Shadelight Truffle##11275+
		|tip You can find these aruond the trees here
		.get 8 Shadelight Truffle |q 30330/2
		.' Use your Shadelight Truffles in your bag |use Shadelight Truffle Spores##80127
		.' Plant 8 Shadelight Spores |q 30330/1
		|only if havequest(30330)
	step
		goto Valley of the Four Winds 29.7,41.4
		.from Stout Shaghorn##59139+
		.get 4 Fatty Goatsteak |q 30332/1
		|only if havequest(30332)
	step
		goto Valley of the Four Winds 52.8,51.8
		.talk Anthea Ironpaw##58713
		..turnin Cindergut Peppers##30329
	step
		goto Valley of the Four Winds 53.4,51.6
		.talk Jian Ironpaw##58716
		..turnin The Truffle Shuffle##30330
	step
		goto 52.5,51.7
		.talk Yan Ironpaw##58715
		..turnin The Thousand-Year Dumpling##30328
	step
		goto 53.0,51.3
		.talk Kol Ironpaw##58712
		..turnin Fatty Goatsteak##30332
	step
		goto 52.6,51.6
		.talk Mei Mei Ironpaw##58714
		..turnin The Mile-High Grub##30331
	step
		'You have reached the end of the dailies for today.
		.' Click here to go back to the beginning of the Pandaria Cooking Dailies. |confirm |next "dailies"
]])

ZygorGuidesViewer:RegisterInclude("Nomi_Dailies",[[
	step
	label "start"
		.' Use Cooking School Bell##86425
		.' Talk to Nomi, standing next to you. |use
		..accept Lesson 1: Sliced Peaches##31332 |or
		..accept Lesson 2: Instant Noodles##31333 |or
		..accept Lesson 3: Toasted Fish Jerky |or
		..accept Lesson 4: Dried Needle Mushrooms |or
		..accept Lesson 5: Pounded Rice Cake |or
	step
		goto Valley of the Four Winds 53.6,51.2
		.talk Sungshin Ironpaw##64231
		.buy 5 Pandaren Peach##31332 |q 31332/1
	step
		goto Valley of the Four Winds 53.6,51.2
		.talk Sungshin Ironpaw##64231
		.buy 5 Instant Noodles##74854 |q 31333/1
	step
		goto Valley of the Four Winds 53.6,51.2
		.talk Sungshin Ironpaw##64231
		.buy 5 Golden Carp##74866 |q 31334/1
	step
		goto Valley of the Four Winds 53.6,51.2
		.talk Sungshin Ironpaw##64231
		.buy 5 Needle Mushrooms##85583 |q 31335/1
	step
		goto Valley of the Four Winds 53.6,51.2
		.talk Sungshin Ironpaw##64231
		.buy 5 Rice##74851 |q 31336/1
	step
		.' Talk to Nomi, standing next to you.
		..turnin Lesson 1: Sliced Peaches##31332 |or
		..turnin Lesson 2: Instant Noodles##31333 |or
		..turnin Lesson 3: Toasted Fish Jerky |or
		..turnin Lesson 4: Dried Needle Mushrooms |or
		..turnin Lesson 5: Pounded Rice Cake |or
	step
		'You have reached the end of the dailies for today.
		.' Click here to go back to the beginning of the Nomi Cooking Dailies. |confirm |next "start"
]])

ZygorGuidesViewer:RegisterInclude("H_second_that_emotion",[[
	step
		'You can either purchase these from the Auction House or farm for them: 
		.collect 1 Bad Clams##43491
		.collect 1 Haunted Herring##43492
		.collect 1 Last Week's Mammoth##43488
		.collect 1 Tasty Cupcake##43490
		.' Click here to go farm for these |confirm |next "farm1"
		|next eat
	step
	label farm1
		'You can either purchase these from the Auction House or farm for them: 
		.collect 1 Succulent Clam Meat##36782
		.collect 1 Mote of Shadow##22577
		.collect 1 Chunk o' Mammoth##34736
		.collect 1 Northern Egg##43501
		.collect 1 Fangtooth Herring##41810
		.collect 1 Essence of Undeath##12808
		.' Click here to go farm for these |confirm |next "farm2"
		|next "make"
	step
	label farm2
	title +Succulent Clam Meat
		goto Borean Tundra,41.2,17.6
		.from Winterfin Warrior##25217+
		.collect Darkwater Clam##36781 |n
		'Open the Darkwater Clams in your bags |use Darkwater Clam##36781
		.collect 1 Succulent Clam Meat##36782
	step
	title +Chunk o' Mammoth
		goto Borean Tundra,78.2,24.0
		.from Scourged Mammoth##25452+
		.collect 1 Chunk o' Mammoth##34736
	step
	title +Northern Egg
		goto Borean Tundra,85.2,36.2
		.from Carrion Condor##26174
		.collect 1 Northern Egg##43501
	step
	title +Fangtooth Herring (Requires Fishing)
		fly Vengeance Landing
	step
		goto Howling Fjord,60.2,33.6
		'.' Fish at this spot
		.collect 1 Fangtooth Herring##41810
	step
	title +Essence of Undeath
		goto Western Plaguelands,69.1,73.0 |n
		.' Enter Scholomance here |goto Scholomance |noway |c
	step
		'Kill all undead mobs in the dungeon
		.collect 1 Essence of Undeath##12808
	step
	title +Second That Emotion
	label make
		goto Orgrimmar 52.0,73.8
		'Get someone to make your Bad Clams, Last Week's Mammoth, Haunted Herring, and Tasty Cupcake |tip Ask in your guild or in trade for someone to make these. Be sure to tip well! |only if skill("Cooking")<350
		'Make your Bad Clams, Last Week's Mammoth, Haunted Herring, and Tasty Cupcake |only if skill("Cooking")>=350
		'Build a Basic Campfire |cast Basic Campfire##818 |only if skill("Cooking")>=350
		.create Haunted Herring##58525,Cooking,1 total |only if skill("Cooking")>=350
		.create Bad Clams##58523,Cooking,1 total |only if skill("Cooking")>=350
		.create Last Week's Mammoth##58521,Cooking,1 total |only if skill("Cooking")>=350
		.create Tasty Cupcake##58512,Cooking,1 total |only if skill("Cooking")>=350
		.collect 1 Haunted Herring##43492
		.collect 1 Bad Clams##43491
		.collect 1 Last Week's Mammoth##43488
		.collect 1 Tasty Cupcake##43490
		.' Click here if you don't have these recipes |confirm |next "recipes" |only if skill("Cooking")>=350
		|next "eat"
	step
	label recipes
		goto Borean Tundra,54.6,70.0
		.from Crypt Crawler##25227
		.collect 1 Recipe: Bad Clams##43509
		.collect 1 Recipe: Last Week's Mammoth##43508
		.collect 1 Recipe: Haunted Herring##43510
		.collect 1 Recipe: Tasty Cupcake##43507
	step
		.learn Bad Clams##58523 |use Recipe: Bad Clams##43509
		.learn Haunted Herring##58525 |use Recipe: Haunted Herring##43510
		.learn Last Week's Mammoth##58521 |use Recipe: Last Week's Mammoth##43508
		.learn Tasty Cupcake##58512 |use Recipe: Tasty Cupcake##43507
	step
		'Build a Basic Campfire |cast Basic Campfire##818
		.create Haunted Herring##58525,Cooking,1 total 
		.create Bad Clams##58523,Cooking,1 total 
		.create Last Week's Mammoth##58521,Cooking,1 total 
		.create Tasty Cupcake##58512,Cooking,1 total 
		.collect 1 Haunted Herring##43492
		.collect 1 Bad Clams##43491
		.collect 1 Last Week's Mammoth##43488
		.collect 1 Tasty Cupcake##43490
	step
	label eat
		'Eat the Haunted Herring to become scared |use Haunted Herring##43492
		.' Eat Haunted Herring |achieve 1780/2
	step
		'Eat the Bad Clams to become angry |use Bad Clams##43491
		.' Eat Bad Clams |achieve 1780/1
	step
		'Eat the Last Week's Mammoth to become sad |use Last Week's Mammoth##43488
		.' Eat Last Week's Mammoth |achieve 1780/3
	step
		'Eat the Tasty Cupcake to become happy! |use Tasty Cupcake##43490
		.' Eat Tasty Cupcake |achieve 1780/4
		..' Eat each one of the "emotion" foods |achieve 1780
]])

ZygorGuidesViewer:RegisterInclude("H_the_cake_is_not_a_lie",[[
	step
		'Complete dailies in Shattrath City until you get the recipe for the Delicious Chocolate Cake:
		|confirm
	step
		'Routing to the proper section |next "create" |only if achieved(877)
		'Routing to the proper section |next |only if default
	step
		#include "H_Dalaran_Cooking_Dailies"
	step
		.' You have completed the maximum amount of Dalaran Cooking dailies you can do today.
		.collect Recipe: Delicious Chocolate Cake##33925 |n |tip You are not guaranteed to get this recipe - it is random, so try to have patience.
		.' Click the Recipe: Delicious Chocolate Cake |use Recipe: Delicious Chocolate Cake##33925
		.learn Delicious Chocolate Cake##43779
		.'_
		.' Click here to go back to the beginning of the dailies for today if you haven't received the cake pattern. |confirm |next "dailies"
	step
	label "create"
		goto Orgrimmar,54.9,78.2
		.talk Barkeep Morag##5611
		.buy 4 Ice Cold Milk##1179
	step
		goto 56.4,61.3
		.talk Suja##46708
		.buy 8 Simple Flour##30817
		.buy 4 Mild Spices##2678
	step
		fly Fizzle & Pozzik's Speedbarge
	step
		goto Thousand Needles 76.5,74.8
		.talk Daisy##40832
		.buy 1 Flask of Port##2593
	step
		#include "auctioneer"
		.buy 3 Mageroyal##785
		.buy 8 Small Egg##6889 |next "HaveEggs"
		.' Or...
		.' Click this line if you would rather farm the Small Eggs |confirm |next "farm"
	step
	label "farm"
		goto Azshara,49.8,15.6
		.from Thunderhead Hippogryph##6375+
		.collect 8 Small Egg##6889
	step
	label "HaveEggs"
		'Build a Basic Campfire |cast Basic Campfire##818
		.create Delicious Chocolate Cake##43779,Cooking,1 total |n
		.' Earn The Cake Is Not A Lie Achievement |achieve 877
]])
--------------------------------------------------------------------------------------------------------------------------------------
-- Professions Fishing
--------------------------------------------------------------------------------------------------------------------------------------

ZygorGuidesViewer:RegisterInclude("H_Old_Gnome_and_the_Sea",[[
	step
		 goto Ashenvale,78.0,51.7
		.' Look for Sagefish Schools in the water.  Walk along the rivers until you find one if you're unable to see one at this spot.
		.' It looks like a swarm of fish.
		.' Use you fishing skill until your lure is inside of the school of fish, then catch one. |cast Fishing##7620
		.' Earn The Old Gnome and the Sea Achievement. |achieve 153
	step
		'Congratulations! You've earned The Old Gnome and the Sea achievement!
]])
ZygorGuidesViewer:RegisterInclude("H_The_Scavenger",[[
	step
		goto Zangarmarsh 57.0,56.0
		.' Look for Steam Pump Flotsam in the water around this area and fish from it |cast Fishing##7620
		.' Fish from Steam Pump Flotsam |achieve 1257/1
	step
		goto Tanaris 67.4,38.2
		.' Look for Floating Wreckage around this area |tip You may have to fish from other pools to get this to show up |cast Fishing##7620
		.' Fish from Floating Wreckage |achieve 1257/5
	step
		goto Feralas,63.1,51.5 
		.' Look for Waterlogged Wreckage around this area |tip You may have to fish from other pools to get this to show up |cast Fishing##7620
		.' Fish from Waterlogged Wreckage |achieve 1257/4
	step
		goto Northern Stranglethorn 55.0,64.0
		.' Look for Schooner Wreckage around this area |tip You may need to fish from other pools to get this to show up |cast Fishing##7620
		.' Fish from Schooner Wreckage |achieve 1257/3
	step
		'Go to The Cape of Stranglethorn |goto The Cape of Stranglethorn |noway |c
	step
		goto 30.9,81.5
		.' Look for Bloodsail Wreckage around this area |tip You may need to fish from other pools to get this to show up |cast Fishing##7620
		.' Fish from Bloodsail Wreckage |achieve 1257/2
	step
		.' Successfully fish in each of the junk nodes |achieve 1257
	step
		'Congratulations! You've earned The Scavenger achievement!
]])
ZygorGuidesViewer:RegisterInclude("H_The_Fishing_Diplomat",[[
	step
		goto Orgrimmar,24.8,62.8
		.' Use your fishing skill in the pond |cast Fishing##7620
		.' Fish in Orgrimmar |achieve 150/1
	step
		goto Stormwind City 69.0,92.2
		.' Use your fishing skill in the moat in front of Stormwind City |cast Fishing##7620
		.' Fish in Stormwind City |achieve 150/2
	step
		.' Earn The Fishing Diplomat. |achieve 150
	step
		'Congratulations! You've earned The Fishing Diplomat achievement!
]])
ZygorGuidesViewer:RegisterInclude("H_Mr._Pinchy's_Magical_Crawdad_Box",[[
	step
		.' You can track fishing in horder to help you find Highland Mixed Schools.
		.learn Find Fish##43308  |next "HaveFishTracking"
		|confirm
		.' or
		.' Click here if you are already in Outland |confirm |next "outland"
	step
		goto Terokkar Forest,65.0,76.8
		.' Use your Find Fish ability to locate Highland Mixed Schools
		|confirm
	step
		goto Terokkar Forest,66.5,84.3
		.' Here [Terokkar Forest,66.5,84.3]
		.' Here [Terokkar Forest,65.9,73.1]
		.' Here [Terokkar Forest,60.6,59.9]
		.' Here [Terokkar Forest,45.0,40.5]
		.' Use your fishing skill to fish in the pond |cast Fishing##7620
		.collect 1 Magical Crawdad Box##27445 |n
		'|modeldisplay 3215
		.learnpet Magical Crawdad##18839 |use Magical Crawdad Box##27445
]])
ZygorGuidesViewer:RegisterInclude("H_The_Lurker_Above",[[
	step
		.' In order to earn the _Lurker Above_ achievement, you will need to be in a raid group.
		.' You will also need to be at least Level 70.
		.' It would be best if you picked up Elixirs of Water Walking 
		.' You won't need a certain level of fishing, but the high level you are, the higher change you have of fishing up 'The Lurker Below'.
		.' Click here after you have read the requirements for this achievement. |confirm
		.' or 
		.' Click here if you are in Outland already |confirm |next "outland"
	step
		goto Zangarmarsh,50.4,41.0 |n
		.' Swim down underwater through the tube to the Coilfang Reservoir |goto 51.9,38.0 |c
	step
		 goto Serpentshrine Cavern,13.5,59.6
		 .' Ride the elevator down
		.' Click here once you're at the bottom and off of the elevator |confirm
	step
		goto Serpentshrine Cavern,19.6,68.5
		.' Walk up the ramp and ride the elevator up.
		.' Click here once you ride the elevator up. |confirm
	step
		goto Serpentshrine Cavern,22.7,72.8 |n
		.' Use your water walking potion and jump into the water. |use Elixir of Water Walking##8827
		.' If you jump into the water without water walking, fish will attack you and you will have to kill them before using your Elixir.
		.' Walk over to the wooden circle with the Strange pool in the center |goto Serpentshrine Cavern,38.6,59.5 |c
	step
		.' Once you're there, use your fishing ability and make sure that your lure lands in the Strange Pool. |cast Fishing##7620
		.' Earn The Lurker Above Achievement. |achieve 144
	step
		'Congratulations! You've earned The Lurker Above achievement!
]])
ZygorGuidesViewer:RegisterInclude("H_Old_Man_Barlowned",[[
	step
		.' In order the earn this achievement, you will need to have completed these 5 daily quests:
		.' Crcolisks in the City |achieve 905/1
		.' Bait Bandits |achieve 905/2
		.' Felblood Fillet |achieve 905/3
		.' The One That Got Away |achieve 905/4
		.' Shrimpin' Ain't Easy |achieve 905/5
		.' Click here to proceed |confirm
	step
		goto Terokkar Forest,38.7,12.8
		.talk Old Man Barlo##25580
		.' You will only be able to pick up 1 of 5 dailies per day.
		.accept Crocolisks in the City##11665 |or
		.accept Bait Bandits##11666 |or
		.accept Felblood Fillet##11669 |or
		.accept The One That Got Away##11667 |or
		.accept Shrimpin' Ain't Easy##11668 |or
	step
		goto Orgrimmar 47.6,47.1
		.' Use your Fishing skill to fish in the water all around the wooden dock |cast Fishing##7620
		..get Baby Crocolisk##34864 |q 11665/1
		only if havequest(11665)
	step
		goto Terokkar Forest,51.8,37.2
		.' Fish in the river here |cast Fishing##7620
		..get Blackfin Darter##34865 |q 11666/1
		only if havequest(11666)
	step
		goto Nagrand,37.4,47.1
		.' Use your fishing ability to fish in the lake. |cast Fishing##7620
		..get World's Largest Mudfish##34868 |q 11667/1
		only if havequest(11667)
	step
		goto Zangarmarsh,77.9,79.7
		.' Fish from the Lake here |cast Fishing##7620
		.'Click the Bloated Barbed Gill Trout in your bags|use Bloated Barbed Gill Trout##35313
		..get Giant Freshwater Shrimp##34866 |q 11668/1
		only if havequest(11668)
	step
		goto Shadowmoon Valley,29.9,38.8
		.' Use your fishing ability in the green lava. |cast Fishing##7620
		..get Monstrous Felblood Snapper |q 11669/1
		only if havequest(11669)
	step
		goto Terokkar Forest,38.7,12.8
		.talk Old Man Barlo##25580
		.' You will only be able to pick up 1 of 5 dailies per day.
		.turnin Crocolisks in the City##11665 |or
		.turnin Bait Bandits##11666 |or
		.turnin Felblood Fillet##11669 |or
		.turnin The One That Got Away##11667 |or
		.turnin Shrimpin' Ain't Easy##11668 |or	
	step
		.' Crcolisks in the City |achieve 905/1
		.' Bait Bandits |achieve 905/2
		.' Felblood Fillet |achieve 905/3
		.' The One That Got Away |achieve 905/4
		.' Shrimpin' Ain't Easy |achieve 905/5
	step
		.' Earn the Old Man Barlowned Achievement. |achieve 905
	step
		'Congratulations! You've earned the Old Man Barlowned achievement!
]])
ZygorGuidesViewer:RegisterInclude("H_Outland_Angler",[[
	step
		.' In order to earn the Outland Angler achievement, you will need to fish from 6 different pools of fish in the Outlands.
		|confirm
	step
		goto Zangarmarsh,72.5,59.9
		.' Use your fishing skill on Sporefish School's around Umberfen Lake |cast Fishing##7620
		.' Fish from a Sporefish School |achieve 1225/6
	step
		goto Terokkar Forest,60.8,59.0 |n
		.' You will need to fly to reach the Highland Mixed Schools.  There are two more spots you can check for them below:
		.' The large Skettis Lake |goto 66.4,80.0 |n
		.' Lake Jorune |goto 45.9,39.5 |n
		.' Fish from a Highland Mixed School |achieve 1225/5
	step
		map Terokkar Forest
		path follow loose;loop off;ants straight // this stays until the end of the guide.
		path	 60.5,51.9	62.9,48.1	63.6,45.0
		path	 60.0,36.5
		.' Follow the stream until you find a School of Darters or Brackish Mixed School in the river.
		.' Use your fishing skill to fish from either Brackish Mixed or School of Darters
		.' Fish from a School of Darters |achieve 1225/4
		.' Fish from a Brackish Mixed School |achieve 1225/1
	step
		map Nagrand
		path follow loose;loop off;ants straight // this stays until the end of the guide.
		path	 47.2,44.4	48.7,45.3	51.1,43.2
		path	 50.9,47.6	48.8,48.1	47.4,48.6
		path	 46.5,47.6
		.' Follow the stream until you find a Bluefish and a Mudfish School.
		.' Use your fishing skill to fish from either Bluefish and a Mudfish School |cast Fishing##7620
		.' Fish from a Bluefish School |achieve 1225/2
		.' Fish from a Mudfish School |achieve 1225/3
	step
		.' Earn the Outland Angler Achievement. |achieve 1225
	step
		'Congratulations! You've earned the Outland Angler achievement!
]])
ZygorGuidesViewer:RegisterInclude("H_Fish_Don't_Leave_Footprints",[[
	step
		goto Northern Stranglethorn,31.0,37.7
		.' Use your fishing skill fish from Schooner Wreckage along The Savage Coast.  You may need to fish out the other schools of fish to get them to spawn. |cast Fishing##7620
		.collect Weather-Beaten Journal##34109
		.' Use the Weather-Beaten Journal. |use Weather-Beaten Jounral##34109
		.' Earn the Fish Don't Leave Footprints achievement. |achieve 1243
	step
		.' Congratulations, you have earned the Fish Don't Leave Footprints achievement!
]])
ZygorGuidesViewer:RegisterInclude("H_The_Coin_Master",[[
	step
		'This guide will help you earn the achievements A Penny For Your Thoughts, Silver in the City, There's Gold In That There Fountain, and finally, The Coin Master.
		.' Click here to proceed. |confirm
	step
		.' Here is your current progression on The Coin Master.
		.' A Penny For Your Thoughts. |achieve 2096/1
		.' Silver in the City. |achieve 2096/2
		.' There's a Gold In That There Fountain. |achieve 2096/3
		.' Click here to proceed. |confirm
	step
		goto Dalaran,52.6,66.5
		.' This fountain is where you will be fishing from to earn these achievements. Use your fishing skills to fish up Copper, Silver and Gold Coins. |cast Fishing##7620
		.' Earn the A Penny For Your Thoughts achievement. |achieve 2096/1
		.' Earn the Silver in the City achievement. |achieve 2096/2
		.' Earn the There's Gold In That There Fountain achievement. |achieve 2096/3
		.' This achievement takes a lot of time, so try to be patient.
	step
		.' Earn the A Penny For Your Thoughts Achiement. |achieve 2094
		.' Earn the Silver in the City achievement. |achieve 2095
		.' Earn the There's Gold In That There Fountain achievement. |achieve 1957
		.' Earn The Coin Master achievement. |achieve 2096
	step
		.' Congratulation, you have earned The Coin Master achievement!
]])
ZygorGuidesViewer:RegisterInclude("H_Master_Angler_of_Azeroth",[[
	step
		'To earn this Achievement, you need to go to Booty Bay, accept this quest and be the first to complete it.
		.' You can start this quest every _Sunday_ from _2pm to 4pm SERVER TIME_. 
		|confirm
	step
		goto Orgrimmar,66.6,41.6
		.talk Shankys##3333
		.buy 1 Fishing Pole##6256
		.buy 10 Shiny Bauble##6529
		.' Or
		|confirm
	step
		goto The Cape of Stranglethorn,41.7,73.0
		.talk Riggle Bassbait##15077
		..accept Master Angler##8193
	step
		goto The Cape of Stranglethorn,39.1,57.9
		.' Make sure you have you're fishing pole equipped and fish in these area's for Tasty Fish |use Fishing Pole##6256
		.' Attach your Shiny Bauble to your fishing pole to increase your fishing skill slightly |use Shiny Bauble##6529
		.get 40 Speckled Tastyfish##19807 |q 8193
		.' You can find more schools of fish here: [37.9,55.6]
		.' Here [36.3,53.8]
		.' Here [36.1,50.9]
		.' And here [36.2,47.7]
	step
		goto The Cape of Stranglethorn,41.7,73.0
		.talk Riggle Bassbait##15077
		..turnin Master Angler##8193
		.' Be the first to turn in this quest to earn achievement
		.' Earn Master Angler Achievement |achieve 306
]])
ZygorGuidesViewer:RegisterInclude("H_Master_Angler_of_Northrend",[[
	step
		'To earn this Achievement, you need to go to Northrend, catch a _Blacktip Shark_ and be the first to turn it in.
		.' You can start fishing every _Saturday_ at _2pm SERVER TIME_, you will hear the NPC yell out that the 
		.' contest has started, make sure you are next to a school of fish, and start fishing!
		|confirm
	step
		goto Orgrimmar,66.6,41.6
		.talk Shankys##3333
		.buy 1 Fishing Pole##6256
		.buy 10 Shiny Bauble##6529
		.' Or
		|confirm
	step
		goto Dalaran,65.7,32.2
		.talk Uda the Beast##31557
		.home Dalaran
	step
		goto Dalaran,52.4,65.2
		.talk Elder Clearwater##38294
		.turnin Kalu'ak Fishing Derby##24803
	step
		goto Dalaran,56.0,46.8
		.click Teleport to Violet Stand Crystal##8070
		.' Teleport to the Violet Stand |goto Crystalsong Forest |noway |c
	step
		map Crystalsong Forest
		path follow loose;loop off;ants straight
		path	22.5,35.4
		path	25.2,43.4	29.6,45.2	34.0,47.9
		path	38.7,54.4	44.8,56.7	50.3,56.4
		.' Follow this path and turn your _Track Fishing_ on.
		.' Fish up a _Blacktip Shark_ from any school of fish.|use Fishing Pole##6256
		.' Attach your Shiny Bauble to your fishing pole to increase your fishing skill slightly |use Shiny Bauble##6529
		.collect Blacktip Shark##50289
	step
		goto Dalaran,52.4,65.2
		.talk Elder Clearwater##38294
		.turnin Kalu'ak Fishing Derby##24803
		.' If you are the first to turn in this quest you will get an achievement
		.' Earn the Achievement Master Angler of Azeroth |achieve 306
]])

ZygorGuidesViewer:RegisterInclude("H_TB_Fishing_Dailies",[[
		goto Thunder Bluff,56.0,47.0
		.talk Kah Mistrunner##3028 |or
		.accept Craving Crayfish##29349 |or  
		.accept Pond Predators##29345 |or
		.accept Shiny Baubles##29354 |or 
		.accept The Race to Restock##29348 |or
		.accept The Ring's the Thing##29346 |or
	step
		goto 44.9,54.8
		.' Dive into the water and click on the Stonebull Crafish |tip They look like little blue crabs
		.get Stonebull Crayfish##69977 |q 29349/1
		only if havequest(29349)
	step
		goto Thunder Bluff,41.7,59.4
		.' Use your Fishing skill here to catch Azshara Snakeheads |cast Fishing##7620
		.get 8 Azshara Snakehead##69934 |q 29345/1
		only if havequest(29345)
	step
		goto Thunder Bluff,35.6,40.9
		.' Click on the Shiny Stones lying on the ground around Thunder Bluff's base |tip They look like shinning purple stones
		.get 20 Shiny Stone##69983 |q 29354/1
		only if havequest(29354)
	step
		goto Mulgore 49.6,49.5
		.' Use your Fishing skill here to catch Randy Smallfish and Amorous Mud Snapper |cast Fishing##7620
		.get 2 Randy Smallfish##69964 |q 29348/1
		.get 2 Amorous Mud Snapper##69967 |q 29348/2
		only if havequest(29348)
	step
		goto Thunder Bluff,28.8,20.4
		.' Use your Fishing skill in the glowing water here |cast Fishing##7620
		.get 1 Poshken's Ring##69935 |q 29346/1
		only if havequest(29346)
	step
		goto Thunder Bluff,56.0,47.0
		.talk Kah Mistrunner##3028
		.turnin Craving Crayfish##29349  
		.turnin Pond Predators##29345
		.turnin The Race to Restock##29348 
		only if havequest(29349) or havequest(29345) or havequest(29348)
	step
		goto Thunder Bluff,35,53.8
		.talk Nahari Cloudchaser##29354
		.turnin Shiny Baubles##29354
		only if havequest(29354)
	step
		goto Thunder Bluff,28.8,20.4
		.talk Poshken Hardbinder##30709
		.turnin The Ring's the Thing##29346 
		only if havequest(29346)
]])
ZygorGuidesViewer:RegisterInclude("H_Org_Fishing_Dailies",[[
		goto Orgrimmar,65.7,41.1
		.talk Razgar##43239
		..' You will only be able to complete 1 of the following quests per day
		..accept A Furious Catch##26588 |or
		..accept A Golden Opportunity##26572 |or
		..accept A Staggering Effort##26557 |or
		..accept Clammy Hands##26543 |or
		..accept No Dumping Allowed##26556 |or
	step
		goto Durotar,37.4,16.8
		.' Fish in the river in this spot
		.get Giant Furious Pike |q 26588/1 |tip This fish can only be caught in Durotar, so make sure you are standing and fishing in Durotar.
	step
		goto 42.8,24.0
		.' Use Razgar's Fillet Knife on a Drowned Thunder Lizard |use Razgar's Fillet Knife##58955 |tip They look like dead dinosaurs underwater around this area.
		.collect Drowned Thunder Lizard Tail##58958 |n
		.' Use your Drowned Thunder Lizard Tail next to Golden Stonefish |use Drowned Thunder Lizard Tail##58958 |tip They look like big yellow fish underwater around this area.
		.get 3 Golden Stonefish |q 26572/1
	step
		goto 57.2,9.5
		.' Click Monstrous Clams |tip They look like huge white clams underwater around this area.
		.get 10 Monstrous Clam Meat |q 26543/1	
	step
		goto Azshara,27.6,74.5
		.from Weakened Mosshoof Stag##35096+
		.collect 1 Stag Eye##58949 |q 26557
	step
		 goto Orgrimmar,46.2,46.5
		.' Use your Stag Eye |use Stag Eye##58949
		.' Fish in the water off the dock in this spot
		.get Sandy Carp |q 26557/1
	step
		goto 38.5,80.1
		.' Fish in the water in this spot
		.get 6 Toxic Puddlefish |q 26556/1
	step
		goto 65.7,41.1
		.talk Razgar##43239
		..' You will only be able to complete 1 of the following quests per day
		..turnin A Furious Catch##26588
		..turnin A Golden Opportunity##26572
		..turnin A Staggering Effort##26557
		..turnin Clammy Hands##26543
		..turnin No Dumping Allowed##26556
]])
ZygorGuidesViewer:RegisterInclude("H_UC_Fishing_Dailies",[[
		goto Undercity,81.6,30.8
		.talk Armand Cromwell##4573
		.' You will only be able to accept one of the five quests listed.
		.accept Fish Head##29317 |or
		.accept Like Pike?##29320 |or
		.accept Moat Monster!##29361 |or
		.accept Tadpole Terror##29319 |or
		.accept Time for Slime##29322 |or
	step
		goto 81.6,31.5
		.' Use your Fishing skill at the edge of the wooden dock to fish up a Severed Abomination Head |cast Fishing##7620
		.get Severed Abomination Head##69901 |q 29317/1
		only if havequest(29317)
	step
		goto Undercity,67.3,15.2
		.' Click on the graves here to collect a Corpse Worm |tip It looks like sparkling dirt in front of a grave stone
		only if havequest(29320)
	step
		goto Tirisfal Glades,67.1,50.8
		.' Use your Fishing skill in the water here to fish up Corpse-Fed Pike |cast Fishing##7620
		.get Corpse-Fed Pike##69909 |q 293320/1
		only if havequest(29320)
	step
		goto Undercity,64.7,16.5 
		.' Open your Moat Monster Feeding Kit |use Moat Monster Feeding Kit##69999
		.' Lure the Moat Monster out with the Alliance Decoy |use Alliance Decoy Ki##69998
		.' Feed the Moat Monster with your Bloated Frogs! |use Bloated Frog##69995
		.' Feed Bloated Frogs to the Moat Monster |q 29361/1
		|only if havequest(29361)
	step
		goto Tirisfal Glades,50.6,56.5
		.' Use your Fishing skill to fish up Giant Flesh-Eating Tadpoles |cast Fishing##7620
		.get 8 Giant Flesh-Eating Tadpole##69905 |q 29319/1
		only if havequest(29319)
	step
		goto Undercity,81.1,32.0
		.' Click on the Squirming Slime Mold in the green, slimy water all over Undercity |tip These are a bit hard to see, so, to see them better, you can dive into the water, or turn on your display health bars by pushing [V]
		.get 10 Squirming Slime Mold##69911 |q 29322/1
		only if havequest(29322)
	step
		goto Undercity,81.6,30.8
		.talk Armand Cromwell##4573
		.turnin Like Pike?##29320 |or 
		.turnin Moat Monster!##29361 |or 
		.turnin Tadpole Terror##29319 |or 
		.turnin Time for Slime##29322 |or  
		|only if havequest(29320) or havequest(29361) or havequest(29319) or havequest(29322)
	step
		goto Undercity,48.4,69.4 
		.talk Master Apothecary Faranell##2055 |or 
		.turnin Fish Head##29317 
		|only if havequest(29317)
]])

---------------------------------------------------------------------------------------
--Dailies
---------------------------------------------------------------------------------------
-- Outland

ZygorGuidesViewer:RegisterInclude("H_SSO_PreQuest_with_Dailies", [[
	step
	label "start"
		goto Shattrath City,49.1,42.5
		.talk Exarch Nasuun##24932
		..accept Maintaining the Sunwell Portal##11514
	step
		goto 62.8,36.0
		.talk Lord Torvos##25140
		..accept Sunfury Attack Plans##11877
	step
		goto 62.8,35.6
		.talk Emissary Mordin##19202
		..accept Gaining the Advantage##11875
		only if skill("Skinning")>300 or skill("Mining")>300 or skill("Herbalism")>300
	step
		goto Shattrath City,61.7,52.1
		.talk Harbinger Haronem##19475
		..accept The Multiphase Survey##11880
	step
		goto Nagrand,50.3,40.4
		.from Clefthoof Bull##17132+,Talbuk Thorngrazer##17131+,Wild Elekk##18334+
		.' Skin their corpses in order to collect the Nether Residue.
		.get 8 Nether Residue##35229 |q 11875/1
		only if skill("Skinning")>=300
	step
		goto 40.8,31.6
		.' Mine inside the cave and collect Nether Residue.
		.collect 8 Nether Residue##35229 |q 11875/1
		.' You can check [Nagrand,50.0,56.6] for more Mining Nodes.
		only if skill("Mining")>=300
	step
		goto Nagrand,38.3,65.3
		.' Fly around the Spirit Fields looking for Fiery Red Orbs on the ground.
		.' Use your Multiphase Spectrographic Goggles on the Orbs. |use Multiphase Spectrographic Goggles##35233
		..goal 6 Multiphase Readings Taken |q 11880/1
	step
		goto Blade's Edge Mountains,54.0,18.1
		.from Unbound Ethereal##22244+,Bash'ir Raider##22241+,Bash'ir Arcanist##22243+,Bash'ir Spell-Thief##22242+
		.collect 1 Bash'ir Phasing Device |n
		'Use the Bash'ir Phasing Device. |use Bash'ir Phasing Device##34248
		.' Become Out of Phase |havebuff Interface\Icons\Ability_Mage_Invisibility
		.click Smuggled Mana Cell##7257 
		.' Collect 10 Smuggled Mana Cell |q 11514/1
	step
		goto Netherstorm,25.9,66.8
		.from Sunfury Bloodwarder##18853+,Sunfury Captain##19453+,Sunfury Magister##18855+,Sunfury Geologist##19779+,Sunfury Astromancer##19643
		.get Sunfury Attack Plans |q 11877/1
	step
		goto Shattrath City,62.8,36.0
		.talk Lord Torvos##25140
		.turnin Sunfury Attack Plans##11877
	step
		goto 62.8,35.6
		.talk Emissary Mordin##19202 
		.turnin Gaining the Advantage##11875
	step
		goto 61.6,52.2
		.talk Harbinger Haronem##19475
		.turnin The Multiphas Survey##11880
	step
		goto 49.1,42.5
		.talk Exarch Nasuun##24932
		.turnin Maintaining the Sunwell Portal##11514
	step
		goto Shattrath City,48.6,42.0 |n
		.' Click the Shattrath Portal to Isle of Quel'Danas. |goto Isle of Quel'Danas
	step
		goto Isle of Quel'Danas,47.5,35.4
		.talk Astromancer Darnarian##25133
		..accept Know Your Ley Lines##11547
	step
		goto 47.5,35.1
		.talk Battlemage Arynna##25057
		..accept The Air Strikes Must Continue##11533
	step
		goto 47.6,35.1
		.talk Harbinger Inuuro##25061
		..accept The Battle Must Go On##11537
	step
		goto 48.8,37.2
		.talk Anchorite Ayuri##25112
		..accept Your Continued Support##11548
		.' This quest requires that you give 10 Gold in trade of reputation with the Shattered Sun Offensive, you should be able to turn it in immidiately.
		..turnin Your Continued Support##11548
	step
		goto 50.6,39.0
		.talk Vindicator Kaalan##25108
		..accept Keeping the Enemy at Bay##11543
	step
		goto 49.3,40.4
		.talk Magister Ilastar##25069
		..accept Crush the Dawnblade##11540
	step
		goto 50.6,40.8
		.talk Smith Hauthaa##25046
		..accept Don't Stop Now....##11536
		..accept Ata'mal Armaments##11544
	step
		goto 51.5,32.5
		.talk Mar'nah##24975
		..accept Rediscovering Your Roots##11521
		..accept Open for Business##11546
	step
		goto 53.8,34.3
		.talk Captain Valindria##25088
		..accept Disrupt the Greengill Coast##11541
	step
		goto 47.5,30.5
		.talk Captain Theris Dawnhearth##24967
		..accept Arm the Wards!##11523
		..accept The Missing Magistrix##11526
	step
		goto 47.1,30.7
		.talk Vindicator Xayann##24965
		..accept Further Conversions##11525
	step
		goto Isle of Quel'Danas,44.3,28.5
		.from Wretched Fiend##24966+
		.collect 4 Mana Remnants##34338 |q 11523 |c
		.kill Erratic Sentry##24972+ |n
		.' Use Attuned Crystal Cores on the Erratic Sentries corpse. |use Attuned Crystal Cores##34368
		..goal 5 Converted Sentry Deployed |q 11525/1
		.click Bloodberry Bush##28
		..collect 5 Bloodberry |q 11546/1 |tip They can be found all around this area on the ground.
	step
		goto Isle of Quel'Danas,42.1,35.7
		.kill 6 Dawnblade Summoner |q 11540/1
		.kill 6 Dawnblade Blood Knight |q 11540/2
		.kill 3 Dawnblade Marksman |q 11540/3
		.' Use your Astromancer's Crystal to sample the Bloodcrystal's density. |use Astromancer's Crystal##34533
		.' Bloodcrystal Reading Taken |q 11547/3
	step
		goto Isle of Quel'Danas,46.5,35.5
		.' Use the Mana Remnants to Energize the Crystal Ward. |use Mana Remnants##34338
		.' Energize a Crystal Ward |q 11523/1
	step
		goto 48.5,25.2
		.talk Ayren Cloudbreaker##25059
		.' Tell him you Need to Intercept the Dawnblade Reinforcements.
		.' Use your Flaming Oil to set fire to the ships sails as you fly around. |use Flaming Oil##34489
		.' Sin'loren sails burned |q 11543/1
		.' Bloodoath sails burned |q 11543/2
		.' Dawnchaser sails burned |q 11543/3
	step
		.kill 6 Dawnblade Reservist##25087+ |q 11543/4
		.' You can find more at [Isle of Quel'Danas,51.1,9.7]
		.' Another spot for them is at [Isle of Quel'Danas,55.2,11.8]
	step
		goto Isle of Quel'Danas,52.4,17.4
		.talk Unrestrained Dragonhawk##25236
		.' Ride the dragonhawk to Sun's Reach. |goto Isle of Quel'Danas,48.4,25.3 |noway|c
	step
		goto Isle of Quel'Danas,48.5,25.2
		.talk Ayren Cloudbreaker##25059
		.' Tell him you've been ordered to undertake an airstrike.
		.' Use your Arcane Charges on mobs once you get to the Dead Scar. |use Arcane Charges##34475
		.kill 2 Pit Overlord##25031+ |q 11533/1
		.kill 3 Eredar Sorcerer##25033+ |q 11533/2
		.kill 12 Wrath Enforcer##25030+ |q 11533/3
	step
		goto Isle of Quel'Danas,48.5,43.7
		.kill Emissary of Hate##25003 |n
		.' Use your Shattered Sun Banner on his corpse. |use Shattered Sun Banner##34414
		.' Impale the Emissary of Hate |q 11537/1
		.kill 6 Burning Legion Demon |q 11537/2
		.' Use your Astromancer's Crystal to sample the Portal's density. |use Astromancer's Crystal##34533
		.' Portal Reading Taken |q 11547/1
	step
		.' Take this path back to they shoreside. |goto Isle of Quel'Danas,57.3,38.6 |c
	step
		goto Isle of Quel'Danas,64.1,49.9
		.from Darkspine Myrmidon##25060+
		..collect Darkspine Chest Key##34477 |n
		.from Darkspine Siren##25073+
		..collect Orb of Murloc Control##34483 |n
		.' Use your Orbs of Murloc Control on Greengill Slaves along the shore. |use Orb of Murloc Control##34483
		.' Free 10 Greengill Slaves |q 11541/1
		.' Use your Darkspine Chest Keys on the Darkspine Ore Chest.
		.get 3 Darkspine Iron Ore |q 11536/1
	step
		goto Isle of Quel'Danas,61.1,62.0
		.' Use your Astromancer's Crystal to sample the Shrine's density. |use Astromancer's Crystal##34533
		.' Shrine Reading Taken |q 11547/2
	step
		goto Isle of Quel'Danas,53.8,34.3
		.talk Captain Valindria##25088
		..turnin Disrupt the Greengill Coast##11541
	step
		goto 50.6,40.7
		.talk Smith Hauthaa##25046
		..turnin Don't Stop Now....##11536
	step
		goto 50.6,39.0
		.talk Vindicator Kaalan##25108
		..turnin Keeping the Enemy at Bay##11543
	step
		goto 49.3,40.4
		.talk Magister Ilastar##25069
		..turnin Crush the Dawnblade##11540
	step
		goto 51.5,32.5
		.talk Mar'nah##24975
		..turnin Open for Business##11546
	step
		goto 47.5,35.3
		.talk Astromancer Darnarian##25133
		.turnin Know Your Ley Lines##11547
	step
		goto 47.5,35.1
		.talk Battlemage Arynna##25057
		.turnin The Air Strikes Must Continue##11533
	step
		goto 47.6,35.1
		.talk Harbinger Inuuro##25061
		.turnin The Battle Must Go On##11537
	step
		goto 47.5,30.5
		.talk Captain Theris Dawnhearth##24967
		.turnin Arm the Wards!##11523
	step
		goto 47.1,30.7
		.talk Vindicator Xayann##24965
		.turnin Further Conversions##11525
	step
		goto Isle of Quel'Danas,48.5,44.7
		|use Captured Legion Scroll##34420
		.' Teleport to Hellfire Peninsula |goto Hellfire Peninsula,58.6,18.7,0.5 |noway|c
	step
		goto Hellfire Peninsula,58.2,17.6
		.talk Magistrix Seyla##24937
		.turnin The Missing Magistrix##11526
		..accept Blood for Blood##11515
		..accept Blast the Gateway##11516
	step
		goto Hellfire Peninsula,66.4,20.1
		.from Wrath Herald##24919+
		.collect 4 Demonic Blood##34259 
		.' use the Sizzling Embers to summon a Living Flare. |use Sizzling Embers##34253
		.kill Incandescent Fel Spark##22323+ |n
		.' Once you see a message that says "Living Flare becomes unstable with brimming energy!" take it to [Hellfire Peninsula,58.6,18.7].
		.' Legion Gateway Destroyed |q 11516/1
	step
		goto 59.9,21.0
		.' Use your Fel Siphon on Felblood Initiates. |use Fel Siphon##34257
		.kill 4 Emaciated Felblood##24918 |q 11515/1
	step
		goto Hellfire Peninsula,58.2,17.6
		.talk Magistrix Seyla##24937
		.turnin Blast the Gateway##11516
		.turnin Blood for Blood##11515
	step
		goto Terokkar Forest,59.7,10.3
		.from Razorthorn Flayer##24920+
		..collect Razorthorn Flayer Gland##34255 |q 11521 |n
		.' Use your Razorthorn Flayer Gland on Razorthorn Ravagers. |use Razorthorn Flayer Gland##34255
		.' Use your pets Expose Razorthorn Root ability on mounds of dirt around the area. |cast Expose Razorthorn Root##44935
		.collect 5 Razorthorn Root##34254 |q 11521/1
	step
		 goto Shadowmoon Valley,68.5,37.5
		.from Shadowmoon Chosen##22084+,Shadowmoon Slayer##22082+,Shadowmoon Darkweaver##22081+
		.collect 5 Ata'mal Armament##34500 |q 11544
	step
		goto Shattrath City,48.6,42.0 |n
		.' Click the Shattrath Portal to Isle of Qual'Danas. |goto Isle of Quel'Danas |noway|c
	step
		goto Isle of Quel'Danas,51.5,32.5
		.talk Mar'nah##24975
		.turnin Rediscovering Your Roots##11521
	step
		goto 50.6,40.7
		.' Click the Ata'mal Armaments and cleanse them at Hauthaa's Anvil. |use Ata'mal Armament##34500
		.' Cleanse 5 Ata'mal Metals |q 11544/1
	step
		goto 50.6,40.7
		.talk Smith Hauthaa##25046
		..turnin Ata'mal Armaments##11544
	step
		goto Isle of Quel'Danas,47.3,30.7
		.talk Eldara Dawnrunner##25032
		..accept A Friend in the Frontlines##11554 |instant
		only if rep ("Shattered Sun Offensive")==Friendly
	step
		goto Isle of Quel'Danas,47.3,30.7
		.talk Eldara Dawnrunner##25032
		..accept Honored By Your Allies##11555 |instant
		only if rep ("Shattered Sun Offensive")==Honored
	step
		goto Isle of Quel'Danas,47.3,30.7
		.talk Eldara Dawnrunner##25032
		..accept Revered in the Field of Battle##11556 |instant
		only if rep ("Shattered Sun Offensive")==Revered
	step
		goto Isle of Quel'Danas,47.3,30.7
		.talk Eldara Dawnrunner##25032
		..accept Exalted Among All Combatants##11557 |instant
		only if rep ("Shattered Sun Offensive")==Exalted
	step
		goto Isle of Quel'Danas,51.2,33.1
		.talk Anchorite Kairthos##25163
		..accept A Magnanimous Benefactor##11549 |tip This quest will cost you 1,000 Gold, but give you the title "Of the Shattered Sun".
		only if rep ("Shattered Sun Offensive")==Exalted
	step
		goto Isle of Quel'Danas,51.2,33.1
		.talk Anchorite Kairthos##25163
		.' _WARNING_, by turning in this quest, you will spend _1000 gold!_
		..turnin A Magnanimous Benefactor##11549
		only if rep ("Shattered Sun Offensive")==Exalted
	step
		'Congratulations, you have earned the title _of the Shattered Sun_!
		only if rep ("Shattered Sun Offensive")==Exalted
	step
		'You have reached the end of the dailies for today.
		.' Click here to go back to the beginning of the dailies. |confirm |next "start"
]])
ZygorGuidesViewer:RegisterInclude("H_Therazane_PreQuest", [[
		goto Orgrimmar,49.7,76.5
		.' Click the Warchief's Command Board |tip It looks like a wooden board hanging between 2 wooden posts, with papers pinned on it.
		..accept Warchief's Command: Deepholm!##27722
	step
		goto 50.5,38.4
		.talk Farseer Krogar##45244
		..turnin The War Has Many Fronts##27442
		..turnin Warchief's Command: Deepholm!##27722
		..accept The Maelstrom##27203
	step
		goto The Maelstrom,33.4,50.2
		.talk Thrall##45042
		..turnin The Maelstrom##27203
		..accept Deepholm, Realm of Earth##27123
	step
		goto 32.5,52.0
		.' Click the Wyvern |tip It looks like a wind rider flying in place.
		.' You will fly into Deepholm |goto Deepholm,49.9,54.7,0.5 |noway |c
	step
		goto Deepholm,49.6,53.0
		.talk Maruut Stonebinder##43065
		..turnin Deepholm, Realm of Earth##27123
		..accept Gunship Down##26245
	step
		goto 49.7,52.9
		.talk Seer Kormo##43397
		..accept Elemental Energy##27136
		..accept The Earth Claims All##26244
	step
		goto 49.5,53.3
		.talk Earthcaller Yevaa##42573
		..accept Where's Goldmine?##26409
	step
		goto 49.2,51.9
		.talk Caretaker Nuunwa##45300
		.home Temple of Earth
	step
		goto 46.5,57.3
		.talk Initiate Goldmine##42574
		..turnin Where's Goldmine?##26409
		..accept Explosive Bonding Compound##26410
		..accept Something that Burns##27135
	step
		goto 45.5,57.9
		.from Rockslice Flayer##42606+
		.get 5 Quartzite Resin |q 26410/1
	step
		goto 46.5,57.3
		.talk Initiate Goldmine##42574
		..turnin Explosive Bonding Compound##26410
	step
		goto 51.1,61.6
		.' Use your Depleted Totem |use Depleted Totem##60835
		.from Lodestone Elemental##43258+, Energized Geode##43254+ |tip Kill them next to your Depleted Totems.
		.' Energize the Totem 8 Times |q 27136/1
	step
		goto 52.0,58.9
		.' Use Goldmine's Fire Totem in the red lava spot |use Goldmines's Fire Totem##60834
		.from Magmatooth##45099
		.get The Burning Heart |q 27135/1
	step
		goto 49.7,52.9
		.talk Seer Kormo##43397
		..turnin Elemental Energy##27136
	step
		goto 46.5,57.3
		.talk Initiate Goldmine##42574
		..turnin Something that Burns##27135
		..accept Apply and Flash Dry##26411
	step
		goto 46.6,57.2
		.' Use your Explosive Bonding Compound on Flint Oremantle |use Explosive Bonding Compound##58502 |tip He's laying on the ground next to Initiate Goldmine.
		.' Apply the Explosive Bonding Compound |q 26411/1
	step
		goto 46.5,57.3
		.talk Initiate Goldmine##42574
		..turnin Apply and Flash Dry##26411
		..accept Take Him to the Earthcaller##26413
	step
		goto 49.5,53.3
		.' Introduce Flint Oremantle to Earthcaller Yevaa |q 26413/1
	step
		goto 49.5,53.3
		.talk Earthcaller Yevaa##42573
		..turnin Take Him to the Earthcaller##26413
		..accept To Stonehearth's Aid##26484
	step
		goto 56.1,74.2
		.' Click the Slain Cannoneer |tip It looks like a dead orc on the deck of the crashed zeppelin, laying next to a pile of cannon balls and a cannon.
		.' Receive the Second Clue |q 26245/2
	step
		goto 53.5,73.8
		.' Click Captain Skullshatter |tip He's a dead orc laying on the ground next to a small round table in a side room on the deck of the crashed zeppelin.
		.' Receive the First Clue |q 26245/1
	step
		goto 53.6,73.8
		.' Click the Captain's Log |tip It's a gray book laying on the small round table next to Captain Skullshatter.
		..accept Captain's Log##26246
	step
		goto 56.7,76.4
		.' Click the Unexploded Artillery Shell |tip It looks like a metal casing, or bullet type of object laying on the ground underneath the crashed zeppelin.  You can get to it by flying in the 3 open side doors on the north side of the crashed zeppelin.
		.' Receive the Third Clue |q 26245/3
	step
		goto 55.9,74.9
		.kill 5 Deepstone Elemental |q 26244/1
	step
		goto 49.6,52.9
		.talk Maruut Stonebinder##43065
		..turnin Gunship Down##26245
		..turnin Captain's Log##26246
	step
		goto 49.7,52.9
		.talk Seer Kormo##43397
		..turnin The Earth Claims All##26244
	step
		goto 49.6,53.0
		.talk Maruut Stonebinder##43065
		..accept Diplomacy First##26247
	step
		goto 62.4,52.6
		.talk Stormcaller Mylra##42684
		..turnin Diplomacy First##26247
		..accept All Our Friends Are Dead##26248
		..accept The Admiral's Cabin##26249
	step
		'All around on this airship:
		.' Use your Spirit Totem on Slain Crew Members |use Spirit Totem##58167 |tip They look like dead Alliance soldiers all over this airship.
		.' Receive 6 Slain Crew Member Information |q 26248/1
	step
		'Enter the doorway on the main deck of the airship:
		.talk First Mate Moody##43082
		..turnin The Admiral's Cabin##26249
		..accept Without a Captain or Crew##26427
	step
		'Leave through the doorway and immediately turn right:
		.' Click the Bottle of Whiskey |tip It's a yellow bottle sitting on the edge of a small life boat on the side of the airship.
		.get Bottle of Whiskey |q 26427/1
	step
		'All around on the deck of the airship:
		.' Click a Spool of Rope |tip They are coiled up ropes laying all around on the deck of the airship.
		.get Spool of Rope |q 26427/2
	step
		'Enter the doorway on the main deck of the airship:
		.talk First Mate Moody##43082
		..turnin Without a Captain or Crew##26427
	step
		'Go to the very top of the airship:
		.talk Stormcaller Mylra##42684
		..turnin All Our Friends Are Dead##26248
		..accept Take No Prisoners##26251
		..accept On Second Thought, Take One Prisoner##26250
	step
		'Go onto the main deck of the ship and go down the stairs to the deck below:
		.' Fight Mor'norokk the Hateful until he surrenders |tip He's downstairs in the airship, in the very back of the first level you come to.
		.talk Mor'norokk the Hateful##42801
		.' Subdue Mor'norokk the Hateful |q 26250/1
	step
		'All around on this lower deck of the airship:
		.kill 6 Twilight Saboteur |q 26251/1
	step
		'Go to the very top of the airship:
		.talk Stormcaller Mylra##42684
		..turnin Take No Prisoners##26251
		..turnin On Second Thought, Take One Prisoner##26250
		..accept Some Spraining to Do##26254
	step
		Next to Stormcaller Mylra:
		.' Click Stormbeak |tip It's a gryphon flying in place next to the airship.
		.' Interrogate Mok'norrok |q 26254/1
	step
		'When you land on the airship again:
		.talk Stormcaller Mylra##42684
		..turnin Some Spraining to Do##26254
		..accept Return to the Temple of Earth##26255
	step
		goto 49.6,53.0
		.talk Maruut Stonebinder##43065
		..turnin Return to the Temple of Earth##26255
		..accept Deathwing's Fall##26258
	step
		goto 49.7,52.9
		.talk Seer Kormo##43397
		..accept Blood of the Earthwarder##26259
	step
		goto 59.4,58.2
		.' Go to this spot
		.' Reach Deathwing's Fall |q 26258/1
		.' Click the Quest Complete box that displays on the right side of the screen under your minimap
		..turnin Deathwing's Fall##26258
		..accept Bleed the Bloodshaper##26256
	step
		goto 61.5,60.6
		.from Twilight Bloodshaper##43218+
		.get Twilight Orders |q 26256/1
		.' Click the Quest Complete box that displays on the right side of the screen under your minimap
		..turnin Bleed the Bloodshaper##26256
		..accept Question the Slaves##26261
	step
		goto 62.8,59.5
		.' Click the Slavemaster's Coffer |tip It looks like a small wooden chest on the ground inside a red tent.
		.collect Twilight Slaver's Key##60739 |q 26261
	step
		goto 61.2,60.1
		.from Living Blood##43123+
		.get 5 Blood of Neltharion |q 26259/1
	step
		goto 64.5,65.5
		.' Click Ball and Chains |tip They are attached to the feet of the Enslaved Miners around this area.
		.' Free 6 Enslaved Miners |q 26261/1
		.' Click the Quest Complete box that displays on the right side of the screen under your minimap
		..turnin Question the Slaves##26261
		..accept The Forgemaster's Log##26260
	step
		goto 63.7,55.4
		.' Click the Forgemaster's Log |tip It's a blue-ish book laying on the floor at the very top of this tower.
		..turnin The Forgemaster's Log##26260
		..accept Silvermarsh Rendezvous##27007
	step
		goto 70.6,61.2
		.' Go to this spot
		.' Reach Upper Silvermarsh |q 27007/1
		.' Click the Quest Complete box that displays on the right side of the screen under your minimap
		..turnin Silvermarsh Rendezvous##27007
		..accept Quicksilver Submersion##27010
	step
		goto 71.8,64.3
		.' Click the Trogg Crate |tip It's a brown box sitting next to the water.
		.collect Trogg Crate##60809 |q 27010
		.from Murkstone Trogg##44936
		.collect Maziel's Research##60816 |n
		.' Click Maziel's Research in your bags |use Maziel's Research##60816
		..accept Twilight Research##27100
	step
		goto 74.9,64.8
		.' Use your Trogg Crate in the water and swim to this spot |use Trogg Crate##60809
		.' Watch the dialogue
		.' Uncover the World Pillar Fragment Clue |q 27010/1
		.' Click the Quest Complete box that displays on the right side of the screen under your minimap
		..turnin Quicksilver Submersion##27010
		..accept The Twilight Overlook##27061
	step
		goto 72.5,65.2
		.from Mercurial Ooze##43158+
		.get 4 Twilight Research Notes |q 27100/1
		.' Click the Quest Complete box that displays on the right side of the screen under your minimap
		..turnin Twilight Research##27100
		..accept Maziel's Revelation##27101
	step
		goto 67.2,70.2
		.' Click Maziel's Journal |tip It looks like a small black book laying on the ground on this tiny island in a pond, next to a big rock.
		..turnin Maziel's Revelation##27101
		..accept Maziel's Ascendancy##27102
	step
		goto 69.5,68.0 |n
		.' Enter the cave |goto 69.5,68.0,0.5 |noway |c
	step
		goto 72.8,62.0
		.kill Maziel |q 27102/1
		.' Click the Quest Complete box that displays on the right side of the screen under your minimap
		..turnin Maziel's Ascendancy##27102
	step
		goto 69.5,68.0 |n
		.' Leave the cave |goto 69.5,68.0,0.5 |noway |c	
	step
		goto 64.5,82.1
		.talk Stormcaller Mylra##44010
		..turnin The Twilight Overlook##27061
		..accept Big Game, Big Bait##26766
		..accept To Catch a Dragon##26768
	step
		goto 68.2,77.9
		.from Scalesworn Cultist##44221+
		.get Twilight Snare |q 26768/1
	step
		goto 64.5,82.1
		.talk Stormcaller Mylra##44010
		..turnin To Catch a Dragon##26768
	step
		goto 59.9,83.6
		.from Jadecrest Basilisk##43981+
		.' Use Mylra's Knife on Jadefire Basilisk corpses |use Mylra's Knife##60382
		.get 5 Side of Basilisk Meat |q 26766/1 
	step
		goto 64.5,82.1
		.talk Stormcaller Mylra##44010
		..turnin Big Game, Big Bait##26766
		..accept Testing the Trap##26771
	step
		goto 50.9,85.3
		.' Use your Trapped Basilisk Meat |use Trapped Basilisk Meat##60773
		.kill Stonescale Matriarch |q 26771/1
	step
		goto 64.5,82.1
		.talk Stormcaller Mylra##44010
		..turnin Testing the Trap##26771
		..accept Abyssion's Minions##26857
	step
		goto 64.6,82.2
		.talk Seer Galekk##44222
		..accept Block the Gates##26861
	step
		goto 68.7,75.0
		.' Use your Stormstone next to the swirling blue portal |use Stormstone##60501
		.' Disrupt the Twilight Gate |q 26861/1
	step
		goto 71.2,75.1
		.' Use your Stormstone next to the structure with the floating yellow crystal |use Stormstone##60501
		.' Disrupt the Elemental Gate |q 26861/2
	step
		goto 69.9,76.7
		.from Scalesworn Cultist##44221+, Twilight Scalesister##43967+, Twilight Dragonspawn##43966+
		.' Defeat 8 Abyssion's Underlings |q 26857/1
	step
		goto 64.6,82.2
		.talk Seer Galekk##44222
		..turnin Block the Gates##26861
	step
		goto 64.5,82.2
		.talk Stormcaller Mylra##44010
		..turnin Abyssion's Minions##26857
		..accept The World Pillar Fragment##26876
	step
		goto 69.9,76.9
		.' Use your Earthen Ring Banner |use Earthen Ring Banner##60810
		.from Abyssion##
		.' Click The First Fragment of the World Pillar |tip It's a floating green rock that appears after you kill Abyssion.
		.get The Upper World Pillar Fragment |q 26876/1
	step
		goto 49.6,53.0
		.talk Maruut Stonebinder##43065
		..turnin The World Pillar Fragment##26876
	step
		goto 49.7,52.9
		.talk Seer Kormo##43397
		..turnin Blood of the Earthwarder##26259
	step
		goto 27.9,68.7
		.talk Crag Rockcrusher##43071
		..turnin To Stonehearth's Aid##26484
		..accept The Quaking Fields##27931
	step
		goto 30.6,77.7
		.talk Slate Quicksand##47195
		..turnin The Quaking Fields##27931
		..accept The Axe of Earthly Sundering##27932
		..accept Elemental Ore##27933
	step
		goto 32.2,79.1
		.' Use The Axe of Earthly Sundering on Emerald Colossi |use The Ace of Earthly Sundering##60490 |tip They look like glowing giants that walk around this area.
		.kill 5 Sundered Emerald Colossus |q 27932/1 
		.from Jade Rager##44220+
		.get 6 Elemental Ore |q 27933/1
	step
		goto 30.6,77.7
		.talk Slate Quicksand##47195
		..turnin The Axe of Earthly Sundering##27932
		..turnin Elemental Ore##27933
		..accept One With the Ground##27934
	step
		goto 30.6,77.7
		.talk Slate Quicksand##47195
		..' Tell him you are ready for the ritual
		.' Complete the One With the Ground Ritual |q 27934/1
		.' Click the Quest Complete box that displays on the right side of the screen under your minimap
		..turnin One With the Ground##27934
		..accept Bring Down the Avalanche##27935
	step
		goto 46.9,89.1
		.kill Avalanchion |q 27935/1
	step
		goto 43.4,82.0 |n
		.' Leave the cave |goto 43.4,82.0,0.5 |noway |c
	step
		goto 27.9,68.7
		.talk Crag Rockcrusher##43071
		..turnin Bring Down the Avalanche##27935
		..accept Stonefather's Boon##26499
	step
		goto 28.2,69.6
		.talk Earthbreaker Dolomite##43160
		..accept We're Surrounded##26500
	step
		goto 29.7,68.8
		kill 12 Stone Trogg Ambusher |q 26500/1
		.' Use Stonefather's Banner next to Stone Hearth Defenders |use Stonefather's Banner##58884 |tip They look like dwarves.  Stonefather's Banner won't work on the Stone Hearth Defenders if they already have the Stonefather's Boon buff.
		.' Grant the Stonefather's Boon 12 times |q 26499/1
	step
		goto 28.2,69.6
		.talk Earthbreaker Dolomite##43160
		..turnin We're Surrounded##26500
		..accept Thunder Stones##26502
	step
		goto 27.9,68.7
		.talk Crag Rockcrusher##43071
		..turnin Stonefather's Boon##26499
		..accept Sealing the Way##26501
	step
		goto 27.3,67.8
		.' Use your Rockslide Reagent on the Earthen Geomancer |use Rockslide Reagent##58885 |tip They must be out of combat for it to work, so kill any troggs attacking the Earthen Geomancer.
		.' Seal the Shrine |q 26501/4
	step
		goto 26.0,68.8
		.' Use your Rockslide Reagent on the Earthen Geomancer |use Rockslide Reagent##58885 |tip They must be out of combat for it to work, so kill any troggs attacking the Earthen Geomancer.
		.' Seal the Barracks |q 26501/3
	step
		goto 26.2,69.8
		.' Use your Rockslide Reagent on the Earthen Geomancer |use Rockslide Reagent##58885 |tip They must be out of combat for it to work, so kill any troggs attacking the Earthen Geomancer.
		.' Seal the Inn |q 26501/2
	step
		goto 27.3,70.1
		.' Use your Rockslide Reagent on the Earthen Geomancer |use Rockslide Reagent##58885 |tip They must be out of combat for it to work, so kill any troggs attacking the Earthen Geomancer.
		.' Seal the Armory |q 26501/1
		.' Click Thunder Stones |tip They looks like blue round spiked cannonballs on the ground and in wagons around this area.
		.get 12 Thunder Stone |q 26502/1 
	step
		goto 24.5,62.4
		.talk Gravel Longslab##43168
		..turnin Sealing the Way##26501
		..accept Shatter Them!##26537
	step
		goto 24.8,62.2
		.talk Clay Mudaxle##43169
		..turnin Thunder Stones##26502
		..accept Fixer Upper##26564
	step
		goto 24.6,62.2
		.talk Earthmender Deepvein##43319
		..accept Battlefront Triage##26591
	step
		goto 23.9,60.3
		.' Use Deepvein's Patch Kit on Injured Earthens |use Deepvein's Patch Kit##58965 |tip They look like dwarves laying on the ground around this area.
		.' Patch up 10 Injured Earthen |q 26591/1
		.' Click Catapult Parts |tip They look kind of like big metal parts laying on the ground around this area.
		.get 6 Catapult Part |q 26564/1 
		.from Stone Trogg Berserker##43228+, Stone Trogg Geomancer##43234+, Needlerock Rider##43250+
		.kill 12 Fractured Battlefront stone troggs |q 26537/1
	step
		goto 24.5,62.4
		.talk Gravel Longslab##43168
		..turnin Shatter Them!##26537
	step
		goto 24.6,62.2
		.talk Earthmender Deepvein##43319
		..turnin Battlefront Triage##26591
	step
		goto 24.8,62.2
		.talk Clay Mudaxle##43169
		..turnin Fixer Upper##26564
	step
		goto 24.5,62.4
		.talk Gravel Longslab##43168
		..accept Troggzor the Earthinator##26625
	step
		goto 22.6,56.9
		.from Troggzor the Earthinator##43456
		.get The Earthinator's Cudgel |q 26625/1 
	step
		goto 24.5,62.4
		.talk Gravel Longslab##43168
		..turnin Troggzor the Earthinator##26625
	step
		goto 24.8,62.2
		.talk Clay Mudaxle##43169
		..accept Rush Delivery##27126
	step
		goto 20.7,61.6
		.talk Peak Grindstone##45043
		..turnin Rush Delivery##27126
		..accept Close Escort##26632
	step
		goto 20.7,61.6
		.talk Peak Grindstone##45043
		..' Tell him you're ready to escort the catapult
		.' Safely Escort the Earthen Catapult |q 26632/1
	step
		goto 22.7,52.0
		.talk Pyrium Lodestone##43897
		..turnin Close Escort##26632
		..accept Keep Them off the Front##26755
	step
		goto 22.4,52.0
		.' Click an Earthen Catapult |tip They look like wooden launchers with stone wheels.
		.' Use your Fire Catapult ability on your hotbar on the Stone Trogg and Fungal mobs
		.' Bombarb 30 Reinforcements |q 26755/1
	step
		goto 22.7,52.0
		.talk Pyrium Lodestone##43897
		..turnin Keep Them off the Front##26755
		..accept Reactivate the Constructs##26762
	step
		goto 22.8,52.1
		.talk Flint Oremantle##43898
		..accept Mystic Masters##26770
	step
		goto 22.6,47.6
		.' Click Deactivated War Construct |tip They look like metal golems around this area.
		.' Reactivate 5 Deactivated War Constructs |q 26762/1
		.kill 5 Needlerock Mystic |q 26770/1
	step
		goto 22.8,52.1
		.talk Flint Oremantle##43898
		..turnin Mystic Masters##26770
	step
		goto 22.7,52.0
		.talk Pyrium Lodestone##43897
		..turnin Reactivate the Constructs##26762
		..accept Down Into the Chasm##26834
	step
		goto 27.6,44.8
		.talk Slate Quicksand##44143
		..turnin Down Into the Chasm##26834
		..accept Sprout No More##26791
		..accept Fungal Monstrosities##26792
	step
		goto 27.6,44.7
		.' Click the War Guardian |tip It looks like a metal golem.
		.' Obtain a War Guardian for the Sprout No More quest |q 26791/1
		.' Obtain a War Guardian for the Fungal Monstrosities quest |q 26792/1
	step
		goto 26.8,41.8
		.kill 5 Fungal Monstronsity |q 26792/2
		.' Click Giant Mushrooms |tip They look like huge mushrooms with orange caps around this area.
		.' Destroy 5 Giant Mushrooms |q 26791/2
	step
		goto 27.6,44.8
		.talk Slate Quicksand##44143
		..turnin Sprout No More##26791
		..turnin Fungal Monstrosities##26792
		..accept A Slight Problem##26835
	step
		goto 22.7,52.0
		.talk Pyrium Lodestone##43897
		..turnin A Slight Problem##26835
		..accept Rescue the Stonefather... and Flint##26836
	step
		goto 24.5,31.1
		.from Bouldergut##44151
		.' Rescue Stonefather Oremantle |q 26836/1
	step
		goto 22.7,52.0
		.talk Pyrium Lodestone##43897
		..turnin Rescue the Stonefather... and Flint##26836
		..accept The Hero Returns##27937
	step
		goto 28.0,68.6
		.talk Stonefather Oremantle##44204
		..turnin The Hero Returns##27937
		..accept The Middle Fragment##27938
	step
		goto 28.0,68.7
		.' Click The Stonefather's Safe |tip It looks like a metal vault door with gold circles and symbols on it.
		.get The Middle Fragment of the World Pillar |q 27938/1
	step
		goto 49.5,53.3
		.talk Earthcaller Yevaa##42573
		..turnin The Middle Fragment##27938
	step
		goto 49.6,53.0
		.talk Maruut Stonebinder##43065
		..accept The Very Earth Beneath Our Feet##26326
	step
		goto 46.1,45.6
		.talk Earthcaller Torunscar##42730
		..turnin The Very Earth Beneath Our Feet##26326
		..accept Crumbling Defenses##26312
		..accept On Even Ground##26314
	step
		goto 46.2,45.7
		.talk Earthmender Norsala##42731
		..accept Core of Our Troubles##26313
	step
		goto 44.3,43.7
		.from Irestone Rumbler##42780+
		.' Use your Elementium Grapple Line on Servants of Therazane |use Elementium Grapple Line##58169 |tip Run away from the Servants of Therazane to bring them down.
		.' Relieve Stormcaller Mylra |q 26312/2
	step
		goto 44.5,41.3
		.from Irestone Rumbler##42780+
		.' Use your Elementium Grapple Line on Servants of Therazane |use Elementium Grapple Line##58169 |tip Run away from the Servants of Therazane to bring them down.
		.' Relieve Tawn Winterbluff |q 26312/1
	step
		goto 47.6,42.8
		.from Irestone Rumbler##42780+
		.' Use your Elementium Grapple Line on Servants of Therazane |use Elementium Grapple Line##58169 |tip Run away from the Servants of Therazane to bring them down.
		.' Relieve Hargoth Dimblaze |q 26312/3
	step
		goto 46.2,42.2
		.from Irestone Rumbler##42780+
		.get 6 Irestone Core |q 26313/1
		.' Use your Elementium Grapple Line on Servants of Therazane |use Elementium Grapple Line##58169 |tip Run away from the Servants of Therazane to bring them down.
		.' Bring down 3 Servants of Therazane |q 26314/1
	step
		goto 46.2,45.7
		.talk Earthmender Norsala##42731
		..turnin Core of Our Troubles##26313
	step
		goto 46.1,45.6
		.talk Earthcaller Torunscar##42730
		..turnin Crumbling Defenses##26312
		..turnin On Even Ground##26314
	step
		goto 46.2,45.7
		.talk Earthmender Norsala##42731
		..accept Imposing Confrontation##26315
	step
		goto 49.2,40.1
		.' Use your Earthen Ring Proclamation on Boden the Imposing |use Earthen Ring Proclamation##58177 |tip He's a huge rock giant that walks around this area.
		.' Seek Peace with Boden the Imposing |q 26315/1
	step
		goto 46.2,45.7
		.talk Earthmender Norsala##42731
		..turnin Imposing Confrontation##26315
		..accept Rocky Relations##26328
	step
		goto 56.5,42.7
		.talk Diamant the Patient##42467
		..turnin Rocky Relations##26328
		..accept Hatred Runs Deep##26376
		..accept Unsolid Ground##26377
	step
		goto 56.5,41.0
		.talk Quartz Stonetender##42899
		..accept Loose Stones##26375
	step
		goto 60.2,39.4
		.kill Dragul Giantbutcher |q 26376/1
	step
		goto 59.5,41.5
		.' Click Jade Crystal Clusters |tip They look like green glowing rocks sitting on the ground all around this area.
		.collect 6 Jade Crystal Cluster##58500 |q 26377
		.' Use your Delicate Chain Smasher next to Quartz Rocklings |use Delicate Chain Smasher##58254 |tip They look like small rock giants around this area.
		.' Release 6 Quartz Rocklings |q 26375/1
	step
		'Use the Jade Crystal Clusters |use Jade Crystal Cluster##58500
		.collect Jade Crystal Composite##58783 |q 26377
	step
		goto 59.6,41.4
		.' Use your Jade Crystal Composite |use Jade Crystal Composite##58783
		.' Lure an Agitated Tunneler |q 26377/1
	step
		goto 59.3,40.6
		.from Twilight Laborer##42924+, Twilight Priestess##42823+, Twilight Duskwarden##42917+
		.kill 12 Lorthuna's Gate Cultists |q 26376/2 
	step
		goto 56.5,41.0
		.talk Quartz Stonetender##42899
		..turnin Loose Stones##26375
	step
		goto 56.5,42.7
		.talk Diamant the Patient##42467
		..turnin Hatred Runs Deep##26376
		..turnin Unsolid Ground##26377
		..accept Violent Gale##26426
	step
		goto 51.7,31.6
		.' Get next to Felsen the Enduring |tip He's a big white rock giant.
		.' Find Felsen the Enduring |q 26426/1
	step
		goto 58.4,25.7
		.' Fly to the mouth of this cave
		.' Find the entrance to the Crumbling Depths |q 26426/2
		.' Click the Quest Complete box that displays on the right side of the screen under your minimap
		..turnin Violent Gale##26426
		..accept Depth of the Depths##26869
	step
		goto 64.5,21.7 |n
		.' Follow the path |goto 64.5,21.7,0.5 |noway |c
	step
		goto 65.3,18.4 |n
		.' Follow the path |goto 65.3,18.4,0.5 |noway |c
	step
		goto 66.4,20.6
		.' Click the Gigantic Painite Cluster |tip It looks like a green crystal cluster near the mouth of the cave.
		..turnin Depth of the Depths##26869
		..accept A Rock Amongst Many##26871
	step
		goto 64.3,23.5
		.' Follow the path to this spot, then jump down |goto 64.3,23.5,0.5 |noway |c
	step
		goto 58.3,25.5 |n
		.' Leave the cave |goto 58.3,25.5,0.5 |noway |c
	step
		goto 56.5,42.7
		.talk Diamant the Patient##42467
		..turnin A Rock Amongst Many##26871
		..accept Entrenched##26436
	step
		goto 34.3,34.3
		.talk Kor the Immovable##42469
		..turnin Entrenched##26436
		..accept Intervention##26438
		..accept Making Things Crystal Clear##26437
	step
		goto 34.6,34.2
		.talk Berracite##43344
		..accept Putting the Pieces Together##26439
	step
		goto 30.5,46.8
		.from Jaspertip Borer##42524+, Jaspertip Swarmer##42521+, Jaspertip Ravager##42525+, Jaspertip Crystal-gorger##43171+
		.kill 12 Jaspertip flayers |q 26438/1
		.' Click Chalky Crystal Formations |tip They look like big white blocks on the ground around this area.
		.get 8 Chalky Crystal Formation |q 26437/1 
		.' Click Dormant Stonebound Elementals |tip They look like crumbled rock elementals on the ground around this area.
		.' Reform 6 Stonebound Elementals |q 26439/1
	step
		goto 34.3,34.3
		.talk Kor the Immovable##42469
		..turnin Intervention##26438
		..turnin Making Things Crystal Clear##26437
	step
		goto 34.5,34.4
		.talk Berracite##43344
		..turnin Putting the Pieces Together##26439
	step
		'Next to you:
		.talk Pebble##43116
		..accept Clingy##26440
	step
		goto 30.1,47.7
		.' Get next to the huge green crystals
		.' Bring Pebble to the crystal formation |q 26440/1
	step
		'Next to you:
		.talk Pebble##43116
		..turnin Clingy##26440
		..accept So Big, So Round...##26441
	step
		goto 34.3,34.3
		.talk Kor the Immovable##42469
		..turnin So Big, So Round...##26441
		..accept Petrified Delicacies##26507
		..accept Rock Bottom##26575
	step
		goto 47.6,26.8
		.kill Gorgonite |q 26575/1
	step
		goto 47.5,26.8
		.' Click Petrified Stone Bats |tip They looks like black stone bats laying on the ground around this area.
		.get 12 Petrified Stone Bat |q 26507/1
	step
		'Next to you:
		.talk Pebble##43116
		..turnin Petrified Delicacies##26507
	step
		goto 34.3,34.3
		.talk Kor the Immovable##42469
		..turnin Rock Bottom##26575
		..accept Steady Hand##26576
		..accept Rocky Upheaval##26577
	step
		goto 39.9,19.4
		.talk Terrath the Steady##42466
		..turnin Steady Hand##26576
		..accept Don't. Stop. Moving.##26656
	step
		goto 39.9,19.4
		.talk Terrath the Steady##42466
		..' Tell him you are ready to escort a group of elementals across the open.
		.' Speak to Terrath the Steady |q 26656/1
	step
		goto 51.1,14.7
		.' Go to this spot
		.' Escort 5 Opalescent Guardians to safety |q 26656/2 |tip Run on the ground with your mount, don't fly or you the rock elementals will disappear when you get too far away from them.
	step
		goto 39.9,19.4
		.talk Terrath the Steady##42466
		..turnin Don't. Stop. Moving.##26656
		..accept Hard Falls##26657
		..accept Fragile Values##26658
	step
		goto 35.4,22.5
		.from Stone Trogg Beast Tamer##43598 |tip He moves all around this area capturing basilisks, so you may need to look around a bit for him.
		.get Stonework Mallet |q 26658/1
	step
		goto 39.9,19.4
		.talk Terrath the Steady##42466
		..turnin Fragile Values##26658
	step
		goto 36.5,18.8
		.kill 6 Stone Drake |q 26657/1 |tip They will fall to the ground with half health, so you can kill them, even though they are elite.
	step
		goto 40.0,19.4
		.talk Terrath the Steady##42466
		..turnin Hard Falls##26657
		..accept Resonating Blow##26659
	step
		goto 32.7,24.3
		.' Use your Stonework Mallet next to the Pale Resonating Crystal |use Stonework Mallet##60266 |tip It's a huge green crystal sitting on the ground.
		.' Strike the Pale Resonating Crystal |q 26659/1
		.from Aeosera##43641 |tip Click the Boulder Platforms to jump from rock to rock while fighting Aeosera.  When she is casting her Breath Fire ability, jump to another rock and attack her while she is breathing fire to the other rock.  Repeat this until she surrenders.
		.' Defeat Aeosera |q 26659/2
	step
		goto 33.1,24.1
		.talk Terrath the Steady##42466
		..turnin Resonating Blow##26659
	step
		goto 49.5,53.3
		.talk Earthcaller Yevaa##42573
		..accept The Reliquary##27953
	step
		goto 51.3,50.1
		.talk Examiner Rowe##44823
		..turnin The Reliquary##27953
		..accept The Twilight Plot##27005
	step
		goto 51.3,50.0
		.talk Reliquary Jes'ca Darksun##44818
		..accept Fly Over##27008
	step
		goto 39.0,74.2
		.' Go to this spot next to the big white portal
		.' Investigate the Master's Gate |q 27008/1 
	step
		goto 40.1,72.2
		.from Twilight Cryptomancer##44855+, Twilight Crusher##44849+, Twilight Armsman##44847+
		.get Masters' Gate Plans |q 27005/1
	step
		goto 51.3,50.1
		.talk Examiner Rowe##44823
		..turnin The Twilight Plot##27005
	step
		goto 51.3,50.0
		.talk Reliquary Jes'ca Darksun##44818
		..turnin Fly Over##27008
		..accept Fight Fire and Water and Air with...##27043
	step
		goto 51.3,50.1
		.talk Examiner Rowe##44823
		..accept Decryption Made Easy##27041
	step
		goto 40.8,66.3
		.from Bound Water Elemental##44886
		.' Acquire the Water Ward |q 27043/2
	step
		goto 36.0,67.4
		.from Bound Fire Elemental##44887
		.' Acquire the Fire Ward |q 27043/1
	step
		goto 40.5,72.4
		.from Bound Air Elemental##44885
		.' Acquire the Air Ward |q 27043/3
	step
		goto 40.2,67.5
		.' Click One-Time Decryption Engines |tip They look like machines around this area with a circular scroll spinning around them, and yellow cores floating in the middle of the spinning scrolls.
		.' Decrypt 6 Plans |q 27041/1
		.' Click the Quest Complete box that displays on the right side of the screen under your minimap
		..turnin Decryption Made Easy##27041
		..accept The Wrong Sequence##27059
	step
		goto 39.1,73.9
		.' Click the Waygate Controller |tip It looks like a cylinder stone container with a stone ring on top of it, sitting in front of the huge white portal.
		.' Destroy the Waygate |q 27059/1
	step
		goto 39.9,62.2
		.kill Haethen Kaul |q 27043/4 |tip He's up on a huge floating rock.
	step
		goto 51.3,50.0
		.talk Examiner Rowe##44823
		..turnin The Wrong Sequence##27059
		..accept That's No Pyramid!##28293
	step
		goto 51.3,50.0
		.talk Reliquary Jes'ca Darksun##44818
		..turnin Fight Fire and Water and Air with...##27043
	step
		goto 72.2,54.0
		.talk Gorsik the Tumultuous##42472
		..turnin Rocky Upheaval##26577
		..accept Doomshrooms##26578
		..accept Gone Soft##26579
		..accept Familiar Intruders##26580
	step
		goto 71.8,47.6
		.talk Windspeaker Lorvarius##43395
		..turnin Familiar Intruders##26580
		..accept A Head Full of Wind##26581
	step
		goto 73.6,40.8
		.kill 8 Fungal Behemoth |q 26579/1
		.from Doomshroom##+ |tip They look like orange mushrooms around this area.
		.' Destroy 10 Doomshrooms |q 26578/1
		.' Gather a sample of the red mist|q 26581/1 |tip There are small clouds of red mist that float around on the ground around this area.  Walk into one of them to gather a sample.
	step
		goto 71.8,47.6
		.talk Windspeaker Lorvarius##43395
		..turnin A Head Full of Wind##26581
		..accept Unnatural Causes##26582
	step
		goto 72.2,54.0
		.talk Gorsik the Tumultuous##42472
		..turnin Doomshrooms##26578
		..turnin Gone Soft##26579
		..turnin Unnatural Causes##26582
		..accept Shaken and Stirred##26584
		..accept Corruption Destruction##26585
	step
		goto 68.5,26.4
		.talk Ruberick##43442
		..accept Wrath of the Fungalmancer##26583
	step
		goto 68.6,29.1 |n
		.' Enter the cave |goto 68.6,29.1,0.5 |noway |c
	step
		goto 69.8,31.9
		.talk Earthmender Norsala##43503
		..' Tell her you're ready when she is
		.kill Fungalmancer Glop |q 26583/2 |tip Follow him each time he runs away.  Avoid the mushrooms as you walk, they will give you a debuff.  While fighting Fungalmancer Glop, kill the Boomshrooms he creates.  Don't let them grow too big, they will explode and deal a lot of damage.
	step
		goto 70.2,33.8 |n
		.' Follow the path up |goto 70.2,33.8,0.5 |noway |c
	step
		goto 68.6,29.1 |n
		.' Leave the cave |goto 68.6,29.1,0.5 |noway |c
	step
		goto 68.5,26.3
		.talk Ruberick##43442
		..turnin Wrath of the Fungalmancer##26583
	step
		goto 69.4,24.8
		.kill 8 Verlok Pillartumbler |q 26584/1
		.' Click Verlok Miracle-grow |tip They look like gray bags sitting on the ground around this area.
		.get 8 Verlok Miracle-grow |q 26585/1
	step
		goto 72.2,54.0
		.talk Gorsik the Tumultuous##42472
		..turnin Shaken and Stirred##26584
		..turnin Corruption Destruction##26585
		..accept At the Stonemother's Call##26750
	step
		goto 56.3,12.2
		.talk Therazane##42465
		..turnin At the Stonemother's Call##26750
		..accept Audience with the Stonemother##26752
	step
		'Watch the dialogue
		.' Attend the Stonemother's Audience |q 26752/1
	step
		goto 56.1,13.5
		.talk Earthcaller Torunscar##43809
		..turnin Audience with the Stonemother##26752
		..accept Rallying the Earthen Ring##26827
	step
		goto 49.9,50.1
		.talk Hargoth Dimblaze##44644
		..' Tell him you are joining an assault on Lorthuna's Gate and he is needed.
		|confirm
	step
		goto 51.5,51.8
		.talk Stormcaller Jalara##44633
		..' Tell her you are joining an assault on Lorthuna's Gate and she is needed.
		|confirm
	step
		goto 49.9,50.1
		.talk Hargoth Dimblaze##44644
		..' Tell him you are joining an assault on Lorthuna's Gate and he is needed.
		.' Rally 5 Earthen Ring |q 26827/1
	step
		goto 49.6,53.0
		.talk Maruut Stonebinder##43065
		..turnin Rallying the Earthen Ring##26827
		..accept Our Part of the Bargain##26828
	step
		goto 63.3,25.0
		.talk Therazane##44025
		..turnin Our Part of the Bargain##26828
		..accept The Stone March##26829
		..accept Therazane's Mercy##26832
	step
		goto 62.6,26.9
		.talk Boden the Imposing##44080
		..accept The Twilight Flight##26831
	step
		goto 62.4,31.8
		.from High Priestess Lorthuna##42914 |tip She is in a small room on the top of this building.  She is elite, but you can still kill her.  She will run away when she is almost dead.
		.' Defeat High Priestess Lorthuna |q 26832/2
	step
		goto 58.9,32.9
		.from Boldrich Stonerender##42923
		.' Defeat Boldrich Stonerender |q 26832/1
	step
		goto 63.1,38.1
		.from Zoltrik Drakebane##42918 |tip You will eventually get on a stone drake and fly after Zoltrik Drakebane.  You can use your Jump ability to jump onto his drake, if you are a melee class.  Either way, you will land on a rock with him and kill him there.
		.' Defeat Zoltrik Drakebane |q 26831/1
	step
		goto 64.1,36.9
		.talk Terrath the Steady##42614
		..turnin The Twilight Flight##26831
	step
		goto 60.3,33.2
		.from Defaced Earthrager##44076+, Twilight Soulreaper##42916+, Twilight Priestess##42823+
		.kill 15 Twilight Precipice Cultists |q 26829/1
	step
		goto 63.3,25.0
		.talk Therazane##44025
		..turnin The Stone March##26829
		..turnin Therazane's Mercy##26832
		..accept Word In Stone##26833
	step
		goto 49.6,53.0
		.talk Maruut Stonebinder##43818
		..turnin Word In Stone##26833
		..accept Undying Twilight##26875
	step
		goto 50.7,49.6
		.kill 12 Twilight Invaders |q 26875/1
		.kill Desecrated Earthrager |q 26875/2
		.' Click the Quest Complete box that displays on the right side of the screen under your minimap
		..turnin Undying Twilight##26875
		..accept The Binding##26971
	step
		goto 49.6,52.9
		.kill High Priestess Lorthuna |q 26971/1 
	step
		goto 49.6,52.9
		.talk Earthcaller Torunscar##43835
		..turnin The Binding##26971
	step
		goto 49.8,53.4
		.talk Therazane##43792
		..accept The Stone Throne##26709
	step
		goto 56.4,12.1
		.talk Therazane##42465
		..turnin The Stone Throne##26709
]])
ZygorGuidesViewer:RegisterInclude("H_Therazane_DailyQuest", [[
		'Increasing your Therazane reputation to Revered will unlock more daily quests. |tip Use the THERAZANE REPUTATION guide in the Cataclysm Reputation section to do this.
	step
		goto Deepholm,56.1,14.4
		.talk Felsen the Enduring##43805
		..accept Fear of Boring##27046
		..accept Motes##27047
		..accept Beneath the Surface##28488 |tip This quest can be offered at random and may not be offered every day.
	step
		goto 56.6,14.1
		.talk Terrath the Steady##43806
		..accept The Restless Brood##28391 |tip This quest can be offered at random if you have at least Revered reputation with Therazane.  However, the quest may not be offered every day.
		only if rep ('Therazane') >= Revered
	step
		goto 55.4,14.2
		.talk Pyrite Stonetender##44945
		..accept Lost In The Deeps##26710 |tip This quest can be offered at random and may not be offered every day.
	step
		goto 57.3,12.5
		.talk Gorsik the Tumultuous##43804
		..accept Soft Rock##27049
		..accept Fungal Fury##27050
	step
		goto 59.6,14.0
		.talk Ruberick##44973
		..accept Through Persistence##27051
		..accept Glop, Son of Glop##28390 |only if rep ('Therazane') >= Revered |tip This quest can be offered at random if you have at least Revered reputation with Therazane.  However, the quest may not be offered every day.
	step
		goto 32.7,24.3
		.' Use your Stonework Mallet next to the Pale Resonating Crystal |use Stonework Mallet##60266 |tip It's a huge green crystal sitting on the ground.
		.' Strike the Pale Resonating Crystal |q 28391/1
		.from Aeosera##43641 |tip Click the Boulder Platforms to jump from rock to rock while fighting Aeosera.  When she is casting her Breath Fire ability, jump to another rock and attack her while she is breathing fire to the other rock.  Repeat this until she surrenders.
		.' Defeat Aeosera |q 28391/2
		only if rep ('Therazane') >= Revered
	step
		goto 56.6,14.1
		.talk Terrath the Steady##43806
		..turnin The Restless Brood##28391
		only if rep ('Therazane') >= Revered
	step
		goto 58.3,25.6 |n
		.' Enter the cave |goto 58.3,25.6,0.5 |noway |c
	step
		goto 61.3,26.2
		.talk Ricket##44968
		..accept Underground Economy##27048 |tip This quest can be offered at random and may not be offered every day.
	step
		goto 66.1,28.1
		.' Follow the path inside the cave
		.' Click the Ruby Gemstone Cluster |tip It looks like 3 dark colored spinning rings with a bunch of red crystals spinning above them.
		.from Enormous Gyreworm##48533
		.get Ruby Crystal Cluster |q 28488/1
	step
		goto 63.6,23.0
		.' Use Ricket's Tickers next to Deep Alabaster Crystals |use Ricket's Tickers##65514 |tip They look like huge white rocks around this area.
		.get 3 Deep Alabaster Crystal |q 27048/1
	step
		goto 62.6,23.9 |n
		.' Follow this path |goto 62.6,23.9,0.5 |noway |c
	step
		goto 61.8,19.7
		.' Use Ricket's Tickers next to Deep Celestite Crystals |use Ricket's Tickers##65514 |tip They look like huge blue rocks around this area.
		.get 3 Deep Celestite Crystal |q 27048/2
	step
		goto 62.0,18.0 |n
		.' Follow this path |goto 62.0,18.0,0.5 |noway |c
	step
		goto 64.4,18.6
		.' Use Ricket's Tickers next to Deep Amethyst Crystals |use Ricket's Tickers##65514 |tip They look like huge purple rocks around this area.
		.get 3 Deep Amethyst Crystal |q 27048/3
	step
		goto 65.3,18.4 |n
		.' Follow this path |goto 65.3,18.4,0.5 |noway |c
	step
		goto 66.4,20.2
		.' Use Ricket's Tickers next to Deep Garnet Crystals |use Ricket's Tickers##65514 |tip They look like huge red rocks around this area.
		.get 3 Deep Garnet Crystal |q 27048/4	
	step
		goto 63.6,23.9
		.' All around inside this cave:
		.from Gorged Gyreworm##42766+, Gyreworm##44257+
		.kill 10 Gyreworm |q 27046/1
		.' Click Painite Shards |tip They look like small green glowing crystals sitting on the ground all around inside this cave.
		.get 10 Painite Mote |q 27047/1
	step
		goto 63.1,20.8
		.talk Pebble##49956
		..' Tell him to follow you
	step
		goto 64.2,17.6 |n
		.' Follow this path |goto 64.2,17.6,0.5 |noway |c
	step
		goto 61.3,26.2
		.talk Ricket##44968
		..turnin Underground Economy##27048
	step
		goto 58.3,25.6 |n
		.' Leave the cave |goto 58.3,25.6,0.5 |noway |c
	step
		goto 58.3,25.6
		.' Wait in this spot until Pebble bobbles around appreciatively and then disappears into the distance
		.' Bring Pebble to safety |q 26710/1
	step
		goto 74.0,41.2
		.kill 8 Fungal Behemoth |q 27049/1
		.from Verlok Grubthumper##43367+, Verlok Shroomtender##43368+
		.get Bag of Verlok Miracle-Grow |q 27051/1
		.' Click Sprouting Crimson Mushrooms |tip They look like tiny mushrooms on the ground around this area.  Try to only click the solid blue, solid red, or white-brown ones.  The blue ones with red spots will explode and hurt you. 
		.' Destroy 10 Freshly Sprouted Mushrooms |q 27050/1
	step
		goto 68.6,29.1 |n
		.' Enter the cave |goto 68.6,29.1,0.5 |noway |c
	step
		goto 69.8,31.9
		.talk Earthmender Norsala##43503
		..' Tell her you're ready when she is
		.kill Fungalmancer Glop |q 28390/1 |tip Follow him each time he runs away.  Avoid the mushrooms as you walk, they will give you a debuff.  While fighting Fungalmancer Glop, kill the Boomshrooms he creates.  Don't let them grow too big, they will explode and deal a lot of damage.
	step
		goto 70.2,33.8 |n
		.' Follow the path up |goto 70.2,33.8,0.5 |noway |c
	step
		goto 68.6,29.1 |n
		.' Leave the cave |goto 68.6,29.1,0.5 |noway |c
	step
		goto 55.4,14.2
		.talk Pyrite Stonetender##44945
		..turnin Lost In The Deeps##26710
	step
		goto 57.3,12.5
		.talk Gorsik the Tumultuous##43804
		..turnin Soft Rock##27049
		..turnin Fungal Fury##27050
	step
		goto 59.6,14.0
		.talk Ruberick##44973
		..turnin Through Persistence##27051
		..turnin Glop, Son of Glop##28390 |only if rep ('Therazane') >= Revered
	step
		goto Deepholm,56.1,14.4
		.talk Felsen the Enduring##43805
		..turnin Fear of Boring##27046
		..turnin Motes##27047
		..turnin Beneath the Surface##28488
]])

--------------------------------------------------------------------------------------------------------------------------------------
-- REPUTATIONS
--------------------------------------------------------------------------------------------------------------------------------------

ZygorGuidesViewer:RegisterInclude("Argent Tourney_Aspirant",[[
		goto Icecrown,76.3,24.3
		.talk Magister Edien Sunhollow##33542
		..accept Up To The Challenge##13678
	step
		goto 76.3,24.4
		.talk Magister Edien Sunhollow##33542
		.' You will only be able to accept, and turn in, 1 of these 3 daily quests per day:
		..accept A Blade Fit For A Champion##13673 |or
		..accept A Worthy Weapon##13674 |or
		..accept The Edge of Winter##13675 |or
	step
		goto 76.3,24.4
		.talk Amariel Sunsworn##33658
		..accept Training in the Field##13676
	step
		goto 76.2,24.4
		.talk Galathia Brightdawn##33659
		..accept Learning the Reins##13677
	step
		goto Grizzly Hills,61.2,50.3
		.' Use the Warts-B-Gone Lip Balm|use Warts-B-Gone Lip Balm##44986
		.' Target Lake Frogs
		.' Use the emote /kiss on the Lake Frogs
		.' Repeat this process until one of the Lake Frogs turns into the Maiden of Ashwood Lake
		.talk Maiden of Ashwood Lake##33220
		..' Tell her you are glad to help
		.get Ashwood Brand |q 13673/1
	step
		goto Icecrown,69.1,76.2
		.click Winter Hyacinth##3231
		.collect 4 Winter Hyacinth##45000 |q 13674
	step
		goto Dragonblight,93.2,26.1
		.' Use Winter Hyacinths in the water here|use Winter Hyacinth##45000
		.' Listen to the Maiden of Drak'Mar
		.click Blade of Drak'Mar##8564
		.get Blade of Drak'Mar |q 13674/1
	step
		goto Crystalsong Forest,54.5,74.9
		.from Lord Everblaze##33289
		.collect 1 Everburning Ember##45005 |q 13675
	step
		goto Howling Fjord,42.2,19.7
		.'Use the Everburning Ember on Maiden of Winter's Breath|use Everburning Ember##45005
		.get Winter's Edge |q 13675/1
	step
		goto Icecrown,74.8,35.5
		.from Vrykul Necrolord##31783+, Frostbrood Whelp##31718+
		.kill 8 Icecrown Scourge |q 13676/1
	step
		goto 75.6,23.7
		.' Equip the Horde Lance in your bags|use Horde Lance##46070
		.' Click to mount the Stabled Sunreaver Hawkstrider|invehicle |q 13677
	step
		goto 73.1,24.8
		.' Target a Melee Target
		.' If you don't want to kill your mount be sure to keep your Defend ability maxed out at 3 stacks
		.' Use your Thrust ability to attack the target 5 times |q 13677/1
	step
		goto 72.9,25.1
		.' Target a Charge Target from a distance
		.' Use Shield-Breaker ability until you notice the targets Defend is gone
		.' Use your Charge ability on the Charge Target 2 times |q 13677/3
	step
		goto 73.3,25.0
		.' Target a Ranged Target from a distance
		.' Use Shield-Breaker ability on Ranged Target to bring it's shields down
		.' Use Shield-Breaker ability on Ranged Target twice, while it's shields are down|q 13677/2
	step
		goto 76.3,24.4
		.talk Magister Edien Sunhollow##33542
		.' You will only be able to accept, and turn in, 1 of these 3 daily quests per day:
		..turnin A Blade Fit For A Champion##13673
		..turnin A Worthy Weapon##13674
		..turnin The Edge of Winter##13675
	step
		goto 76.3,24.4
		.talk Amariel Sunsworn##33658
		..turnin Training in the Field##13676
	step
		goto 76.2,24.4
		.talk Galathia Brightdawn##33659
		..turnin Learning the Reins##13677
	step
		'Make sure you have 15 Aspirant's Seals:
		.get 15 Aspirant's Seal |q 13678/1 |tip If you do not have 15 Aspirant's Seals, keep repeating the daily quests in this guide section.  It takes 3 days of doing these Aspirant Rank dailies to get 15 Aspirant's Seals.
	step
		goto 76.3,24.4
		.talk Magister Edien Sunhollow##33542
		..turnin Up To The Challenge##13678
]])

ZygorGuidesViewer:RegisterInclude("Argent Tourney_Valiant",[[
		goto Icecrown,76.3,24.4
		.talk Magister Edien Sunhollow##33542
		..accept The Aspirant's Challenge##13680
	step
		goto 71.8,20.0
		.' Equip the Horde Lance in your bags|use Horde Lance##46070
		.' Click to mount the Stabled Sunreaver Hawkstrider|invehicle |q 13680
	step
		goto 71.4,19.6
		.talk Squire David##33447
		.' Tell him you are ready to fight!|tip Use your Defend ability on your hotbar to max your shield out at 3 charges before telling Squire David this.
		.'An Argent Valiant runs up on a horse
		.' Use the abilities on your hotbar to defeat the Argent Valiant|tip The best strategy to defeat the Argent Valiant is to always make sure your shield is up by using your Defend ability.  Then, use your Shield-Breaker ability to bring down the Argent Valiant's shield.  When his shield is down, use your Charge ability on him.  Keep repeating this process until he is defeated.
		.' Defeat the Argent Valiant |q 13680/1
	step
		goto 76.3,24.4
		.talk Magister Edien Sunhollow##33542
		..turnin The Aspirant's Challenge##13680
		..accept A Valiant Of Orgrimmar##13691 |only Orc
		..accept A Valiant Of Sen'jin##13693 |only Troll
		..accept A Valiant Of Thunder Bluff##13694 |only Tauren
		..accept A Valiant Of Undercity##13695 |only Scourge
		..accept A Valiant Of Silvermoon##13696 |only BloodElf
	step
		goto 76.5,24.6
		.talk Mokra the Skullcrusher##33361
		..turnin A Valiant Of Orgrimmar##13691
		..accept The Valiant's Charge##13697
		only Orc
	step
		goto 76.0,24.5
		.talk Zul'tore##33372
		..turnin A Valiant Of Sen'jin##13693
		..accept The Valiant's Charge##13719
		only Troll
	step
		goto 76.2,24.6
		.talk Runok Wildmane##33403
		..turnin A Valiant Of Thunder Bluff##13694
		..accept The Valiant's Charge##13720
		only Tauren
	step
		goto 76.5,24.2
		.talk Deathstalker Visceri##33373
		..turnin A Valiant Of Undercity##13695
		..accept The Valiant's Charge##13721
		only Scourge
	step
		goto 76.5,23.9
		.talk Eressea Dawnsinger##33379
		..turnin A Valiant Of Silvermoon##13696
		..accept The Valiant's Charge##13722
		only BloodElf
	// ORC VALIANT RANK DAILY LOOP (BEGIN)
	step
		goto 76.5,24.6
		.talk Mokra the Skullcrusher##33361
		.' You will only be able to accept, and turn in, 1 of these 3 daily quests per day:
		..accept A Blade Fit For A Champion##13762 |or
		..accept A Worthy Weapon##13763 |or
		..accept The Edge Of Winter##13764 |or
		only Orc
	step
		goto 76.5,24.5
		.talk Akinos##33405
		..accept A Valiant's Field Training##13765
		only Orc
	step
		goto 76.4,24.6
		.talk Morah Worgsister##33544
		..accept The Grand Melee##13767
		..accept At The Enemy's Gates##13856
		only Orc
	step
		goto Grizzly Hills,61.2,50.3
		.' Use the Warts-B-Gone Lip Balm|use Warts-B-Gone Lip Balm##44986
		.' Target Lake Frogs
		.' Use the emote /kiss on the Lake Frogs
		.' Repeat this process until one of the Lake Frogs turns into the Maiden of Ashwood Lake
		.talk Maiden of Ashwood Lake##33220
		..get Ashwood Brand |q 13762/1
		only Orc
	step
		goto Icecrown,69.1,76.2
		.click Winter Hyacinth##3231
		.collect 4 Winter Hyacinth##45000 |q 13763
		only Orc
	step
		goto Dragonblight,93.2,26.1
		.' Use Winter Hyacinths in the water here|use Winter Hyacinth##45000
		.' Listen to the Maiden of Drak'Mar
		.click Blade of Drak'Mar##8564
		.get Blade of Drak'Mar |q 13763/1
		only Orc
	step
		goto Crystalsong Forest,54.5,74.9
		.from Lord Everblaze##33289
		.collect 1 Everburning Ember##45005 |q 13764
		only Orc
	step
		goto Howling Fjord,42.2,19.7
		.'Use the Everburning Ember on Maiden of Winter's Breath|use Everburning Ember##45005
		.get Winter's Edge |q 13764/1
		only Orc
	step
		goto Icecrown,48.9,71.4
		.' Equip the Horde Lance in your bags|use Horde Lance##46070
		.' Click to mount the Stabled Campaign Warhorse|invehicle |q 13856
		only Orc
	step
		goto 50.1,74.8
		.kill 15 Boneguard Footman##33438|q 13856/1 |tip They are skeletons that walk around this area.  You can simply run over these with your horse, you don't need to target or attack them at all.
		.kill 10 Boneguard Scout##33550 |q 13856/2 |tip They are gargoyles that fly around this area.  Use your Shield-Breaker ability on them, while also using your Defend ability to keep your shield maxed at 3 charges.
		.kill 3 Boneguard Lieutenant##33429 |q 13856/3 |tip They ride horses around this area.  Use your Shield-Breaker ability on them to bring down their shields, then use your Charge ability on them.  Also, keep your shield maxed at 3 by using your Defend ability.  If they get too close, you can also use your Thrust ability to do a good amount of damage, but just remember to keep your shield maxed at 3 charges.
		only Orc
	step
		goto 49.1,71.4
		'Click the red arrow on your vehicle hot bar to stop riding the horse |outvehicle |q 13856
		only Orc
	step
		goto 44.3,54.2
		.kill 10 Converted Hero##32255 |q 13765/1
		only Orc
	step
		goto 75.5,24.0
		.' Equip the Horde Lance in your bags|use Horde Lance##46070
		.' Click to mount the Stabled Orgrimmar Wolf|invehicle |q 13767
		only Orc
	step
		goto 75.3,26.0
		.' Talk to the riders on mounts of other Horde races
		.' Tell them you are ready to fight!
		.' Fight and defeat them|tip Use your Defend ability to keep your shield maxed at 3 charges, then use your Shield-Breaker to lower the Valiants' shields, then use your Charge ability on them.  If they get close, use your Thrust ability, then use your Charge ability when they run away to get into Charge range.  Just remember to keep your shield maxed at 3 charges.
		.get 3 Mark of the Valiant |q 13767/1
		only Orc
	step
		goto 76.5,24.6
		.talk Mokra the Skullcrusher##33361
		.' You will only be able to accept, and turn in, 1 of these 3 daily quests per day:
		..turnin A Blade Fit For A Champion##13762
		..turnin A Worthy Weapon##13763
		..turnin The Edge Of Winter##13764
		only Orc
	step
		goto 76.5,24.5
		.talk Akinos##33405
		..turnin A Valiant's Field Training##13765
		only Orc
	step
		goto 76.4,24.6
		.talk Morah Worgsister##33544
		..turnin The Grand Melee##13767
		..turnin At The Enemy's Gates##13856
		only Orc
	// ORC VALIANT RANK DAILY LOOP (END)
	//
	// TROLL VALIANT RANK DAILY LOOP (BEGIN)
	step
		goto 76.0,24.5
		.talk Zul'tore##33372
		.' You will only be able to accept, and turn in, 1 of these 3 daily quests per day:
		..accept A Blade Fit For A Champion##13768 |or
		..accept A Worthy Weapon##13769 |or
		..accept The Edge Of Winter##13770 |or
		only Troll
	step
		goto 76.0,24.6
		.talk Shadow Hunter Mezil-kree##33540
		..accept A Valiant's Field Training##13771
		only Troll
	step
		goto 75.9,24.4
		.talk Gahju##33545
		..accept The Grand Melee##13772
		..accept At The Enemy's Gates##13857
		only Troll
	step
		goto Grizzly Hills,61.2,50.3
		.' Use the Warts-B-Gone Lip Balm|use Warts-B-Gone Lip Balm##44986
		.' Target Lake Frogs
		.' Use the emote /kiss on the Lake Frogs
		.' Repeat this process until one of the Lake Frogs turns into the Maiden of Ashwood Lake
		.talk Maiden of Ashwood Lake##33220
		..' Tell her you are glad to help
		.get Ashwood Brand |q 13768/1
		only Troll
	step
		goto Icecrown,69.1,76.2
		.click Winter Hyacinth##3231
		.collect 4 Winter Hyacinth##45000 |q 13769
		only Troll
	step
		goto Dragonblight,93.2,26.1
		.' Use Winter Hyacinths in the water here|use Winter Hyacinth##45000
		.' Listen to the Maiden of Drak'Mar
		.click Blade of Drak'Mar##8564
		.get Blade of Drak'Mar |q 13769/1
		only Troll
	step
		goto Crystalsong Forest,54.5,74.9
		.from Lord Everblaze##33289
		.collect 1 Everburning Ember##45005 |q 13770
		only Troll
	step
		goto Howling Fjord,42.2,19.7
		.'Use the Everburning Ember on Maiden of Winter's Breath|use Everburning Ember##45005
		.get Winter's Edge |q 13770/1
		only Troll
	step
		goto Icecrown,48.9,71.4
		.' Equip the Horde Lance in your bags|use Horde Lance##46070
		.' Click to mount the Stabled Campaign Warhorse|invehicle |q 13857
		only Troll
	step
		goto 50.1,74.8
		.kill 15 Boneguard Footman##33438|q 13857/1 |tip They are skeletons that walk around this area.  You can simply run over these with your horse, you don't need to target or attack them at all.
		.kill 10 Boneguard Scout##33550 |q 13857/2 |tip They are gargoyles that fly around this area.  Use your Shield-Breaker ability on them, while also using your Defend ability to keep your shield maxed at 3 charges.
		.kill 3 Boneguard Lieutenant##33429 |q 13857/3 |tip They ride horses around this area.  Use your Shield-Breaker ability on then to bring down their shields, then use your Charge ability on them.  Also, keep your shield maxed at 3 by using your Defend ability.  If they get too close, you can also use your Thrust ability to do a good amount of damage, but just remember to keep your shield maxed at 3 charges.
		only Troll
	step
		goto 49.1,71.4
		'Click the red arrow on your vehicle hot bar to stop riding the horse |outvehicle |q 13857
		only Troll
	step
		goto 44.3,54.2
		.kill 10 Converted Hero##32255 |q 13771/1
		only Troll
	step
		goto 75.6,23.8
		.' Equip the Horde Lance in your bags|use Horde Lance##46070
		.' Click to mount the Stabled Darkspear Raptor|invehicle |q 13772
		only Troll
	step
		goto 75.3,26.0
		.' Talk to the riders on mounts of other Horde races
		.' Tell them you are ready to fight!
		.' Fight and defeat them|tip Use your Defend ability to keep your shield maxed at 3 charges, then use your Shield-Breaker to lower the Valiants' shields, then use your Charge ability on them.  If they get close, use your Thrust ability, then use your Charge ability when they run away to get into Charge range.  Just remember to keep your shield maxed at 3 charges.
		.get 3 Mark of the Valiant |q 13772/1
		only Troll
	step
		goto 76.0,24.5
		.talk Zul'tore##33372
		.' You will only be able to accept, and turn in, 1 of these 3 daily quests per day:
		..turnin A Blade Fit For A Champion##13768
		..turnin A Worthy Weapon##13769
		..turnin The Edge Of Winter##13770
		only Troll
	step
		goto 76.0,24.6
		.talk Shadow Hunter Mezil-kree##33540
		..turnin A Valiant's Field Training##13771
		only Troll
	step
		goto 75.9,24.4
		.talk Gahju##33545
		..turnin The Grand Melee##13772
		..turnin At The Enemy's Gates##13857
		only Troll
	// TROLL VALIANT RANK DAILY LOOP (END)
	//
	// TAUREN VALIANT RANK DAILY LOOP (BEGIN)
	step
		goto 76.2,24.6
		.talk Runok Wildmane##33403
		.' You will only be able to accept, and turn in, 1 of these 3 daily quests per day:
		..accept A Blade Fit For A Champion##13773 |or
		..accept A Worthy Weapon##13774 |or
		..accept The Edge Of Winter##13775 |or
		only Tauren
	step
		goto 76.3,24.7
		.talk Dern Ragetotem##33539
		..accept A Valiant's Field Training##13776
		only Tauren
	step
		goto 76.1,24.6
		.talk Anka Clawhoof##33549
		..accept The Grand Melee##13777
		..accept At The Enemy's Gates##13858
		only Tauren
	step
		goto Grizzly Hills,61.2,50.3
		.' Use the Warts-B-Gone Lip Balm|use Warts-B-Gone Lip Balm##44986
		.' Target Lake Frogs
		.' Use the emote /kiss on the Lake Frogs
		.' Repeat this process until one of the Lake Frogs turns into the Maiden of Ashwood Lake
		.talk Maiden of Ashwood Lake##33220
		..' Tell her you are glad to help
		.get Ashwood Brand |q 13773/1
		only Tauren
	step
		goto Icecrown,69.1,76.2
		.click Winter Hyacinth##3231
		.collect 4 Winter Hyacinth##45000 |q 13774
		only Tauren
	step
		goto Dragonblight,93.2,26.1
		.' Use Winter Hyacinths in the water here|use Winter Hyacinth##45000
		.' Listen to the Maiden of Drak'Mar
		.click Blade of Drak'Mar##8564
		.get Blade of Drak'Mar |q 13774/1
		only Tauren
	step
		goto Crystalsong Forest,54.5,74.9
		.from Lord Everblaze##33289
		.collect 1 Everburning Ember##45005 |q 13775
		only Tauren
	step
		goto Howling Fjord,42.2,19.7
		.'Use the Everburning Ember on Maiden of Winter's Breath|use Everburning Ember##45005
		.get Winter's Edge |q 13775/1
		only Tauren
	step
		goto Icecrown,48.9,71.4
		.' Equip the Horde Lance in your bags|use Horde Lance##46070
		.' Click to mount the Stabled Campaign Warhorse|invehicle |q 13858
		only Tauren
	step
		goto 50.1,74.8
		.kill 15 Boneguard Footman##33438 |q 13858/1 |tip They are skeletons that walk around this area.  You can simply run over these with your horse, you don't need to target or attack them at all.
		.kill 10 Boneguard Scout##33550 |q 13858/2 |tip They are gargoyles that fly around this area.  Use your Shield-Breaker ability on them, while also using your Defend ability to keep your shield maxed at 3 charges.
		.kill 3 Boneguard Lieutenant##33429 |q 13858/3 |tip They ride horses around this area.  Use your Shield-Breaker ability on then to bring down their shields, then use your Charge ability on them.  Also, keep your shield maxed at 3 by using your Defend ability.  If they get too close, you can also use your Thrust ability to do a good amount of damage, but just remember to keep your shield maxed at 3 charges.
		only Tauren
	step
		goto 49.1,71.4
		'Click the red arrow on your vehicle hot bar to stop riding the horse |outvehicle |q 13858
		only Tauren
	step
		goto 44.3,54.2
		.kill 10 Converted Hero##32255 |q 13776/1
		only Tauren
	step
		goto 75.5,24.3
		.' Equip the Horde Lance in your bags|use Horde Lance##46070
		.' Click to mount the Stabled Thunder Bluff Kodo|invehicle |q 13777
		only Tauren
	step
		goto 75.3,26.0
		.' Talk to the riders on mounts of other Horde races
		.' Tell them you are ready to fight!
		.' Fight and defeat them|tip Use your Defend ability to keep your shield maxed at 3 charges, then use your Shield-Breaker to lower the Valiants' shields, then use your Charge ability on them.  If they get close, use your Thrust ability, then use your Charge ability when they run away to get into Charge range.  Just remember to keep your shield maxed at 3 charges.
		.get 3 Mark of the Valiant |q 13777/1
		only Tauren
	step
		goto 76.2,24.6
		.talk Runok Wildmane##33403
		.' You will only be able to accept, and turn in, 1 of these 3 daily quests per day:
		..turnin A Blade Fit For A Champion##13773
		..turnin A Worthy Weapon##13774
		..turnin The Edge Of Winter##13775
		only Tauren
	step
		goto 76.3,24.7
		.talk Dern Ragetotem##33539
		..turnin A Valiant's Field Training##13776
		only Tauren
	step
		goto 76.1,24.6
		.talk Anka Clawhoof##33549
		..turnin The Grand Melee##13777
		..turnin At The Enemy's Gates##13858
		only Tauren
	// TAUREN VALIANT RANK DAILY LOOP (END)
	//
	// SCOURGE VALIANT RANK DAILY LOOP (BEGIN)
	step
		goto 76.5,24.2
		.talk Deathstalker Visceri##33373
		.' You will only be able to accept, and turn in, 1 of these 3 daily quests per day:
		..accept A Blade Fit For A Champion##13778 |or
		..accept A Worthy Weapon##13779 |or
		..accept The Edge Of Winter##13780 |or
		only Scourge
	step
		goto 76.6,24.1
		.talk Sarah Chalke##33541
		..accept A Valiant's Field Training##13781
		only Scourge
	step
		goto 76.5,24.3
		.talk Handler Dretch##33547
		..accept The Grand Melee##13782
		..accept At The Enemy's Gates##13860
		only Scourge
	step
		goto Grizzly Hills,61.2,50.3
		.' Use the Warts-B-Gone Lip Balm|use Warts-B-Gone Lip Balm##44986
		.' Target Lake Frogs
		.' Use the emote /kiss on the Lake Frogs
		.' Repeat this process until one of the Lake Frogs turns into the Maiden of Ashwood Lake
		.talk Maiden of Ashwood Lake##33220
		..' Tell her you're glad to help
		.get Ashwood Brand |q 13778/1
		only Scourge
	step
		goto Icecrown,69.1,76.2
		.click Winter Hyacinth##3231
		.collect 4 Winter Hyacinth##45000 |q 13779
		only Scourge
	step
		goto Dragonblight,93.2,26.1
		.' Use Winter Hyacinths in the water here|use Winter Hyacinth##45000
		.' Listen to the Maiden of Drak'Mar
		.click Blade of Drak'Mar##8564
		.get Blade of Drak'Mar |q 13779/1
		only Scourge
	step
		goto Crystalsong Forest,54.5,74.9
		.from Lord Everblaze##33289
		.collect 1 Everburning Ember##45005 |q 13780
		only Scourge
	step
		goto Howling Fjord,42.2,19.7
		.'Use the Everburning Ember on Maiden of Winter's Breath|use Everburning Ember##45005
		.get Winter's Edge |q 13780/1
		only Scourge
	step
		goto Icecrown,48.9,71.4
		.' Equip the Horde Lance in your bags|use Horde Lance##46070
		.' Click to mount the Stabled Campaign Warhorse|invehicle |q 13860
		only Scourge
	step
		goto 50.1,74.8
		.kill 15 Boneguard Footman##33438|q 13860/1 |tip They are skeletons that walk around this area.  You can simply run over these with your horse, you don't need to target or attack them at all.
		.kill 10 Boneguard Scout##33550 |q 13860/2 |tip They are gargoyles that fly around this area.  Use your Shield-Breaker ability on them, while also using your Defend ability to keep your shield maxed at 3 charges.
		.kill 3 Boneguard Lieutenant##33429 |q 13860/3 |tip They ride horses around this area.  Use your Shield-Breaker ability on then to bring down their shields, then use your Charge ability on them.  Also, keep your shield maxed at 3 by using your Defend ability.  If they get too close, you can also use your Thrust ability to do a good amount of damage, but just remember to keep your shield maxed at 3 charges.
		only Scourge
	step
		goto 49.1,71.4
		'Click the red arrow on your vehicle hot bar to stop riding the horse |outvehicle |q 13860
		only Scourge
	step
		goto 44.3,54.2
		.kill 10 Converted Hero##32255 |q 13781/1
		only Scourge
	step
		goto 75.6,23.9
		.' Equip the Horde Lance in your bags|use Horde Lance##46070
		.' Click to mount the Stabled Forsaken Warhorse|invehicle |q 13782
		only Scourge
	step
		goto 75.3,26.0
		.' Talk to the riders on mounts of other Horde races
		.' Tell them you are ready to fight!
		.' Fight and defeat them|tip Use your Defend ability to keep your shield maxed at 3 charges, then use your Shield-Breaker to lower the Valiants' shields, then use your Charge ability on them.  If they get close, use your Thrust ability, then use your Charge ability when they run away to get into Charge range.  Just remember to keep your shield maxed at 3 charges.
		.get 3 Mark of the Valiant |q 13782/1
		only Scourge
	step
		goto 76.5,24.2
		.talk Deathstalker Visceri##33373
		.' You will only be able to accept, and turn in, 1 of these 3 daily quests per day:
		..turnin A Blade Fit For A Champion##13778
		..turnin A Worthy Weapon##13779
		..turnin The Edge Of Winter##13780
		only Scourge
	step
		goto 76.6,24.1
		.talk Sarah Chalke##33541
		..turnin A Valiant's Field Training##13781
		only Scourge
	step
		goto 76.5,24.3
		.talk Handler Dretch##33547
		..turnin The Grand Melee##13782
		..turnin At The Enemy's Gates##13860
		only Scourge
	// SCOURGE VALIANT RANK DAILY LOOP (END)
	//
	// BLOOD ELF VALIANT RANK DAILY LOOP (BEGIN)
	step
		goto 76.5,23.9
		.talk Eressea Dawnsinger##33379
		.' You will only be able to accept, and turn in, 1 of these 3 daily quests per day:
		..accept A Blade Fit For A Champion##13783 |or
		..accept A Worthy Weapon##13784 |or
		..accept The Edge Of Winter##13785 |or
		only BloodElf
	step
		goto 76.4,23.8
		.talk Kethiel Sunlance##33538
		..accept A Valiant's Field Training##13786
		only BloodElf
	step
		goto 76.5,23.9
		.talk Aneera Thuron##33548
		..accept The Grand Melee##13787
		..accept At The Enemy's Gates##13859
		only BloodElf
	step
		goto Grizzly Hills,61.2,50.3
		.' Use the Warts-B-Gone Lip Balm|use Warts-B-Gone Lip Balm##44986
		.' Target Lake Frogs
		.' Use the emote /kiss on the Lake Frogs
		.' Repeat this process until one of the Lake Frogs turns into the Maiden of Ashwood Lake
		.talk Maiden of Ashwood Lake##33220
		..' Tell her you are glad to help
		.get Ashwood Brand |q 13783/1
		only BloodElf
	step
		goto Icecrown,69.1,76.2
		.click Winter Hyacinth##3231
		.collect 4 Winter Hyacinth##45000 |q 13784
		only BloodElf
	step
		goto Dragonblight,93.2,26.1
		.' Use Winter Hyacinths in the water here|use Winter Hyacinth##45000
		.' Listen to the Maiden of Drak'Mar
		.click Blade of Drak'Mar##8564
		.get Blade of Drak'Mar |q 13784/1
		only BloodElf
	step
		goto Crystalsong Forest,54.5,74.9
		.from Lord Everblaze##33289
		.collect 1 Everburning Ember##45005 |q 13785
		only BloodElf
	step
		goto Howling Fjord,42.2,19.7
		.'Use the Everburning Ember on Maiden of Winter's Breath|use Everburning Ember##45005
		.get Winter's Edge |q 13785/1
		only BloodElf
	step
		goto Icecrown,48.9,71.4
		.' Equip the Horde Lance in your bags|use Horde Lance##46070
		.' Click to mount the Stabled Campaign Warhorse|invehicle |q 13859
		only BloodElf
	step
		goto 50.1,74.8
		.kill 15 Boneguard Footman##33438|q 13859/1 |tip They are skeletons that walk around this area.  You can simply run over these with your horse, you don't need to target or attack them at all.
		.kill 10 Boneguard Scout##33550 |q 13859/2 |tip They are gargoyles that fly around this area.  Use your Shield-Breaker ability on them, while also using your Defend ability to keep your shield maxed at 3 charges.
		.kill 3 Boneguard Lieutenant##33429 |q 13859/3 |tip They ride horses around this area.  Use your Shield-Breaker ability on then to bring down their shields, then use your Charge ability on them.  Also, keep your shield maxed at 3 by using your Defend ability.  If they get too close, you can also use your Thrust ability to do a good amount of damage, but just remember to keep your shield maxed at 3 charges.
		only BloodElf
	step
		goto 49.1,71.4
		'Click the red arrow on your vehicle hot bar to stop riding the horse |outvehicle |q 13859
		only BloodElf
	step
		goto 44.3,54.2
		.kill 10 Converted Hero##32255 |q 13786/1
		only BloodElf
	step
		goto 75.5,24.1
		.' Equip the Horde Lance in your bags|use Horde Lance##46070
		.' Click to mount the Stabled Silvermoon Hawkstrider|invehicle |q 13787
		only BloodElf
	step
		goto 75.3,26.0
		.' Talk to the riders on mounts of other Horde races
		.' Tell them you are ready to fight!
		.' Fight and defeat them|tip Use your Defend ability to keep your shield maxed at 3 charges, then use your Shield-Breaker to lower the Valiants' shields, then use your Charge ability on them.  If they get close, use your Thrust ability, then use your Charge ability when they run away to get into Charge range.  Just remember to keep your shield maxed at 3 charges.
		.get 3 Mark of the Valiant |q 13787/1
		only BloodElf
	step
		goto 76.5,23.9
		.talk Eressea Dawnsinger##33379
		.' You will only be able to accept, and turn in, 1 of these 3 daily quests per day:
		..turnin A Blade Fit For A Champion##13783
		..turnin A Worthy Weapon##13784
		..turnin The Edge Of Winter##13785
		only BloodElf
	step
		goto 76.4,23.8
		.talk Kethiel Sunlance##33538
		..turnin A Valiant's Field Training##13786
		only BloodElf
	step
		goto 76.5,23.9
		.talk Aneera Thuron##33548
		..turnin The Grand Melee##13787
		..turnin At The Enemy's Gates##13859
		only BloodElf
	// BLOOF ELF VALIANT RANK DAILY LOOP (END)
	step
		'Make sure you have 25 Valiant Seals:
		.get 25 Valiant's Seal |q 13697/1 |tip If you do not have 25 Valiant's Seals, keep repeating the daily quests in this guide section.  It takes 5 days of doing these Valiant Rank dailies to get 25 Valiant's Seals. |only Orc
		.get 25 Valiant's Seal |q 13719/1 |tip If you do not have 25 Valiant's Seals, keep repeating the daily quests in this guide section.  It takes 5 days of doing these Valiant Rank dailies to get 25 Valiant's Seals. |only Troll
		.get 25 Valiant's Seal |q 13720/1 |tip If you do not have 25 Valiant's Seals, keep repeating the daily quests in this guide section.  It takes 5 days of doing these Valiant Rank dailies to get 25 Valiant's Seals. |only Tauren
		.get 25 Valiant's Seal |q 13721/1 |tip If you do not have 25 Valiant's Seals, keep repeating the daily quests in this guide section.  It takes 5 days of doing these Valiant Rank dailies to get 25 Valiant's Seals. |only Scourge
		.get 25 Valiant's Seal |q 13722/1 |tip If you do not have 25 Valiant's Seals, keep repeating the daily quests in this guide section.  It takes 5 days of doing these Valiant Rank dailies to get 25 Valiant's Seals. |only BloodElf
	step
		goto 76.5,24.6
		.talk Mokra the Skullcrusher##33361
		..turnin The Valiant's Charge##13697
		..accept The Valiant's Challenge##13726
		only Orc
	step
		goto 76.0,24.5
		.talk Zul'tore##33372
		..turnin The Valiant's Charge##13719
		..accept The Valiant's Challenge##13727
		only Troll
	step
		goto 76.2,24.6
		.talk Runok Wildmane##33403
		..turnin The Valiant's Charge##13720
		..accept The Valiant's Challenge##13728
		only Tauren
	step
		goto 76.5,24.2
		.talk Deathstalker Visceri##33373
		..turnin The Valiant's Charge##13721
		..accept The Valiant's Challenge##13729
		only Scourge
	step
		goto 76.5,23.9
		.talk Eressea Dawnsinger##33379
		..turnin The Valiant's Charge##13722
		..accept The Valiant's Challenge##13731
		only BloodElf
	step
		goto 72.2,22.5
		.' Equip the Horde Lance in your bags|use Horde Lance##46070
		.' Click to mount the Stabled Orgrimmar Wolf|invehicle |q 13726
		only Orc
	step
		goto 72.0,22.5
		.' Equip the Horde Lance in your bags|use Horde Lance##46070
		.' Click to mount the Stabled Darkspear Raptor|invehicle |q 13727
		only Troll
	step
		goto 71.9,22.4
		.' Equip the Horde Lance in your bags|use Horde Lance##46070
		.' Click to mount the Stabled Thunder Bluff Kodo|invehicle |q 13728
		only Tauren
	step
		goto 72.1,22.4
		.' Equip the Horde Lance in your bags|use Horde Lance##46070
		.' Click to mount the Stabled Forsaken Warhorse|invehicle |q 13729
		only Scourge
	step
		goto 72.2,22.4
		.' Equip the Horde Lance in your bags|use Horde Lance##46070
		.' Click to mount the Stabled Silvermoon Hawkstrider|invehicle |q 13731
		only BloodElf
	step
		goto 68.6,21.0
		.talk Squire Danny##33518
		..' Tell him you are ready to fight!
		.'An Argent Champion runs up on a horse
		.' Use the abilities on your hotbar to defeat the Argent Champion|tip The best strategy to defeat the Argent Champion is to always make sure your shield is up by using your Defend ability.  Make sure your shield is stacked to 3 charges before you begin the fight.  When the fight begins, immediately use your Charge ability on the Argent Champion.  Stay in very close range and spam your Thrust ability.  Remember to keep your shield maxed at 3 charges, also.  Eventually, the Argent Champion will try to run away to get into Charge range.  When he starts to run away, start spamming your Charge ability until you charge him in the back, then get back into melee range and start spamming your Thrust ability again.  Keep repeating this process until he is defeated.
		.' Defeat the Argent Valiant |q 13726/1 |only Orc
		.' Defeat the Argent Valiant |q 13727/1 |only Troll
		.' Defeat the Argent Valiant |q 13728/1 |only Tauren
		.' Defeat the Argent Valiant |q 13729/1 |only Scourge
		.' Defeat the Argent Valiant |q 13731/1 |only BloodElf
	step
		goto 76.5,24.6
		.talk Mokra the Skullcrusher##33361
		..turnin The Valiant's Challenge##13726
		..accept A Champion Rises##13736
		only Orc
	step
		goto 76.0,24.5
		.talk Zul'tore##33372
		..turnin The Valiant's Challenge##13727
		..accept A Champion Rises##13737
		only Troll
	step
		goto 76.2,24.6
		.talk Runok Wildmane##33403
		..turnin The Valiant's Challenge##13728
		..accept A Champion Rises##13738
		only Tauren
	step
		goto 76.5,24.2
		.talk Deathstalker Visceri##33373
		..turnin The Valiant's Challenge##13729
		..accept A Champion Rises##13739
		only Scourge
	step
		goto 76.5,23.9
		.talk Eressea Dawnsinger##33379
		..turnin The Valiant's Challenge##13731
		..accept A Champion Rises##13740
		only BloodElf
	step
		goto 69.7,22.9
		.talk Justicar Mariel Trueheart##33817
		..turnin A Champion Rises##13736 |only Orc
		..turnin A Champion Rises##13737 |only Troll
		..turnin A Champion Rises##13738 |only Tauren
		..turnin A Champion Rises##13739 |only Scourge
		..turnin A Champion Rises##13740 |only BloodElf
		..accept The Scourgebane##13795 |only DeathKnight
		..accept Eadric the Pure##13794 |only !DeathKnight
	step
		goto 73.8,20.1
		.talk Crok Scourgebane##33762
		..turnin The Scourgebane##13795
		only DeathKnight
	step
		goto 70.0,23.4
		.talk Eadric the Pure##33759
		..turnin Eadric the Pure##13794
		only !DeathKnight
]])

ZygorGuidesViewer:RegisterInclude("H_Eastern_Plaguelands_Argent_Dawn",[[
	step
		goto Eastern Plaguelands,9.0,66.5
		.talk Fiona##45417
		..turnin Into the Woods##27683 |only if havequest(27683)
		..accept Gidwin Goldbraids##27367
		..accept Tarenar Sunstrike##27370
	step
		goto 4.1,36.0
		.talk Gidwin Goldbraids##45428
		..turnin Gidwin Goldbraids##27367
		..accept Just Encased##27368
	step
		goto 4.7,35.6 |n
		.' Enter the tunnel |goto 4.7,35.6,0.5 |noway |c
	step
		goto 5.1,33.4
		.from Crypt Stalker##8555+,Crypt Horror##8557+, Crypt Walker##8556+, Crypt Slayer##8558+ |tip All inside this tunnel.
		.get 8 Crypt Bile |q 27368/1
	step
		goto 4.7,35.6 |n
		.' Leave the tunnel |goto 4.7,35.6,0.5 |noway |c
	step
		goto Eastern Plaguelands,4.1,36.0
		.talk Gidwin Goldbraids##45428
		..turnin Just Encased##27368
		..accept Greasing the Wheel##27369
	step
		goto 3.4,38.0
		.click Banshee's Bell##9889+ |tip They are located right along the edge of the water
		.get 10 Banshee's Bells |q 27369/1
	step
		goto 9.0,66.5
		.talk Fiona##45417
		..turnin Greasing the Wheel##27369
	step
		goto 18.4,74.8
		.talk Tarenar Sunstrike##45429
		..turnin Tarenar Sunstrike##27370
		..accept What I Do Best##27371
	step
		goto 18.6,76.9
		.kill 5 Death's Step Miscreation##45444+ |q 27371/1
		.' Click the Quest Complete box that displays on the right side of the screen under your minimap
		..turnin What I Do Best##27371
		..accept A Gift For Fiona##27372
	step
		goto 17.2,68.7
		.from Plaguehound Runt##8596+ |tip They share spawn locations with the Carrion Grubs.  So, if you are having trouble finding Plaguehound Runts, kill Carrion Grubs and more should spawn.
		.get 10 Plaguehound Blood |q 27372/1
		.' You can find more Plague Hound Runts around [Eastern Plaguelands,14.4,63.0].
	step
		goto 9.0,66.5
		.talk Fiona##45417
		..turnin A Gift For Fiona##27372
		..accept Onward, to Light's Hope Chapel##27373
	step
		goto 8.8,66.6
		.clicknpc Captain Redpath##10937
		..' Choose 1 of the 3 buffs you can choose from |tip All of the buffs only work while you're in Eastern Plaguelands.  Fiona's Lucky Charm gives you a chance to loot extra gold or items from enemies.  Gidwin's Weapon Oil gives you a chance to do extra Holy damage on melee and ranged attacks.  Tarenar's Talisman gives you a chance to do extra Holy damage on successful spell attacks.
		.' Click here to proceed. |confirm
	step
		goto 8.8,66.6
		.clicknpc Fiona's Caravan##45400
		..' Choose to go to the next destination
		.' Ride Fiona's Caravan |q 27373/1
	step
		goto 34.9,67.9
		.talk Janice Myers##44232
		.fpath Crown Guard Tower
	step
		goto 35.0,68.1
		.talk Urk Gagbaz##45500
		..accept Zaeldarr the Outcast##27432
	step
		goto 34.9,69.1
		.talk Fiona##45417
		..turnin Onward, to Light's Hope Chapel##27373
	step
		goto 35.3,68.8
		.talk Tarenar Sunstrike##45429
		..accept Traveling Companions##27381
	step
		goto 35.6,68.9
		.talk Carlin Redpath##11063
		..accept Little Pamela##27383
	step
		goto 35.9,69.3
		.' Go to the top of the tower
		.talk Argus Highbeacon##45451
		..' Ask him if he's interested in joining your caravan
		.' Find a traveling companion |q 27381/1
	step
		goto 35.9,69.3
		.talk Argus Highbeacon##45451
		..accept Rough Roads##27382
	step
		goto 35.3,68.9
		.talk Tarenar Sunstrike##45429
		..turnin Traveling Companions##27381
	step
		goto 32.4,83.7
		.talk Pamela Redpath##10926
		..turnin Little Pamela##27383
		..accept Pamela's Doll##27384
		..accept I'm Not Supposed to Tell You This##27392
	step
		goto 35.5,85.3
		.' You can find the doll parts in all of the buildings
		.click Pamela's Doll's Right Side##4233
		.collect Pamela's Doll's Right Side##12888 |q 27384
		.click Pamela's Doll's Left Side##4232
		.collect Pamela's Doll's Left Side##12887 |q 27384
		.click Pamela's Doll's Head##4231
		.collect Pamela's Doll's Head##12886 |q 27384
	step
		'Use Pamela's Doll's Head |use Pamela's Doll's Head##12886
		.get Pamela's Doll |q 27384/1
	step
		goto 40.3,83.8
		.from The Lone Hunter##45450
		.get Joseph's Hunting Blade |q 27392/1
	step
		goto 32.4,83.7
		.talk Pamela Redpath##10926
		..turnin Pamela's Doll##27384
		..turnin I'm Not Supposed to Tell You This##27392
		..accept Uncle Carlin##27385
	step
		ding 40
	step
		goto 35.6,68.9
		.talk Carlin Redpath##11063
		..turnin Uncle Carlin##27385
		..accept A Strange Historian##27386
	step
		goto 35.3,68.0
		.talk Chromie##10667
		..turnin A Strange Historian##27386
		..accept Villains of Darrowshire##27387
		..accept Heroes of Darrowshire##27388
		..accept Marauders of Darrowshire##27389
	step
		goto 35.0,68.1
		.talk Urk Gagbaz##45500
		..accept Cenarion Tenacity##27544
	step
		goto 35.6,68.9
		.talk Carlin Redpath##11063
		..' Ask him if he has the extended Annals of Darrowshire
		.get Extended Annals of Darrowshire |q 27388/1
	step
		goto 39.8,72.4
		.click Shattered Sword of Marduk##4175
		.get Shattered Sword of Marduk |q 27387/2
	step
		goto 39.6,72.1
		.kill 13 Plaguebat##8600+ |q 27382/1
	step
		goto 35.6,68.7
		.' Go to the top of the tower
		.talk Argus Highbeacon##45451
		..turnin Rough Roads##27382
	step
		goto 24.2,78.5 |n
		.' Enter the crypt |goto 24.2,78.5,0.5 |noway |c
	step
		goto 23.8,77.9
		.' Go to the bottom of the crypt
		.from Zaeldarr the Outcast##12250
		.get Zaeldarr's Head |q 27432/1
	step
		goto 22.1,68.2
		.click Redpath's Shield##4172
		.get Redpath's Shield |q 27388/3
	step
		goto 22.3,68.3
		.' Go upstairs
		.click Davil's Libram##430
		.get Davil's Libram |q 27388/2
	step
		goto 35.0,68.2
		.talk Urk Gagbaz##45500
		..turnin Zaeldarr the Outcast##27432
	step
		goto 35.2,68.1
		.talk Chromie##10667
		..turnin Heroes of Darrowshire##27388
	step
		goto 37.3,60.2
		.click Horgus' Skull##4173
		.get Skull of Horgus |q 27387/1
	step
		goto 30.2,56.9
		.talk Rayne##16135
		..turnin Cenarion Tenacity##27544
		..accept Postponing the Inevitable##27420
		..accept Amidst Death, Life##27421
	step
		goto 33.7,44.4
		.' Go inside the necropolis
		.' Use Rayne's Seeds while standing on the platform above the green liquid |use Rayne's Seeds##61036
		.' Plant a Seed in the Western Necropolis |q 27421/2
	step
		goto 37.8,42.5
		.' Go inside the necropolis
		.' Use Rayne's Seeds while standing on the platform above the green liquid |use Rayne's Seeds##61036
		.' Plant a Seed in the Northeastern Necropolis |q 27421/3
	step
		goto 37.6,48.3
		.' Go inside the necropolis
		.' Use Rayne's Seeds while standing on the platform above the green liquid |use Rayne's Seeds##61036
		.' Plant a Seed in the Southeastern Necropolis |q 27421/1
	step
		goto 36.4,46.0
		.from Scourge Champion##8529+
		.collect Fetid Skull##13157 |n
		.' Use your Mystic Crystal when you have a Fetid Skull |use Mystic Crystal##13156
		.get 5 Resonating Skull |q 27389/1
		.from Shadowmage##8550+, Dark Adept##8546+
		.collect Plague Disseminator Control Rune##61037 |n
		.' Use your Overcharged Mote when you have a Plague Disseminator Control Rune |use Overcharged Mote##61038
		.' Destroy 3 Plague Disseminators |q 27420/1
	step
		goto 30.2,56.9
		.talk Rayne##16135
		..turnin Postponing the Inevitable##27420
		..turnin Amidst Death, Life##27421
	step
		goto 35.3,68.1
		.talk Chromie##10667
		..turnin Villains of Darrowshire##27387
		..turnin Marauders of Darrowshire##27389
		..accept The Battle of Darrowshire##27390
	step
		goto 35.1,84.0
		.' Use your Relic Bundle |use Relic Bundle##15209
		.' Fight in the battle and follow the instructions that appear on your screen
		.from Redpath the Corrupted##10938
		.' Joseph Redpath will appear after the battle at [Eastern Plaguelands,35.1,84.0]
		.talk Joseph Redpath##10936
		.' Accept Redpath's Forgiveness |q 27390/1
	step
		goto 32.4,83.7
		.talk Pamela Redpath##10926
		..turnin The Battle of Darrowshire##27390
		..accept Hidden Treasures##27391
	step
		goto 32.2,83.4
		.click Joseph's Chest##318
		..turnin Hidden Treasures##27391
	step
		goto 34.9,69.2
		.talk Fiona##45417
		..accept The Trek Continues##27448
	step
		goto 35.0,69.3
		.clicknpc Fiona's Caravan##45400
		..' Choose to go to the next destination
		.' Ride in Fiona's Caravan |q 27448/1
	step
		goto 52.9,53.1
		.talk Fiona##45417
		..turnin The Trek Continues##27448
		..accept Boys Will Be Boys##27455
	step
		goto 53.0,53.1
		.clicknpc Fiona's Caravan##45400
		.' Complete the Argus' Journal quest |tip This will give you a 2% experience bonus while in Eastern Plaguelands, so will allow you to level faster.  // %
		|confirm
	step
		goto 53.2,54.6
		.talk Betina Bigglezink##11035
		..accept To Kill With Purpose##27451
		..accept Dark Garb##27452
	step
		goto 53.8,54.0
		.' Go to the top of the tower
		.talk Frederick Calston##45575
		..accept Frederick's Fish Fancy##27450
	step
		goto 52.8,51.4
		.talk Vex'tul##45574
		..accept Honor and Strength##27449
		.kill 3 Mossflayer Rogue##45579+ |q 27449/1
	step
		goto 52.8,51.4
		.talk Vex'tul##45574
		..turnin Honor and Strength##27449
	step
		ding 41
	step
		goto 50.2,61.3
		.clicknpc Plague Puffer##45650+
		.get 8 Plague Puffer |q 27450/1
		.clicknpc Infectis Incher##45655+
		.get 8 Infectis Incher |q 27450/2
		.clicknpc Infectis Scuttler##45657+
		.get 8 Infectis Scuttler |q 27450/3
	step
		goto 53.7,62.3
		.from Unseen Servant##8538+, Stitched Horror##8543+, Hate Shrieker##8541+, Dark Caster##8526+, Scourge Warder##8525+, Gibbering Ghoul##8531+
		.collect 7 Living Rot##15447 |n |tip These only last 10 minutes, so keep an eye on the timer and try to get them as fast as you can.
		.' Use Mortar and Pestle once you have 7 Living Rot |use Mortar and Pestle##15454
		.get Coagulated Rot |q 27451/1
		.' Click the Quest Complete box that displays on the right side of the screen under your minimap
		..turnin To Kill With Purpose##27451
	step
		goto 55.7,61.0
		.from Dark Summoner##8551+, Vile Tutor##8548+
		.get Death Cultist Headwear |q 27452/1
		.get Death Cultist Robes |q 27452/2
		.' Click the Quest Complete box that displays on the right side of the screen under your minimap
		..turnin Dark Garb##27452
		..accept Catalysm##27453
	step
		goto 57.6,72.6
		.' Use Betina's Flasks on Plague Ravagers and Blighted Surges underwater |use Betina's Flasks##61284
		.get 8 Active Liquid Plague Agent |q 27453/1
		.' Click the Quest Complete box that displays on the right side of the screen under your minimap
		..turnin Catalysm##27453
		..accept Just a Drop in the Bucket##27454
	step
		goto 61.7,75.5
		.' Use your Death Cultist Disguise |use Death Cultist Disguise##61283
		.' Wear your Death Cultist Disguise |havebuff INTERFACE\ICONS\inv_helmet_152 |q 27454
	step
		goto 62.4,76.4
		.click Mereldar Plague Cauldron##4331
		..' Choose to throw in an entire flask
		.' Disturb the Mereldar Plague Cauldron |q 27454/1
	step
		goto 53.2,54.6
		.talk Betina Bigglezink##11035
		..turnin Just a Drop in the Bucket##27454
	step
		goto 53.8,54.0
		.' Go to the top of the tower
		.talk Frederick Calston##45575
		..turnin Frederick's Fish Fancy##27450
	step
		goto 74.4,53.3
		.talk Gidwin Goldbraids##45431
		..turnin Boys Will Be Boys##27455
		..accept A Boyhood Dream##27463
	step
		goto 73.8,51.9
		.talk Rimblat Earthshatter##16134
		..accept Gathering Some Grub(s)##27456
	step
		goto 74.9,53.5
		.talk Smokey LaRue##11033
		..accept Smokey and the Bandage##27458
	step
		goto 75.6,52.4
		.talk Jessica Chambers##16256
		.home Light's Hope Chapel
	step
		goto 75.6,52.0
		.talk Leonid Barthalomew the Revered##11036
		..accept The Brotherhood of Light##27459
	step
		goto 75.9,52.0
		.talk Lord Maxwell Tyrosus##11034
		..turnin A Boyhood Dream##27463
		..accept Argent Call: The Trial of the Crypt##27464
	step
		goto 77.2,50.8 |n
		.' Enter the crypt |goto 77.2,50.8,0.5 |noway |c
	step
		goto 77.2,51.4
		.' Go to the bottom of the crypt
		.' Use your Argent Scroll |use Argent Scroll##61309
		.from Argent Warden##45698+
		.from Lord Raymond George##45707
		.' Complete the Trial of the Crypt |q 27464/1
	step
		goto 75.9,52.0
		.talk Lord Maxwell Tyrosus##11034
		..turnin Argent Call: The Trial of the Crypt##27464
		..accept Argent Call: The Noxious Glade##27465
	step
		goto 75.7,52.0
		.talk Master Craftsman Omarion##16365
		..accept Buried Blades##27467
	step
		goto 71.9,45.4
		.from Stephen Browman##46167
		.get Browman's Wrappings |q 27458/1
	step
		goto 72.1,41.6 |n
		.' Run up this path |goto 72.1,41.6,0.5 |noway |c
	step
		goto 77.4,37.3
		.kill 16 Noxious Glade Scourge |q 27465/1
		.kill 8 Noxious Glade Cultists |q 27465/2
		.clicknpc Slain Scourge Trooper##45695+
		.' Bury 10 Blades |q 27467/1
		' |from Diseased Flayer##8532+, Dread Weaver##8528+, Death Singer##8542+
		' |from Skullmage##45691+, Noxious Assassin##45692+
		|tip Be careful of the patrolling elite, Garginox, in this area.
		|modelnpc Garginox##45681
	step
		goto 75.7,52.0
		.talk Master Craftsman Omarion##16365
		..turnin Buried Blades##27467
	step
		goto 75.9,52.0
		.talk Lord Maxwell Tyrosus##11034
		..turnin Argent Call: The Noxious Glade##27465
	step
		goto 74.9,53.5
		.talk Smokey LaRue##11033
		..turnin Smokey and the Bandage##27458
	step
		goto 71.1,60.6
		.from Carrion Grub##8603+, Carrion Devourer##8605+
		.get 15 Slab of Carrion Worm Meat |q 27456/1
	step
		goto 72.6,74.8
		.talk Archmage Angela Dosantos##16116
		..turnin The Brotherhood of Light##27459
		..accept Soft Landing##27460
	step
		goto 73.6,74.8
		.kill 10 Tyr's Hand Scarlet Crusader |q 27460/1
		' |from Scarlet Enchanter##9452+, Scarlet Warder##9447+, Scarlet Cleric##9449+
	step
		goto 77.6,79.4
		.click Crusader's Flare##6543
		..turnin Soft Landing##27460
		..accept To Take the Abbey##27461
		..accept To Take the Barracks##27462
	step
		goto 75.3,76.2
		.talk Crusade Commander Korfax##16112
		..turnin To Take the Barracks##27462
		..accept Scarlet Salvage##27614
		..accept The Wrathcaster##27615
		..accept The Huntsman##27616
		..accept The Commander##27619
	step
		ding 42
	step
		goto 74.8,76.7
		.click Battered Chest##10
		.get Crimson Boar |q 27614/1
	step
		goto 74.2,78.3
		.click Battered Chest##10
		.get Lihanna's Strand |q 27614/2
	step
		goto 75.1,79.0
		.click Battered Chest##10
		.get Shroud of Uther |q 27614/3
	step
		goto 75.9,77.5
		.click Battered Chest##10
		.get Gavinrad's Sigil |q 27614/4
	step
		goto 75.0,78.3
		.' Go into the basement of the fortress
		.kill Mataus the Wrathcaster##46093 |q 27615/1
	step
		goto 74.9,78.3
		.' Go upstairs into the main room of the fortress
		.kill Scarlet Commander Marjhan##46092 |q 27619/1
	step
		goto 74.5,77.5
		.' Go down the hall and up more stairs
		.kill Huntsman Leopold##46094 |q 27616/1
	step
		goto 75.3,76.2
		.talk Crusade Commander Korfax##16112
		..turnin Scarlet Salvage##27614
		..turnin The Wrathcaster##27615
		..turnin The Huntsman##27616
		..turnin The Commander##27619
		..accept Argent Upheaval##27618
	step
		goto 76.1,75.3
		.talk Archmage Angela Dosantos##16116
		..turnin Argent Upheaval##27618
	step
		goto 76.7,73.1
		.talk Crusade Commander Eligor Dawnbringer##16115
		..turnin To Take the Abbey##27461
		..accept Victory From Within##27612
		..accept The Assassin##27613
	step
		goto 77.8,71.0
		.' Click the Argent Portal |tip It looks like a swirling portal in a room on the north side of the building.  Follow the stairs up in the Library Wing, not the big spiral stairs in the middle of the building.
		.' Open the Portal within the Library Wing |q 27612/2
	step
		goto 78.6,72.9
		.' Click the Argent Portal |tip It looks like a swirling portal in a room on the west side of the building.
		.' Open the Portal within the Hall of Arms |q 27612/1
	step
		goto 77.6,72.7
		.' Follow the big spiral stairs up to the top of the bell tower
		.kill Rohan the Assassin##46095 |q 27613/1
	step
		goto 76.7,73.1
		.talk Crusade Commander Eligor Dawnbringer##16115
		..turnin Victory From Within##27612
		..turnin The Assassin##27613
		..accept Befouled No More##27617
	step
		goto 76.1,75.3
		.talk Archmage Angela Dosantos##16116
		..turnin Befouled No More##27617
		..accept Like Rats##27620
	step
		goto 82.3,79.4
		.kill Crusader Lord Valdelmar##46096 |q 27620/1
	step
		goto 75.6,52.0
		.talk Leonid Barthalomew the Revered##11036
		..turnin Like Rats##27620
	step
		 goto Eastern Plaguelands,75.8,52.4
		.talk Tarenar Sunstrike##45729
		..accept Argent Call: Northdale##27466
	step
		goto 73.8,51.9
		.talk Rimblat Earthshatter##16134
		..turnin Gathering Some Grub(s)##27456
		..accept An Opportune Alliance##27457
	step
		goto 61.8,41.0
		.talk Vex'tul##45574
		..accept Out of the Ziggurat##27481
	step
		goto 61.0,43.7
		.talk Deacon Andaal##45736
		..accept Righteous Indignation##27479
	step
		goto 61.6,43.1
		.talk Gamella Cracklefizz##45735
		..accept The Corpulent One##27477
	step
		goto 61.5,42.7
		.talk Fiona##45417
		..turnin An Opportune Alliance##27457
		..turnin Argent Call: Northdale##27466
	step
		goto 61.6,43.2
		.talk Tarenar Sunstrike##45729
		..accept Ix'lar the Underlord##27487
	step
		goto 61.8,35.7
		.kill Ix'lar the Underlord##45744 |q 27487/1 |tip He's a big purple bug that walks around this area, so you may need to search for him.
		.kill 10 Ix'lar's minion |q 27487/2
		' |from Scourge Guard##8527+, Gangled Golem##8544+, Nerubian Sycophant##45743+
	step
		goto 56.7,27.9
		.kill Borelgore##11896 |q 27477/1 |tip He's a huge yellow grub that walks along in this big trench.
	step
		goto 58.9,20.4 |n
		.' Run up this path |goto 58.9,20.4,0.5 |noway |c
	step
		goto 66.8,9.9
		.' Don't walk over the dirt piles on the ground, they spawn more enemies
		.from Warlord Thresh'jin##10822 |tip Don't worry that he's elite, you can kill him easily
		.get Body of Warlord Thresh'jin |q 27481/1
		.' Click the Quest Complete box that displays on the right side of the screen under your minimap
		..turnin Out of the Ziggurat##27481
		..accept Into the Flames##27482
	step
		goto 67.4,9.0
		.' Use the Body of Warlordw Thresh'jin next to the Bonfire at the top of the temple |use Body of Warlord Thresh'jin##61316
		.' Burn Warlord Thresh'jin's Body |q 27482/1
		.' Click the Quest Complete box that displays on the right side of the screen under your minimap
		..turnin Into the Flames##27482
	step
		goto 64.5,13.7
		.' Don't walk over the dirt piles on the ground, they spawn more enemies
		.from Mossflayer Cannibal##8562+, Mossflayer Scout##8560+, Mossflayer Shadowhunter##8561+, Infected Mossflayer##12261+
		.get 30 Mossflayer Eye |q 27479/1
	step
		goto 61.3,44.5
		.talk Deacon Andaal##45736
		..turnin Righteous Indignation##27479
	step
		ding 43
	step
		goto 61.6,43.1
		.talk Gamella Cracklefizz##45735
		..turnin The Corpulent One##27477
	step
		goto 61.5,42.7
		.talk Fiona##45417
		..turnin Ix'lar the Underlord##27487
	step
		goto 61.6,43.2
		.talk Tarenar Sunstrike##45729
		..accept Impatience##27488
	step
		goto 65.5,24.4
		.click Open Prayer Book##254
		.get Gidwin's Prayer Book |q 27488/1
	step
		goto 61.6,43.2
		.talk Tarenar Sunstrike##45729
		..turnin Impatience##27488
		..accept Nobody to Blame but Myself##27489
	step
		goto 61.6,42.5
		.clicknpc Fiona's Caravan##45400
		..' Choose to go to the next destination
		.' Ride Fiona's Caravan to Northpass Tower |q 27489/1
	step
		goto 50.4,20.1
		.talk Tarenar Sunstrike##45729
		..turnin Nobody to Blame but Myself##27489
		..accept Beat it Out of Them##27522
	step
		goto 50.0,19.5
		.talk Kirkian Dawnshield##45826
		..accept Wretched Hive of Scum and Villainy##27521
	step
		goto 54.6,19.1
		.from Scourge Siege Engineer##17878+
		.' Beat 6 Scourge Siege Engineers |q 27522/1
		.' Discover Gidwin's Location |q 27522/2
		.' Discover Gidwin's Captor |q 27522/3
	step
		goto 47.0,17.4
		.kill 9 Quel'lithien Wretched |q 27521/1
		' |from Wretched Pathstrider##8565+, Wretched Woodsman##8563+, Wretched Ranger##8564+
	step
		goto 48.0,23.0
		.talk Corpseburner Tim##45816
		..accept Duskwing, Oh How I Hate Thee...##27523
	step
		goto 46.4,33.8
		.' Use The Corpseburner's Flare in this spot |use The Corpseburner's Flare##61334 |tip If you get a message that there are no valid targets, wait until Duskwing spawns.  He's a big gray bat that flies in the sky around this area.
		.from Duskwing##11897
		.get Patch of Duskwing's Fur |q 27523/1
	step
		goto 48.0,23.0
		.talk Corpseburner Tim##45816
		..turnin Duskwing, Oh How I Hate Thee...##27523
	step
		goto 50.5,20.2
		.talk Fiona##45417
		..turnin Beat it Out of Them##27522
		..accept Blind Fury##27524
	step
		goto 50.5,20.2
		.talk Argus Highbeacon##45451
		..accept The Plaguewood Tower##27532
	step
		goto 50.0,19.5
		.talk Kirkian Dawnshield##45826
		..turnin Wretched Hive of Scum and Villainy##27521
	step
		goto 27.6,21.2
		.talk Tarenar Sunstrike##45729
		..turnin Blind Fury##27524
		..accept Guardians of Stratholme##27525
	step
		goto 27.6,20.9
		.talk Crusader Kevin Frost##45831
		..accept Scourged Mass##27528
		..accept Defenders of Darrowshire##27529
		..accept Add 'em to the Pile##27539
	step
		goto 29.4,19.7
		.kill Karthis Darkrune##45868 |q 27525/2
		.collect The Baroness' Missive##61378 |n
		.' Click The Baroness' Missive in your bags |use The Baroness' Missive##61378
		..accept The Baroness' Missive##27551
	step
		goto 27.4,21.3
		.talk Tarenar Sunstrike##45729
		..turnin The Baroness' Missive##27551
		..accept Gidwin's Fate Revealed##27526
	step
		goto 29.1,26.2
		.' Enter this building and watch the cutscene
		.' Find Gidwin Goldbraids |q 27526/1
	step
		goto 28.4,25.9
		.talk Gidwin Goldbraids##45730
		..turnin Gidwin's Fate Revealed##27526
		..accept Journey's End##27527
	step
		goto 25.4,19.8
		.kill Omasum Blighthoof##45867 |q 27525/1
	step
		goto 31.4,20.3
		.' All around Plaguewood, do the following:
		.from Overstuffed Golem##45851+
		.' Use your Crusader's Torch on their corpses |use Crusader's Torch##61369
		.' Burn 8 Overstuffed Golem Corpses |q 27528/1
		.from Cursed Mage##8524+, Scourge Soldier##8523+
		.get 16 Stinking Skull |q 27539/1
		.from Cannibal Ghoul##8530+
		.talk Darrowshire Spirit##11064 |tip They spawn after you kill Cannibal Ghouls.
		.' Free 8 Darrowshire Spirits |q 27529/1
	step
		goto 28.5,25.9
		.talk Tarenar Sunstrike##45729
		..turnin Guardians of Stratholme##27525
	step
		goto 27.6,20.9
		.talk Crusader Kevin Frost##45831
		..turnin Scourged Mass##27528
		..turnin Defenders of Darrowshire##27529
		..turnin Add 'em to the Pile##27539
		..accept The Corpsebeasts##27530
	step
		ding 44
	step
		goto 28.3,32.3
		.' Use your Argent Lightwell Charm next to the big brown monster corpses |use Argent Lightwell Charm##61375 |tip You will have to put 3 around each corpse, and you can't put them too close together.
		.' Destroy 3 Corpsebeasts |q 27530/1
	step
		goto 27.6,20.9
		.talk Crusader Kevin Frost##45831
		..turnin The Corpsebeasts##27530
	step
		goto 17.7,28.0
		.talk Argent Apothecary Judkins##45828
		..turnin The Plaguewood Tower##27532
		..accept Counter-Plague Research##27531
		..accept Just a Little Touched##27535
	step
		goto 25.1,34.5
		.click Flesh Giant Foot##8077
		.get Flesh Giant Foot Scrapings |q 27531/3
	step
		goto 23.5,22.4
		.click Rotberry Bush##28+
		.get 20 Rotberry |q 27531/1
		.click Disembodied Arm##8373+
		.get 5 Disembodied Arm |q 27531/2
	step
		goto 17.7,28.0
		.talk Argent Apothecary Judkins##45828
		..turnin Counter-Plague Research##27531
	step
		goto 11.3,28.6
		.talk Augustus the Touched##12384
		..turnin Just a Little Touched##27535
		..accept A Fate Worse Than Butchery##27533
		..accept Augustus' Receipt Book##27534
	step
		goto 14.2,26.3
		.click Augustus' Receipt Book##4872
		.get Augustus' Receipt Book |q 27534/1
	step
		goto 14.4,28.5
		.kill 9 Plagued Swine##16117+ |q 27533/1
	step
		goto 11.3,28.6
		.talk Augustus the Touched##12384
		..turnin A Fate Worse Than Butchery##27533
		..turnin Augustus' Receipt Book##27534
	step
		'Use Gidwin's Hearthstone |use Gidwin's Hearthstone##61379
		.' Teleport to Light's Hope Chapel |goto 75.6,52.4,0.5 |noway |c
	step
		goto 73.7,52.1
		.talk Fiona##45417
		..turnin Journey's End##27527
	step
	label	"Annals"
		goto 76.1,51.0
		.talk Lord Raymond George##49856
		|tip These are dungeon quests. If you are not high level, you will need to get a group to continue.
		..accept Annals of the Silver Hand##28755 |repeatable
	step
		goto Stratholme,32.1,34.6
		.click The Bastion Door##444
		.' Enter the hallway |goto Stratholme,30.5,35.8,0.5 |c
	step
		goto Stratholme,22.4,56.6
		.click Hall of the High Command Door##444
		.' Enter the Hallway and turn left |goto 20.1,59.5,0.5 |noway |c
	step
		goto Stratholme,27.5,74.7
		.click Annals of the Silver Hand##8133
		.get Annals of the Silver Hand |q 28755/1
	step
		goto Eastern Plaguelands,76.2,51.0
		.talk Lord Raymond George##49856
		..turnin Annals of the Silver Hand##28755 |repeatable |next "Annals" |only if rep('Argent Dawn')<=Exalted |tip If you do not reset your instance then you will only be forced to clear mobs one time.
		.' Earn Exalted reputation with the Argent Dawn |condition rep('Argent Dawn')==Exalted |next "exalted" |only if rep('Argent Dawn')==Exalted
	step
	label exalted
		.' Congratulations, you are now Exalted with the _Argent Dawn_!
]])

ZygorGuidesViewer:RegisterInclude("H_Icecrown_Argent_Crusade_Rep",[[
	step
		'Routing to proper section |next "tabard" |only if completedq(13083)
		'Routing to proper section |next |only if not completedq(13083)
	step
		goto Icecrown,87.8,78.1
		.talk Aedan Moran##30433
		.fpath The Argent Vanguard
	step
		goto Icecrown 87.5,75.8
		.talk Highlord Tirion Fordring##28179
		..accept Honor Above All Else##13036
	step
		goto 87.1,75.8
		.talk Crusade Commander Entari##30223
		..turnin Honor Above All Else##13036
		..accept Scourge Tactics##13008
	step
		goto 86.8,76.7
		.talk Father Gustav##30226
		..accept Curing The Incurable##13040
	step
		goto 86.1,75.8
		.talk Crusader Lord Dalfors##30224
		..accept Defending The Vanguard##13039
	step
		goto 84.4,74.3
		.from Carrion Fleshstripper##30206+, Forgotten Depths Acolyte##30205+
		.kill 15 Forgotten Depths Nerubian |q 13039/1
		.get 10 Forgotten Depths Venom Sac|q 13040/1
		.' Kill the white spider wrappings around this area.
		|modelnpc Webbed Crusader##17680
		.' Free 8 Webbed Crusaders |q 13008/1
	step
		goto 86.1,75.8
		.talk Crusader Lord Dalfors##30224
		..turnin Defending The Vanguard##13039
	step
		goto 86.8,76.7
		.talk Father Gustav##30226
		..turnin Curing The Incurable##13040
	step
		goto 87.1,75.8
		.talk Crusade Commander Entari##30223
		..turnin Scourge Tactics##13008
		..accept If There Are Survivors...##13044
	step
		goto 87.0,79.0
		.talk Penumbrius##30227
		..turnin If There Are Survivors...##13044
		..accept Into The Wild Green Yonder##13045
	step
		goto 87.1,79.1
		'Click the Argent Skytalon to ride it |modelnpc Argent Skytalon##30500 |invehicle |c |q 13045
	step
		goto 79.0,67.4
		.' Use the Grab Captured Crusader ability near Captured Crusaders to pick them up |petaction Grab Captured Crusader
		.' Once you pick up a Captured Crusader, fly to [86.9,76.5]
		.' Use the Drop Off Captured Crusader ability near the tents to drop off the crusaders
		.' Repeat this process 2 more times
		.' Rescue 3 Captured Crusaders |q 13045/1
	step
		.' Click the red arrow on your vehicle hot bar to stop riding the dragon |outvehicle |c
	step
		goto 87.5,75.8
		.talk Highlord Tirion Fordring##28179
		..turnin Into The Wild Green Yonder##13045
		..accept A Cold Front Approaches##13070
	step
		goto 85.6,76.0
		.talk Siegemaster Fezzik##30657
		..turnin A Cold Front Approaches##13070
		..accept The Last Line Of Defense##13086
	step
		goto 85.3,75.9
		'Click the Argent Cannon to get on it |modelnpc Argent Cannon##30236 |invehicle |c |q 13086
	step
		'Use the skills on your hotbar to kill scourge mobs and dragons
		'|from Forgotten Depths Slayer##30593+
		.kill 100 Scourge Attacker |q 13086/1
		.kill 3 Frostbrood Destroyer##30575+ |q 13086/2
	step
		.' Click the red arrow on your vehicle hot bar to stop using the cannon |outvehicle |c
	step
		goto 85.6,76.0
		.talk Siegemaster Fezzik##30657
		..turnin The Last Line Of Defense##13086
	step
		goto 86.0,75.8
		.talk Highlord Tirion Fordring##28179
		..accept Once More Unto The Breach, Hero##13105 |only DeathKnight
		..accept Once More Unto The Breach, Hero##13104 |only !DeathKnight
	step
		goto 83.0,72.9
		.talk The Ebon Watcher##30596
		..turnin Once More Unto The Breach, Hero##13105 |only DeathKnight
		..turnin Once More Unto The Breach, Hero##13104 |only !DeathKnight
		..accept The Purging Of Scourgeholme##13118
		..accept The Scourgestone##13122
	step
		goto 83.0,73.1
		.talk Crusade Architect Silas##30686
		..accept The Stone That Started A Revolution##13130
	step
		goto 83.0,73.1
		.talk Crusade Engineer Spitzpatrick##30714
		..accept It Could Kill Us All##13135
	step
		goto 82.9,72.8
		.talk Father Gustav##30683
		..accept The Restless Dead##13110
	step
		goto 80.4,68.2
		.kill 8 Reanimated Crusader##31043+ |q 13118/3
		.kill 3 Forgotten Depths Underking##31039+ |q 13118/2
		.get 15 Scourgestone |q 13122/1
		.' Use your Holy Water on Reanimated Crusader corpses |use Holy Water##43153
		.' Free 10 Restless Souls |q 13110/1
	step
		goto 78.7,60.2
		.kill 3 Forgotten Depths High Priest##31037+ |q 13118/1
		.' You can find another Forgotten Depths High Priest at [76.2,61.0]
	step
		goto 82.9,72.8
		.talk Father Gustav##30683
		..turnin The Restless Dead##13110
	step
		goto 83.0,72.9
		.talk The Ebon Watcher##30596
		..turnin The Purging Of Scourgeholme##13118
		..turnin The Scourgestone##13122
		..accept The Air Stands Still##13125
	step
		goto 77.6,62.2
		.' Use your War Horn of Acherus on Salranax the Flesh Render |use War Horn of Acherus##43206 |tip A Death Knight is summoned to help you, but make sure you get the first hit on Salranax the Flesh Render, or else you won't get credit for the kill.
		.kill Salranax the Flesh Render##30829 |q 13125/1
	step
		goto 79.7,60.9
		.' Use your War Horn of Acherus on High Priest Yath'amon |use War Horn of Acherus##43206 |tip A Death Knight is summoned to help you, but make sure you get the first hit on High Priest Yath'amon, or else you won't get credit for the kill.
		.kill High Priest Yath'amon##30831 |q 13125/3
	step
		goto 76.6,54.1
		.' Use your War Horn of Acherus on Underking Talonox |use War Horn of Acherus##43206 |tip A Death Knight is summoned to help you, but make sure you get the first hit on Underking Talonox, or else you won't get credit for the kill.
		.kill Underking Talonox##30830 |q 13125/2
	step
		.' Click the dark portal that spawns after you kill Underking Talonox to return to the Valley of Echoes |goto Icecrown,83.0,72.6,0.5 |noway |c
	step
		goto 83.0,72.9
		.talk The Ebon Watcher##30596
		..turnin The Air Stands Still##13125
	step
		goto Crystalsong Forest,59.9,57.2 //// Display ID
		.from Unbound Ent##30862+, Unbound Dryad##30860+
		.get 8 Crystallized Energy |q 13135/1
		.click Crystalline Heartwood##8439  
		.get 10 Crystalline Heartwood |q 13130/1
	step
		goto 73.8,53.0
		.click Ancient Elven Masonry##8356 
		.get 10 Ancient Elven Masonry|q 13130/2
		.' You can find more Ancient Elven Masonry around [79.6,61.3] |n
	step
		goto Icecrown,83.0,73.1
		.talk Crusade Architect Silas##30686
		..turnin The Stone That Started A Revolution##13130
	step
		goto 83.0,73.1
		.talk Crusade Engineer Spitzpatrick##30714
		..turnin It Could Kill Us All##13135
	step
		goto 82.9,72.8
		.talk Father Gustav##30683
		..accept Into The Frozen Heart Of Northrend##13139
	step
		goto 86.0,75.8
		.talk Highlord Tirion Fordring##28179
		..turnin Into The Frozen Heart Of Northrend##13139
		..accept The Battle For Crusaders' Pinnacle##13141
	step
		goto 80.1,72.0
		.' Use your Blessed Banner of the Crusade |use Blessed Banner of the Crusade##43243
		.' Watch the Battle for Crusaders' Pinnacle |q 13141/1
	step
		goto 82.9,72.8
		.talk Father Gustav##30683
		..turnin The Battle For Crusaders' Pinnacle##13141
		..accept The Crusaders' Pinnacle##13157
	step
		goto 79.8,71.8
		.talk Highlord Tirion Fordring##28179
		..turnin The Crusaders' Pinnacle##13157
		..accept A Tale of Valor##13068
	step
		goto 79.5,72.7
		.talk Warlord Hork Strongbrow##31240
		..accept Orgrim's Hammer##13224
	step
		goto 79.8,30.8
		.talk Crusader Bridenbrad##30562
		..turnin A Tale of Valor##13068
		..accept A Hero Remains##13072
	step
		goto 79.8,71.8
		.talk Highlord Tirion Fordring##28179
		..turnin A Hero Remains##13072
		..accept The Keeper's Favor##13073
	step
		goto 87.1,77.0
		.talk Arch Druid Lilliandra##30630
		..' Ask her for a portal to Moonglade
		..' Click the Moonglade Portal that appears next to you |goto Moonglade |noway |c
	step
		goto Moonglade,36.2,41.8
		.talk Keeper Remulos##11832
		..turnin The Keeper's Favor##13073
		..accept Hope Within the Emerald Nightmare##13074
	step
		goto 33.7,44.1
		.click Emerald Acorn##424
		.get 3 Emerald Acorn|q 13074/1
	step
		'Right click your Fitfull Dream buff to awaken from the nightmare |nobuff Spell_Nature_Sleep |q 13074 |tip The Fitfull Dream buff icon looks like a closed eye.
	step
		goto 36.2,41.8
		.talk Keeper Remulos##11832
		..turnin Hope Within the Emerald Nightmare##13074
		..accept The Boon of Remulos##13075
	step
		.talk Keeper Remulos##11832
		..' Tell him you wish to return to Arch Druid Lilliandra.
		..' Click the Moonglade Return Portal |goto Icecrown |noway |c
	step
		goto 79.8,30.8
		.talk Crusader Bridenbrad##30562
		..turnin The Boon of Remulos##13075
		..accept Time Yet Remains##13076
	step
		goto 79.8,71.8
		.talk Highlord Tirion Fordring##28179
		..turnin Time Yet Remains##13076
		..accept The Touch of an Aspect##13077
	step
		goto Dragonblight,57.9,54.2|n
		.talk Tariolstrasz##26443
		..'Tell him you need to go to the top of the temple|goto Dragonblight,59.7,53.1,0.1 |noway |c
	step
		goto 59.8,54.7
		.talk Alexstrasza the Life-Binder##26917
		..turnin The Touch of an Aspect##13077
		..accept Dahlia's Tears##13078
	step
		goto 59.5,53.3|n
		.talk Torastrasza##26949
		..'Tell him you want to go to the ground level of the temple |goto Dragonblight,58.0,55.2,0.1|noway|c
	step
		goto 43.2,51.7
		.' There should be a fight happening, so just wait around until the fight is over |tip If there isn't fight happening, just wait until the fighters spawn again, and there should be some red dragon Ruby Watchers flying above the fight.
		..' At the end of the fight, a Ruby Watcher will blow alot of fire on the ground and the Dahlia's Tears will spawn
		.click Dahlia's Tears##8329 
		..get Dahlia's Tears|q 13078/1
	step
		goto 57.9,54.2|n
		.talk Tariolstrasz##26443
		..'Tell him you need to go to the top of the temple |goto Dragonblight,59.7,53.1,0.1|noway|c
	step
		goto 59.8,54.7
		.talk Alexstrasza the Life-Binder##26917
		..turnin Dahlia's Tears##13078
		..accept The Boon of Alexstrasza##13079
	step
		goto 59.5,53.3|n
		.talk Torastrasza##26949
		..'Tell him you want to go to the ground level of the temple |goto Dragonblight,58.0,55.2,0.1|noway|c
	step
		goto Icecrown 79.8,30.8
		.talk Crusader Bridenbrad##30562
		..turnin The Boon of Alexstrasza##13079
		..accept Hope Yet Remains##13080
	step
		goto 79.8,71.8
		.talk Highlord Tirion Fordring##28179
		..turnin Hope Yet Remains##13080
		..accept The Will of the Naaru##13081
	step
		.' Click the Portal to Shattrath that appears near you|goto Shattrath City|noway|c
	step
		goto Shattrath City,54,44.8
		.talk A'dal##18481
		..turnin The Will of the Naaru##13081
		..accept The Boon of A'dal##13082
	step
		goto Icecrown,79.8,30.8
		.talk Crusader Bridenbrad##30562
		..turnin The Boon of A'dal##13082
	step
		goto 79.8,30.8
		.click Bridenbrad's Possessions##1 
		..accept Light Within the Darkness##13083
	step
		goto 79.8,71.8
		.talk Highlord Tirion Fordring##28179
		..turnin Light Within the Darkness##13083
	step
	label "tabard"
		'You should now be above honored with the _Argent Crusade_.
		.' The fastest way to continue to earn reputation with _Argent Crusade_ is to buy a tabard and run any dungeon that gives experience. 
		|confirm
	step
		goto Icecrown,87.5,75.6
		.talk Veteran Crusader Aliocha Segard##30431
		.buy 1 Tabard of the Argent Crusade##43154
	step
		.' Equip this Tabard in your bags |equipped Tabard of the Argent Crusade##43154 |use Tabard of the Argent Crusade##43154
		.' You can run any dungeon that grants experience to gain reputation for the Argent Crusade.
		.' Friendly with Argent Crusade |condition rep('Argent Crusade')>=Friendly
		.' Honored with Argent Crusade |condition rep('Argent Crusade')>=Honored
		.' Revered with Argent Crusade |condition rep('Argent Crusade')>=Revered
		.' Become Exalted with Argent Crusade |condition rep('Argent Crusade')==Exalted
	step
		'Congratulations! You are now Exalted with the _Argent Crusade_!
]])

ZygorGuidesViewer:RegisterInclude("H_Firelands_PreQuests",[[
	step
		goto Orgrimmar,49.7,76.5
		.' Click the Warchief's Command Board |tip It looks like a wooden wall with a bunch of paper notes on it.
		..accept Warchief's Command: Mount Hyjal!##27721
		.' You will automatically accept a quest by entering Orgrimmar
		..accept A Personal Summons##28790
	step
		goto 50.5,38.4
		.talk Farseer Krogar##45244
		..turnin A Personal Summons##28790
		..accept The Eye of the Storm##28805
	step
		goto 50.8,37.8
		.' Click the Waters of Farseeing |tip It looks like a small bowl with spinning bright blue water in it.
		.' Witness the Vision of the Farseer |q 28805/1
	step
		goto 50.5,38.4
		.talk Farseer Krogar##45244
		..turnin The Eye of the Storm##28805	
	step
		goto 39.9,50.9
		.talk Cenarion Emissary Blackhoof##15188
		..' Ask him to please send you to Moonglade
		.' You will teleport to Moonglade |goto Moonglade,45.1,43.1,0.5 |noway |c
	step
		goto Moonglade,45.5,44.9
		.talk Emissary Windsong##39865
		..turnin Warchief's Command: Mount Hyjal!##27721
		..accept As Hyjal Burns##25316
	step
		goto Mount Hyjal,63.1,24.1
		.talk Sebelia##40843
		.home Nordrassil
	step
		goto 62.0,24.9
		.talk Ysera##40928
		..turnin As Hyjal Burns##25316
		..accept Protect the World Tree##25317
	step
		goto 64.0,22.6
		.talk Anren Shadowseeker##39925
		..accept The Earth Rises##25460
	step
		goto 64.0,22.5
		.talk Tholo Whitehoof##40278
		..accept Inciting the Elements##25370
	step
		goto 65.8,20.8
		.kill 8 Scalding Rock Elemental |q 25460/1
		.' Click Juniper Berries |tip They look like small green bushes with small red berries on them, at the base of trees around this area.
		.collect 4 Juniper Berries##53009 |n
		.' Use your Juniper Berries on Faerie Dragons |use Juniper Berries##53009 |tip They look like small blue flying dragons around this area.
		.' Follow the Faerie Dragons to find Twilight Inciters
		.kill 4 Twilight Inciter |q 25370/1
	step
		goto 64.0,22.5
		.talk Tholo Whitehoof##40278
		..turnin Inciting the Elements##25370
		..accept Flames from Above##25574
	step
		goto 64.0,22.6
		.talk Anren Shadowseeker##39925
		..turnin The Earth Rises##25460
	step
		goto 55.9,15.8
		.' Use Tholo's Horn to call for an emerald dragon |use Tholo's Horn##55122
		.' Burn the Infiltrators' Encampment |q 25574/1
	step
		goto 64.0,22.5
		.talk Tholo Whitehoof##40278
		..turnin Flames from Above##25574
	step
		goto 47.7,35.5
		.talk Malfurion Stormrage##15362
		..turnin Protect the World Tree##25317
		..accept War on the Twilight's Hammer##25319
	step
		goto 47.7,35.5
		.talk Windspeaker Tamila##39869
		..accept The Flameseer's Staff##25472
	step
		goto 47.8,29.4
		.kill 4 Twilight Flamecaller |q 25319/1
		.kill 10 Twilight Vanquisher |q 25319/2
		.' Click Charred Stagg Fragments |tip They look like small white pieces on the ground around this area.
		.get 8 Charred Staff Fragment |q 25472/1
	step
		goto 47.7,35.5
		.talk Malfurion Stormrage##15362
		..turnin War on the Twilight's Hammer##25319
		..turnin The Flameseer's Staff##25472
		..accept Flamebreaker##25323
	step
		goto 44.7,33.2
		.' Use your Flameseer's Staff on Blazebound Revenants |use Flameseer's Staff##53107
		.kill 30 Unbound Flame Spirit |q 25323/1
		.' You can find more Blazebound Revenants at [48.5,29.2]
	step
		goto 47.7,35.5
		.talk Malfurion Stormrage##15362
		..turnin Flamebreaker##25323
		..accept The Return of Baron Geddon##25464
	step
		goto 44.1,27.0
		.' Use your Flameseer's Staff on Baron Geddon |use Flameseer's Staff##54463 |tip He's a big fire elemental standing in the middle of this crater.
		.' Weaken Baron Geddon 20 Times |q 25464/1 |tip Run away when you see Galrond of the Claw yell "Look out!".
	step
		goto 47.7,35.5
		.talk Malfurion Stormrage##15362
		..turnin The Return of Baron Geddon##25464
	step
		goto 47.7,35.5
		.talk Windspeaker Tamila##39869
		..accept Emerald Allies##25430
	step
		goto 48.4,19.0
		.talk Alysra##38917
		..turnin Emerald Allies##25430
		..accept The Captured Scout##25320
	step
		goto 44.5,18.9
		.talk Scout Larandia##40096
		..turnin The Captured Scout##25320
		..accept Twilight Captivity##25321
	step
		goto 44.4,20.7
		.from Twilight Overseer##40123
		.get Twilight Overseer's Key |q 25321/1
	step
		goto 44.5,18.9
		.talk Scout Larandia##40096
		..turnin Twilight Captivity##25321
		..accept Return to Alysra##25424
	step
		goto 48.4,19.0
		.talk Alysra##38917
		..turnin Return to Alysra##25424
		..accept A Prisoner of Interest##25324
	step
		goto 52.6,17.3 |n
		.' Enter the cave |goto 52.6,17.3,0.5 |noway |c
	step
		goto 56.8,18.8
		.' Follow the path in the cave
		.talk Captain Saynna Stormrunner##40139
		..turnin A Prisoner of Interest##25324
		..accept Through the Dream##25325
	step
		goto 52.6,17.3 |n
		.' Leave the cave
		.' Deliver Arch Druid Fandral Staghelm |q 25325/1
	step
		goto 52.2,17.4
		.talk Alysra##40178
		..turnin Through the Dream##25325
		..accept Return to Nordrassil##25578
	step
		goto 62.0,24.9
		.talk Ysera##40928
		..turnin Return to Nordrassil##25578
		..accept The Return of the Ancients##25584
	step
		goto 35.7,19.4
		.talk Oomla Whitehorn##39429
		..turnin The Return of the Ancients##25584
		..accept Harrying the Hunters##25255
	step
		goto 35.8,19.7
		.talk Jadi Falaryn##39427
		..accept End of the Supply Line##25233
		..accept In the Rear With the Gear##25234
	step
		goto 34.6,24.5
		.kill 6 Twilight Hunter |q 25255/1
		.kill 4 Twilight Proveditor |q 25233/1 |tip They walk with 3 Twilight slaves and a Twilight Slavedriver.
		.' Click Twilight Supplies |tip The Twilight Slaves are carrying them.  You can get the supplies after you kill the Twilight Proveditor and Twilight Slavedriver.
		.get 36 Twilight Supplies |q 25234/1
	step
		goto 35.8,19.7
		.talk Jadi Falaryn##39427
		..turnin End of the Supply Line##25233
		..turnin In the Rear With the Gear##25234
	step
		goto 35.7,19.4
		.talk Oomla Whitehorn##39429
		..turnin Harrying the Hunters##25255
		..accept The Voice of Lo'Gosh##25269
	step
		goto 30.1,31.7
		.talk Takrik Ragehowl##39432
		..turnin The Voice of Lo'Gosh##25269
		..accept Howling Mad##25270
	step
		goto 29.0,31.4
		.from Lycanthoth Vandal##39445+
		.get 6 Polluted Incense |q 25270/1
	step
		goto 30.1,31.7
		.talk Takrik Ragehowl##39432
		..turnin Howling Mad##25270
		..accept Lycanthoth the Corruptor##25272
	step
		goto 32.4,37.3
		.' Use Lycanthoth's Incense next to Lycanthoth's Altar |use Lycanthoth's Incense##52682 |tip Inside the cave.
		.kill Lycanthoth |q 25272/1
	step
		goto 32.5,37.4
		.talk Spirit of Lo'Gosh##39622
		..turnin Lycanthoth the Corruptor##25272
	step
		goto 29.6,29.3
		.talk Spirit of Lo'Gosh##39622
		..accept The Shrine Reclaimed##25279
	step
		goto 28.4,29.9
		.talk Takrik Ragehowl##39432
		..turnin The Shrine Reclaimed##25279
		..accept Cleaning House##25277
	step
		goto 28.3,30.0
		.talk Royce Duskwhisper##39435
		..accept The Eye of Twilight##25300
	step
		goto 28.2,29.9
		.talk Rio Duran##39434
		..accept From the Mouth of Madness##25297
	step
		goto 28.9,32.1
		.' Click a Bitterblossom |tip They look like purple flowers around this small island.
		.get Bitterblossom |q 25297/2
	step
		goto 26.5,35.0
		.' Click a Stonebloom |tip They look like piles of brown-ish bags on the ground around this area.
		.get Stonebloom |q 25297/1
	step
		goto 27.2,35.2
		.' Click the Eye of Twilight |tip It looks like a glowing purple ball in a metal rod with a hook on it.
		..turnin The Eye of Twilight##25300
		..accept Mastering Puppets##25301
	step
		goto 28.4,35.8
		.' Click a Darkflame Ember |tip They are purple glowing coals sitting in a brazier.
		.get Darkflame Ember |q 25297/3
	step
		goto 28.4,36.5
		.' Click the Twilight Cauldron |tip It's a metal pot with blue smoke coming out of it.
		..turnin From the Mouth of Madness##25297
		..accept Free Your Mind, the Rest Follows##25298
	step
		goto 26.9,36.3 |n
		.' Enter the cave |goto 26.9,36.3,0.5 |noway |c
	step
		goto 27.2,40.8
		.talk Kristoff Manheim##39797
		..accept Gar'gol's Gotta Go##25328 |tip This quest is currently bugged, so some players are able to accept the quest while others cannot.
	step
		goto 26.5,38.5
		.' Click Gar'gol's Personal Treasure Chest |tip It's a small metal chest sitting on a small stone mound.
		.get Rusted Skull Key |q 25328/1
	step
		goto 25.8,41.6
		.' Click The Twilight Apocrypha |tip It's an open book layin on a wooden crate at the very back of the cave.
		..turnin Mastering Puppets##25301
		..accept Elementary!##25303
	step
		goto 26.0,41.8
		.' Click the Crucible of Fire |tip It looks like a floating glowing hourglass.
		.' Activate the Crucible of Fire |q 25303/3
	step
		goto 25.6,41.7
		.' Click the Crucible of Earth |tip It looks like a floating glowing hourglass.
		.' Activate the Crucible of Earth |q 25303/1
	step
		goto 25.8,41.9
		.' Click the Crucible of Air |tip It looks like a floating glowing hourglass.
		.' Activate the Crucible of Air |q 25303/2
	step
		goto 26.0,41.6
		.' Click the Crucible of Water |tip It looks like a floating glowing hourglass.
		.' Activate the Crucible of Water |q 25303/4
	step
		goto 25.8,41.6
		.' Click The Twilight Apocrypha |tip It's an open book layin on a wooden crate at the very back of the cave.
		..turnin Elementary!##25303
		..accept Return to Duskwhisper##25312
	step
		goto 26.7,39.2
		.from Hovel Brute##39642+, Hovel Shadowcaster##39643+
		.' Slay 8 Minions of Gar'gol |q 25277/1
		.talk Twilight Servitor##39644
		..' Administor the drought
		.' Free 8 Twilight Servitors |q 25298/1
	step
		goto 27.2,40.8
		.talk Kristoff Manheim##39797
		..turnin Gar'gol's Gotta Go##25328
		..accept Get Me Outta Here!##25332
	step
		goto 27.1,36.0 |n
		.' Leave the cave
		.' Escort Kristoff Out |q 25332/1
	step
		goto 28.6,30.2
		.talk Royce Duskwhisper##39435
		..turnin Return to Duskwhisper##25312
		..turnin Get Me Outta Here!##25332
	step
		goto 28.4,29.9
		.talk Takrik Ragehowl##39432
		..turnin Cleaning House##25277
		..accept Sweeping the Shelf##25354
		..accept Lightning in a Bottle##25355
	step
		goto 28.2,29.9
		.talk Rio Duran##39434
		..turnin Free Your Mind, the Rest Follows##25298
	step
		goto 29.1,40.7
		.kill 8 Twilight Stormcaller |q 25354/1
		.kill 5 Howling Riftdweller |q 25354/2
		.' Click a Lightning Channel |tip They look like rods standing upright around this area, with lamps at the top of them.
		..get Charged Condenser Jar |q 25355/1
	step
		'Use your Totem of Lo'Gosh |use Totem of Lo'Gosh##52854
		.talk Spirit of Lo'Gosh##39622
		..turnin Lightning in a Bottle##25355
		..accept Into the Maw!##25617
	step
		goto 26.2,41.0 |n
		.' Go inside the blue portal |goto 25.8,41.5,0.3 |noway |c
	step
		goto 26.3,41.9
		.talk Jordan Olafson##40834
		..turnin Into the Maw!##25617
		..accept Forged of Shadow and Flame##25575
		..accept Crushing the Cores##25577
	step
		goto 26.3,42.0
		.talk Yargra Blackscar##40837
		..accept Rage of the Wolf Ancient##25576
	step
		goto 29.6,41.8
		.kill 12 Dark Iron Laborer |q 25576/1
		.from Searing Guardian##40841+
		.collect 8 Smoldering Core##55123 |n
		.' Use your Smoldering Cores next to Twilight Anvils |use Smoldering Core##55123 |tip They are small anvils sitting on the ground around this area.
		.' Destroy 8 Smoldering Cores |q 25577/1
		.' Click Twilight Arms Crates |tip They look like wooden boxes sitting on the ground around this area.
		.' Destroy 10 Twilight Arms Crates |q 25575/1
	step
		goto 26.3,42.0
		.talk Yargra Blackscar##40837
		..turnin Rage of the Wolf Ancient##25576
	step
		goto 26.3,41.9
		.talk Jordan Olafson##40834
		..turnin Forged of Shadow and Flame##25575
		..turnin Crushing the Cores##25577
		..accept Cindermaul, the Portal Master##25599
	step
		goto 30.7,41.7
		.kill Cindermaul |q 25599/1
		.' Click the Battered Stone Chest |tip It spawns after you kill Cindermaul.
		.get Tome of Openings |q 25599/2
	step
		goto 26.3,41.9
		.talk Jordan Olafson##40834
		..turnin Cindermaul, the Portal Master##25599
		..accept Forgemaster Pyrendius##25600
	step
		goto 31.9,46.3
		.' Click the Portal Runes |tip They are brown metal plates on the ground on this small circular island in the lava.
		.' Lure Forgemaster Pyrendius onto the activated Portal Runes |tip This will weaken him and allow you to kill him.
		.kill Forgemaster Pyrendius |q 25600/1
	step
		goto 26.3,41.9
		.talk Jordan Olafson##40834
		..turnin Forgemaster Pyrendius##25600
		..accept Return from the Firelands##25612
	step
		goto 25.9,40.9 |n
		.' Go inside the blue portal |goto 26.3,40.9,0.3 |noway |c
	step
		goto 28.4,29.9
		.talk Takrik Ragehowl##39432
		..turnin Sweeping the Shelf##25354
		..turnin Return from the Firelands##25612
	step
		goto 27.0,62.7
		.talk Vision of Ysera##46987
		..accept Aviana's Legacy##27874
	step
		goto 28.2,29.9
		.talk Rio Duran##39434
		..accept The Fires of Mt. Hyjal##25630
	step
		goto 19.0,40.9
		.talk Laina Nightsky##39927
		..turnin The Fires of Mt. Hyjal##25630
		..accept Fighting Fire With ... Anything##25381
		..accept Disrupting the Rituals##25382
	step
		goto 19.2,37.9
		.talk Mylune##39930
		..accept Save the Wee Animals##25385
	step
		goto 19.0,37.0
		.talk Matoclaw##39928
		..accept If You're Not Against Us...##25404
	step
		goto 22.3,44.9
		.talk Tyrus Blackhorn##39933
		..' Tell him you've been sent to request his aid, then tell him he could be destroyed, then ask him if he will help you
		.' Persuade Blackhorn |q 25404/1
	step
		goto 22.3,44.9
		.talk Tyrus Blackhorn##39933
		..turnin If You're Not Against Us...##25404
		..accept Seeds of Their Demise##25408
	step
		goto 21.1,42.6
		.from Wailing Weed##40066+
		.get 8 Bileberry |q 25408/1
	step
		goto 22.3,44.9
		.talk Tyrus Blackhorn##39933
		..turnin Seeds of Their Demise##25408
		..accept A New Master##25411
	step
		goto 14.5,45.3
		.from Twilight Inferno Lord##39974
		.' Use your Bottled Bileberry Brew on the corpse of a Twilight Inferno Lord |use Bottled Bileberry Brew##53120
		.' Subjugate a Twilight Inferno Lord |q 25411/1
	step
		'Next to you:
		.talk Subjugated Inferno Lord##40093
		..turnin A New Master##25411
		..accept The Name Never Spoken##25412
	step
		goto 14.3,45.4
		.' Click the Southern Firestone |tip It looks like a metal stand with a small flame at the top of it.
		.' Examine the Southern Firestone |q 25412/3
	step
		goto 11.7,41.5
		.' Click the Central Firestone |tip It looks like a metal stand with a small flame at the top of it.
		.' Examine the Central Firestone |q 25412/2
	step
		goto 9.6,36.5
		.' Click the Northern Firestone |tip It looks like a metal stand with a small flame at the top of it.
		.' Examine the Northern Firestone |q 25412/1
	step
		goto 11.3,38.2
		.kill 10 Raging Firestorm |q 25381/1
		.kill 6 Twilight Inferno Lord |q 25382/1		
		.' Click Panicked Bunnies and Terrified Squirrels |tip They are small and run around this area.
		.get 10 Frightened Animal |q 25385/1
	step
		goto 19.0,40.9
		.talk Laina Nightsky##39927
		..turnin Fighting Fire With ... Anything##25381
		..turnin Disrupting the Rituals##25382
	step
		goto 19.2,37.9
		.talk Mylune##39930
		..turnin Save the Wee Animals##25385
		..accept Oh, Deer!##25392
	step
		goto 22.3,44.9
		.talk Tyrus Blackhorn##39933
		..turnin The Name Never Spoken##25412
		..accept Black Heart of Flame##25428
	step
		goto 14.6,42.2
		.' Use your Charred Branch while in the burning forest area |use Charred Branch##53464
		.from Thol'embaar##40107
		.get Black Heart of Thol'embaar |q 25428/1
	step
		goto 12.5,44.6
		.' Click 3 Injured Fawns |tip They look like tiny deer laying on the ground around this area.
		.' Lead the Injured Fawns back to Mylune at [19.2,37.9]
		.' Escort 3 Injured Fawns Home |q 25392/1
	step
		goto 19.2,37.9
		.talk Mylune##39930
		..turnin Oh, Deer!##25392
	step
		goto 22.3,44.9
		.talk Tyrus Blackhorn##39933
		..turnin Black Heart of Flame##25428
		..accept Good News... and Bad News##29066
	step
		goto 19.0,40.9
		.talk Laina Nightsky##39927
		..accept Last Stand at Whistling Grove##25940
	step
		goto 19.0,37.0
		.talk Matoclaw##39928
		..turnin Good News... and Bad News##29066
	step
		goto 13.7,32.8
		.talk Keeper Taldros##39932
		..turnin Last Stand at Whistling Grove##25940
		..accept The Bears Up There##25462
	step
		goto 13.9,34.1
		.' Click the Climbing Tree |tip They look like small ladders leaning aginst the trees around this area.
		.' Click Hyjal Bear Cubs in the tree
		.' Use your Climb Up ability to climb to the top of the tree
		.' Use your Chuck-a-bear ability to throw the cubs down |tip Aim the yellow spot at the bearskin trampoline on the ground.
		.' Rescue 6 Hyjal Bear Cubs |q 25462/1
	step
		goto 13.7,32.8
		.talk Keeper Taldros##39932
		..turnin The Bears Up There##25462
		..accept Smashing Through Ashes##25490
	step
		goto 16.4,51.8
		.kill 8 Charbringer |q 25490/1	
	step
		goto 27.1,62.6
		.talk Arch Druid Hamuul Runetotem##5769
		..turnin Smashing Through Ashes##25490
		..accept Durable Seeds##25491
		..accept Fresh Bait##25493
	step
		goto 27.1,63.0
		.talk Rayne Feathersong##40331
		..accept Firebreak##25492
	step
		goto 34.0,53.2
		.kill 10 Lava Surger |q 25492/1
		.from Core Hound##46910+
		.get 4 Core Hound Entrails |q 25493/1
		.' Click Scorched Soil |tip They look like piles of dirt around this area.
		.get 10 Hyjal Seedling |q 25491/1
	step
		goto 42.2,45.4
		.talk Thisalee Crow##41006
		..accept The Wormwing Problem##25655
		..accept Scrambling for Eggs##25656
	step
		goto 44.4,46.2
		.talk Choluna##41005
		..turnin Aviana's Legacy##27874
		..accept An Offering for Aviana##25663
	step
		goto 40.4,44.3
		.' Use your Sacred Nectar next to Aviana's Burial Circle |use Sacred Nectar##55208
		.' Offer the Nectar |q 25663/1
		.talk Mysterious Winged Spirit##41068
		..turnin An Offering for Aviana##25663
		..accept A Plea From Beyond##25665
	step
		goto 36.9,43.4
		.from Wormwing Screecher##41027+, Wormwing Swifttalon##41028+
		.' Slay 10 Wormwing Harpies |q 25655/1
		.' Click Stolen Hyjal Eggs |tip They look like big white eggs sitting at the base of trees around this area.
		.get 8 Hyjal Egg |q 25656/1
	step
		goto 42.2,45.4
		.talk Thisalee Crow##41006
		..turnin The Wormwing Problem##25655
		..turnin Scrambling for Eggs##25656
		..accept A Bird in Hand##25731
	step
		goto 44.4,46.2
		.talk Choluna##41005
		..turnin A Plea From Beyond##25665
		..accept A Prayer and a Wing##25664
	step
		goto 38.4,44.2
		.' Click the Harpy Signal Fire |tip It's a brazier with red fire in it.
		.' Fight Marion Wormwing until she gets captured |q 25731/1
		.talk Marion Wormwing##41112
		..' Ask her why she is stealing eggs, then tell Thisalee to kill her
		.' Interrogate Marion Wormwing |q 25731/2
	step
		goto 39.2,37.1
		.' Use your Enormous Bird Call in Blaithe's Roost |use Enormous Bird Call##55211 |tip It's a huge bird nest sitting on top of this mountain peak.
		.from Blaithe##41084
		.get Ancient Feather |q 25664/1
	step
		goto 42.2,45.4
		.talk Thisalee Crow##41006
		..turnin A Bird in Hand##25731
	step
		goto 44.4,46.2
		.talk Choluna##41005
		..turnin A Prayer and a Wing##25664
	step
		goto 43.5,45.9
		.' Go upstairs in the Shrine of Aviana
		.talk Skylord Omnuron##40997
		..accept Fact-Finding Mission##25740
	step
		ding 81
	step
		goto 27.1,62.6
		.talk Arch Druid Hamuul Runetotem##5769
		..turnin Durable Seeds##25491
		..turnin Fresh Bait##25493
		..accept Hell's Shells##25507
	step
		goto 27.1,63.0
		.talk Rayne Feathersong##40331
		..turnin Firebreak##25492
		..accept Prepping the Soil##25502
	step
		goto 33.0,64.6
		.' Click the Flameward |tip It's a floating stone in a golden claw stand.
		.' Activate the Flameward |q 25502/1
		.' Defend the Flameward |q 25502/2
	step
		goto 32.8,70.8
		.talk Thisalee Crow##41006
		..turnin Fact-Finding Mission##25740
		..accept Sethria's Brood##25746
		..accept A Gap in Their Armor##25758
	step
		goto 31.3,77.1
		.' Click the Codex of Shadows |tip It's an open book sitting on a wooden box.
		..accept The Codex of Shadows##25763
	step
		goto 30.9,76.7
		.from Twilight Dragonkin##41029+, Twilight Dragonkin Armorers##41030+
		.' Slay 12 Sethria's Minions |q 25746/1
		.' Click Twilight Armor Plates |tip They look like tan pieces of metal laying on the ground around this area.
		.get 8 Twilight Armor Plate |q 25758/1 
	step
		goto 32.8,70.8
		.talk Thisalee Crow##41006
		..turnin Sethria's Brood##25746
		..turnin A Gap in Their Armor##25758
		..accept Disassembly##25761
		..turnin The Codex of Shadows##25763
		..accept Egg Hunt##25764
	step
		goto 31.1,76.7
		.' Use Thisalee's Shive on Twilight Juggernauts |use Thisalee's Shiv##55883 |tip Use Thisalee's Shive multiple times to remove the Twilight Juggernauts' Armor Plating and make them weaker.
		.kill 3 Twilight Juggernaut |q 25761/1
		.' Click Shadow Cloak Generators |tip They look like blue glowing machines around this area.
		.' Unveil and Defend Aviana's Egg |q 25764/1
	step
		goto 32.8,70.8
		.talk Thisalee Crow##41006
		..turnin Disassembly##25761
		..turnin Egg Hunt##25764
		..accept Sethria's Demise##25776
	step
		goto 35.5,98.0
		.from Sethria##41255
		.' Use Thisalee's Signal Rocket when Sethria turns into a dragon |use Thisalee's Signal Rocket##56003
		.kill Sethria |q 25776/1
	step
		goto 32.8,70.8
		.talk Thisalee Crow##41006
		..turnin Sethria's Demise##25776
		..accept Return to the Shrine##25795	
	step
		goto 37.4,52.3
		.' Use your Heap of Core hound Innards near Nemesis |use Heap of Core hound Innards##54744 |tip Nemesis is a huge turtle that walks all around The Flamewake area, so you may need to search for him.
		.' Click Nemesis when he becomes friendly
		.get Nemesis Shell Fragment |q 25507/1
	step
		goto 44.4,46.2
		.talk Choluna##41005
		..turnin Return to the Shrine##25795
		..accept An Ancient Reborn##25807
	step
		goto 44.3,47.9
		.' Use Herald's Incense next to Aviana's Egg |use Herald's Incense##56016 |tip Aviana's Egg is in the tree tower, in a side room.
		.' Burn Herald's Incense |q 25807/1
	step
		goto 44.3,48.0
		.talk Aviana##41308
		..turnin An Ancient Reborn##25807
	step
		goto 44.1,45.9
		.talk Morthis Whisperwing##41003
		..accept The Hatchery Must Burn##25810
	step
		goto 39.2,58.1 |n
		.' Go inside the blue portal |goto 38.8,58.0,0.3 |noway |c
	step
		goto 37.2,56.2
		.talk Farden Talonshrike##40578
		..turnin The Hatchery Must Burn##25810
		..accept Flight in the Firelands##25523
	step
		goto 37.2,56.2
		.' Click the Twilight Weapon Rack |tip It's a wooden stand with some weapons leaning against it.
		.collect Twilight Firelance##52716 |q 25523
	step
		goto 37.4,56.0
		.' Equip the Twilight Firelance |equipped Twilight Firelance##52716 |q 25523
		.' Click Aviana's Guardian to ride it |invehicle |tip They are hippogryphs.
	step
		goto 36.4,53.2
		.' Use your Flap ability on your hotbar repeatedly to fly to this green flag
		.' Visit the Guardian Flag |q 25523/1
	step
		goto 37.2,56.2
		.' Use your Flap ability on your hotbar repeatedly to fly to this spot
		.talk Farden Talonshrike##40578
		..turnin Flight in the Firelands##25523
		..accept Wave One##25525
	step
		goto 36.8,54.0
		.' Use your Flap ability on your hotbar repeatedly to fly around this area
		.' Fly into Twilight Buzzards to joust them
		.kill 10 Twilight Knight Rider |q 25525/1
	step
		goto 37.2,56.2
		.' Use your Flap ability on your hotbar repeatedly to fly to this spot
		.talk Farden Talonshrike##40578
		..turnin Wave One##25525
		..accept Wave Two##25544
	step
		goto 36.8,54.0
		.' Use your Flap ability on your hotbar repeatedly to fly around this area
		.' Fly into Twilight Firebirds to joust them |tip Be careful, don't let the burning Falling Boulders hit you.
		.kill 10 Twilight Lancer |q 25544/1
	step
		goto 37.2,56.2
		.' Use your Flap ability on your hotbar repeatedly to fly to this spot
		.talk Farden Talonshrike##40578
		..turnin Wave Two##25544
		..accept Egg Wave##25560
	step
		goto 33.3,56.9
		.' Use your Flap ability on your hotbar repeatedly to fly around this area
		.' Run over Firelands Eggs |tip They look like blue eggs on the ground around this area.
		.' Destroy 40 Firelands Eggs |q 25560/1
		.' You can find more Firelands Eggs all around [35.8,53.6]
	step
		goto 37.2,56.2
		.' Use your Flap ability on your hotbar repeatedly to fly to this spot
		.talk Farden Talonshrike##40578
		..turnin Egg Wave##25560
		..accept Return to Aviana##25832
	step
		'Click the red arrow on your hot bar to get off the hippogryph |outvehicle |c |q 25832
	step
		'Don't forget to equip your real weapon again
		|confirm
	step
		goto 39.1,57.6 |n
		.' Go inside the blue glowing orb |goto 38.8,58.6,0.3 |noway |c
	step
		goto 44.3,48.0
		.talk Aviana##41308
		..turnin Return to Aviana##25832	
	step
		goto 27.1,62.6
		.talk Arch Druid Hamuul Runetotem##5769
		..turnin Hell's Shells##25507
		..accept Tortolla Speaks##25510
	step
		goto 27.1,63.0
		.talk Rayne Feathersong##40331
		..turnin Prepping the Soil##25502
	step
		goto 24.7,55.7
		.talk Tortolla##41504
		..turnin Tortolla Speaks##25510
		..accept Breaking the Bonds##25514
		..accept Children of Tortolla##25519
	step
		goto 24.0,55.9
		.' Click the Rod of Subjugation |tip It's a huge metal rod with an orange spinning ball on top of it.
		.' Disable the First Rod of Subjugation |q 25514/1
	step
		goto 25.2,54.9
		.' Click the Rod of Subjugation |tip It's a huge metal rod with an orange spinning ball on top of it.
		.' Disable the Second Rod of Subjugation |q 25514/2
	step
		goto 24.7,55.7
		.talk Tortolla##41504
		..turnin Breaking the Bonds##25514
	step
		goto 24.8,57.1
		.from Deep Corruptor##40561+
		.' Save 6 Tortolla's Eggs |q 25519/1
	step
		goto 24.7,55.7
		.talk Tortolla##41504
		..turnin Children of Tortolla##25519
		..accept An Ancient Awakens##25520
	step
		goto 27.1,62.6
		.talk Arch Druid Hamuul Runetotem##5769
		..turnin An Ancient Awakens##25520
	step
		goto 27.0,62.7
		.talk Vision of Ysera##46998
		..accept The Last Living Lorekeeper##25830	
	step
		goto 27.4,55.5
		.talk Nordu##41381
		..turnin The Last Living Lorekeeper##25830
		..accept Firefight##25842
	step
		goto 26.6,53.2
		.kill 5 Fiery Tormentor |q 25842/1
	step
		goto 27.4,55.5
		.talk Nordu##41381
		..turnin Firefight##25842
		..accept Aessina's Miracle##25372
	step
		goto 19.5,37.8
		.talk Arch Druid Hamuul Runetotem##5769
		..turnin Aessina's Miracle##25372
]])

ZygorGuidesViewer:RegisterInclude("Kaluak_Rep",[[
	step
		goto Borean Tundra 54.3,36.1
		.talk Etaruk##25292
		..accept Reclaiming the Quarry##11612
	step
		goto 54.7,35.8
		.' Talk to Elder Atkanok 
		..accept The Honored Ancestors##11605
		'|model Elder Atkanok##7633
	step
		goto 52.8,34
		.click "Elder Sagani"##7655 
		.' Identify the Elder Sagani |q 11605/2
	step
		goto 52.3,31.2
		.click "Elder Takret"##7655 
		.' Identify the Elder Takret |q 11605/3
	step
		goto 50.9,32.4
		.click "Elder Kesuk"##7655
		.' Identify the Elder Kesuk |q 11605/1
	step
		goto 54.4,35.1
		.kill 12 Beryl Treasure Hunter##25353+ |q 11612/1
	step
		goto 54.7,35.8
		.' Talk to Elder Atkanok
		..turnin The Honored Ancestors##11605
		..accept The Lost Spirits##11607
		'|model Elder Atkanok##7633
	step
		goto 54.3,36.1
		.talk Etaruk##25292
		..turnin Reclaiming the Quarry##11612
		..accept Hampering Their Escape##11617
	step
		goto 51.5,31.4
		.kill Beryl Hound##25355+ |n
		.get 6 Cores of Malice|n
		.' Use the Cores of Malice on Kaskala Craftsmen and Kaskala Shaman |use Core of Malice##34711
		.' Free 3 Kaskala Craftsman spirits |q 11607/1
		.' Free 3 Kaskala Shaman spirits |q 11607/2
		.from Beryl Reclaimer##25449+
		.collect 3 Gnomish Grenade##34772|q 11617
	step
		goto 52.2,32.1
		.' Use your Gnomish Grenade while standing under the floating platform |use Gnomish Grenade##34772 |tip If you can fly, you can stand on the floating platform and use your Gnomish Grenade.
		.' Destroy the North Platform |q 11617/2
	step
		goto 51,33.9
		.' Use your Gnomish Grenade while standing under the floating platform |use Gnomish Grenade##34772 |tip If you can fly, you can stand on the floating platform and use your Gnomish Grenade.
		.' Destroy the West Platform |q 11617/3
	step
		goto 52.8,34.5
		.' Use your Gnomish Grenade while standing under the floating platform |use Gnomish Grenade##34772 |tip If you can fly, you can stand on the floating platform and use your Gnomish Grenade.
		.' Destroy the East Platform |q 11617/1
	step
		goto 54.7,35.8
		.' Talk to Elder Atkanok
		..turnin The Lost Spirits##11607
		..accept Picking Up the Pieces##11609
		'|model Elder Atkanok##7633
	step
		goto 54.3,36.1
		.talk Etaruk##25292
		..turnin Hampering Their Escape##11617
		..accept A Visit to the Curator##11623
	step
		goto 53.1,33.3
		.click Tuskarr Ritual Object##7472+ 
		.get 6 Tuskarr Ritual Object|q 11609/1
	step
		goto 50.1,32.6
		.kill Curator Insivius##25448 |q 11623/1
	step
		goto 54.7,35.8
		.' Talk to Elder Atkanok
		..turnin Picking Up the Pieces##11609
		..accept Leading the Ancestors Home##11610
		'|model Elder Atkanok##7633
	step
		goto 54.3,36.1
		.talk Etaruk##25292
		..turnin A Visit to the Curator##11623
	step
		goto 52.8,34
		.' Use your Tuskarr Ritual Object while standing next to the Elder Sagani |use Tuskarr Ritual Object##34715 |tip It looks like 2 small totem pole things at the base of the big stone on the huge bone cart.
		.' Complete Elder Sagani's ceremony |q 11610/2
		|model "Elder Saganai"##7655
	step
		goto 52.3,31.2
		.' Use your Tuskarr Ritual Object while standing next to the Elder Takret |use Tuskarr Ritual Object##34715 |tip It looks like 2 small totem pole things at the base of the big stone on the huge bone cart.
		.' Complete Elder Takret's ceremony |q 11610/3
		|model "Elder Takret"##7655
	step
		goto 50.9,32.4
		.' Use your Tuskarr Ritual Object while standing next to the Elder Kesuk |use Tuskarr Ritual Object##34715 |tip It looks like 2 small totem pole things at the base of the big stone on the huge bone cart.
		.' Complete Elder Kesuk's ceremony |q 11610/1
		|model "Elder Kesuk"##7655
	step
		goto 54.7,35.8
		..' Talk to Elder Atkanok
		..turnin Leading the Ancestors Home##11610
		'|model Elder Atkanok##7633
		step
		goto 32.3,54.3
		.talk Waltor of Pal'ea##25476
		..accept Into the Mist##11655
		..accept Horn of the Ancient Mariner##11660
	step
		goto 30.4,53.5
		.from Kvaldir Mist Lord##25496, Kvaldir Mistweaver##25479+
		.get 8 Tuskarr Relic |q 11655/1
		.get Horn of the Ancient Mariner |q 11660/1
	step
		goto 32.2,54.1
		.talk Gorge the Corpsegrinder##25329
		..turnin Tanks a lot...##11651
		..accept The Plains of Nasam##11652
	step
		goto 32.3,54.3
		.talk Waltor of Pal'ea##25476
		..turnin Into the Mist##11655
		..accept Burn in Effigy##11656
		..turnin Horn of the Ancient Mariner##11660
		..accept Orabus the Helmsman##11661
	step
		goto 29.8,52.6
		.' Stand at the front of the ship
		.' Use your Tuskarr Torch|use Tuskarr Torch##34830
		.' Destroy Bor's Hammer |q 11656/3
	step
		goto 31,49
		.' Stand at the front of the ship
		.' Use your Tuskarr Torch|use Tuskarr Torch##34830
		.' Destroy The Kur Drakkar |q 11656/2
	step
		goto 31.7,48.3
		.' Stand at the front of the ship
		.' Use your Tuskarr Torch|use Tuskarr Torch##34830
		.' Destroy The Serpent's Maw |q 11656/1
	step
		goto 26.8,54.7
		.' Stand at the very edge of the rocks
		.' Use your Horn of the Ancient Mariner|use Horn of the Ancient Mariner##34844
		.kill Orabus the Helmsman##32576 |q 11661/1
	step
		goto 30.1,61.7
		.' Stand at the front of the ship
		.' Use your Tuskarr Torch|use Tuskarr Torch##34830
		.' Destroy Bor's Anvil |q 11656/4
	step
		goto 32.3,54.3
		.talk Waltor of Pal'ea##25476
		..turnin Burn in Effigy##11656
		..turnin Orabus the Helmsman##11661
		..accept Seek Out Karuk!##11662
	step
		goto 47.1,75.5
		.talk Karuk##25435
		.turnin Seek Out Karuk!##11662
		..accept Karuk's Oath##11613
	step
		goto 46.5,77.2
		.kill 6 Skadir Raider##25522+ |q 11613/1
		.kill 5 Skadir Longboatsman##25521+ |q 11613/2
	step
		goto 44.2,77.8
		.'Kill the Riplash Myrmidon and cheering Skadir mobs
		.talk Captured Tuskarr Prisoner##25636
		..accept Cruelty of the Kvaldir##12471
	step
		goto 47.1,75.5
		.talk Karuk##25435
		..turnin Karuk's Oath##11613
		..accept Gamel the Cruel##11619
		..turnin Cruelty of the Kvaldir##12471
	step
		'Go inside the cave to 46.4,78.2|goto 46.4,78.2
		.kill Gamel the Cruel##26449 |q 11619/1
	step
		goto 47.1,75.5
		.talk Karuk##25435
		..turnin Gamel the Cruel##11619
		..accept A Father's Words##11620
	step
		goto 43.6,80.5
		.talk Veehja##25450
		..turnin A Father's Words##11620
		..accept The Trident of Naz'jan##11625
	step
		'Go into the big building to 54.7,89.1|goto 54.7,89.1
		.from Ragnar Drakkarlund##26451
		.get Trident of Naz'jan|q 11625/1
	step
		goto 43.6,80.5
		.talk Veehja##25450
		..turnin The Trident of Naz'jan##11625
		..accept The Emissary##11626
	step
		goto 52.2,88.2
		.' Swim underwater to the bubbling rock at the very bottom, so you don't run out of air
		.' Use your Trident of Naz'jan on Leviroth|use Trident of Naz'jan##35850
		.kill Leviroth##26452 |q 11626/1
	step
		goto 47.1,75.5
		.talk Karuk##25435
		..turnin The Emissary##11626
	step
		goto 63.8,46.1
		.talk Ataika##26169
		..accept Not Without a Fight!##11949
	step
		goto 64,45.7
		.talk Utaik##26213
		..accept Preparing for the Worst##11945
	step
		goto 65.3,47.2
		.kill 12 Kvaldir Raider##25760+ |q 11949/1
		.click Kaskala Supplies##644
		.get 8 Kaskala Supplies |q 11945/1
	step
		goto 63.8,46.1
		.talk Ataika##26169
		..turnin Not Without a Fight!##11949
		..accept Muahit's Wisdom##11950
	step
		goto 64,45.7
		.talk Utaik##26213
		..turnin Preparing for the Worst##11945 
	step
		goto 67.2,54.9
		.talk Elder Muahit##26218
		..turnin Muahit's Wisdom##11950
		..accept Spirits Watch Over Us##11961
	step
		goto 67.6,50.4
		.talk Iruk##26219
		.' <Search corpse for Issliruk's Totem>
		.get Issliruk's Totem |q 11961/1
	step
		goto 67.2,54.9
		.talk Elder Muahit##26218
		..turnin Spirits Watch Over Us##11961
		..accept The Tides Turn##11968
	step
		goto 67.6,56.6
		.kill Heigarr the Horrible##26266 |q 11968/1
	step
		goto 67.2,54.8
		.talk Elder Muahit##26218
		..turnin The Tides Turn##11968
	step
		goto Howling Fjord,40.3,60.3
		.talk Orfus of Kamagua##23804
		..accept The Dead Rise!##11504
	step
		goto 57.7,77.5
		.' Click the Mound of Debris|tip It looks like a pile of dirt in the bottom of this small pit, next to a skeleton.
		.get Fengir's Clue|q 11504/1
	step
		goto 59.2,77
		.' Click the Unlocked Chest|tip It looks like a small chest in the bottom of this small pit, next to a skeleton.
		.get Rodin's Clue|q 11504/2
	step
		goto 59.8,79.4
		.' Click the Long Tail Feather|tip It's a small blue feather sitting on a circular shield in this pit, on top of a skeleton.
		.get Isuldof's Clue|q 11504/3
	step
		goto 62,80
		.' Click the Cannonball|tip It looks like a big round grey ball sitting in the dirt in this pit, between a skeleton's legs.
		.get Windan's Clue|q 11504/4
	step
		goto 40.3,60.3
		.talk Orfus of Kamagua##23804
		..turnin The Dead Rise!##11504
		..accept Elder Atuik and Kamagua##11507
	step
		'Go across The Ancient Lift to 25.0,57.0|goto 25.0,57.0
		.talk Elder Atuik##24755
		..turnin Elder Atuik and Kamagua##11507
		..accept Grezzix Spindlesnap##11508
		..accept Feeding the Survivors##11456
	step
		goto 29.1,58.8
		.kill Island Shoveltusk##24681+ |n
		.get 6 Island Shoveltusk Meat|q 11456/1
	step
		goto 25.0,57.0
		.talk Elder Atuik##24755
		..turnin Feeding the Survivors##11456
		..accept Arming Kamagua##11457
	step
		goto 26.4,62.9
		.from Frostwing Chimaera##24673
		.get 3 Chimaera Horn|q 11457/1
	step
		goto 25.0,57.0
		.talk Elder Atuik##24755
		..turnin Arming Kamagua##11457
		..accept Avenge Iskaal##11458
	step
		goto 23.1,62.7
		.talk Grezzix Spindlesnap##24643
		..turnin Grezzix Spindlesnap##11508
		..accept Street "Cred"##11509
	step
		goto 35.1,80.9
		'Talk to "Silvermoon" Harry##24539
		..turnin Street "Cred"##11509
		..accept "Scoodles"##11510
	step
		goto 35.6,80.2
		.talk Handsome Terry##24537
		..accept Forgotten Treasure##11434
	step
		goto 37.8,79.6
		.talk Scuttle Frostprow##24784
		..accept Swabbin' Soap##11469
	step
		goto 38.3,83.4
		.from "Scoodles"##24899
		.get Sin'dorei Scrying Crystal|q 11510/1
	step
		goto 37.8,84.6
		.click the Eagle Figurine##6925 |tip It's a blue eagle statue inside this ship on the middle floor.
		.get Eagle Figurine|q 11434/2
	step
		goto 37.1,85.5
		.click the Amani Vase##7495 |tip It looks like a grey vase at the bottom of this wrecked ship.
		.get Amani Vase|q 11434/1
	step
		goto 31.4,77.9
		.from Big Roy##24785
		.get Big Roy's Blubber|q 11469/1
	step
		goto 35.1,80.9
		.talk "Silvermoon" Harry##24539
		..turnin "Scoodles"##11510
		..accept The Ancient Armor of the Kvaldir##11567
		..accept The Frozen Heart of Isuldof##11512
		..accept The Lost Shield of the Aesirites##11519
		..accept The Staff of Storm's Fury##11511
	step
		goto 35.6,80.2
		.talk Handsome Terry##24537
		..turnin Forgotten Treasure##11434
		..accept The Fragrance of Money##11455
	step
		goto 36.3,80.5
		.talk Taruk##24541
		..accept Gambling Debt##11464
	step
		goto 37.7,79.6
		.talk Scuttle Frostprow##24784
		..turnin Swabbin' Soap##11469
	step
		goto 35.1,81.0
		.talk "Silvermoon" Harry##24539
		.' Tell him:
		.' Taruk sent me to collect what you owe.>
		.from "Silvermoon" Harry##24539
		.' After he submits to you
		.' <Pay up, Harry!>
		.' Collect "Silvermoon" Harry's Debt |q 11464/1
	step
		goto 36.3,80.5
		.talk Taruk##24541
		..turnin Gambling Debt##11464
		..accept Jack Likes His Drink##11466
	step
		goto 35.3,79.6
		.talk Olga, the Scalawag Wench##24639
		.' Tell her:
		.' <I'd like to buy Jack a drink.>
		.' She will walk over to Jack Adams
		|confirm |q 11466
	step
		goto 35.5,79.4
		.clicknpc Jack Adams##24788
		.' Discretely search the pirate's pockets for Taruk's payment.>
		.get Jack Adams' Debt |q 11466/1
	step
		goto 36.3,80.5
		.talk Taruk##24541
		..turnin Jack Likes His Drink##11466
		..accept Dead Man's Debt##11467
	step
		goto 35.4,78.1
		.from Rabid Brown Bear##24633+
		.get 4 Bear Musk |q 11455/1
	step
		goto 33.6,75.6 |n
		.' Enter the Cave here |goto 33.6,75.6,0.5 |noway |c |q 11512
	step
		goto 33.8,78.0
		.from "Mad" Jonah Sterling##24742
		.' After you beat him, he will jump down
		|confirm |q 11512
	step
		goto 33.7,79.2 |n
		.' Run down the ramp here |goto 33.7,79.2,0.5 |noway |c |q 11512
	step
		goto 32.3,78.7
		.click The Frozen Heart of Isuldof##7554
		.get The Frozen Heart of Isuldof |q 11512/1
	step
		'Leave the cave and go to 33.2,63.9|goto 33.2,63.9
		.kill 8 Crazed Northsea Slaver##24676+ |q 11458/1
	step
		goto 37.2,74.8
		.talk Captain Ellis##24910
		..turnin The Lost Shield of the Aesirites##11519
		..accept Mutiny on the Mercy##11527
	step
		'Go downstairs in the ship
		.kill Mutinous Sea Dog##25026+ |n
		.get 5 Barrel of Blasting Powder|q 11527/1
	step
		'Go upstairs to the ship deck
		.talk Captain Ellis##24910
		..turnin Mutiny on the Mercy##11527
		..accept Sorlof's Booty##11529
	step
		'Run to the other end of the ship deck to the big cannon
		.clicknpc The Big Gun##24992
		.' Keep clicking The Big Gun until Sorlof is dead
		.' Sorlof will drop a big pile of gold on the shore
		.' Jump off the ship and click Sorlof's Booty
		.get Sorlof's Booty|q 11529/1
	step
		goto 37.2,74.8
		.talk Captain Ellis##24910
		..turnin Sorlof's Booty##11529
		..accept The Shield of the Aesirites##11530
	step
		goto 35.3,64.8
		.' At the bottom of the ship. If you are careful, you can avoid _Abdul the Insane_
		.click The Staff of Storm's Fury##1708
		.get The Staff of Storm's Fury |q 11511/1
	step
		goto 32.7,60.2
		.click Dirt Mound##20
		.from Black Conrad's Ghost##24790+
		.get Black Conrad's Treasure |q 11467/1
	step
		goto 25.0,57.0
		.talk Elder Atuik##24755
		..turnin Avenge Iskaal##11458
	step
		goto 36.3,80.5
		.talk Taruk##24541
		..turnin Dead Man's Debt##11467
	step
		goto 35.6,80.2
		.talk Handsome Terry##24537
		..turnin The Fragrance of Money##11455
	step
		goto 81.8,73.9
		.click The Ancient Armor of the Kvaldir##7624
		.get The Ancient Armor of the Kvaldir |q 11567/1
	step
		'Ride the big lift to the top of the cliff and go to 40.3,60.3|goto 40.3,60.3
		.talk Orfus of Kamagua##23804
		..turnin The Ancient Armor of the Kvaldir##11567
		..turnin The Frozen Heart of Isuldof##11512
		..turnin The Shield of the Aesirites##11530
		..turnin The Staff of Storm's Fury##11511
		..accept A Return to Resting##11568
	step
		goto 57.6,77.4
		.' Use your Bundle of Vrykul Artifacts while standing near the skeleton|use Bundle of Vrykul Artifacts##34624
		.' Return the Shield of Aesirites |q 11568/1
	step
		goto 59.2,77
		.' Use your Bundle of Vrykul Artifacts while standing near the skeleton|use Bundle of Vrykul Artifacts##34624
		.' Return the Staff of Storm's Fury |q 11568/2
	step
		goto 59.8,79.4
		.' Use your Bundle of Vrykul Artifacts while standing near the skeleton.|use Bundle of Vrykul Artifacts##34624
		.' Return the Frozen Heart of Isuldof |q 11568/3
	step
		goto 62,80
		.' Use your Bundle of Vrykul Artifacts while standing near the skeleton.|use Bundle of Vrykul Artifacts##34624
		.' Return the Ancient Armor of the Kvaldir |q 11568/4
	step
		goto 40.3,60.3
		.talk Orfus of Kamagua##23804
		..turnin A Return to Resting##11568
		..accept Return to Atuik##11572
	step
		'Go across the Ancient Lift to 25.0,57.0|goto 25.0,57.0
		.talk Elder Atuik##24755
		..turnin Return to Atuik##11572
	step
		goto Dragonblight 48,74.9
		.talk Elder Ko'nani##26194
		..accept Let Nothing Go To Waste##11958
	step
		goto Dragonblight 48.3,74.3
		.talk Trapper Mau'i##26228
		..accept Planning for the Future##11960
	step
		goto 45.3,63.7
		.from Snowfall Glade Reaver##26197, Snowfall Glade Wolvar##26198, Snowfall Glade Shaman##26201, Snowfall Glade Den Mother##26199
		.get 6 Stolen Moa'ki Goods|q 11958/1
		.clicknpc Snowfall Glade Pup##26200
		.get 12 Snowfall Glade Pup|q 11960/1
	step
		goto 48.3,74.3
		.talk Trapper Mau'i##26228
		..turnin Planning for the Future##11960
	step
		goto 48,74.9
		.talk Elder Ko'nani##26194
		..turnin Let Nothing Go To Waste##11958
		..accept Slay Loguhn##11959
	step
		goto 46.3,59.2
		.from Loguhn##26196
		.get Blood of Loguhn|n
		.' Click the Blood of Loguhn in your bags|use Blood of Loguhn##35688
		.' Smear the Blood of Loguhn on yourself |q 11959/1
	step
		goto 48,74.9
		.talk Elder Ko'nani##26194
		..turnin Slay Loguhn##11959
	step
		goto 49.2,75.6
		.talk Toalu'u the Mystic##26595
		..accept Spiritual Insight##12028
	step
		goto 48.9,75.8
		.' Use Toalu'u's Spiritual Incense next to Toalu'u's Brazier|use Toalu'u's Spiritual Incense##35907|tip Sitting next to the entrance to the small house.
		.' Watch yourself fly as a wisp
		.' Attain Spiritual Insight concerning Indu'le Village |q 12028/1
	step
		goto 49.2,75.6
		.talk Toalu'u the Mystic##26595
		..turnin Spiritual Insight##12028
		..accept Elder Mana'loa##12030
	step
		goto 47.7,76.6
		.talk Tua'kea##26245
		..accept Tua'kea's Crab Traps##12009
	step
		goto 46.6,77.5
		.' Click Tua'kea's Crab Traps|tip They look like small cages on the ground underwater around this area.
		.get 8 Tua'kea Crab Trap|q 12009/1
	step
		goto 47.7,80
		.' Click the Wrecked Crab Trap|tip It looks like a broken version of Tue'kea's Crab Traps, on the ground underwater.
		..accept Signs of Big Watery Trouble##12011
	step
		goto 47.7,76.6
		.talk Tua'kea##26245
		..turnin Tua'kea's Crab Traps##12009
		..turnin Signs of Big Watery Trouble##12011
		..accept The Bait##12016
	step
		goto 43.7,82.3
		.from Kili'ua##26521
		.get The Flesh of "Two Huge Pincers"|q 12016/1
	step
		goto 47.7,76.6
		.talk Tua'kea##26245
		..turnin The Bait##12016
		..accept Meat on the Hook##12017
	step
		goto 46.7,78.2
		.' Use Tu'u'gwar's Bait next to Tua'kea's Fishing Hook|use Tu'u'gwar's Bait##35838|tip It looks like a rope leading into the water, with a big hook on the end.
		.' Kill Tu'u'gwar when he comes|kill 1 Tu'u'gwar|q 12017/1
	step
		goto 47.7,76.6
		.talk Tua'kea##26245
		..turnin Meat on the Hook##12017
	step
		goto 36.4,65
		'Talk to Elder Mana'loa |model Elder Mana'loa##7768 
		..turnin Elder Mana'loa##12030
		..accept Freedom for the Lingering##12031
	step
		goto 37.2,65.5
		.from Indu'le Mystic##26336, Indu'le Warrior##26344
		.' Put 15 Indu'le spirits to rest |q 12031/1
	step
		goto 36.4,65
		'Talk to Elder Mana'loa |model Elder Mana'loa##7768 
		..turnin Freedom for the Lingering##12031
		..accept Conversing With the Depths##12032
	step
		goto 34.3,79.8|n
		.' The path up to Conversing With the Depths starts here|goto Dragonblight,34.3,79.8,0.5|noway|c |q 12032
	step
		'Follow the path up to 34,83.4|goto 34,83.4
		.' Click The Pearl of the Depths|tip It's a big white pearl sitting on a altar thing.
		.' Oacha'noa appears and tells you to jump in the water
		.' Jump in the water when he tells you to
		.' Obey Oacha'noa's compulsion |q 12032/1
	step
		goto 49.2,75.6
		.talk Toalu'u the Mystic##26595
		..turnin Conversing With the Depths##12032
	step
		.' Once you've completed all of the quests above, you can now do the daily quests.
		.' Reach exalted with The Kalu'ak |next "exalted" |only if rep("Kalu'ak")==Exalted
		|confirm |next |only if default
//borean//
	step
	label "daily"
		goto Borean Tundra,64,45.7
		.talk Utaik##26213
		..accept Preparing for the Worst##11945
	step
		goto 65.3,47.2
		.click Kaskala Supplies##644
		.get 8 Kaskala Supplies |q 11945/1
	step
		goto 64,45.7
		.talk Utaik##26213
		..turnin Preparing for the Worst##11945
//dragon//
	step
		goto Dragonblight,48.3,74.3
		.talk Trapper Mau'i##26228
		..accept Planning for the Future##11960
	step
		goto 45.3,63.7
		.clicknpc Snowfall Glade Pup##26200
		.get 12 Snowfall Glade Pup |q 11960/1
	step
		goto 48.3,74.3
		.talk Trapper Mau'i##26228
		..turnin Planning for the Future##11960
//howling//
	step
		goto Howling Fjord 24.6,58.9
		.talk Anuniaq##24810
		..accept The Way to His Heart...##11472
	step
		goto 28.9,74.8
		.' Use Anuniaq's Net on the Schools of Tasty Reef Fish|use Anuniaq's Net##40946|tip They look like swarms of fish in the water.
		.kill Great Reef Shark##24637+ |n
		.collect 10 Tasty Reef Fish##34127|q 11472
	step
		goto 31,74.4
		.' Use your Tasty Reef Fish on a Reef Bull as far away as you can|use Tasty Reef Fish##34127
		.' He will come to the spot where you're standing
		.' Keep doing this
		.' Lead the Reef Bull to a Reef Cow on the other side of the water |q 11472/1
	step
		goto 24.6,58.9
		.talk Anuniaq##24810
		..turnin The Way to His Heart...##11472
	step
		'You have reached the end of the dailies for today.
		.' To go back to the beginning of this guide, click here. |next "daily" |confirm |only if default
		.' Earn Exalted reputation with the Kalu'ak |next "exalted" |only if rep("Kalu'ak")==Exalted
]])

ZygorGuidesViewer:RegisterInclude("H_Hodir_Q",[[
	step
		goto The Storm Peaks,41,86.4
		.talk Jeer Sparksocket##29431
		..turnin Luxurious Getaway!##12853
		..accept Clean Up##12818
	step
		goto The Storm Peaks 41.1,85.9
		.talk Smilin' Slirk Brassknob##29904
		.home K3
	step
		goto 41.1,86.1
		.talk Gretchen Fizzlespark##29473 |tip She's inside the inn.
		..accept They Took Our Men!##12843
		..accept Equipment Recovery##12844
	step
		goto 40.9,85.3
		.talk Ricket##29428
		..accept Reclaimed Rations##12827
		..accept Expression of Gratitude##12836
	step
		goto 40.8,84.5
		.talk Skizzle Slickslide##29721
		..fpath K3
	step
		goto 39.8,86.4
		.click Charred Wreckage##6866
		.get 10 Charred Wreckage|q 12818/1
	step
		goto 35,83.8
		.from Savage Hill Scavenger##29404+, Savage Hill Brute##29623+
		.click Dried Gnoll Rations##335
		.get 16 Dried Gnoll Rations|q 12827/1
	step
		goto 30.3,85.7
		.kill Gnarlhide##30003|q 12836/1
	step
		goto 41,86.4
		.talk Jeer Sparksocket##29431
		..turnin Clean Up##12818
		..accept Just Around the Corner##12819
	step
		goto 40.9,85.3
		.talk Ricket##29428
		..turnin Reclaimed Rations##12827
		..turnin Expression of Gratitude##12836
		..accept Ample Inspiration##12828
	step
		goto 35.1,87.8
		.click Sparksocket's Tools##1209
		.get Sparksocket's Tools|q 12819/1
	step
		goto 41,86.4
		.talk Jeer Sparksocket##29431
		..turnin Just Around the Corner##12819
		..accept Slightly Unstable##12826
	step
		goto 40.9,85.3
		.talk Ricket##29428
		..turnin Slightly Unstable##12826
		..accept A Delicate Touch##12820
	step
		goto 43.1,81.2
		.' Use your Improved Land Mines to place mines on the ground close to each other|use Improved Land Mines##40676|tip Garm Invaders and Snowblind Followers will run over the mines and die.
		.kill 12 Garm Attackers|q 12820/1
		'|modelnpc 29619
		'|modelnpc 29618
	step
		goto 41.7,80
		.talk Tore Rumblewrench##29430
		..accept Moving In##12829
		..accept Ore Repossession##12830
	step
		goto 41.7,80
		.click the U.D.E.D. Dispenser##2029
		.' Retrieve a bomb from the dispenser
		.collect U.D.E.D.##40686|q 12828
	step
		'Go to [43.9,79.0] quickly
		.' Use your U.D.E.D. on an Ironwool Mammoth|use U.D.E.D.##40686|tip They walk around this area spread out.
		.click  Mammoth Meat##2951
		.get 8 Hearty Mammoth Meat|q 12828/1
	step
		goto The Storm Peaks 40.5,78.2
		.' Go into the cave |goto 40.4,77.8 |noway|c
	step
		goto 41.5,74.9
		.talk Injured Goblin Miner##29434
		..accept Only Partly Forgotten##12831
	step
		goto 44,75.9
		.kill Snowblind Diggers##29413 |n
		.get 5 Impure Saronite Ore|q 12830/1
	step
		goto 47.1,72.3
		.from Icetip Crawler##29461
		.get 1 Icetip Venom Sac|q 12831/1
	step
		goto 44,75.9
		.kill 12 Crystalweb Spiders |q 12829/1
		'|modelnpc 29412
	step
		goto 43.5,75.2
		.talk Injured Goblin Miner##29434
		..turnin Only Partly Forgotten##12831
		..accept Bitter Departure##12832
	step
		goto 43.5,75.2
		.talk Injured Goblin Miner##29434
		..'Tell the miner you're ready
		.' Escort the Injured Goblin Miner to K3 |q 12832/1
	step
		'Fly up to [39.8,73.3]
		.kill Sifreldar Storm Maiden##29323+ |n
		.collect 5 Cold Iron Key##40641|n
		.click Rusty Cage##7469+
		.' Free 5 Goblin Prisoners |q 12843/1
		.click K3 Equipment##335
		.get 8 K3 Equipment |q 12844/1
	step
		goto 41.7,80
		.talk Tore Rumblewrench##29430
		..turnin Moving In##12829
		..turnin Ore Repossession##12830
	step
		goto 40.9,85.3
		.talk Ricket##29428
		..turnin A Delicate Touch##12820
		..turnin Ample Inspiration##12828
		..turnin Bitter Departure##12832
		..accept Opening the Backdoor##12821
	step
		goto 41.1,86.1
		.talk Gretchen Fizzlespark##29473
		..turnin They Took Our Men!##12843
		..accept Leave No Goblin Behind##12846
		..turnin Equipment Recovery##12844
	step
		goto 45.1,82.4
		.click Transporter Power Cell##8099
		.get Transporter Power Cell|q 12821/1
	step
		goto 50.7,81.9
		.' Use your Transporter Power Cell next to the Teleportation Pad|use Transporter Power Cell##40731|tip It looks like a tall machine with a fan in the bottom of it.
		.' Activate the Garm Teleporter |q 12821/2
	step
		goto 40.9,85.3
		.talk Ricket##29428
		..turnin Opening the Backdoor##12821
		..accept Know No Fear##12822
	step
		goto 50.0,81.8
		.talk Gino##29432
		..accept A Flawless Plan##12823
	step
		'Go inside the cave to [50.5,77.8]
		.' Use your Hardpacked Explosive Bundle next to Frostgut's Altar|use Hardpacked Explosive Bundle##41431|tip It's a stone altar with a bunch of melted red candles on it.  Follow the path in the cave that spirals up all the way to the top of the cave to find it.
		.kill Tormar Frostgut##29626 |q 12823/2
	step
		goto 48.1,81.9
		.kill 6 Garm Watcher##29409+ |q 12822/1
		.kill 8 Snowblind Devotee##29407+ |q 12822/2
	step
		'Go outside and go to [50.0,81.8]
		.talk Gino##29432
		..turnin A Flawless Plan##12823
		..accept Demolitionist Extraordinaire##12824
	step
		Fly up into the cave to [42.8,68.9]
		.talk Lok'lira the Crone##29481
		..turnin Leave No Goblin Behind##12846
		..accept The Crone's Bargain##12841
	step
		goto 44.2,68.9
		.from Overseer Syra##29518
		.get 1 Runes of the Yrkvinn|q 12841/1
	step
		goto 42.8,68.9
		.talk Lok'lira the Crone##29481
		..turnin The Crone's Bargain##12841
		..accept Mildred the Cruel##12905
	step
		goto 44.4,68.9
		.talk Mildred the Cruel##29885
		..turnin Mildred the Cruel##12905
		..accept Discipline##12906
	step
		goto 44.8,70.3
		.' Use your Disciplining Rod on Exhausted Vrykul|use Disciplining Rod##42837|tip They are sitting on the ground inside these side tunnels inside this mine.
		.' Discipline 6 Exhausted Vrykul |q 12906/1
		'|modelnpc 30146
	step
		goto 44.4,68.9
		.talk Mildred the Cruel##29885
		..turnin Discipline##12906
		..accept Examples to be Made##12907
	step
		goto 45.4,69.1
		.kill 1 Garhal##30147 |q 12907/1
	step
		goto 44.4,68.9
		.talk Mildred the Cruel##29885
		..turnin Examples to be Made##12907
		..accept A Certain Prisoner##12908
	step
		goto 42.8,68.9
		.talk Lok'lira the Crone##29481
		..turnin A Certain Prisoner##12908
		..accept A Change of Scenery##12921
	step
		.' Follow the path in the mine east out to the other side to [47.5,69.1]
		.talk Lok'lira the Crone##29975
		..turnin A Change of Scenery##12921
		..accept Is That Your Goblin?##12969
	step
		goto 48.2,69.8
		.talk Agnetta Tyrsdottar##30154
		.' Tell her to skip the warmup
		.kill Agnetta Tyrsdottar##30154 |q 12969/1
	step
		goto 47.5,69.1
		.talk Lok'lira the Crone##29975
		..turnin Is That Your Goblin?##12969
		..accept The Hyldsmeet##12970
	step
		goto 47.5,69.1
		.talk Lok'lira the Crone##29975
		..'Ask her about her proposal
		.' Listen to Lok'lira's proposal |q 12970/1
	step
		goto 47.5,69.1
		.talk Lok'lira the Crone##29975
		..turnin The Hyldsmeet##12970
		..accept Taking on All Challengers##12971
	step
		goto 51,66.4
		.talk Victorious Challenger##30012
		.kill 6 Victorious Challenger##30012+ |q 12971/1
	step
		goto 47.5,69.1
		.talk Lok'lira the Crone##29975
		..turnin Taking on All Challengers##12971
		..accept You'll Need a Bear##12972
	step
		goto 48.4,72.1
		.talk Iva the Vengeful##29997
		..accept Off With Their Black Wings##12942
		..accept Yulda's Folly##12968
	step
		goto 48.4,72.1
		.talk Thyra Kvinnshal##30041
		..accept Aberrations##12925
	step
		goto 53.1,65.7
		.talk Brijana##29592
		..turnin You'll Need a Bear##12972
		..accept Going Bearback##12851
	step
		goto 53.1,65.7
		.clicknpc Icefang##29598
		.' While riding Icefang, use the Flaming Arrow ability on your hotbar to shoot arrows at the Frostworgs and Frost Giants|petaction Flaming Arrow
		.' Burn 7 Frostworgs |q 12851/1
		.' Burn 15 Frost Giants |q 12851/2
		'|modelnpc 29358
		'|modelnpc 29351
	step
		goto 53.1,65.7
		.talk Brijana##29592
		..turnin Going Bearback##12851
		..accept Cold Hearted##12856
	step
		'Fly to 63.9,62.5|goto 63.9,62.5
		.clicknpc Captive Proto-Drake##29708
		.' Use your Ice Shard ability on the Brunnhildar Prisoners|petaction Ice Shard|tip The Brunnhildar Prisoners look like blue blocks of ice around this area on the ground.
		.' When your Proto-Drake is holding 3 Brunnhildar Prisoners, start flying toward Brunnhildar Village at [The Storm Peaks 59.9,61.2], the drake will eventually go on autopilot.  Repeat this process 2 more times.
		.' Rescue 9 Brunnhildar Prisoners |q 12856/1
		.' Free 3 Proto-Drakes |q 12856/2
		'|modelnpc 29639
	step
		goto 53.1,65.7
		.talk Brijana##29592
		..turnin Cold Hearted##12856
		..accept Deemed Worthy##13063
	step
		goto 49.7,71.8
		.talk Astrid Bjornrittar##29839
		..turnin Deemed Worthy##13063
		..accept Making a Harness##12900
	step
		goto 47.9,74.7
		.kill Icemane Yeti##29875+|n
		.get 3 Icemane Yeti Hide|q 12900/1
	step
		goto 49.7,71.8
		.talk Astrid Bjornrittar##29839
		..turnin Making a Harness##12900
		..accept The Last of Her Kind##12983
		..accept The Slithering Darkness##12989
	step
		goto 55.8,63.9
		.kill 8 Ravenous Jormungar##29605+ |q 12989/1 |tip They are inside the cave.
	step
		goto 54.8,60.4
		.clicknpc Injured Icemaw Matriarch##29563
		.' The bear runs back to Brunnhildar Village
		.' Rescue the Icemaw Matriarch |q 12983/1
	step
		goto 49.7,71.8
		.talk Astrid Bjornrittar##29839
		..turnin The Last of Her Kind##12983
		..accept The Warm-Up##12996
		..turnin The Slithering Darkness##12989
	step
		'Use your Reins of the Warbear Matriarch outside the building to ride a bear|invehicle|c|use Reins of the Warbear Matriarch##42481
	step
		goto 50.8,67.7
		.' Use the abilities on your hotbar to fight Kirgaraak|tip He's a big white yeti.
		.' Defeat Kirgaraak |q 12996/1
		'|modelnpc 29352
	step
		'Click the red arrow to get off the bear|script VehicleExit()|outvehicle|c
	step
		goto 49.7,71.8
		.talk Astrid Bjornrittar##29839
		..turnin The Warm-Up##12996
		..accept Into the Pit##12997
	step
		goto 49.1,69.4
		.' Use your Reins of the Warbear Matriarch inside The Pit of the Fang to ride a bear|use Reins of the Warbear Matriarch##42499
		.' Use the abilities on your hotbar to fight Hyldsmeet Warbears
		.kill 6 Hyldsmeet Warbear##30174+ |q 12997/1
	step
		'Click the red arrow to get off the bear|script VehicleExit()|outvehicle|c
	step
		goto 49.7,71.8
		.talk Astrid Bjornrittar##29839
		..turnin Into the Pit##12997
		..accept Prepare for Glory##13061
	step
		goto 47.5,69.1
		.talk Lok'lira the Crone##29975
		..turnin Prepare for Glory##13061
		..accept Lok'lira's Parting Gift##13062
	step
		goto 50.9,65.6
		.talk Gretta the Arbiter##29796
		..turnin Lok'lira's Parting Gift##13062
		..accept The Drakkensryd##12886
	step
		'You fly off on a drake and start flying in circles around a tower:
		.' Use your Hyldnir Harpoon in your bags on Hyldsmeet Proto-Drakes to harpoon over to a new drake|use Hyldnir Harpoon##41058
		.kill Hyldsmeet Drakerider##29694+ |n
		.' Repeat this process 9 more times
		.' Defeat 10 Hyldsmeet Drakeriders  |q 12886/1
	step
		'They look like light fixtures on the side of the stone columns.
		.' Use your Hyldnir Harpoon in your bags on a Column Ornament to get off the drake|outvehicle|c|use Hyldnir Harpoon##41058
	step
		goto 33.4,58
		.talk Thorim##29445
		..turnin The Drakkensryd##12886
		..accept Sibling Rivalry##13064
	step
		goto 33.4,58
		.talk Thorim##29445
		..'Ask him what became of Sif
		.' Hear Thorim's History |q 13064/1
	step
		goto 33.4,58
		.talk Thorim##29445
		..turnin Sibling Rivalry##13064
		..accept Mending Fences##12915
	step
		goto 27.3,63.7
		.kill 12 Nascent Val'kyr##29570+ |q 12942/1
		.kill Valkyrion Aspirant##29569+ |n
		.collect 6 Vial of Frost Oil##41612|q 12925
	step
		goto 23.7,58.3
		.' Use your Vials of Frost Oil on the Plagued Proto-Drake Eggs|use Vial of Frost Oil##41612|tip They look like brown spiked eggs sitting in the yellow water around this area.
		.' Try to get 6 at a time
		.' Destroy 30 Plagued Proto-Drake Eggs |q 12925/1
		'|model 3891 
	step
		goto 24,61.8
		.kill Yulda the Stormspeaker##30046 |q 12968/1
		.click Harpoon Crate##8217
		..accept Valkyrion Must Burn##12953
	step
		goto 26,59.8
		.clicknpc Valkyrion Harpoon Gun##30066
		.' Use the Flaming Harpoon ability on your hotbar to shoot the tan bundles of straw near buildings and in wagons around this area|petaction Flaming Harpoon
		.' Start 6 Fires |q 12953/1
	step
		'Click the red arrow to get off the gun|script VehicleExit()|outvehicle|c
	step
		goto 40.9,85.3
		.talk Ricket##29428
		..turnin Demolitionist Extraordinaire##12824
		..turnin Know No Fear##12822
		..accept Overstock##12833
	step
		goto 43.1,81.2
		.' Use your Improved Land Mines to place mines on the ground close to each other|use Improved Land Mines##40676|tip Garm Invaders and Snowblind Followers will run over the mines and die.
		.kill 12 Garm Invader|q 12833/1
		'|modelnpc 29619
		'|modelnpc 29618
	step
		goto 40.9,85.3
		.talk Ricket##29428
		..turnin Overstock##12833
	step
		goto 48.4,72.1
		.talk Thyra Kvinnshal##30041
		..turnin Aberrations##12925
	step
		goto 48.4,72.1
		.talk Iva the Vengeful##29997
		..turnin Off With Their Black Wings##12942
		..turnin Yulda's Folly##12968
		..turnin Valkyrion Must Burn##12953
	step
		goto 75.8,63
		.click Granite Boulder##7750+
		.' Use Thorim's Charm of Earth on the Stormforged Iron Giants|use Thorim's Charm of Earth##41505
		.' Help the dwarves kill them
		.kill 5 Stormforged Iron Giant##29375+  |q 12915/2
		.collect Slag Covered Metal##41556 |q 12922 |future |n
		.use Slag Covered Metal##41556
		..accept The Refiner's Fire##12922
	step
		goto 75.4,63.5
		.from Seething Revenant##29504+
		.get 10 Furious Spark|q 12922/1
	step
		goto 77.2,62.9
		.click Granite Boulder##7750 
		.' Use Thorim's Charm of Earth on Fjorn|use Thorim's Charm of Earth##41505|tip He's a huge fire giant, holding a huge smithing hammer.
		.' Help the dwarves kill him
		.kill Fjorn##29503 |q 12915/1
	step
		goto 77.2,62.9
		.click Fjorn's Anvil##7481
		..turnin The Refiner's Fire##12922
		..accept A Spark of Hope##12956
	step
		goto 33.4,58
		.talk Thorim##29445
		..turnin A Spark of Hope##12956
		..turnin Mending Fences##12915
		..accept Forging an Alliance##12924
	step
		goto 62.6,60.9
		.talk Halvdan##32571
		..fpath Dun Niffelem
	step
		goto 65.4,60.2
		.talk King Jokkum##30105
		..accept You Can't Miss Him##12966
	step
		goto 75.4,63.6
		.talk Njormeld##30099
		..turnin You Can't Miss Him##12966
		..accept Battling the Elements##12967		
	step
		goto 75.7,63.9
		.clicknpc Snorri##30123 |invehicle |c
		.' Use the Gather Snow ability on your hotbar to gather snow from Snowdrifts|petaction Gather Snow|tip The Snowdrifts look like piles of snow on the ground.
		.' Use the Throw Snowball ability on your hotbar to throw the snow at Seething Revenants|petaction Throw Snowball
		.kill 10 Seething Revenant##29504+ |q 12967/1
	step
		'Click the red arrow on your hotbar to leave Snorri|script VehicleExit()|outvehicle|c
	step
		goto 75.4,63.6
		.talk Njormeld##30099
		..turnin Battling the Elements##12967
	step
		goto 63.2,63.2
		.talk Njormeld##30127
		..turnin Forging an Alliance##12924
		..accept A New Beginning##13009
	step
		goto 63.2,62.9
		.click Fjorn's Anvil##7481
		..accept Hot and Cold##12981
	step
		goto 65.4,60.2
		.talk King Jokkum##30105
		..accept In Memoriam##12975
	step
		goto 69.7,60.2
		.kill Brittle Revenant##30160+ |n
		.collect 6 Essence of Ice##42246 |q 12981
	step
		goto 75.3,62.8
		.' Use your Essences of Ice next to Smoldering Scraps|use Essence of Ice##42246
		.click  Frozen Iron Scrap##8231+
		.get 6 Frozen Iron Scrap|q 12981/1
	step
		goto 72.1,49.4
		.click Horn Fragment##8222+
		.get 8 Horn Fragment|q 12975/1
	step
		goto 65.4,60.2
		.talk King Jokkum##30105
		..turnin In Memoriam##12975
		..accept A Monument to the Fallen##12976
	step
		goto 63.2,63.2
		.talk Njormeld##30127
		..turnin A Monument to the Fallen##12976
	step
		goto 63.2,62.9
		.click Fjorn's Anvil##7481+
		..turnin Hot and Cold##12981
	step
		goto 64.1,65.1
		.click Hodir's Horn##7352
		..accept Blowing Hodir's Horn##12977
	step
		goto 72.1,51.8
		.from Niffelem Forefather##29974+, Restless Frostborn Ghost##30144+
		.' Use Hodir's Horn on their corpses|use Hodir's Horn##42164
		.' Free 5 Niffelem Forefathers |q 12977/1
		.' Free 5 Restless Frostborn |q 12977/2
	step
		goto 64.1,65.1
		.click Hodir's Horn##7352
		..turnin Blowing Hodir's Horn##12977
	step
		goto 63.2,63.2
		.talk Njormeld##30127
		..accept Forging a Head##12985
	step
		goto 65.4,60.2
		.talk King Jokkum##30105
		..accept Jormuttar is Soo Fat...##13011
	step
		goto 69.7,58.9
		.' Use your Diamond Tipped Pick on Dead Iron Giants|use Diamond Tipped Pick##42424
		.kill Stormforged Ambusher##30208+ |n
		.get 8 Stormforged Eye|q 12985/1
	step
		goto 63.2,63.2
		.talk Njormeld##30127
		..turnin Forging a Head##12985
		..accept Mounting Hodir's Helm##12987
	step
		goto 64.3,59.2
		.' Fly to the tip of this ice spike
		.' Use the Tablets of Pronouncement in your bags|use Tablets of Pronouncement##42442
		.' Mount Hodir's Helm |q 12987/1
	step
		goto 63.2,63.2
		.talk Njormeld##30127
		..turnin Mounting Hodir's Helm##12987
	step
		goto 64.2,59.2
		.click Hodir's Helm##8221+
		..accept Polishing the Helm##13006
	step
		goto 55.6,63.4
		.kill Viscous Oil##30325+ |n
		.get 5 Viscous Oil|q 13006/1
		.' Use your Everfrost Razor on Dead Icemaw Bears|use Everfrost Razor##42732
		.collect 1 Icemaw Bear Flank##42733|q 13011
		'|modelnpc 30292
	step
		goto 54.7,60.8
		.' Follow the path inside the cave to this spot
		.' Use your Icemaw Bear Flank while standing on the small frozen pond with a bunch of rocks on it|use Icemaw Bear Flank##42733
		.kill 1 Jormuttar##30340 |q 13011/1
	step
		goto 33.4,58
		.talk Thorim##29445
		..turnin A New Beginning##13009
		..accept Veranus##13050
	step
		goto 43.7,67.4
		.click Small Proto-Drake Egg##7398+
		.get 5 Small Proto-Drake Egg|q 13050/1
		.' You can find more Small Proto-Drake Eggs at [45.2,66.9] |n
	step
		goto 33.4,58
		.talk Thorim##29445
		..turnin Veranus##13050
		..accept Territorial Trespass##13051
	step
		goto 38.7,65.6
		.' Stand in this big nest
		.' Use the Stolen Proto-Dragon Eggs in your bags |use Stolen Proto-Dragon Eggs##42797
		.' Lure Veranus |q 13051/1
	step
		goto 33.4,58
		.talk Thorim##29445
		..turnin Territorial Trespass##13051
		..accept Krolmir, Hammer of Storms##13010
	step
		goto 64.2,59.2
		.click Hodir's Helm##8221
		..turnin Polishing the Helm##13006
	step
		goto 65.4,60.2
		.talk King Jokkum##30105
		..turnin Jormuttar is Soo Fat...##13011
	step
		goto 65.4,60.2
		.talk King Jokkum##30105
		..'Ask him what has become of Krolmir
		.' Discover Krolmir's Fate |q 13010/1
	step
		goto 71.4,48.8
		.talk Thorim##30390
		..turnin Krolmir, Hammer of Storms##13010
		..accept The Terrace of the Makers##13057
	step
		goto 56.3,51.4
		.talk Thorim##30295
		..turnin The Terrace of the Makers##13057
		..accept The Earthen Oath##13005
		..accept Loken's Lackeys##13035
	step
		goto 57.3,46.7
		.' Use your Horn of the Peaks to summon earthen helpers|use Horn of the Peaks##42840
		.' Fight mobs around this area
		.kill 7 Iron Sentinel##29984+ |q 13005/1
		.kill 20 Iron Dwarf Assailant##29978+ |q 13005/2
	step
		goto 55.3,43.3
		.' Use your Horn of the Peaks to summon earthen helpers|use Horn of the Peaks##42840
		.kill Eisenfaust##30341 |q 13035/1
	step
		goto 48.6,45.6
		.' Use your Horn of the Peaks to summon earthen helpers|use Horn of the Peaks##42840
		.kill Halefnir the Windborn##30376 |q 13035/2
	step
		goto 45,38.1
		.' Use your Horn of the Peaks to summon earthen helpers|use Horn of the Peaks##42840
		.kill Duronn the Runewrought##30353 |q 13035/3
	step
		goto 56.3,51.4
		.talk Thorim##30295
		..turnin The Earthen Oath##13005
		..turnin Loken's Lackeys##13035
		..accept The Reckoning##13047
	step
		goto 35.9,31.5
		.talk Thorim##30399
		..'Tell him you are with him
		.' Witness the Reckoning |q 13047/1
	step
		goto 65.4,60.2
		.talk King Jokkum##30105
		..turnin The Reckoning##13047
	step
		goto 40.9,85.3
		.talk Ricket##29428
		..accept When All Else Fails##13060
	step
		goto 40.9,85.3
		.talk Ricket##29428
		..'Tell her you are ready to head further into Storm Peaks
		.'You will fly to Grom'arsh Crash Site |goto 36.8,49.6 |noway |c
	step
		goto The Storm Peaks 37.0,49.6
		.talk Olut Alegut##30472
		..turnin When All Else Fails##13060
	step
		goto The Storm Peaks 37.3,49.7
		.talk Boktar Bloodfury##29651
		..accept The Missing Bronzebeard##12895
	step
		goto 29.5,74.1
		.talk Archaeologist Andorin##29650
		..accept On Brann's Trail##12854
	step
		goto The Storm Peaks 37.1,49.5
		.talk Peon Gakra##29944
		.home Grom'arsh Crash-Site
	step
		goto The Storm Peaks 36.5,49.1
		.talk Blood Guard Lorga##30247
		..accept Emergency Measures##13000
		..accept The Missing Tracker##13054
	step
		goto The Storm Peaks 36.1,64.1
		.click Disturbed Snow
		..get Burlap-Wrapped Note |q 12895/1
		|modeidisplay 5333
	step
		goto The Storm Peaks 47.0,54.9 |n
		.' Enter the cave here |goto The Storm Peaks 47.0,54.9 |noway |c
	step
		goto The Storm Peaks 48.5,54.3
		.talk Tracker Val'zij##30469
		..turnin The Missing Tracker##13054
		..accept Cave Medicine##13055
	step
		goto The Storm Peaks 49.3,52.8
		.click Cave Mushroom
		..get 8 Cave Mushroom |q 13055/1
		|modeldisplay 2090
	step
		goto The Storm Peaks 48.5,47.5
		.from Cavedweller Worg##30164+
		..get 6 Worg Fur |q 13000/1
		.from Infesting Jormungar##30148+
		..get Toxin Gland |q 13055/2
	step
		goto The Storm Peaks 48.5,54.3
		.talk Tracker Val'zij##30469
		..turnin Cave Medicine##13055
		..accept There's Always Time for Revenge##13056
	step
		goto The Storm Peaks 48.9,46.7
		.kill Gimorak##30167 |q 13056/1
	step
		goto The Storm Peaks 48.5,54.3
		.talk Tracker Val'zij##30469
		..turnin There's Always Time for Revenge##13056
	step
		goto The Storm Peaks 37.3,49.7
		.talk Boktar Bloodfury##29651
		..turnin The Missing Bronzebeard##12895
		..accept The Nose Knows##12909
	step
		goto The Storm Peaks 36.4,49.1
		.talk Blood Guard Lorga##30247
		..turnin Emergency Measures##13000
	step
		goto The Storm Peaks 40.8,51.2
		.talk Khaliisi##29855
		..turnin The Nose Knows##12909
		..accept Sniffing Out the Perpetrator##12910
	step
		goto The Storm Peaks 40.8,51.2
		.clicknpc Frostbite##29857
		.' Use the abilities on your hotbar to slow down the _Steamforged Pursuers_.
		.' Ride Frostbite until you reach the end of the scent trail. |q 12910/1
	step
		goto The Storm Peaks 48.5,60.8
		.from Tracker Thulin##29695+ |q 12910/2
		..collect Brann's Communicator##40971
	step
		'Use Brann's Communicator in your bags. |use Brann's Communicator##40971
		.talk Brann Bronzebeard##29579
		..turnin Sniffing Out the Perpetrator##12910
		..accept Speak Orcish, Man!##12913
	step
		goto The Storm Peaks 37.3,49.7
		.talk Moteha Windborn##29937
		..turnin Speak Orcish, Man!##12913
		..accept Speaking with the Wind's Voice##12917
	step
		goto The Storm Peaks 27.1,42.0
		.from Stormrider##29624+
		..get 5 Voice of the Wind |q 12917/1
	step
		goto The Storm Peaks 37.3,49.7
		.talk Moteha Windborn##29937
		..turnin Speaking with the Wind's Voice##12917
	step
		goto The Storm Peaks 37.3,49.7
		.talk Boktar Bloodfury##29651
		..accept Catching up with Brann##12920
	step
		'Use Brann's Communicator in your bags. |use Brann's Communicator##40971
		.talk Brann Bronzebeard##29579
		. ' Ask him if he can understand you. |q 12920/1
	step
		goto The Storm Peaks 37.3,49.7
		.talk Boktar Bloodfury##29651
		..turnin Catching up with Brann##12920
		..accept Pieces of the Puzzle##12926
	step
		goto The Storm Peaks 37.6,43.5
		.kill Library Guardian##29724 |n
		.collect 6 Inventor's Disk Fragment##41130 |n
		.' Click the Inventor's Disk Fragments in your bags to combine them |use Inventor's Disk Fragment##41130
		.get The Inventor's Disk |q 12926/1
	step
		'Use Brann's Communicator in your bags |use Brann's Communicator##40971
		.talk Brann Bronzebeard##29579
		..turnin Pieces of the Puzzle##12926
		..accept Data Mining##12927
	step
		goto 38.5,44.2
		.' Use The Inventor's Disk on Databanks |use The Inventor's Disk##41179 |tip They look like floating round star things.
		.' Gather 7 Hidden Data |q 12927/1
		'|modelnpc 29746
	step
		'Use Brann's Communicator in your bags. |use Brann's Communicator##40971
		.talk Brann Bronzebeard##29579
		..turnin Data Mining##12927
		..accept The Library Console##13416
	step
		goto The Storm Peaks 37.4,46.8
		.click Inventor's Library Console##8177
		..turnin The Library Console##13416
		..accept Norgannon's Shell##12928
	step
		goto The Storm Peaks 37.4,46.8
		'Click the Charged Disk in your bags |use Charged Disk##44704
		.from Archivist Mechaton##29775
		.get Norgannon's Shell |q 12928/1
	step
		'Use Brann's Communicator in your bags. |use Brann's Communicator##40971
		.talk Brann Bronzebeard##29579
		..turnin Norgannon's Shell##12928
		..accept Going After the Core##13273
		..accept The Earthen of Ulduar##12929
	step
		goto The Storm Peaks 59.2,51.5
		.click Prospector Soren's Maps
		..get Prospector Soren's Maps |q 13273/2
		|modeldisplay 222
	step
		goto The Storm Peaks 59.8,52.6
		.click Prospector Khrona's Notes
		..get Prospector Khrona's Notes |q 13273/1
		|modeldisplay 5851
	step
		'Use Brann's Communicator in your bags. |use Brann's Communicator##40971
		.talk Brann Bronzebeard##29579
		..turnin Going After the Core##13273
		..accept The Core's Keeper##13274
	step
		goto The Storm Peaks 56.5,58.5 |n
		.' Enter Loken's Bargain here |goto The Storm Peaks 56.5,58.5 |noway |c
	step
		goto The Storm Peaks 56.3,52.3
		.from Athan##31798+
		..get Norgannon's Core |q 13274/1
	step
		'Use Brann's Communicator in your bags. |use Brann's Communicator##40971
		.talk Brann Bronzebeard##29579
		..turnin The Core's Keeper##13274
		..accept Forging the Keystone##13285
	step
		goto The Storm Peaks 56.5,58.5 |n
		.' Leave Loken's Bargain here |goto The Storm Peaks 56.5,58.5 |noway |c
	step
		goto The Storm Peaks 45.5,49.5
		.talk Brann Bronzebeard##29579
		.' Tell him you're ready to make the keystone.
		.' Help Brann create the keystone |q 13285/1
	step
		goto The Storm Peaks 37.3,49.7
		.talk Boktar Bloodfury##29651
		..turnin Forging the Keystone##13285
	step
		goto The Storm Peaks 30.6,36.9 |n
		.' Enter the building here |goto The Storm Peaks 30.6,36.9 |noway |c
	step
		goto 30.6,36.3
		.talk Breck Rockbrow##29950
		..fpath Bouldercrag's Refuge
	step
		goto The Storm Peaks 31.4,38.0
		.talk Bouldercrag the Rockshaper##29801
		..turnin The Earthen of Ulduar##12929
		..accept Rare Earth##12930
	step
		goto The Storm Peaks 26.3,66.7
		.from Stormforged Pillager##29586+, Stormforged Loreseeker##29843+
		.get 5 Frostweave Cloth|q 12930/2
	step
		goto The Storm Peaks 28.3,29.4
		.click Enchanted Earth##8194 |tip They're all over the mountain's side
		.get 7 Enchanted Earth|q 12930/1
	step
		goto Icecrown 46.5,49.3
		.from Scourge Banner-Bearer##31900+
		.from Converted Hero##32255+
		..collect 5 Frostweave Cloth##33470 |q 12930/2
	step
		goto The Storm Peaks 31.4,38.0
		.talk Bouldercrag the Rockshaper##29801
		..turnin Rare Earth##12930
		..accept Fighting Back##12931
		..accept Relief for the Fallen##12937
	step
		goto The Storm Peaks 28.3,36.8
		.' Use your Telluric Poultice on _Fallen Earthen Defenders_ in this area. |use Telluric Poultice##41988
		.' Heal 8 Fallen Earthen Defenders |q 12937/1
		|modelnpc Fallen Earthen Defender##30035
	step
		goto The Storm Peaks 28.3,37.4
		.from Stormforged Reaver##29382+, Stormforged Raider##29377+
		.' Kill 10 Steamforged Attackers |q 12931/1
	step
		goto The Storm Peaks 31.4,38.0
		.talk Bouldercrag the Rockshaper##29801
		..turnin Fighting Back##12931
		..turnin Relief for the Fallen##12937
		..accept Slaves of the Stormforged##12957
		..accept The Dark Ore##12964
	step
		goto The Storm Peaks 27.4,49.8 |n
		.' Enter the cave here |goto The Storm Peaks 27.4,49.8 |noway |c
	step
		goto The Storm Peaks 27.2,50.3
		.click Ore Cart
		.get Dark 5 Ore Sample |q 12964/1
		.talk Captive Mechagnome##29384
		.' Attempt to free Captive Mechagnome |q 12957/1
		|modeldisplay Ore Cart##28291
	step
		goto The Storm Peaks 31.4,38.0
		.talk Captive Mechagnome##29384
		..turnin Slaves of the Stormforged##12957
		..turnin The Dark Ore##12964
		..accept The Gifts of Loken##12965
	step
		goto The Storm Peaks 24.0,42.6
		.click Loken's Fury
		.' Destroy Loken's Fury |q 12965/1
		|modeldisplay Loken's Fury##8224
	step
		goto The Storm Peaks 26.2,47.7
		.click Loken's Power
		.' Destroy Loken's Power |q 12965/2
		|modeldisplay Loken's Power##8224
	step
		goto The Storm Peaks 24.6,48.4
		.click Loken's Favor
		.' Destroy Loken's Favor |q 12965/3
		|modeldisplay Loken's Favor##8224
	step
		goto The Storm Peaks 31.4,38.0
		.talk Bouldercrag the Rockshaper##29801
		..turnin The Gifts of Loken##12965
	step
		goto The Storm Peaks 31.3,38.1
		.talk Bruor Ironbane##30152
		..accept Facing the Storm##12978
	step
		goto The Storm Peaks 24.7,42.7
		.from Stormforged War Golem##29380+, Stormforged Magus##29374+, Stormforged Champion##29370+
		.' Kill 10 Nidavelir Stormforged |q 12978/1
		.collect 1 Dark Armor Plate##42203 |n
		.' Click the Dark Armor Plate in your bags |use Dark Armor Plate##42203
		..accept Armor of Darkness##12979
	step
		goto The Storm Peaks 24.7,42.7
		.from Stormforged War Golem##29380+
		.get 4 Dark Armor Sample##42204 |q 12979/1
	step
		goto The Storm Peaks 31.3,38.1
		.talk Bruor Ironbane##30152
		..turnin Facing the Storm##12978
		..turnin Armor of Darkness##12979
		..accept The Armor's Secrets##12980
	step
		goto The Storm Peaks 33.6,39.6 |n
		.' Enter Mimir's Workshop here |goto The Storm Peaks 33.6,39.6 |noway |c
	step
		goto The Storm Peaks 32.1,40.7
		.talk Attendant Tock##30190
		.' Ask him to tell him more about the armor plate. |q 12980/1
	step
		goto The Storm Peaks 31.3,38.1
		.talk Bruor Ironbane##30152
		..turnin The Armor's Secrets##12980
	step
		goto The Storm Peaks 31.4,38.0
		.talk Bouldercrag the Rockshaper##29801
		..accept Valduran the Stormborn##12984
	step
		goto The Storm Peaks 24.4,52.1
		.' Use Bouldercrag's Warhorn in this spot |use Bouldercrag's War Horn##42419
		.from Valduran the Stormborn##29368+ |q 12984/1
	step
		goto The Storm Peaks 31.4,38.0
		.talk Bouldercrag the Rockshaper##29801
		..turnin Valduran the Stormborn##12984
		..accept Destroy the Forges!##12988
	step
		goto The Storm Peaks 31.3,38.1
		.talk Bruor Ironbane##30152
		..accept Hit Them Where it Hurts##12991
	step
		goto The Storm Peaks 29.0,45.9
		.' Use Bouldercrag's Bomb next to the Lightning Forge here. |use Bouldercrag's Bomb##42441
		.' Damage the North Lightning Forge |q 12988/1
	step
		goto The Storm Peaks 29.6,45.9
		.' Use Bouldercrag's Bomb next to the Lightning Forge here. |use Bouldercrag's Bomb##42441
		.' Damage the Central Lightning Forge |q 12988/2
	step
		goto The Storm Peaks 30.2,46.1
		.' Use Bouldercrag's Bomb next to the Lightning Forge here. |use Bouldercrag's Bomb##42441
		.' Damage the Central Lightning Forge |q 12988/3
	step
		goto The Storm Peaks 29.3,46.0
		.from Stormforged Artificer##29376+ |q 12991/1
	step
		goto The Storm Peaks 31.3,38.1
		.talk Bruor Ironbane##30152
		..turnin Hit Them Where it Hurts##12991
	step
		goto The Storm Peaks 31.4,38.0
		.talk Bouldercrag the Rockshaper##29801
		..turnin Destroy the Forges!##12988
		..accept A Colossal Threat##12993
	step
		goto The Storm Peaks 29.9,45.9
		.click Colossus Defense Specs
		..get Colossus Defense Specs |q 12993/2
		|modeldisplay 210
	step
		goto The Storm Peaks 28.9,44.1
		.click Colossus Attack Specs
		..get Colossus Attack Specs |q 12993/1
		|modeldisplay 210
	step
		goto The Storm Peaks 31.4,38.0
		.talk Bouldercrag the Rockshaper##29801
		..turnin A Colossal Threat##12993
		..accept The Heart of the Storm##12998
	step
		goto The Storm Peaks 32.4,63.6 |n
		.' Enter Uldis here |goto The Storm Peaks 32.4,63.6 |noway |c
	step
		goto The Storm Peaks 36.1,60.9
		.click The Heart of the Storm
		. 'Attempt to secure the Heart of the Swarm |q 12998/1
		|modeldisplay 7800
	step
		goto The Storm Peaks 31.4,38.0
		.talk Bouldercrag the Rockshaper##29801
		..turnin The Heart of the Storm##12998
		..accept The Iron Colossus##13007
	step
		goto The Storm Peaks 27.2,35.9
		.' Click the shining orb in front of you to take control of a _Tamed Jormungar_.
		|modelnpc Tamed Jormungar##30301
		|confirm
	step
		goto The Storm Peaks 27.3,45.7
		.' Use the abilities on your hotbar to kill the Iron Colossus.
		.from Iron Colossus##30300+ |q 13007/1
	step
		goto The Storm Peaks 31.4,38.0
		.talk Bouldercrag the Rockshaper##29801
		..turnin The Iron Colossus##13007
]])

ZygorGuidesViewer:RegisterInclude("H_Hodir",[[
//DAILY//
	step
	label "Daily"
		goto The Storm Peaks,64.2,59.2
		.click Hodir's Helm##8221
		..accept Polishing the Helm##13006
	step
		goto The Storm Peaks,64.8,59.1
		.talk Lorekeeper Randvir##30252
		..accept Raising Hodir's Spear##13001
		only if rep ('The Sons of Hodir')>=Honored
	step
		goto 63.2,62.9
		.click Fjorn's Anvil##7481
		..accept Hot and Cold##12981
	step
		goto 64.1,65.1
		.click Hodir's Horn##7352 
		..accept Blowing Hodir's Horn##12977
	step
		goto 55.6,63.4
		.from Viscous Oil##30325+
		.get 5 Viscous Oil |q 13006/1
	step
		goto 59.0,61.2
		.from Stoic Mammoth##30260+
		..get 3 Stoic Mammoth Hide |q 13001/2
		only if rep ('The Sons of Hodir')>=Honored
	step
		'The entrance to the cave starts here |goto 55.9,64.2,0.5 |c
		only if rep ('The Sons of Hodir')>=Honored
	step
		goto 54.7,60.8
		.click Everfrost Shard##8247+
		.get 3 Everfrost Shard |q 13001/1
		only if rep ('The Sons of Hodir')>=Honored
	step
		'Leave the cave |goto 55.9,64.2,0.5 |c
		only if rep ('The Sons of Hodir')>=Honored
	step
		goto 64.8,59.1
		.talk Lorekeeper Randvir##30252
		..turnin Raising Hodir's Spear##13001 |tip This quest will unlock the Thrusting Hodir's Spear daily quest.
		only if rep ('The Sons of Hodir')>=Honored
	step
		goto 64.2,59.2
		.click Hodir's Helm##8221 
		..turnin Polishing the Helm##13006
	step
		goto 69.7,60.2
		.from Brittle Revenant##30160+
		.collect 6 Essence of Ice##42246 |q 12981
	step
		goto 75.3,62.8
		.' Use your Essences of Ice next to Smoldering Scraps |use Essence of Ice##42246 |tip The Smoldering Scraps look like small smoking pieces of metal on the ground around this area.
		.click Frozen Iron Scrap##8231+
		.get 6 Frozen Iron Scrap |q 12981/1
	step
		goto 72.1,51.8
		.from Niffelem Forefather##29974+, Restless Frostborn Ghost##30144+
		.' Use Hodir's Horn on their corpses |use Hodir's Horn##42164
		.' Free 5 Niffelem Forefathers |q 12977/1
		.' Free 5 Restless Frostborn |q 12977/2
	step
		goto 67.0,45.1
		.' If you want to grind mobs for Relics of Ulduar, or buy them on the Auction House, to turn in for The Sons of Hodir reputation, this is an awesome spot, as these mobs drop the Relics of Ulduar frequently.  You get 650 The Sons of Hodir reputation for every 10 Relics of Ulduar you collect.  If you don't want to do this, skip this step.
		.from Scion of Storm##30184+ |tip They are air elementals all around inside this big cave.
		.' You can also buy the Relics of Ulduar on the Auction House, if you'd like to get the reputation much faster.
		.collect Relic of Ulduar##42780+|n |tip You turn these in in multiples of 10.
		|confirm
	step
		goto 63.2,62.9
		.click Fjorn's Anvil##7481
		..turnin Hot and Cold##12981
	step
		goto 64.1,65.1
		.click Hodir's Horn##7352 
		..turnin Blowing Hodir's Horn##12977
	step
		goto 66.2,61.4
		.talk Lillehoff##32540
		..accept Hodir's Tribute##13559 |tip This is a repeatable quest.  Turn in all of your Relics of Ulduar.
	step
		.' Click here to reset the daily quests. |confirm |next "Daily" |only if rep('The Sons of Hodir')<=Friendly
		' Become honored with The Sons of Hodir |condition rep('The Sons of Hodir')>=Honored |next "Daily2"
	step
	label "Daily2"
		goto The Storm Peaks,63.5,59.8
		.talk Frostworg Denmother##30294
		..accept Spy Hunter##12994
	step
		goto 64.2,59.2
		.click Hodir's Helm##8221 
		..accept Polishing the Helm##13006
	step
		goto 65.1,60.8
		.click Hodir's Spear##8220 
		..accept Thrusting Hodir's Spear##13003
	step
		goto 63.2,62.9
		.click Fjorn's Anvil##7481
		..accept Hot and Cold##12981
	step
		goto 64.1,65.1
		.click Hodir's Horn##7352
		..accept Blowing Hodir's Horn##12977
	step
		goto 57.2,64.0
		.' Use your Ethereal Worg's Fang next to the Corpse of the Fallen Worg |use Ethereal Worg's Fang##42479
		.' Follow the wolf that spawns and kill the Stormforged Infiltrator it finds
		.' Repeat this process 2 more times
		.' Kill 3 Stormforged Infiltrators |q 12994/1	
	step
		goto 55.6,63.4
		.from Viscous Oil##30325+ |tip They look like slimes inside this cave.
		.get 5 Viscous Oil |q 13006/1
	step
		goto 56.6,64.3
		.' Use the Spear of Hodir on a Wild Wyrm flying around in the sky |use Spear of Hodir##42769
		.' While fighting the Wild Wyrm, there will be 2 phases to the fight.  Phase 1: |tip In phase 1 of the fight, you will be underneath the Wild Wyrm.  Use your Grab On ability to keep your grip high, or you will fall off and die.  Repeatedly use your Thrust Spear ability, until you get a message the Wild Wyrm is about to use its claw attack.  When you see that message, use your Dodge Claws ability, and then immediately use your Mighty Spear Thrust ability after that.  Remember to keep your grip up by using your Grab On ability, and repeat this process until phase 2 of the fight begins.
		.' In phase 2 of the fight with the Wild Wyrm, the strategy changes: |tip In phase 2 of the fight, you will be inside the Wild Wyrm's mouth.  Repeatedly use your Pry Jaws Open ability, try to stack it 20 times.  After you stack your Pry Jaws ability 20 times (which will give your Fatal Strike ability 100% chance to hit), use your Fatal Strike ability to kill the Wild Wyrm.  If you are close to dying, just stack your Pry Jaws Open ability as many times as you can, then use your Fatal Strike ability before you die, and hope it kills the Wild Wyrm.  
		.' Kill the Wild Wyrm |q 13003/1	
	step
		goto 63.5,59.8
		.talk Frostworg Denmother##30294
		..turnin Spy Hunter##12994
	step
		goto 64.2,59.2
		.click Hodir's Helm##8221 
		..turnin Polishing the Helm##13006
	step
		goto 65.1,60.8
		.click Hodir's Spear##8220 
		..turnin Thrusting Hodir's Spear##13003
	step
		goto 69.7,60.2
		.from Brittle Revenant##30160+
		.collect 6 Essence of Ice##42246 |q 12981
	step
		goto 75.3,62.8
		.' Use your Essences of Ice next to Smoldering Scraps |use Essence of Ice##42246 |tip The Smoldering Scraps look like small smoking pieces of metal on the ground around this area.
		.' Click the Frozen Iron Scraps
		.get 6 Frozen Iron Scrap |q 12981/1
	step
		goto 72.1,51.8
		.from Niffelem Forefather##29974+, Restless Frostborn Ghost##30144+
		.' Use Hodir's Horn on their corpses |use Hodir's Horn##42164
		.' Free 5 Niffelem Forefathers |q 12977/1
		.' Free 5 Restless Frostborn |q 12977/2
	step
		goto 67.0,45.1
		.' If you want to grind mobs for Relics of Ulduar, or buy them on the Auction House, to turn in for The Sons of Hodir reputation, this is an awesome spot, as these mobs drop the Relics of Ulduar frequently.  You get 650 The Sons of Hodir reputation for every 10 Relics of Ulduar you collect.  If you don't want to do this, skip this step.
		.from Scion of Storm##30184+ |tip They are air elementals all around inside this big cave.
		.' You can also buy the Relics of Ulduar on the Auction House, if you'd like to get the reputation much faster.
		.collect Relic of Ulduar##42780+|n |tip You turn these in in multiples of 10.
		|confirm
	step
		goto 63.2,62.9
		.click Fjorn's Anvil##7481
		..turnin Hot and Cold##12981
	step
		goto 64.1,65.1
		.click Hodir's Horn##7352
		..turnin Blowing Hodir's Horn##12977
	step
		goto 66.2,61.4
		.talk Lillehoff##32540
		..accept Hodir's Tribute##13559 |tip This is a repeatable quest.  Turn in all of your Relics of Ulduar.
	step
		.' In order to repeat these daily quests, click here to reset the daillies. |confirm |next "Daily2" |only if rep('The Sons of Hodir')<=Honored
		' Become Revered with The Sons of Hodir |condition rep('The Sons of Hodir')>=Revered |next "Daily3"
	step
	label "Daily3"
		goto The Storm Peaks,63.5,59.8
		.talk Frostworg Denmother##30294
		..accept Spy Hunter##12994
	step
		goto 64.2,59.2
		.click Hodir's Helm##8221 
		..accept Polishing the Helm##13006
	step
		goto 65.1,60.8
		.click Hodir's Spear##8220 
		..accept Thrusting Hodir's Spear##13003
	step
		goto 67.6,59.9
		.click Arngrim the Insatiable##8284
		..accept Feeding Arngrim##13046
	step
		goto 63.2,62.9
		.click Fjorn's Anvil##7481
		..accept Hot and Cold##12981
	step
		goto 64.1,65.1
		.click Hodir's Horn##7352
		..accept Blowing Hodir's Horn##12977
	step
		goto 57.2,64.0
		.' Use your Ethereal Worg's Fang next to the Corpse of the Fallen Worg |use Ethereal Worg's Fang##42479
		.' Follow the wolf that spawns and kill the Stormforged Infiltrator it finds
		.' Repeat this process 2 more times
		.' Kill 3 Stormforged Infiltrators |q 12994/1	
	step
		goto 56.4,65.0
		.' Use Arngrim's Tooth on Roaming Jormungars |use Arngrim's Tooth##42774
		.' Fight Disembodied Jormungars until Arngrim the Insatiable comes to eat them
		.' Feed Arngrim's Spirit 5 Times |q 13046/1
	step
		goto 55.6,63.4
		.from Viscous Oil##30325+ |tip They look like slimes inside this cave.
		.get 5 Viscous Oil |q 13006/1
	step
		goto 56.6,64.3
		.' Use the Spear of Hodir on a Wild Wyrm flying around in the sky |use Spear of Hodir##42769
		.' While fighting the Wild Wyrm, there will be 2 phases to the fight.  Phase 1: |tip In phase 1 of the fight, you will be underneath the Wild Wyrm.  Use your Grab On ability to keep your grip high, or you will fall off and die.  Repeatedly use your Thrust Spear ability, until you get a message the Wild Wyrm is about to use its claw attack.  When you see that message, use your Dodge Claws ability, and then immediately use your Mighty Spear Thrust ability after that.  Remember to keep your grip up by using your Grab On ability, and repeat this process until phase 2 of the fight begins.
		.' In phase 2 of the fight with the Wild Wyrm, the strategy changes: |tip In phase 2 of the fight, you will be inside the Wild Wyrm's mouth.  Repeatedly use your Pry Jaws Open ability, try to stack it 20 times.  After you stack your Pry Jaws ability 20 times (which will give your Fatal Strike ability 100% chance to hit), use your Fatal Strike ability to kill the Wild Wyrm.  If you are close to dying, just stack your Pry Jaws Open ability as many times as you can, then use your Fatal Strike ability before you die, and hope it kills the Wild Wyrm.  
		.' Kill the Wild Wyrm |q 13003/1	
	step
		goto 63.5,59.8
		.talk Frostworg Denmother##30294
		..turnin Spy Hunter##12994
	step
		goto 64.2,59.2
		.click Hodir's Helm##8221 
		..turnin Polishing the Helm##13006
	step
		goto 65.1,60.8
		.click Hodir's Spear##8220 
		..turnin Thrusting Hodir's Spear##13003
	step
		goto 67.6,59.9
		.click Arngrim the Insatiable##8284
		..turnin Feeding Arngrim##13046
	step
		goto 69.7,60.2
		.from Brittle Revenant##30160+
		.collect 6 Essence of Ice##42246 |q 12981
	step
		goto 75.3,62.8
		.' Use your Essences of Ice next to Smoldering Scraps |use Essence of Ice##42246 |tip The Smoldering Scraps look like small smoking pieces of metal on the ground around this area.
		.' Click the Frozen Iron Scraps
		.get 6 Frozen Iron Scrap |q 12981/1
	step
		goto 72.1,51.8
		.from Niffelem Forefather##29974+, Restless Frostborn Ghost##30144+
		.' Use Hodir's Horn on their corpses |use Hodir's Horn##42164
		.' Free 5 Niffelem Forefathers |q 12977/1
		.' Free 5 Restless Frostborn |q 12977/2
	step
		goto 67.0,45.1
		.' If you want to grind mobs for Relics of Ulduar, or buy them on the Auction House, to turn in for The Sons of Hodir reputation, this is an awesome spot, as these mobs drop the Relics of Ulduar frequently.  You get 650 The Sons of Hodir reputation for every 10 Relics of Ulduar you collect.  If you don't want to do this, skip this step.
		.from Scion of Storm##30184+ |tip They are air elementals all around inside this big cave.
		.' You can also buy the Relics of Ulduar on the Auction House, if you'd like to get the reputation much faster.
		.collect Relic of Ulduar##42780+ |n |tip You turn these in in multiples of 10.
		|confirm
	step
		goto 63.2,62.9
		.click Fjorn's Anvil##7481
		..turnin Hot and Cold##12981
	step
		goto 64.1,65.1
		.click Hodir's Horn##7352
		..turnin Blowing Hodir's Horn##12977
	step
		goto 66.2,61.4
		.talk Lillehoff##32540
		..accept Hodir's Tribute##13559 |tip This is a repeatable quest.  Turn in all of your Relics of Ulduar.
	step
		.' To restart the Hodir daily quests, click here. |confirm |next "Daily3" |only if rep('The Sons of Hodir')<=Revered
		' Become Exalted with The Sons of Hodir |condition rep('The Sons of Hodir')==Exalted |next "Exalted"
]])

ZygorGuidesViewer:RegisterInclude("H_Skyguard_PreQ",[[
	step
		goto Shattrath City,64.3,42.3
		.talk Yuula##23449
		..accept Threat from Above##11096
	step
		goto Terokkar Forest,21.8,16.1
		.from 20 Gordunni Back-Breaker##22143+, Gordunni Soulreaper##23022+, Gordunni Head-Splitter##22148+, Gordunni Elementalist##22144+ |q 11096/1
		.' You can find more around here [24.4,8.9]
	step
		goto Shattrath City,64.3,42.3
		.talk Yuula##23449
		..turnin Threat from Above##11096
		..accept To Skettis!##11098
	step
		goto Terokkar Forest,64.5,66.7
		.talk Sky Sergeant Doryn##23048
		..turnin To Skettis!##11098
	step
		goto 63.5,65.8
		.talk Skyguard Handler Deesak##23415
		..accept Hungry Nether Rays##11093
	step
		goto 64.0,66.9
		.talk Severin##23042
		..accept World of Shadows##11004
	step
		goto 61.4,81.8
		.' Use your Nether Ray Cage |use Nether Ray Cage##32834 |tip Keep your Nether Ray out while killing Warp Chasers and wait until it is done eating before you kill another.
		.from Blackwind Warp Chaser##23219+
		.' You can find more Warp Chasers here [64.5,84.4]
		.get 10 Nether Ray Meal |q 11093/1
	step
		goto Terokkar Forest,61.6,75.3
		.from Skettis Soulcaller##21911+, Skettis Windwalker##21649+, Skettis Wing Guard##21644+, Skettis Talonite##21650+
		.get 6 Shadow Dust |q 11004/1
		.' You can find more here [69.5,85.5]
		.' Here[73.2,87.9]
		.' Here[75.2,81.3]
		.' And here [69.2,74.1]
	step
		goto Terokkar Forest,64.0,66.9
		.talk Severin##23042
		..turnin World of Shadows##11004
	step
		goto 63.5,65.8
		.talk Skyguard Handler Deesak##23415
		..turnin Hungry Nether Rays##11093
	step
		goto 64.1,66.9
		.talk Sky Commander Adaris##23038
		..accept Secrets of the Talonpriests##11005
	step
		goto 69.7,74.7
		.' Use the Elixer of Shadows in your bags |use Elixer of Shadows##32446
		.' You will get a buff Elixir of Shadows |havebuff Interface\Icons\Spell_Shadow_DetectInvisibility
	step
		goto 70.1,74.5
		.kill Talonpriest Zellek##23068 |q 11005/3
	step
		goto 69.3,78.1
		.kill Talonpriest Ishaal##23066+ |q 11005/1
		.collect Ishaal's Almanac##32523 |n |use Ishaal's Almanac##32523
		..accept Ishaal's Almanac##11021
	step
		goto 69.8,81.8
		.kill Talonpriest Skizzik##23067+ |q 11005/2
	step
		goto 64.1,66.9
		.talk Sky Commander Adaris##23038
		..turnin Secrets of the Talonpriests##11005
		..turnin Ishaal's Almanac##11021
		..accept An Ally in Lower City##11024
	step
		goto Shattrath City 52.5,21.0
		.talk Rilak the Redeemed##22292
		..turnin An Ally in Lower City##11024
		..accept Countdown to Doom##11028
	step
		goto Terokkar Forest,64.1,66.9
		.talk Nutral##18940
		..turnin Countdown to Doom##11028
	step
		goto 64.2,66.9
		.talk Hazzik##23306
		..accept Hazzik's Bargain##11056
	step
		goto 74.8,80.1
		.click Hazzik's Package##6396
		.get Hazzik's Package |q 11056/1
	step
		goto 64.3,66.9
		.talk Hazzik##23306
		..turnin Hazzik's Bargain##11056
		..accept A Shabby Disguise##11029
	step
		goto 66.2,77.5
		.' Use the Shabby Arakkoa Disguise in your bags |use Shabby Arakkoa Disguise##32741
		.' Wear the Shabby Arakkoa Disguise |havebuff Interface\Icons\INV_Misc_Birdbeck_01
	step
		  goto 67.0,79.7
		.talk Sahaak##23363
		.buy Adversarial Bloodlines##32742 |q 11029
	step
		goto 64.3,66.9
		.talk Hazzik##23306
		..turnin A Shabby Disguise##11029
		..accept Adversarial Blood##11885
	step
		goto Terokkar Forest,61.6,75.3
		.from Skettis Soulcaller##21911+, Skettis Windwalker##21649+, Skettis Wing Guard##21644+, Skettis Talonite##21650+
		.collect 12 Shadow Dust##32388 |q 11885 |future
		.' You can find more here [69.5,85.5]
		.' Here[73.2,87.9]
		.' Here[75.2,81.3]
		.' And here [69.2,74.1]
	step
		goto 64.0,66.9
		.talk Severin##23042
		..accept More Shadow Dust##11006 |instant
		..collect 2 Elixir of Shadows##32446+ |q 11885 |future
	step
		' This next quest is meant to be a _3 person_ quest. Make sure that you are either high level, or that you have a group to continue.
		|confirm always
	step
		.' Use the Elixer of Shadows in your bags |use Elixer of Shadows##32446
		.' You will get a buff Elixir of Shadows |havebuff Interface\Icons\Spell_Shadow_DetectInvisibility
	step
		goto Terokkar Forest,61.6,75.3
		.from Time-Lost Skettis High Priest##21787+
		.from Time-Lost Skettis Reaver##21651+
		.from Time-Lost Skettis Worshipper##21763+
		..collect 40 Time-Lost Scroll##32620+
		.' You can find more here [69.5,85.5]
		.' Here[73.2,87.9]
		.' Here[75.2,81.3]
		.' And here [69.2,74.1]
	step
		goto 69.7,74.7
		.click Skull Pile##6393 |tip This will use 10 Time-Lost Scrolls
		.' <Call forth Darkscreecher Akkarai.>
		.' <Call forth Karrog.>
		.' <Call forth Gezzarak the Huntress.>
		.' <Call forth Vakkiz the Windrager.>
		.kill Darkscreecher Akkarai##23161 |q 11885/1
		.collect Akkarai's Talons##32715
		.kill Karrog##23165 |q 11885/2
		.collect Karrog's Spine##32717
		.kill Gezzarak the Huntress##23163 |q 11885/3
		.collect Gezzarak's Claws##32716
		.kill Vakkiz the Windrager##23204 |q 11885/4
		.collect Vakkiz's Scale##32718
		.'You can find more skull piles here: [70.1,79.5]
		.' Here [73.5,80.7]
		.' Here [70.2,83.3]
	step
		goto 64.2,66.9
		.talk Hazzik##23306
		..turnin Adversarial Blood##11885
		..accept Tokens of the Descendants##11074 |instant
	step
		goto 64.1,66.9
		.talk Sky Commander Adaris##23038
  		..accept Terokk's Downfall##11073
	step
		goto 66.2,77.5
		.click Skull Pile##6393 |tip This will use 1 Time-Lost Offering.
		.' <Call forth Terokk.>
		.from Terokk##21838 |tip When he gets a shield and becomes immune, walk him over the Blue Smoke. A meteor will come down and break his shield.
		.' Killing Terokk will gain you 550 reputation with Ska'tari Skyguard
		|confirm always
	step
		goto 64.1,66.9
		.talk Sky Commander Adaris##23038
  		..turnin Terokk's Downfall##11073
]])

ZygorGuidesViewer:RegisterInclude("H_Skyguard_Daily",[[
	step
	label	"dailies"
		goto Terokkar Forest,64.5,66.7
		.talk Sky Sergeant Doryn##23048
		..accept Fires Over Skettis##11008
	step
		goto 63.1,80.0
		.' Fly to the top of this tree and use your Blasting charges to destroy _Monstrous Kaliri Eggs_
		.' Use the Skyguard Blasting Charges in your bags |use Skyguard Blasting Charges##32406
		.Destroy 20 Monstrous Kaliri Eggs |q 11008/1
		.' You can find more eggs here:  goto [61.3,79.9]
		.' Here [67.5,79.3]
		.' Here [68.0,85.6]
		.' and here [70.3,84.5]
		'|model 378
	step
		goto 64.5,66.7
		.talk Sky Sergeant Doryn##23048
		..turnin Fires Over Skettis##11008
	step
		goto 61.0,75.6
		.talk Skyguard Prisoner##23383
		..accept Escape from Skettis##11085
		.' He can also be found here: [68.4,74.0]
		.' and here: [75.0,86.5]
	step
		.' Escort the Skyguard Prisoner to the bottom of the bridge |tip Help him kill any mobs on the way down.
		.' Rescue the Skyguard Prisoner. |q 11085/1
		'|modelnpc 23383
	step
		goto 64.5,66.7
		.talk Sky Sergeant Doryn##23048
		..turnin Escape from Skettis##11085
	step
	label	"grind"
		goto Terokkar Forest,61.6,75.3
		.from Skettis Soulcaller##21911+, Skettis Windwalker##21649+, Skettis Wing Guard##21644+, Skettis Talonite##21650+
		.collect 12 Shadow Dust##32388
		.' You can find more here [69.5,85.5]
		.' Here[73.2,87.9]
		.' Here[75.2,81.3]
		.' And here [69.2,74.1]
	step
		goto 64.0,66.9
		.talk Severin##23042
		..accept More Shadow Dust##11006 |instant |n
		..collect 2 Elixir of Shadows##32446
	step
		.' Use the Elixer of Shadows in your bags |use Elixer of Shadows##32446
		.' You will get a buff Elixir of Shadows |havebuff Interface\Icons\Spell_Shadow_DetectInvisibility
	step
		goto Terokkar Forest,61.6,75.3
		.from Time-Lost Skettis High Priest##21787+
		.from Time-Lost Skettis Reaver##21651+
		.from Time-Lost Skettis Worshipper##21763+
		..collect 40 Time-Lost Scroll##32620+
		.' You can find more here [69.5,85.5]
		.' Here[73.2,87.9]
		.' Here[75.2,81.3]
		.' And here [69.2,74.1]
	step
		goto 69.7,74.7
		.click Skull Pile##6393 |tip This will use 10 Time-Lost Scrolls
		.' <Call forth Darkscreecher Akkarai.>
		.' <Call forth Karrog.>
		.' <Call forth Gezzarak the Huntress.>
		.' <Call forth Vakkiz the Windrager.>
		.from Darkscreecher Akkarai##23161
		.collect Akkarai's Talons##32715
		.from Karrog##23165
		.collect Karrog's Spine##32717
		.from Gezzarak the Huntress##23163
		.collect Gezzarak's Claws##32716
		.from Vakkiz the Windrager##23204
		.collect Vakkiz's Scale##32718
		.'You can find more skull piles here: [70.1,79.5]
		.' Here [73.5,80.7]
		.' Here [70.2,83.3]
	step
		goto Terokkar Forest,64.3,66.9
		.talk Hazzik##23306
		..accept Tokens of the Descendants##11074 |instant |n
		.collect Time-Lost Offering##32720
	step
		goto 66.2,77.5
		.click Skull Pile##6393 |tip This will use 1 Time-Lost Offering.
		.' <Call forth Terokk.>
		.from Terokk##21838 |tip When he gets a shield and becomes immune, walk him over the Blue Smoke. A meteor will come down and break his shield.
		.' Killing Terokk will gain you 550 reputation with Ska'tari Skyguard
		|confirm always
		|next "dailies" |only if rep("Sha'tari Skyguard")<=Revered
		|next |only if rep("Sha'tari Skyguard")==Exalted
]])

ZygorGuidesViewer:RegisterInclude("H_Oracles",[[
		'Proceeding to Prequests |next |condition rep('The Oracles')<=Friendly |only if rep('The Oracles')<=Friendly
		'Proceeding to Dailies |next "daily" |condition rep('The Oracles')>=Friendly |only if rep('The Oracles')>=Friendly
	step
		goto Sholazar Basin,50.5,62.1
		.talk Tamara Wobblesprocket##28568
		..accept The Part-time Hunter##12654
	step
		goto 50.5,77.3
		.from Pitch##28097
		.get Pitch's Remains |q 12654/1
	step
		goto 50.5,76.6
		.talk Tracker Gekgek##28095
		..accept Playing Along##12528
	step
		goto 55,69.1
		.talk High-Shaman Rakjak##28082
		..turnin Playing Along##12528
		..accept The Ape Hunter's Slave##12529
	step
		'Talk to Goregek the Gorilla Hunter who is following you
		..accept Tormenting the Softknuckles##12530
	step
		goto 57.5,73.3
		.kill 8 Hardknuckle Forager |q 12529/1
	step
		goto 61.1,71.7
		.kill 6 Hardknuckle Charger |q 12529/2
	step
		goto 66.9,73.2
		.' Use your Softknuckle Poker on Softknuckles |use Softknuckle Poker##38467 |tip Softknuckles are baby gorillas.
		.' A Hardknuckle Matriarch will spawn eventually
		.kill 1 Hardknuckle Matriarch |q 12530/1
	step
		goto 55,69.1
		.talk High-Shaman Rakjak##28082
		..turnin The Ape Hunter's Slave##12529
		..turnin Tormenting the Softknuckles##12530
		..accept The Wasp Hunter's Apprentice##12533
	step
		goto 55.5,69.7
		.talk Elder Harkek##28138
		..accept The Sapphire Queen##12534
	step
		goto 59.6,75.8
		.kill 6 Sapphire Hive Wasp |q 12533/1
		.kill 9 Sapphire Hive Drone |q 12533/2
	step
		goto 59.4,79.1|n
		.' The path down to The Sapphire Queen starts here |goto 59.4,79.1,0.3 |noway |c |q 12534
	step
		'Follow the path down to 57.1,79.3 |goto 57.1,79.3
		.from Sapphire Hive Queen##28087
		.get Stinger of the Sapphire Queen |q 12534/1
	step
		'Go outside to 55.0,69.1|goto 55.0,69.1
		.talk High-Shaman Rakjak##28082
		..turnin The Wasp Hunter's Apprentice##12533
		..turnin The Sapphire Queen##12534
	step
		goto 55.5,69.7
		.talk Elder Harkek##28138
		..accept Flown the Coop!##12532
	step
		'They are all around the village
		.' Click the Chicken Escapees
		.get 12 Captured Chicken |q 12532/1
	step
		goto 55.5,69.7
		.talk Elder Harkek##28138
		..turnin Flown the Coop!##12532
		..accept The Underground Menace##12531
	step
		goto 55,69.1
		.talk High-Shaman Rakjak##28082
		..accept Mischief in the Making##12535
	step
		goto 56.6,84.6
		.' Click the Skyreach Crystal Formations |tip They look like white crystal cluster on the ground along the river bank.
		.get 8 Skyreach Crystal Cluster |q 12535/1
	step
		goto 49.8,85
		.from Serfex the Reaver##28083
		.get Claw of Serfex |q 12531/1
	step
		goto 55,69.1
		.talk High-Shaman Rakjak##28082
		..turnin The Underground Menace##12531
		..turnin Mischief in the Making##12535
		..accept A Rough Ride##12536
	step
		goto 57.3,68.4
		.talk Captive Crocolisk##28298
		..'Tell him let's do this
		.' Travel to Mistwhisper Refuge |q 12536/1
	step
		'When you jump off the crocodile:
		.talk Zepik the Gorloc Hunter##28668
		..turnin A Rough Ride##12536
		..accept Lightning Definitely Strikes Twice##12537
		..accept The Mist Isn't Listening##12538
	step
		goto 45.4,37.2
		.' Use your Skyreach Crystal Clusters next to the stone monument |use Skyreach Crystal Clusters##38510 |tip It's a tall rectangle stone monument.
		.' Click the Arranged Crystal Formation that appears
		.' Sabotage the Mistwhisper Weather Shrine |q 12537/1
	step
		goto 45.5,39.8
		.' Kill 12 Mistwhisper Gorlocs |q 12538/1
	step
		'Use Zepik's Hunting Horn if Zepik is not standing next to you: |use Zepik's Hunting Horn##38512
		.talk Zepik the Gorloc Hunter##28216
		..turnin Lightning Definitely Strikes Twice##12537
		..turnin The Mist Isn't Listening##12538
		..accept Hoofing It##12539
	step
		goto 55,69.1
		.talk High-Shaman Rakjak##28082
		..turnin Hoofing It##12539
		..accept Just Following Orders##12540
	step
		goto 55.7,64.9
		.talk Injured Rainspeaker Oracle##28217
		..' Pull it to its feet
		.' Kill the crocodile that spawns
		.' Locate the Injured Rainspeaker Oracle |q 12540/1
	step
		goto 55.7,64.9
		.talk Injured Rainspeaker Oracle##28217
		..turnin Just Following Orders##12540
		..accept Fortunate Misunderstandings##12570
		..'Tell him you are ready to travel to his village now.
		.' Escort the Injured Rainspeaker Oracle to Rainspeaker Canopy |q 12570/1
	step
		goto 54.6,56.3
		.talk High-Oracle Soo-say##28027
		..turnin Fortunate Misunderstandings##12570
		..accept Make the Bad Snake Go Away##12571
	step
		'Use Lafoo's Bug Bag if Lafoo is not standing next to you: |use Lafoo's Bug Bag##38622
		.talk Lafoo##28120
		..accept Gods like Shiny Things##12572
	step
		goto 57.5,52.4
		.kill 1 Venomtip |q 12571/2 |tip He walks back and forth on this small path near the waterfall.
	step
		goto 52.4,53.2
		'Use Lafoo's Bug Bag if Lafoo is not standing next to you: |use Lafoo's Bug Bag##38622
		.' Stand on top of the twinkles of light on the ground around this area
		.' Lafoo will dig up the treasure
		.' Click the random items that appear on the ground
		.get 6 Shiny Treasures |q 12572/1
		.kill 10 Emperor Cobra |q 12571/1
	step
		goto 54.6,56.3
		.talk High-Oracle Soo-say##28027
		..turnin Make the Bad Snake Go Away##12571
		..accept Making Peace##12573
		..turnin Gods like Shiny Things##12572
	step
		goto 51.3,64.6
		.talk Shaman Vekjik##28315
		..'Tell him you brought an offering
		.' Extend the Peace Offering to Shaman Vekjik |q 12573/1
	step
		goto 50.5,62.1
		.talk Tamara Wobblesprocket##28568
		..turnin The Part-time Hunter##12654
	step
		goto 54.6,56.3
		.talk High-Oracle Soo-say##28027
		..turnin Making Peace##12573
		..accept Back So Soon?##12574
	step
		goto 42.1,38.6
		.talk Mistcaller Soo-gan##28114
		..turnin Back So Soon?##12574
		..accept The Lost Mistwhisper Treasure##12575
		..accept Forced Hand##12576
	step
		goto 40.4,26.4
		.kill 8 Frenzyheart Spearbearer |q 12576/1
		.kill 6 Frenzyheart Scavenger |q 12576/2
	step
		goto 41.3,19.8
		.kill 1 Warlord Tartek |q 12575/1 |tip He comes walking up on a red dragon.
	step
		goto 41.6,19.5
		.' Click the Mistwhisper Treasure |tip It's a yellow glowing floating orb, hovering over a tree stump altar.
		.get Mistwhisper Treasure |q 12575/2
	step
		goto 42.1,38.6
		.talk Mistcaller Soo-gan##28114
		..turnin The Lost Mistwhisper Treasure##12575
		..turnin Forced Hand##12576
		..accept Home Time!##12577
	step
		goto 54.6,56.3
		.talk High-Oracle Soo-say##28027
		..turnin Home Time!##12577
		..accept The Angry Gorloc##12578
	step
		goto 75.3,54.1
		.' Travel to Mosswalker Village |q 12578/1
	step
		'Use Moodle's Stress Ball if Moodle is not standing next to you:|use Moodle's Stress Ball##38624
		.talk Moodle##28122
		..turnin The Angry Gorloc##12578
		..accept The Mosswalker Savior##12580
		..accept Lifeblood of the Mosswalker Shrine##12579
	step
		goto 75.4,52.4
		.talk Mosswalker Victim##28113
		.' Rescue 6 Mosswalker Victims |q 12580/1
	step
		'Use Moodle's Stress Ball if Moodle is not standing next to you:|use Moodle's Stress Ball##38624
		.talk Moodle##28122
		..turnin The Mosswalker Savior##12580
	step
		goto 68.9,54.6
		.' Click Lifeblood Shards on the ground |tip They look like small red crystals on the ground around this area.
		.get 10 Lifeblood Shard |q 12579/1
	step
		goto 54.5,56.6
		'You can also use Moodle's Stress Ball if you have it in your bags:|use Moodle's Stress Ball##38624 
		.talk Moodle##28122
		..turnin Lifeblood of the Mosswalker Shrine##12579
		..accept A Hero's Burden##12581
]])
--------------------------------------------------------------------------------------------------------------------------------------
-- MoP DAILIES/REPUTATIONS
--------------------------------------------------------------------------------------------------------------------------------------
ZygorGuidesViewer:RegisterInclude("Shado_Pan_Daily_H",[[
	step
	label shado_dailies
		goto Townlong Steppes 49.3,71.0
		'Click here if Master Snowdrift is the questgiver today |next |confirm |modelnpc 63009
		.' He can be found here: [49.5,70.6]
		'Click here if Ban Bearheart is the questgiver today |next "bearheart" |confirm |modelnpc 62304
		.' He can be found here [49.0,70.5]
		'Click here if Ling of the Six Pools is the questgiver today |next "ling" |confirm |modelnpc 63614
		.' She can be found here: [49.0,71.3]
	step
		goto 49.4,70.6
		.talk Master Snowdrift##63009
		..accept The Challenger's Ring: Chao the Voice##31127
		|only if not completedq(31127)
		|only if rep('Shado-Pan')>=Honored
	step
		goto 49.4,70.6
		.talk Master Snowdrift##63009
		..accept The Challenger's Ring: Lao-Chin the Iron Belly##31128
		|only if rep('Shado-Pan')>=Revered
	step
		goto 49.3,72.0
		.talk Lao-Chin the Iron Belly##62978
		.' I'm here to challenge you! |q 31128/1
		|only if havequest(31128)
	step
		goto 50.6,67.8
		.talk Lao-Chin the Iron Belly##63135
		.' All right, let's do this!
		.' Defeat Lao-Chin the Iron Belly |q 31128/2
		|only if havequest(31128)
	step
		goto 49.6,70.5
		.talk Master Snowdrift##63009
		..turnin The Challenger's Ring: Lao-Chin the Iron Belly##31128
		|only if havequest(31128)
	step
		goto 49.7,70.5
		.talk Chao the Voice##62550
		.' Tell her you're here to challenge her! |q 31127/1
		|only if havequest(31127)
	step
		goto 50.1,68.3
		.talk Chao the Voice##63125
		.' Let's do this.
		.' Defeat Chao the Voice |q 31127/2
		|only if havequest(31127)
	step
		goto 49.4,70.6
		.talk Master Snowdrift##63009
		..turnin The Challenger's Ring: Chao the Voice##31127
		|only if havequest(31127)
	step
		goto 49.4,70.6
		.talk Master Snowdrift##63009 |tip You will only be able to accept 4 of the following dailies.
		..accept Assault Fire Camp Gai-Cho##31113 |or 4
		..accept Assault Deadtalker's Plateau##31114 |or 4
		..accept The Enemy of My Enemy... Is Still My Enemy!##31119 |or 4
		..accept Spirit Dust##31116 |or 4 
		..accept The Deadtalker Cipher##31118 |or 4
	step
		'Talk to Chao the Voice or Protector Yi and ask one of them to come with you. They will help you in combat and allow you to turnin your quests outside of this questing hub.|tip Yi patrols so you may need to search for him.
		.' Chao the Voice at [49.7,70.5] |modelnpc 62550
		.' Protector Yi at [49.3,71.3] |modelnpc 62546
		|confirm
		|only if not completedq(31128)
	step
		'Talk to Chao the Voice, Protector Yi or Lao-Chin the Iron Belly and ask one of them to come with you. They will help you in combat and allow you to turn in your quests outside of this questing hub.|tip Yi patrols so you may need to search for him.
		.' Chao the Voice at [49.7,70.5] |modelnpc 62550
		.' Protector Yi at [49.3,71.3] |modelnpc 62546
		.' Lao-Chin the Iron Belly at [49.3,71.9] |modelnpc 62978
		|confirm
		|only if completedq(31128)
	step
		goto 63.4,43.3
		.from Gai-Cho Yaungol##62552+, Gai-Cho Earthtalker##62553+, Gai-Cho Pitchthrower##62608+ |only if havequest(31113)
		.' Kill 16 Gai-Cho Yaungol, Earthtalkers, or Pitchthrowers. |q 31113/1 |only if havequest(31113)
		.click Highly Explosive Yaungol Oil Barrel |only if havequest(31119)
		.collect Highly Explosive Yaungol Oil##84762 |n |tip You can only carry 10 at a time, so you may need to make multiple trips. |only if havequest(31119)
	step
		goto 60.2,48.6
		'Use your Highly Explosive Yaungol Oil to kill as many enemies in this area as you can in 1 hit. |use Highly Explosive Yaungol Oil Barrel##84762
		.from Gai-Cho Boltshooter##62589+, Gai-Cho Cauterizer##62577+, Gai-Cho Gatewatcher##62568+, Kri'thik Aggressor##62572+, Kri'thik Screecher##62602+
		.' Kill 100 Gai-Cho Battledfired Combatants |q 31119/1
		.' If you run out of oil, you can find more here [63.4,43.3]
		|only if havequest(31119)
	step
		goto 51.1,51.8
		.kill 8 Deadtalker Corpsedefiler##62677+ |q 31114/1 |only if havequest(31114)
		.kill Deadtalker Crusher##62844 |q 31114/2 |tip He is elite but with your companion you should be able to defeat him. |only if havequest(31114)
		.from Defiled Spirit##62679 |only if havequest(31116)
		.collect Ancient Spirit Dust##84727 |n |only if havequest(31116)
		.click Defiled Yaungol Remains |only if havequest(31116)
		.' Return 8 Spirits to Their Remains |q 31116/1 |only if havequest(31116)
	step
		goto 51.1,51.8
		.from Deadtalker Crusher##62844+, Deadtalker Corpsedefiler##62677+ |only if havequest(31118)
		.get Ciphered Scroll##84759 |q 31118/1 |only if havequest(31118)
	step
		'Next to you will either be Chao the Voice or Protector Yi:
		.'Talk to Chao the Voice |modelnpc 62550
		.'Talk to Protector Yi |modelnpc 62546
		..turnin Assault Fire Camp Gai-Cho##31113
		..turnin Assault Deadtalker's Plateau##31114 
		..turnin The Enemy of My Enemy... Is Still My Enemy!##31119
		..turnin Spirit Dust##31116
		..turnin The Deadtalker Cipher##31118
		|only if not completedq(31128)
	step
		'Next to you will either be Chao the Voice, Protector Yi, or Lao-Chin the Iron Belly:
		.'Talk to Chao the Voice |modelnpc 62550
		.'Talk to Protector Yi |modelnpc 62546
		.'Talk to Lao-Chin the Iron Belly |modelnpc 62978
		..turnin Assault Fire Camp Gai-Cho##31113
		..turnin Assault Deadtalker's Plateau##31114 
		..turnin The Enemy of My Enemy... Is Still My Enemy!##31119
		..turnin Spirit Dust##31116
		..turnin The Deadtalker Cipher##31118
		|only if completedq(31128)
	step
		'Click the Quest Discovered box that displays on the right side of the screen under your minimap
		..accept Uruk!##31117 |or
		..accept Cheng Bo!##31120 |or
	step
		goto 50.4,48.9
		.kill Uruk##62613 |q 31117/1
	step
		goto 60.7,42.1
		.kill Cheng Bo##62554 |q 31120/1
	step
		goto 49.6,70.5
		.talk Master Snowdrift##63009
		..turnin Uruk!##31117 |or
		..turnin Cheng Bo!##31120 |or
		|next "end"
///New questgiver today?
	step
	label bearheart
		goto 49.0,70.4
		.talk Ban Bearheart##62304
		..accept The Challenger's Ring: Snow Blossom##31038
		|only if not completedq(31038)
		|only if rep('Shado-Pan')>=Honored
	step
		goto 49.0,70.4
		.talk Ban Bearheart##62304
		..accept The Challenger's Ring: Yalia Sagewhisper##31104
		|only if rep('Shado-Pan')>=Revered
	step
		goto 48.9,70.1
		.talk Snow Blossom##62380
		.' Ask her to meet in the Challenger's Ring. |q 31038/1
		|only if havequest(31038)
	step
		goto 50.2,67.9
		.talk Snow Blossom##62834
		.' I challenge you!
		.' Defeat Snow Blossom |q 31038/2
		|only if havequest(31038)
	step
		goto 49.0,70.4
		.talk Ban Bearheart##62304
		..turnin The Challenger's Ring: Snow Blossom##31038
		|only if havequest(31038)
	step
		goto 48.9,70.0
		.talk Yalia Sagewhisper##62303
		.' Ask her to meet you in the Challenger's Ring. |q 31104/1
		|only if havequest(31104)
	step
		goto 50.4,67.7
		.talk Yalia Sagewhisper##62850
		.' I challenge you!
		.' Defeat Yalia Sagewhisper |q 31104/2
		|only if havequest(31104)
	step
		goto 49.0,70.4
		.talk Ban Bearheart##62304
		..turnin The Challenger's Ring: Yalia Sagewhisper##31104
		|only if havequest(31104)
	step
		goto 49.0,70.4
		.talk Ban Bearheart##62304
		..accept The Mogu Menace##31105 |or 4
		..accept The Mogu Menace##31106 |or 4
		..accept The Mogu Menace##31039 |or 4
		..accept Bronze Claws##31044 |or 4
		..accept Illusions Of The Past##31045 |or 4
		..accept Grave Consequences##31048 |or 4
		..accept Dark Arts##31043 |or 4
		..accept Onyx Hearts##31042 |or 4
		..accept Born Free##31047 |or 4
		..accept Spiteful Sprites##31040 |or 4
		..accept Egg Rescue!##31041 |or 4
		..accept Little Hatchlings##31046 |or 4
	step
		'Talk to Snow Blossom or Fei Li and ask one of them to come with you. They will help you in combat and allow you to turn in your quests outside of this questing hub.
		.' Snow Blossom at [48.9,70.1] |modelnpc 62380
		.' Fei Li at [48.8,70.2] |modelnpc 62354
		|confirm
		|only if not completedq(31104)
	step
		'Talk to Snow Blossom, Fei Li, or Yalia Sagewhisper and ask one of them to come with you. They will help you in combat and allow you to turn in your quests outside of this questing hub.
		.' Snow Blossom at [48.9,70.1] |modelnpc 62380
		.' Fei Li at [48.8,70.2] |modelnpc 62354
		.' Yalia Sagewhisper at [48.8,70.0] |modelnpc 62303
		|confirm
		|only if completedq(31104)
	step
		goto 28.8,22.4
		.talk Moshu the Arcane##62810
		..accept Through the Portal##31110
		|only if not completedq(31110)
	step
		goto 32.8,25.1
		.clicknpc Ball and Chain##62539 |only if havequest(31047)
		.' Free 6 Wild Cloudriders |q 31047/1 |only if havequest(31047)
		.click Shan'ze Cage |only if havequest(31046)
		.' Free 20 Cloudrider Hatchlings. |q 31046/1 |only if havequest(31046)
		.click Shiny Egg |only if havequest(31041)
		.get 8 Cloudrunner Egg |q 31041/1 |only if havequest(31041)
		|only if havequest(31041) or havequest(31046) or havequest(31047)
	step
		goto 24.4,15.2
		.kill 3 Shan'ze Illusionist##62440+ |q 31045/1|only if havequest(31045)
		.click Shan'ze Tablet |only if havequest(31043)
		.get 8 Shan'ze Tablet |q 31043/1 |only if havequest(31043)
		.click Mogu Burial Urn |only if havequest(31048)
		.kill 24 Shan'ze Ancestor##62285+ |q 31048/1 |only if havequest(31048)
		.from Onyx Stormclaw##62448 |only if havequest(31042)
		.get 4 Onyx Heart |q 31042/1 |only if havequest(31042)
	step
		goto 28.5,18.5
		.from Shan'ze Serpentbinder##62293+, Shan'ze Beastmaster##62530+ |only if havequest(31105) or havequest(31106) or havequest (31039)
		.' Kill 12 Shan'ze Serpentbinders or Beastmasters |q 31105/1 |only if havequest(31105)
		.' Kill 12 Shan'ze Serpentbinders or Beastmasters |q 31106/1 |only if havequest(31106)
		.' Kill 12 Shan'ze Serpentbinders or Beastmasters |q 31039/1 |only if havequest(31039)
		.from Bronze Quilen##62266+ |only if havequest(31044)
		.get 20 Bronze Claw##83153+ |q 31044/1 |only if havequest(31044)
	step
		goto 23.0,19.5
		.from Darkwoods Pixie##62268+, Darkwoods Charmer##62457+
		.' Kill 30 Darkwoods Sprites or Darkwoods Charmers. |q 31040/1
		|only if havequest(31040)
	step
		.from Shan'ze Serpentbinder##62293+, Shan'ze Illusionist##62440+, Shan'ze Ancestor##62285+, Shan'ze Beastmaster##62515+, Darkwoods Charmer##62520
		.get 1000 Ancient Arcane Powder##84102+ |q 31110/1
		|only if havequest(31110)
	step
		'Next to you will either be Fei Li or Snow Blossom
		.talk Fei Li##62354
		.talk Snow Blossom##62380
		..turnin The Mogu Menace##31105
		..turnin The Mogu Menace##31106
		..turnin The Mogu Menace##31039
		..turnin Bronze Claws##31044
		..turnin Illusions Of The Past##31045
		..turnin Grave Consequences##31048
		..turnin Dark Arts##31043
		..turnin Onyx Hearts##31042
		..turnin Born Free##31047
		..turnin Spiteful Sprites##31040 
		..turnin Egg Rescue!##31041 
		..turnin Little Hatchlings##31046 
		..accept When The Dead Speak##31062 |or
		..accept Riding the Storm##31061 |or
		..accept In Sprite Of Everything##31049 |or
		|only if not completedq(31104)
	step
		'Next to you will either be Fei Li, Snow Blossom, or Yalia Sagewhisper
		.talk Fei Li##62354
		.talk Snow Blossom##62380
		.talk Yalia Sagewhisper##62303
		..turnin The Mogu Menace##31105
		..turnin Bronze Claws##31044
		..turnin Illusions Of The Past##31045
		..turnin Grave Consequences##31048
		..turnin Dark Arts##31043
		..turnin Onyx Hearts##31042
		..turnin Born Free##31047
		..turnin Spiteful Sprites##31040 
		..turnin Egg Rescue!##31041 
		..turnin Little Hatchlings##31046 
		..accept When The Dead Speak##31062 |or
		..accept Riding the Storm##31061 |or
		..accept In Sprite Of Everything##31049 |or
		|only if completedq(31104)
	step
		goto 30.9,12.6
		.' Use the Bronze Claws on the Cloudrunners around this area. |use Bronze Claws##83134
		.from Shan'ze Cloudrunner##62584 
		.' Free 8 Shan'ze Cloudriders |q 31061/1
		|only if havequest(31061)
	step
		'Click the Leave Vehicle button. |outvehicle
		|only if havequest(31061)
	step
		'Enter the tunnel here. |goto 20.3,15.8 <5 |c
		|only if havequest(31049)
	step
		goto 19.5,13.8
		.kill Darkwoods Faerie##62522 |q 31049/1
		|only if havequest(31049)
	step
		'Leave the tunnel here. |goto 20.3,15.8 <5 |c
		|only if havequest(31049)
	step
		goto 32.3,9.5
		.kill Shan'ze Deathspeaker##62559 |q 31062/1 |tip Make sure you destroy his Spirit Gems, if you let them pile up they can overwhelm you.
		|only if havequest(31062)
	step
		goto 28.8,22.4
		.talk Moshu the Arcane##62810
		..turnin Through the Portal##31110
		|only if havequest(31110)
	step
		goto 49.0,70.4
		.talk Ban Bearheart##62304
		..turnin When The Dead Speak##31062 
		..turnin Riding the Storm##31061 
		..turnin In Sprite Of Everything##31049 
		|next "end"
/// New Questigver today
	step
	label ling
		goto 49.0,71.3
		.talk Ling of the Six Pools##63614
		..accept The Challenger's Ring: Hawkmaster Nurong##31220
		|only if not completedq(31220)
		|only if rep('Shado-Pan')>=Honored
	step
		goto 49.0,71.3
		.talk Ling of the Six Pools##63614
		..accept The Challenger's Ring: Tenwu of the Red Smoke##31221
		|only if rep('Shado-Pan')>=Revered 
	step
		goto 48.9,71.2
		.talk Tenwu of the Red Smoke##63616
		.' Ask him to meet you in the Challenger's Ring. |q 31221/1
		|only if havequest(31221)
	step
		goto 50.6,68.5
		.talk Tenwu of the Red Smoke##64471
		.' Let's see if you can back that talk up.
		.' Defeat Temwu of the Red Smoke |q 31221/2
		|only if havequest(31221)
	step
		goto 49.0,71.3
		.talk Ling of the Six Pools##63614
		..turnin The Challenger's Ring: Tenwu of the Red Smoke##31221
		|only if havequest(31221)
	step
		goto 49.0,70.9
		.talk Hawkmaster Nurong##63618
		.' Ask him to meet you in the Challenger's Ring. |q 31220/1
		|only if havequest(31220)
	step
		goto 50.7,68.2
		.talk Hawkmaster Nurong##64470
		.' Let's go!
		.' Defeat Hawkmaster Nurong |q 31220/2
		|only if havequest(31220)
	step
		goto 49.0,71.3
		.talk Ling of the Six Pools##63614
		..turnin The Challenger's Ring: Hawkmaster Nurong##31220
		|only if havequest(31220)
	step
		goto 49.0,71.3
		.talk Ling of the Six Pools##63614
		..accept Sra'vess Wetwork##31196 |or 4
		..accept The Bigger They Come...##31197 |or 4
		..accept A Morale Victory##31198 |or 4
		..accept Destroy the Siege Weapons!##31199 |or 4
		..accept Fumigation##31200 |or 4
		..accept Friends, Not Food!##31201 |or 4
	step
		'Talk to Hawkmaster Nurong or Taoshi and ask one of them to come with you. They will help you in combat and allow you to turn in your quests outside of this questing hub.
		'Hawkmaster Nurong at [48.7,71.2] |modelnpc 63618
		'Taoshi at [48.7,71.0] |modelnpc 63617
		|confirm
		|only if not completedq(31221)
	step
		'Talk to Hawkmaster Nurong, Taoshi, or Tenwu of the Red Smoke and ask one of them to come with you. They will help you in combat and allow you to turn in your quests outside of this questing hub.
		'Hawkmaster Nurong at [48.7,71.2] |modelnpc 63618
		'Taoshi at [48.7,71.0] |modelnpc 63617
		'Tenwu of the Red Smoke [48.9,71.2] |modelnpc 63616
		|confirm
		|only if completedq(31221)
	step
		goto 48.7,71.1
		.talk Ku-Mo##65341
		..accept Seeking Father##30933
		.' If this quest is unavailable, click here. |confirm
		|only if not completedq(30933)
	step
		goto 27.5,54.6
		.click Sra'thik Siege Weapon
		.' Small Southern Siege Weapon destroyed |q 31199/2
		|only if havequest(31199)
	step
		goto 25.8,53.8
		.click Sra'thik Siege Weapon
		.' Large Southern Siege Weapon destroyed |q 31199/1
		|only if havequest(31199)
	step
		goto 23.5,55.5
		.click Sra'thik Idol
		.' Southern Idol destroyed |q 31198/1
		|only if havequest(31198)
	step
		goto 21.5,49.2
		.click Sra'thik Idol
		.' Central Idol destroyed |q 31198/3
		|only if havequest(31198)
	step
		goto 27.2,41.2
		.click Sra'thik Siege Weapon
		.' Large Northern Siege Weapon destroyed |q 31199/3
		|only if havequest(31199)
	step
		goto 26.2,39.8
		.click Sra'thik Siege Weapon
		.' Small Northern Siege Weapon destroyed |q 31199/4
		|only if havequest(31199)
	step
		goto 27.8,41.9
		.click Sra'thik Idol
		.' Eastern Idol destroyed |q 31198/4
		|only if havequest(31198)
	step
		goto 23.6,44.7 
		'Use the Bag of Shado-Pan Gas Bombs at this location. |use Bag of Shado-Pan Gas Bombs##86532
		.' Egg Chamber bombed |q 31200/3
		|only if havequest(31200)
	step
		goto 22.0,41.6 
		'Use the Bag of Shado-Pan Gas Bombs at this location. |use Bag of Shado-Pan Gas Bombs##86532
		.' Torture Cell bombed |q 31200/4
		|only if havequest(31200)
	step
		goto 21.2,43.2 
		'Use the Bag of Shado-Pan Gas Bombs at this location. |use Bag of Shado-Pan Gas Bombs##86532
		.' Slaughtering Pit bombed |q 31200/5
		|only if havequest(31200)
	step
		goto 21.0,45.9 
		'Use the Bag of Shado-Pan Gas Bombs at this location. |use Bag of Shado-Pan Gas Bombs##86532
		.' Amber Vault bombed |q 31200/1
		|only if havequest(31200)
	step
		goto 16.2,45.8
		.click Sra'thik Idol
		.' Western Idol destroyed |q 31198/2
		|only if havequest(31198)
	step
		goto 17.6,58.0
		.talk Shado-Pan Trainee##64459
		.' Tell them "No you're not!"
		.' Shado-Pan Trainee at Southern Feeding Pit freed. |q 31201/3
		|only if havequest(31201)
	step
		goto 17.4,57.0
		.talk Shado-Pan Trainee##64460
		.' Tell them "No you're not!"
		.' Shado-Pan Trainee at Southern Feeding Pit freed. |q 31201/2
		|only if havequest(31201)
	step
		goto 17.4,57.0
		.talk Sentinel Ku-Yao##61694
		.' Tell him his son has been looking for him.
		.' Search for Sentinel Ku-Yao. |q 30933/1
		|only if havequest(30933)
	step
		goto 18.0,53.5
		.talk Shado-Pan Trainee##64461
		.' Tell them "No you're not!"
		.' Shado-Pan Trainee at Southern Feeding Pit freed. |q 31201/1
		|only if havequest(31201)
	step
		goto 23.9,47.3
		'Use the Bag of Shado-Pan Gas Bombs at this location. |use Bag of Shado-Pan Gas Bombs##86532
		.' Nutriment Cell bombed |q 31200/2
		|only if havequest(31200)
	step
		'Make sure you have done the following around Sra'vess:
		.from Sra'thik Mutilator##63678+, Sra'thik Cacophyte##63680+, Sra'thik Drone##63677+, Sra'thik Regenerator##63681+, Sra'thik Swiftwing##63683+ |only if havequest(31196)
		.' Kill 15 Lesser Sra'thik mantid. |q 31196/1 |only if havequest(31196)
		.from Sra'thik Swarm-Leader##63685+, Sra'thik Vessguard##63686+, Sra'thik Will-Breaker##63684+, Sra'thik Deathmixer##63688+ |only if havequest(31197)
		.' Kill 4 Greater Sra'thik mantid. |q 31197/1 |only if havequest(31197)
	step
		'Next to you is either Hawkmaster Nurong or Taoshi
		.talk Taoshi##63617
		.talk Hawkmaster Nurong##63618
		..turnin Sra'vess Wetwork##31196
		..turnin The Bigger They Come...##31197
		..turnin A Morale Victory##31198
		..turnin Destroy the Siege Weapons!##31199
		..turnin Fumigation##31200
		..turnin Friends, Not Food!##31201 
		|only if not completedq(31221)
	step
		'Next to you is either Hawkmaster Nurong, Taoshi, or Tenwu.
		.'Talk to Taoshi |modelnpc 63617
		.'Talk to Hawkmaster Nurong |modelnpc 63618
		.'Talk to Tenwu of the Red Smoke |modelnpc 63616
		..turnin Sra'vess Wetwork##31196
		..turnin The Bigger They Come...##31197
		..turnin A Morale Victory##31198
		..turnin Destroy the Siege Weapons!##31199
		..turnin Fumigation##31200
		..turnin Friends, Not Food!##31201 
		|only if completedq(31221)
	step
		'Click the Quest Discovered box that displays on the right side of the screen under your minimap
		..accept Target of Opportunity: Sra'thik Hivelord##31204 |or
		..accept Target of Opportunity: Sra'thik Swarmlord##31203 |or
	step
		goto 16.4,40.9
		.kill Sra'thik Swarmlord##63693 |q 31203/1
		|only if havequest(31203)
	step
		'Enter the building here. |goto 27.1,44.1 <5 |c
		|only if havequest(31204)
	step
		goto 24.3,44.0
		.kill Sra'thik Hivelord##63694 |q 31204/1
		|only if havequest(31204)
	step
		'Leave the building. |goto 27.1,44.1 <5 |c
		|only if havequest(31204)
	step
		goto 48.7,71.1
		.talk Ku-Mo##65341
		..turnin Seeking Father##30933
		|only if havequest(30933)
	step
		goto 49.0,71.4
		.talk Ling of the Six Pools##63614
		..turnin Target of Opportunity: Sra'thik Hivelord##31204 |or
		..turnin Target of Opportunity: Sra'thik Swarmlord##31203 |or
		|next "end"
/// Exalted Reputation
	step
	label end
		goto 48.8,70.6
		.talk Rushi the Fox##64595
		..buy 1 Grand Commendation of the Shado-Pan##93220 |n
		.' Use the Commendation of the Shado-Pan you just purchased. |condition ZGV:GetReputation("Shado-Pan").hasBonus |use Grand Commendation of the Shado-Pan##93220
		|only if rep("Shado-Pan")>=Revered
	step
		goto 49.4,70.6
		.talk Master Snowdrift##63009
		..accept Mogu Incursions##31266
		|only if rep('Shado-Pan')==Exalted and not completedq(31266)
	step
		goto 48.8,58.6
		.kill Shan'ze Spymaster##63888 |q 31266/1
		|only if rep('Shado-Pan')==Exalted and not completedq(31266)
	step
		goto 49.4,70.6
		.talk Master Snowdrift##63009
		..turnin Mogu Incursions##31266
		..accept Surprise Attack!##31277
		|only if rep('Shado-Pan')==Exalted and not completedq(31277)
	step
		goto 42.6,63.9
		.talk Ban Bearheart##63908
		.' Tell him "Let's go".
		.' Join the battle of Niuzao Temple |q 31277/1
		|only if havequest(31277)
	step
		goto 41.3,60.0
		'Wait for the dialogue to end and fight off the invasion.
		.from Shan'ze Brutalizer##63933+
		.from Hei Feng##63920 |tip When he casts Deep Breath step behind him.
		.' Defeat the Mogu Invasion |q 31277/2
		|only if havequest(31277) 
	step
		goto 49.2,71.0
		.talk Ban Bearheart##62304
		..turnin Surprise Attack!##31277
		|only if havequest(31277)
	step
		'You have reached the end of this daily guide.
		.' Click here to return to the start of the dailies. |next "shado_dailies" |confirm
]])

ZygorGuidesViewer:RegisterInclude("Marista_Hub",[[
	step
		goto Krasarang Wilds 52.4,76.6
		.talk Nan-Po##60441
		.fpath Marista
	step
		goto Krasarang Wilds 51.7,75.3
		.talk Tony Tuna##60182
		..accept Particular Plumage##30667
	step
		goto 51.5,76.9
		.talk Jay Cloudfall##60173 |tip Outside, up the stairs and to the right
		..accept Sudden, Unexpected Crocolisk Aggression##30666
	step
		goto 46.4,68.6
		.from Crimson Lory##60198+
		.get 6 Crimson Tailfeather##80678+ |q 30667/2
		.from Emerald Lory##60200+
		.get 6 Emerald Tailfeather##80677+ |q 30667/1
		.from Dusky Lory##60196+
		.get 6 Dusky Tailfeather##80679+ |q 30667/3
 		.from Mortbreath Skulker##60202+, Mortbreath Snapper##60201+
 		.' Kill 8 Mortbreath crocolisk |q 30666/1
	step
		goto 51.7,75.3
		.talk Tony Tuna##60182
		..turnin Particular Plumage##30667
	step
		goto 51.5,76.9
		.talk Jay Cloudfall##60173
		..turnin Sudden, Unexpected Crocolisk Aggression##30666
		..accept Build Your Own Raft##30668
	step
		goto 52.3,77.9
		.click Tough Kelp
		.get Tough Kelp##80804 |q 30668/2
	step
		goto 52.4,76.2
		.click Spare Plank
		.get 4 Spare Plank##80685 |q 30668/1
	step
		goto 51.5,76.9
		.talk Jay Cloudfall##60173
		..turnin Build Your Own Raft##30668
		..accept The Lorewalker on the Lake##30669
	step
		goto 51.7,76.6
		.click Your Raft
		.' Pick up your raft |q 30669/1
	step
		goto 46.0,78.9
		.talk Wise Ana Wu##60139
		..turnin The Lorewalker on the Lake##30669
		..accept Wisdom Has A Price##30671
		..accept Misery##30691
	step
		.' Go underwater and enter the cave |goto 46.0,79.9 <5 |c
	step
		goto 46.2,83.5
		.from Nahassa##60203+ |tip Nahassa will use an ability called Feverish Deathbite that will cause you to hallucinate many more crocolisks have spawned, they aren't really there so don't panic.
		.' Put Nahassa out of his misery |q 30691/1
	step
		'Click the Complete Quest box that displays on the right side of the screen under your minimap
		..turnin Misery##30691
	step
		.' Exit the cave |goto 46.0,79.9 <5 |c
	step
		goto 46.0,79.0
		.from Great Grey Shark##60204+, Nayeli Hammerhead##60432+
		.get 5 Shark Fillet##80810+ |q 30671/1
	step
		goto 46.0,78.9
		.talk Wise Ana Wu##60139
		..turnin Wisdom Has A Price##30671
		..accept Balance##30672
	step
		goto 45.1,84.9
		'Run over one of the piles of fish along the beach.
		'Click the Quest Discovered box that displays on the right side of the screen under your minimap
		..accept Balance Without Violence##30674
	step
		.from Unga Fish-Getter##60299+
		.collect 1 Confusing Treasure Map##80827 |n
		.' Click the Confusing Treasure Map in your bags |use Confusing Treasure Map##80827
		..accept Buried Hozen Treasure##30675
	step
		goto 46.1,86.7
		.clicknpc Flailing Carp##60367 |tip You can find these all along the beach
		.' Throw 6 Flailing Carp back into the water |q 30674/1
		.kill 10 Unga Fish-Getter##60299+ |q 30672/1
		.click Lump of Sand
		.get Buried Hozen Treasure##80817 |q 30675/1
	step
		'Click the Complete Quest box that displays on the right side of the screen under your minimap
		..turnin Balance Without Violence##30674
		..turnin Buried Hozen Treasure##30675
	step
		goto 51.5,76.8
		.talk Jay Cloudfall##60173
		..turnin Balance##30672
	step
		goto Krasarang Wilds 29.7,39.0
		.talk Tired Shushen##58278
		..accept Thieving Raiders##30168
		..accept Raid Leader Slovan##30169
	step
		goto 31.8,29.0
		.kill Slovan##58285 |q 30169/1
		.from Riverblade Flesh-hunter##58274
		.get 5 Pillaged Jinyu Loot##78958 |q 30168/1
	step
		goto Krasarang Wilds 29.7,39.1
		.talk Tired Shushen##58278
		..turnin Thieving Raiders##30168
		..turnin Raid Leader Slovan##30169
	step
		goto 24.6,39.2
		.clicknpc Dawnchaser Captive##58608
		.' Rescue 8 Captives |q 30163/1
		.kill 8 Korjan Reclaimer##58614+ |q 30229/1
		.click Mogu Artifact
		.get 10 Mogu Artifact##79120+ |q 30230/1
	step
		goto 28.8,50.6
		.talk Kang Bramblestaff##56112
		..turnin Re-Reclaim##30230
	step
		goto 28.7,50.9
		.talk Kor Bloodtusk##58114
		..turnin For the Tribe##30163
		..turnin The Greater Danger##30229
	step
		goto 29.1,51.1
		.talk Ambassador Han##58630
		..accept The Mantid##30175
	step
		goto 16.0,39.8
		.talk Sunwalker Dezco##58607
		..accept The Stoneplow Convoy##30164
	step
		goto 15.3,35.3
		.clicknpc Stoneplow Envoy##58955
		.' Save 7 Stoneplow Envoy |q 30164/1
		.from Ik'thallik Precursor##58367+, Ik'thallik Vanguard##58368+
		.' Kill 10 Ik'thallik Mantid |q 30175/1
	step
		goto 16.0,39.8
		.talk Sunwalker Dezco##58607
		..turnin The Stoneplow Convoy##30164
	step
		goto 15.7,39.7
		.talk Ambassador Len##58954
		..turnin The Mantid##30175
	step
		goto 16.0,39.8
		.talk Sunwalker Dezco##58607
		..accept For Family##30174
	step
		goto 23.6,48.8
		.talk Kor Bloodtusk##58670
		.' Try to free Kor from his bonds
		.kill Groundbreaker Brojai##58224 |q 30174/1 |tip He will summon adds one at a time. They aren't too difficult to kill.
	step
		goto 28.9,50.8
		.talk Sunwalker Dezco##58607
		..turnin For Family##30174
		..accept Warn Stoneplow##30241
	step
		goto Valley of the Four Winds 19.5,56.8
		.talk Loon Mai##56720
		..turnin Warn Stoneplow##30241
	step
		goto 18.1,55.9
		.talk Mudmug##56474
		..accept It Does You No Good In The Keg##30653
	step
		goto Valley of the Four Winds 18.0,56.3
		.talk Loon Mai##56720
		..accept The Swarm Begins##30622
	step
		goto Valley of the Four Winds 18.0,56.5
		.talk Mei Barrelbottom##59855
		..accept The Mantidote##30623
	step
		goto Valley of the Four Winds 17.5,50.2
		.' Deliver beer to Zhu's Wardens |q 30653/1
	step
		goto Valley of the Four Winds 15.2,55.4
		.' Deliver beer to Crane Wing Priests |q 30653/2
	step
		goto Valley of the Four Winds 13.0,56.0
		.' Deliver beer to Tauren Settlers |q 30653/4
	step
		goto Valley of the Four Winds 10.7,55.5
		.' Deliver beer to Shado-Pan |q 30653/3
	step
		.' Click the Complete Quest box that displays on the right side of the screen under your minimap
		..turnin It Does You No Good In The Keg##30653
	step
		goto 13.4,54.6
		.from Ik'thallik Infestor##56721+, Ik'thik Warrior##56722+
		.' Kill 15 Ik'thallik Infestors or Warriors |q 30622/1
		.' Use Ken-Ken's mask on Ik'thik Wing Commanders. |use Ken-Ken's Mask##80337
		.from Manifestation of Fear##59874+ 
		.' Defeat 5 Manifestation of Fear that come out of Ik'thik Wing Commanders. |q 30623/1 
	step
		.' Click the Complete Quest box that displays on the right side of the screen under your minimap
		..turnin The Mantidote##30623
	step
		goto 11.6,49.5
		.talk Guard Captain Oakenshield##57198
		..turnin The Swarm Begins##30622
		..accept Students No More##30625
	step
		'The students you are looking for can be at one of four locations fighting one of the quest mobs below. Find the students and kill the follow monsters:
		.'Ik'thallik Tendon-Slicer at [9.5,54.0]
		.kill Ik'thallik Tendon-Slicer##59888 |q 30625/3
		.'Ik'thallik Fearmonger at [9.5,58.2]
		.kill Ik'thallik Fearmonger##59889 |q 30625/4
		.'Ik'thallik Bloodrager at [8.9,54.2]
		.kill Ik'thallik Bloodrager##59887 |q 30625/1
		.'Ik'thik Incubator at [8.9,51.0]
		.kill Ik'thik Incubator##59890 |q 30625/2
	step
		goto 11.6,49.5
		.talk Guard Captain Oakenshield##57198
		..turnin Students No More##30625
		..accept Retreat!##30626
	step
		goto 18.0,56.3
		.talk Loon Mai##56720
		..turnin Retreat!##30626
	step
		goto 17.9,55.7
		.talk Master Bruised Paw##59856
		..accept The Savior of Stoneplow##30627
	step
		goto 18.0,56.7 |n
		.talk Miss Fanny##59857
		.' Tell her "Let's go". |invehicle
	step
		'Use your Unyielding Fist ability to defeat the Mantid Collossus. |tip Use your Unyielding Fist ability when the new icon on your screens flashes orange
		.kill Mantid Colossus##56703 |q 30627/1
	step
		goto 18.0,56.3
		.talk Loon Mai##56720
		..turnin The Savior of Stoneplow##30627
		..accept The Gratitude of Stoneplow##30628
]])

ZygorGuidesViewer:RegisterInclude("August_Celestials",[[
	step
	label startaug
		goto Vale of Eternal Blossoms 62.8,23.4
		.talk Sage Lotusbloom##64001
		.' The following quests will only be available the first time you are sent to a new area. They are random and Sage Lotusbloom will only have one at a time.
		..accept Challenge At The Temple of the Red Crane##31379 |or |next "crane" |only if not completedq(31379)
		..accept Attack At The Temple of the Jade Serpent##31377  |or |next "serpent" |only if not completedq(31377)
		..accept Defense At Niuzao Temple##31383 |or |next "ox" |only if not completedq(31383)
		..accept Trial At The Temple of the White Tiger##31381 |or |next "tiger" |only if not completedq(31381)
		.' If no quest is available, ask her how you can help the August Celestials today. Then click on whichever spirit needs you today.
		.' Niuzao the Black Ox |confirm |next "ox"
		.' Yu'lon the Jade Serpent |confirm |next "serpent"
		.' Xuen the White Tiger |confirm |next "tiger"
		.' Chi-Ji the Red Crane |confirm |next "crane"
// Crane
	step
	label crane
		goto Krasarang Wilds 31.3,63.4
		.talk Thelonius##60506
		..turnin Challenge At The Temple of the Red Crane##31379
		|only if not completedq(31379)
	step
		goto 31.3,63.4
		.talk Thelonius##60506
		..accept Students of Chi-Ji##30718
		..accept Champion of Chi-Ji##30740 |only if achieved(7287)
	step
		goto 31.3,63.6
		.talk Yan Quillpaw##60529
		..accept Gifts of the Great Crane##30717
	step
		goto 31.3,63.6
		.talk Kuo-Na Quillpaw##60528
		..accept Chasing Hope##30716
	step
		goto 34.6,82.0
		.talk Champion of Chi-Ji##60546
		.' Let's fight!
		.' Defeat a Champion of Chi-Ji |q 30740/1
		|only if havequest(30740)
	step
		goto 31.2,73.9
		.from 10 Student of Chi-Ji##60601+
		.' Duel 10 Students of Chi-Ji |q 30718/1
		.click Cerulean Gift of the Crane
		.click Crimson Gift of the Crane
		.click Bronze Gift of the Crane
		|tip The Gifts look like feathers laying around on the ground.
		.get 10 Gift of the Great Crane##80938+ |q 30717/1
		.' Find 3 Spirits of the Crane |q 30716/1 |tip They look like stealthed birds roaming around the isle in set paths. Run into them.
	step
		goto 31.3,63.6
		.talk Kuo-Na Quillpaw##60528
		..turnin Chasing Hope##30716
	step
		goto 31.3,63.6
		.talk Yan Quillpaw##60529
		..turnin Gifts of the Great Crane##30717
	step
		goto 31.3,63.4
		.talk Thelonius##60506
		..turnin Students of Chi-Ji##30718
		..accept Ellia Ravenmane##30725 |or
		..accept Minh Do-Tan##30726 |or
		..accept Ellia Ravenmane: Rematch##30727 |or
		..accept Fat Long-Fat##30728 |or
		..accept Julia Bates##30729 |or
		..accept Dextrous Izissha##30730 |or
		..accept Kuo-Na Quillpaw##30731 |or
		..accept Ellia Ravenmane: Revenge##30732 |or
		..accept Tukka-Tuk##30733 |or
		..accept Huck Wheelbarrow##30734 |or
		..accept Mindel Sunspeaker##30735 |or
		..accept Yan Quillpaw##30736 |or
		..accept Fat Long-Fat: Rematch##30737 |or
		..accept Thelonius##30738 |or
		..accept Ellia Ravenmane: Redemption##30739 |or
		|only if not achieved(7287)
	step
		goto 31.3,63.4
		.talk Thelonius##60506
		..turnin Students of Chi-Ji##30718
		..turnin Champion of Chi-Ji##30740
		|only if achieved(7287)
		|next "end"
	step
		goto 32.0,70.7
		.talk Fat Long-Fat##60534 |tip He is on the very top of this building.
		.' Let's fight!
		.' Defeat Fat Long-Fat |q 30728/1
	step
		goto 31.8,71.2
		.talk Ellia Ravenmane##60530
		.' Let's fight!
		.' Defeat Ellia Ravenmane |q 30725/1
	step
		goto 32.1,69.9
		.talk Mindel Sunspeaker##60541
		.' Let's fight!
		.' Defeat Mindel Sunspeaker |q 30735/1
	step
		goto 32.0,76.5
		.talk Minh Do-Tan##60532
		.' Let's fight!
		.' Defeat Minh Do-Tan |q 30726/1
	step
		goto 34.1,75.1
		.talk Tukka-Tuk##60539
		.' Let's fight!
		.' Defeat Tukka-Tuk |q 30733/1
	step
		goto 36.4,75.6
		.talk Ellia Ravenmane##60545
		.' Let's fight!
		.' Defeat Ellia Ravenmane |q 30739/1
	step
		goto 31.7,80.3
		.talk Dextrous Izissha##60536
		.' Let's fight!
		.' Defeat Dextrous Izissha |q 30730/1
	step
		goto 34.8,82.6
		.talk Fat Long-Fat##60543
		.' Let's fight!
		.' Defeat Fat Long-Fat |q 30737/1
	step
		goto 36.6,74.8
		.talk Kuo-Na Quillpaw##60537
		.' Let's fight!
		.' Defeat Kuo-Na Quillpaw |q 30731/1
	step
		goto 35.2,75.1
		.talk Ellia Ravenmane##60533
		.' Let's fight!
		.' Defeat Ellia Ravenmane |q 30727/1
	step
		goto 28.9,75.5
		.talk Julia Bates##60535
		.' Let's fight!
		.' Defeat Julia Bates |q 30729/1
	step
		goto 27.9,70.3
		.talk Huck Wheelbarrow##60540
		.' Let's fight!
		.' Defeat Huck Wheelbarrow |q 30734/1
	step
		goto 36.5,76.2
		.talk Yan Quillpaw##60542
		.' Let's fight!
		.' Defeat Yan Quillpaw |q 30736/1
	step
		goto 34.5,83.3
		.talk Ellia Ravenmane##60538
		.' Let's fight!
		.' Defeat Ellia Ravenmane |q 30732/1
	step
		goto 28.8,72.4
		.talk Thelonius##60544
		.' Let's fight!
		.' Defeat Thelonius |q 30738/1
	step
		goto 31.3,63.4
		.talk Thelonius##60506
		..turnin Ellia Ravenmane##30725 |or
		..turnin Minh Do-Tan##30726 |or
		..turnin Ellia Ravenmane: Rematch##30727 |or
		..turnin Fat Long-Fat##30728 |or
		..turnin Julia Bates##30729 |or
		..turnin Dextrous Izissha##30730 |or
		..turnin Kuo-Na Quillpaw##30731 |or
		..turnin Ellia Ravenmane: Revenge##30732 |or
		..turnin Tukka-Tuk##30733 |or
		..turnin Huck Wheelbarrow##30734 |or
		..turnin Mindel Sunspeaker##30735 |or
		..turnin Yan Quillpaw##30736 |or
		..turnin Fat Long-Fat: Rematch##30737 |or
		..turnin Thelonius##30738 |or
		..turnin Ellia Ravenmane: Redemption##30739 |or
		|only if not achieved(7287)
		|next "end"
////Not always here,
	step
	label serpent
		goto The Jade Forest 53.9,61.9
		.talk Elder Sage Tai-Feng##57324
		..turnin Attack At The Temple of the Jade Serpent##31377 |only if havequest(31377)
		..accept Arrows of Fortune##30065 |or
		..accept Hidden Power##30066 |or
		..accept The Darkness Around Us##30006 |or
	step
		goto 53.9,61.9
		.talk Elder Sage Storm-Sing##57319
		..accept Behind the Masks##30063
		..accept Saving the Sutras##30064
		'Click here if he has no quests today. |confirm
	step
		goto 56.5,53.6
		.click Ancient Sutra
		.get 6 Ancient Sutra##77432 |q 30064/1
		|only if havequest(30064)
	step
		goto 55.3,57.4
		.from Final Doubt##57330+, Lingering Doubt##57396+ |only if havequest(30063)
		.get 8 Mask of Doubt##77419+ |q 30063/1 |only if havequest(30063)
		.click Defender's Arrow |only if havequest(30065)
		.get 10 Defender's Arrow##77452+ |q 30065/1 |only if havequest(30065)
		.' Use the Stack of Mantras in your bags on Yu'lon Adepts and Yu'lon Guardians |use Stack of Mantras##77475 |only if havequest(30066)
		.' Deliver 6 Ancient Mantras |q 30066/1 |only if havequest(30066)
		|modelnpc Yu'lon Guardian##57400
		|modelnpc Yu'lon Adept##57316
	step
		goto 53.4,54.2
		.from Final Doubt##57330+, Lingering Doubt##57396+, Shadow Of Doubt##57389
		.' Kill 15 Sha Invaders |q 30006/1
		|only if havequest(30006)
	step
		goto 53.9,61.9
		.talk Elder Sage Storm-Sing##57319
		..turnin Behind the Masks##30063
		..turnin Saving the Sutras##30064 
	step
		goto The Jade Forest 53.9,61.9
		.talk Elder Sage Tai-Feng##57324
		..turnin Arrows of Fortune##30065 
		..turnin Hidden Power##30066
		..turnin The Darkness Around Us##30006
		..accept Flames of the Void##30068
		..accept The Shadow of Doubt##30067
		|noquest
	step
		goto 57.5,62.3
		.kill Shadow of Doubt##57389 |q 30067/1
		|only if havequest(30067)
	step
		goto 54.1,60.9
		.clicknpc War Serpent##57871
		.' Ride the War Serpent |invehicle
		|only if havequest(30068)
	step
		'Fly around the Jade Temple Grounds and extinguish Void Flames. |tip they look like black fire.
		.' If you run out of water you can refill it in the river [53.9,58.0]
		.' Douse 6 Void Flames |q 30068/1
		|only if havequest(30068)
	step
		goto 53.9,61.9
		.' Click the Leave Vehicle button. |outvehicle
		|only if havequest(30068)
	step
		goto 53.9,61.9
		.talk Elder Sage Tai-Feng##57324
		..turnin The Shadow of Doubt##30067
		..turnin Flames of the Void##30068
		|next "end"
/// Temple of the White Tiger. Not giving rep for August Celstials.
	step
	label tiger
		goto Kun-Lai Summit 67.2,55.9
		.talk Xuen##60968
		..turnin Trial At The Temple of the White Tiger##31381 
		|only if havequest(31381)
	step
		goto 67.2,55.9
		.talk Xuen##60968
		..accept Round 1: Brewmaster Chani##30879 |or
		..accept Round 1: The Streetfighter##30880 |or 
		..accept Contending With Bullies##31517 |tip This quest may not be available.
		|confirm
	step
		goto 71.1,55.8
		.kill Shonuf##64757 |q 31517/1
		|only if havequest(31517)
	step
		goto 71.0,51.8
		.talk Brewmaster Chani##60996
		.' Challenge her. |tip She has a lot of health but isn't too difficult to kill. She will toss Bitter Brew on the ground, so kite her out of it. She also has an AoE cone called The Steamer, you can avoid this by either moving out of it, or interrupting the channel.
		.'Defeat Brewmaster Chani |q 30879/1
		|only if havequest(30879)
	step
		goto 71.0,51.8
		.talk Lun-Chi##60994
		.' Challenge her.
		.' Defeat The Streetfighter |q 30880/1
		|only if havequest(30880)
	step
		goto 70.3,51.3
		.talk Xuen##60968
		..turnin Round 1: Brewmaster Chani##30879 
		..turnin Round 1: The Streetfighter##30880 
		..turnin Contending With Bullies##31517
		..accept Round 2: Clever Ashyo & Ken-Ken##30881 |or
		..accept Round 2: Kang Bramblestaff##30882 |or
	step
		goto 71.7,45.4
		.talk Kang Bramblestaff##60978
		.' Challenge him.
		.' Defeat Kang Bramblestaff |q 30882/1
		|only if havequest(30882)
	step
		goto 71.7,45.4
		.talk Clever Ashyo##60980
		.' Challenge him. |tip Kill Ken-Ken first as he is the weaker of the two. He will cast Ken-Ken Rampage causing him to whirlwind, when he does momentarily switch to Ashyo. Ashyo will summon Water Spouts and Healing Spheres. The Spheres are top priority and the Spouts are easily avoidable.
		.' Defeat Clever Ashyo |q 30881/1
		.' Defeat Ken-Ken |q 30881/2
		|modelnpc Ken-Ken##60979
		|only if havequest(30881)
	step
		goto 71.8,44.9
		.talk Xuen##60968
		..turnin Round 2: Clever Ashyo & Ken-Ken##30881
		..turnin Round 2: Kang Bramblestaff##30882
		..accept Round 3: The Wrestler##30883 |or
		..accept Round 3: Master Boom Boom##30885 |or
	step
		goto 66.7,46.5
		.talk Master Boom Boom##61013
		.' Challenge him. |tip He will constantly toss Dynamite at you that will put a landmine on the ground if you walk over it. When he starts the fuse on his boom box, be out of the middle of the arena by the time it finishes.
		.' Defeat Master Boom Boom |q 30885/1
		|only if havequest(30885)
	step
		goto 66.7,46.5
		.talk The Wrestler##60997
		.' Challenge him. |tip Click on the chairs around the room to increase your damage and cause The Wrestler to be stunned for 10 seconds. If you space these out enough, you could potentially kill him before he can hurt you. Periodically he will grapple and throw you, it does not do much damage but it prevents control of your character. Finally, he uses a Sling Sweat ability which puts a blue puddle on the ground that reduces your movement speed and does damage.
		.' Defeat The Wrestler |q 30883/1
		|only if havequest(30883)
	step
		goto 66.4,46.3
		.talk Xuen##60968
		..turnin Round 3: The Wrestler##30883
		..turnin Round 3: Master Boom Boom##30885
		..accept Round 4: The P.U.G.##30907 |or
		..accept Round 4: Master Windfur##30902 |or
	step
		goto 68.8,43.8
		.talk Master Windfur##61012
		.' Challenge him.
		.' Defeat Master Windfur. |q 30902/1
		|only if havequest(30902)
	step
		'Enter the building and go to [69.0,43.7]
		.talk Healiss##61004
		.' Challenge him. |tip Defeat the P.U.G. by first kill Healiss. He will attempt to run away and only has one healing spell that he may try to use, it is called Jungle Remedy, save Interrupts and Stuns for this ability. Next deal with Tankiss, he has more health but is a greater threat than Hackiss, his only ability is called Ground Pummel which will knock you can and deal some damage. Finally kill Hackiss, his only ability is Backstab. This will leave a small bleed on you.
		.' Defeat Hackiss |q 30907/1
		.' Defeat Healiss |q 30907/2
		.' Defeat Tankiss |q 30907/3
		|modelnpc Hackiss##61007
		|modelnpc Tankiss##61006
		|only if havequest(30907)
	step
		goto 68.5,44.6
		.talk Xuen##60968
		..turnin Round 4: The P.U.G.##30907
		..turnin Round 4: Master Windfur##30902
	step
		goto Kun-Lai Summit 68.5,56.5
		.talk Lin Tenderpaw##60981
		..accept The Torch of Strength##31492
		.' Click here if this quest is unavailable |confirm |next "end"
	step
		'For this quest you must go up the path, avoiding all of the tornadoes that roam around. If you mount, or touch a tornado, you will have to go back to Lin and start the quest over.
		|confirm
	step
		goto 69.6,53.0 |n
		.' Enter the first temple here. |goto 69.6,53.0 |noway |c
	step
		goto 66.9,51.2 |n
		.' Enter the second temple here. |goto 66.9,51.2 |noway |c
	step
		goto 68.6,46.6
		.' Click _The Strong Brazier_ to light it.
		.' Light the Strong Brazier |q 31492/1
	step
		goto Kun-Lai Summit 68.5,56.5
		.talk Lin Tenderpaw##60981
		..turnin The Torch of Strength##31492
		|next "end"
/// Niuzao Temple. Possible unlock hub at revered.
	step
	label ox
		goto Townlong Steppes 39.3,62.3
		.talk Ogo the Elder##61580
		..turnin Defense At Niuzao Temple##31383 |only if havequest(31383)
		..accept The Siege Swells##30956 |or
		..accept The Unending Siege##30952 |or
	step
		goto 39.3,62.3
		.talk Ogo the Younger##61581
		..accept The Big Guns##30959 |or
		..accept A Blade is a Blade##30954 |or
	step
		goto 39.2,62.1
		.talk Yak-Keeper Kyana##61585
		..accept Fallen Sentinels##30953
		.' If this quest is unavailable today, click here. |confirm
	step
		goto 39.4,61.9
		.talk Sentinel Commander Qipan##61584
		..accept The Overwhelming Swarm##30957
		.' If this quest is unavailable today, click here. |confirm
	step
		goto 38.9,62.4
		.talk High Adept Paosha##61583
		..accept In Battle's Shadow##30958 |or
		..accept Paying Tribute##30955 |or
	step
		'The following can all be done around Niuzao Temple:
		.' Use your Pot of Fire on Sra'thik War Wagons |use Pot of Fire##82346 |modelnpc Sra'thik War Wagon##61510 |only if havequest(30959)
		.' Cause 3 Sri'thik War Wagons to explode. |q 30959/1 |only if havequest(30959)
		.from Sra'thik Swiftclaw##61508+, Sra'thik Warcaller##61502+, Sra'thik Fleshrender##61514+ |only if havequest(30956)
		.' Kill 25 Sri'thik attackers |q 30956/1 |only if havequest(30956)
		.kill 4 Sra'thik Kunchong##61509+ |q 30957/1 |only if havequest(30957)
		.click Loose Brick |only if havequest(30958)
		.' Throw 10 Loose Stones up to Niuzao Stonemasons |q 30958/1 |only if havequest(30958)
		.' Use your Yak's Milk Flask on Wounded Niuzao Sentinels. |use Yak's Milk Flask##82381 |tip Normal healing spells will also heal the Sentinels if you have them. |only if havequest(30953)
		.' Heal 8 Niuzao Sentinels |q 30953/1 |only if havequest(30953)
		.click Niuzao Food Supply |only if havequest(30955)
		.' Gather 6 Food for Niuzao |q 30955/1 |only if havequest(30955)
		.from Sra'thik Warcaller##61502+, Sra'thik Swiftclaw##61508+ |only if havequest(30952)
		.' Kill 12 Sra'thik attackers |q 30952/1 |only if havequest(30952)
		.click Sra'thik Weapon |tip After you kill a Sra'thik a weapon may drop. |only if havequest(30954)
		.get 10 Sra'thik Weapon##82353 |q 30954/1 |only if havequest(30954)
	step
		goto 39.3,62.3
		.talk Ogo the Elder##61580
		..turnin The Siege Swells##30956 
		..turnin The Unending Siege##30952 
	step
		goto 39.3,62.3
		.talk Ogo the Younger##61581
		..turnin The Big Guns##30959 
		..turnin A Blade is a Blade##30954 
	step
		goto 39.2,62.1
		.talk Yak-Keeper Kyana##61585
		..turnin Fallen Sentinels##30953 
		..turnin In Battle's Shadow##30958 
	step
		goto 39.4,61.9
		.talk Sentinel Commander Qipan##61584
		..turnin The Overwhelming Swarm##30957
	step
		goto 38.9,62.4
		.talk High Adept Paosha##61583
		..turnin Paying Tribute##30955
	step
	label "end"
		goto Vale of Eternal Blossoms 62.8,23.4
		.talk Sage Lotusbloom##64001
		..buy 1 Grand Commendation of the August Celestials##93224 |n
		.' Use the Commendation of the August Celestials you just purchased. |condition ZGV:GetReputation("August Celestials").hasBonus |use Grand Commendation of the August Celestials##93224
		|only if rep("August Celestials")>=Revered
	step
		'You have reached the end of this daily guide.
		.' Click here to return to the start of the dailies. |next "startaug" |confirm
]])

ZygorGuidesViewer:RegisterInclude("Dominance_Offensive",[[
	startlevel 90
	step
		'Proceeding to the Dominance Offensive Dailies |next "dailies" |condition completedq(32108) |only if completedq(32108)
		'Proceeding to the Dominance Offensive Prequests |next |condition not completedq(32108) |only if not completedq(32108)
	step
		goto Vale of Eternal Blossoms 62.9,28.3
		.talk Sunwalker Dezco##64566
		..accept Meet the Scout##32249
	step
		goto Krasarang Wilds 8.7,64.4
		.talk Scout Rokla##67812
		..turnin Meet the Scout##32249
	step
		goto Krasarang Wilds 8.7,64.4
		.talk Garrosh Hellscream##62092
		..accept The Might of the Warchief##32250
	step
		goto Krasarang Wilds 10.0,64.1
		.from Alliance Sentinel##67900+, Alliance Footman##+, Alliance Priest##+
		..' Kill 25 Alliance troops |q 32250/1
	step
		goto Krasarang Wilds 10.7,53.2
		.talk Blood Guard Gro'tash##67927
		..' Find Blood Guard Gro'tash |q 32250/2
	step
		goto Krasarang Wilds 15.7,57.8
		.talk Grizzle Gearslip##67926
		..' Find Grizzle Gearslip |q 32250/3
	step
		'Next to you
		.talk Garrosh Hellscream##62092
		..turnin The Might of the Warchief##32250
		..accept Domination Point##32108
	step
		goto 8.5,63.8
		.click Signal Fire
		..turnin Domination Point##32108
	step
		goto Krasarang Wilds 9.7,52.5
		.talk Kromthar##67785
		.fpath Domination Point
	step
	label "dailies"
		goto Krasarang Wilds 10.1,53.9
		.talk Blood Guard Gro'tash##67880
		..accept The Ruins of Ogudei##32449 |or |next "ogudei"
		..accept The Time is Now!##32450 |or |next "lion"
		..accept Flash! Aaaaaahhhh!##32235 |or |next
		.' If no quests are available, click here |confirm |next "cave"
	step
		goto Krasarang Wilds 10.2,53.6
		.talk Brolic##67767
		..accept Tear It Up##32126
	step
		goto Krasarang Wilds 10.3,55.6
		.talk Shokia##56411
		..accept Death on Two Legs##32123
	step
		goto Krasarang Wilds 11.8,57.6
		.' Fly up in the air and throw your Bilgewater Molotovs at the Skyfire Gyrocopter X2s |use The Bilgewater Molotov##92019
		.' Kill 6 Skyfire Gyrocopter X2s |q 32235/1
	step
		goto Krasarang Wilds 8.1,61.3
		.click Alliance Supply Drop
		.' Destroy 8 Alliance Supply Drops |q 32126/1
	step
		goto 9.9,64.2
		.from Shieldwall Marine##+, Shieldwall Stormcaller##+,
		.' Kill 10 Alliance Troops |q 32123/1
	step
		goto Krasarang Wilds 10.3,55.6
		.talk Shokia##56411
		..turnin Death on Two Legs##32123
	step
		goto Krasarang Wilds 10.3,53.1
		.talk Brolic##67767
		..turnin Tear It Up##32126
	step
		goto Krasarang Wilds 10.1,53.9
		.talk Blood Guard Gro'tash##67880
		..turnin Flash! Aaaaaahhhh!##32235
		..accept Another One Bites the Dust##32128
	step
		goto Krasarang Wilds 10.3,53.1
		.talk Brolic##67767
		..accept All Dead, All Dead##32127
	step
		goto Krasarang Wilds 12.7,75.8
		.from Captain Brent the Black##+ |tip On the second floor of the ship, towards the back.
		..kill Captain Brent the Black |q 32127/1
	step
		goto Krasarang Wilds 12.3,75.6
		.click Powder Magazine |tip It's on the bottom floor of the ship, next to Fireworks and Bombs.
		.' Destroy the Defiant ammunition |q 32128/2
	step
		goto Krasarang Wilds 15.0,76.4
		.from Captain Mulkey##+ |tip On the second floor of the ship, towards the back.
		..kill Captain Mulkey |q 32127/2
	step
		goto Krasarang Wilds 15.1,76.6
		.click Powder Magazine |tip It's on the bottom floor of the ship, next to Fireworks and Bombs.
		.' Destroy the Valor's Edge ammunition |q 32128/1
	step
		goto Krasarang Wilds 10.1,53.9
		.talk Blood Guard Gro'tash##67880
		..turnin Another One Bites the Dust##32128
	step
		goto Krasarang Wilds 10.3,53.1
		.talk Brolic##67767
		..turnin All Dead, All Dead##32127
		|next "end" |only if default
		|next "friendly" |only if repval('Dominance Offensive','Friendly')>=950 and not completedq(32257)
		|next "friendly2" |only if repval('Dominance Offensive','Friendly')>=4900 and not completedq(32372)
		|next "honored" |only if repval('Dominance Offensive','Honored')>=3250 and not completedq(32244)
		|next "honored2" |only if repval('Dominance Offensive','Honored')>=7300 and not completedq(32384)
		|next "honored3" |only if repval ('Dominance Offensive','Honored')>=10800 and not completedq(32352)
		|next "revered" |only if repval ('Dominance Offensive','Revered')>=2400 and not completedq(32330)
		|next "revered2" |only if repval ('Dominance Offensive','Revered')>=6850 and not completedq(32368)
		|next "revered3" |only if repval ('Dominance Offensive','Revered')>=10600 and not completedq(32392)
		|next "revered4" |only if repval ('Dominance Offensive','Revered')>=14500 and not completedq(32328)
		|next "revered5" |only if repval ('Dominance Offensive','Revered')>=18500 and not completedq(32412)
		|next "exalted" |only if rep("Dominance Offensive")==Exalted
	step
	label "cave"
		goto Krasarang Wilds 12.8,56.8
		.click Bounty Board
		..accept Wanted: Lieutenant Ethan Jacobson##32223 |or
		..accept Wanted: Chief Engineer Cogwrench##32222 |or
	step
		goto Krasarang Wilds 13.0,56.2
		.talk Rivett Clutchpop##67608
		..accept Storming the Beach##32221 |or
		..accept Bilgewater Infiltrators##32214 |or
	step
		goto Krasarang Wilds 13.7,55.8
		.talk Duke##67562
		..accept Krasarang Steampot##32199 |or
		..accept Mystery Meatloaf##32197 |or
	step
		goto Krasarang Wilds 13.7,55.8
		.talk Boss-Lady Trixel##67535
		..accept Work Order: Iron##32140 |or
		..accept Work Order: Fuel##32136 |or
		..accept Work Order: Lumber##32138 |or
	step
		goto Krasarang Wilds 9.9,60.8
		.' Use the "New" and "Improved" Infared Heat Focals in your bags. |use "New" and "Improved" Infared Heat Focals##92475
		.from SI:7 Saboteur##67689+
		.' Kill 10 SI:7 Saboteurs |q 32214/1
		|only if havequest(32214)
	step
		goto Krasarang Wilds 17.7,54.7
		.from Polluted Viseclaw##67896+, Polluted Viseclaw Scuttler##68584+
		.collect 5 Polluted Viseclaw Meat##91869 |q 32199/1
		|only if havequest(32199)
	step
		goto Krasarang Wilds 15.9,65.1
		.from Mature Terrapin##67895+, Polluted Viseclaw##67896+, Polluted Viseclaw Scuttler##68584+
		.collect 7 Chunk of Mystery Meat##91874 |q 32197/1
		|only if havequest(32197)
	step
		goto Krasarang Wilds 19.0,71.0
		..kill Lieutenant Ethan Jacobson##68028 |q 32223/1
		|only if havequest(32223)
	step
		 goto Krasarang Wilds 21.6,51.2
		 ..kill Chief Engineer Cogwrench##68012 |q 32222/1
		 |only if havequest(32222)
	step
		goto Krasarang Wilds 18.8,68.2
		.from Shieldwall Marine##67354+
		.from Dwarven Mortar Team Engineer##67545+
		.from Shieldwall Stormcaller##67425+
		.' Kill 10 Shieldwall Forces |q 32221/1
		|only if havequest(32221)
	step
		goto Krasarang Wilds 20.5,58.1
		.talk Zino "The Shredder" Quickchop##67534
		..turnin Work Order: Lumber##32138
		..accept Stacked!##32139
		|only if havequest(32138) or completedq(32138)
	step
		goto Krasarang Wilds 22.6,62.3
		.talk Daxil "The Gem" Oregrind##67537
		..turnin Work Order: Iron##32140
		..accept Power Metal##32141
		|only if havequest(32140) or completedq(32140)
	step
		goto Krasarang Wilds 25.5,60.4
		.talk Grizzle Gearslip##67542
		..turnin Work Order: Fuel##32136
		..accept Runnin' On Empty##32137
		|only if havequest(32136) or completedq(32136)
	step
		goto Krasarang Wilds 20.6,58.1
		.talk Bixy Buzzsaw##67533
		..accept Universal Remote-Explode##32238
		|only if completedq(32138)
	step
		goto Krasarang Wilds 25.3,60.4
		.talk Bixy Buzzsaw##67553
		..accept Precious Resource##32237
		|only if completedq(32136)
	step
		goto Krasarang Wilds 22.4,62.2
		.talk Bixy Buzzsaw##67553
		..accept Bug Off!##32236
		|only if completedq(32140)
	step
		goto Krasarang Wilds 20.2,60.7
		.click Domination Point Lumber## |only if havequest(32139)
		.collect 9 Domination Point Lumber |q 32139/1 |only if havequest(32139)
		'Use your Universal Remote on Shieldwall Mecha-Pounders to weaken them. |use Universal Remote##91902 |only if havequest(32238)
		.kill 9 Shieldwall Mecha-Pounder##68011 |q 32238/1 |only if havequest(32238)
		|only if havequest(32139) or havequest(32238)
	step
		goto Krasarang Wilds 23.5,56.4
		.click Fauly Valve
		.' Tighten 8 Faulty Valves |q 32237/1
		|only if havequest(32237)
	step
		goto Krasarang Wilds 26.5,63.2
		.click "Distilled" Fuel Barrel
		..get 9 "Distilled" Fuel Barrel |q 32137/1
		|only if havequest(32137)
	step
		goto Krasarang Wilds 19.9,62.5
		'Use your Hand-Dandy Bug Off Sprayer on _Agitated Shale Spiders_ to spawn Shale Shards |use Hand-Dandy Bug Off Sprayer##93026 |only if havequest(32236)
		.' Spray 5 Agitated Shale Spiders |q 32236/1 |only if havequest(32236)
		.kill 12 Shale Shards##68653+ |q 32236/2 |only if havequest(32236)
		'Click _Energized Iron_ deposits on the sides of the cave to spawn Energized Iron Ore Chunks. |only if havequest(32141)
		.click Energized Iron Ore Chunk |only if havequest(32141)
		.get 7 Energized Iron Ore Chunk |q 32141/1 |only if havequest(32141)
		|modelnpc Agitated Shale Spider##67759 |only if havequest(32236)
		|only if havequest(32236) or havequest(32141)
	step
		goto Krasarang Wilds 20.6,58.1
		.talk Bixy Buzzsaw##67533
		..turnin Universal Remote-Explode##32238
		|only if havequest(32238)
	step
		goto Krasarang Wilds 20.5,58.1
		.talk Zino "The Shredder" Quickchop##67534
		..turnin Stacked!##32139
		|only if havequest(32139)
	step
		goto Krasarang Wilds 22.4,62.2
		.talk Bixy Buzzsaw##67553
		..turnin Bug Off!##32236 
		|only if havequest(32236)
	step
		goto Krasarang Wilds 25.3,60.4
		.talk Bixy Buzzsaw##67553
		..turnin Precious Resource##32237
		|only if havequest(32237)
	step
		goto Krasarang Wilds 26.0,58.1
		.talk Sezik Steampot##67536
		..turnin Krasarang Steampot##32199 |only if havequest(32199)
		..turnin Mystery Meatloaf##32197 |only if havequest(32197)
		|only if havequest(32199) or havequest(32197)
	step
		goto Krasarang Wilds 13.8,55.9
		.talk Boss-Lady Trixel##67535
		..turnin Power Metal##32141 |only if havequest(32141)
		..turnin Runnin' On Empty##32137 |only if havequest(32137)
		|only if havequest(32137) or havequest(32141)
	step
		goto Krasarang Wilds 13.0,56.1
		.talk Rivett Clutchpop##67608
		..turnin Storming the Beach##32221 |only if havequest(32221)
		..turnin Bilgewater Infiltrators##32214 |only if havequest(32214)
		|only if havequest(32214) or havequest(32221)
	step
		goto Krasarang Wilds 10.1,53.9
		.talk Blood Guard Gro'tash##67880
		..turnin Wanted: Lieutenant Ethan Jacobson##32223 |only if havequest(32223)
		..turnin Wanted: Chief Engineer Cogwrench##32222 |only if havequest(32222)
		|next "end" |only if default
		|next "friendly" |only if repval('Dominance Offensive','Friendly')>=950 and not completedq(32257)
		|next "friendly2" |only if repval('Dominance Offensive','Friendly')>=4900 and not completedq(32372)
		|next "honored" |only if repval('Dominance Offensive','Honored')>=3250 and not completedq(32244)
		|next "honored2" |only if repval('Dominance Offensive','Honored')>=7300 and not completedq(32384)
		|next "honored3" |only if repval ('Dominance Offensive','Honored')>=10800 and not completedq(32352)
		|next "revered" |only if repval ('Dominance Offensive','Revered')>=2400 and not completedq(32330)
		|next "revered2" |only if repval ('Dominance Offensive','Revered')>=6850 and not completedq(32368)
		|next "revered3" |only if repval ('Dominance Offensive','Revered')>=10600 and not completedq(32392)
		|next "revered4" |only if repval ('Dominance Offensive','Revered')>=14500 and not completedq(32328)
		|next "revered5" |only if repval ('Dominance Offensive','Revered')>=18500 and not completedq(32412)
		|next "exalted" |only if rep("Dominance Offensive")==Exalted
	step
	label "lion"
		goto Krasarang Wilds 75.9,34.4
		.talk Shademaster Kiryn##67628
		..turnin The Time is Now!##32450
		..accept Hero Killer##32135
		..accept Worker Harassment##32132
		..accept Sentry Wards##32133
	step
		goto Krasarang Wilds 75.9,34.2
		.talk Zazzix "Toasty" Sparkrocket##67402
		..accept Good Luck, Have Fun##32130 |or 2
		..accept We Require More Minerals!##32131 |or 2
		..accept Hard Counter##32134 |or 2
	step
		goto Krasarang Wilds 81.8,25.4
		.from Thane Stonehearth##67636 |q 32135/1
		|only if havequest(32135)
	step
		goto Krasarang Wilds 86.2,25.6
		.click Town Hall Sentry Ward Location
		.' Place the Sentry Ward in Town Hall |q 32133/1
		|only if havequest(32133)
	step
		goto Krasarang Wilds 86.1,33.1
		.click Docks Sentry Ward Location
		.' Place the Sentry Ward on the docks |q 32133/2
		|only if havequest(32133)
	step
		goto Krasarang Wilds 87.1,30.9 |n
		.' Enter the Barracks here |goto Krasarang Wilds 87.1,30.9 |noway |c
		|only if havequest(32133)
	step
		goto Krasarang Wilds 87.7,32.7
		.click Barracks Sentry Ward Location
		.' Place the Sentry Ward in the Barracks |q 32133/3
		|only if havequest(32133)
	step
		goto Krasarang Wilds 84.2,22.9
		.from Shieldwall Peasant##67423+
		..' Kill 30 Shieldwall Peasant |q 32132/1
		|only if havequest(32132)
	step
		goto Krasarang Wilds 78.2,18.3
		.from Shieldwall Engineer##67971
		.click Animatable Stone
		.collect 20 Animatable Stone##91823 |q 32131/1
		|only if havequest(32131)
	step
		goto Krasarang Wilds 82.4,24.5
		.kill 8 Dwarven Mortar Team Engineer##67545+ |q 32134/1
		.kill 2 Dwarven Mortar Tube##67541+ |q 32134/2
		|only if havequest(32134)
	step
		goto Krasarang Wilds 81.4,25.7
		.from Shieldwall Footman##67304
		.collect 10 Extra-Waxy Alliance Ears##92474 |q 32130/1
		|only if havequest(32130)
	step
		goto Krasarang Wilds 75.9,34.2
		.talk Zazzix "Toasty" Sparkrocket##67402
		..turnin Good Luck, Have Fun##32130
		..turnin We Require More Minerals!##32131
		..turnin Hard Counter##32134
	step
		goto Krasarang Wilds 75.9,34.4
		.talk Shademaster Kiryn##67628
		..turnin Hero Killer##32135
		..turnin Worker Harassment##32132
		..turnin Sentry Wards##32133
		|next "end" |only if default
		|next "friendly" |only if repval('Dominance Offensive','Friendly')>=950 and not completedq(32257)
		|next "friendly2" |only if repval('Dominance Offensive','Friendly')>=4900 and not completedq(32372)
		|next "honored" |only if repval('Dominance Offensive','Honored')>=3250 and not completedq(32244)
		|next "honored2" |only if repval('Dominance Offensive','Honored')>=7300 and not completedq(32384)
		|next "honored3" |only if repval ('Dominance Offensive','Honored')>=10800 and not completedq(32352)
		|next "revered" |only if repval ('Dominance Offensive','Revered')>=2400 and not completedq(32330)
		|next "revered2" |only if repval ('Dominance Offensive','Revered')>=6850 and not completedq(32368)
		|next "revered3" |only if repval ('Dominance Offensive','Revered')>=10600 and not completedq(32392)
		|next "revered4" |only if repval ('Dominance Offensive','Revered')>=14500 and not completedq(32328)
		|next "revered5" |only if repval ('Dominance Offensive','Revered')>=18500 and not completedq(32412)
		|next "exalted" |only if rep("Dominance Offensive")==Exalted
	step
	label "ogudei"
		goto Krasarang Wilds 76.3,34.1
		.talk Belloc Brightblade##67847
		..turnin The Ruins of Ogudei##32449
		..accept Taking Advantage##32118
	step
		goto Krasarang Wilds 76.2,34.0 |n
		'Click the portal to go to the Ruins of Ogudei |goto Krasarang Wilds/3 37.4,46.4,0.5
		|only if havequest(32118)
		|confirm
	step
		goto Krasarang Wilds/3 36.1,42.1
		.talk Kaelis Sunsoar##68274
		..turnin Taking Advantage##32118
	step
		goto Krasarang Wilds/3 36.1,42.1
		.talk Kaelis Sunsoar##68274
		..accept The Spirit Trap##32342
		..accept It Is A Mystery##32344 |or
		..accept We're Not Monsters!##32345 |or
		..accept Legacy of Ogudei##32120
		..accept Ogudei's Lieutenants##32343
		..accept Kick 'em While They're Down##32348
	step
		goto Krasarang Wilds/3 78.6,44.2 |n
		.' Go up the path here. |goto Krasarang Wilds/3 78.6,44.2 |noway |c
	step
		'Walk around this cave and pay attention to your Anamoly Reader above your actionbars. This quest is like a "Hot & Cold" game, where the closer you get, the greater anamoly reading you get. Once you have 100%, you will automatically disperse the anamoly.
		.' Disperse the anamoly |q 32344/1
		|only if havequest(32344)
	step
		goto Krasarang Wilds/3 70.2,52.8
		.from Troubled Slave Spirit##68074+
		.' Free 14 Troubled Slave Spirits |q 32345/1
		|only if havequest(32345)
	step
		goto Krasarang Wilds/2 55.5,53.7
		.from Spiritbound Brutalizer##68073+
		.from Spiritbound Arcanist##68070+
		.collect 5 Ancient Mogu Essence##92704 |q 32120/1
		|only if havequest(32120)
	step
		goto Krasarang Wilds/2 74.1,29.7
		.from Spirit Trap##68061+
		..get 3 Spirit Trap |q 32342/1
		|only if havequest(32342)
	step
		goto Krasarang Wilds/2 67.8,80.3
		.from Gen-li, Twister of Words##68169+
		.from Meng-do, Strength of Mountains##68170+
		..collect Gen-Li's Essence##92736 |q 32343/1
		..collect Meng-do's Essence##92735 |q 32343/1
	step
		goto Krasarang Wilds/2 56.7,38.7 |n
		.' Go up the stairs here. |goto Krasarang Wilds/2 56.7,38.7 |noway |c
	step
		goto Krasarang Wilds/1 59.3,37.3
		.from Shieldwall Footman##67304+, Shieldwall Rifleman##67297+, Lion's Landing Guard Captain##68310+
		.' Kill 12 Lion's Landing Military |q 32348/1
	step
		goto Krasarang Wilds/3 36.2,41.2
		.talk Kaelis Sunsoar##68274
		..turnin The Spirit Trap##32342
		..turnin It Is A Mystery##32344
		..turnin We're Not Monsters!##32345
		..turnin Legacy of Ogudei##32120
		..turnin Ogudei's Lieutenants##32343
		..turnin Kick 'em While They're Down##32348
		|next "end" |only if default
		|next "friendly" |only if repval('Dominance Offensive','Friendly')>=950 and not completedq(32257)
		|next "friendly2" |only if repval('Dominance Offensive','Friendly')>=4900 and not completedq(32372)
		|next "honored" |only if repval('Dominance Offensive','Honored')>=3250 and not completedq(32244)
		|next "honored2" |only if repval('Dominance Offensive','Honored')>=7300 and not completedq(32384)
		|next "honored3" |only if repval ('Dominance Offensive','Honored')>=10800 and not completedq(32352)
		|next "revered" |only if repval ('Dominance Offensive','Revered')>=2400 and not completedq(32330)
		|next "revered2" |only if repval ('Dominance Offensive','Revered')>=6850 and not completedq(32368)
		|next "revered3" |only if repval ('Dominance Offensive','Revered')>=10600 and not completedq(32392)
		|next "revered4" |only if repval ('Dominance Offensive','Revered')>=14500 and not completedq(32328)
		|next "revered5" |only if repval ('Dominance Offensive','Revered')>=18500 and not completedq(32412)
		|next "exalted" |only if rep("Dominance Offensive")==Exalted
	step
	label "friendly"
		goto Krasarang Wilds 10.4,53.8
		.talk General Nazgrim##67939
		..accept Rise Of An Empire##32256
	step
		goto Krasarang Wilds 9.9,52.4
		.talk Tak-Tak##68681
		.' Tell him to take you to the Shrine of Seven Stars. |goto Vale of Eternal Blossoms,59.1,20.4 |noway |c
	step
		goto Shrine of Two Moons/2 32.1,83.8
		.talk Garrosh Hellscream##67840
		..turnin Rise Of An Empire##32256
		..accept Buried Secrets##32242
	step
		goto Vale of Eternal Blossoms 20.9,15.5
		.talk Fanlyr Silverthorn##67834
		..turnin Buried Secrets##32242
		..accept Voice of the Gods##32257
	step
		goto Vale of Eternal Blossoms 18.2,12.0
		'Click on the Mercurial Guardian to investigate it. |q 32257/1
		.from Mercurial Guardian##67833
		.get Ancient Korune Tablet |q 32257/2
	step
		goto Vale of Eternal Blossoms 20.9,15.5
		.talk Fanlyr Silverthorn##67834
		..turnin Voice of the Gods##32257
		|next "end"
	step
	label "friendly2"
		goto Krasarang Wilds 10.6,53.6
		.talk Messenger Grummle##67865
		..accept Someone You Should See##32284
	step
		goto Kun-Lai Summit 71.6,93.0
		.talk Chen Stormstout##67866
		..turnin Someone You Should See##32284
		..accept Regeneration Takes Time##32318
	step
		goto Kun-Lai Summit 77.2,92.2
		.from Summit Sprite##68026+, Sinister Needle##68027+
		.get 10 Sturdy Needle##92499+ |q 32318/1
	step
		goto Kun-Lai Summit 71.6,93.0
		.talk Chen Stormstout##67866
		..turnin Regeneration Takes Time##32318
	step
		goto Kun-Lai Summit 71.6,93.2
		.talk Vol'jin##68023
		..accept Find Thrall!##32319
	step
		'Use Vol'jin's Hearthstone in your bags to get to Thrall. |use Vol'jin's Hearthstone##92510 |q 32319/1
	step
		goto Valley of Trials 44.4,66.6
		.talk Thrall##68025
		..turnin Find Thrall!##32319
		..accept The Horde Is Family##32320
		.' Escort Thrall to the Echo Isles |q 32320/1
	step
		goto Echo Isles 38.4,46.6
		.talk Thrall##68025
		..turnin The Horde Is Family##32320
		..accept De-Subjugation##32372
	step
		goto Echo Isles 61.6,65.8
		.kill Gul'tar the Subjugator##68048 |q 32372/3 |tip He's elite, but easy to kill. You will get help from other NPCs during the battle.
	step
		goto Echo Isles 54.4,54.6
		.kill 10 Kor'kron Overseer##68041 |q 32372/1
		.kill 5 Kor'kron Subjugator##68044 |q 32372/2
	step
		goto Echo Isles 58.5,62.1
		.talk Thrall##68025
		..turnin De-Subjugation##32372
		|next "end"
	step
	label "honored"
		goto Krasarang Wilds 10.4,53.7
		.talk General Nazgrim##67939
		..accept To Mogujia##32190
	step
		goto Kun-Lai Summit 57.0,79.0
		.talk Lor'themar Theron##67581
		..turnin To Mogujia##32190
		..accept Bloodlines##32192
	step
		goto Kun-Lai Summit 57.0,78.6
		.talk Fanlyr Silverthorn##67603
		..accept Ancient Guardians##32191
		..accept The Korune##32244
	step
		goto Kun-Lai Summit 58.2,71.0
		.from Korune Spellweaver##67752
		.get Korune Codex##92072 |q 32244/1
	step
		goto 58.6,74.4
		.from Korune Warden##67587+
		.' Free 6 Blood Elves |q 32192/1
		.kill 5 Korune Guardian##67574+ |q 32191/1
	step
		goto Kun-Lai Summit 57.0,79.0
		.talk Lor'themar Theron##67581
		..turnin Bloodlines##32192
	step
		goto Kun-Lai Summit 57.0,78.6
		.talk Fanlyr Silverthorn##67603
		..turnin Ancient Guardians##32191
		..turnin The Korune##32244
		|next "end"
	step
	label "honored2"
		goto Krasarang Wilds 10.4,53.8
		.talk General Nazgrim##67939
		..accept To the Valley!##32376
	step
		goto Krasarang Wilds 9.9,52.5
		.talk Tak-Tak##68681
		.' Tell him to take you to the Valley of Emperors. |goto Kun-Lai Summit 53.8,49.0 |noway |c
	step
		goto Kun-Lai Summit 53.8,49.2
		.talk Lor'themar Theron##68370
		..turnin To the Valley!##32376
		..accept Legacy of the Korune##32379
		..accept Clearing a Path##32378
	step
		goto Kun-Lai Summit 56.9,47.8
		.click Legacy of the Korune
		.get Legacy of the Korune |q 32379/2
	step
		goto Kun-Lai Summit 57.3,48.0
		.from Korune Sha-weaver##68410+, Korune Mutilator##68401+ |q 32378/1
		..get Korune Orders |q 32379/1
		..get Sealed Korune Artifact |q 32379/3
	step
		goto Kun-Lai Summit 53.8,49.2
		.talk Lor'themar Theron##68370
		..turnin Clearing a Path##32378
		..turnin Legacy of the Korune##32379
		..accept Trapping the Leader##32384
	step
		goto Kun-Lai Summit 55.9,46.2 |n
		.' Enter the tomb here |goto Kun-Lai Summit 55.9,46.2 |noway |c
	step
		goto Kun-Lai Summit 56.7,44.2
		.from Shan Kien##68378+
		.' Weaken Shan Kien |q 32384/1
	step
		goto Kun-Lai Summit 53.8,49.2
		.talk Lor'themar Theron##68370
		..turnin Trapping the Leader##32384
		|next "end"
	step
	label "honored3"
		goto Krasarang Wilds 10.4,53.8
		.talk General Nazgrim##67939
		..accept Echoes of Thunder##32351
	step
		goto Krasarang Wilds 9.9,52.5
		.talk Tak-Tak##68681
		.' Tell him to take you to the Shrine of Seven Stars. |tip This is an error by Blizzard. Eventually they will fix it and it will say the Shrine of Two Moons, so don't worry about going into enemy territory. |goto Vale of Eternal Blossoms/0 59.1,20.3 |noway |c
	step
		goto Shrine of Two Moons/2 68.0,44.6
		.talk Baine Bloodhoof##68287
		..turnin Echoes of Thunder##32351
		..accept A Gathering Storm##32352
	step
		goto Shrine of Two Moons/1 48.9,41.3
		.clicknpc Sha-Touched Grunt##68284+
		.' Fight the Grunts until they surrender.
		..' Save 6 Sha-Touched Grunts |q 32352/1
	step
		goto Shrine of Two Moons/2 66.0,46.3
		.talk Garrosh Hellscream##67840
		..turnin A Gathering Storm##32352
		|next "end"
	step
	label "revered"
		goto Krasarang Wilds 10.4,53.8
		.talk General Nazgrim##67939
		..accept Get My Results!##32329
	step
		goto Silvermoon City 54.0,20.4
		.talk Lor'themar Theron##16802
		..turnin Get My Results!##32329
		..accept What's in the Box?##32330
	step
		goto Silvermoon City 86.4,31.8
		.clicknpc Arcanis Mechanica##68430 |q 32330/1
	step
		goto Silvermoon City 92.0,37.4
		.talk Archmage Aethas Sunreaver##68086 |q 32330/2
		.talk Grand Magister Rommath##68085 |q 32330/1
	step
		.' Click the big glowing box in front of you 
		.from Concentrated Sha##68259 |q 32330/4
	step
		goto Silvermoon City 91.3,37.5
		.talk Lor'themar Theron##68084
		..turnin What's in the Box?##32330
		|next "end"
	step
	label "revered2"
		goto Krasarang Wilds 10.4,53.8
		.talk General Nazgrim##67939
		..accept The Kun-Lai Expedition##32363
	step
		goto Krasarang Wilds 9.9,52.5
		.talk Tak-Tak##68681
		.' Tell him to take you to the Gossh'ar Advance |goto Kun-Lai Summit 60.6,55.0 |noway |c
	step
		goto Kun-Lai Summit 60.4,55.2
		.talk Baine Bloodhoof##68287
		..turnin The Kun-Lai Expedition##32363
		..accept Ties with the Past##32448
	step
		goto Kun-Lai Summit 63.2,41.8 |n
		.' Enter the cave here |goto Kun-Lai Summit 63.2,41.8 |noway |c
	step
		goto Kun-Lai Summit 63.8,45.2
		.from Varatus the Conqueror##68907
		.get Spirit Essence of Varatus#93212 |q 32448/1
	step
		goto Kun-Lai Summit 60.4,55.2
		.talk Baine Bloodhoof##68287
		..turnin Ties with the Past##32448
		..accept Memory Wine##32368
	step
		.' Drink the Memory Wine in your bags |use Memory Wine##92756 |q 32368/1
		.' Witness Shan Kien's Past |q 32368/2
	step
		goto Kun-Lai Summit 60.4,55.2
		.talk Baine Bloodhoof##68287
		..turnin Memory Wine##32368
		|next "end"
	step
	label "revered3"
		goto Krasarang Wilds 10.4,53.8
		.talk General Nazgrim##67939
		..accept The Ruins of Korune##32391
	step
		goto Krasarang Wilds 9.9,52.5
		.talk Tak-Tak##68681
		.' Tell him to take you to the Ruins of Korune |goto Kun-Lai Summit 32.9,25.9 |noway |c
	step
		goto Kun-Lai Summit 32.8,26.2
		.talk Ishi##68337
		..turnin The Ruins of Korune##32391
		..accept The Divine Bell##32392
	step
		goto Kun-Lai Summit 33.1,26.7 |n
		.' Enter the cave here |goto Kun-Lai Summit 33.1,26.7 |noway |c
	step
		goto Kun-Lai Summit/20 53.9,30.4
		.' When you get to this area, make sure to step on the light blue/grey tiles to avoid death.
		|confirm
	step
		goto Kun-Lai Summit/20 28.9,79.8
		.' Go down the stairs here |goto Kun-Lai Summit/20 28.9,79.8 |noway |c
	step
		goto Kun-Lai Summit/21 59.9,25.7
		.from Sarannha Skyglaive##68472 |tip She patrols all around this area. Some searching may be required. |q 32392/1
	step
		goto Kun-Lai Summit/21 61.0,24.9
		.talk Ishi##68337
		..turnin The Divine Bell##32392
		|next "end"
	step
	label "revered4"
		goto Krasarang Wilds 10.4,53.8
		.talk General Nazgrim##67939
		..accept Insertion##32326
	step
		goto Krasarang Wilds 10.4,53.8
		.click Portal to Darnassus
		.' You will travel to Teldrassil |goto Teldrassil |noway |c
	step
		goto Teldrassil 40.0,50.4
		.talk Fanlyr Silverthorn##68077
		..turnin Insertion##32326
		..accept The Darnassus Mission##32327
	step
		goto Darnassus 38.4,33.3 |n
		.' You will get a stealth buff. This mission does not put you in a seperate phase from any other NPCs or players in this zone, so be careful!
		.' Enter the Cenarion Enclave here |goto Darnassus 38.4,33.3 |noway |c
	step	
		goto Darnassus 40.0,39.6
		.click Divine Bell##
		.' Locate the Devine Bell |q 32327/2
		.' You will be teleported back to Fanlyr once you tag the bell.
	step
		goto Teldrassil 40.0,50.4
		.talk Fanlyr Silverthorn##68077
		..turnin The Darnassus Mission##32327
		..accept Victorious Return##32328
	step
		goto Teldrassil 40.0,50.4 |n
		.click Portal to Domination Point |goto Krasarang Wilds 10.4,53.8 |noway |c
	step
		goto Krasarang Wilds 10.4,53.8
		.talk General Nazgrim##67939
		..turnin Victorious Return##32328
		|next "end"
	step
	label "revered5"
		goto Krasarang Wilds 10.4,53.8
		.talk General Nazgrim##67939
		..accept The Situation in Dalaran##32402
	step
		goto Krasarang Wilds/0 9.7,52.5
		.talk Kromthar##67785
		.' Tell her you need to get to Dalaran |goto 924/2 |noway |c
	step
		goto 924/2 31.6,51.3
		.talk Grand Magister Rommath##68586
		..turnin The Situation in Dalaran##32402
		..accept It Starts in the Sewers##32403
	step
		goto 924/2 45.3,56.9
		.talk Sunreaver Citizen##68695
		.' Tell them it is not safe here!
		.' Evacuate 9 Sunreaver Citizens |q 32403/1
	step
		goto 924/2 45.4,53.7
		.talk Grand Magister Rommath##68586
		..turnin It Starts in the Sewers##32403
		..accept Violence in the Arena##32404
	step
		goto 924/2 47.2,43.4
		.kill 6 Silver Covenant Enforcer##68042+ |q 32404/1
		.kill 4 Silver Covenant Spellbow##68043+ |q 32404/2
	step
		goto 924/2 54.3,28.2
		.talk Grand Magister Rommath##68586
		..turnin Violence in the Arena##32404
		..accept Hand of the Silver Covenant##32405
	step
		goto 924/2 61.4,14.0
		.kill Sorin Magehand##32405 |q 32405/1
	step
		goto 924/2 64.0,48.0
		.talk Grand Magister Rommath##68586
		..turnin Hand of the Silver Covenant##32405
		..accept A Tactical Assault##32406
	step
		.' Follow Grand Magister Rommath to the center of Dalaran at [924/1 50.4,48.4]
		..' You will be teleported to the Violet Hold and must fight your way back to him.
		.talk Grand Magister Rommath##68586
		..turnin A Tactical Assault##32406
		..accept The Silver Covenant's Stronghold##32408
		..accept The Kirin Tor's True Colors##32409
		..accept Krasus' Landing##32410
	step
		goto 924/1 37.2,62.0
		.kill Arcanist Rathaella##68049 |q 32408/1
	step
		goto 924/1 47.4,22.2
		.kill Lieutenant Corwin##68047 |q 32409/1
		.from Stormwind Footman##68707+, Stormwind Cleric##68708+ |q 32409/2
	step
		goto 924/1 71.0,44.8
		.clicknpc Sunreaver Dragonhawk##68728
		.' Free 6 Sunreaver Dragonhawks |q 32410/1
	step
		goto 924/1 50.4,48.4
		.talk Grand Magister Rommath##68586
		..turnin The Silver Covenant's Stronghold##32408
		..turnin The Kirin Tor's True Colors##32409
		..turnin Krasus' Landing##32410
		..accept The Remaining Sunreavers##32411
	step
		goto 924/1 58.6,27.2
		.' Use your Tear of the Sin'dorei on Magister Surdiel |use Tear of the Sin'dorei##93124
		.' Rescue Magister Surdiel |q 32411/4
		|modelnpc Magister Suridel##68716
	step
		goto 924/1 60.0,15.4
		.' Use your Tear of the Sin'dorei on High Arcanist Savor |use Tear of the Sin'dorei##93124
		.' Rescue High Arcanist Savor |q 32411/2
		|modelnpc High Arcanist Savor##68714
	step
		goto 924/1 65.2,23.6
		.' Use your Tear of the Sin'dorei on Magistrix Vesara |use Tear of the Sin'dorei##93124
		.' Rescue Magistrix Vesara |q 32411/5
		|modelnpc Magistrix Vesara##68717
	step
		goto 924/1 69.8,33.6
		.' Use your Tear of the Sin'dorei on Uda the Beast |use Tear of the Sin'dorei##93124
		.' Rescue Uda the Beast |q 32411/1
		|modelnpc Uda the Beast##68711
	step
		goto 924/1 67.2,35.6
		.' Use your Tear of the Sin'dorei on Magister Hathorel |use Tear of the Sin'dorei##93124
		.' Rescue Magister Hathorel |q 32411/3
		|modelnpc Magister Hathorel##68715
	step
		goto 924/1 50.4,48.4
		.talk Grand Magister Rommath##68586
		..turnin The Remaining Sunreavers##32411
		..accept One Last Grasp##32412
	step
		goto 924/1 30.0,48.4
		.kill Mage-Commander Zuros##68632 |q 32412/1
	step
		goto 30.0,48.4
		.' Click the portal to go into the sewers.
		|confirm
	step
		goto 924/2 9.8,87.6
		.' Jump out of the sewers here. |tip Don't worry, a Dragonhawk will catch you before you die.
		.' Escape from Dalaran |q 32412/2
	step
		goto Silvermoon City 71.2,41.6
		.talk Lor'themar Theron##16802
		..turnin One Last Grasp##32412
	step
		goto Krasarang Wilds 10.4,53.8
		.talk General Nazgrim##67939
		..accept The Bell Speaks##32398
	step
		goto Krasarang Wilds/0 9.9,52.5
		.talk Tak-Tak##68681
		.' Tell him to take you to Emperor's Reach |goto 
	step
		goto Kun-Lai Summit 55.8,34.0
		.talk Malkorok##67844
		..turnin The Bell Speaks##32398
		..accept Breath of Darkest Shadow##32399
	step
		goto Kun-Lai Summit 56.0,32.1
		.from Kor'kron Juggernaut##68840
		.' Clear the area of all Juggernauts
		|confirm
	step
		goto Kun-Lai Summit 55.8,32.0
		.from Ishi##68225 |q 32399/1
		.from Anduin Wrynn##68224 |q 32399/2
	step
		goto Kun-Lai Summit 55.8,32.0
		.talk Garrosh Hellscream##68223
		..turnin Breath of Darkest Shadow##32399
		|next "end"
	step
	label "end"
		goto Krasarang Wilds 10.8,53.4
		.talk Tuskripper Grukna##69060
		..buy 1 Grand Commendation of Dominance Offensive##93232 |n
		.' Use the Commendation of Dominance Offensive you just purchased. |condition ZGV:GetReputation("Dominanse Offensive").hasBonus |use Grand Commendation of Dominance Offensive##93232
		|only if rep("Dominance Offensive")>=Revered
	step
		'This is the end of this guide.
		.' Click here to return to the beginning of the dailies |confirm |next "dailies"
	step
	label "exalted"
		'Congratulations, you are now Exalted with the Dominance Offensive!
]])

ZygorGuidesViewer:RegisterInclude("Sturdy_Traps",[[
	startlevel 90
	step
		'This guide will take you through the bonus quests for the Dominance Offensive.
		'These quests do not offer any reputation, but they do offer Valor Points and the Lesser Charms of Good Fortune.
		|confirm
	step
	label "route"
		'Routing to proper section |next "tokens" |only if itemcount(91838)<30
		'Routing to proper section |next "menu" |only if itemcount(91838)>=30
	step
	label "tokens"
		goto Krasarang Wilds 9.9,64.2
		.from Shieldwall Marine##+, Shieldwall Stormcaller##+
		.collect 30 Lion's Landing Commission##91838
	step
	label "menu"
		'Click here to go purchase and accept the Sturdy Tiger Trap questline. |confirm |next "tiger"
		.'_
		'Click here to go purchase and accept the Sturdy Crane Snare questline. |confirm |next "crane"
		.'_
		'Click here to go purchase and accept the Sturdy Crab Crate questline. |confirm |next "crab"
	step
	label "tiger"
		goto Krasarang Wilds 10.7,53.6
		.talk Ongrom Black Tooth##67751
		.buy 1 Sturdy Tiger Trap##91855
	step
		'Click the _Sturdy Tiger Trap_ in your bags. |use Sturdy Tiger Trap##91855
		..accept Beastmaster's Hunt: The Tiger##32162
	step
		goto Dread Wastes 51.6,67.4
		.from Wasteland Yak##66549+, Wasteland Calf##66595
		.collect 25 Unbruised Yak Haunch##91816 |q 32162/1
	step
		goto Krasarang Wilds 13.9,41.4
		.click Mount of Dirt##
		..turnin Beastmaster's Hunt: The Tiger##32162
	step
		goto Krasarang Wilds 13.8,41.2
		.clicknpc Krasari Elder##67556
		..accept Beastmaster's Quarry: The Tiger##32182
	step
		goto Krasarang Wilds 12.6,62.7
		.talk Jorn Skyseer##67447
		..turnin Beastmaster's Quarry: The Tiger##32182
		|next "group"
	step
	label "crab"
		goto Krasarang Wilds 10.7,53.6
		.talk Ongrom Black Tooth##67751
		.buy 1 Sturdy Crab Crate##91822
	step
		'Click the _Sturdy Crab Crate_ in your bags. |use Sturdy Crab Crate##91822
		..accept Beastmaster's Hunt: The Crab##32163
	step
		goto Krasarang Wilds 45.2,91.6
		.from Unga Villager##60358+
		..get 30 Funky Rotten Fish |q 32163/1
	step
		goto Krasarang Wilds 56.3,42.1
		.click Mount of Dirt##
		..turnin Beastmaster's Hunt: The Crab##32163
	step
		goto Krasarang Wilds 56.4,42.1
		.click Captured Colossal Viseclaw
		..accept Beastmaster's Quarry: The Crab##32183
	step
		goto Krasarang Wilds 12.6,62.7
		.talk Jorn Skyseer##67447
		..turnin Beastmaster's Quarry: The Crab##32183
		|next "group"
	step
	label "crane"
		goto Krasarang Wilds 10.7,53.6
		.talk Ongrom Black Tooth##67751
		.buy 1 Sturdy Crane Snare##91819
	step
		'Click the _Sturdy Crane Snare_ in your bags. |use Sturdy Crane Snare##91819
		..accept Beastmaster's Hunt: The Crane##32161
	step
		goto Krasarang Wilds/0 34.5,71.2
		.from Child of Chi-Ji##60616+
		..get 5 Pristine Golden Crownfeather |q 32161/1
	step
		goto Krasarang Wilds/0 73.2,44.6
		.from Great Crane##59763+
		..get Pristine Jet Crownfeather##91815 |q 32161/2
	step
		goto Krasarang Wilds 56.3,42.1
		.click Mount of Dirt##
		..turnin Beastmaster's Hunt: The Crane##32161
	step
		goto Krasarang Wilds 56.4,42.1
		.click Ancient Bloodcrown Crane##
		..accept Beastmaster's Quarry: The Crane##32181
	step
		goto Krasarang Wilds 12.6,62.7
		.talk Jorn Skyseer##67447
		..turnin Beastmaster's Quarry: The Crane##32181
		|next "group"
	step
	label group
		goto Krasarang Wilds 12.6,62.7
		.talk Jorn Skyseer##67447
		.' The dailies you have completed will determine which enemies are available to you to fight.
		.' Click here to fight the _Ancient Bloodcrown Crane_. |confirm |next bc
		.' Click here to fight the _Krasari Elder_. |confirm |next ke
		.' Click here to fight the _Colossal Viseclaw_. |confirm |next cv
	step
	label bc
		.' Tell him you would like to fight the Bloodcrown Crane.
		.' During the fight, pay attention to the songs that it uses.
		.' Some can be interrupted while others simply need to be avoided.
		.from Ancient Bloodcrown Crane##67555
		..accept Ancient's Fall##32167
	step
		goto Krasarang Wilds 12.6,62.7
		.talk Jorn Skyseer##67447
		.turnin Ancient's Fall##32167
		|next "end"
	step
	label ke
		.' Tell him you would like to fight the Krasari Elder.
		.' During the fight, you will want to stay close to it at _ALL TIMES_.
		.' It will occassionally vanish, if you have a hunter simply put a flare out.
		.from Krasari Elder##67556
		..accept End of an Elder##32168
	step
		goto Krasarang Wilds 12.6,62.7
		.talk Jorn Skyseer##67447
		.turnin End of an Elder##32168
		|next "end"
	step
	label cv
		.' Tell him you would like to fight the Colossal Viseclaw.
		.' During the fight, you will want to kite him around.
		.' He will have a damage reduction buff that decreases while he moves.
		.' If it reaches _0_, the buff will reset.
		.from Colossal Viseclaw##67508
		..accept A Colossal Victory##32169
	step
		goto Krasarang Wilds 12.6,62.7
		.talk Jorn Skyseer##67447
		..turnin A Colossal Victory##32169
		|next "end"
	step
	label end
		'You have reached the end of the guide.
		.' Click here to go back to the beginning of the Traps guide. |next "route"
]])

ZygorGuidesViewer:RegisterInclude("H_Tillers",[[
	startlevel 90
	step
		'Proceeding to the Tiller's Dailies  |next "dailies" |condition completedq(31945) |only if completedq(31945)
		'Proceeding to the Tiller's Prequests |next |condition not completedq(31945) |only if not completedq(31945)
	step
		goto Valley of the Four Winds 52.0,48.0
		.talk Farmer Yoon##58721
		..accept A Helping Hand##30252
	step
		goto 51.8,48.8
		.click Unbudging Rock
		.' Clear 8 Unbudging Rocks |q 30252/1
	step
		goto 52.8,47.9
		.talk Farmer Yoon##58646
		..turnin A Helping Hand##30252
	step
		goto 52.3,48.8
		.talk Farmer Yoon##58646
		..accept Learn and Grow I: Seeds##30535
	step
		goto 52.9,52.2
		.talk Merchant Greenfield##58718
		.' Tell him you're there to pick up seeds.
		.' Get a Packet of Green Cabbage Seeds |q 30535/1
	step
		goto 52.3,48.8
		.talk Farmer Yoon##58646
		..turnin Learn and Grow I: Seeds##30535
		..accept Learn and Grow II: Tilling and Planting##30254
	step
		goto 52.0,48.3
		.clicknpc Untilled Soil##59985+
		.' Till 2 patches of Soil. |q 30254/1
		.' Use the EZ-Gro Green Cabbage Seeds in your bags on the Tilled Soil. |use EZ-Gro Green Cabbage Seeds##80302
		.' Plant seeds in 2 patches of Tilled Soil. |q 30254/2
		|modelnpc Tilled Soil##58563
	step
		goto 52.3,48.8
		.talk Farmer Yoon##58646
		..turnin Learn and Grow II: Tilling and Planting##30254
		..accept Learn and Grow III: Tending Crops##30255
	step
		goto 52.0,48.3
		.' Use the Rusty Watering Can on the Parched EZ-Gro Green Cabbage |use Rusty Watering Can##79104
		.' Water 2 parched Ez-Gro Green Cabbage |q 30255/1
		|modelnpc Parched EZ-Gro Green Cabbage##59987
	step
		goto 52.3,48.8
		.talk Farmer Yoon##58646
		..turnin Learn and Grow III: Tending Crops##30255
		..accept Learn and Grow IV: Harvesting##30256
	step
		goto 52.0,48.3
		.clicknpc Ripe EZ-Gro Green Cabbage##59833
		.get 2 EZ-Gro Green Cabbage |q 30256/1
	step
		goto 52.3,48.8
		.talk Farmer Yoon##58646
		..turnin Learn and Grow IV: Harvesting##30256
		..accept Learn and Grow V: Halfhill Market##30257
	step
		goto 52.8,48.0
		.click Dark Soil
		.get Marsh Lily |q 30257/1
	step
		goto 53.1,51.8
		.talk Gina Mudclaw##58706
		..turnin Learn and Grow V: Halfhill Market##30257 
		..accept Learn and Grow VI: Gina's Vote##31945
	step
		goto 52.9,52.2
		.talk Merchant Greenfield##58718
		.buy 1 Scallion Seeds##80591 |q 31945
	step
		goto 52.0,48.4
		.clicknpc Untilled Soil##58562
		.' Use your Scallion Seeds on the Tilled Soil |use Scallion Seeds##80591
		.' Plant Scallion Seeds |q 31945/1
		|modelnpc Tilled Soil##58563
	step
	label info
		'Click here for information on Bursting Crops |next "bursting" |confirm
		'Click here for information on Parched Crops |next "parched" |confirm
		'Click here for information on Infested Crops |next "infested" |confirm
		'Click here for information on Wiggling Crops |next "wiggling" |confirm
		'Click here for information on Alluring Crops |next "alluring" |confirm
		'Click here for information on Smothered Crops |next "smothered" |confirm
		'Click here for information on Wild Crops |next "wild" |confirm
		'Click here for information on Runty Crops |next "runty" |confirm
		'Click here for information on Tangled Crops |next "tangled" |confirm
	step
	label bursting
		'Unless you got a Bursting Scallion immediately after planting your Scallions, you will have to wait a full day until you can pick your crops.
		.' Click here if you are ready to harvest your crops. |confirm
		.' Click here to start doing dailies. |next "dailies" |confirm
	step
		goto 52.0,48.4
		.clicknpc Bursting Scallions##63160 
		.clicknpc Ripe Scallions##63165
		.' Harvest Ripe Scallions |q 31945/2
		.get 5 Scallion##74843 |q 31945/3
		|next "exit"
	step
	label runty
		goto 52.0,48.4
		.clicknpc Runty Scallions##63166
		.' Press your Space Bar and jump. 
		.' Click here to return to the information page. |next "info" |confirm
		.' Click here when you are have tilled your crops. |next "bursting" |confirm
	step
	label wiggling
		goto 52.0,48.4
		.clicknpc Wiggling Scallions##63169
		.from Voracious Virmen##60039
		.' Click here to return to the information page. |next "info" |confirm
		.' Click here when you are have tilled your crops. |next "bursting" |confirm
	step
	label infested
		goto 52.2,48.3
		.click Vintage Bug Sprayer
		.collect Vintage Bug Sprayer##80513 |n
		.' Use your Vintage Bug Sprayer on the Infested Scallions |use Vintage Bug Sprayer##80513
		|modelnpc Infested Scallions##63162
		.' Click here to return to the information page. |next "info" |confirm
		.' Click here when you are have tilled your crops. |next "bursting" |confirm
	step
	label alluring
		goto 52.2,48.3
		.clicknpc Alluring Scallions##63159
		.from Swooping Plainshawk##60072
		.' Click here to return to the information page. |next "info" |confirm
		.' Click here when you are have tilled your crops. |next "bursting" |confirm
	step
	label wild
		goto 52.0,48.4
		.clicknpc Wild Scallions##63170	
		.' Ride the Scallion |invehicle |c 
	step
		'Spam the Flex ability on your new hotbar, when the plant tries to cast Vine Slam, interrupt it with your Gnaw ability.
		.' Build 50 stacks on Dominance. |outvehicle |c
	step
		.' Click here to return to the information page. |next "info" |confirm
		.' Click here when you are have tilled your crops. |next "bursting" |confirm
	step
	label tangled
		goto 52.0,48.4 |n
		.clicknpc Tangled Scallions##63168
		.' Run to [51.7,48.9]
		'|goto 51.7,48.9 <5 |c
	step
		.' Click here to return to the information page. |next "info" |confirm
		.' Click here when you are have tilled your crops. |next "bursting" |confirm
	step
	label parched
		goto 52.0,48.4
		.' Use the Rusty Watering Can on the Parched Scallions |use Rusty Watering Can##79104
		.' Click here to return to the information page. |next "info" |confirm
		.' Click here when you are have tilled your crops. |next "bursting" |confirm
		|modelnpc Parched Scallions##63163
	step
	label smothered
		goto 52.0,48.4
		.clicknpc Encroaching Weed##60185
		.' Ride the Weed |invehicle |c
	step
		'Spam the Pull ability on your new hotbar. 
		.' Pull the Weed |outvehicle |c
	step
		.' Click here to return to the information page. |next "info" |confirm
		.' Click here when you are have tilled your crops. |next "bursting" |confirm
		|modelnpc Smothered Scallions##63167
	step
	label exit
		goto 53.1,51.8
		.talk Gina Mudclaw##58706
		..turnin Learn and Grow VI: Gina's Vote##31945
	step
	label dailies
		goto Valley of the Four Winds 51.9,48.3
		'Start each day out by harvesting the crops from the previous day.
		|confirm
	step
		goto 52.3,48.8
		.talk Farmer Yoon##58646 |tip He will only have 2 quests a day.
		..accept The Kunzen Hunter-Chief##30336 |or 2
		..accept That Dangling Carrot##31670 |or 2
		..accept Stealing is Bad... Re-Stealing is OK##30334 |or 2
		..accept The Cabbage Test##31669 |or 2
		..accept It's Melon Time##31942 |or 2
		..accept A Pumpkin-y Perfume##31672 |or 2
		..accept Stalling the Ravage##30335 |or 2
		..accept Red Blossom Leeks, You Make the Croc-in' World Go Down##31673 |or 2
		..accept Squash Those Foul Odors##31941 |or 2
		..accept The Lesser of Two Evils##30333 |or 2
		..accept The White Turnip Treatment##31675 |or 2
		..accept The Pink Turnip Challenge##31674 |or 2
		..accept Which Berries? Witchberries.##31943 |or 2
		..accept Why Not Scallions?##31671 |or 2
		..accept Simian Sabotage##30337 |or 2
		|only if not completedq(32682)
	step
		goto 53.0,51.8
		.talk Farmer Yoon##58646 |tip He will only have 1 quest a day.
		..accept The Kunzen Hunter-Chief##30336 |or
		..accept Stealing is Bad... Re-Stealing is OK##30334 |or
		..accept Stalling the Ravage##30335 |or
		..accept The Lesser of Two Evils##30333 |or
		..accept Simian Sabotage##30337 |or
		|only if completedq(32682)
	step
		goto 52.7,50.5
		.talk Andi##64464 |tip He will only have 1 quest a day.
		..accept A Gift For Fung##30475 |or
		..accept A Gift For Chee Chee##30471 |or
		..accept A Gift For Haohan##30477 |or
		..accept A Gift For Jogu##30478 |or
		..accept A Gift For Sho##30472 |or
		..accept A Gift For Tina##30470 |or
		..accept A Gift For Ella##30474 |or
		..accept A Gift For Old Hillpaw##30476 |or
		..accept A Gift For Fish##30473 |or
		 ..accept A Gift For Gina##30479 |or
	step
		goto 53.1,51.7
		.talk Ella##58647
		..accept You Have to Burn the Ropes##30327
		.'_
		.' Click here if Ella is not in town |confirm
	step
		goto 53.0,51.7
		.talk Haohan Mudclaw##57402
		..accept Pest Problems##30319
		.'_
		.' Click here if Haohan is not in town |confirm
	step
		goto 53.1,51.7
		.talk Tina Mudclaw##58761
		..accept They Don't Even Wear Them##30323
		.'_
		.' Click here if Tina is not in town |confirm
	step
		goto 53.1,52.1
		.talk Chee Chee##58709
		..accept Not in Chee-Chee's Backyard##30324
		.'_
		.' Click here if Chee-Chee is not in town |confirm
	step
		goto 52.8,51.8
		.talk Fish Fellreed##58705
		..accept The Kunzen Legend-Chief##30326
		.'_
		.' Click here if Fish Felreed is not in town |confirm
	step
		goto 52.9,51.7
		.talk Farmer Fung##57298
		..accept Water, Water Everywhere##30317
		.'_
		.' Click here if Farmer Fung is not in town |confirm
	step
		goto 53.1,52.1
		.talk Sho##58708
		..accept Where It Counts##30325
		.'_
		.' Click here if Sho is not in town |confirm
	step
		goto 53.6,52.5
		.talk Jogu the Drunk##58710
		..accept Weed War II##30321
		.'_
		.' Click here if Jogu has no available quests. |confirm
	step
		goto 53.0,51.8
		.talk Old Hillpaw##58707
		..accept Chasing the Chicken##30318
		.'_
		.' Click here if Old Hillpaw is not in town. |confirm
	step
		goto 53.2,51.8
		.talk Gina Mudclaw##58706
		..accept Money Matters##30322
		.'_
		.' If this quest is unavailable click here. |confirm
	step
		goto 55.1,50.3
		.talk Innkeeper Lei Lan##59582
		.' Tell her you are here on behalf of Gina Mudclaw.
		.' Innkeeper Lei Lan's Payment |q 30322/3
		|only if havequest(30322)
	step
		goto 55.6,52.1
		.talk Lolo Lio##59585
		.' Tell him you are here on behalf of Gina Mudclaw.
		.' Lolo Lio's Payment |q 30322/4
		|only if havequest(30322)
	step
		goto 56.1,49.6
		.talk Trader Jambeezi##59583
		.' Tell him you are here on behalf of Gina Mudclaw.
		.' Trader Jambeezi's Payment |q 30322/2
		|only if havequest(30322)
	step
		goto 56.7,47.1
		.talk Spicemaster Jin Jao##59581
		.' Tell him you are here on behalf of Gina Mudclaw.
		.' Spicemaster Jin Jao's Payment |q 30322/1
		|only if havequest(30322)
	step
		goto 52.9,52.1
		.talk Merchant Greenfield##58718
		.buy 1 Juicycrunch Carrot Seeds##80590
		|only if havequest(31670)
	step
		goto 52.9,52.1
		.talk Merchant Greenfield##58718
		.buy 1 Green Cabbage Seeds##79102
		|only if havequest(31669)
	step
		goto 52.9,52.1
		.talk Merchant Greenfield##58718
		.buy 1 Witchberry Seeds##89326
		|only if havequest(31943)
	step
		goto 52.9,52.1
		.talk Merchant Greenfield##58718
		.buy 1 Scallion Seeds##80591
		|only if havequest(31671)
	step
		goto 52.9,52.1
		.talk Merchant Greenfield##58718
		.buy 1 White Turnip Seeds##80595
		|only if havequest(31675)
	step
		goto 52.9,52.1
		.talk Merchant Greenfield##58718
		.buy 1 Pink Turnip Seeds##80594
		|only if havequest(31674)
	step
		goto 52.9,52.1
		.talk Merchant Greenfield##58718
		.buy 1 Jade Squash Seeds##89328
		|only if havequest(31941)
	step
		goto 52.9,52.1
		.talk Merchant Greenfield##58718
		.buy 1 Striped Melon Seeds##89329
		|only if havequest(31942)
	step
		goto 52.9,52.1
		.talk Merchant Greenfield##58718
		.buy 1 Mogu Pumpkin Seeds##80592
		|only if havequest(31672)
	step
		goto 52.9,52.1
		.talk Merchant Greenfield##58718
		.buy 1 Red Blossom Leek Seeds##80593
		|only if havequest(31673)
	step
		goto 56.5,50.4
		.talk Wing Nga##60231
		.' Tell her that you'd like to borrow one of Farmer Fung's kites.
		.' Ride a kite. |invehicle |c
		|only if havequest(30317)
	step
		.' Use your Water Buckest ability on the Dusty Spots below you. |tip They are outlined by a yellow circle.
		.' Water 35 Dusty Spots |q 30317/1
		|only if havequest(30317)
	step
		goto 52.0,48.4
		.clicknpc Untilled Soil##58562
		.' Use your Scallion Seeds on the Tilled Soil |use Scallion Seeds##80591
		.' Plant Scallion Seeds |q 31671/1
		|modelnpc Tilled Soil##58563
		|only if havequest(31671)
	step
		goto 52.0,48.4
		.clicknpc Untilled Soil##58562
		.' Use your Juicycrunch Carrot Seed on the Tilled Soil |use Juicycrunch Carrot Seeds##80590
		.' Plant 1 Juicycrunch Carrot Seed |q 31670/1
		|modelnpc Tilled Soil##58563
		|only if havequest(31670)
	step
		goto 52.0,48.4
		.clicknpc Untilled Soil##58562
		.' Use your Witchberry Seeds on the Tilled Soil |use Witchberry Seeds##89326
		.' Plant Witchberry Seeds |q 31943/1
		|modelnpc Tilled Soil##58563+
		|only if havequest(31943)
	step
		goto 52.0,48.4
		.clicknpc Untilled Soil##58562
		.' Use your Mogu Pumpkin Seeds on the Tilled Soil |use Mogu Pumpkin Seeds##80592
		.' Plant Mogu Pumpkin Seeds |q 31672/1
		|modelnpc Tilled Soil##58563+
		|only if havequest(31672)
	step
		goto 52.0,48.4
		.clicknpc Untilled Soil##58562
		.' Use your Jade Squash Seeds on the Tilled Soil |use Jade Squash Seeds##89328
		.' Plant Jade Squash Seeds |q 31941/1
		|modelnpc Tilled Soil##58563+
		|only if havequest(31941)
	step
		goto 52.0,48.4
		.clicknpc Untilled Soil##58562
		.' Use your White Turnip Seeds on the Tilled Soil |use White Turnip Seeds##80595
		.' Plant White Turnip Seeds |q 31675/1
		|modelnpc Tilled Soil##58563+
		|only if havequest(31675)
	step
		goto 52.0,48.4
		.clicknpc Untilled Soil##58562
		.' Use your Pink Turnip Seeds on the Tilled Soil |use Pink Turnip Seeds##80594
		.' Plant Pink Turnip Seeds |q 31674/1
		|modelnpc Tilled Soil##58563+
		|only if havequest(31674)
	step
		goto 52.0,48.4
		.clicknpc Untilled Soil##58562
		.' Use your Green Cabbage Seeds on the Tilled Soil |use Green Cabbage Seeds##79102
		.' Plant Green Cabbage Seeds |q 31669/1
		|modelnpc Tilled Soil##58563+
		|only if havequest(31669)
	step
		goto 52.0,48.4
		.clicknpc Untilled Soil##58562
		.' Use your Striped Melon Seeds on the Tilled Soil |use Striped Melon Seeds##89329
		.' Plant Striped Melon Seeds |q 31942/1
		|modelnpc Tilled Soil##58563+
		|only if havequest(31942)
	step
		goto 52.0,48.4
		.clicknpc Untilled Soil##58562
		.' Use your Red Blossom Leek Seeds on the Tilled Soil |use Red Blossom Leek Seeds##80593
		.' Plant Red Blossom Leek Seeds |q 31673/1
		|modelnpc Tilled Soil##58563
		|only if havequest(31673)
	step
		goto 45.9,48.5
		.click Goldenfire Orchid##10921
		.get Goldenfire Orchid |q 30479/1
		.' You can also find this here: [41.6,42.8]
		.' or here: [37.5,37.3]
		|only if havequest(30479)
	step
		goto 42.4,50.0
		.talk Lost Dog##59533
		..accept Lost and Lonely##30526
		|only if repval('The Tillers','Revered')>=13000
	step
		goto 38.5,51.7
		.talk Gai Lan##57385
		.' Ask him, "What Weeds?"
		.' Get the Weed War buff. |havebuff Interface\Icons\INV_Misc_Herb_05
		|only if havequest(30321)
	step
		.clicknpc Ugly Weed##57306
		.clicknpc Nasty Weed##57308
		.click Weed-B-Gone Gas Bomb |tip Use the new button available to you to clear a lot of weeds at once
		.' Pull 100 Weeds |q 30321/1
		|only if havequest(30321)
	step
		goto 31.3,53.2
		.clicknpc Hillpaw's Chicken##58918 |tip Most of these chickens are disguised animals. When you pick one up click the button that appears on your screen.
		.' You can deliver lost hens to the chicken coop here [30.4,52.5]
		.get Old Hillpaw's Prize Chicken##80223 |q 30318/1
		|only if havequest(30318)
	step
		goto 37.4,37.3
		.from Monstrous Plainshawk##59641
		.collect 1 Bloody Plainshawk Leg##80232
		|only if havequest(30475)
	step
		goto 39.6,45.3
		.talk Wika-Wika##59532
		.' Mook-mooks?
		.' Get the Pest Problems buff. |havebuff Pest Problems
		|only if havequest(30319)
	step
		goto 39.6,45.3
		.clicknpc Black-Nose Marmot##59530
		.' Stomp 25 Black-Nose Marmot |q 30319/1
		|only if havequest(30319)
	step
		goto 30.2,46.0
		.from Teeku##59130, Jim-Jim##59128, Jokka-Jokka##59126, Kon-Kon##59127
		.' Kill the Kunzen-Hunter Chief. |q 30336/1
		|only if havequest(30336)
	step
		goto 29.2,38.2
		.from Skyrange Mushan##64309+
		.get 20 Tasty T-Bone |q 30526/1
		|only if havequest(30526)
	step
		goto 32.0,32.1
		.click Kunzen Rope
		.' Burn 6 ropes |q 30327/1
		|only if havequest(30327)
	step
		goto 29.7,34.5
		.click Yu-Ping Soup Cauldron
		.get Yu-Ping Soup##79870 |q 30472/1
		|only if havequest(30472)
	step
		goto 29.7,34.5
		.kill 1 Kunzen Ritualist##59123 |q 30325/3
		.click Blazing Ember##5746
		.' Kick 4 Blazing Ember |q 30325/2
		.click Kunzen Ritual Candle##11320
		.' Throw 8 Kunzen Ritual Candles |q 30325/1
		|only if havequest(30325)
	step
		goto 31.6,28.7
		.from Buk-Buk##59133+, Bimba##59135+, Yammo##59134+, Rit-Rit##59132+
		.get 1 Kunzen Legend-Book##79866 |q 30326/1
		|only if havequest(30326)
	step
		goto 33.6,23.9
		.click Authentic Valley Stir Fry
		.get Authentic Valley Stir Fry |q 30471/1
		|only if havequest(30471)
	step
		goto 34.0,24.1
		.click Yak Statuette
		.get Yak Statuette##79828 |q 30473/1
		|only if havequest(30473)
	step
		goto 32.7,30.6
		'Use the Barrel of Fireworks in your bags. |use Barrel of Fireworks##79885
		.' Stolen tools exploded |q 30337/2
		|only if havequest(30337)
	step
		goto 30.4,28.1
		'Use the Barrel of Fireworks in your bags. |use Barrel of Fireworks##79885
		.' Stolen weapons exploded |q 30337/1
		|only if havequest(30337)
	step
		goto 32.1,25.9
		'Use the Barrel of Fireworks in your bags. |use Barrel of Fireworks##79885
		.' Stolen beer exploded |q 30337/3
		|only if havequest(30337)
	step
		goto 35.0,22.0
		'Use the Barrel of Fireworks in your bags. |use Barrel of Fireworks##79885
		.' Stolen grain exploded |q 30337/4
		|only if havequest(30337)
	step
		goto 34.2,23.5
		.from Kunzen Rockflinger##59120+, Kunzen Collector##59124+, Kunzen Ravager##59119+, Kunzen Hunter##59121+
		.' Kill 12 Kunzen hozen |q 30335/1
		|only if havequest(30335)
	step
		goto 34.2,23.5
		.click Stolen Vegetable |only if havequest(30334)
		.get 16 Stolen Vegetable##79824 |q 30334/1 |only if havequest(30334)
		.from Kunzen Rockflinger##59120+, Kunzen Collector##59124+, Kunzen Ravager##59119+ |only if havequest(30324) or havequest(30474)
		.' Kill 8 Kunzen tribe members. |q 30324/1 |only if havequest(30324)
		.get Spicy Shrimp Dumplings##79871 |q 30474/1 |only if havequest(30474)
	step
		goto 44.1,29.1
		.from Enormous Cattail Grouper##59639
		.get Enormous Cattail Grouper Tooth |q 30477/1
		|only if havequest(30477)
	step
		'Enter this warren. |goto 46.9,21.1 <5 |c
		|only if havequest(30333)
	step
		goto 48.7,18.7
		.kill Springtail Warren-Mother##59516 |q 30333/1
		|only if havequest(30333)
	step
		'Leave the warren. |goto 46.9,21.1 <5 |c
		|only if havequest(30333)
	step
		'Enter this warren. |goto 44.0,22.3 <5 |c
		|only if havequest(30470)
	step
		goto 44.7,19.6
		.from Springtail Littlewhisker##59515+, Springtail Trapper##59513+, Springtail Burrower##59514+
		.get Stolen Circlet##80138 |q 30323/1
		.get Ransacked Ring##80137 |q 30323/2
		.get Buglarized Bracelet##80139 |q 30323/3
		|only if havequest(30323)
	step
		'Leave the warren. |goto 44.0,22.3 <5 |c
		|only if havequest(30470)
	step
		'This item could be in either warren or the patch of land seperating the two entrances.
		.click Chrysoberyl Outcropping##7456
		.get Uncut Chrysoberyl |q 30470/1
		|only if havequest(30470)
	step
		goto 44.2,28.8
		.click Freshwater Oyster
		.get Blue Freshwater Pearl## |q 30476/1
		|only if havequest(30476)
	step
		goto 42.4,50.0
		.talk Lost Dog##59533
		..turnin Lost and Lonely##30526
		|only if havequest(30526)
	step
		goto 52.6,47.8
		.click Yoon's Apples
		.collect 8 Yoon's Apple##80234
		|only if havequest(30478)
	step
		goto 52.8,47.9
		.click Yoon's Craneberries
		.collect 50 Yoon's Craneberry##80235
		|only if havequest(30478)
	step
		goto 53.2,52.2
		.talk Bobo Ironpaw##58717
		.' Tell him you've got all this fruit here.
		.get Apple-Berry Hooch |q 30478/1
		|only if havequest(30478)
	step
		goto 53.0,51.3
		.talk Kol Ironpaw##58712
		.' Ask him if he could grill your plainshawk leg.
		.get Grilled Plainshawk Leg##80233 |q 30475/1
		|only if havequest(30475)
	step
		goto 52.3,48.8
		.talk Farmer Yoon##58646
		..turnin The Kunzen Hunter-Chief##30336
		..turnin That Dangling Carrot##31670
		..turnin Stealing is Bad... Re-Stealing is OK##30334
		..turnin The Cabbage Test##31669
		..turnin It's Melon Time##31942
		..turnin A Pumpkin-y Perfume##31672
		..turnin Stalling the Ravage##30335
		..turnin Red Blossom Leeks, You Make the Croc-in' World Go Down##31673
		..turnin Squash Those Foul Odors##31941
		..turnin The Lesser of Two Evils##30333
		..turnin The White Turnip Treatment##31675
		..turnin The Pink Turnip Challenge##31674
		..turnin Which Berries? Witchberries.##31943
		..turnin Why Not Scallions?##31671
		..turnin Simian Sabotage##30337
		|only if not completedq(32682)
	step
		goto 53.0,51.8
		.talk Farmer Yoon##58646 |tip He will only have 1 quest a day.
		..turnin The Kunzen Hunter-Chief##30336 |or
		..turnin Stealing is Bad... Re-Stealing is OK##30334 |or
		..turnin Stalling the Ravage##30335 |or
		..turnin The Lesser of Two Evils##30333 |or
		..turnin Simian Sabotage##30337 |or
		|only if completedq(32682)
	step
		goto 52.9,51.7
		.talk Farmer Fung##57298
		..turnin Water, Water Everywhere##30317
		..turnin A Gift For Fung##30475 |only if havequest(30475)
	step
		goto 52.8,51.8
		.talk Fish Fellreed##58705
		..turnin The Kunzen Legend-Chief##30326
		..turnin A Gift For Fish##30473 |only if havequest(30473)
	step
		goto  53.0,51.7
		.talk Ella##58647
		..turnin You Have to Burn the Ropes##30327
		..turnin A Gift For Ella##30474 |only if havequest(30474)
	step
		goto 53.1,52.1
		.talk Sho##58708
		..turnin Where It Counts##30325
		..turnin A Gift For Sho##30472 |only if havequest(30472)
	step
		goto 53.2,51.8
		.talk Gina Mudclaw##58706
		..turnin Money Matters##30322
		..turnin A Gift For Gina##30479 |only if havequest(30479)
	step
		goto 53.1,51.9
		.talk Old Hillpaw##58707
		..turnin Chasing the Chicken##30318
		..turnin A Gift For Old Hillpaw##30476 |only if havequest(30476)
	step
		goto 53.1,51.7
		.talk Tina Mudclaw##58761
		..turnin A Gift For Tina##30470 |only if havequest(30470)
		..turnin They Don't Even Wear Them##30323
	step
		goto 53.0,51.7
		.talk Haohan Mudclaw##57402
		..turnin Pest Problems##30319
		..turnin A Gift For Haohan##30477 |only if havequest(30477)
	step
		goto 53.6,52.5
		.talk Jogu the Drunk##58710
		..turnin Weed War II##30321
		..turnin A Gift For Jogu##30478 |only if havequest(30478)
	step
		goto 53.1,52.1
		.talk Chee Chee##58709
		..turnin Not in Chee-Chee's Backyard##30324
		..turnin A Gift For Chee Chee##30471 |only if havequest(30471)
		|next "honored" |only if rep('The Tillers')==Honored
		|next "revered" |only if rep('The Tillers')==Revered
		|next "exalted" |only if rep('The Tillers')==Exalted
		|next "end" |only if rep('The Tillers')<=Friendly
	step
	label honored
		goto 52.3,48.8
		.talk Farmer Yoon##58646
		..accept Growing the Farm I: The Weeds##30260
		|next mungmung |only if repval('The Tillers','Honored')>=5600 and completedq(31936) and not completedq(31946)
	step
		goto 38.6,51.7
		.talk Gai Lan##57385
		..turnin Growing the Farm I: The Weeds##30260
		..accept Growing the Farm I: A Little Problem##30516
	step
		goto 36.5,51.1
		.click Spideroot
		.get 6 Spideroot |q 30516/1
	step
		goto 38.6,51.7
		.talk Gai Lan##57385
		..turnin Growing the Farm I: A Little Problem##30516
		|next "revered" |only if rep('The Tillers')>=Revered
	step
		goto 51.9,48.3
		'When you arrive at Sunsong Ranch you will get a buff. After 15 minutes your ranch will be expanded. |tip You cannot buy your farm upgrade until the expansion is done. 
		|confirm
		|only if not completedq(31936)
	step
		goto 53.2,51.8
		.talk Gina Mudclaw##58706
		.buy 1 "Jinyu Princess" Irrigation System##89812 |q 31936
	step
		'Click the "Jinyu Princess" Irrigation System in your bags. |use "Jinyu Princess" Irrigation System##89812
		..accept The "Jinyu Princess" Irrigation System##31936
	step
		goto 52.3,48.8
		.talk Farmer Yoon##58646
		..turnin The "Jinyu Princess" Irrigation System##31936
		|next mungmung |only if repval('The Tillers','Honored')>=5600 and completedq(31936) and not completedq(31946)
		|next "end" |only if default
	step
	label revered
		goto 53.2,51.8
		.talk Gina Mudclaw##58706
		..buy 1 Grand Commendation of the Tillers##93226 |n
		.' Use the Commendation of the Tillers you just purchased. |condition ZGV:GetReputation("The Tillers").hasBonus |use Grand Commendation of the Tillers##93226
		|only if rep("The Tillers")>=Revered
	step
		goto 52.3,48.8
		.talk Farmer Yoon##58646
		..accept Growing the Farm II: The Broken Wagon##30523
		|next "fung" |only if repval('The Tillers','Revered')>=4200
		|next "mungmung" |only if completedq(31936) and not completedq(31946)
		|only if completedq(30516) and rep('The Tillers')>=Revered
	step
		goto 41.7,30.0
		.talk Fish Fellreed##58705
		..turnin Growing the Farm II: The Broken Wagon##30523
		..accept Growing the Farm II: Knock on Wood##30524
	step
		goto 42.8,29.1
		.click Boat Planks
		.get 100 Waxed Plank##80136 |q 30524/1
	step
		goto 41.7,30.0
		.talk Fish Fellreed##58705
		..turnin Growing the Farm II: Knock on Wood##30524
	step
		goto 51.9,48.3
		'When you arrive at Sunsong Ranch you will get a buff. After 15 minutes your ranch will be expanded. |tip You cannot buy your farm upgrade until the expansion is done. 
		|confirm
		|only if not completedq(31937)
	step
		goto 53.2,51.8
		.talk Gina Mudclaw##58706
		.buy 1 "Thunder King" Pest Repellers##89813 |q 31937
	step
		'Click the "Thunder King" Pest Repellers in your bags. |use "Thunder King" Pest Repellers##89813
		..accept "Thunder King" Pest Repellers##31937
	step
		goto 52.3,48.8
		.talk Farmer Yoon##58646
		..turnin "Thunder King" Pest Repellers##31937
		|next "end"
	step
	label mungmung
		goto 52.3,48.8
		.talk Farmer Yoon##58646
		..accept Mung-Mung's Vote I: A Hozen's Problem##30258
		|next "fung" |only if completedq(31946)
	step
		goto 44.2,34.3
		.talk Mung-Mung##57401
		..turnin Mung-Mung's Vote I: A Hozen's Problem##30258
		..accept Mung-Mung's Vote II: Rotten to the Core##30259
	step
		goto 42.7,38.2
		.click Partially Chewed Carrot
		.get 10 Partially Chewed Carrot##80116 |q 30259/1
	step
		goto 44.2,34.3
		.talk Mung-Mung##57401
		..turnin Mung-Mung's Vote II: Rotten to the Core##30259
		..accept Mung-Mung's Vote III: The Great Carrot Caper##31946
	step
		goto 52.9,52.1
		.talk Merchant Greenfield##58718
		.buy 2 Juicycrunch Carrot Seeds##80590 |q 31946
	step
		goto 52.0,48.4
		.clicknpc Untilled Soil##58562
		.' Use your Juicycrunch Carrot Seeds on the Tilled Soil |use Juicycrunch Carrot Seeds##80590
		.' Plant 2 Juicycrunch Carrot Seeds |q 31946/1
		|modelnpc Tilled Soil##58563
	step
		'Wait a day for the carrots to grow and then harvest them.
		.' Harvest 2 Ripe Juicycrunch Carrots |q 31946/2
		.get 10 Juicycrunch Carrot##74841 |q 31946/3
	step
		goto 44.2,34.3
		.talk Mung-Mung##57401
		..turnin Mung-Mung's Vote III: The Great Carrot Caper##31946
		|next "end"
	step
	label fung
		goto 52.3,48.8
		.talk Farmer Yoon##58646
		..accept Farmer Fung's Vote I: Yak Attack##30517
		|next |only if repval('The Tillers','Revered')>=8400
		.' Click here if this quest is not available yet |confirm |next end
	step
		goto 48.3,33.9
		.talk Farmer Fung##57298
		..turnin Farmer Fung's Vote I: Yak Attack##30517
		..accept Farmer Fung's Vote II: On the Loose##30518
	step
		goto 51.0,36.7
		.clicknpc Escaped Shagskin##59491
		.' Ride 5 Escaped Shagskin to [50.4,34.7] |q 30518/1
	step
		goto 48.3,33.9
		.talk Farmer Fung##57298
		..turnin Farmer Fung's Vote II: On the Loose##30518
		..accept Farmer Fung's Vote III: Crazy For Cabbage##31947
	step
		goto 52.9,52.1
		.talk Merchant Greenfield##58718
		.buy 3 Green Cabbage Seeds##79102 |q 31947
	step
		goto 52.0,48.4
		.clicknpc Untilled Soil##58562
		.' Use your Green Cabbage Seeds on the Tilled Soil |use Green Cabbage Seeds##79102
		.' Plant 3 Green Cabbage Seeds |q 31947/1
		|modelnpc Tilled Soil##58563
	step
		'Wait a day for the Green Cabbage to grow and then harvest them.
		.' Harvest 3 Green Cabbage |q 31947/2
		.get 15 Green Cabbage##74840 |q 31947/3
	step
		goto 48.3,33.9
		.talk Farmer Fung##57298
		..turnin Farmer Fung's Vote III: Crazy For Cabbage##31947
	step
	label nana
		goto 52.2,48.8
		.talk Farmer Yoon##58646
		..accept Nana's Vote I: Nana's Secret Recipe##30519
		|next |only if repval('The Tillers','Revered')>=16800
		.' Click here if this quest is not available yet |confirm |next end
	step
		goto 54.7,47.0
		.talk Nana Mudclaw##64597
		..turnin Nana's Vote I: Nana's Secret Recipe##30519
		..accept Nana's Vote II: The Sacred Springs##31948
	step
		goto 56.7,21.7
		.from Thousand-Year Guardian##66850+
		.' You may have to kill the Guardian first, then collect the water
		'Use the Empty Pitcher while standing under the waterfall. |use Empty Pitcher##89902
		.' Thousand-Year Water |q 31948/1
	step
		goto 54.7,47.0
		.talk Nana Mudclaw##64597
		..turnin Nana's Vote II: The Sacred Springs##31948
		..accept Nana's Vote III: Witchberry Julep##31949
	step
		goto 52.9,52.1
		.talk Merchant Greenfield##58718
		.buy 3 Witchberry Seeds##89326 |q 31949
	step
		goto 52.0,48.4
		.clicknpc Untilled Soil##58562
		.' Use your Witchberry Seeds on the Tilled Soil |use Witchberry Seeds##89326
		.' Plant 3 Witchberry Seeds |q 31949/1
		|modelnpc Tilled Soil##58563
		|only if havequest(31949)
	step
		'Wait a day for the Witchberries to grow and then harvest them.
		.' Harvest 3 Witchberries |q 31949/2
		.get 15 Witchberries##74846 |q 31949/3	
	step
		goto 54.7,47.0
		.talk Nana Mudclaw##64597
		..turnin Nana's Vote III: Witchberry Julep##31949
	step
	label haohan
		goto 52.2,48.8
		.talk Farmer Yoon##58646
		..accept Haohan's Vote I: Bungalow Break-In##30521
		.' Click here if this quest is not available yet |confirm |next end
	step
		goto 44.6,34.1
		.talk Haohan Mudclaw##57402
		..turnin Haohan's Vote I: Bungalow Break-In##30521
		..accept Haohan's Vote II: The Real Culprits##30522
	step
		goto 39.4,43.6
		.clicknpc Muddy Tracks##52171
		.' Investigate 8 Suspicious Footprints. |q 30522/1 |tip When you click the eighth footprint a hozen will attack you.
	step
		goto 52.2,48.8
		.talk Farmer Yoon##58646
		..turnin Haohan's Vote II: The Real Culprits##30522
		..accept Haohan's Vote III: Pure Poison##30525
	step
		'Enter this warren |goto 47.0,20.9 <5 |c
	step
		.click Cave Lily
		.get Cave Lily##80141 |q 30525/2
	step
		'Leave this warren |goto 47.0,20.9 <5 |c
	step
		'Enter this warren |goto 44.0,22.2 <5 |c
	step
		.click Bloodbloom##2313
		.get Bloodbloom##80140 |q 30525/1
	step
		'Leave this warren |goto 44.0,22.2 <5 |c
	step
		goto 42.5,22.3
		.click Violet Lichen##2314
		.get Violet Lichen |q 30525/4
	step
		'Enter this warren |goto 39.4,20.4 <5 |c
	step
		.click Ghostcap##9844
		.get Ghostcap##80142 |q 30525/3
	step
		'Leave this warren |goto 39.4,20.4 <5 |c
	step
		goto 52.2,48.8
		.talk Farmer Yoon##58646
		..turnin Haohan's Vote III: Pure Poison##30525
		..accept Haohan's Vote IV: Melons For Felons##30527
	step
		goto 52.9,52.1
		.talk Merchant Greenfield##58718
		.buy 4 Striped Melon Seeds##89329 |q 30527
	step
		goto 52.0,48.4
		.clicknpc Untilled Soil##58562
		.' Use your Striped Melon Seeds on the Tilled Soil |use Striped Melon Seeds##89329
		.' Plant 4 Striped Melon Seeds |q 30527/1
		|modelnpc Tilled Soil##58563
	step
		'Wait a day for the Striped Melons to grow and then harvest them.
		.' Harvest 4 Striped Melons |q 30527/2
		.get 20 Striped Melon##74848 |q 30527/3	
	step
		goto 52.2,48.8
		.talk Farmer Yoon##58646
		..turnin Haohan's Vote IV: Melons For Felons##30527
		..accept Haohan's Vote V: Chief Yip-Yip##30528 //20000 Revered?
	step
		'Enter the cave here |goto 33.1,20.2 <5 |c
	step
		goto 32.4,20.6
		.kill Chief Yip-Yip##59567 |q 30528/1
		'Use the _Throw Melon_ button on your screen when he begins casting _Charging Up_. This will cause him to stop attacking and take increased damage for a few seconds.
	step
		goto 52.2,48.8
		.talk Farmer Yoon##58646
		..turnin Haohan's Vote V: Chief Yip-Yip##30528
	step
		goto 52.0,49.0
		'After some talking, the Offering Bowl should light up for you to click.
		.click Offering Bowl
		|confirm
		|next "end"
	step
	label exalted
		goto 52.2,48.8
		.talk Farmer Yoon##58646
		..accept Growing the Farm III: The Mossy Boulder##30529
		.' Click here if this quest is not available yet |confirm |next end
		|next |only if default
	step
		goto 44.6,34.1
		.talk Haohan Mudclaw##57402
		..turnin Growing the Farm III: The Mossy Boulder##30529
	step
		goto 51.9,48.3
		'When you arrive at Sunsong Ranch you will get a buff. After 15 minutes your ranch will be expanded. |tip You cannot buy your farm upgrade until the expansion is done. 
		|confirm
		|only if not completedq(31938)
	step
		goto 53.2,51.8
		.talk Gina Mudclaw##58706
		.buy 1 "Earth-Slasher" Master Plow##89814 |q 31938
	step
		'Click the "Earth-Slasher" Master Plow in your bags. |use "Earth-Slasher" Master Plow##89814
		..accept The "Earth-Slasher" Master Plow##31938
	step
		goto 52.3,48.8
		.talk Farmer Yoon##58646
		..turnin The "Earth-Slasher" Master Plow##31938
	step
		goto Valley of the Four Winds 54.7,47.0
		.talk Nana Mudclaw##64597
		..accept Inherit the Earth##32682
		|only if rep('The Tillers')==Exalted and not completedq(32682)
	step
		goto Valley of the Four Winds 52.2,48.8
		.talk Farmer Yoon##58646
		.' Ask him if he will join the council of the Tillers Union. |q 32682/1
		|only if rep('The Tillers')==Exalted and not completedq(32682)
	step
		goto Valley of the Four Winds 54.7,47.0
		.talk Nana Mudclaw##64597
		..turnin Inherit the Earth##32682 |tip This quest opens up the farm to you, granting you a place to rest and set your hearthstone, as well as opening up new quests known as work orders that allow you to gain reputation with other factions through farming.
		|only if rep('The Tillers')==Exalted and not completedq(32682)
	step
		goto 52.0,49.0
		.click Tillers Shrine##11506
		..accept A Second Hand##30534
	step
		'For this quest you must be _Best Friends_ with one of the 10 Tiller NPCs. Please refer to the Reputations guides for assistance in gaining rep for an individual.
		|confirm
	step
		'Go to your _Best Friend's_ home.
		.' Ask them: <Friend>, how'd you like to help us run the farm? |q 30534/1
	step
		goto 52.0,49.0
		.click Tillers Shrine##11506
		..turnin A Second Hand##30534
	step
	label end
		'The last thing to do with The Tillers each day is to plant as many crops as your farm can hold. Each crop harvest will award reputation so do this every day.
		.' Click here to go back to the beginning of the dailies section. |next "dailies" |confirm
]])

ZygorGuidesViewer:RegisterInclude("tillers_prequests",[[
		goto Vale of Eternal Blossoms 60.2,22.9
		.talk Farmhand Dooka##64011
		..accept The Tillers##31374
	step
		goto Valley of the Four Winds 52.0,48.0
		.talk Farmer Yoon##58721
		..turnin The Tillers##31374
		..accept A Helping Hand##30252
	step
		goto 51.8,48.8
		.click Unbudging Rock
		.' Clear 8 Unbudging Rocks |q 30252/1
	step
		goto 52.8,47.9
		.talk Farmer Yoon##58646
		..turnin A Helping Hand##30252
	step
		goto 52.3,48.8
		.talk Farmer Yoon##58646
		..accept Learn and Grow I: Seeds##30535
	step
		goto 52.9,52.2
		.talk Merchant Greenfield##58718
		.' Tell him you're there to pick up seeds.
		.' Get a Packet of Green Cabbage Seeds |q 30535/1
	step
		goto 52.3,48.8
		.talk Farmer Yoon##58646
		..turnin Learn and Grow I: Seeds##30535
		..accept Learn and Grow II: Tilling and Planting##30254
	step
		goto 52.0,48.3
		.clicknpc Untilled Soil##59985+
		.' Till 2 patches of Soil. |q 30254/1
		.' Use the EZ-Gro Green Cabbage Seeds in your bags on the Tilled Soil. |use EZ-Gro Green Cabbage Seeds##80302
		.' Plant seeds in 2 patches of Tilled Soil. |q 30254/2
		|modelnpc Tilled Soil##58563
	step
		goto 52.3,48.8
		.talk Farmer Yoon##58646
		..turnin Learn and Grow II: Tilling and Planting##30254
		..accept Learn and Grow III: Tending Crops##30255
	step 
		goto 52.0,48.3
		.' Use the Rusty Watering Can on the Parched EZ-Gro Green Cabbage |use Rusty Watering Can##79104
		.' Water 2 parched Ez-Gro Green Cabbage |q 30255/1
		|modelnpc Parched EZ-Gro Green Cabbage##59987
	step 
		goto 52.3,48.8
		.talk Farmer Yoon##58646
		..turnin Learn and Grow III: Tending Crops##30255
		..accept Learn and Grow IV: Harvesting##30256
	step
		goto 52.0,48.3
		.clicknpc Ripe EZ-Gro Green Cabbage##59833
		.get 2 EZ-Gro Green Cabbage |q 30256/1
	step
		goto 52.3,48.8
		.talk Farmer Yoon##58646
		..turnin Learn and Grow IV: Harvesting##30256
		..accept Learn and Grow V: Halfhill Market##30257
	step
		goto 52.8,48.0
		.click Dark Soil
		.get Marsh Lily |q 30257/1
	step
		goto 53.1,51.8
		.talk Gina Mudclaw##58706
		..turnin Learn and Grow V: Halfhill Market##30257
		..accept Learn and Grow VI: Gina's Vote##31945
	step
		goto 52.9,52.2
		.talk Merchant Greenfield##58718
		.buy 1 Scallion Seeds##80591 |q 31945
	step
		goto 52.0,48.4
		.clicknpc Untilled Soil##58562
		.' Use your Scallion Seeds on the Tilled Soil |use Scallion Seeds##80591
		.' Plant Scallion Seeds |q 31945/1
		|modelnpc Tilled Soil##58563
	step
	label info
		'Click here for information on Bursting Crops |next "bursting" |confirm
		'Click here for information on Parched Crops |next "parched" |confirm
		'Click here for information on Infested Crops |next "infested" |confirm
		'Click here for information on Wiggling Crops |next "wiggling" |confirm
		'Click here for information on Alluring Crops |next "alluring" |confirm
		'Click here for information on Smothered Crops |next "smothered" |confirm
		'Click here for information on Wild Crops |next "wild" |confirm
		'Click here for information on Runty Crops |next "runty" |confirm
		'Click here for information on Tangled Crops |next "tangled" |confirm
	step
	label bursting
		'Unless you got a Bursting Scallion immediately after planting your Scallions, you will have to wait a full day until you can pick your crops.
		.' Click here if you are ready to harvest your crops. |confirm
	step
		goto 52.0,48.4
		.clicknpc Bursting Scallions##63160 
		.clicknpc Ripe Scallions##63165
		.' Harvest Ripe Scallions |q 31945/2
		.get 5 Scallion##74843 |q 31945/3
		|next "exit"
	step
	label runty
		goto 52.0,48.4
		.clicknpc Runty Scallions##63166
		.' Press your Space Bar and jump. 
		.' Click here to return to the information page. |next "info" |confirm
		.' Click here when you are have tilled your crops. |next "bursting" |confirm
	step
	label wiggling
		goto 52.0,48.4
		.clicknpc Wiggling Scallions##63169
		.from Voracious Virmen##60039
		.' Click here to return to the information page. |next "info" |confirm
		.' Click here when you are have tilled your crops. |next "bursting" |confirm
	step 
	label infested
		goto 52.2,48.3
		.click Vintage Bug Sprayer
		.collect Vintage Bug Sprayer##80513 |n
		.' Use your Vintage Bug Sprayer on the Infested Scallions |use Vintage Bug Sprayer##80513
		|modelnpc Infested Scallions##63162
		.' Click here to return to the information page. |next "info" |confirm
		.' Click here when you are have tilled your crops. |next "bursting" |confirm
	step
	label alluring
		goto 52.2,48.3
		.clicknpc Alluring Scallions##63159
		.from Swooping Plainshawk##60072
		.' Click here to return to the information page. |next "info" |confirm
		.' Click here when you are have tilled your crops. |next "bursting" |confirm
	step 
	label wild
		goto 52.0,48.4
		.clicknpc Wild Scallions##63170	
		.' Ride the Scallion |invehicle |c 
	step
		'Spam the Flex ability on your new hotbar, when the plant tries to cast Vine Slam, interrupt it with your Gnaw ability.
		.' Build 50 stacks on Dominance. |outvehicle |c
	step
		.' Click here to return to the information page. |next "info" |confirm
		.' Click here when you are have tilled your crops. |next "bursting" |confirm
	step
	label tangled
		goto 52.0,48.4 |n
		.clicknpc Tangled Scallions##63168
		.' Run to [51.7,48.9]
		'|goto 51.7,48.9 <5 |c
	step
		.' Click here to return to the information page. |next "info" |confirm
		.' Click here when you are have tilled your crops. |next "bursting" |confirm
	step
	label parched
		goto 52.0,48.4
		.' Use the Rusty Watering Can on the Parched Scallions |use Rusty Watering Can##79104
		.' Click here to return to the information page. |next "info" |confirm
		.' Click here when you are have tilled your crops. |next "bursting" |confirm
		|modelnpc Parched Scallions##63163
	step
	label smothered
		goto 52.0,48.4
		.clicknpc Encroaching Weed##60185
		.' Ride the Weed |invehicle |c
	step
		'Spam the Pull ability on your new hotbar. 
		.' Pull the Weed |outvehicle |c
	step
		.' Click here to return to the information page. |next "info" |confirm
		.' Click here when you are have tilled your crops. |next "bursting" |confirm
		|modelnpc Smothered Scallions##63167
	step
	label exit
		goto 53.1,51.8
		.talk Gina Mudclaw##58706
		..turnin Learn and Grow VI: Gina's Vote##31945
]])

ZygorGuidesViewer:RegisterInclude("H_Anglers",[[
	step
		'You must have fishing in order to accept dailies from this faction.
		.'_
		.' Click here to begin today's dailies for the Anglers. |confirm |next "dailies"
	step
	label dailies
		'There will only be three dailies available from the following questgivers. It is possible for one questgiver to give you two quests in the same day, but it is unlikely.
		|confirm
	step
		goto Krasarang Wilds 67.9,45.2
		.talk Fisherman Haito##59584
		..accept Shocking!##30584 |or
		..accept Jagged Abalone##30586 |or
		.'_
		.' If these quests are unavailable today, click here. |confirm
	step
		goto 67.5,44.6
		.talk Fiznix##60136
		..accept Like Bombing Fish In A Barrel##30678 |or
		..accept Scavenger Hunt##30698 |or
		.'_
		.' If this quest is unavailable today, click here. |confirm
	step
		goto 67.5,43.5
		.talk Angler Shen##59586
		..accept Snapclaw##30700 |or
		..accept Fishing for a Bruising##30588 |or
		.'_
		.' If these quests are unavailable today, click here. |confirm
	step
		goto 68.3,43.5
		.talk John "Big Hook" Marsock##60674
		..accept Bright Bait##30754 |or
		..accept Jumping the Shark##30753 |or
		.'_
		.' If these quests are unavailable today, click here. |confirm
	step
		goto 67.6,42.5
		.talk Trawler Yotimo##60135
		..accept Armored Carp##30613 |or
		..accept Huff & Puff##30658 |or
		.'_
		.' If these quests are unavailable today, click here. |confirm
	step
		goto 68.4,42.1
		.talk Elder Fisherman Rassan##60673
		..accept What Lurks Below##30585 |or
		..accept Who Knew Fish Liked Eggs?##30598 |or
		.'_
		.' If these quests are unavailable today, click here. |confirm
	step
		goto 67.2,41.2
		.talk Fo Fook##60675
		..accept Piranha!##30763 |or
		..accept Viseclaw Soup##30701 |or
		.'_
		.' If these quests are unavailable today, click here. |confirm
	step
		goto 68.4,43.1
		.clicknpc Frenzied Reef Shark##60408 
		.' Ride the shark. |invehicle |c
		|only if havequest(30753)
	step
		'Use the abilities on your hotbar to kill the shark, make sure not to let your grip bar reach zero.
		.kill Frenzied Reef Shark##60408 |q 30753/1
		|only if havequest(30753)
	step
		goto 69.1,37.9
		.click Jagged Abalone##261
		.get 9 Jagged Abalone Meat##80277 |q 30586/1
		|only if havequest(30586)
	step
		'Enter the underwater cave here. |goto 71.3,38.5 <5 |c
		|only if havequest(30700)
	step
		goto 73.9,38.4
		.from Snapclaw##60401
		.get Snapclaw's Claw##80831 |q 30700/1
		|only if havequest(30700)
	step
		'Leave the cave. |goto 71.3,38.5 <5 |c
		|only if havequest(30700)
	step
		goto 65.6,30.5
		'Use your fishing skill to fish up 7 Dojani Eel.
		.get 7 Dojani Eel |q 30584/1
		|only if havequest(30584)
	step
		goto 62.4,40.9
		.kill 8 Riverblade Raider##59714+ |q 30588/1
		|only if havequest(30588)
	step
		goto 55.1,45.7
		.from Viseclaw Fry##61090+, Viseclaw Fisher##58880+
		.get 16 Viseclaw Fisher Eye##80832+ |q 30701/1
		|only if havequest(30701)
	step
		goto 59.8,38.8
		.click Suncrawler //unknow model wtf
		.get 7 Suncrawler##81116 |q 30754/1
		|only if havequest(30754)
	step
		goto 59.3,46.3
		'Use your Goblin Fishing Bomb to kill Sting Rays. |use Goblin Fishing Bomb##80599 |tip You can kill the Sting Rays by other means, using the bombs is much quicker though.
		.from Sting Ray##60278+
		.get 3 Stinger##80600+ |q 30678/1
		|only if havequest(30678)
	step
		goto 36.8,43.3
		'Use your fishing skill to fish up 5 Wolf Piranha.
		.get 5 Wolf Piranha |q 30763/1
		|only if havequest(30763)
	step
		goto 34.4,31.4
		'Use your fishing skill in the Mysterious Whirlpool until Narjon the Gulper appears. |tip When Narjon spawns, make sure to equip your weapon quickly.
		.from Narjon the Gulper##59689 |q 30585/1
		.get Beloved Ring##80262 |q 30585/2
		|only if havequest(30585)
	step
		goto 51.4,62.2
		'Use your Anglers Fishing Spear near a Prickly Puffer |use Anglers Fishing Spear##80403 |tip The closer you are the easier it is to hit the fish.
		.from Prickly Puffer##60037
		.get 5 Prickly Puffer Spine##80529 |q 30658/1
		|only if havequest(30658)
	step
		goto 67.5,44.8
		.click Goblin Fishing Raft
		.' Ride a Goblin Fishing Raft |havebuff Rafting
		|only if havequest(30698)
	step
		goto 64.3,50.7
		'Use your fishing skill in the Shipwreck Debris pools to fish up 15 Rusty Shipwreck Debris.
		.get 15 Shipwreck Debris |q 30698/1
		.' You can find more Debris at [64.3,50.6]
		|only if havequest(30698)
	step
		goto 65.2,47.5
		.click Pristine Crane Egg##1867
		.get Pristine Crane Egg |q 30598/1
		|only if havequest(30598)
	step
		goto 70.1,51.2
		'Use your Anglers Fishing Spear near an Armored Carp |use Anglers Fishing Spear##80403 |tip The closer you are the easier it is to hit the fish.
		.from Armored Carp##59936+
		.get 5 Armored Carp##80437 |q 30613/1
		|only if havequest(30613)
	step
		goto 68.2,42.7
		'Use the Pristine Crane Egg in your bags |use Pristine Crane Egg##80303
		.' Use your fishing skill in the Crane Yolk Pool and fish up a Silver Goby.
		.get Silver Goby##80310 |q 30598/2
		|only if havequest(30598)
	step
		goto 68.4,42.1
		.talk Elder Fisherman Rassan##60673
		..turnin What Lurks Below##30585
		..turnin Who Knew Fish Liked Eggs?##30598
	step
		goto 67.5,44.6
		.talk Fiznix##60136
		..turnin Like Bombing Fish In A Barrel##30678
		..turnin Scavenger Hunt##30698
	step
		goto 67.5,43.5
		.talk Angler Shen##59586
		..turnin Snapclaw##30700
		..turnin Fishing for a Bruising##30588
	step
		goto 67.6,42.5
		.talk Trawler Yotimo##60135
		..turnin Armored Carp##30613
		..turnin Huff & Puff##30658
	step
		goto 67.9,45.2
		.talk Fisherman Haito##59584
		..turnin Shocking!##30584
		..turnin Jagged Abalone##30586
	step
		goto 68.3,43.5
		.talk John "Big Hook" Marsock##60674
		..turnin Bright Bait##30754
		..turnin Jumping the Shark##30753
	step
		goto 67.2,41.2
		.talk Fo Fook##60675
		..turnin Piranha!##30763
		..turnin Viseclaw Soup##30701
	step
		goto 68.4,43.4
		.talk Nat Pagle##63721
		..buy 1 Grand Commendation of the Anglers##93225 |n
		.' Use the Commendation of the Anglers you just purchased. |condition ZGV:GetReputation("The Anglers").hasBonus |use Grand Commendation of the Anglers##93225
		|only if rep("The Anglers")>=Revered
	step
		'You have reached the end of this guide.
		.' Click here to go back to the dailies. |confirm |next "dailies"
]])

ZygorGuidesViewer:RegisterInclude("H_Klaxxi",[[
	step
		'This guide requires that you have completed all of the quests in the Dread Wastes.
		'The following questlines are required to access all of the possible dailies for the Klaxxi.
		.' A Cry From Darkness |achieve 6540/1
		.' Falling to Pieces |achieve 6540/2
		.' Blood of Ancients |achieve 6540/3
		.' Mazu's Bounty |achieve 6540/4
		..' Please refer to Zygor's Leveling and Loremaster guides for assistance in completing these questlines. |only if not achieved(6540) and not ZGV.guidesets['LevelingHMOP']
		..' Click here to go to Zygor's Leveling and Loremaster guides for assistance in completing these questlines. |confirm |next "Zygor's Horde Leveling Guides\\Pandaria 85-90\\Dread Wastes (89-90)" |only if not achieved(6540) and ZGV.guidesets['LevelingHMOP']
		|confirm
	step
	label	klaxxi start
		goto Dread Wastes 55.0,35.4
		.talk Malik the Unscathed##62774
		..accept The Empress' Gambit##31959
		|only if rep("The Klaxxi")>=Exalted
	step
		goto Dread Wastes 55.0,35.9
		.talk Kil'ruk the Wind-Reaver##62538
		..accept Dreadspinner Extermination##31231 |or 2
		..accept Nope Nope Nope##31235 |or 2
		..accept Culling the Swarm##31109 |or 2
		..accept Mistblade Destruction##31267 |or 2
		..accept Eradicating the Zan'thik##31111 |or 2
		..accept Vess-Guard Duty##31505 |or 2
		|noquest
	step
		goto 54.9,36.2
		.talk Xaril the Poisoned Mind##62151
		..accept Dark Skies##31216
		|noquest
		|only if completedq(31211)
	step
		goto 54.8,36.2
		.talk Hisek the Swarmkeeper##63785
		..accept Debugging the Terrace##31237 |or
		..accept Quiet Now##31510 |or
		..accept Infection##31272 |or
		..accept Ordnance Disposal##31504 |or
		|noquest
		|only if completedq(31439)
	step
		goto 54.3,36.1
		.talk Korven the Prime##62180
		..accept An Ancient Empire##31232 |or 2
		..accept Sap Tapping##31233 |or 2
		..accept Sampling the Empire's Finest##31496 |or 2
		..accept The Fight Against Fear##31270 |or 2
		..accept The Scale-Lord##31269 |or 2
		..accept Meltdown##31507 |or 2
		|noquest
	step
		goto 54.3,35.9
		.talk Rik'kal the Dissector##65253
		..accept Bad Genes##31271 |or 2
		..accept Wing Clip##31502 |or 2
		..accept Shortcut to Ruin##31503 |or 2
		..accept Putting An Eye Out##31234 |or 2
		..accept Specimen Request##31508 |or 2
		..accept Fear Takes Root##31509 |or 2
		|noquest
		|only if completedq(31606)
	step
		goto 54.3,35.8
		.talk Kaz'tik the Manipulator##63758
		..accept Brain Food##31238 |or 2
		..accept Sonic Disruption##31487 |or 2
		..accept Free From Her Clutches##31494 |or 2
		..accept A Little Brain Work##31268 |or 2
		..accept Kunchong Treats##31024  |or 2
		..accept Rampage Against the Machine##31808 |or 2
		..accept Shackles of Manipulation##31506 |or 2
		|noquest
//terrace of gurthan
	step
		goto 55.1,35.9
		.talk Kil'ruk the Wind-Reaver##62538
		.' Tell him:
		.' <Please Fly me to the Terrace of Gurthan.> |invehicle
		|only if havequest(31237) or havequest(31231)
	step
		 goto 67.9,24.3
		 .' Kill creatures until you get the buff:
		 .' Pheremone Tracking |havebuff Interface\Icons\Ability_Rogue_BloodyEye
		 .' Locate and kill Eye's of the Empress. |tip Start looking for red mist on the groud first.
		 .kill 6 Eye of the Empress##63783+ |q 31237/1
		|only if havequest(31237)
	step
		'In order to do the 'hidden' quest for this area, you must have at least one other person to help you.
		|confirm |future |q 31677
		|only if havequest(31237) or havequest(31231)
	step
		goto 66.2,31.8
		.' Around this location you should be able to see a _green rune_ and a _red rune_.
		.' One person will need to _/lay_ on the _green rune_, while the other must _/kneel_ at the _red rune_. This will cause a level 90 Elite to spawn.
		.' This daily is active for everyone in the area, so you should find some help easily.
		.from Warlord Gurthan##65502
		.collect Ashes of Warlord Gurthan##88715 |future |q 31677
		|only if havequest(31237)
	step
		.' Click the _Ashes of Warlord Gurthan_ in your bags |use Ashes of Warlord Gurthan##88715
		..accept The Warlord's Ashes##31677
		|only if havequest(31237) or havequest(31677)
	step
		goto 54.9,36.2
		.talk Xaril the Poisoned Mind##62151
		.' Talk to Xaril and tell him:  |q 31216/1
		.' <I am ready to fly, Xaril.> |invehicle
		|only if havequest(31216)
	step
		'Use the _Venom Bomb_ to kill the small enemies. 
		.' Use the _Paralyzing Syrum_ then immidiately the _Venom Bomb_ to kill the larger enemies.
		.kill 200 Mantid |q 31216/2
		.kill 3 Kunchong |q 31216/3
		|only if havequest(31216)
	step
		'Click the Return to Klaxxi'vess button on your action bar |outvehicle
		|only if havequest(31216)
	step
		goto 55.0,35.9
		.talk Kil'ruk the Wind-Reaver##62538
		.' Ask him to fly you to the Clutches of Shek'zeer. |invehicle
		|only if havequest(31109)
	step
		goto 38.3,30.3
		'Use the Sonic Divebomb ability on your new hotbar to land. |outvehicle
		tip It's a good idea to land on Karanosh <Kunchong Matriarch>, she drops a daily quest item.
		|only if havequest(31109)
	step
		'Enter this building. |goto 37.0,28.1 <5 |c
		goto 37.4,29.3
		.click Central Feeder##12991
		.' Sample the Central Feeder |q 31496/1
		|only if havequest(31496)
	step
		'Enter this building. |goto 39.3,29.3 <5 |c
		goto 39.1,30.5
		.click Northeast Feeder##12991
		.' Sample the Northeast Feeder |q 31496/4
		|only if havequest(31496)
	step
		goto 39.3,30.9
		.kill Vess-Guard Na'kal##64890 |q 31503/1
		|only if havequest(31503)
	step
		'Enter this building. |goto 38.3,32.0 <5 |c
		goto 37.9,33.1
		.click East Feeder##12991
		.' Sample the East Feeder |q 31496/2
		|only if havequest(31496)		
	step
		'Enter this building. |goto 36.3,32.3 <5 |c
		goto 37.0,32.8
		.click North Feeder##12991
		.' Sample the North Feeder |q 31496/3
		|only if havequest(31496)		
	step
		goto 35.2,31.3
		.from Shek'zeer Needler##64714+
		.get 24 Needler Wings##87401 |q 31502/1 
		|only if havequest(31502)
	step
		goto 66.0,19.3
		.from Greatback Mushan##62029
		.get 6 Mushan Tongue##85665 |q 31238/1
		.' You can find more Mushan around [56.9,23.4]
		|only if havequest(31238)
	step
		goto 73.2,22.5
		'Use the Shado-Pan Dragon Gun on Dreadspinner Eggs |use Shado-Pan Dragon Gun##82807 |only if havequest(31235)
		.' Destroy 20 Dreadspinner Eggs |q 31235/1 |only if havequest(31235)
		.kill 8 Dreadspinner Tender##61981+ |q 31231/1 |only if havequest(31231)
		|only if havequest(31235) or havequest(31231)
	step
		goto 68.1,30.0
		.click Gurthani Tablet
		.get 8 Gurthani Tablet##85634 |q 31232/1
		|only if havequest(31232)
	step
		goto 67.7,37.1
		.from Mire Beast##63731+
		.get 1 Pristine Mire Beast Eye## |q 31234/1
		|only if havequest(31234)
	step
		goto 66.6,43.8
		.click Amber Tap |tip These are located on trees. Look for Sapfly packs to find these easier. |modelnpc Sapfly##62386
		.click Amber Pot
		.get 6 Amber Sap##85664 |q 31233/1
		|only if havequest(31233)
	step
		goto 42.0,33.7
		.click Pheromone Mine
		.' Disable 8 Pheromone Mines |q 31504/1
		.' You can find more mines around [48.1,31.4]
		|only if havequest(31504)
	step
		goto 44.9,35.6
		.' Use the Sonic Disruption Fork on Dread Kunchong. |use Sonic Disruption Fork##87394 |only if havequest(31487)
		.kill 4 Dread Kunchong##64717 |q 31487/1 |only if havequest(31487)
		.kill 6 Shek'zeer Manipulator##64720 |q 31487/2 |only if havequest(31487)
		.click Kunchong Cage |only if havequest(31494)
		.' Free 8 Kunchong Hatchlings |q 31494/1 |only if havequest(31494)
		|only if havequest(31487) or havequest(31494)
	step
		goto 44.4,43.0
		.from Shek'zeer Swarmborn##62582+, Shek'zeer Needler##64714+, Shek'zeer Bladesworn##62563+, Shek'zeer Clutch-Keeper##64559+
		.' Kill 40 Shek'zeer Mantid. |q 31109/1
		tip It's by far fastest to kill the tiny Shek'zeer Swarmborn by the dozen.
		|only if havequest(31109)
	step
		goto 41.4,33.2
		.from Karanosh##64724 |tip She wanders around this area, so you may have to search for her.
		.collect Enormous Kunchong Mandibles##87878
		.' Click the Enormous Kunchong Mandibles in your bags |use Enormous Kunchong Mandibles##87878
		..accept The Matriarch's Maw##31599
		|only if havequest(31109)
	step
		goto 58.6,51.1 
		.kill 15 Horrorscale Scorpid##62162+ |q 31270/1 |only if havequest(31270)
		.from Chillwater Turtle##62160+ |only if havequest(31024)
		.get 4 Meaty Turtle Haunch##82869 |q 31024/1 |only if havequest(31024)
		|only if havequest(31270) or havequest(31024)
	step
		goto 62.0,65.8
		.kill 3 Ik'thik Genemancer##63257+ |q 31271/1
		.kill 6 Ik'thik Egg-Drone##63176+ |q 31271/2
		|only if havequest(31271)
	step
		goto 61.4,70.3
		.' Use the Sonic Emitter in your bags on Ik'thik Amberstingers. |use Sonic Emitter##85884
		.from Ik'thik Amberstinger##63728+ 
		.get 3 Amber-Encrusted Brain##85885 |q 31268/1
		|only if havequest(31268)
	step
		 goto 60.7,67.7
		.from Bluehide Mushan##63729+, Needleback Porcupine##65118+, Bonedust Moth##63725+ |tip Make sure that they have the Infected buff before you attack them. Only wildlife with that buff will count for this quest.
		.kill 6 Infected wildlife |q 31272/1
		|only if havequest(31272)
	step
		'Enter the tunnel here. |goto 66.8,63.8 <5 |c
		|only if havequest(31269)
	step
		goto 66.5,66.0
		.kill Mistblade Scale-Lord##63179 |q 31269/1
		|only if havequest(31269)
	step
		'Leave the tunnel. |goto 66.8,63.8 <5 |c
		|only if havequest(31269)
	step
		goto 67.2,59.3
		.kill 6 Mistblade Ripper##61970+ |q 31267/1
		|only if havequest(31267)
	step
		goto 55.1,35.9
		.talk Kil'ruk the Wind-Reaver##62538
		.' Ask him to fly you to Zan'vess |invehicle
		|only if havequest(31111) or havequest(31508) or havequest(31506) or havequest(31111) or havequest(31510)
	step
		goto 31,70
		'Use the Sonic Divebomb ability on your new hotbar to land. |outvehicle
		|only if havequest(31111) or havequest(31508) or havequest(31506) or havequest(31111) or havequest(31510)
	step
		'As you complete quests in this area:
		.click Dreadspore Bulbs##391
		.' Destroy 15 Dreadspore Bulbs |q 31509/1 |n
		|confirm
		|only if havequest(31509)
	step
		goto 31.5,69.6
		.from Kypari Crawler##65231+ |only if havequest(31508)
		.get 6 Kyparite Shards |q 31508/1 |only if havequest(31508)
		.from Thought-Bound Miner##64970+ |only if havequest(31506)
		.get 6 Zan'thik Shackles |q 31506/1 |only if havequest(31506)
		.kill 6 Zan'thik Impaler##64971+ |q 31111/1 |only if havequest(31111)
		.kill 6 Zan'thik Manipulator##64973+ |q 31111/2 |only if havequest(31111)
		|only if havequest(31506) or havequest(31111) or havequest(31508)
	step
		goto 33.4,61.0
		.from Kypa'rak##65229
		.collect 1 Massive Kyparite Core |n
		.'_
		.' Click the Massive Kyparite Core in your bags |use Massive Kyparite Core##87871
		..accept Kypa'rak's Core##31598
		|only if havequest(31111) or havequest(31508) or havequest(31506) or havequest(31111) or havequest(31510)
	step
		goto 29.1,74.7
		..kill Vess-Guard Vik'az##64979+ |q 31505/1
		|only if havequest(31505)
	step
		goto 23.0,77.3
		.kill 6 Zan'thik Amberhusk##64982+ |q 31507/1
		|only if havequest(31507)
	step
		'All around this area
		.click Dreadspore Bulbs##391
		.' Destroy 15 Dreadspore Bulbs |q 31509/1
		|only if havequest(31509)
	step
		goto 24.2,86.2
		.click Zan'thik Resonating Crystal##214455
		.kill Adjunct Sek'ot##64995 |q 31510/1
	step
		goto 50.8,41.3
		.clicknpc Kovok##63765
		.' Locate Kovok |q 31808/1 
		|only if havequest(31808)
	step
		'Use the abilities on your hotbar to complete your task.
		.from Ik'thik Slayer, Ik'thik Kunchong, Ik'thik Warrior
		.' Kill 200 Mantid |q 31808/2
		|only if havequest(31808)
	step
		goto 55.0,35.4
		.talk Ambersmith Zikk##64599
		..turnin Kypa'rak's Core##31598
		..turnin The Matriarch's Maw##31599
		|only if havequest(31598) or havequest(31599)
	step
		goto 55.0,35.9
		.talk Kil'ruk the Wind-Reaver##62538
		..turnin Dreadspinner Extermination##31231 
		..turnin Nope Nope Nope##31235 
		..turnin Culling the Swarm##31109 
		..turnin Mistblade Destruction##31267
		..turnin Eradicating the Zan'thik##31111
		..turnin Vess-Guard Duty##31505
		..turnin The Warlord's Ashes##31677
	step
		goto 54.9,36.2
		.talk Xaril the Poisoned Mind##62151
		..turnin Dark Skies##31216
	step
		goto 54.8,36.2
		.talk Hisek the Swarmkeeper##63785
		..turnin Debugging the Terrace##31237
		..turnin Quiet Now##31510
		..turnin Infection##31272
		..turnin Ordnance Disposal##31504
	step
		goto 54.3,36.1
		.talk Korven the Prime##62180
		..turnin An Ancient Empire##31232 
		..turnin Sap Tapping##31233 
		..turnin Sampling the Empire's Finest##31496 
		..turnin The Fight Against Fear##31270
		..turnin The Scale-Lord##31269
		..turnin Meltdown##31507
	step
		goto 54.3,35.9
		.talk Rik'kal the Dissector##65253
		..turnin Bad Genes##31271 
		..turnin Wing Clip##31502
		..turnin Shortcut to Ruin##31503
		..turnin Putting An Eye Out##31234
		..turnin Specimen Request##31508
		..turnin Fear Takes Root##31509
	step
		goto 54.3,35.8
		.talk Kaz'tik the Manipulator##63758
		..turnin Brain Food##31238 
		..turnin Sonic Disruption##31487 
		..turnin Free From Her Clutches##31494 
		..turnin A Little Brain Work##31268
		..turnin Kunchong Treats##31024
		..turnin Rampage Against the Machine##31808
		..turnin Shackles of Manipulation##31506
		|next |only if rep("The Klaxxi")>=Revered and not completedq(31465)
		|next "exalted" |only if rep("The Klaxxi")>=Exalted and not completedq(31612)
		|next end |only if default
	step
		goto 55.0,35.6
		.talk Ambersmith Zikk##64599
		..buy 1 Grand Commendation of the Klaxxi##92522 |n
		.' Use the Commendation of the Klaxxi you just purchased. |condition ZGV:GetReputation("The Klaxxi").hasBonus |use Grand Commendation of the Klaxxi##92522
		|only if rep("The Klaxxi")>=Revered
	step
		goto 55.1,35.9
		.talk Kil'ruk the Wind-Reaver##62538
		..accept Beneath The Heart Of Fear##31018
	step
		goto 29.0,42.4 |n
		.' Enter this tunnel |goto 29.0,42.4 <5 |noway |c
	step
		goto 30.7,40.3
		.kill Adjunct Ek'vem##62073+ |q 31018/1
	step
		goto 33.4,40.2
		.kill Adjunct Ikkess##62074+ |q 31018/2
	step
		goto 33.4,44.3
		.kill Adjunct Suruz##62075+ |q 31018/3
	step
		goto 30.7,44.4
		.kill Adjunct Tzikzi##62076+ |q 31018/4
	step
		goto 31.9,42.5
		.click Ancient Amber Chunk
		.' Wake Xaril the Poisoned Mind |q 31018/5
	step
		goto 29.0,42.4 |n
		.' Exit the tunnel here |goto 29.0,42.4 <5 |noway |c
	step
		goto 28.6,42.1
		.talk Xaril the Poisoned Mind##62151
		..turnin Beneath The Heart Of Fear##31018
		..accept Venomous Intent##31208
		..accept Dark Wings, Dark Things##31209
		..accept A Shade of Dread##31210
	step
		goto 24.7,41.8
		.from Ruby Venomtail##63588+, Dread Scarab##63587+
		.get 150 Scarab Wing |q 31209/1
		.get 8 Venomous Stinger |q 31208/1
		.click Dreadshade##5031
		.get 8 Dreadshade |q 31210/1
		.' You can find more around [26.4,36.4]
		.' And here [26.2,30.8]
	step
		goto 28.6,42.1
		.talk Xaril the Poisoned Mind##62151
		..turnin Venomous Intent##31208
		..turnin Dark Wings, Dark Things##31209
		..turnin A Shade of Dread##31210
	step
		goto 28.6,42.1
		.talk Xaril the Poisoned Mind##62151
		..accept The Poisoned Mind##31211
	step
		goto 28.6,42.1
		.talk Xaril the Poisoned Mind##62151
		.' Tell him:
		.' <I am ready to fly, Xaril.> |invehicle |q 31211
	step
		'Use the _Venom Syrum_ to kill the small enemies. 
		.' Use the _Paralyzing Syrum_ then immidiately the _Venom Syrum_ to kill the larger enemies.
		.' Speak to Xaril the Poisoned Mind |q 31211/1
		.kill 200 Mantid |q 31211/2
		.kill 3 Kunchong |q 31211/3
		'|from Krik'thik Wingguard##63613+, Ik'thik Warrior##63635+, Ik'thik Slayer##63636+ Dread Behemoth##65513+, Krik'thik Battletank##63625+, 
	step
		goto 54.9,36.2
		.talk Xaril the Poisoned Mind##62151
		..turnin The Poisoned Mind##31211
	step
		goto 54.8,34.1
		.talk Kor'ik##64815
		..accept Dropping Our Signal##31439
	step
		goto 56.3,58.2
		.' Use your Tuning Fork on the Amber Rock |use Klaxxi Tuning Fork##87202
		.' Awaken Hisek the Swarmkeeper |q 31439/1
	step
		goto 56.3,58.2
		.talk Hisek the Swarmkeeper##64672
		..turnin Dropping Our Signal##31439
		..accept Corruption Runs Deep##31441
	step
		goto 56.2,57.6
		.kill Kor'ik##64583+ |q 31441/1
	step
		goto 56.3,57.6
		.talk Hisek the Swarmkeeper##64705
		..turnin Corruption Runs Deep##31441
		..accept Damage Control##31458
		..accept Extracting Answers##31465
	step
		goto 55.6,47.1
		.click Kypari Ik Beacon##11971
		.' Deactivate Kypari Ik Resonating Crystal |q 31458/2
	step
		goto 50.5,45.8
		.kill 5 Ik'thik Whisperer##64622+ |q 31458/1
		.from Ik'thik Swarmborn##64831+
		.get 6 Venom-Coated Mandible |q 31465/1
	step
		goto 54.8,36.2
		.talk Hisek the Swarmkeeper##63785
		..turnin Damage Control##31458
		..turnin Extracting Answers##31465
		|next |only if rep("The Klaxxi")>=Exalted and not completedq(31612)
		|next end |only if default
	step
	label "exalted"
		goto 40.4,34.4
		.talk Malik the Unscathed##66776
		.' Report to Malik the Unscathed |q 31959/1
	step
		.' Click the Auto complete quest box that appears below your minimap:
		..turnin The Empress' Gambit##31959
		..accept The Wrath of Shek'zeer##31609
	step
		.' While you are completing this quest, you will need to assist your Mantid Swarm in defeating 25 Mantid Subjugates.
		|confirm
		|modelnpc 66789
		|modelnpc 66788
		|modelnpc 66790
	step
		goto 44.6,35.2
		.kill Akkolon##66783 |q 31609/1
		|tip You will have Paragons waiting in thie area to help you. If Akkolon is not in this location, you will have to wait to allow him to respawn.
	step
		goto 41.6,39.8
		.kill Shox'tik##66784 |q 31609/2
		|tip You will have Paragons waiting in thie area to help you. If Shox'tik is not in this location, you will have to wait to allow him to respawn.
	step
		goto 43.8,29.6
		.kill Manifestation of Terror##66785 |q 31609/3
		|tip You will have Paragons waiting in thie area to help you. If the Manifestation of Terror is not in this location, you will have to wait to allow it to respawn.
	step
		goto 43.4,33.0
		.kill 25 Mantid Subjugates |q 31609/4
	step
		goto 55.0,35.9
		.talk Kil'ruk the Wind-Reaver##62538
		..turnin The Wrath of Shek'zeer##31609
		..accept Shadow of the Empire##31612
	step
		.' Follow Kil'ruk the Wind-Rever into the chamber
		.' Walk with Kil'ruk |q 31612/1
	step
		.' Next to you:
		.talk Kil'ruk the Wind-Reaver##66800
		..turnin Shadow of the Empire##31612
		|next end
	step
	label end
		'This is the end of this guide.
		.' Click here to return to the beginning of the dailies |confirm |next "klaxxi start"
]])

ZygorGuidesViewer:RegisterInclude("Golden_Lotus_PreQuests",[[
		goto Kun-Lai Summit 72.0,94.2
		.talk Wanderer Chu##64521
		..accept Temple of the White Tiger##31393
	step
		goto Kun-Lai Summit 68.7,43.0
		.talk Sunwalker Dezco##64542
		..turnin Temple of the White Tiger##31393
		..accept A Celestial Experience##31395
	step
		goto Kun-Lai Summit 68.9,42.8
		'Talk to Xuen |q 31395/1 |modelnpc Xuen##64528
		.from Spirit of Violence##64656
		.' Pass the First Test |q 31395/2
		.from Spirit of Anger##64684
		.' Pass the Second Test |q 31395/3
		.from Spirit of Hatred##64742
		.' Pass the Third Test |q 31395/4
	step
		goto Kun-Lai Summit 68.7,43.0
		.talk Sunwalker Dezco##64542
		..turnin A Celestial Experience##31395
		..accept A Witness to History##31511
	step
		goto Kun-Lai Summit 56.0,91.4
		.talk Sunwalker Dezco##64853
		.' Tell him there is only one way to find out. |q 31511/1
	step
		goto Shrine of Two Moons/1 69.3,48.9
		.talk Madam Vee Luo##62996
		..accept A Witness to History##31511
	step
		goto Vale of Eternal Blossoms 56.1,91.6
		.talk Sunwalker Dezco##64853
		.' Tell him there is only one way to find out. |q 31511/1
	step
		goto Shrine of Two Moons/1 69.2,49.0
		.talk Madam Vee Luo##62996
		..turnin A Witness to History##31511
]])

ZygorGuidesViewer:RegisterInclude("Golden_Lotus",[[
	step
	label "dailies"
		goto Vale of Eternal Blossoms/0 21.4,71.6
		.talk Kun Autumnlight##58920
		..accept Mantid Under Fire##30243
		..accept Bloodied Skies##30266
		|noquest
	step
		goto Vale of Eternal Blossoms/0 21.4,71.6
		.talk Anji Autumnlight##58919
		..accept The Thunder Below##30280
		..accept The Crumbling Hall##30277
		|noquest
	step
		goto Vale of Eternal Blossoms/0 20.1,75.6
		.talk Hai-Me Heavyhands##58962 |tip He walks around the Trainees in this area.
		..accept The Battle Ring##30306
	step
		goto Vale of Eternal Blossoms/0 18.5,71.6
		.talk Yumi Goldenpaw##58743
		..accept Survival Ring: Blades##30242
		..accept Survival Ring: Flame##30240
		|noquest
	step
		goto Vale of Eternal Blossoms/0 18.1,63.5
		.talk Kelari Featherfoot##58704
		..accept Roll Club: Serpent's Spine##30261
	step
		goto Vale of Eternal Blossoms/0 18.1,63.5
		.talk Kelari Featherfoot##58704
		.' Tell him: <Let's roll>. |q 30261/1
		|only if havequest(30261)
	step
		'Hold down your right mouse button to help you maneuver through the course. |tip Grab as many speed boosts as you can to make it go quicker.
		.' Complete the Serpent's Spine Roll Course. |q 30261/2
		|only if havequest(30261)
	step
		goto Vale of Eternal Blossoms/0 18.1,63.5
		.talk Kelari Featherfoot##58704
		..turnin Roll Club: Serpent's Spine##30261
		|only if havequest(30261)
	step
		goto Vale of Eternal Blossoms 19.7,74.2
		.from Shado-Pan Trainee##58992+
		.' Defeat 20 Shado-Pan Trainees. |q 30306/1
		|only if havequest(30306)
	step
		goto Vale of Eternal Blossoms 19.2,67.5
		.' Stay within the circle and avoid the posts with blades surrounding them and the running pandas.
		.' Live through the Survival Ring for 90 seconds |q 30242/1
		|only if havequest(30242)
	step
		goto 19.2,67.5
		.' Stay within the circle and avoid getting hit by the fireworks.
		.' Live through the Survival Ring for 90 seconds |q 30240/1
		|only if havequest(30240)
	step
		goto Vale of Eternal Blossoms 5.4,72.3
		.click Setting Sun Turret 
		.' Mount a turret. |invehicle |c |tip It's on the upper level of the tower here.
		|only if havequest(30266)
	step
		.kill 30 Krik'thik Swarmer##63973+ |q 30266/1
		|only if havequest(30266)
	step
		'Click the Leave Vehicle button. |outvehicle
		|only if havequest(30266)
	step
		goto Vale of Eternal Blossoms 3.9,51.7
		.clicknpc Hot Oil Cauldron##64369
		.' Use the abilities on your hotbar to kill 80 Krik'thik Hivelings |q 30243/1 |tip Use the Ignitable Oil Bucket first, followed by the Shado-Pan Torch.
	step
		goto Vale of Eternal Blossoms 22.4,26.9
		'Traverse the following rooms by only stepping on the _green tiles_, other tiles will harm you.
		|confirm
		|only if havequest(30280) or havequest(30277)
	step
		goto Vale of Eternal Blossoms/19 53.9,68.3
		.kill Milau##64965 |q 30280/1 |tip Milau has several deadly abilities. He will cast a Lightning Breath in any direction, do not be in front of him when he does this. He also starts casting Lightning Pools, constantly move until he is done. Periodically he will pull you to the middle of the room and cast Lightning Sweep. While he is casting get as much distance on him as you can.
		|only if havequest(30280)
	step
		goto Vale of Eternal Blossoms/18 42.1,27.2
		.click Deactivate Final Spirit Wall
		.' Deactivate the Final Spirit Wall |q 30277/1
		|only if havequest(30277)
	step
		goto 49.4,30.6
		.click Ancient Guo-Lai Artifact
		.get Ancient Guo-Lai Artifact |q 30277/2
		|only if havequest(30277)
	step
		goto Vale of Eternal Blossoms/0 18.5,71.5
		.talk Yumi Goldenpaw##58743
		..turnin Survival Ring: Blades##30242
	step
		goto Vale of Eternal Blossoms/0 20.1,75.6
		.talk Hai-Me Heavyhands##58962 |tip He walks around the Trainees in this area.
		..turnin The Battle Ring##30306
	step
		goto Vale of Eternal Blossoms/0 21.4,71.6
		.talk Anji Autumnlight##58919
		..turnin The Thunder Below##30280
		..turnin The Crumbling Hall
	step
		goto Vale of Eternal Blossoms/0 21.4,71.6
		.talk Kun Autumnlight##58920
		..turnin Mantid Under Fire##30243
		..turnin Bloodied Skies##30266
	step
	label end
		'You have reached the end of the guide for today.
		.' Click here to go back to the beginning of the dailies. |confirm |next "dailies"
]])

ZygorGuidesViewer:RegisterInclude("H_Cloud_Serpent_Pre",[[
	step
		goto Vale of Eternal Blossoms 60.6,21.7
		.talk Wei Lakebreeze##64533
		..accept The Order of the Cloud Serpent##31375
	step
		goto The Jade Forest 57.5,45.1
		.talk Instructor Skythorn##58228
		..turnin The Order of the Cloud Serpent##31375
	step
		goto 57.7,45.0
		.talk Elder Anli##58564
		..accept Wild Things##30134
	step
		goto 65.3,31.7
		.talk Instructor Tong##58225
		..turnin Wild Things##30134
		..accept Beating the Odds##30135
		..accept Empty Nests##30136
		..accept Egg Collection##30137
	step
		goto 64.4,31.1
		.' Use the Silken Rope in your bags on Windward Hatchlings |use Silken Rope##78947
		.' Get 6 Hatchlings and bring them to [65.8,31.2]
		.' Return 6 Windward Hatchlings to their nests. |q 30136/1
	step
		goto 68.1,31.2
		.from Slitherscale Ripper##58212+, Slitherscale Eggdrinker##63532+
		.' Kill 8 Slitherscale saurok |q 30135/1
		.click Serpent Egg
		.get 6 Serpent Egg##78959 |q 30137/1
	step
		goto 65.3,31.7
		.talk Instructor Tong##58225
		..turnin Beating the Odds##30135
		..turnin Empty Nests##30136
		..turnin Egg Collection##30137
		..accept Choosing the One##30138
		..turnin Choosing the One##30138
	step
		goto 65.3,31.7
		.talk Instructor Tong##58225 |tip You will only accept one of the following quests.
		..accept The Rider's Journey##30139 |or
		..accept The Rider's Journey##30140 |or
		..accept The Rider's Journey##30141 |or
	step
		goto 57.6,45.1
		.talk Instructor Skythorn##58228 |tip You will only turn in one of the following quests.
		..turnin The Rider's Journey##30139
		..turnin The Rider's Journey##30140
		..turnin The Rider's Journey##30141
		..accept It's A...##30142
	step
		.' Watch the scene and see your egg hatch.
		.' Egg Hatched. |q 30142/1
	step
		goto 57.6,45.1
		.talk Instructor Skythorn##58228
		..turnin It's A...##30142
]])

ZygorGuidesViewer:RegisterInclude("H_Cloud_Serpent",[[
	step
	label	start
		'Proceeding to Order of the Cloud Serpent Dailies |condition completedq(30142) |next "dailies" |only if completedq(30142)
		'Moving to the Order of the Cloud Serpent prequests. |next |condition not completedq(30142) |only if not completedq(30142)
	step
		#include "H_Cloud_Serpent_Pre"
	step
	label dailies
		goto The Jade Forest 57.5,45.3
		'Talk to Your Hatchling |tip Your Hatchling is whichever color egg you chose in the prequests.
		..accept Catch!##30151 |or 2
		..accept Pooped##31704 |or 2
		..accept Feeding Time##30156 |or 2
		..accept The Easiest Way To A Serpent's Heart##30154 |or 2
		..accept Sweet as Honey##30150 |or 2
		|noquest
		|modelnpc Your Hatchling##58416
		|modelnpc Your Hatchling##58213
		|only if not completedq(30143)
	step
		goto 57.5,45.3
		'Talk to Your Hatchling |tip Your Hatchling is whichever color egg you chose in the prequests.
		..accept Catch!##30151 |or 2
		..accept Pooped##31704 |or 2
		..accept Pooped##31716 |or 2
		..accept Feeding Time##30156 |or 2
		..accept The Easiest Way To A Serpent's Heart##30154 |or 2
		..accept Sweet as Honey##30150 |or 2
		|noquest
		|modelnpc Your Hatchling##58416
		|modelnpc Your Hatchling##58213
		|only if completedq(30143)
	step
		goto 57.6,45.1
		.talk Instructor Skythorn##58228
		..accept Restoring the Balance##30155 |or 2
		..accept Disarming the Enemy##30158 |or 2
		..accept Thinning The Pack##31698 |or 2
		..accept Weeping Widows##31706 |or 2
		..accept A Tangled Web##31707 |or 2
		..accept Monkey Mischief##31712 |or 2
		|noquest
	step
		goto 57.5,44.7
		.talk Jenova Longeye##58413
		..accept Just a Flesh Wound##30148 |only if skill("First Aid")>=525
		..accept A Feast for the Senses##30149 |only if skill("Cooking")>=525
		..accept Fragments of the Past##30147 |only if skill("Archaeology")>=525 
		..accept Snack Time##30146 |only if skill("Fishing")>=1
		|tip NOTE: You will be able to accept Fragments of the Past at any level Archaeology, but won't be able to do the quest unless your skill in Archaeology is 525 or more.
	step
		goto 57.6,44.9
		.talk Elder Anli##58564
		..accept Slitherscale Suppression##31194 |or 2
		..accept Madcap Mayhem##31703 |or 2
		..accept Dark Huntress##31701 |or 2
		..accept On The Prowl##31702 |or 2
		..accept The Seed of Doubt##31711 |or 2
		..accept The Trainer's Challenge: Qua-Ro Whitebrow##31721 |or 2
		..accept The Trainer's Challenge: Ace Longpaw##31717 |or 2
		..accept The Trainer's Challenge: Suchi the Sweet##31720 |or 2
		..accept The Trainer's Challenge: Big Bao##31718 |or 2
		..accept The Big Kah-Oona##31715 |or 2
		|noquest
	step
		goto 58.3,45.0
		.talk Ningna Darkwheel##58509
		..accept Sprite Fright##31699 |or
		..accept The Shoe Is On The Other Foot##31700 |or
		|noquest
	step
		goto 58.5,44.7
		.talk Suchi the Sweet##58510
		..accept Preservation##30159 |or
		..accept Emptier Nests##30157 |or
		|noquest
	step
		goto 57.5,44.0
		.talk Big Bao##58508
		..accept Lingering Doubt##31709
		|noquest
	step
		goto 57.3,43.5
		.talk Qua-Ro Whitebrow##58511
		..accept Serpent's Scale##31708
		..accept Saving the Serpents##31714
		|noquest
	step
		goto The Jade Forest 58.6,43.7
		.talk Instructor Windblade##58420
		..accept The Sky Race##30152
		|noquest
	step
		goto 58.0,43.7
		.talk Ace Longpaw##58506
		..accept The Big Brew-haha##31713
		|noquest
	step
		goto 58.6,43.7
		.talk Instructor Windblade##58420
		.' Tell her you are ready to start the Sky Race.
		.' Ride your Dragon! |invehicle
		|only if havequest(30152)
	step
		path	60.6,39.4	59.7,31.5	61.3,25.2
		path	66.3,36.0	66.2,42.4	66.8,51.4
		path	64.0,51.0	60.4,52.9	61.8,54.5
		path	58.7,46.8	58.4,46.4	58.1,46.0
		'Follow this path and collect the checked flags hanging off of the Checkpoint balloons. As you fly, gain speed by flying through cloud rings
		.' Pass 10 Checkpoints. |q 30152/1
		.' Pass underneath the Finish Line |q 30152/2
		|only if havequest(30152)
	step
		goto 57.3,43.5
		.talk Qua-Ro Whitebrow##58511
		.' Challenge him to a duel!
		.' Defeat Qua-Ro Whitebrow |q 31721/1 
		|only if havequest(31721)
	step
		goto 58.0,43.7
		.talk Ace Longpaw##58506
		.' Challenge him to a duel!
		.' Defeat Ace Longpaw |q 31717/1
		|only if havequest(31717)
	step
		goto 57.5,44.0
		.talk Big Bao##58508
		.' Challnge him to a duel!
		.' Defeat Big Bao |q 31718/1
		|only if havequest(31718)
	step
		goto 58.5,44.7
		.talk Suchi the Sweet##58510
		.' Challenge her to a duel!
		.' Defeat Suchi the Sweet |q 31720/1
		|only if havequest(31720)
	step
		goto 69.8,31.3
		.kill Slitherscale Lizard-Lord##63536 |q 31194/1
		|only if havequest(31194)
	step
		goto 68.1,31.2 |only if havequest(30155) or havequest(30158)
		.from Slitherscale Ripper##58212+, Slitherscale Eggdrinker##63532+ |only if havequest(30155)
		.' Kill 8 Slitherscale saurok |q 30155/1 |only if havequest(30155)
		.click Slitherscale Weapons |only if havequest(30158)
		.get 5 Slitherscale Harpoon##79025 |q 30158/1 |only if havequest(30158)
		.click Serpent Egg |only if havequest(30159)
		.get 8 Serpent Eggs |q 30159/1 |only if havequest(30159)
	step
		goto 64.6,33.3
		.from Saltback Turtle##58218+, Saltback Yearling##58219+
		.collect 15 Saltback Meat Scrap##79028 |n
		.' Use the meat scraps to make a Saltback meat |use Saltback Meat Scrap##79028
		.collect 3 Saltback Meat##79027 |n
		.' Use the meat to feed your Hatchling |use Saltback Meat##79027 |q 30156/1
	step
		goto 57.2,45.2
		.' Use the Bouncy Ball in your bags. |use Bouncy Ball##79043
		.' Catch the Bouncy Ball whenever your Hatchling tosses it up, this will be every second throw.
		.' Catch the Ball 8 times. |q 30151/1
		|only if havequest(30151)
	step
		goto 55.1,46.5
		.click Hatchling Poop##9572 |tip It is all around this area.
		.get 5 Tiny Bags of Poop |q 31704/1
		|only if havequest(31704)
	step
		goto 55.1,46.5
		.click Hatchling Poop##9572 |tip It is all around this area.
		.get 5 Big Bags of Poop |q 31716/1
		|only if havequest(31716)
	step
		goto 57.5,45.4
		'Talk to Your Hatchling |tip Your Hatchling is whichever color egg you chose in the prequests.
		|modelnpc Your Hatchling##58416
		|modelnpc Your Hatchling##58213
		..turnin Pooped##31704
		|only if havequest(31704)
	step
		goto 57.5,45.4
		'Talk to Your Hatchling |tip Your Hatchling is whichever color egg you chose in the prequests.
		|modelnpc Your Hatchling##58416
		|modelnpc Your Hatchling##58213
		..turnin Pooped##31716
		|only if havequest(31716)
	step
		goto 62.7,27.4
		.kill Shadowfae Madcap##65613 |q 31703/1
		|only if havequest(31703)
	step
		goto 64.7,25.7
		.kill Windward Huntress##63538 |q 31701/1
		|only if havequest(31701)
	step
		goto 63.8,22.3
		.kill Windward Saber## |q 31702/1
		|only if havequest(31702)
	step
		goto 62.8,24.7
		.from Windward Tiger##63537 |only if havequest(30154)
		.get 5 Tiger Flank##85282 |q 30154/1 |only if havequest(30154)
		.kill 7 Shadowfae Trickster |q 31699/1 |only if havequest(31699)
		.from Windward Alpha+, Windward Tiger##63537+ |only if havequest(31698)
		.' Kill 8 Windward Tigers. |q 31698/1 |only if havequest(31698)
		.click Stolen Boots |only if havequest(31700)
		.get 14 Stolen Boots##89054 |q 31700/1 |only if havequest(31700)
	step
		'Enter the cave here. |goto 58.0,31.7 <5 |c
		|only if havequest(31708) or havequest(31710) or havequest(31706) or havequest(31711) or havequest(31709) or havequest(31707)
	step
		goto The Jade Forest/15 62.7,25.7
		.' Use the Sha Attunement Device next to this Disturbance |use Sha Attunement Device##88966
		.' Measure the Northeastern Sha Disturbance |q 31709/2
		|only if havequest(31709)
	step
		goto The Jade Forest/15 37.0,31.9
		.' Use the Sha Attunement Device next to this Disturbance |use Sha Attunement Device##88966
		.' Measure the Northwestern Sha Disturbance |q 31709/1
		|only if havequest(31709)
	step
		goto The Jade Forest/15 35.7,40.2
		.kill Seed of Doubt |q 31711/1
		|only if havequest(31711)
	step
		 goto The Jade Forest/15 61.0,74.1
		.' Use the Sha Attunement Device next to this Disturbance |use Sha Attunement Device##88966
		.' Measure the Southern Sha Disturbance |q 31709/3
		|only if havequest(31709)
	step
		.' Kill Widowspawn |only if havequest(31710)
		.get 100 Tiny Spider Eye's |q 31710/1 |only if havequest(31710)
		.kill 7 Weeping Widow |q 31706/1 |only if havequest(31706)
		.click Serpent's Scale |only if havequest(31708)
		.get 25 Serpent's Scale##88895 |q 31708/1 |only if havequest(31708)
		.from Widow's Web##65634+ |only if havequest(31707)
		.' Free 5 Sri-La Villagers |q 31707/1 |only if havequest(31707)
	step
		'Leave the cave. |goto The Jade Forest/15 75.8,19.0 |c
		|only if havequest(31708) or havequest(31710) or havequest(31706) or havequest(31711) or havequest(31709) or havequest(31707)
	step
		.' Enter the Oona Kagu cave. |goto The Jade Forest/0 57.7,27.7 <5 |c
		|only if havequest(31715)
	step
		goto The Jade Forest/16 45.8,77.8
		.kill 1 Lord Oona##65628 |q 31715/1
		|only if havequest(31715)
	step
		goto 55.2,28.4
		.click Serpent
		.collect 10 Rescued Serpent##88894 |q 31714/1
		|only if havequest(31714)
	step
		goto 55.2,28.4
		.from Oona Brewchugger##65624
		.click Stolen Sri-La Keg
		.' Collect 100 Sri-La Stout |q 31713/1
		|modeldisplay 11025
		|only if havequest(31713)
	step
		goto 55.2,28.0
		.from Oona Goon##65621+, Oona Brewchugger##65624+, Oona Tuna-Catcher##65623+
		.' Kill 13 Oona hozen |q 31712/1
		|only if havequest(31712)
	step
		goto The Jade Forest 64.5,31.1
		.' Use your Silken Rope on _Windward Hatchlings_. |use Silken Rope##78947
		.' Bring the Windward Hatchlings to the nest at [63.4,31.4].
		.' Return 6 Windward Hatchlings |q 30157/1
		|modelnpc 58243
		|modelnpc 58220
		|modelnpc 58244
		|only if havequest(30157)
	step
		'Use your First Aid skill to create 8 _Windwool Bandages_ or _Heavy Windwool Bandages_.
		'You can also ask other players to sell you some bandages.
		.create 8 Heavy Windwool Bandage##102698,First Aid,8 total |only if skill("First Aid")>=550 and skill("First Aid")<600
		.collect 8 Windwool Bandage##72985 |or |only if skill("First Aid")<550
		.' or
		.create 8 Heavy Windwool Bandage##102699,First Aid,8 total  |only if skill("First Aid")>=600
		.collect 8 Heavy Windwool Bandage##72986 |or |only if skill("First Aid")<550
		|only if havequest(30148)
	step
		goto 63.9,31.1
		.' Use your Windwool Bandages on Injured Hatchlings |use Windwool Bandage##72985
		.' Heavy Windwool Bandages work, too. |use Heavy Windwool Bandage##72986
		.' Bandage 8 Injured Hatchlings |q 30148/1
		|modelnpc Injured Hatchling##58416
		|only if havequest(30148)
	step
		goto 57.0,43.0
		.' Equip your Fishing Pole |use Fishing Pole##6256
		.' Use your Fishing skill to fish in the water here |cast Fishing##7620  |tip You will have to fish from Pools if you have low Fishing Skill.
		.get 10 Sugar Minnow##79046 |q 30146/1 |only if havequest(30146)
		.collect 10 Golden Carp##74866 |only if havequest(30149)
		|only if havequest(30146) or havequest(30149)
	step
		'Use your Cooking skill to create 5 Fish Cakes.
		.create 5 Fish Cake##104297,Cooking,5 total |q 30149/1 |or
		.buy 5 Fish Cake##74641 |or
		'You can ask other players to sell you some, if they happen to have leftovers.
		|only if havequest(30149)
	step
		goto The Jade Forest 55.1,47.2
		.from Honeykeeper##58363+
		.get 30 Honeycomb##79030 |q 30150/1
		|only if havequest(30150)
	step
		goto 58.0,43.7
		.talk Ace Longpaw##58506
		..turnin The Big Brew-haha##31713
		|only if havequest(31713)
	step
		goto 57.6,44.9
		.talk Elder Anli##58564 |tip You will only have a couple of these quests.
		..turnin Slitherscale Suppression##31194
		..turnin Dark Huntress##31701
		..turnin On The Prowl##31702
		..turnin Restoring the Balance##30155
		..turnin Disarming the Enemy##30158
		..turnin Madcap Mayhem##31703
		..turnin The Easiest Way To A Serpent's Heart##30154
		..turnin Sprite Fright##31699
		..turnin Thinning The Pack##31698
		..turnin The Shoe Is On The Other Foot##31700
		..turnin Weeping Widows##31706
		..turnin The Seed of Doubt##31711
		..turnin A Tangled Web##31707
		..turnin The Sky Race##30152
		..turnin The Trainer's Challenge: Qua-Ro Whitebrow##31721
		..turnin The Trainer's Challenge: Ace Longpaw##31717
		..turnin The Trainer's Challenge: Suchi the Sweet##31720 
		..turnin The Trainer's Challenge: Big Bao##31718
		..turnin Preservation##30159
		..turnin Lingering Doubt##31709
		..turnin Emptier Nests##30157
		..turnin Monkey Mischief##31712
		..turnin The Big Kah-Oona##31715
		..turnin Saving the Serpents##31714
	step
		goto 57.5,45.3
		'Talk to Your Hatchling |tip Your Hatchling is whichever color egg you chose in the prequests.
		|modelnpc Your Hatchling##58416
		|modelnpc Your Hatchling##58213
		..turnin Tiny Treats##31710 
		|only if havequest(31710)
	step
		goto 57.5,45.3
		'Talk to Your Hatchling |tip Your Hatchling is whichever color egg you chose in the prequests.
		|modelnpc Your Hatchling##58416
		|modelnpc Your Hatchling##58213
		|only if not completedq(30143)
	step
		goto 57.5,45.3
		'Talk to Your Hatchling |tip Your Hatchling is whichever color egg you chose in the prequests.
		|modelnpc Your Hatchling##58416
		|modelnpc Your Hatchling##58213
		|only if completedq(30143)
	step
		'Open your world map, find dig sites in Pandaria, then go to them |tip They look like small shovel icons on your world map that spawn in random places.  Once you get to the zone where the dig site is located, you will see the dig site on your map as a red highlighted area.
		.' Use your Survey ability inside the dig site area |cast Survey##80451
		.' A telescope will appear, follow the direction it points in and continue using your Survey ability to eventually find the artifacts |tip Each dig site has 6 artifacts you can find.
		.' Click the Archaeology Fragments that spawn on the ground
		.get 6 Serpentrider Relic## |q 30147/1
		|only if havequest(30147)
	step
		goto 57.5,44.7
		.talk Jenova Longeye##58413
		..turnin Just a Flesh Wound##30148 |only if skill("First Aid")>=525
		..turnin A Feast for the Senses##30149 |only if skill("Cooking")>=525
		..turnin Fragments of the Past##30147
		..turnin Snack Time##30146
	step
		goto 57.5,45.4
		'Talk to Your Hatchling |tip Your Hatchling is whichever color egg you chose in the prequests.
		|modelnpc Your Hatchling##58416
		|modelnpc Your Hatchling##58213
		..turnin Sweet as Honey##30150
		|only if havequest(30150)
	step
		goto 57.6,44.9
		.talk Elder Anli##58564
		..turnin Catch!##30151
		|only if havequest(30151)
	step
		goto 57.6,44.9
		.talk Elder Anli##58564
		..accept Needle Me Not##31705
		|only if completedq(30151)
	step
		goto 57.0,41.2
		.' Use the Golden Honey in your bags |use Golden Honey##89113
		.kill Orchard Needler |q 31705/1
		|only if havequest(31705)
	step
		goto 57.6,44.9
		.talk Elder Anli##58564
		..turnin Needle Me Not##31705
		|next "exalted" |only if rep("Order of the Cloud Serpent")==Exalted
		|next "revered" |only if rep("Order of the Cloud Serpent")==Revered
		|next "end" |only if rep("Order of the Cloud Serpent")<=Revered
	step
	label revered
		goto The Jade Forest 56.6,44.4
		.talk San Redscale##58414
		..buy 1 Grand Commendation of the Order of the Cloud Serpent##93229 |n
		.' Use the Commendation of the Order of the Cloud Serpent you just purchased. |condition ZGV:GetReputation("Order of the Cloud Serpent").hasBonus |use Grand Commendation of the Order of the Cloud Serpent##93229
		|only if rep("Order of the Cloud Serpent")>=Revered
	step
		goto 57.6,44.9
		.talk Elder Anli##58564
		..accept They Grow Like Weeds##30143
	step
		goto 58.6,43.7
		.talk Instructor Windblade##58420
		.' Ask Instructor Windbalde how your serpent is doing.
		.' Speak to Instructor Windblade |q 30143/1
	step
		goto 58.6,43.7
		.talk Instructor Windblade##58420
		..turnin They Grow Like Weeds##30143
		..accept Flight Training: Ring Round-Up##30144
	step
		'The color of Cloud Serpent depends on your egg color choice when you unlocked the dailies for this faction.
		.clicknpc Golden Cloud Serpent##58429
		.clicknpc Azure Cloud Serpent##58441
		.clicknpc Jade Cloud Serpent##58442
		.' Ride your Cloud Serpent |invehicle |c 
		|only if havequest(30144)
	step
		'Fly your Cloud Serpent through the rings made from clouds.
		.' Fly through 6 Cloud Rings |q 30144/1
	step
		goto 58.6,43.7
		.' Click the Leave Vehicle button |outvehicle |c
	step
		goto 58.6,43.7
		.talk Instructor Windblade##58420
		..turnin Flight Training: Ring Round-Up##30144
		..accept Flight Training: Full Speed Ahead##30145
	step
		'The color of Cloud Serpent depends on your egg color choice when you unlocked the dailies for this faction.
		.clicknpc Golden Cloud Serpent##58429
		.clicknpc Azure Cloud Serpent##58441
		.clicknpc Jade Cloud Serpent##58442
		.' Ride your Cloud Serpent |invehicle |c
		|only if havequest(30145)
	step
		'Follow Instructor Windblade through the course, her mounts flies faster than yours so fly through some of the cloud rings to maintain speed with your guide. If you move too slowly or get too far away from the guide, the course will restart.
		.' Finish the course |q 30145/1
	step
		goto 58.6,43.7
		.talk Instructor Windblade##58420
		..turnin Flight Training: Full Speed Ahead##30145
		..accept Flight Training: In Due Course##30187
	step
		'The color of Cloud Serpent depends on your egg color choice when you unlocked the dailies for this faction.
		.clicknpc Golden Cloud Serpent##58429
		.clicknpc Azure Cloud Serpent##58441
		.clicknpc Jade Cloud Serpent##58442
		.' Ride your Cloud Serpent |invehicle |c
		|only if havequest(30187)
	step
		path	strict; curved; loop
		path	60.6,39.4	59.7,31.5	61.3,25.2
		path	66.3,36.0	66.2,42.4	66.8,51.4
		path	64.0,51.0	60.4,52.9	61.8,54.5
		path	58.7,46.8	58.4,46.4
		'Follow this path and collect the checked flags hanging off of the Checkpoint balloons. As you fly, gain speed by flying through cloud rings
		.' Pass 10 Checkpoints |q 30187/1
	step
		goto 58.6,43.7
		.talk Instructor Windblade##58420
		..turnin Flight Training: In Due Course##30187
		|next "end"
	step
	label exalted
		goto 57.6,45.0
		.talk Elder Anli##58564
		..accept Riding the Skies##31811
	step
		'Watch the cinematic
		.' Join the Order of the Cloud Serpent |q 31811/1
	step
		goto 57.6,45.0
		.talk Elder Anli##58564
		..turnin Riding the Skies##31811
	step
		Proceeding to the next step |next end |only if default
		Proceeding to Riding the Skies Quest |next exalted |only if rep('Order of the Cloud Serpent')==Exalted
	step
	label	exalted
		goto 57.7,44.9
		.talk Elder Anli##58564
		..accept Riding the Skies##31810
	step
		goto 57.7,44.9
		.talk Elder Anli##58564
		..turnin Riding the Skies##31810
	step
	label end
		'This the end of our daily guide.
		.' Click here to go back to the beginning |confirm |next start
]])

ZygorGuidesViewer:RegisterInclude("Sunreavers_dailies",[[
	label "start"
		'Proceeding to the Sunreavers Dailies |next "dailies" |only if default
		'Moving to the Sunreavers prequests. |next |only if not completedq(32680) and thunderstage()==1
		'Moving to the First Scenario |next "scenario1" |only if thunderstage()>=2 and not completedq(32212)
		'Moving to the Second Scenario |next "scenario2" |only if thunderstage()>=3 and not completedq(32276)
		'Moving to the Third Scenario |next "scenario3" |only if thunderstage()>=4 and not completedq(32277)
		'Moving to the Fourth Scenario |next "scenario4" |only if thunderstage()>=5 and not completedq(32278)
		'Moving to the Fifth Scenario |next "post5" |only if thunderstage()>5 and not completedq(32279)
//PREQUEST
	step
	label "prequest"
		goto Vale of Eternal Blossoms 62.9,28.3
		.talk Sunwalker Dezco##64566
		..accept Thunder Calls##32678
	step
		goto Townlong Steppes 50.8,73.4
		.talk Scout Captain Elsia##70358
		..turnin Thunder Calls##32678
		..accept The Storm Gathers##32680
	step
		goto Townlong Steppes 50.8,73.4
		.talk Scout Captain Elsia##70358
		.' Tell her you're ready to go. |q 32680/1
		.' Discover the Isle of Thunder |q 32680/2
	step
		goto Isle of Thunder 28.4,52.4
		.talk Lor'themar Theron##67990
		..turnin The Storm Gathers##32680
		|next "start"
////SCENARIO
	step
	label "scenario1"
		goto Isle of Thunder 28.4,52.3
		.talk Lor'themar Theron##67990
		..accept The Assault on Zeb'tula##32212
		.' Enter the Scenario _Assault on Zeb'tula_. |goto 933 |noway|c
	step
		goto Isle of Thunder 28.4,52.3
		.talk Lor'themar Theron##67990
		.' Tell him you're ready to go. |q 32212/1
	step
		goto 933 28.5,52.3
		.clicknpc Sunreaver Bloodhawk##69487
		.' Ride the Sunreaver Bloodhawk.
		scenariogoal 22673
	step
		scenariogoal 22654
	step
		scenariostage 1
	step
		goto 933 42.7,50.5
		.from Zeb'tula Raptor##69658+, from Zeb'tula Beastcaller##69657+
		|scenariogoal 22655
	step
		scenariostage 2
	step
		goto 933 39.0,43.9
		.from Zeb'tula Stoneshield##69517+
		.from Zandalari Barricade##69516+
		.from Zeb'tula Spearanger##69518+
		scenariogoal 22656
	step
		scenariostage 3
	step
		goto 933 38.8,38.7
		.from Kresh the Ripper##69474
		scenariogoal 22657
	step
		scenariostage 4
	step
		goto 933 32.8,35.2
		.from Arcanital Tula'chek##69475
		.' While fighting Arcanital Tula'chek, the mask puts down yellow protection fields.
		.' Position yourself so that you are IN the yellow field, while Tula'chek is OUT of the field.
		scenariogoal 22659
		scenariogoal 22660
	step
		scenariostage 5
	step
		goto Isle of Thunder 32.5,35.5
		.talk Lor'themar Theron##67990
		..turnin The Assault on Zeb'tula##32212
		|next "start"
////SCENARIO2
	step
	label "scenario2"
		goto Isle of Thunder 32.6,35.5
		.talk Lor'themar Theron##67990
		..accept Tear Down This Wall!##32276
	step
		goto Isle of Thunder 32.6,35.5
		.talk Lor'themar Theron##67990
		.' Tell him you're ready to tear down the wall! |q 32276/1
		.' Enter the Scenario. |goto 933 |noway|c
	step
		goto 933 48.4,51.1
		.click Heavy Explosives
		.collect Heavy Explosives##93962
		scenariogoal
	step
		scenariostage 1
	step
		goto 933 55.8,57.9
		.talk Scout Captain Elsia##69565
		.' Tell her you have the explosives for her.
		scenariogoal 22700
	step
		scenariostage 2
	step
		goto 933 56.2,56.2
		.click Heavy Explosives
		.' Light the fuse on the explosives to detonate them.
		scenariogoal 22702
	step
		scenariostage 3
	step
		goto 933 54.7,45.9
		.from War-God Al'chukla##69755+
		scenariogoal 23004
	step
		scenariostage 4
	step
		goto 933 54.1,46.2 |n
		.' Click the Portal to Isle of Thunder |goto Isle of Thunder 33.2,32.4 |noway |c
	step
		goto Isle of Thunder 32.6,35.5
		.talk Lor'themar Theron##67990
		..turnin Tear Down This Wall!##32276
		|next "start"
////SCENARIO3
	step
	label "scenario3"
		goto Isle of Thunder 32.6,35.6
		.talk Lor'themar Theron##67990
		..accept To the Skies!##32277
	step
		goto Isle of Thunder 32.6,35.6
		.talk Lor'themar Theron##67990
		.' Tell him you're ready to go! |q 32277/1
		.' Enter the To the Skies scenario! |goto 933 |noway|c
	step
		goto 933 32.3,34.4
		.clicknpc Thunderwing##69509
		scenariogoal 22666
		scenariogoal 22667
	step
		scenariostage 1
	step
		'Use the Jump! ability on your toolbar to fight the Zandalari Attackers |tip After you defeat the first one, you will automatically jump to each other one until this stage is complete.
		.from Zandalari Beastcaller##69521+
		scenariogoal 22668
	step
		scenariostage 2
	step
		goto 933 48.7,25.5
		.from Beastmaster Horaki##69559+
		scenariogoal 22669
	step
		scenariostage 3
	step
		goto 933 49.3,26.0
		.talk Taoshi##69810
		.' Tell her lets go.
		scenariogoal 22738
	step
		scenariostage 4
	step
		goto 933 48.8,25.6
		.' Wait here while Taoshi sets up the bomb.
		scenariogoal 22740
	step
		goto 933/0 49.3,25.6 |n
		.' Enter the cave here |goto 933/1 |noway |c
	step
		goto 933/1 32.9,57.9
		scenariogoal 22741
	step
		scenariostage 5
	step
		goto 933/1 31.4,71.3
		.from Slavemaster Shiaxu##69923+ |scenariogoal 22672
		scenariogoal 22672
	step
		scenariostage 6
	step
		goto 933/1 31.4,77.2 |n
		.' Click the portal to the Isle of Thunder |goto Isle of Thunder/0 33.3,32.4 |noway |c
	step
		goto Isle of Thunder/0 32.5,35.5
		.talk Lor'themar Theron##67990
		..turnin To the Skies!##32277
		|next "start"
////SCENARIO4
	step
	label "scenario4"
		goto Isle of Thunder/0 32.9,32.7
		.talk Taoshi##70297
		..accept Decisive Action##32278
	step
		goto Isle of Thunder/0 32.9,32.7
		.talk Taoshi##70297
		.' Tell her you're with her!
		.' You will queue for the solo scenario, click accept when the box pups up on your screen. |goto 933 62.5,54.6 |noway |c
	step
		goto 933/0 63.2,54.4
		.clicknpc Thunderwing##69458
		scenariogoal 22661
	step
		scenariostage 1
	step
		.' Use the _Smoke Bomb_ ability on your hotbar to cloud the vision of the Zandalari patrols.
		scenariogoal 23007
	step
		scenariostage 2
	step
		.' Follow _Taoshi_ around the ship and sneak up behind the _Veteran Wingriders_ she marks for you.
		.' When the enemies are inside your red circle, use the _Knock Out_ ability that pops up on your screen.
		scenariogoal 23003
		scenariogoal 22663
		|modelnpc Veteran Wingrider##69552
	step
		scenariostage 3
	step
		goto 933/0 67.2,47.3
		.from Captain Halu'kal##69482+ |tip He's on the lower deck of the ship.
		scenariogoal 22664
	step
		scenariostage 4
	step
		 goto 933/0 59.4,44.2
		.' Sneak your way around the totems and guards to Hu'seng the Gatekeeper.
		scenariogoal 22665
	step
		scenariostage 5
	step
		goto 933/0 59.1,44.1
		.from Hu'seng the Gatekeeper##69483+ |scenariogoal 22667
		.collect 1 Gatekeeper's Orb##94918 |scenariogoal 22810
	step
		scenariostage 6
	step
		goto 933/0 58.4,42.8
		.click Deactivated Access Generator
		scenariogoal 22809
	step
		scenariostage 7
	step
		goto Isle of Thunder/0 57.8,41.9 |n
		.' Click the Portal to Dawnseeker Promontory |goto Isle of Thunder/0 33.3,32.4 |noway |c
	step
		goto Isle of Thunder/0 32.5,35.5
		.talk Lor'themar Theron##67990
		..turnin Decisive Action##32278
		|next "start"
//SCENARIO5
	step
	label post5
		goto Isle of Thunder/0 32.6,35.5
		.talk Lor'themar Theron##67990
		..accept The Fall of Shan Bu##32279
	step
		goto Isle of Thunder/0 32.6,35.5
		.talk Lor'themar Theron##67990
		.' Tell him that you are ready to launch the asault.
		.' Speak to Lor'themar Theron |q 32279/1
		.' Enter the scenario. |goto 933|noway|c
	step
		goto Isle of Thunder/0 56.1,39.1
		.talk Scout Captain Elsia##69620
		.' Tell her you are ready to go. |scenariogoal 22742
	step
		goto Isle of Thunder/0 57.7,41.3
		.' Enter the courtyard. |scenariogoal 22799
	step
		goto 933 57.5,40.8
		.from Zandalari Stoneshield##69527 
		|scenariogoal 22675
	step
		scenariostage 1
	step
		goto 933 57.9,40.8
		.from Palace Gatekeeper##69510+ 
		|scenariogoal 22685
	step
		scenariostage 2
	step
		goto 933 59.8,38.0
		.from Quilen Guardian##69506+, Shan'ze Electrocutioner##69525+, Zandalari Stoneshield##69865+ 
		|scenariogoal 22734
	step
		scenariostage 3
	step
		goto 933 60.0,37.8
		.from Shan Bu##69534
		|scenariogoal 22683
	step
		scenariostage 4
	step
		goto 933 57.9,40.9
		.' Follow Taran Zhu to this spot and watch the conflict.
		|confirm
		|modelnpc Taran Zhu##69501+
	step
		goto 933 56.9,40.5 |n
		.' Click the portal to the Isle of Thunder |goto Isle of Thunder/0 33.2,32.4 |noway |c
	step
		goto Isle of Thunder/0 32.5,35.5
		.talk Lor'themar Theron##67990
		..turnin The Fall of Shan Bu##32279
		|next "start"
//DAILIES
	step
	label "dailies"
		goto Isle of Thunder 28.4,52.3
		.talk Lor'themar Theron##67990
		..accept Za'Tual##32729
		|only if thunderstage()==1
	step
		goto Isle of Thunder 28.4,52.4
		.talk Girana the Blooded##67673
		..accept The Court of Bones##32728
		|only if thunderstage()==1
	step
		goto Isle of Thunder 28.6,52.4
		.talk Magister Hathorel##67663
		..accept Ihgaluk Crag##32730
		|only if thunderstage()==1
	step
		goto Isle of Thunder 32.5,35.3
		.clicknpc Assignment Map##70567
		..'Click PvE at the assignment screen. |questchoice 21 54 -- PvE
		|only if thunderstage()>=2
	step
		goto Isle of Thunder 32.5,35.2
		.talk Magister Hathorel##67663
		..accept Ihgaluk Crag##32730 
		..accept A Wing to Fly On##32506 |only if thunderstage()>=2
		|noquest
		|only if thunderstage()>=2 and completedq(32212)
	step
		goto Isle of Thunder 32.5,35.2
		.talk Girana the Blooded##67673
		..accept The Court of Bones##32728 |or 2
		..accept The Zandalari Colossus##32230 |or 2
		..accept The Shuddering Moor##32228 |or 2 |only if thunderstage()>=2
		|noquest
		|only if thunderstage()>=2 and completedq(32212)
	step
		goto Isle of Thunder 32.6,35.5
		.talk Lor'themar Theron##67990
		..accept Za'Tual##32729
		..accept Encroaching Force##32521
		|only if thunderstage()>=2  and completedq(32212)
		|noquest
	step
		goto Isle of Thunder 33.5,35.1
		.talk High Arcanist Savor##67662
		..accept The Sleepless Legion##32285 |or
		..accept Enemies Beneath the Tower##32287 |or
		|noquest
		|only if thunderstage()>=2
		|next "dailies2"
////COURT OF BONES
	step
	label "dailies2"
		'Routing to the next section |next "zatual" |only if thunderstage()>=2 and not havequest(32728) and not completedq(32728)
		'Routing to the next section |next |only if default
	step
		goto Isle of Thunder 33.1,52.7
		.talk Grand Magister Rommath##67989
		..turnin The Court of Bones##32728 |only if havequest(32728)
		..accept Grave Circumstances##32201 |only if havequest(32728) or completedq(32728)
		..accept The Call of Thunder##32225 |only if havequest(32728) or completedq(32728)
		|noquest
		|only if thunderstage()==1
	step
		goto Isle of Thunder 32.9,52.6
		.talk Ryshelle Brightlock##69389
		..accept Stone Cold##32219
		..accept Into the Crypts##32226
		..accept Rise No More!##32224
		..accept The Conquest of Stone##32517
		|noquest
		|only if thunderstage()==1
	step
		goto Isle of Thunder 33.1,53.0
		.talk Captain Aerthas Firehawk##67983
		..accept Ashes of the Enemy##32218 |or
		..accept Soul Surrender##32220 |or
		|only if thunderstage()==1
	step
		goto Isle of Thunder 38.5,51.3
		.talk Grand Magister Rommath##67989
		..turnin The Court of Bones##32728
		..accept Grave Circumstances##32201
		..accept The Bloodletter##32495
		..accept The Call of Thunder##32225
		|noquest
		|only if thunderstage()>=2 and completedq(32212)
	step
		goto Isle of Thunder 38.5,51.2
		.talk Ryshelle Brightlock##69389
		..accept Stone Cold##32219
		..accept Rise No More!##32224
		..accept Into the Crypts##32226
		..accept The Conquest of Stone##32517
		|noquest
		|only if thunderstage()>=2 and completedq(32212)
	step
		goto Isle of Thunder 38.5,51.1
		.talk Captain Aerthas Firehawk##67983
		..accept Soul Surrender##32220 |or
		..accept Ashes of the Enemy##32218 |or
		|noquest
		|only if thunderstage()>=2 and completedq(32212)
	step
		goto Isle of Thunder 35.0,48.2
		.from Kaida the Bloodletter##69250 |q 32495/1
		|only if havequest(32495)
	step
		goto Isle of Thunder 35.1,64.3
		.' Kill the Shan'ze Soulrippers surrounding the Ancient Stone Conqueror in this room.
		.' Stop the Ancient Stone Conqueror ritual |q 32517/1
		|modelnpc Shan'ze Soulripper##69903+
		|only if havequest(32517)
	step
		goto Isle of Thunder 32.9,55.9
		' Kill the _Shan'ze Thundercallers_ around the Lightning Rod to stop the ritual. |q 32225/1
		|modelnpc Shan'ze Thundercaller##69264+
		|only if havequest(32225)
	step
		goto Isle of Thunder 36.1,51.8
		.click Tormented Cage
		.' Save 6 Scouts |q 32220/1
		|modelnpc Sunreaver Scout##69305
		|modelnpc Silver Covenant Scout##69267
		|only if havequest(32220)
	step
		goto Isle of Thunder 35.5,52.3
		.from Shan'ze Gravekeeper##69235+, Shan'ze Thundercaller##69264+ |q 32201/1 |only if havequest(32201) |tip The Thundercallers will cast Chain Lightning which places a circular spell under your character that you will need to move out of to avoid heavy damage.
		.from Risen Ancestor##69237+ |q 32224/1 |only if havequest(32224)
		.from Grave Guardian##69240+ |q 32219/1 |only if havequest(32219)
		.' Use your Blessed Torch on Mummified Remains |use Blessed Torch##93751 |tip They're laying in coffins scattered around this area. |q 32218/1 |only if havequest(32218)
		|modelnpc Mummified Remains##69337 |only if havequest(32218)
		|only if havequest(32219) or havequest(32218) or havequest(32201) or havequest(32224)
	step
		goto Isle of Thunder 36.3,58.8 
		goto zone Hall of the Exalted
		.' Enter the Hall of the Exalted here |goto Isle of Thunder 36.3,58.8 |noway |c
		|only if havequest(32226)
	step
		goto Isle of Thunder 36.8,56.5 |subzone Hall of the Exalted
		.' Use the Incantation of Gura in your bags to summon Gura |use Incantation of Gura##93803
		.from Gura the Reclaimed##69241+ |q 32226/1
		|only if havequest(32226)
////ZA'TUAL
	step
	label "zatual"
		'Routing to the next section |next "crag" |only if thunderstage()>=4 and not havequest(32729) and not completedq(32729)
		'Routing to the next section |next |only if default
	step
		goto Isle of Thunder 36.8,64.8
		.talk Halduron Brightwing##70520
		..turnin Za'Tual##32729
		..accept Surgical Death##32275
		..accept Harbingers of the Loa##32252
		..accept Dangers of Za'Tual##32200
		|noquest
		|only if thunderstage()>=1 and havequest(32729) or completedq(32729)
	step
		goto Isle of Thunder 36.7,64.7
		.talk Elina Zaralae##69418
		..accept Dark Offerings##32217
		..accept Heinous Sacrifice##32215
		|noquest
		|only if thunderstage()>=1 and completedq(32729)
	step
		goto Isle of Thunder 36.8,64.9
		.talk Kethiel Sunlance##67984
		..accept Pterrible Ptorment##32216
		..accept Preventing a Future Threat##32227
		|noquest
		|only if thunderstage()>=1 and completedq(32729)
	step
		goto Isle of Thunder 41.3,69.9
		.from Zandalari Arcweaver##69224+
		..' Free the Tormented Skyscreamer |q 32216/1
		|only if havequest(32216)
	step
		goto Isle of Thunder/0 28.0,77.2
		.' Run over _Hatchling Skyscreamers_ in this area to scare them. 
		.' Scare 12 Hatchling Skyscreamers |q 32227/1
		|modelnpc Hatchling Skyscreamer##69128
		|only if havequest(32227)
	step
		goto Isle of Thunder 39.8,65.3
		.from Spiritbinder Tec'uat##69255 |only if havequest(32275)
		.click Tec'uat's Altar
		.' Destroy Tec'uat's Altar |q 32215/2
		|only if havequest(32215)
	step
		goto Isle of Thunder 38.7,78.6
		.from Spiritbinder Pa'chek##69256 |only if havequest(32275)
		.click Pa'chek's Altar
		.' Destroy Pa'chek's Altar |q 32215/3
		|only if havequest(32215)
	step
		goto Isle of Thunder 33.9,76.2
		.from Spiritbinder Cha'lat##69254 |only if havequest(32275)
		.click Cha'lat's Altar
		.' Destroy Cha'lat's Altar |q 32215/1
		|only if havequest(32215)
	step
		goto Isle of Thunder 35.4,68.0
		.click Zandalari Offering
		.' Destroy 6 Zandalari Offerings |q 32217/1
		|only if havequest(32217)
	step
		goto Isle of Thunder 36.4,70.0
		.from Zandalari Arcanital##69281+, Zandalari Speaker##69136+ |q 32252/1
		.' You can either wait here _(the respawn rate is high for these mobs)_, or find another at [38.9,76.4]
		|only if havequest(32252)
	step
		goto Isle of Thunder 31.3,69.9
		.from Zandalari Jaguar Warrior##69171+ |q 32275/2
		.from Zandalari Beastcaller##69065+ |q 32275/1
		.from Zandalari Spiritbinder## |q 32275/3
		|only if havequest(32275)
	step
		goto Isle of Thunder 31.3,69.9
		.from Zandalari Stoneshield##69223+, Zandalari Commoner##69170+, Zandalari Beastcaller##69065+, Zandalari Jaguar Warrior##69171+ |q 32200/1
		|only if havequest(32200)
////IHGALUK CRAG
	step
	label "crag"
		'Routing to the next section |next "dire" |only if thunderstage()>=2 and not havequest(32730) and not completedq(32730)
		'Routing to the next section |next |only if default
	step
		goto Isle of Thunder 46.9,66.9
		.talk Archmage Aethas Sunreaver##67660
		..turnin Ihgaluk Crag##32730
		..accept The Skumblade Threat##32204 |or 2
		..accept Manipulating the Saurok##32254 |or 2
		..accept Subtle Encouragement##32605 |or 2
		..accept De-Constructed##32255 |or 2
		|noquest
	step
		goto Isle of Thunder 46.8,66.8
		.talk Sunwalker Dezco##69425
		..accept The Residents of Ihgaluk##32274
		|noquest
	step
		goto Isle of Thunder 47.0,66.7
		.talk Amalia Penshire##69371
		..accept Just Some Light Clean-Up Work##32299 |or 2
		..accept The Creeping Carpet of Ihgaluk##32489 |or 2
		..accept Left to Rot##32491 |or 2
		|noquest
	step
		goto Isle of Thunder 46.9,66.9
		.talk Archmage Aethas Sunreaver##67660
		..accept Skin of the Saurok##32549 |tip NOTE: This quest will give you the ability to disguise yourself as a saurok. This spell will happen automatically whenever you are outside of combat and inside Ihgaluk Crag. If you try to attack another saurok, the disguise will vanish and all saurok will be hostile to you until you are out of combat again.
		|noquest
		|only if not completedq(32507)
	step
		goto Isle of Thunder 47.2,79.6
		.from Skumblade Filthmonger##69228+, Skumblade Brute##69338+, Skumblade Scavenger##69227+ |q 32549/1
		|only if not completedq(32507) and thunderstage()==1
	step
		.' Click the quest complete box that appears below your minimap.
		..turnin Skin of the Saurok##32549
		|only if not completedq(32507)
	step
		'While going through Ihgaluk Crag:
		.' Anytime you kill a saurok, click the _Plant Mogu Weapon_ icon that appears at the center of your screen.
		|confirm
		|only if havequest(32605)
	step
		goto Isle of Thunder 51.5,78.4
		.from Fetid Meat Pile##69247+
		..' Fetid Meat Pile destroyed |q 32491/1
		|only if havequest(32491)
	step
		goto Isle of Thunder/0 46.6,71.9
		.clicknpc Malfunctioning Sunreaver##69289
		.' Recover Malfunctioning Sunreaver |q 32255/4
		|only if havequest(32255)
	step
		goto Isle of Thunder 44.6,83.3
		.clicknpc Magister Arlan##69293
		.' Speak with Magister Arlan |q 32254/1
		|only if havequest(32254)
	step
		goto Isle of Thunder/0 44.2,81.8
		.clicknpc Disabled Sunreaver Construct##69439
		.' Recover Disabled Construct |q 32255/1
		|only if havequest(32255)
	step
		goto Isle of Thunder 51.7,73.6
		.clicknpc Magistrix Vesara##69310
		.' Speak with Magistrix Vesara |q 32254/3
		|only if havequest(32254)
	step
		map Isle of Thunder/0 
		path follow loose;loop;ants straight 
		path	51.8,74.4	53.3,77.0	54.3,79.3
		path	55.1,82.2	55.1,82.2	55.3,84.2
		path	54.9,86.7	53.9,88.3	52.4,90.4
		path	50.8,90.5	49.2,89.5	49.4,85.8
		path	49.8,84.0	49.4,82.0	49.2,79.8
		path	50.1,78.4	50.4,77.1	50.6,75.8
		.clicknpc Distressed Sunreaver Construct##69290
		.' Recover Distressed Construct |q 32255/3
		|only if havequest(32255)
	step
		goto Isle of Thunder 51.5,85.0
		.clicknpc Magister Sarien##69309
		.' Speak with Magister Sarien |q 32254/2
		|only if havequest(32254)
	step
		goto Isle of Thunder/0 53.6,91.2
		.clicknpc Buried Sunreaver Construct##69288
		.' Recover Buried Construct |q 32255/2
		|only if havequest(32255)
	step
		goto Isle of Thunder 51.5,81.0
		.from Quivering Filth##69251+
		..' Disperse 75 Filth |q 32299/1
		|only if havequest(32299)
	step
		goto Isle of Thunder 50.9,78.9
		.from 1 Skumblade Brute##69338 |q 32274/1
		|only if havequest(32274)
	step
		.' Follow the path up here. |goto Isle of Thunder 50.5,76.8|c
		|only if havequest(32274)
	step
		goto Isle of Thunder 49.8,76.1
		.from 1 Skumblade Saur-Priest##69229 |q 32274/2
		|only if havequest(32274)
	step
		goto Isle of Thunder 56.3,86.4
		.from 1 Skumblade Seadragon##69226+ |q 32274/3
		|only if havequest(32274)
	step
		goto Isle of Thunder 53.9,78.0
		.' Go around Ihgaluk running over any _Ihgaluk Roaches_ you see.
		..' Crush 150 Ihgaluk Roaches |q 32489/1
		|only if havequest(32489)
	step
		goto Isle of Thunder 45.2,74.7
		.from Skumblade Brute##69338+, Skumblade Shortfang##69348+, Skumblade Scavenger##69227+, Skumblade Fleshripper##69210+
		.' Click the _Plant the spear_ ability that appears in the middle of your screen to plant the weapons on their corpses.
		.' Plant 9 Mogu weapons |q 32605/1
		|only if havequest(32605)
	step
		goto Isle of Thunder 45.2,74.7
		.from Skumblade Brute##69338+, Skumblade Shortfang##69348+, Skumblade Scavenger##69227+, Skumblade Fleshripper##69210+ |q 32204/1
		|only if havequest(32204)
	step
	label "dire"
		goto Isle of Thunder 40.8,48.3
		.clicknpc Wild Pterrorwing Hatchling##69428 |tip The hatchling roams around this circular path, some searching may be necessary.
		.' Catch a Wild Pterrorwing Hatchling |q 32506/1
		|only if havequest(32506)
	step
		goto Isle of Thunder/0 42.8,64.0
		.from Zandalari Colossus##69405 |q 32230/1 |tip He patrols around this circular path, some searching may be necessary.
		|only if havequest(32230)
	step
		goto Isle of Thunder/0 53.2,56.3
		.from Mighty Devilsaur##69406 |q 32228/1 |tip He patrols around this circular path, some searching may be necessary.
		|only if havequest(32228)
	step
		 goto Isle of Thunder 43.0,55.2
		.from Animated Warrior##67473+ |q 32285/1
		|only if havequest(32285)
	step
		goto Isle of Thunder/0 47.0,61.4
		.from Shan'ze Bloodseeker##69431+, Shan'ze Animator##70069+ |q 32287/1
		|only if havequest(32287)
////TURNIN
	step
	label "turnin"
		goto Isle of Thunder 47.0,66.8
		.talk Amalia Penshire##69371
		..turnin The Creeping Carpet of Ihgaluk##32489
		..turnin Just Some Light Clean-Up Work##32299
		..turnin Left to Rot##32491
		|only if havequest(32299) or havequest(32489) or havequest(32491)
	step
		goto Isle of Thunder 46.9,66.9
		.talk Archmage Aethas Sunreaver##67660
		..turnin The Skumblade Threat##32204
		..turnin Manipulating the Saurok##32254
		..turnin Subtle Encouragement##32605
		..turnin The Skumblade Threat##32204
		..turnin De-Constructed##32255
		|only if havequest(32489) or havequest(32605) or havequest(32254) or havequest(32255) or havequest(32204)
	step
		goto Isle of Thunder 46.8,66.7
		.talk Sunwalker Dezco##69425
		..turnin The Residents of Ihgaluk##32274
		|only if havequest(32274)
	step
		goto Isle of Thunder 36.7,64.7
		.talk Elina Zaralae##69418
		..turnin Dark Offerings##32217
		..turnin Heinous Sacrifice##32215
		|only if havequest(32217) or havequest(32215)
	step
		goto Isle of Thunder 36.8,64.9
		.talk Kethiel Sunlance##67984
		..turnin Pterrible Ptorment##32216
		..turnin Preventing a Future Threat##32227
		|only if havequest(32216) or havequest(32227)
	step
		goto Isle of Thunder 36.8,64.8
		.talk Halduron Brightwing##70520
		..turnin Harbingers of the Loa##32252
		..turnin Surgical Death##32275
		..turnin Dangers of the Za'Tual##32200
		..accept Encroaching Force##32521
		..accept The Beast Pens##32523
		..accept The Beating of Troll Drums##32524
		..accept Among the Bones##32293
		..accept Imposing Threat##32522
		|only if havequest(32252) or havequest(32275) or havequest(32200) or completedq(32252) or completedq(32275) or completedq(32200)
		|noquest
	step
		goto Isle of Thunder 38.5,51.2
		.talk Ryshelle Brightlock##69389
		..turnin Stone Cold##32219
		..turnin Rise No More!##32224
		..turnin Into the Crypts##32226
		..turnin The Conquest of Stone##32517
		|only if thunderstage()>=2 and completedq(32212)
	step
		goto Isle of Thunder 38.6,51.1
		.talk Captain Aerthas Firehawk##67983
		..turnin Ashes of the Enemy##32218
	step
		goto Isle of Thunder 38.5,51.3
		.talk Grand Magister Rommath##67989
		..turnin Grave Circumstances##32201
		..turnin The Bloodletter##32495
		..turnin Soul Surrender##32220
		..turnin The Call of Thunder##32225
		..accept Encroaching Force##32521 |or 
		..accept Competing Magic##32520 |or 
		..accept Imposing Threat##32522 |or 
		..accept The Beating of Troll Drums##32524 |or 
		..accept The Beast Pens##32523 |or 
		..accept Among the Bones##32293 |or 
		|noquest
		|only if thunderstage()>=2 and completedq(32212) and havequest(32201) or thunderstage()>=2 and completedq(32212) and completedq(32201)
	step
		goto Isle of Thunder 32.9,52.6
		.talk Ryshelle Brightlock##69389
		..turnin The Conquest of Stone##32517
		..turnin Into the Crypts##32226
		..turnin Stone Cold##32219
		..turnin Rise No More!##32224
		|only if thunderstage()==1
	step
		goto Isle of Thunder 33.1,53.0
		.talk Captain Aerthas Firehawk##67983
		..turnin Ashes of the Enemy##32218
		|only if thunderstage()==1
	step
		goto Isle of Thunder 33.0,52.8
		.talk Grand Magister Rommath##67989
		..turnin Grave Circumstances##32201
		..turnin Soul Surrender##32220
		..turnin The Call of Thunder##32225
		..accept Competing Magic##32561 |or
		..accept Imposing Threat##32562 |or
		|noquest
		|only if thunderstage()==1
	step
		goto Isle of Thunder/0 32.6,35.5
		.talk Lor'themar Theron##67990
		..accept Encroaching Force##32521 
		..accept Competing Magic##32520 
		..accept Imposing Threat##32522
		..accept The Beating of Troll Drums##32524 
		..accept The Beast Pens##32523 
		..accept Among the Bones##32293
		|noquest
		|only if thunderstage()>=2 and completedq(32212) and not havequest(32201) and not completedq(32201)
	step
		goto Isle of Thunder/0 45.7,59.5
		..kill 1 Horgak the Enslaver##70176 |q 32562/1 |only if havequest(32562)
		..kill 1 Horgak the Enslaver##70176 |q 32522/1 |only if havequest(32522)
		|only if havequest(32562) or havequest(32522)
	step
		goto Isle of Thunder 44.2,68.7
		.from Arcweaver Jor'guva##69665 |q 32561/1 |only if havequest(32561)
		.from Arcweaver Jor'guva##69665 |q 32520/1 |only if havequest(32520)
		|only if havequest(32561) or havequest(32520)
	step
		goto Isle of Thunder 44.2,68.7
		.from Arcweaver Jor'guva##69665+ |q 32520/1
		|only if havequest(32520)
	step
		goto Isle of Thunder 33.0,52.6
		.click Orb of Translocation##7161
		.' Teleport to the Crimson Treader |goto Isle of Thunder 28.5,51.6 |noway |c
		|only if havequest(32561)
	step
		goto Isle of Thunder/0 45.1,35.6
		.from Nurkala##69663 |q 32521/1
		|only if havequest(32521)
	step
		goto Isle of Thunder/0 41.9,79.4
		..kill Zur'chaka the Bonecrafter##69666 |q 32293/1
		|only if havequest(32293)
	step
		goto Isle of Thunder 28.4,52.4
		.talk Lor'themar Theron##67990
		..turnin Competing Magic##32561
		..turnin Encroaching Force##32521
		..turnin Imposing Threat##32562 
		|only if havequest(32561) or havequest(32521) or havequest(32562)
		|only if thunderstage()==1
	step
		goto Isle of Thunder 32.6,35.5
		.talk Lor'themar Theron##67990
		..turnin Za'Tual##32729
		..turnin Encroaching Force##32521
		..turnin Competing Magic##32520
		..turnin Imposing Threat##32562 
		..turnin Imposing Threat##32522
		|only if thunderstage()>=2  and completedq(32212) or havequest(32729) or havequest(32521) or havequest(32520) or havequest(32562)
	step
		goto Isle of Thunder 32.6,33.0
		.talk Archmage Aethas Sunreaver##67660
		..turnin Subtle Encouragement##32605
		..accept De-Constructed##32255
		..accept The Skumblade Threat##32204
		|noquest
		|only if havequest(32605) or havequest(32204) or havequest(32255)
	step
		goto Isle of Thunder 33.7,33.7
		.talk Grand Magister Rommath##67989
		..turnin Grave Circumstances##32201 |only if havequest(32201)
		..turnin The Call of Thunder##32225 |only if havequest(32225)
		..turnin Soul Surrender##32220 |only if havequest(32220)
		|only if havequest(32201) or havequest(32225) or havequest(32220)
	step
		goto Isle of Thunder 33.7,33.7
		.talk Ryshelle Brightlock##69389
		..turnin Rise No More!##32224 |only if havequest(32224)
		..turnin The Conquest of Stone##32517 |only if havequest(32517)
		..turnin Stone Cold##32219 |only if havequest(32219)
		|only if havequest(32224) or havequest(32517) or havequest(32219)
	step
		goto Isle of Thunder 33.6,33.9
		.talk Captain Aerthas Firehawk##67983
		..turnin Ashes of the Enemy##32218
		|only if havequest(32218)
	step
		goto Isle of Thunder 32.5,35.2
		.talk Girana the Blooded##67673
		..turnin The Zandalari Colossus##32230
		..turnin The Shuddering Moor##32228
		|only if havequest(32230) or havequest(32228) or completedq(32230) or completedq(32228)
	step
		goto Isle of Thunder 32.5,35.2
		.talk Magister Hathorel##67663
		..turnin A Wing to Fly On##32506
		|only if havequest(32506)
	step
		goto Isle of Thunder 33.5,35.1
		.talk High Arcanist Savor##67662
		..turnin The Sleepless Legion##32285
		..turnin Enemies Beneath the Tower##32287
		|only if havequest(32285) or havequest(32287)
	step
		goto Isle of Thunder 32.5,35.5
		.talk Elina Zaralae##69418
		..turnin Heinous Sacrifice##32215
		..turnin Dark Offerings##32217
		|only if havequest(32215) or havequest(32217)
	step
		goto Isle of Thunder/0 32.5,35.6
		.talk Kethiel Sunlance##67984
		..turnin Preventing a Future Threat##32227
		|only if havequest(32227)
	step
		goto Isle of Thunder 32.5,35.6
		.talk Lor'themar Theron##67990
		..accept Encroaching Force##32521 |or 2
		..accept Competing Magic##32520 |or 2
		..accept Imposing Threat##32522 |or 2
		..accept The Beating of Troll Drums##32524 |or 2
		..accept The Beast Pens##32523 |or 2
		..accept Among the Bones##32293
		|noquest
		|only if completedq(32227) or completedq(32217) or completedq(32215) or completedq(32285) or completedq(32287)
	step
		goto Isle of Thunder 44.2,68.7
		.from Arcweaver Jor'guva##69665 |q 32561/1 |only if havequest(32561)
		.from Arcweaver Jor'guva##69665 |q 32520/1 |only if havequest(32520)
		|only if havequest(32561) or havequest(32520)
	step
		goto Isle of Thunder 45.0,35.5
		..from Nurkala##69663 |q 32521/1 |only if havequest(32521)
		|only if havequest(32521)
	step
		goto Isle of Thunder/0 45.7,59.5
		..from 1 Horgak the Enslaver##70176 |q 32522/1 |only if havequest(32522)
		|only if havequest(32522)
	step
		goto Isle of Thunder 54.5,45.2
		.from Zur'chaka the Bonecrafter##69666+
		|only if havequest(32294)
	step
		goto Isle of Thunder/0 41.9,79.4
		..kill Zur'chaka the Bonecrafter##69666 |q 32293/1
		|only if havequest(32293)
	step
		goto Isle of Thunder 47.2,40.7
		.talk Scout Captain Elsia##67985
		..turnin Raining Bones##32294
		|only if havequest(32294)
	step
		goto Isle of Thunder 32.5,35.5
		.talk Lor'themar Theron##67990
		..turnin Harbingers of the Loa##32252
		..turnin Dangers of Trolltonshire##32200
		..turnin Among the Bones##32293
		..turnin Surgical Death##32275
		|only if havequest(32252) or havequest(32200) or havequest(32293) or havequest(32275)
	step
		.' Routing to proper section |next "beast" |only if havequest(32523) or completedq(32523)
		.' Routing to proper section |next "terrace" |only if havequest(32524) or completedq(32524)
		.' Routing to proper section |next "end" |only if default

////CONQUEROR'S TERRACE
	step
	label "terrace"
		goto Isle of Thunder 54.0,49.8
		.talk Scout Captain Elsia##67985
		..turnin The Beating of Troll Drums##32524
		..accept Very Disarming##32233
		..accept This Just Won't Do##32206
		..accept What's Inside Counts##32232
		|noquest
		|only if havequest(32524) or completedq(32524)
	step
		goto Isle of Thunder/0 53.9,49.9
		.talk Magister Edien Sunhollow##67986
		..accept Power Play##32494 |or 2
		..accept Knowledge Is Power##32234 |or 2
		..accept They All Fall Down##32493 |or 2
		|noquest
		|only if completedq(32524)
	step
		goto Isle of Thunder/0 56.8,46.3
		.from Arcanital Ra'kul##69300
		..get Mask of the Dark Mystic |q 32494/2
		|only if completedq(32524)
	step
		goto Isle of Thunder/0 59.4,56.6
		.from Spiritbinder Tu'chek##69301
		..collect Mask of the Spirit-Caller##93733 |q 32494/1
		|only if completedq(32524)
	step
		goto Isle of Thunder/0 60.2,54.0
		.from Guardian Tak'u##69336+ |q 32232/1
	step
		goto Isle of Thunder/0 57.1,50.4
		.click Ritual Artifact
		..get 6 Ritual Artifact |q 32234/1
		|only if completedq(32524)
	step
		goto Isle of Thunder/0 55.7,50.7
		.click Loa-Infused Blade
		..collect 7 Loa-Infused Blade##93736 |q 32233/1
		|only if completedq(32524)
	step
		goto Isle of Thunder 55.7,50.7
		.from Zandalari Acolyte##69295+, Zandalari Bloodguard##69294+, Zandalari Haruspex##69297+, Zandalari Soultwister##69296+ |q 32206/1
		.from Spirit-Bound Sentry##69335+
		.' Use your _Resonance Siphon_ on Spirit-Bound Sentries.  |use Resonance Siphon##93806
		.' 5 Zandalari Spirits captured |q 32493/1
		|only if completedq(32524)
	step
		goto Isle of Thunder/0 53.9,49.8
		.talk Scout Captain Elsia##67985
		..turnin This Just Won't Do##32206
		..turnin Very Disarming##32233
		..turnin What's Inside Counts##32232
		|only if completedq(32524)
	step
		goto Isle of Thunder/0 53.9,49.8
		.talk Magister Edien Sunhollow##67986
		..turnin Power Play##32494
		..turnin Knowledge Is Power##32234
		..turnin They All Fall Down##32493
		..accept Save Our Scouts!##32209 |or
		..accept Maximum Capacitor##32208 |or
		|noquest
		|only if completedq(32524)
	step
		goto Isle of Thunder 54.0,49.9
		.talk Scout Captain Elsia##67985
		..accept Raining Bones##32294 |or
		..accept Encroaching Force##32565 |or
		|noquest
	step
		goto Isle of Thunder 54.5,45.3
		.from Zur'chaka the Bonecrafter##69666 |q 32294/1
		|only if havequest(32294)
	step
		goto Isle of Thunder 61.9,61.6
		..kill Nurkala##69663 |q 32565/1
		|only if havequest(32565)
	step
		goto Isle of Thunder 53.9,49.8
		.talk Scout Captain Elsia##67985
		..turnin Raining Bones##32294
		..turnin Encroaching Force##32565
		|next "end" |only if thunderstage()<=3
	step
		goto Isle of Thunder/1 28.0,62.2
		.' Use your Arcane Emancipator on Scout Alaine |use Arcane Emancipator##93761
		.' Scout Alaine rescued |q 32209/3
		|modelnpc Scout Alaine##69357 
		|only if havequest(32209)
	step
		goto Isle of Thunder/1 44.3,54.8
		.' Use your Arcane Emancipator on Scout Elearis |use Arcane Emancipator##93761
		.' Scout Elearis rescued |q 32209/1
		|modelnpc Scout Elearis##69357 
		|only if havequest(32209)
	step
		goto Isle of Thunder/1 54.3,35.2
		.' Use your Arcane Emancipator on Scout Merior |use Arcane Emancipator##93761
		.' Scout Merior rescued |q 32209/2
		|modelnpc Scout Merior##69356 
		|only if havequest(32209)
	step
		goto Isle of Thunder/1 21.0,69.9
		.click Lightning Drill
		.' Destroy the Western Lightning Drill |q 32208/1
		|only if havequest(32208)
	step
		goto Isle of Thunder/1 32.6,37.5
		.click Lightning Drill
		.' Destroy the Central Lightning Drill |q 32208/2
		|only if havequest(32208)
	step
		goto Isle of Thunder/1 62.2,15.4
		.click Lightning Drill
		.' Destroy the Eastern Lightning Drill |q 32208/3
		|only if havequest(32208)
	step
		goto Isle of Thunder/0 54.9,31.3
		.from Metal Lord Mono-Han##69326 |q 32209/4
		|only if havequest(32209)
	step
		goto Isle of Thunder/0 54.9,31.3
		.from Metal Lord Mono-Han##69326+ |q 32208/4
		|only if havequest(32208)
	step
		.' Click the Quest Complete box in the upper left corner of your screen below your minimap.
		..turnin Save Our Scouts!##32209
		..turnin Maximum Capacitor##32208
		..accept Forge Ahead!##32292 |only if thunderstage()>=4
		|noquest
		|next "end" |only if thunderstage()<=4
		|only if completedq(32524) or completedq(32523)
	step
		goto Isle of Thunder/0 57.7,34.0
		.from Itoka##69461+ |q 32292/1
		|only if completedq(32524) or completedq(32523)
	step
		goto Isle of Thunder/0 55.4,38.4
		.from Fleshcrafter Hoku##69435
		..get Mogu Codex Fragment |q 32292/2
		|only if completedq(32524) or completedq(32523)
	step
		goto Isle of Thunder/0 58.7,42.7
		.talk Scout Captain Elsia##70551
		..turnin Forge Ahead!##32292
		|only if completedq(32524) or completedq(32523)
	step
		goto Isle of Thunder/0 58.6,42.7
		.talk Taoshi##69413
		..accept Extended Shore Leave##32676 
		..accept Raiding the Vault##32677
		|noquest
		|only if thunderstage()>=5
	step
		goto Isle of Thunder/2 58.6,66.2
		.from Lu-Shero##69274+
		..collect Hoard-Keeper's Key##95374
		|only if havequest(32677)
	step
		goto 33.2,28.3
		.click Stormy Chest
		.' Choker of Storms |q 32677/1
		|only if havequest(32677)
	step
		goto Isle of Thunder/0 63.8,38.9
		.get Workshop Orders |q 32676/2
		|only if havequest(32676)
		|only if thunderstage()>=5
	step
		goto Isle of Thunder/0 67.7,46.3
		.from Arcweaver Uzan##69272+ |q 32676/1
		|only if havequest(32676)
		|only if thunderstage()>=5
	step
		goto Isle of Thunder/0 32.5,35.5
		.talk Lor'themar Theron##67990
		..turnin Extended Shore Leave##32676
		..turnin Raiding the Vault##32677
		..turnin Competing Magic##32520
		|next "end"
		|only if thunderstage()>=5
////BEAST PENS
	step
	label "beast"
		goto Isle of Thunder/0 47.1,40.7
		.talk Scout Captain Elsia##67985
		.' Find Scout Captain Elsia at the Beast Pens |q 32523/1
		..turnin The Beast Pens##32523
	step
		goto Isle of Thunder/0 47.2,40.8
		.talk Magister Edien Sunhollow##67986
		..accept Saur Loser##32207 
		..accept Direhorn or Devilsaur##32297 
		..accept Loa-saur##32283 
		|noquest
	step
		goto Isle of Thunder/0 47.1,40.7
		.talk Scout Captain Elsia##67985
		..accept Dino Might##32298 |or
		..accept Compy Stomp##32282 |or
		|noquest
//	step
//		goto Isle of Thunder 53.4,42.3
//		.from Zandalari Fetish-Binder##69155+, Master Caller##69286+, Defiant Devilsaur##67477+
	step
		goto 53.6,44.6
		.from Loa Speaker##69302 |q 32283/1
		|only if havequest(32283)
	step
		goto Isle of Thunder/0 49.7,38.8
		.click Saur Fetish##13556 
		.from Zandalari Saurcaller##69154+
		.from Zandalari Fetish-Binder##69155+
		.collect 5 Saur Fetish##93668
		|only if havequest(32298)
	step
		goto Isle of Thunder/0 49.2,40.9
		.' Use your _Saur Fetish_ on any dinosaurs near this spot. |use Saur Fetish##93668 |only if havequest(32298)
		.' Use 5 Saur Fetishes on dinosaurs in the area. |q 32298/1 |only if havequest(32298)
		.from Trained Compy##58071+, Zandalari Fetish-Binder##69155+, Tamed Bladetalon##69180+, Zandalari Beastlord##69144+, Zandalari Fetish-Binder##69155+, Zandalari Saurcaller##69154+, Maturing Raptor##69183+
		.' Kill 10 Beast Pens Trolls |q 32207/1 |only if havequest(32207)
		.' you can find more around [49.4,38.2]
		.kill 5 Raptor |q 32282/1 |only if havequest(32282)
		.' You can find more raptors around [49.6,37.9] |only if havequest(32282)
		.kill 10 Trained Compy |q 32282/2 |only if havequest(32282)
		|modelnpc Trained Compy##58071+
		|modelnpc Maturing Raptor##69183+
		|modelnpc Tamed Bladetalon##69180+
		|only if havequest(32207) or havequest(32298)
	step
		goto Isle of Thunder/0 51.8,32.9
		.' Kill all the _Master Callers_ surrounding the direhorn.
		.' Disrupt the Binding Ritual. |q 32297/1
		|modelnpc Master Caller##69286+
		|only if havequest(32297)
	step
		goto Isle of Thunder/0 47.2,40.6
		.talk Scout Captain Elsia##67985
		..turnin Dino Might##32298
		..turnin Compy Stomp##32282
	step
		goto Isle of Thunder/0 47.3,40.8
		.talk Magister Edien Sunhollow##67986
		..turnin Saur Loser##32207
		..turnin Loa-saur##32283
		..turnin Direhorn or Devilsaur##32297
		..accept Save Our Scouts!##32209 |or
		..accept Maximum Capacitor##32208 |or
		|noquest
		|only if completedq(32523)
	 step
		goto Isle of Thunder 47.2,40.6
		.talk Scout Captain Elsia##67985
		..accept Encroaching Force##32563 
		..accept Zandalari on the Rise##32564 
		|noquest
		|only if completedq(32523)
	step
		goto Isle of Thunder 44.2,68.7
		.from Arcweaver Jor'guva##69665 |q 32564/1
		|only if havequest(32564)
	step
		goto Isle of Thunder 45.3,35.1
		.from Nurkala##69663 |q 32563/1
		|only if havequest(32563)
	 step
		goto Isle of Thunder 47.2,40.6
		.talk Scout Captain Elsia##67985
		..turnin Encroaching Force##32563
		..turnin Zandalari on the Rise##32564 |or
	step
		goto Isle of Thunder/1 28.0,62.2
		.' Use your Arcane Emancipator on Scout Alaine |use Arcane Emancipator##93761
		.' Scout Alaine rescued |q 32209/3
		|modelnpc Scout Alaine##69357 
		|only if havequest(32209)
	step
		goto Isle of Thunder/1 44.3,54.8
		.' Use your Arcane Emancipator on Scout Elearis |use Arcane Emancipator##93761
		.' Scout Elearis rescue |q 32209/1
		|modelnpc Scout Elearis##69357
		|only if havequest(32209)
	step
		goto Isle of Thunder/1 54.3,35.2
		.' Use your Arcane Emancipator on Scout Merior |use Arcane Emancipator##93761
		.' Scout Merior rescued |q 32209/2
		|modelnpc Scout Merior##69356 
		|only if havequest(32209)
	step
		goto Isle of Thunder/1 21.0,69.9
		.click Lightning Drill
		.' Destroy the Western Lightning Drill |q 32208/1
		|only if havequest(32208)
	step
		goto Isle of Thunder/1 32.6,37.5
		.click Lightning Drill
		.' Destroy the Central Lightning Drill |q 32208/2
		|only if havequest(32208)
	step
		goto Isle of Thunder/1 62.2,15.4
		.click Lightning Drill
		.' Destroy the Eastern Lightning Drill |q 32208/3
		|only if havequest(32208)
	step
		goto Isle of Thunder/0 54.9,31.3
		.from Metal Lord Mono-Han##69326 |q 32209/4
		|only if havequest(32209)
	step
		goto Isle of Thunder/0 54.9,31.3
		.from Metal Lord Mono-Han##69326 |q 32208/4
		|only if havequest(32208)
	step
		.' Click the Quest Complete box in the upper left corner of your screen below your minimap.
		..turnin Save Our Scouts!##32209
		..turnin Maximum Capacitor##32208
		..accept Forge Ahead!##32292
		|noquest
		|only if havequest(32209) or completedq(32208) or havequest(32208) or completedq(32209)
	step
		goto Isle of Thunder/0 57.7,34.0
		.from Itoka##69461+ |q 32292/1
		|only if havequest(32292)
	step
		goto Isle of Thunder/0 55.4,38.4
		.from Fleshcrafter Hoku##69435
		..get Mogu Codex Fragment |q 32292/2
		|only if havequest(32292)
	step
		goto Isle of Thunder/0 58.7,42.7
		.talk Scout Captain Elsia##70551
		..turnin Forge Ahead!##32292
		|only if havequest(32292)
		|next "end" |only if thunderstage()<=4
		|next |only if default |only if thunderstage()>=5
	step
		goto Isle of Thunder/0 58.6,42.7
		.talk Taoshi##69413
		..accept Extended Shore Leave##32676 |or
		..accept Raiding the Vault##32677 |or
		|noquest
		|only if thunderstage()>=4
	step
		goto Isle of Thunder/2 58.6,66.2
		.from Lu-Shero##69274+
		..collect Hoard-Keeper's Key##95374
		|only if havequest(32677)
	step
		goto 33.2,28.3
		.click Stormy Chest
		.' Choker of Storms |q 32677/1
		|only if havequest(32677)
	step
		goto Isle of Thunder/0 63.8,38.9
		.get Workshop Orders |q 32676/2
		|only if havequest(32676)
	step
		goto Isle of Thunder/0 67.7,46.3
		.from Arcweaver Uzan##69272+ |q 32676/1
		|only if havequest(32676)
	step
		goto Isle of Thunder/0 32.5,35.5
		.talk Lor'themar Theron##67990
		..turnin Extended Shore Leave##32676
		..turnin Raiding the Vault##32677
		|next "end"
	step
	label "end"
		goto Isle of Thunder/0 33.4,32.4
		.talk Vasarin Redmorn##67672
		..buy 1 Grand Commendation of the Sunreaver Onslaught##95548 |n
		.' Use the Commendation of the Shado-Pan you just purchased. |condition ZGV:GetReputation("Sunreaver Onslaught").hasBonus |use Grand Commendation of the Sunreaver Onslaught##95548
		|only if rep("Sunreaver Onslaught")>=Revered
	step
		'You have reached the end of the dailies for today.
		.' Click here to go back to the beginning of the guide. |confirm |next "start"
]])

ZygorGuidesViewer:RegisterInclude("H_Beasts_of_Fable_D",[[
		goto Vale of Eternal Blossoms 60.8,23.7
		.talk Gentle San##64582
		..accept Beasts of Fable Book I##32604
		..accept Beasts of Fable Book II##32868
		..accept Beasts of Fable Book III##32869
	step
		goto Vale of Eternal Blossoms 11.0,70.9
		.' _No-No_
		.' This enemy is aquatic.
		.' It is strong against undead and weak to flying attacks.
		.' I would suggest that you use flying pets against this enemy.
		.' No-No defeated |q 32869/2
		'|modelnpc 68559
	step
		goto Valley of the Four Winds 40.5,43.7
		.' _Lucky Yi_
		.' This enemy is a critter.
		.' Is is strong against Elementals and weak to beast attacks.
		.' I would suggest using beast pets against this enemy.
		.' Lucky Yi defeated |q 32868/2
		'|modelnpc 68561
	step
		goto Valley of the Four Winds 25.3,78.5
		.' _Greyhoof_
		.' This enemy is a beast.
		.' It is strong against humanoids and weak against mechanical pets.
		.' I would suggest using a team of mechanical pets against this enemy.
		.' Greyhoof defeated |q 32868/1
		'|modelnpc 68560
	step
		goto Krasarang Wilds 36.3,37.3
		.' _Skitterer Xi'a_
		.' This enemy is aquatic.
		.' It is strong against undead and weak to flying pets.
		.' I would suggest using flying pets against this enemy.
		.' Xi'a defeated |q 32868/3
		'|modelnpc 68566
	step
		goto Dread Wastes 26.1,50.2
		.' _Gorespine_
		.' This enemy is a beast.
		.' It is strong against humanoids and weak against mechanical pets.
		.' I would suggest using a team of mechanical pets against this enemy.
		.' Gorespine defeated |q 32869/1
		'|modelnpc 68558
	step
		goto Townlong Steppes 72.3,79.8
		.' _Ti'un the Wanderer_
		.' This enemy is aquatic.
		.' It is strong against undead and weak to flying pets.
		.' I would suggest using flying pets against this enemy.
		.' Ti'un the Wanderer defeated |q 32869/3
		'|modelnpc 68562
	step
		goto Kun-Lai Summit 35.2,56.2
		.' This enemy is a beast.
		.' It is strong against humanoids and weak against mechanical pets.
		.' I would suggest using a team of mechanical pets against this enemy.
		.' Kafi defeated |q 32604/2
		'|modelnpc 68563
	step
		goto Kun-Lai Summit 67.9,84.7
		.' _Dos-Ryga_
		.' This enemy is aquatic.
		.' It is strong against undead and weak to flying pets.
		.' I would suggest using flying pets against this enemy.
		.' Dos-Ryga defeated |q 32604/3
		'|modelnpc 68564
	step
		goto The Jade Forest 48.4,71.0
		.' _Ka'wi the Gorger_
		.' This enemy is a beast.
		.' It is strong against humanoids and weak against mechanical pets.
		.' I would suggest using a team of mechanical pets against this enemy.
		.' Ka'wi the Gorger defeated |q 32604/1
		'|modelnpc 68555
	step
		goto The Jade Forest 57.0,29.1
		.' _Nitun_
		.' This enemy is a critter.
		.' Is is strong against Elementals and weak to beast attacks.
		.' I would suggest using beast pets against this enemy.
		.' Nitun defeated |q 32604/4
		'|modelnpc 68565
	step
		goto Vale of Eternal Blossoms 60.8,23.7
		.talk Gentle San##64582
		..turnin Beasts of Fable Book I##32604
		..turnin Beasts of Fable Book II##32868
		..turnin Beasts of Fable Book III##32869
]])

ZygorGuidesViewer:RegisterInclude("H_Cloud_Serpent_Pre",[[
		goto Vale of Eternal Blossoms 60.6,21.7
		.talk Wei Lakebreeze##64533
		..accept The Order of the Cloud Serpent##31375
	step
		goto The Jade Forest 57.8,45.0
		.talk Instructor Skythorn##58228
		..turnin The Order of the Cloud Serpent##31375
	step
		goto 57.7,45.0
		.talk Elder Anli##58564
		..accept Wild Things##30134
	step
		goto 65.3,31.7
		.talk Instructor Tong##58225
		..turnin Wild Things##30134
		..accept Beating the Odds##30135
		..accept Empty Nests##30136
		..accept Egg Collection##30137
	step
		goto 64.4,31.1
		.' Use the Silken Rope in your bags on Windward Hatchlings |use Silken Rope##78947
		.' Get 6 Hatchlings and bring them to [65.8,31.2]
		.' Return 6 Windward Hatchlings to their nests. |q 30136/1
	step
		goto 68.1,31.2
		.from Slitherscale Ripper##58212+, Slitherscale Eggdrinker##63532+
		.' Kill 8 Slitherscale saurok. |q 30135/1
		.click Serpent Egg
		.get 6 Serpent Egg##78959 |q 30137/1
	step
		goto 65.3,31.7
		.talk Instructor Tong##58225
		..turnin Beating the Odds##30135
		..turnin Empty Nests##30136
		..turnin Egg Collection##30137
		..accept Choosing the One##30138
		..turnin Choosing the One##30138
	step
		goto 65.3,31.7
		.talk Instructor Tong##58225 |tip You will only accept one of the following quests.
		..accept The Rider's Journey##30139 |or
		..accept The Rider's Journey##30140 |or
		..accept The Rider's Journey##30141 |or
	step
		goto 57.6,45.1
		.talk Instructor Skythorn##58228 |tip You will only turn in one of the following quests.
		..turnin The Rider's Journey##30139
		..turnin The Rider's Journey##30140
		..turnin The Rider's Journey##30141
		..accept It's A...##30142
	step
		.' Watch the scene and see your egg hatch.
		.' Egg Hatched. |q 30142/1
	step
		goto 57.6,45.1
		.talk Instructor Skythorn##58228
		..turnin It's A...##30142
]])

--------------------------------------------------------------------------------------------------------------------------------------
-- Trainers
--------------------------------------------------------------------------------------------------------------------------------------
ZygorGuidesViewer:RegisterInclude("trainer_Alchemy",[[
		goto Orgrimmar,55.7,45.7
		.talk Yelmak##3347
]])

ZygorGuidesViewer:RegisterInclude("trainer_Archaeology",[[
		goto Orgrimmar 49.0,70.7
		.talk Belloc Brightblade##47571
]])

ZygorGuidesViewer:RegisterInclude("trainer_Blacksmithing",[[
		goto Orgrimmar,44.4,77.3
		.talk Rogg##37072
]])

ZygorGuidesViewer:RegisterInclude("trainer_Blacksmithing_Shatt",[[
		goto Shattrath City,69.4,43.3
		.talk Kradu Grimblade##20124
]])

ZygorGuidesViewer:RegisterInclude("trainer_Mining",[[
		goto Orgrimmar 44.6,78.4
		.talk Gonto##46357
]])

ZygorGuidesViewer:RegisterInclude("trainer_Herbalism",[[
		goto Orgrimmar,54.7,50.5
		.talk Muraga##46741
]])

ZygorGuidesViewer:RegisterInclude("trainer_Inscription",[[
		goto Orgrimmar 55.2,55.7
		.talk Nerog##46716
]])

ZygorGuidesViewer:RegisterInclude("trainer_Engineering",[[
		goto Orgrimmar 56.9,56.4
		.talk Roxxik##11017
]])

ZygorGuidesViewer:RegisterInclude("trainer_Cooking",[[
		goto Orgrimmar 56.3,61.5
		.talk Arugi##46709
]])

ZygorGuidesViewer:RegisterInclude("trainer_Cooking_MoP",[[
		goto Valley of the Four Winds 53.6,51.2
		.talk Sungshin Ironpaw##64231
]])

ZygorGuidesViewer:RegisterInclude("trainer_Tailoring",[[
		goto Orgrimmar,60.8,59.1
		.talk Magar##3363
]])

ZygorGuidesViewer:RegisterInclude("trainer_FirstAid",[[
		goto Orgrimmar 37.1,87.2
		.talk Krenk Choplimb##45540
]])

ZygorGuidesViewer:RegisterInclude("trainer_Fishing",[[
		goto Orgrimmar 66.5,41.5
		.talk Lumak##3332
]])

ZygorGuidesViewer:RegisterInclude("trainer_Enchanting",[[
		goto Orgrimmar 53.4,49.3
		.talk Godan##3345
]])

ZygorGuidesViewer:RegisterInclude("trainer_Skinning",[[
		goto Orgrimmar,61.1,54.8
		.talk Thuwd##7088
]])

ZygorGuidesViewer:RegisterInclude("trainer_Leatherworking",[[
		goto Orgrimmar,60.9,54.9
		.talk Karolek##3365
]])

ZygorGuidesViewer:RegisterInclude("trainer_Mining",[[
		goto Orgrimmar 72.3,35.0
		.talk Makaru##3357
]])

ZygorGuidesViewer:RegisterInclude("trainer_Jewelcrafting",[[
		goto Orgrimmar 72.5,34.5
		.talk Lugrah##46675
]])

ZygorGuidesViewer:RegisterInclude("trainer_HerbalismUC",[[
		goto Undercity,54.0,49.6
		.talk Martha Alliestar##4614
]])

ZygorGuidesViewer:RegisterInclude("trainer_Mining_mop",[[
	goto The Jade Forest/0 27.9,14.9
	.talk Stonebreaker Ruian##66979
]])

ZygorGuidesViewer:RegisterInclude("trainer_Herbalism_mop",[[
	goto The Jade Forest/0 27.8,15.5
	.talk Grower Miao##66980
]])

ZygorGuidesViewer:RegisterInclude("home_Herb_Mine_mop",[[
		goto The Jade Forest/0 28.5,13.3
		.talk Brewmother Kiki##66236
		.home Honeydew Village
]])

--------------------------------------------------------------------------------------------------------------------------------------
-- Supply Vendors
--------------------------------------------------------------------------------------------------------------------------------------
ZygorGuidesViewer:RegisterInclude("vendor_Alchemy",[[
		goto Orgrimmar 55.4,46.1
		.talk Kor'geld##3348
]])

ZygorGuidesViewer:RegisterInclude("vendor_Archaeology",[[
]])

ZygorGuidesViewer:RegisterInclude("vendor_Blacksmithing",[[
		goto Orgrimmar 45.0,77.1
		.talk Punra##46359
]])

ZygorGuidesViewer:RegisterInclude("vendor_Mining",[[
		goto Orgrimmar,72.7,34.8
		.talk Gorina##3358
]])

ZygorGuidesViewer:RegisterInclude("vendor_Herbalism",[[
]])

ZygorGuidesViewer:RegisterInclude("vendor_Inscription",[[
		goto Orgrimmar,55.4,56.0
		.talk Moraka##46718
]])

ZygorGuidesViewer:RegisterInclude("vendor_Engineering",[[
		goto Orgrimmar,56.8,56.4
		.talk Sovik##3413
]])

ZygorGuidesViewer:RegisterInclude("vendor_Cooking",[[
		goto Orgrimmar 56.4,61.3
		.talk Suja##46708
]])

ZygorGuidesViewer:RegisterInclude("vendor_Tailoring",[[
		goto Orgrimmar,60.7,58.7
		.talk Borya##3364
]])

ZygorGuidesViewer:RegisterInclude("vendor_FirstAid",[[
]])

ZygorGuidesViewer:RegisterInclude("vendor_Fishing",[[
]])

ZygorGuidesViewer:RegisterInclude("vendor_Enchanting",[[
		goto Orgrimmar 53.3,48.9
		.talk Kithas##3346
]])

ZygorGuidesViewer:RegisterInclude("vendor_Skinning",[[
		goto Orgrimmar 60.5,54.5
		.talk Tamar##3366
]])

ZygorGuidesViewer:RegisterInclude("vendor_Leatherworking",[[
		goto Orgrimmar,60.3,54.3
		.talk Tamar##3366
]])

ZygorGuidesViewer:RegisterInclude("vendor_Jewelcrafting",[[
		
		goto Orgrimmar 72.4,34.6
		.talk Marith Lazuria##50482
]])
ZygorGuidesViewer:RegisterInclude("vendor_Jewelcrafting_1",[[
		
		goto Orgrimmar 72.4,34.6
		.talk Taryssa Lazuria##57922
]])
ZygorGuidesViewer:RegisterInclude("vendor_Jewelcrafting_MoP",[[
		
		goto The Jade Forest 48.0,35.0
		.talk Mai the Jade Shaper##65098
]])

--------------------------------------------------------------------------------------------------------------------------------------
-- Buying
--------------------------------------------------------------------------------------------------------------------------------------
ZygorGuidesViewer:RegisterInclude("auctioneer",[[
		goto Orgrimmar,54.1,73.3
		.talk Auctioneer Drezmit##44866
]])

ZygorGuidesViewer:RegisterInclude("auctioneer_dalaran",[[
		goto Dalaran,38.8,25.1
		.talk Brassbolt Mechawrench##35594
]])

ZygorGuidesViewer:RegisterInclude("shatt_auctioneer",[[
		goto Shattrath City,51.0,26.5 |only if rep ('The Aldor') >= Neutral
		.talk Auctioneer Itoran##50143 |only if rep ('The Aldor') >= Neutral
		goto Shattrath City,57.0,63.2 |only if rep ('The Scryers') >= Friendly
		.talk Auctioneer Kalaren##50139|only if rep ('The Scryers') >= Friendly
]])

ZygorGuidesViewer:RegisterInclude("goto_shatt_auctioneer",[[
		goto Shattrath City,51.0,26.5 |only if rep ('The Aldor') >= Neutral
		.talk Auctioneer Itoran##50143 |only if rep ('The Aldor') >= Neutral
		goto Shattrath City,57.0,63.2 |only if rep ('The Scryers') >= Friendly
		.talk Auctioneer Kalaren##50139|only if rep ('The Scryers') >= Friendly
]])
--------------------------------------------------------------------------------------------------------------------------------------
-- Anvils
--------------------------------------------------------------------------------------------------------------------------------------
ZygorGuidesViewer:RegisterInclude("maincity_forge",[[
		goto Orgrimmar 75.9,37.3
		.' Stand at this forge
]])

ZygorGuidesViewer:RegisterInclude("maincity_anvil",[[
		goto Orgrimmar 44.7,78.0
		 .' Stand at this Anvil
]])

ZygorGuidesViewer:RegisterInclude("maincity_forge2",[[
		goto Orgrimmar 44.7,78.0
		.' Stand at this forge
]])

ZygorGuidesViewer:RegisterInclude("hellanvil",[[
		goto Hellfire Peninsula,53.3,38.3
		.' Stand in this spot
]])

ZygorGuidesViewer:RegisterInclude("twil_anvil",[[
		goto Twilight Highlands,79.2,76.3
		.' Stand next to this anvil
]])

ZygorGuidesViewer:RegisterInclude("shatt_anvil",[[
		goto Shattrath City 69.4,42.8
		.' Stand next to this Anvil
]])

--------------------------------------------------------------------------------------------------------------------------------------
-- Other
--------------------------------------------------------------------------------------------------------------------------------------
ZygorGuidesViewer:RegisterInclude("cast_campfire",[[
		'Create a basic campfire |cast Basic Campfire##818
]])




--------------------------------------------------------------------------------------------------------------------------------------
-- Mounts
--------------------------------------------------------------------------------------------------------------------------------------

ZygorGuidesViewer:RegisterInclude("basic_mounts",[[
	step
	label "route"
		'Redirecting to Apprentice Riding |next "apprentice" |only if level>=20.0
		'Redirecting to Journeyman Riding |next "journeyman" |only if level>=40.0
		'Redirecting to Expert Riding/Flight Master's License |next "expert" |only if level>=60.0
		'Redirecting to Cold Weather Flying |next "cold" |only if level>=68.0
		'Redirecting to Artisan Riding |next "artisan" |only if level>=70.0
		'Redirecting to Master Riding |next "master" |only if level>=80.0
	step
	label "apprentice"
		goto Orgrimmar 49.0,59.6
		.talk Maztha##44919
		.learn Apprentice Riding##33388
		|only Orc
	step
		goto Orgrimmar 61.6,35.6
		.talk Ogunaro Wolfrunner##3362
		|tip You can pick which one of these mounts you would like to use for your character.
		.buy 1 Horn of the Black Wolf##46099 |or
		.buy 1 Horn of the Brown Wolf##5668 |or
		.buy 1 Horn of the Dire Wolf##5665 |or
		.buy 1 Horn of the Timber Wolf##1132 |or
		|only Orc
		|next "end"
	step
		goto Tirisfal Glades 61.8,51.8
		.talk Velma Warnam##4773
		.learn Apprentice Riding##33388
		|only Undead
	step
		goto Tirisfal Glades 61.8,51.8
		.talk Zachariah Post##4731
		|tip You can pick which one of these mounts you would like to use for your character.
		.buy 1 Black Skeletal Horse##46308 |or
		.buy 1 Blue Skeletal Horse##13332 |or
		.buy 1 Brown Skeletal Horse##13333 |or
		.buy 1 Red Skeletal Horse##13331 |or
		|only Undead
		|next "end"
	step
		goto Mulgore 47.6,58.0
		.talk Kar Stormsinger##3690
		.learn Apprentice Riding##33388
		|only Tauren
	step
		goto Mulgore 47.6,58.0
		.talk Harb Clawhoof##3685
		|tip You can pick which one of these mounts you would like to use for your character.
		.buy 1 White Kodo##46100 |or
		.buy 1 Gray Kodo##15277 |or
		.buy 1 Brown Kodo##15290 |or
		|only Tauren
		|next "end"
	step
		goto Durotar 55.2,75.4
		.talk Xar'Ti##7953
		.learn Apprentice Riding##33388
		|only Troll
	step
		goto Durotar 55.2,75.6
		.talk Zjolnir##7952
		|tip You can pick which one of these mounts you would like to use for your character.
		.buy 1 Whistle of the Emerald Raptor##8588 |or
		.buy 1 Whistle of the Turquoise Raptor##8591 |or
		.buy 1 Whistle of the Violet Raptor##8592 |or
		|only Troll
		|next "end"
	step
		goto Eversong Woods 61.2,54.0
		.talk Perascamin##16280
		.learn Apprentice Riding##33388
		|only Blood Elf
	step
		goto Eversong Woods 61.0,54.6
		.talk Winaestra##16264
		|tip You can pick which one of these mounts you would like to use for your character.
		.buy 1 Black Hawkstrider##29221 |or
		.buy 1 Blue Hawkstrider##29220 |or
		.buy 1 Purple Hawkstrider##29222 |or
		.buy 1 Red Hawkstrider##28927 |or
		|only Blood Elf
		|next "end"
	step
		goto Orgrimmar 36.6,87.0
		.talk Revi Ramrod##48513
		.learn Apprentice Riding##33388
		|only Goblin
	step
		goto Orgrimmar 36.2,86.6
		.talk Kall Worthaton##48510
		.buy 1 Goblin Trike Key##62461
		|only Goblin
		|next "end"
	step
		goto Orgrimmar 49.0,59.6
		.talk Maztha##44919
		.learn Apprentice Riding##33388
		|only Pandaren
	step
		goto Orgrimmar 69.8,41.0
		.talk Turtlemaster Odai##66022
		|tip You can pick which one of these mounts you would like to use for your character.
		.buy 1 Reins of the Black Dragon Turtle##91008 |or
		.buy 1 Reins of the Blue Dragon Turtle##91009 |or
		.buy 1 Reins of the Brown Dragon Turtle##91005 |or
		.buy 1 Reins of the Green Dragon Turtle##91004 |or
		.buy 1 Reins of the Purple Dragon Turtle##91006 |or
		.buy 1 Reins of the Red Dragon Turtle##91007 |or
		|only Pandaren
		|next "end"
	step
	label "journeyman"
		goto Orgrimmar 49.0,59.6
		.talk Maztha##44919
		.learn Journeyman Riding##33391
		|only Orc
	step
		goto Orgrimmar 61.6,35.6
		.talk Ogunaro Wolfrunner##3362
		|tip You can use the level 20 mount you purchased, or pick which one of these new mounts you would like to use for your character.
		.buy 1 Horn of the Swift Gray Wolf##18798 |or
		.buy 1 Horn of the Swift Brown Wolf##18796 |or
		.buy 1 Horn of the Swift Timber Wolf##18797 |or
		.' Click here if you wish to use the mount you purchased before. |confirm
		|only Orc
		|next "end"
	step
		goto Tirisfal Glades 61.8,51.8
		.talk Velma Warnam##4773
		.learn Journeyman Riding##33391
		|only Undead
	step
		goto Tirisfal Glades 61.8,51.8
		.talk Zachariah Post##4731
		|tip You can use the level 20 mount you purchased, or pick which one of these new mounts you would like to use for your character.
		.buy 1 Green Skeletal Warhorse##13334 |or
		.buy 1 Ochre Skeletal Warhorse##47101 |or
		.buy 1 Purple Skeletal Warhorse##18791 |or
		.' Click here if you wish to use the mount you purchased before. |confirm
		|only Undead
		|next "end"
	step
		goto Mulgore 47.6,58.0
		.talk Kar Stormsinger##3690
		.learn Journeyman Riding##33391
		|only Tauren
	step
		goto Mulgore 47.6,58.0
		.talk Harb Clawhoof##3685
		|tip You can use the level 20 mount you purchased, or pick which one of these new mounts you would like to use for your character.
		.buy 1 Great White Kodo##18794 |or
		.buy 1 Great Gray Kodo##18795 |or
		.buy 1 Great Brown Kodo##15290 |or
		.' Click here if you wish to use the mount you purchased before. |confirm
		|only Tauren
		|next "end"
	step
		goto Durotar 55.2,75.4
		.talk Xar'Ti##7953
		.learn Journeyman Riding##33391
		|only Troll
	step
		goto Durotar 55.2,75.6
		.talk Zjolnir##7952
		|tip You can use the level 20 mount you purchased, or pick which one of these new mounts you would like to use for your character.
		.buy 1 Swift Blue Raptor##18788 |or
		.buy 1 Swift Olive Raptor##18789 |or
		.buy 1 Swift Orange Raptor##18790 |or
		.' Click here if you wish to use the mount you purchased before. |confirm
		|only Troll
		|next "end"
	step
		goto Eversong Woods 61.2,54.0
		.talk Perascamin##16280
		.learn Journeyman Riding##33391
		|only Blood Elf
	step
		goto Eversong Woods 61.0,54.6
		.talk Winaestra##16264
		|tip You can use the level 20 mount you purchased, or pick which one of these new mounts you would like to use for your character.
		.buy 1 Swift Green Hawkstrider##29223 |or
		.buy 1 Swift Pink Hawkstrider##28936 |or
		.buy 1 Swift Purple Hawkstrider##29224 |or
		.' Click here if you wish to use the mount you purchased before. |confirm
		|only Blood Elf
		|next "end"
	step
		goto Orgrimmar 36.6,87.0
		.talk Revi Ramrod##48513
		.learn Journeyman Riding##33391
		|only Goblin
	step
		goto Orgrimmar 36.2,86.6
		.talk Kall Worthaton##48510
		|tip You can use the level 20 mount you purchased, or pick this new mount.
		.buy 1 Goblin Turbo-Trike Key##62462
		.' Click here if you wish to use the mount you purchased before. |confirm
		|only Goblin
		|next "end"
	step
		goto Orgrimmar 49.0,59.6
		.talk Maztha##44919
		.learn Journeyman Riding##33391
		|only Pandaren
	step
		goto Orgrimmar 69.8,41.0
		.talk Turtlemaster Odai##66022
		|tip You can use the level 20 mount you purchased, or pick which one of these new mounts you would like to use for your character.
		.buy 1 Reins of the Great Black Dragon Turtle##91011 |or
		.buy 1 Reins of the Great Blue Dragon Turtle##91013 |or
		.buy 1 Reins of the Great Brown Dragon Turtle##91014 |or
		.buy 1 Reins of the Great Green Dragon Turtle##91012 |or
		.buy 1 Reins of the Great Purple Dragon Turtle##91015 |or
		.buy 1 Reins of the Great Red Dragon Turtle##91010 |or
		.' Click here if you wish to use the mount you purchased before. |confirm
		|only Pandaren
		|next "end"
	step
	label "expert"
		goto Orgrimmar 49.0,59.6
		.talk Maztha##44919
		.learn Expert Riding##34090
		.learn Flight Master's License##90267
	step
		goto Orgrimmar 48.0,58.6
		.talk Drakma##44918
		|tip You can pick which one of these mounts you would like to use for your character.
		.buy 1 Blue Wind Rider##25475 |or
		.buy 1 Green Wind Rider##25476 |or
		.buy 1 Tawny Wind Rider##25474 |or
		|next "end"
	step
	label "cold"
		goto Orgrimmar 49.0,59.6
		.talk Maztha##44919
		.learn Cold Weather Flying##54197
		|next "end"
	step
	label "artisan"
		goto Orgrimmar 49.0,59.6
		.talk Maztha##44919
		.learn Artisan Riding##34091
	step
		goto Orgrimmar 48.0,58.6
		.talk Drakma##44918
		|tip You can use the level 60 mount you purchased, or pick which one of these new mounts you would like to use for your character.
		.buy 1 Swift Green Wind Rider##25531 |or
		.buy 1 Swift Purple Wind Rider##25533 |or
		.buy 1 Swift Red Wind Rider##25477 |or
		.buy 1 Swift Yellow Wind Rider##25532 |or
		|next "end"
	step
	label "master"
		goto Orgrimmar 49.0,59.6
		.talk Maztha##44919
		.learn Artisan Riding##34091
	step
		goto Orgrimmar 48.0,58.6
		.talk Drakma##44918
		|tip You can use the level 60 or 70 mount you purchased, or pick which one of these new mounts you would like to use for your character.
		.buy 1 Swift Green Wind Rider##25531 |or
		.buy 1 Swift Purple Wind Rider##25533 |or
		.buy 1 Swift Red Wind Rider##25477 |or
		.buy 1 Swift Yellow Wind Rider##25532 |or
		|next "end"
]])


ZygorGuidesViewer:RegisterInclude("Profession_List_Alchemy",[[
		'Known from learning Alchemy
		.learn Elixir of Lion's Strength##2329
	step
		'Known from learning Alchemy
		.learn Elixir of Minor Defense##7183
	step
		'Known from learning Alchemy
		.learn Minor Healing Potion##2330
	step
		#include "trainer_Alchemy"
		.learn Weak Troll's Blood Elixir##3170
	step
		#include "trainer_Alchemy"
		.learn Minor Mana Potion##2331
	step
		#include "trainer_Alchemy"
		.learn Minor Rejuvenation Potion##2332
	step
		'This item is no longer in the game.
		.learn Discolored Healing Potion##4508
	step
		#include "trainer_Alchemy"
		.learn Elixir of Minor Agility##3230
	step
		#include "trainer_Alchemy"
		.learn Elixir of Minor Fortitude##2334
	step
		#include "trainer_Alchemy"
		.learn Lesser Healing Potion##2337
	step
		goto Orgrimmar 45.6,39.0
		.talk Hagrus##3335
		.buy 1 Recipe: Rage Potion##5640 |n
		.learn Rage Potion##6617
	step
		#include "trainer_Alchemy"
		.learn Swiftness Potion##2335
	step
		#include "trainer_Alchemy"
		.learn Blackmouth Oil##7836
	step
		'This is a Random World Drop, from creatures level 8-36 and some dungeons.
		|tip We recommend Southern Barrens for grinding.
		.collect 1 Recipe: Elixir of Giant Growth##6663 |n
		.learn Elixir of Giant Growth##6662
	step
		#include "trainer_Alchemy"
		.learn Elixir of Water Breathing##7179
	step
		#include "trainer_Alchemy"
		.learn Elixir of Wisdom##3171
	step
		goto Duskwood 81.8,19.8
		.talk Kzixx##3134
		.buy 1 Recipe: Holy Protection Potion##6053 |n
		.learn Holy Protection Potion##7255
	step
		#include "trainer_Alchemy"
		.learn Swim Speed Potion##7841
	step
		#include "trainer_Alchemy"
		.learn Healing Potion##3447
	step
		#include "trainer_Alchemy"
		.learn Lesser Mana Potion##3173
	step
		'This is a Random World Drop, from creatures level 16-28 and some dungeons.
		|tip We recommend Black Fathom Deeps for grinding.
		.collect 1 Recipe: Potion of Curing##3394 |n
		.learn Potion of Curing##3174
	step
		#include "trainer_Alchemy"
		.learn Strong Trolls Blood Elixir##3176
	step
		#include "trainer_Alchemy"
		.learn Fire Oil##7837
	step
		#include "trainer_Alchemy"
		.learn Elixir of Defense##3177
	step
		#include "trainer_Alchemy"
		.learn Elixir of Minor Accuracy##63732
	step
		goto Hillsbrad Foothills 57.5,47.8
		.talk Christoph Jeffcoat##2393
		.buy 1 Recipe: Shadow Protection Potion##6054 |n
		|tip This NPC is Horde Faction. Alliance have to purchase it from the AH.
		.learn Shadow Protection Potion##7256
	step
		#include "trainer_Alchemy"
		.learn Elixir of Firepower##7845
	step
		'This is a Random World Drop, from creatures level 20-36 and some dungeons.
		|tip We recommend Gnomeregan for grinding.
		.collect 1 Recipe: Elixir of Lesser Agility##3396 |n
		.learn Elixir of Lesser Agility##2333
	step
		'This is a Random World Drop, from creatures level 20-36 and some dungeons.
		|tip We recommend Gnomeregan for grinding.
		.collect 1 Elixir of Ogre's Strength##6211 |n
		.learn Elixir of Ogre's Strength##3188
	step
		goto Orgrimmar 55.6,46.4
		.talk Kor'geld##3348
		.buy 1 Recipe: Free Action Potion##5642 |n
		.learn Free Action Potion##6624
	step
		#include "trainer_Alchemy"
		.learn Greater Healing Potion##7181
	step
		#include "trainer_Alchemy"
		.learn Mana Potion##3452
	step
		#include "trainer_Alchemy"
		.learn Lesser Invisibility Potion##3448
	step
		#include "trainer_Alchemy"
		.learn Shadow Oil##3449
	step
		goto Stonetalon Mountains 50.4,63.6
		.talk Jeeda##4083
		.buy 1 Recipe: Fire Protection Potion##7257 |n
		.learn Fire Protection Potion##7257
	step
		#include "trainer_Alchemy"
		.learn Elixir Fortitude##3450
	step
		goto Orgrimmar 44.0,38.4
		.talk Hagrus##3335
		.buy 1 Recipe: Great Rage Potion##5643 |n
		.learn Great Rage Potion##6618
	step
		'This is a Random World Drop, from creatures level 25-45 and some dungeons.
		|tip We recommend Uldaman for grinding.
		.collect 1 Recipe: Major Troll's Blood Elixir##3831 |n
		.learn Major Troll's Blood Elixir##3451
	step
		#include "trainer_Alchemy"
		.learn Elixir of Agility##11449
	step
		goto The Cape of Stranglethorn 42.6,74.8
		.talk Glyx Brewright##2848
		.buy 1 Recipe: Frost Protection Potion##7258 |n
		.learn Frost Protection Potion##7258
	step
		'This can only be obtained during the Feast of Winter Veil Holiday Event. This is from December 15 - Janurary 2.
		.collect 1 Smokywood Pastures Special Gift##17726 |n
		.' Open your Smokywood Pastures Special Gift |use Smokywood Pastures Special Gift##17726
		.' Or 
		.collect 1 Ticking Present##21327 |n
		.' Open your Ticking Present |use Ticking Present##21327
		.collect 1 Recipe: Elixir of Frost Power##17709 |n
		.learn Elixir of Frost Power##21923
//1 through 3 of Nature Protection Potions
	step
	label	nature_1
		goto Tanaris 50.8,28.0
		.talk Alchemist Pestlezugg##5594
		.buy 1 Recipe: Nature Protection Potion##6057 |n
		.learn Nature Protection Potion##7259
	step
	label	nature_2
		goto Feralas 76.0,43.4
		.talk Bronk##8158
		.buy 1 Recipe: Nature Protection Potion##6057 |n
		.learn Nature Protection Potion##7259
	step
	label	nature_3
		goto 42.6,74.8
		.talk Glyx Brewright##2848
		.buy 1 Recipe: Nature Protection Potion##6057 |n
		.learn Nature Protection Potion##7259
	step	
		'This is a Random World Drop, from creatures level 25-46 and some dungeons.
		|tip We recommend Uldaman for grinding.
		.collect 1 Recipe: Elixir of Detect Lesser Invisibility##3832 |n
		.learn Elixir of Detect Lesser Invisibility##3453
	step
		#include "trainer_Alchemy"
		.learn Elixir of Greater Defense##11450
	step
		#include "trainer_Alchemy"
		.learn Catseye Elixir##12609
	step
		goto Hillsbrad Foothills 44.0,21.8
		.talk Bro'kin##2480
		.buy 1 Recipe: Frost Oil##14634 |n
		.learn Frost Oil##3454
	step
		#include "trainer_Alchemy"
		.learn Greater Mana Potion##11448
	step
		#include "trainer_Alchemy"
		.learn Oil of Immolation##11451
	step
		'This recipe is created by a Goblin Engineer. You will need to buy this off the AH or have an Engineer make it for you.
		.collect 1 Recipe: Goblin Rocket Fuel##10644 |n
		.learn Goblin Rocket Fuel##11456
	step
		'This recipe can no longer be learned. It was acquired from a quest no longer in-game. 
		.learn Restorative Potion##11452
	step
		#include "trainer_Alchemy"
		.learn Elixir of Greater Water Breathing##22808
	step
		'This Recipe is no longer obtainable through the game. You will only be able to buy one from another player that has colleceted it already.
		.collect 1 Recipe: Lesser Stoneshield Potion |n
		.learn Lesser Stoneshield Potion##4942
	step
		#include "trainer_Alchemy"
		.learn Superior Healing Potion##11457
	step
		goto 50.8,28.0
		.talk Alchemist Pestlezugg##5594
		.buy 1 Recipe: Philosopher's Stone##9303 |n
		.learn Philosopher's Stone##11459
	step
		goto 50.8,28.0
		.talk Alchemist Pestlezugg##5594
		.buy 1 Recipe: Transmute Iron to Gold##9304 |n
		.learn Transmute: Iron to Gold##11479
	step
		goto 50.8,28.0
		.talk Alchemist Pestlezugg##5594
		.buy 1 Recipe: Transmute Mithril to Truesilver##9305 |n
		.learn Transmute: Mithril to Truesilver##11480
	step	
		goto The Hinterlands 65.2,75.3
		.from Vilebranch Hideskinner##2644+, Vilebranch Shadow Hunter##2645+, Vilebranch Berserker##2643+, Vilebranch Shadowcaster##2642+, Vilebranch Witch Doctor##2640+
		.collect 1 Recipe: Wildvine Potion |n
		.learn Wildvine Potion##11458
	step
		#include "trainer_Alchemy"
		.learn Dreamless Sleep Potion##15833
	step
		#include "trainer_Alchemy"
		.learn Elixir of Detect Undead##11460
	step
		#include "trainer_Alchemy"
		.learn Arcane Elixir##11461
	step
		#include "trainer_Alchemy"
		.learn Elixir of Greater Intellect##11465
	step
		'This is a Random World Drop, from creatures level 33-56 and some dungeons.
		|tip We recommend Stratholme or Zul'Farrak for grinding.
		.collect 1 Recipe: Invisibility Potion##9295 |n
		.learn Invisibility Potion##11464
	step
		'This is a Random World Drop, from creatures level 40-56 and some dungeons.
		|tip We recommend Blackrock Depths for grinding.
		.collect 1 Recipe: Elixir of Dream Vision##9297 |n
		.learn Elixir of Dream Vision##11468
	step
		#include "trainer_Alchemy"
		.learn Elixir of Greater Agility##11467
	step
		'This item may not drop in the game anymore, however they were known to drop from Skeletal Flayers in the past here [Western Plaguelands 54.4,79.9]		
		.collect 1 Recipe: Gift of Arthas##9296 |n
		.learn Gift of Arthas##11466
	step
		'This is a Random World Drop, from creatures level 41-56 and some dungeons.
		|tip We recommend Dire Maul for grinding.
		.collect 1 Recipe: Elixir of Giants##9298 |n
		.learn Elixir of Giants
	step
		goto Feralas 76.0,43.4
		.talk Bronk##8158
		.buy 1 Recipe: Ghost Dye##9302 |n
		.learn Ghost Dye##11473
	step
		#include "trainer_Alchemy"
		.learn Stonescale Oil##17551
	step
		goto 47.2,57.2
		.talk Rartar##8177
		.buy 1 Recipe: Elixir of Demonslaying##9300
		.learn Elixir of Demonslaying##11477
	step
		#include "trainer_Alchemy"
		.learn Elixir of Detect Demon##11478
	step
		goto Searing Gorge 40.2,41.4
		.from Dark Iron Slaver##5844, Dark Iron Taskmaster##5846
		.collect 1 Recipe: Elixir of Greater Firepower##21547 |n
		.learn Elixir of Greater Firepower##26277
	step
		goto 52.6,75.0
		.talk Algernon##4610
		.buy 1 Recipe: Elixir of Shadow Power##9301 |n
		.learn Elixir of Shadow Power##11476
	step
		'This is a Random World Drop, from creatures level 40-56 and some dungeons.
		|tip We recommend Dire Maul for grinding.
		.collect 1 Recipe: Limited Invulnerability Potion |n
		.learn Limited Invulnerability Potion##3175
	step
		#include "trainer_Alchemy"
		.learn Mighty Rage Potion##17552
	step
		#include "trainer_Alchemy"
		.learn Superior Mana Potion##17553
	step
		goto Orgrimmar 55.6,46.4
		.talk Kor'geld##3348
		.buy 1 Recipe: Elixir of Superior Defense##13478 |n
		.learn Elixir of Superior Defense##17554
	step
		#include "trainer_Alchemy"
		.learn Elixir of the Sages##17555
//Transmute Air to Fire 1 - 2
	step
	label	Air_to_Fire_1
		goto Tirisfal Glades 83.2,68.0
		.talk Argent Quartermaster Hasana##10856
		.buy 1 Recipe: Transmute Air to Fire##13482 |n
		.learn Transmute: Air to Fire##17559
	step
	label	Air_to_Fire_2
		goto Eastern Plaguelands 75.8,54.0
		.talk Quartermaster Miranda Breechlock##11536
		.buy 1 Recipe: Transmute Air to Fire##13482 |n
		.learn Transmute: Air to Fire##17559
	step
		goto 50.8,28.0
		.talk Alchemist Pestlezugg##5594
		.buy 1 Recipe: Transmute Arcanite##12958 |n
		.learn Transmute: Arcanite##17187
	step
		'This is a Random World Drop, from creatures level 45-56 and some dungeons.
		|tip We recommend Blackrock Depths for grinding.
		.collect 1 Recipe: Transmute Earth to Life##13489 |n
		.learn Transmute: Earth to Life##17566
	step
		goto 64.8,5.2
		.talk Meilosh##11557
		|tip Must be Friendly with Timbermaw Hold to purchase this recipe.
		.buy 1 Recipe: Transmute Earth to Water##13484 |n
		.learn Transmute: Earth to Water##17561
	step
		goto Blackrock Depths/2 49.8,61.6
		.talk Plugger Spazzring##9499
		.collect 1 Recipe: Transmute Fire to Earth##13483 |n
		.learn Transmute: Fire to Earth##17560
	step
		'This is a Random World Drop, from creatures level 46-60 and some dungeons.
		|tip We recommend Blackrock Depths or Blackwing Lair for grinding.
		.buy 1 Recipe: Transmute Life to Earth##13488 |n
		.learn Transmute: Life to Earth##17565
	step
		'This is a Random World Drop, from creatures level 45-60 and some dungeons.
		|tip We recommend Stratholme or Blackwing Lair for grinding.
		.collect 1 Recipe: Transmute Undeath to Water##13486 |n
		.learn Transmute: Undeath to Water##17563
	step
		goto Western Plaguelands 68.0,77.6
		.talk Magnus Frostwake##11278
		.buy 1 Recipe: Transmute Water to Air##13485 |n
		.learn Transmute: Water to Air##17562
	step
		'This is a Random World Drop, from creatures level 45-60 and some dungeons.
		|tip We recommend Blackrock Depths or Blackwing Lair for grinding.
		.collect 1 Recipe: Transmute Water to Undeath##13487 |n
		.learn Transmute: Water to Undeath##17564
	step
		#include "trainer_Alchemy"
		.learn Elixir of Brute Force##17557
	step
		'This recipe can no longer be learned. It was acquired from a quest no longer in-game. 
		.learn Greater Dreamless Sleep Potion##24366
	step
		'This recipe can no longer be learned. It was acquired from a quest no longer in-game. 
		.learn Mageblood Elixir##24365
	step
		#include "trainer_Alchemy"
		.learn Major Healing Potion##17556
	step
		goto Felwood 39.8,68.2
		.from Jadefire Rogue##7106 
		.' You can find more Rogues here [Azshara 53.8,22.6]
		.collect 1 Recipe: Elixir of the Mongoose##13491 |n
		.learn Elixir of the Mongoose##17571
	step
		'This is a Random World Drop, from creatures level 37-63 and some dungeons.
		|tip We recommend Silithus or Ruins of Ahn'Qiraj for grinding.
		.collect 1 Recipe: Greater Stoneshield Potion##13490 |n
		.learn Greater Stoneshield Potion##17570
	step
		#include "trainer_Alchemy"
		.learn Greater Arcane Elixir##17573
	step
		goto Winterspring 59.2,50.0
		.talk Evie Whirlbrew##11188
		.buy 1 Recipe: Living Action Potion##20013 |n
		.learn Living Action Potion##24367
	step
		#include "trainer_Alchemy"
		.learn Purification Potion##17572
	step
		'This item may not drop in the game anymore, however they were known to drop from Cobalt Mageweavers in the past here [Winterspring 60,77]
		.from Cobalt Mageweaver##7437
		.collect 1 Recipe: Greater Arcane Protection Potion##13497 |n
		.learn Greater Arcane Protection Potion##17577
	step
		goto Burning Steppes/14 65.8,41.9 |n
		.from Firebrand Invoker##9262, Firebrand Pyromancer##9264
		|tip The NPC's can be found inside Lower Blackrock Spire.
		.collect 1 Recipe: Greater Fire Protection Potion##13494 |n
		.learn Greater Fire Protection Potion##17574
	step
		'This item may not drop in the game anymore, however they were known to drop from Frostmaul Giants in the past here [Winterspring 57.8,88.8]
		.from Frostmaul Giant##7428
		.collect 1 Recipe: Greater Frost Protection Potion##13495 |n
		.learn Greater Frost Protection Potion##17575
	step
		goto Silithus 55.4,36.6
		.talk Calandrath##15174
		.buy 1 Recipe: Greater Nature Protection Potion##13496 |n
		.learn Greater Nature Protection Potion##17576
	step
		'This item may not drop in the game anymore, however they were known to drop from Dark Adepts in the past here [Eastern Plaguelands 36.6,45.2]
		.from Dark Adept##8546
		.collect 1 Recipe: Greater Shadow Protection Potion##13499 |n
		.learn Greater Shadow Protection Potion##17578
	step
		'This recipe can no longer be learned. It was acquired from a faction no longer in-game. 
		.learn Mighty Troll's Blood Elixir##24368
	step
		goto Western Plaguelands 68.0,77.6
		.talk Magnus Frostwake##11278
		.buy 1 Recipe: Major Mana Potion##13501 |n
		.learn Major Mana Potion##17580
	step
		goto Blackrock Depths/2 50.3,58.5
		.talk Lokhtos Darkbargainer##12944
		|tip You will need to be Friendly with the Thorium Brotherhood to purchase this.
		.buy 1 Recipe: Transmute Elemental Fire##20761 |n
		.learn Transmute: Elemental Fire##25146
	step
		'This Recipe is dropped from the Bosses of the old raid Molten Core. 
		.collect 1 Recipe: Major Rejuvenation Potion##18257 |n
		.learn Major Rejuvenation Potion##22732
	step
		'This recipe can no longer be learned. It was acquired from a quest no longer in-game. 
		.learn Gurubashi Mojo Madness##24266
	step
		#include "trainer_Alchemy"
		.learn Adept's Elixir##33740
	step
		goto Zangarmarsh 79.2,63.8
		.talk Fedryen Swiftspear##17904
		|tip You need to be Exalted with Cenarion Expedition to purchase this Recipe.
		.buy 1 Recipe: Flask of Distilled Wisdom##31356 |n
		.learn Flask of Distilled Wisdom##17636
	step
		goto Tanaris 63.0,57.2
		.talk Alurmi##21643
		|tip You must be Exalted with the Keepers of Time to purchase this Recipe.
		.buy 1 Recipe: Flask of Supreme Power##31355 |n
		.learn Flask of Supreme Power##17637
	step
		goto Shattrath City 51.6,41.6
		.talk Almaador##21432
		|tip You must be Exalted with the Sha'tari to purchase this Recipe.
		.buy 1 Recipe: Flask of the Titans##31354 |n
		.learn Flask of the Titans##17635
	step
		#include "trainer_Alchemy"
		.learn Onslaught Elixir##33738
	step
		'This is a Random World Drop, from creatures level 46-60 but mostly old raids.
		|tip We recommend Blackwing Lair for grinding.
		.collect 1 Recipe: Potion of Petrification##13518 |n
		.learn Potion of Petrification##17634
	step
		#include "trainer_Alchemy"
		.learn Volatile Healing Potion##33732
	step
		goto Hellfire Peninsula 52.2,36.4
		.talk Apothecary Antonivich##16588
		.buy 1 Recipe: Elixir of Camouflage##22900 |n
		.learn Elixir of Camouflage##28543
		.' You can also purchase this from Melaris here [Silvermoon City 67.0,19.2]
		.talk Melaris##16641
	step
		#include "trainer_Alchemy"
		.learn Elixir of Major Strength##28544
	step
		#include "trainer_Alchemy"
		.learn Elixir of Healing Power##28545
	step
		#include "trainer_Alchemy"
		.learn Elixir of Major Fortitude##39636
	step
		#include "trainer_Alchemy"
		.learn Unstable Mana Potion##33733
	step
		#include "trainer_Alchemy"
		.learn Elixir of Mastery
	step
		goto Zangarmarsh 32.4,51.8
		.talk Seer Janidi##18017
		.buy 1 Recipe: Sneaking Potion##22901 |n
		.learn Sneaking Potion##28546
	step
		goto Zangarmarsh 79.2,63.8
		.talk Fedryen Swiftspear##17904
		|tip You must be Honored with Cenarion Expedition to purchase this Recipe.
		.buy 1 Recipe: Earthen Elixir##32070 |n
		.learn Earthen Elixir##39637
	step
		#include "trainer_Alchemy"
		.learn Elixir of Draenic Wisdom##39638
	step
		goto Zangarmarsh 32.4,51.8
		.talk Seer Janidi##18017
		.buy 1 Recipe: Elixir of Major Frost Power##22902 |n
		.learn Elixir of Major Frost Power##28549
	step
		'This is a Random World Drop, from creatures level 60-72 and some dungeons.
		|tip We recommend The Shattered Halls for grinding.
		.collect 1 Recipe: Insane Strength Potion##22903 |n
		.learn Insane Strength Potion##28550
	step
		#include "trainer_Alchemy"
		.learn Mad Alchemist's Potion##45061
	step
		#include "trainer_Alchemy"
		.learn Mercurial Stone##38070
	step
		'This is a Random World Drop, from creatures level 60-72 and some dungeons.
		|tip We recommend Sethekk Halls for grinding.
		.collect 1 Recipe: Elixir of the Searching Eye##22904 |n
		.learn Elixir of the Searching Eye##28552
	step
		#include "trainer_Alchemy"
		.learn Super Healing Potion##28551
	step
		goto Nagrand 41.2,44.2
		.talk Quartermaster Jaffrey Noreliqe##18821
		|tip Your faction must control Halaa before you can purchase this Recipe.
		.buy 1 Recipe: Elixir of Ironskin##32071 |n
		.learn Elixir of Ironskin##39639
	step
		goto Hellfire Peninsula 54.8,37.8
		.talk Quartermaster Urgronn##17585
		|tip You must be Honored with Thrallmar to purchase this Recipe.
		.buy 1 Recipe: Elixir of Major Agility##24001 |n
		.learn Elixir of Major Agility##28553
	step
		goto Shadowmoon Valley/0 23.0,38.5
		.from Terrormaster##21314+, Shadow Council Warlock##21302+, Wrathwalker##19740+, Overseer Ripsaw##21499+
		.collect 1 Recipe: Fel Strength Elixir##31680 |n
		.learn Fel Strength Elixir##38960
	step
		goto Zangarmarsh 17.8,51.2
		.talk Mycah##18382
		|tip You must be Exalted with Sporeggar to purchase this Recipe.
		.buy 1 Recipe: Shrouding Potion##22906 |n
		.learn Shrouding Potion##28554
	step
		goto Blade's Edge Mountains 51.0,57.8
		.talk Daga Ramba##19837
		.buy 1 Recipe: Super Mana Potion##22907 |n
		.learn Super Mana Potion##28555
	step
		goto Blade's Edge Mountains 51.0,57.8
		.talk Daga Ramba##19837
		.buy 1 Recipe: Elixir of Major Defense##22909 |n
		.learn Elixir of Major Defense##28557
	step
		goto Shattrath City 60.6,64.2
		.talk Quartermaster Enuril##19331
		|tip You must be Revered with The Scryers to purchase this Recipe.
		.buy 1 Recipe: Elixir of Major Firepower##22908 |n
		.learn Elixir of Major Firepower##28556
	step
		goto Shadowmoon Valley/0 40.6,38.4
		.from Deathforge Guardian##20878+, Deathforge Imp##20887+, Deathforge Summoner##20872+, Deathforge Tinkerer##19754+, Deathforge Smith##19756+
		.collect 1 Recipe: Fel Regeneration Potion##31681 |n
		.learn Fel Regeneration Potion##38962
	step
		goto Shattrath City 51.6,41.6
		.talk Almaador##21432
		|tip You must be Revered with The Sha'tar to purchase this Recipe.
		.buy 1 Recipe: Alchemist Stone##13517 |n
		.learn Alchemist Stone##17632
	step
		goto Zangarmarsh 79.2,63.8
		.talk Fedryen Swiftspear##17904
		|tip You must be Honored with Cenarion Expedition to purchase this Recipe.
		.buy 1 Recipe: Transmute Earthstorm Diamond##25869 |n
		.learn Transmute: Earthstorm Diamond##32765
	step
		goto Shattrath City 45.8,20.8
		.talk Skreah##19074
		.buy 1 Recipe: Transmute Primal Might##23574 |n
		.learn Transmute: Primal Might##29688
		.' You can also purchase this from Melaris in Silvermoon city here: [Silvermoon City 67.0,19.2]
		.talk Melaris##16641
	step
		goto Hellfire Peninsula 54.8,37.8
		.talk Quartermaster Urgronn##17585
		.buy 1 Recipe: Transmute Skyfire Diamond##29232 |n
		.learn Transmute: Skyfire Diamond##32766
	step
		goto Shattrath City 51.6,41.6
		.talk Almaador##21432
		|tip You must be Revered with The Sha'tar to purchase this Recipe.
		.buy 1 Recipe: Transmute Primal Air to Fire##22915 |n
		.learn Transmute: Primal Air to Fire##28566
	step
		goto Zangarmarsh 17.8,51.2
		.talk Mycah
		|tip You must be Revered with Sporeggar to purchase this Recipe.
		.buy 1 Recipe: Transmute Primal Earth to Water##22916 |n
		.learn Transmute: Primal Earth to Water##28567
	step
		goto Nagrand 53.4,36.8
		.talk Provisioner Nasela##20241
		|tip You must be Revered with The Mag'har to purchase this Recipe.
		.buy 1 Recipe: Transmute Primal Fire to Earth##22917 |n
		.learn Transmute: Primal Fire to Earth##28568
	step
		goto Zangarmarsh 79.2,63.8
		.talk Fedryen Swiftspear##17904
		|tip You must be Revered with Cenarion Expedition to purchase this Recipe.
		.buy 1 Recipe: Transmute Primal Water to Air##22918 |n
		.learn Transmute: Primal Water to Air##28569
	step
		'This is a Random World Drop, from creatures level 57-72, some dungeons and raids.
		|tip We recommend The Sunwell Plateau and The Black Temple for grinding.
		.collect 1 Recipe: Destruction Potion##22914 |n
		.learn Destruction Potion##28565
	step
		goto Shattrath City 62.6,69.0
		.talk Nakodu##21655
		|tip You must be Revered with Lower City to purchase this Recipe.
		.buy 1 Recipe: Elixir of Major Shadow Power##22910 |n
		.learn Elixir of Major Shadow Power##28558
	step
		'This is a Random World Drop, from creatures level 57-72, some dungeons and raids.
		|tip We recommend The Black Temple and Karazhan for grinding.
		.collect 1 Recipe: Haste Potion##22913 |n
		.learn Haste Potion##28564
	step
		'This is a Random World Drop, from creatures level 60-72, some dungeons and raids.
		|tip We recommend The Black Temple and The Sunwell Plateau for grinding.
		.collect 1 Recipe: Heroic Potion##22912 |n
		.learn Heroic Potion##28563
	step
		goto Blade's Edge Mountains 51.0,57.8
		.talk Daga Ramba##19837
		.buy 1 Recipe: Major Dreamless Sleep Potion##22911 |n
		.learn Major Dreamless Sleep Potion##28562
	step
		'This is a Random World Drop, from creatures level 60-72, some dungeons and raids.
		|tip We recommend Karazhan and The Black Temple for grinding.
		.collect 1 Recipe: Elixir of Major Mageblood##22919 |n
		.learn Elixir of Major Mageblood##28570
	step
		'This Recipe is learned by Discovery.
		.' You need to craft any Potion, Elixir or Flask from The Burning Crusade Expansion to discover this.
		.learn Cauldron of Major Arcane Protection##41458
	step
		'This Recipe is learned by Discovery.
		.' You need to craft any Potion, Elixir or Flask from The Burning Crusade Expansion to discover this.
		.learn Cauldron of Major Fire Protection##41500
	step
		'This Recipe is learned by Discovery.
		.' You need to craft any Potion, Elixir or Flask from The Burning Crusade Expansion to discover this.
		.learn Cauldron of Major Frost Protection##41501
	step
		'This Recipe is learned by Discovery.
		.' You need to craft any Potion, Elixir or Flask from The Burning Crusade Expansion to discover this.
		.learn Cauldron of Major Nature Protection##41502
	step
		'This Recipe is learned by Discovery.
		.' You need to craft any Potion, Elixir or Flask from The Burning Crusade Expansion to discover this.
		.learn Cauldron of Major Shadow Protection##41503
	step
		goto Shadowmoon Valley/0 53.1,59.7
		.from Eclipsion Soldier##22016+, Eclipsion Spellbinder##22017+, Eclipsion Cavalier##22018+,
		.collect 1 Recipe: Fel Mana Potion##31682 |n
		.learn Fel Mana Potion##38961
	step
		goto Nagrand 41.8,70.2
		.from Vir'aani Arcanist##17150
		|tip You can find these Arcanist's all around this area.
		.collect 1 Recipe: Major Arcane Protection Potion##22923 |n
		.learn Major Arcane Protection Potion##28575
	step
		goto The Mechanar/2 27.8,61.1
		.from Sunseeker Astromage##19168
		|tip You can find most of these on the upper level just before Pathaleon the Calculator (Boss).
		.collect 1 Recipe: Major Fire Protection Potion##22920 |n
		.learn Major Fire Protection Potion##28571
	step
		goto Mana-Tombs 32.5,49.5
		.from Nexus-Prince Shaffar##18344
		.collect 1 Recipe: Major Frost Protection Potion##22921 |n
		.learn Major Frost Protection Potion##28572
	step
		goto Blade's Edge Mountains 28.0,82.2
		.from Abyssal Flamebringer##19973+
		.collect 1 Recipe: Major Holy Protection Potion##22925 |n
		.learn Major Holy Protection Potion##28577
	step
		goto Zangarmarsh 79.2,63.8
		.talk Fedryen Swiftspear##17904
		|tip You must be Exalted with Cenarion Expedition to purchase this Recipe.
		.buy 1 Recipe: Major Nature Protection Potion##22922 |n
		.learn Major Nature Protection Potion##28573
	step
		goto Shadowmoon Valley 23.0,38.6
		.from Shadow Council Warlock##21302+
		.collect 1 Recipe: Major Shadow Protection Potion##22924 |n
		.learn Major Shadow Protection Potion##28576
	step
		'This is a Random World Drop, from creatures level 60-72, some dungeons and raids.
		|tip We recommend The Black Temple and Karazhan for grinding.
		.collect 1 Recipe: Elixir of Empowerment##22926 |n
		.learn Elixir of Empowerment##28578
	step
		goto Old Hillsbrad Foothills 69.3,69.1
		.from Captain Skarloc##17862
		.collect 1 Recipe: Ironshield Potion##22927 |n
		.learn Ironshield Potion##28579
	step
		#include "trainer_Alchemy"
		.learn Spellpower Elixir##53842
	step
		'This Recipe is learned by Discovery.
		.' You need to Transmute other Primals from The Burning Crusade Expansion to discover this.
		|tip You may be able to discover this through Potions, Elixirs and Flasks as well.
		.learn Transmute: Primal Earth to Life##28585
	step
		'This Recipe is learned by Discovery.
		.' You need to Transmute other Primals from The Burning Crusade Expansion to discover this.
		|tip You may be able to discover this through Potions, Elixirs and Flasks as well.
		.learn Transmute: Primal Fire to Mana##28583
	step
		'This Recipe is learned by Discovery.
		.' You need to Transmute other Primals from The Burning Crusade Expansion to discover this.
		|tip You may be able to discover this through Potions, Elixirs and Flasks as well.
		.learn Transmute: Primal Life to Earth##28584
	step
		'This Recipe is learned by Discovery.
		.' You need to Transmute other Primals from The Burning Crusade Expansion to discover this.
		|tip You may be able to discover this through Potions, Elixirs and Flasks as well.
		.learn Transmute: Primal Mana to Fire##28582
	step
		'This Recipe is learned by Discovery.
		.' You need to Transmute other Primals from The Burning Crusade Expansion to discover this.
		|tip You may be able to discover this through Potions, Elixirs and Flasks as well.
		.learn Transmute: Primal Shadow to Water##28582
	step
		'This Recipe is learned by Discovery.
		.' You need to Transmute other Primals from The Burning Crusade Expansion to discover this.
		|tip You may be able to discover this through Potions, Elixirs and Flasks as well.
		.learn Transmute: Primal Water to Shadow##28581
	step
		'This Recipe is learned by Discovery.
		.' You need to craft any Potion, Elixir or Flask from The Burning Crusade Expansion to discover this.
		.learn Flask of Blinding Light##28590
	step
		'This Recipe is learned by Discovery.
		.' You need to craft any Potion, Elixir or Flask from The Burning Crusade Expansion to discover this.
		.learn Flask of Fortification##28587
	step
		'This Recipe is learned by Discovery.
		.' You need to craft any Potion, Elixir or Flask from The Burning Crusade Expansion to discover this.
		.learn Flask of Mighty Restoration##28588
	step
		'This Recipe is learned by Discovery.
		.' You need to craft any Potion, Elixir or Flask from The Burning Crusade Expansion to discover this.
		.learn Flask of Pure Death##28591
	step
		'This Recipe is learned by Discovery.
		.' You need to craft any Potion, Elixir or Flask from The Burning Crusade Expansion to discover this.
		.learn Flask of Relentless Assault
	step
		'This Recipe is learned by Discovery.
		.' You need to craft any Potion, Elixir or Flask from The Burning Crusade Expansion to discover this.
		.learn Super Rejuvenation Potion##28586
	step
		goto Isle of Quel'Danas 47.2,30.6
		.talk Eldara Dawnrunner##25032
		|tip You must be Exalted with the Shattered Sun Offensive to purchase this Recipe.
		.buy 1 Recipe: Assassin's Alchemist Stone##35755 |n
		.learn Assassin's Alchemist Stone##47050
	step
		goto Isle of Quel'Danas 47.2,30.6
		.talk Eldara Dawnrunner##25032
		|tip You must be Exalted with the Shattered Sun Offensive to purchase this Recipe.
		.buy 1 Recipe: Guardian's Alchemist Stone##35755 |n
		.learn Guardian's Alchemist Stone##47046
	step
		goto Isle of Quel'Danas 47.2,30.6
		.talk Eldara Dawnrunner##25032
		|tip You must be Exalted with the Shattered Sun Offensive to purchase this Recipe.
		.buy 1 Recipe: Redeemer's Alchemist Stone##35754 |n
		.learn Redeemer's Alchemist Stone##47049
	step
		goto Isle of Quel'Danas 47.2,30.6
		.talk Eldara Dawnrunner##25032
		|tip You must be Exalted with the Shattered Sun Offensive to purchase this Recipe.
		.buy 1 Recipe: Sorcerer's Alchemist Stone##35753 |n
		.learn Sorcerer's Alchemist Stone##47048
	step
		#include "trainer_Alchemy"
		.learn Ethereal Oil##62409
	step
		#include "trainer_Alchemy"
		.learn Guru's Elixir##53848
	step
		#include "trainer_Alchemy"
		.learn Lesser Flask of Toughness##53899
	step
		#include "trainer_Alchemy"
		.learn Pygmy Oil##53812
	step
		#include "trainer_Alchemy"
		.learn Potion of Nightmares##53900
	step
		#include "trainer_Alchemy"
		.learn Elixir of Mighty Strength##54218
	step
		#include "trainer_Alchemy"
		.learn Elixir of Spirit##53847
	step
		#include "trainer_Alchemy"
		.learn Elixir of Mighty Fortitude##53898
	step
		#include "trainer_Alchemy"
		.learn Elixir of Mighty Agility##53840
	step
		#include "trainer_Alchemy"
		.learn Elixir of Mighty Thoughts##60367
	step
		#include "trainer_Alchemy"
		.learn Indestructible Potion##53905
	step
		#include "trainer_Alchemy"
		.learn Transmute: Titanium##60350
	step
		goto Icecrown 50.6,30.8
		.from Cult Researcher##32297
		.collect 1 Recipe: Mighty Arcane Protection Potion##44564 |n
		.learn Mighty Arcane Protection Potion##53936
	step
		goto Icecrown 49.8,32.6
		.from Damned Apothecary##32289
		.collect 1 Recipe: Mighty Frost Protection Potion##44566 |n
		.learn Mighty Frost Protection Potion##53937
	step
		goto 49.6,34.6
		.from Cult Alchemist##32290
		.collect 1 Recipe: Mighty Nature Protection Potion##44567 |n
		.learn Mighty Nature Protection Potion##43942
	step
		goto Icecrown 59.4,74.6
		.from Skeletal Runesmith##30921
		.collect 1 Recipe: Mighty Fire Protection Potion##44565 |n
		.learn Mighty Fire Protection Potion##53939
	step
		goto Icecrown Citadel 45.8,69.6
		.from Cultist Shard Watcher##32349
		.collect 1 Recipe: Mighty Shadow Protection Potion##44568 |n
		.learn Mighty Shadow Protection Potion##53938
	step
		#include "trainer_Alchemy"
		'This Recipe is learned by Discovery. 
		.' You can do the Northrend Alchemy Research in Dalaran every 3 days to try and learn this. |tip Must be level 400 to learn N. A. Research.
		.' You can also craft any Potion, Elixir or Flask from WotLK Exspanion to discover this.
		.learn Crazy Alchemist's Potion##53895
	step
		#include "trainer_Alchemy"
		'This Recipe is learned by Discovery. 
		.' You can do the Northrend Alchemy Research in Dalaran every 3 days to try and learn this. |tip Must be level 400 to learn N. A. Research.
		.' You can also craft any Potion, Elixir or Flask from WotLK Exspanion to discover this.
		.learn Elixir of Accuracy##60354
	step
		#include "trainer_Alchemy"
		'This Recipe is learned by Discovery. 
		.' You can do the Northrend Alchemy Research in Dalaran every 3 days to try and learn this. |tip Must be level 400 to learn N. A. Research.
		.' You can also craft any Potion, Elixir or Flask from WotLK Exspanion to discover this.
		.learn Elixir of Armor Piercing##60365
	step
		#include "trainer_Alchemy"
		'This Recipe is learned by Discovery. 
		.' You can do the Northrend Alchemy Research in Dalaran every 3 days to try and learn this. |tip Must be level 400 to learn N. A. Research.
		.' You can also craft any Potion, Elixir or Flask from WotLK Exspanion to discover this.
		.learn Elixir of Deadly Strikes##60355
	step
		#include "trainer_Alchemy"
		'This Recipe is learned by Discovery. 
		.' You can do the Northrend Alchemy Research in Dalaran every 3 days to try and learn this. |tip Must be level 400 to learn N. A. Research.
		.' You can also craft any Potion, Elixir or Flask from WotLK Exspanion to discover this.
		.learn Elixir of Expertise##60357
	step
		#include "trainer_Alchemy"
		'This Recipe is learned by Discovery. 
		.' You can do the Northrend Alchemy Research in Dalaran every 3 days to try and learn this. |tip Must be level 400 to learn N. A. Research.
		.' You can also craft any Potion, Elixir or Flask from WotLK Exspanion to discover this.
		.learn Elixir of Lightning Speed##60366
	step
		#include "trainer_Alchemy"
		'This Recipe is learned by Discovery. 
		.' You can do the Northrend Alchemy Research in Dalaran every 3 days to try and learn this. |tip Must be level 400 to learn N. A. Research.
		.' You can also craft any Potion, Elixir or Flask from WotLK Exspanion to discover this.
		.learn Elixir of Mighty Defense##60356
	step
		#include "trainer_Alchemy"
		'This Recipe is learned by Discovery. 
		.' You can do the Northrend Alchemy Research in Dalaran every 3 days to try and learn this. |tip Must be level 400 to learn N. A. Research.
		.' You can also craft any Potion, Elixir or Flask from WotLK Exspanion to discover this.
		.learn Elixir of Mighty Mageblood##56519
	step
		#include "trainer_Alchemy"
		'This Recipe is learned by Discovery. 
		.' You can do the Northrend Alchemy Research in Dalaran every 3 days to try and learn this. |tip Must be level 400 to learn N. A. Research.
		.' You can also craft any Potion, Elixir or Flask from WotLK Exspanion to discover this.
		.learn Elixir of Protection##54220
	step
		#include "trainer_Alchemy"
		'This Recipe is learned by Discovery. 
		.' You can do the Northrend Alchemy Research in Dalaran every 3 days to try and learn this. |tip Must be level 400 to learn N. A. Research.
		.' You can also craft any Potion, Elixir or Flask from WotLK Exspanion to discover this.
		.learn Elixir of Water Walking##62410
	step
		#include "trainer_Alchemy"
		'This Recipe is learned by Discovery. 
		.' You can do the Northrend Alchemy Research in Dalaran every 3 days to try and learn this. |tip Must be level 400 to learn N. A. Research.
		.' You can also craft any Potion, Elixir or Flask from WotLK Exspanion to discover this.
		.learn Potion of Speed##54221
	step
		#include "trainer_Alchemy"
		'This Recipe is learned by Discovery. 
		.' You can do the Northrend Alchemy Research in Dalaran every 3 days to try and learn this. |tip Must be level 400 to learn N. A. Research.
		.' You can also craft any Potion, Elixir or Flask from WotLK Exspanion to discover this.
		.learn Potion of Wild Magic##54222
	step
		#include "trainer_Alchemy"
		'This Recipe is learned by Discovery. 
		.' You can do the Northrend Alchemy Research in Dalaran every 3 days to try and learn this. |tip Must be level 400 to learn N. A. Research.
		.' You can also craft any Potion, Elixir or Flask from WotLK Exspanion to discover this.
		.learn Powerful Rejuvenation Potion##53904
	step
		#include "trainer_Alchemy"
		.learn Indestructible Alchemist Stone##60403
	step
		#include "trainer_Alchemy"
		.learn Mercurial Alchemist Stone##60396
	step
		#include "trainer_Alchemy"
		.learn Mighty Alchemist Stone##60405
	step
		'This Recipe is learned by Discovery. 
		.' Most commonly these are learned through Transmuting Gems and Stones within the WotLK Expansion.
		.learn Transmute: Eternal Air to Earth##53777
	step
		'This Recipe is learned by Discovery. 
		.' Most commonly these are learned through Transmuting Gems and Stones within the WotLK Expansion.
		.learn Transmute: Eternal Air to Water##53776
	step
		'This Recipe is learned by Discovery. 
		.' Most commonly these are learned through Transmuting Gems and Stones within the WotLK Expansion.
		.learn Transmute: Eternal Earth to Air##53781
	step
		'This Recipe is learned by Discovery. 
		.' Most commonly these are learned through Transmuting Gems and Stones within the WotLK Expansion.
		.learn Transmute: Eternal Earth to Shadow##53782
	step
		'This Recipe is learned by Discovery. 
		.' Most commonly these are learned through Transmuting Gems and Stones within the WotLK Expansion.
		.learn Transmute: Eternal Fire to Life##53775
	step
		'This Recipe is learned by Discovery. 
		.' Most commonly these are learned through Transmuting Gems and Stones within the WotLK Expansion.
		.learn Transmute: Eternal Fire to Water##53774
	step
		'This Recipe is learned by Discovery. 
		.' Most commonly these are learned through Transmuting Gems and Stones within the WotLK Expansion.
		.learn Transmute: Eternal Life to Fire##53773
	step
		'This Recipe is learned by Discovery. 
		.' Most commonly these are learned through Transmuting Gems and Stones within the WotLK Expansion.
		.learn Transmute: Eternal Life to Shadow##53771
	step
		'This Recipe is learned by Discovery. 
		.' Most commonly these are learned through Transmuting Gems and Stones within the WotLK Expansion.
		.learn Transmute: Eternal Shadow to Earth##53779
	step
		'This Recipe is learned by Discovery. 
		.' Most commonly these are learned through Transmuting Gems and Stones within the WotLK Expansion.
		.learn Transmute: Eternal Shadow to Life##53780
	step
		'This Recipe is learned by Discovery. 
		.' Most commonly these are learned through Transmuting Gems and Stones within the WotLK Expansion.
		.learn Transmute: Eternal Water to Air##53783
	step
		'This Recipe is learned by Discovery. 
		.' Most commonly these are learned through Transmuting Gems and Stones within the WotLK Expansion.
		.learn Transmute: Eternal Water to Fire##53784
	step
		#include "trainer_Alchemy"
		.learn Runic Healing Potion##53836
	step
		#include "trainer_Alchemy"
		.learn Endless Healing Potion##58871
	step
		#include "trainer_Alchemy"
		.learn Endless Mana Potion##58868
	step
		#include "trainer_Alchemy"
		.learn Runic Mana Potion##53837
	step
		#include "trainer_Alchemy"
		.learn Transmute: Earthsiege Diamond##57427
	step
		#include "trainer_Alchemy"
		.learn Draught of War##93935
	step
		#include "trainer_Alchemy"
		.learn Transmute: Skyflare Diamond##57425
	step
		#include "trainer_Alchemy"
		.learn Flask of Endless Rage##53903
	step
		#include "trainer_Alchemy"
		.learn Flask of Pure Mojo##54213
	step
		#include "trainer_Alchemy"
		.learn Flask of Stoneblood##53902
	step
		#include "trainer_Alchemy"
		.learn Flask of the Frost Wyrm##53901
	step
		#include "trainer_Alchemy"
		.learn Transmute: Ametrine##66658
	step
		#include "trainer_Alchemy"
		.learn Transmute: Dreadstone##66662
	step
		#include "trainer_Alchemy"
		.learn Transmute: Eye of Zul##66664
	step
		#include "trainer_Alchemy"
		.learn Transmute: King's Amber##66660
	step
		#include "trainer_Alchemy"
		.learn Transmute: Majestic Zircon##66663
	step
		goto Dalaran 42.6,32.0
		.talk Linzy Blackbolt##28703
		..accept Cardinal Ruby##14151
		.' Transmute 5 Epic Gems from the WotLK Exspansion |q 14151/1
		..turnin Cardinal Ruby##14151
		.learn Transmute: Cardinal Ruby##66659
	step
		#include "trainer_Alchemy"
		.learn Earthen Potion##80478
	step
		#include "trainer_Alchemy"
		.learn Ghost Elixir##80477
	step
		#include "trainer_Alchemy"
		.learn Deathblood Venom##80479
	step
		#include "trainer_Alchemy"
		.learn Elixir of the Naga##80480
	step
		#include "trainer_Alchemy"
		.learn Volcanic Potion##80481
	step
		#include "trainer_Alchemy"
		.learn Potion of Illusion##80269
	step
		#include "trainer_Alchemy"
		.learn Elixir of the Cobra##80484
	step
		#include "trainer_Alchemy"
		.learn Potion of Concentration##80482
	step
		#include "trainer_Alchemy"
		.learn Deepstone Oil##80486
	step
		#include "trainer_Alchemy"
		.learn Mysterious Potion##80487
	step
		#include "trainer_Alchemy"
		.learn Elixir of Deep Earth##80488
	step
		#include "trainer_Alchemy"
		.learn Mighty Rejuvenation Potion##80490
	step
		#include "trainer_Alchemy"
		.learn Elixir of Impossible Accuracy##80491
	step
		#include "trainer_Alchemy"
		.learn Prismatic Elixir##80492
	step
		#include "trainer_Alchemy"
		.learn Mythical Mana Potion##80494
	step
		#include "trainer_Alchemy"
		.learn Potion of the Tol'vir##80495
	step
		#include "trainer_Alchemy"
		.learn Transmute: Living Elements##78866
	step
		#include "trainer_Alchemy"
		.learn Elixir of Mighty Speed##80493
	step
		#include "trainer_Alchemy"
		.learn Golemblood Potion##80496
	step
		#include "trainer_Alchemy"
		.learn Elixir of the Master##80497
	step
		#include "trainer_Alchemy"
		.learn Mythical Healing Potion##80498
	step
		#include "trainer_Alchemy"
		.learn Flask of Flowing Water##94162
	step
		#include "trainer_Alchemy"
		.learn Flask of Steelskin##80719
	step
		#include "trainer_Alchemy"
		.learn Lifebound Alchemist Stone##80508
	step
		#include "trainer_Alchemy"
		.learn Quicksilver Alchemist Stone##96253
	step
		#include "trainer_Alchemy"
		.learn Vibrant Alchemist Stone##96254]
	step
		#include "trainer_Alchemy"
		.learn Volatile Alchemist Stone##96252
	step
		#include "trainer_Alchemy"
		.learn Alchemist's Rejuvenation##114751
	step
		#include "trainer_Alchemy"
		.learn Master Healing Potion##114752
	step
		#include "trainer_Alchemy"
		.learn Transmute: Dream Emerald##80251
	step
		#include "trainer_Alchemy"
		.learn Flask of the Draconic Mind##80720
	step
		#include "trainer_Alchemy"
		.learn Transmute: Ember Topaz##80250
	step
		#include "trainer_Alchemy"
		.learn Flask of Titanic Strength##80723
	step
		#include "trainer_Alchemy"
		.learn Flask of the Winds##80721
	step
		#include "trainer_Alchemy"
		.learn Transmute: Demonseye##80248
	step
		#include "trainer_Alchemy"
		.learn Transmute: Ocean Sapphire##80246
	step
		#include "trainer_Alchemy"
		.learn Transmute: Amberjewel##80247
	step
		#include "trainer_Alchemy"
		.learn Transmute: Pyrium Bar##80244
	step
		#include "trainer_Alchemy"
		.learn Transmute: Inferno Ruby##80245
	step
		#include "trainer_Alchemy"
		.learn Transmute: Shadowspirit Diamond##80237
	step
		#include "trainer_Alchemy"
		.learn Transmute: Truegold##80243
	step
		#include "trainer_Alchemy"
		.learn Potion of Deepholm##80725
	step
		#include "trainer_Alchemy"
		.learn Potion of Treasure Finding##80726
	step
		goto Orgrimmar 48.5,75.6
		.talk Goram##46572
		'To unlock this Recipe you need to complete an Achievement by creating 1000 Cataclysm flasks.
		.' Achieve Better Leveling Through Chemistry |achieve 5465
		.buy 1 Recipe: Cauldron of Battle##65435 |n
		.learn Cauldron of Battle##92643
	step
		goto Orgrimmar 48.5,75.6
		.talk Goram##46572
		'To unlock this Recipe you need to complete an Achievement by creating 3000 Cataclysm flasks.
		.' Achieve Better Leveling Through Chemistry |achieve 5024
		.buy 1 Recipe: Big Cauldron of Battle##65498 |n
		.learn Big Cauldron of Battle##92688
	step
		'You must have _Archaeology Level 450_ and use _45 Tol'vir Fragments_ combined with Tol'vir Hieroglyphic (optional) to create a Canopic Jar.
		.collect 1 Canopic Jar##64657 |n
		.' Open your Canopic Jar |use Canopic Jar##64657 
		|tip This has a low drop rate.
		.collect 1 Recipe: Vial of the Sands##67538 |n
		.learn Vial of the Sands##93328
	step
		'This is a Discovered Recipe
		.' Discovered Recipe's are learned by creating _Alchemist's Rejuvenation_ and _Master healing Potions_. You can also create any new Recipe you have discovered to discover this.
		.collect 1 Recipe: Elixir of Weaponry##84133 |n
		.learn Elixir of Weaponry##114756
	step
		' This Recipe is Discovered by creating _Alchemist's Rejuvenation_ and _Master healing Potions_. You can also create any new Recipe you have discovered to discover this.
		.collect 1 Recipe: Mad Hozen Elixir##84138 |n
		.learn Mad Hozen Elixir##114754	
	step
		' This Recipe is Discovered by creating _Alchemist's Rejuvenation_ and _Master healing Potions_. You can also create any new Recipe you have discovered to discover this.
		.collect 1 Recipe: Mantid Elixir##84139 |n
		.learn Mantid Elixir##114755
	step
		' This Recipe is Discovered by creating _Alchemist's Rejuvenation_ and _Master healing Potions_. You can also create any new Recipe you have discovered to discover this.
		.collect 1 Recipe: Monk's Elixir##84141 |n
		.learn Monk's Elixir##114758
	step
		' This Recipe is Discovered by creating _Alchemist's Rejuvenation_ and _Master healing Potions_. You can also create any new Recipe you have discovered to discover this.
		.collect 1 Recipe: Potion of the Jade Serpent##84146 |n
		.learn Potion of the Jade Serpent##114757
	step
		' This Recipe is Discovered by creating _Alchemist's Rejuvenation_ and _Master healing Potions_. You can also create any new Recipe you have discovered to discover this.
		.collect 1 Recipe: Potion of the Mountains##84147 |n
		.learn Potion of the Mountains##114753
	step
		' This Recipe is Discovered by creating _Alchemist's Rejuvenation_ and _Master healing Potions_. You can also create any new Recipe you have discovered to discover this.
		.collect 1 Recipe: Desecrated Oil##84128 |n
		.learn Desecrated Oil##114761
	step
		'This is a Discovered Recipe
		.' Discovered Recipe's are learned by creating _Alchemist's Rejuvenation_ and _Master healing Potions_. You can also create any new Recipe you have discovered to discover this.
		.collect 1 Recipe: Elixir of Mirrors##84129 |n
		.learn Elixir of Mirrors##114763
	step
		'This is a Discovered Recipe
		.' Discovered Recipe's are learned by creating _Alchemist's Rejuvenation_ and _Master healing Potions_. You can also create any new Recipe you have discovered to discover this.
		.collect 1 Recipe: Elixir of Peace##84130 |n
		.learn Elixir of Peace##114764
	step
		'This is a Discovered Recipe
		.' Discovered Recipe's are learned by creating _Alchemist's Rejuvenation_ and _Master healing Potions_. You can also create any new Recipe you have discovered to discover this.
		.collect 1 Recipe: Elixir of Perfection##84131 |n
		.learn Elixir of Perfection##114762
	step
		'This is a Discovered Recipe
		.' Discovered Recipe's are learned by creating _Alchemist's Rejuvenation_ and _Master healing Potions_. You can also create any new Recipe you have discovered to discover this.
		.collect 1 Recipe: Elixir of the Rapids##84132 |n
		.learn Elixir of the Rapids##114759
	step
		'This is a Discovered Recipe
		.' Discovered Recipe's are learned by creating _Alchemist's Rejuvenation_ and _Master healing Potions_. You can also create any new Recipe you have discovered to discover this.
		.collect 1 Recipe: Potion of Mogu Power##84144 |n
		.learn Potion of Mogu Power##114760
	step
		'This is a Discovered Recipe
		.' Discovered Recipe's are learned by creating _Alchemist's Rejuvenation_ and _Master healing Potions_. You can also create any new Recipe you have discovered to discover this.
		.collect 1 Recipe: Virmen's Bite##84155 |n
		.learn Virmen's Bite##114765
	step
		'This is a Discovered Recipe
		.' Discovered Recipe's are learned by creating _Alchemist's Rejuvenation_ and _Master healing Potions_. You can also create any new Recipe you have discovered to discover this.
		.collect 1 Recipe: Flask of Falling Leaves##84123 |n
		.learn Flask of Falling Leaves##114772
	step
		'This is a Discovered Recipe
		.' Discovered Recipe's are learned by creating _Alchemist's Rejuvenation_ and _Master healing Potions_. You can also create any new Recipe you have discovered to discover this.
		.collect 1 Recipe: Flask of Spring Blossoms##84134 |n
		.learn Flask of Spring Blossoms##114769
	step
		'This is a Discovered Recipe
		.' Discovered Recipe's are learned by creating _Alchemist's Rejuvenation_ and _Master healing Potions_. You can also create any new Recipe you have discovered to discover this.
		.collect 1 Recipe: Flask of Winter's Bite##84137 |n
		.learn Flask of Winter's Bite##114773
	step
		'This is a Discovered Recipe
		.' Discovered Recipe's are learned by creating _Alchemist's Rejuvenation_ and _Master healing Potions_. You can also create any new Recipe you have discovered to discover this.
		.collect 1 Recipe: Flask of the Earth##84135 |n
		.learn Flask of the Earth##114770
	step
		'This is a Discovered Recipe
		.' Discovered Recipe's are learned by creating _Alchemist's Rejuvenation_ and _Master healing Potions_. You can also create any new Recipe you have discovered to discover this.
		.collect 1 Recipe: Flask of the Warm Sun##84136
		.learn Flask of the Warm Sun##114771
	step
		'This is a Discovered Recipe
		.' Discovered Recipe's are learned by creating _Alchemist's Rejuvenation_ and _Master healing Potions_. You can also create any new Recipe you have discovered to discover this.
		.collect 1 Recipe: Transmute River's Heart##84152 |n
		.learn Transmute: River's Heart##114766
	step
		'This is a Discovered Recipe
		.' Discovered Recipe's are learned by creating _Alchemist's Rejuvenation_ and _Master healing Potions_. You can also create any new Recipe you have discovered to discover this.
		.collect 1 Recipe: Transmute Wild Jade##84154 |n
		.learn Transmute: Wild Jade##114767
	step
		'This is a Discovered Recipe
		.' Discovered Recipe's are learned by creating _Alchemist's Rejuvenation_ and _Master healing Potions_. You can also create any new Recipe you have discovered to discover this.
		.collect 1 Recipe: Darkwater Potion##84142 |n
		.learn Darkwater Potion##114774
	step
		'This is a Discovered Recipe
		.' Discovered Recipe's are learned by creating _Alchemist's Rejuvenation_ and _Master healing Potions_. You can also create any new Recipe you have discovered to discover this.
		.collect 1 Recipe: Master Mana Potion##84140 |n
		.learn Master Mana Potion##114775
	step
		'This is a Discovered Recipe
		.' Discovered Recipe's are learned by creating _Alchemist's Rejuvenation_ and _Master healing Potions_. You can also create any new Recipe you have discovered to discover this.
		.collect 1 Recipe: Transmute Imperial Amethyst##84148 |n
		.learn Transmute: Imperial Amethyst##114777
	step
		'This is a Discovered Recipe
		.' Discovered Recipe's are learned by creating _Alchemist's Rejuvenation_ and _Master healing Potions_. You can also create any new Recipe you have discovered to discover this.
		.collect 1 Recipe: Transmute Sun's Radiance##84125 |n
		.learn Transmute: Sun's Radiance##114778
	step
		'This is a Discovered Recipe
		.' Discovered Recipe's are learned by creating _Alchemist's Rejuvenation_ and _Master healing Potions_. You can also create any new Recipe you have discovered to discover this.
		.collect 1 Recipe: Transmute Vermilion Onyx##84126 |n
		.learn Transmute: Vermilion Onyx##114776
	step
		'This is a Discovered Recipe
		.' Discovered Recipe's are learned by creating _Alchemist's Rejuvenation_ and _Master healing Potions_. You can also create any new Recipe you have discovered to discover this.
		.collect 1 Recipe: Potion of Focus##84143 |n
		.learn Potion of Focus##114782
	step
		'This is a Discovered Recipe
		.' Discovered Recipe's are learned by creating _Alchemist's Rejuvenation_ and _Master healing Potions_. You can also create any new Recipe you have discovered to discover this.
		.collect 1 Recipe: Transmute Primal Diamond##84150 |n
		.learn Transmute: Primal Diamond##114781
	step
		'This is a Discovered Recipe
		.' Discovered Recipe's are learned by creating _Alchemist's Rejuvenation_ and _Master healing Potions_. You can also create any new Recipe you have discovered to discover this.
		.collect 1 Recipe: Transmute Primordial Ruby##84151 |n
		.learn Transmute: Primordial Ruby##114784
	step
		'This is a Discovered Recipe
		.' Discovered Recipe's are learned by creating _Alchemist's Rejuvenation_ and _Master healing Potions_. You can also create any new Recipe you have discovered to discover this.
		.collect 1 Recipe: Transmute Trillium Bar##84153 |n
		.learn Transmute: Trillium Bar##114783
	step
		'This is a Discovered Recipe
		.' Discovered Recipe's are learned by creating _Alchemist's Rejuvenation_ and _Master healing Potions_. You can also create any new Recipe you have discovered to discover this.
		.collect 1 Recipe: Transmute Living Steel##84149 |n
		.learn Transmute: Living Steel##114780
	step
		'This is a Discovered Recipe
		.' Discovered Recipe's are learned by creating _Alchemist's Rejuvenation_ and _Master healing Potions_. You can also create any new Recipe you have discovered to discover this.
		.collect 1 Recipe: Potion of Luck##84145 |n
		.learn Potion of Luck##114779
	step
		'This is a Discovered Recipe
		.' Discovered Recipe's are learned by creating _Alchemist's Rejuvenation_ and _Master healing Potions_. You can also create any new Recipe you have discovered to discover this.
		.learn Riddle of Steel##130326
]])

ZygorGuidesViewer:RegisterInclude("Profession_List_Blacksmith",[[
//TRAINER
		'You will learn this when you pick up Blacksmithing
		.learn Rough Copper Vest##12260
	step
		'You will learn this when you pick up Blacksmithing
		.learn Rough Sharpening Stone##2660
	step
		'You will learn this when you pick up Blacksmithing
		.learn Rough Weightstone##3115
	step
		'You will learn this when you pick up Blacksmithing
		.learn Copper Bracers##2663
	step
		'You will learn this when you pick up Blacksmithing
		.learn Copper Chain Pants##2662
	step
		#include "trainer_Blacksmithing"
		.learn Copper Mace##2737
	step
		#include "trainer_Blacksmithing"
		.learn Copper Axe##2738
	step
		#include "trainer_Blacksmithing"
		.learn Copper Chain Boots##3319
	step
		#include "trainer_Blacksmithing"
		.learn Rough Grinding Stone##3320
	step
		#include "trainer_Blacksmithing"
		.learn Copper Shortsword##2739
	step
		#include "trainer_Blacksmithing"
		.learn Copper Claymore##9983
	step
		#include "trainer_Blacksmithing"
		.learn Copper Dagger##8880
	step
		#include "trainer_Blacksmithing"
		.learn Copper Battle Axe##3293
	step
		#include "trainer_Blacksmithing"
		.learn Copper Chain Belt##2661
	step
		#include "trainer_Blacksmithing"
		.learn Runed Copper Gauntlets##3323
	step
		#include "trainer_Blacksmithing"
		.learn Runed Copper Pants##3324
	step
		#include "trainer_Blacksmithing"
		.learn Coarse Sharpening Stone##2665
	step
		#include "trainer_Blacksmithing"
		.learn Coarse Weightstone##3116
	step
		#include "trainer_Blacksmithing"
		.learn Heavy Copper Maul##7408
	step
		#include "trainer_Blacksmithing"
		.learn Runed Copper Belt##2666
	step
		#include "trainer_Blacksmithing"
		.learn Thick War Axe##3294
	step
		#include "trainer_Blacksmithing"
		.learn Coarse Grinding Stone##3326
	step
		#include "trainer_Blacksmithing"
		.learn Runed Copper Bracers##2664
	step
		#include "trainer_Blacksmithing"
		.learn Rough Bronze Boots##7817
	step
		#include "trainer_Blacksmithing"
		.learn Heavy Copper Broadsword##3292
	step
		#include "trainer_Blacksmithing"
		.learn Silver Skeleton Key##19666
	step
		#include "trainer_Blacksmithing"
		.learn Big Bronze Knife##3491
	step
		#include "trainer_Blacksmithing"
		.learn Rough Bronze Cuirass##2670
	step
		#include "trainer_Blacksmithing"
		.learn Rough Bronze Leggings##2668
	step
		#include "trainer_Blacksmithing"
		.learn Bronze Mace##2740
	step
		#include "trainer_Blacksmithing"
		.learn Pearl-handled Dagger##6517
	step
		#include "trainer_Blacksmithing"
		.learn Rough Bronze Shoulders##3328
	step
		#include "trainer_Blacksmithing"
		.learn Bronze Axe##2741
	step
		#include "trainer_Blacksmithing"
		.learn Bronze Shortsword##2742
	step
		#include "trainer_Blacksmithing"
		.learn Patterned Bronze Bracers##2672
	step
		#include "trainer_Blacksmithing"
		.learn Heavy Sharpening Stone##2674
	step
		#include "trainer_Blacksmithing"
		.learn Heavy Weightstone##3117
	step
		#include "trainer_Blacksmithing"
		.learn Heavy Grinding Stone##3337
	step
		#include "trainer_Blacksmithing"
		.learn Bronze Warhammer##9985
	step
		#include "trainer_Blacksmithing"
		.learn Bronze Greatsword##9986
	step
		#include "trainer_Blacksmithing"
		.learn Heavy Bronze Mace##3296
	step
		#include "trainer_Blacksmithing"
		.learn Silvered Bronze Boots##3331
	step
		#include "trainer_Blacksmithing"
		.learn Bronze Battle Axe##9987
	step
		#include "trainer_Blacksmithing"
		.learn Silvered Bronze Gauntlets##3333
	step
		#include "trainer_Blacksmithing"
		.learn Shining Silver Breastplate##2675
	step
		#include "trainer_Blacksmithing"
		.learn Iron Buckle##8768
	step
		#include "trainer_Blacksmithing"
		.learn Golden Skeleton Key##19667
	step
		#include "trainer_Blacksmithing"
		.learn Green Iron Leggings##3506
	step
		#include "trainer_Blacksmithing"
		.learn Green Iron Bracers##3501
	step
		#include "trainer_Blacksmithing"
		.learn Green Iron Helm##3502
	step
		#include "trainer_Blacksmithing"
		.learn Green Iron Hauberk##3508
	step
		#include "trainer_Blacksmithing"
		.learn Glinting Steel Dagger##15972
	step
		#include "trainer_Blacksmithing"
		.learn Golden Scale Bracers##7223
	step
		#include "trainer_Blacksmithing"
		.learn Solid Grinding Stone##9920
	step
		#include "trainer_Blacksmithing"
		.learn Solid Sharpening Stone##9918
	step
		#include "trainer_Blacksmithing"
		.learn Solid Weightstone##9921
	step
		#include "trainer_Blacksmithing"
		.learn Truesilver Skeleton Key##19668
	step
		#include "trainer_Blacksmithing"
		.learn Steel Breastplate##9916
	step
		#include "trainer_Blacksmithing"
		.learn Heavy Mithril Gauntlet##9928
	step
		#include "trainer_Blacksmithing"
		.learn Heavy Mithril Shoulder##9926
	step
		#include "trainer_Blacksmithing"
		.learn Mithril Scale Pants##9931
	step
		#include "trainer_Blacksmithing"
		.learn Heavy Mithril Axe##9993
	step
		#include "trainer_Blacksmithing"
		.learn Steel Plate Helm##9935
	step
		#include "trainer_Blacksmithing"
		.learn Heavy Mithril Breastplate##9959
	step
		#include "trainer_Blacksmithing"
		.learn Mithril Coif##9961
	step
		#include "trainer_Blacksmithing"
		.learn Big Black Mace##10001
	step
		#include "trainer_Blacksmithing"
		.learn Heavy Mithril Boots##9968
	step
		#include "trainer_Blacksmithing"
		.learn Dense Grinding Stone##16639
	step
		#include "trainer_Blacksmithing"
		.learn Dense Sharpening Stone##16641
	step
		#include "trainer_Blacksmithing"
		.learn Dense Weightstone##16640
	step
		#include "trainer_Blacksmithing"
		.learn Thorium Armor##16642
	step
		#include "trainer_Blacksmithing"
		.learn Thorium Belt##16643
	step
		#include "trainer_Blacksmithing"
		.learn Thorium Bracers##16644
	step
		#include "trainer_Blacksmithing"
		.learn Imperial Plate Belt##16647
	step
		#include "trainer_Blacksmithing"
		.learn Imperial Plate Shoulders##16646
	step
		#include "trainer_Blacksmithing"
		.learn Imperial Plate Bracers##16649
	step
		#include "trainer_Blacksmithing"
		.learn Arcanite Skeleton Key##19669
	step
		#include "trainer_Blacksmithing"
		.learn Ornate Thorium Handaxe##16969
	step
		#include "trainer_Blacksmithing"
		.learn Thorium Boots##16652
	step
		#include "trainer_Blacksmithing"
		.learn Thorium Helm##16653
	step
		#include "trainer_Blacksmithing"
		.learn Huge Thorium Battleaxe##16971
	step
		#include "trainer_Blacksmithing"
		.learn Fel Iron Breastplate##29550
	step
		#include "trainer_Blacksmithing"
		.learn Imperial Plate Chest##16663
	step
		#include "trainer_Blacksmithing"
		.learn Imperial Plate Leggings##16730
	step
		#include "trainer_Blacksmithing"
		.learn Imperial Plate Boots##16657
	step
		#include "trainer_Blacksmithing"
		.learn Imperial Plate Helm##16658
	step
		#include "trainer_Blacksmithing"
		.learn Fel Sharpening Stone##29654
	step
		#include "trainer_Blacksmithing"
		.learn Fel Weightstone##34607
	step
		#include "trainer_Blacksmithing"
		.learn Fel Iron Chain Coif##29551
	step
		#include "trainer_Blacksmithing"
		.learn Fel Iron Plate Gloves##29545
	step
		#include "trainer_Blacksmithing"
		.learn Thorium Leggings##16662
	step
		#include "trainer_Blacksmithing"
		.learn Fel Iron Plate Belt##29547
	step
		#include "trainer_Blacksmithing"
		.learn Fel Iron Chain Gloves##29552
	step
		#include "trainer_Blacksmithing"
		.learn Fel Iron Hatchet##29557
	step
		#include "trainer_Blacksmithing"
		.learn Fel Iron Chain Bracers##29553
	step
		#include "trainer_Blacksmithing"
		.learn Fel Iron Hammer##29558
	step
		#include "trainer_Blacksmithing"
		.learn Fel Iron Plate Boots##29548
	step
		#include "trainer_Blacksmithing"
		.learn Fel Iron Plate Pants##29549
	step
		#include "trainer_Blacksmithing"
		.learn Fel Iron Chain Tunic##29556
	step
		#include "trainer_Blacksmithing"
		.learn Fel Iron Greatsword##29565
	step
		#include "trainer_Blacksmithing"
		.learn Lesser Rune of Warding##32284
	step
		#include "trainer_Blacksmithing"
		.learn Cobalt Skeleton Key##59405
	step
		#include "trainer_Blacksmithing"
		.learn Cobalt Belt##52568
	step
		#include "trainer_Blacksmithing"
		.learn Cobalt Boots##52569
	step
		#include "trainer_Blacksmithing"
		.learn Cobalt Bracers##55834
	step
		#include "trainer_Blacksmithing"
		.learn Cobalt Shoulders##52572
	step
		#include "trainer_Blacksmithing"
		.learn Cobalt Triangle Shield##54550
	step
		#include "trainer_Blacksmithing"
		.learn Cobalt Helm##52571
	step
		#include "trainer_Blacksmithing"
		.learn Cobalt Legplates##52567
	step
		#include "trainer_Blacksmithing"
		.learn Cobalt Gauntlets##55835
	step
		#include "trainer_Blacksmithing"
		.learn Cobalt Chestpiece##52570
	step
		#include "trainer_Blacksmithing"
		.learn Spiked Cobalt Helm##54917
	step
		#include "trainer_Blacksmithing"
		.learn Cobalt Tenderizer##55201
	step
		#include "trainer_Blacksmithing"
		.learn Spiked Cobalt Boots##54918
	step
		#include "trainer_Blacksmithing"
		.learn Sturdy Cobalt Quickblade##55200
	step
		#include "trainer_Blacksmithing"
		.learn Forged Cobalt Claymore##55203
	step
		#include "trainer_Blacksmithing"
		.learn Spiked Cobalt Chestpiece##54944
	step
		#include "trainer_Blacksmithing"
		.learn Spiked Cobalt Shoulders##54941
	step
		#include "trainer_Blacksmithing"
		.learn Spiked Cobalt Shoulders##55174
	step
		#include "trainer_Blacksmithing"
		.learn Saronite Defender##54557
	step
		#include "trainer_Blacksmithing"
		.learn Saronite Protector##55013
	step
		#include "trainer_Blacksmithing"
		.learn Notched Cobalt War Axe##55204
	step
		#include "trainer_Blacksmithing"
		.learn Spiked Cobalt Gauntlets##54945
	step
		#include "trainer_Blacksmithing"
		.learn Brilliant Saronite Belt##59436
	step
		#include "trainer_Blacksmithing"
		.learn Brilliant Saronite Legplates##55055
	step
		#include "trainer_Blacksmithing"
		.learn Savage Cobalt Slicer##55177
	step
		#include "trainer_Blacksmithing"
		.learn Tempered Saronite Belt##54551
	step
		#include "trainer_Blacksmithing"
		.learn Tempered Saronite Legplates##54554
	step
		#include "trainer_Blacksmithing"
		.learn Spiked Cobalt Belt##54946
	step
		#include "trainer_Blacksmithing"
		.learn Spiked Cobalt Legplates##54947
	step
		#include "trainer_Blacksmithing"
		.learn Socket Bracer##55628
	step
		#include "trainer_Blacksmithing"
		.learn Socket Gloves##55641
	step
		#include "trainer_Blacksmithing"
		.learn Brilliant Saronite Bracers##59438
	step
		#include "trainer_Blacksmithing"
		.learn Brilliant Saronite Gauntlets##55056
	step
		#include "trainer_Blacksmithing"
		.learn Saronite Ambusher##55179
	step
		#include "trainer_Blacksmithing"
		.learn Tempered Saronite Boots##54552
	step
		#include "trainer_Blacksmithing"
		.learn Tempered Saronite Breastplate##54553
	step
		#include "trainer_Blacksmithing"
		.learn Horned Cobalt Helm##54949
	step
		#include "trainer_Blacksmithing"
		.learn Spiked Cobalt Bracers##54948
	step
		#include "trainer_Blacksmithing"
		.learn Brilliant Saronite Boots##55057
	step
		#include "trainer_Blacksmithing"
		.learn Brilliant Saronite Pauldrons##59440
	step
		#include "trainer_Blacksmithing"
		.learn Saronite Shiv##55181
	step
		#include "trainer_Blacksmithing"
		.learn Tempered Saronite Helm##54555
	step
		#include "trainer_Blacksmithing"
		.learn Tempered Saronite Shoulders##54556
	step
		#include "trainer_Blacksmithing"
		.learn Deadly Saronite Dirk##55206
	step
		#include "trainer_Blacksmithing"
		.learn Cudgel of Saronite Justice##56280
	step
		#include "trainer_Blacksmithing"
		.learn Furious Saronite Beatstick##55182
	step
		#include "trainer_Blacksmithing"
		.learn Saronite Bulwark##55014
	step
		#include "trainer_Blacksmithing"
		.learn Saronite Spellblade##59442
	step
		#include "trainer_Blacksmithing"
		.learn Tempered Saronite Bracers##55017
	step
		#include "trainer_Blacksmithing"
		.learn Brilliant Saronite Breastplate##55058
	step
		#include "trainer_Blacksmithing"
		.learn Brilliant Saronite Helm##59441
	step
		#include "trainer_Blacksmithing"
		.learn Eternal Belt Buckle##55656
	step
		#include "trainer_Blacksmithing"
		.learn Saronite Mindcrusher##55185
	step
		#include "trainer_Blacksmithing"
		.learn Tempered Saronite Gauntlets##55015
	step
		#include "trainer_Blacksmithing"
		.learn Ornate Saronite Bracers##56549
	step
		#include "trainer_Blacksmithing"
		.learn Savage Saronite Bracers##55305
	step
		#include "trainer_Blacksmithing"
		.learn Vengeance Bindings##55298
	step
		#include "trainer_Blacksmithing"
		.learn Titanium Shield Spike##56357
	step
		#include "trainer_Blacksmithing"
		.learn Titanium Weapon Chain##55839
	step
		#include "trainer_Blacksmithing"
		.learn Icebane Girdle##61009
	step
		#include "trainer_Blacksmithing"
		.learn Icebane Treads##61010
	step
		#include "trainer_Blacksmithing"
		.learn Daunting Handguards##55301
	step
		#include "trainer_Blacksmithing"
		.learn Ornate Saronite Gauntlets##56553
	step
		#include "trainer_Blacksmithing"
		.learn Ornate Saronite Pauldrons##56550
	step
		#include "trainer_Blacksmithing"
		.learn Ornate Saronite Waistguard##56551
	step
		#include "trainer_Blacksmithing"
		.learn Ornate Saronite Walkers##56552
	step
		#include "trainer_Blacksmithing"
		.learn Righteous Gauntlets##55300
	step
		#include "trainer_Blacksmithing"
		.learn Savage Saronite Gauntlets##55309
	step
		#include "trainer_Blacksmithing"
		.learn Savage Saronite Pauldrons##55306
	step
		#include "trainer_Blacksmithing"
		.learn Savage Saronite Waistguard##55307
	step
		#include "trainer_Blacksmithing"
		.learn Savage Saronite Walkers##55308
	step
		#include "trainer_Blacksmithing"
		.learn Icebane Chestguard##61008
	step
		#include "trainer_Blacksmithing"
		.learn Daunting Legplates##55303
	step
		#include "trainer_Blacksmithing"
		.learn Helm of Command##55302
	step
		#include "trainer_Blacksmithing"
		.learn Ornate Saronite Hauberk##56555
	step
		#include "trainer_Blacksmithing"
		.learn Ornate Saronite Legplates##56554
	step
		#include "trainer_Blacksmithing"
		.learn Ornate Saronite Skullshield##56556
	step
		#include "trainer_Blacksmithing"
		.learn Righteous Greaves##55304
	step
		#include "trainer_Blacksmithing"
		.learn Righteous Greaves##55311
	step
		#include "trainer_Blacksmithing"
		.learn Savage Saronite Legplates##55310
	step
		#include "trainer_Blacksmithing"
		.learn Savage Saronite Skullshield##55312
	step
		#include "trainer_Blacksmithing"
		.learn Folded Obsidium##76178
	step
		#include "trainer_Blacksmithing"
		.learn Titanium Skeleton Key##59406
	step
		#include "trainer_Blacksmithing"
		.learn Brilliant Titansteel Helm##55374
	step
		#include "trainer_Blacksmithing"
		.learn Brilliant Titansteel Treads##55377
	step
		#include "trainer_Blacksmithing"
		.learn Spiked Titansteel Helm##55372
	step
		#include "trainer_Blacksmithing"
		.learn Spiked Titansteel Treads##55375
	step
		#include "trainer_Blacksmithing"
		.learn Tempered Titansteel Helm##55373
	step
		#include "trainer_Blacksmithing"
		.learn Tempered Titansteel Treads##55376
	step
		#include "trainer_Blacksmithing"
		.learn Titansteel Bonecrusher##55370
	step
		#include "trainer_Blacksmithing"
		.learn Titansteel Destroyer##55369
	step
		#include "trainer_Blacksmithing"
		.learn Titansteel Guardian##55371
	step
		#include "trainer_Blacksmithing"
		.learn Titansteel Shanker##56234
	step
		#include "trainer_Blacksmithing"
		.learn Titansteel Shield Wall##56400
	step
		#include "trainer_Blacksmithing"
		.learn Titansteel Spellblade##63182
	step
		#include "trainer_Blacksmithing"
		.learn Hardened Obsidium Bracers##76179
	step
		#include "trainer_Blacksmithing"
		.learn Redsteel Bracers##76262
	step
		#include "trainer_Blacksmithing"
		.learn Stormforged Bracers##76280
	step
		#include "trainer_Blacksmithing"
		.learn Stormforged Gauntlets##76281
	step
		#include "trainer_Blacksmithing"
		.learn Hardened Obsidium Gauntlets##76180
	step
		#include "trainer_Blacksmithing"
		.learn Hardened Obsidium Shield##76291
	step
		#include "trainer_Blacksmithing"
		.learn Redsteel Gauntlets##76263
	step
		#include "trainer_Blacksmithing"
		.learn Hardened Obsidium Belt##76181
	step
		#include "trainer_Blacksmithing"
		.learn Redsteel Belt##76264
	step
		#include "trainer_Blacksmithing"
		.learn Stormforged Belt##76283
	step
		#include "trainer_Blacksmithing"
		.learn Decapitator's Razor##76433
	step
		#include "trainer_Blacksmithing"
		.learn Cold-Forged Shank##76434
	step
		#include "trainer_Blacksmithing"
		.learn Obsidium Bladespear##76474
	step
		#include "trainer_Blacksmithing"
		.learn Hardened Obsidium Boots##76182
	step
		#include "trainer_Blacksmithing"
		.learn Redsteel Boots##76265
	step
		#include "trainer_Blacksmithing"
		.learn Stormforged Boots##76285
	step
		#include "trainer_Blacksmithing"
		.learn Stormforged Shield##76293
	step
		#include "trainer_Blacksmithing"
		.learn Obsidium Skeleton Key##76438
	step
		#include "trainer_Blacksmithing"
		.learn Fire-Etched Dagger##76435
	step
		#include "trainer_Blacksmithing"
		.learn Hardened Obsidium Shoulders##76258
	step
		#include "trainer_Blacksmithing"
		.learn Lifeforce Hammer##76436
	step
		#include "trainer_Blacksmithing"
		.learn Obsidium Executioner##76437
	step
		#include "trainer_Blacksmithing"
		.learn Stormforged Legguards##76287
	step
		#include "trainer_Blacksmithing"
		.learn Stormforged Shoulders##76286
	step
		#include "trainer_Blacksmithing"
		.learn Redsteel Shoulders##76266
	step
		#include "trainer_Blacksmithing"
		.learn Hardened Obsidium Helm##76260
	step
		#include "trainer_Blacksmithing"
		.learn Stormforged Helm##76288
	step
		#include "trainer_Blacksmithing"
		.learn Elementium Shield Spike##76441
	step
		#include "trainer_Blacksmithing"
		.learn Hardened Obsidium Legguards##76259
	step
		#include "trainer_Blacksmithing"
		.learn Redsteel Legguards##76267
	step
		#include "trainer_Blacksmithing"
		.learn Redsteel Breastplate##76270
	step
		#include "trainer_Blacksmithing"
		.learn Hardened Obsidium Breastplate##76261
	step
		#include "trainer_Blacksmithing"
		.learn Redsteel Helm##76269
	step
		#include "trainer_Blacksmithing"
		.learn Stormforged Breastplate##76289
	step
		#include "trainer_Blacksmithing"
		.learn Ghostly Skeleton Key##122633
	step
		#include "trainer_Blacksmithing"
		.learn Ghost-Forged Bracers##122581
	step
		#include "trainer_Blacksmithing"
		.learn Ghost-Forged Belt##122583
	step
		#include "trainer_Blacksmithing"
		.learn Ghost-Forged Gauntlets##122579
	step
		#include "trainer_Blacksmithing"
		.learn Ghost-Forged Boots##122582
	step
		#include "trainer_Blacksmithing"
		.learn Ghost-Forged Legplates##122580
	step
		#include "trainer_Blacksmithing"
		.learn Ghost-Forged Shoulders##122577
	step
		#include "trainer_Blacksmithing"
		.learn Lightsteel Shield##122635
	step
		#include "trainer_Blacksmithing"
		.learn Living Steel Weapon Chain##131929
	step
		#include "trainer_Blacksmithing"
		.learn Spiritguard Shield##122636
	step
		#include "trainer_Blacksmithing"
		.learn Forgewire Axe##122637
	step
		#include "trainer_Blacksmithing"
		.learn Ghost-Forged Blade##122638
	step
		#include "trainer_Blacksmithing"
		.learn Ghost-Forged Breastplate##122578
	step
		#include "trainer_Blacksmithing"
		.learn Ghost-Forged Helm##122576
	step
		#include "trainer_Blacksmithing"
		.learn Phantasmal Hammer##122639
	step
		#include "trainer_Blacksmithing"
		.learn Ghost Shard##122641
	step
		#include "trainer_Blacksmithing"
		.learn Spiritblade Decimator##122640

//RANDOM DROPS
	step
		'This is a Random World Drop, from creatures level 5-15 and some dungeons.
		|tip We recommend Starter Area Humanoids or Ragefire Chasm for grinding.
		.collect 1 Plans: Copper Chain Vest##3609 |n
		.learn Copper Chain Vest##3321
	step
		'This is a Random World Drop, from creatures level 6-21 and some dungeons.
		|tip We recommend The Barrens or Ragefire Chasm for grinding.
		.collect 1 Plans: Gemmed Copper Gauntlets##3610 |n
		.learn Gemmed Copper Gauntlets##3325
	step
		'This is a Random World Drop, from creatures level 9-25 and some dungeons.
		|tip We recommend Wailing Caverns for grinding.
		.collect 1 Plans: Runed Copper Breastplate##2881 |n
		.learn Runed Copper Breastplate##2667
	step
		'This is a Random World Drop, from creatures level 15-34 and some dungeons.
		|tip We recommend Hillsbrad Foothills or Blackfathom Deeps for grinding.
		.collect 1 Plans: Deadly Bronze Poniard##2883 |n
		.learn Deadly Bronze Poniard##3295
	step
		'This is a Random World Drop, from creatures level 15-34 and some dungeons.
		|tip We recommend Darkshore or Gnomeregan for grinding.
		.collect 1 Plans: Silvered Bronze Breastplate##5578 |n
		.learn Silvered Bronze Breastplate##2673
	step
		'This is a Random World Drop, from creatures level 23-28 and some dungeons.
		|tip We recommend Darkshore or Gnomeregan for grinding.
		.collect 1 Plans: Silvered Bronze Shoulders##2882 |n
		.learn Silvered Bronze Shoulders##3330
	step
		'This is a Random World Drop, from creatures level 20-36 and some dungeons.
		|tip We recommend Scarlet Halls or Gnomeregan for grinding.
		.collect 1 Plans: Iridescent Hammer##5543 |n
		.learn Iridescent Hammer##6518
	step
		'This is a Random World Drop, from creatures level 20-36 and some dungeons.
		|tip We recommend The Hinterlands or Gnomeregan for grinding.
		.collect 1 Plans: Green Iron Boots##3611 |n
		.learn Green Iron Boots##3334
	step
		'This is a Random World Drop, from creatures level 20-36 and some dungeons.
		|tip We recommend Hillsbrad Foothills or Gnomeregan for grinding.
		.collect 1 Plans: Mighty Iron Hammer##3608 |n
		.learn Mighty Iron Hammer##3297
	step
		'This is a Random World Drop, from creatures level 20-36 and some dungeons.
		|tip We recommend Northern Stranglethorn or Gnomeregan for grinding.
		.collect 1 Plans: Green Iron Gauntlets##3612 |n
		.learn Green Iron Gauntlets##3336
	step
		'This is a Random World Drop, from creatures level 20-36 and some dungeons.
		|tip We recommend Northern Stranglethorn or Gnomeregan for grinding.
		.collect 1 Plans: Iron Shield Spike##6044 |n
		.learn Iron Shield Spike##7221
	step
		'This is a Random World Drop, from creatures level 20-36 and some dungeons.
		|tip We recommend Northern Stranglethorn or Gnomeregan for grinding.
		.collect 1 Plans: Silvered Bronze Leggings##10424 |n
		.learn Silvered Bronze Leggings##12259
	step
		'This is a Random World Drop, from creatures level 25-40 and some dungeons.
		|tip We recommend The Cape of Stranglethorn or Razorfen Kraul for grinding.
		.collect 1 Plans: Green Iron Shoulders##3870 |n
		.learn Green Iron Shoulders##3504
	step
		'This is a Random World Drop, from creatures level 25-42 and some dungeons.
		|tip We recommend Desolace and Maraudon for grinding.
		.collect 1 Plans: Iron Counterweight##6045 |n
		.learn Iron Counterweight##7222
	step
		'This is a Random World Drop, from creatures level 25-42 and some dungeons.
		|tip We recommend Desolace and Maraudon for grinding.
		.collect 1 Plans: Golden Iron Destroyer##3867 |n
		.learn Golden Iron Destroyer##3495
	step
		'This is a Random World Drop, from creatures level 25-42 and some dungeons.
		|tip We recommend Desolace and Maraudon for grinding.
		.collect 1 Plans: Golden Scale Leggings##3872 |n
		.learn Golden Scale Leggings##3507
	step
		'This is a Random World Drop, from creatures level 25-40 and some dungeons.
		|tip We recommend Gnomeregan and Maraudon for grinding.
		.collect 1 Plans: Golden Scale Shoulders##3871 |n
		.learn Golden Scale Shoulders##3505
	step
		'This is a Random World Drop, from creatures level 25-40 and some dungeons.
		|tip We recommend Desolace and Maraudon for grinding.
		.collect 1 Plans: Jade Serpentblade##3866 |n
		.learn Jade Serpentblade##3493
	step
		'This is a Random World Drop, from creatures level 25-46 and some dungeons.
		|tip We recommend Uldaman and Maraudon for grinding.
		.collect 1 Plans: Polished Steel Boots##3874 |n
		.learn Polished Steel Boots##3513
	step
		'This is a Random World Drop, from creatures level 30-50 and some dungeons.
		|tip We recommend Uldaman or Stratholme for grinding.
		.collect 1 Plans: Heavy Mithril Pants##7975 |n
		.learn Heavy Mithril Pants##9933
	step
		'This is a Random World Drop, from creatures level 35-50 and some dungeons.
		|tip We recommend Eastern Plaguelands or Stratholme for grinding.
		.collect 1 Plans: Mithril Shield Spike##7976 |n
		.learn Mithril Shield Spike##9939
	step
		'This is a Random World Drop, from creatures level 35-50 and some dungeons.
		|tip We recommend Tanaris or Dire Maul for grinding.
		.collect 1 Plans: Blue Glittering Axe##7992 |n
		.learn Blue Glittering Axe##9995
	step
		'This is a Random World Drop, from creatures level 35-50 and some dungeons.
		|tip We recommend Tanaris or Zul'Farrak for grinding.
		.collect 1 Plans: Wicked Mithril Blade##8029 |n
		.learn Wicked Mithril Blade##9997
	step
		'This is a Random World Drop, from creatures level 30-46 and some dungeons.
		|tip We recommend Uldaman and Maraudon for grinding.
		.collect 1 Plans: Searing Golden Blade##12261 |n
		.learn Searing Golden Blade##15973
	step
		'This is a Random World Drop, from creatures level 30-46 and some dungeons.
		|tip We recommend Dustwallow Marsh or Razorfen Downs for grinding.
		.collect 1 Plans: Steel Weapon Chain##6046 |n
		.learn Steel Weapon Chain##7224
	step
		'This is a Random World Drop, from creatures level 30-46 and some dungeons.
		|tip We recommend Uldaman or Dire Maul for grinding.
		.collect 1 Plans: Golden Scale Cuirass##3873 |n
		.learn Golden Scale Cuirass##3511
	step
		'This is a Random World Drop, from creatures level 30-46 and some dungeons.
		|tip We recommend Maraudon or Dire Maul for grinding.
		.collect 1 Plans: Frost Tiger Blade##3868 |n
		.learn Frost Tiger Blade##3497
	step
		'This is a Random World Drop, from creatures level 30-46 and some dungeons.
		|tip We recommend Maraudon or Dire Maul for grinding.
		.collect 1 Plans: Golden Scale Boots##3875 |n
		.learn Golden Scale Boots##3515
	step
		'This is a Random World Drop, from creatures level 30-46 and some dungeons.
		|tip We recommend Maraudon or Dire Maul for grinding.
		.collect 1 Plans: Shadow Crescent Axe##3869 |n
		.learn Shadow Crescent Axe##3500
	step
		'This is a Random World Drop, from creatures level 40-55 and some dungeons.
		|tip We recommend Tanaris or Stratholme for grinding.
		.collect 1 Plans: Mithril Scale Shoulders##7991 |n
		.learn Mithril Scale Shoulders##9966
	step
		'This is a Random World Drop, from creatures level 40-55 and some dungeons.
		|tip We recommend Tanaris or Zul'Farrak for grinding.
		.collect 1 Plans: Mithril Spurs##7989 |n
		.learn Mithril Spurs##9964
	step
		'This is a Random World Drop, from creatures level 40-55 and some dungeons.
		|tip We recommend Tanaris or Zul'Farrak for grinding.
		.collect 1 Plans: Dazzling Mithril Rapier##7993 |n
		.learn Dazzling Mithril Rapier##10005
	step
		'This is a Random World Drop, from creatures level 40-55 and some dungeons.
		|tip We recommend Tanaris or Zul'Farrak for grinding.
		.collect 1 Plans: Heavy Mithril Helm##7990 |n
		.learn Heavy Mithril Helm##9970
	step
		'This is a Random World Drop, from creatures level 40-55 and some dungeons.
		|tip We recommend Silithus or Zul'Farrak for grinding.
		.collect 1 Plans: Runed Mithril Hammer##8028 |n
		.learn Runed Mithril Hammer##1009
	step
		'This is a Random World Drop, from creatures level 45-60 and some dungeons.
		|tip We recommend Blasted Lands or Sunken Temple for grinding.
		.collect 1 Plans: Radiant Belt##12685 |n
		.learn Radiant Belt##16645
	step
		'This is a Random World Drop, from creatures level 45-60 and some dungeons.
		|tip We recommend Burning Steppes or Sunken Temple for grinding.
		.collect 1 Plans: Wildthorn Mail##12691 |n
		.learn Wildthorn Mail##16650
	step
		'This is a Random World Drop, from creatures level 45-60 and some dungeons.
		|tip We recommend Blackrock Depths for grinding.
		.collect 1 Plans: Radiant Breastplate##12689 |n
		.learn Radiant Breastplate##16648
	step
		'This is a Random World Drop, from creatures level 45-60 and some dungeons.
		|tip We recommend Un'Goro Crater or Blackrock Depths for grinding.
		.collect 1 Plans: Thorium Shield Spike##12692 |n
		.learn Thorium Shield Spike##16651
	step
		'This is a Random World Drop, from creatures level 45-63 and some dungeons.
		|tip We recommend Blasted Lands or Ruins of Ahn'Qiraj for grinding.
		.collect 1 Plans: Radiant Gloves##12695 |n
		.learn Radiant Gloves##16654
	step
		'This is a Random World Drop, from creatures level 50-63 and some dungeons.
		|tip We recommend Blackrock Depths or Molten Core for grinding.
		.collect 1 Plans: Dawnbringer Shoulders##12698 |n
		.learn Dawnbringer Shoulders##16660
	step
		'This is a Random World Drop, from creatures level 45-63 and some dungeons.
		|tip We recommend Silithus or Molten Core for grinding.
		.collect 1 Plans: Radiant Boots##12697 |n
		.learn Radiant Boots##16656
	step
		'This is a Random World Drop, from creatures level 40-63 and some dungeons.
		|tip We recommend Silithus or Molten Core for grinding.
		.collect 1 Plans: Radiant Circlet##12702 |n
		.learn Radiant Circlet##16659
	step
		'This is a Random World Drop, from creatures level 45-60 and some dungeons.
		|tip We recommend Blasted Lands or Sunken Temple for grinding.
		.collect 1 Plans: Radiant Belt##12685 |n
		.learn Radiant Belt##16645
	step
		'This is a Random Raid Drop from creatures level 59-63.
		|tip This will drop in Blackwing Lair, Temple of Ahn'Qiraj or Molten Core.
		.collect 1 Plans: Invulnerable Mail##12728 |n
		.learn Invulnerable Mail##16746
	step
		'This is a Random Raid Drop from creatures level 59-63.
		|tip This will drop in Blackwing Lair, Temple of Ahn'Qiraj or Molten Core.
		.collect 1 Plans: Lionheart Helm##12717 |n
		.learn Lionheart Helm##16726
	step
		'This is a Random Raid Drop from creatures level 59-63.
		|tip This will drop in Blackwing Lair, Temple of Ahn'Qiraj or Molten Core.
		.collect 1 Plans: Persuader##22390 |n
		.learn Persuader##27830
	step
		'This is a Random Raid Drop from creatures level 59-63.
		|tip This will drop in Blackwing Lair, Temple of Ahn'Qiraj or Molten Core.
		.collect 1 Plans: Sageblade##22389 |n
		.learn Sageblade##27832
	step
		'This is a Random Raid Drop from creatures level 59-63.
		|tip This will drop in Blackwing Lair, Temple of Ahn'Qiraj or Molten Core.
		.collect 1 Plans: Stronghold Gauntlets##12720 |n
		.learn Stronghold Gauntlets##16741
	step
		'This is a Random World Drop, from creatures level 45-63 and some dungeons.
		|tip We recommend Blackrock Depths or Blackwing Lair for grinding.
		.collect 1 Plans: Titanic Leggings##22388 |n
		.learn Titanic Leggings##27829
	step
		'This is a Random World Drop, from creatures level 50-63 and some dungeons.
		|tip We recommend Blasted Lands or Blackwing Lair for grinding.
		.collect 1 Plans: Whitesoul Helm##12711 |n
		.learn Whitesoul Helm##16724
	step
		'This is a Random World Drop, from creatures level 50-63 and some dungeons.
		|tip We recommend Molten Core or Blackwing Lair for grinding.
		.collect 1 Plans: Radiant Leggings##12713 |n
		.learn Radiant Leggings##16725
	step
		'This is a Random World Drop, from creatures level 61-71 and some dungeons.
		|tip We recommend The Shattered Halls or Sunwell Plateau for grinding.
		.collect 1 Plans: Black Felsteel Bracers##23626 |n
		.learn Black Felsteel Bracers##29669
	step
		'This is a Random World Drop, from creatures level 61-71 and some dungeons.
		|tip We recommend The Shattered Halls or Sunwell Plateau for grinding.
		.collect 1 Plans: Blessed Bracers##23628 |n
		.learn Blessed Bracers##29672
	step
		'This is a Random World Drop, from creatures level 61-71 and some dungeons.
		|tip We recommend The Shattered Halls or Sunwell Plateau for grinding.
		.collect 1 Plans: Bracers of the Green Fortress##23627 |n
		.learn Bracers of the Green Fortress##29671
	step
		'This is a Random World Drop, from creatures level 61-71 and some dungeons.
		|tip We recommend Sethekk Halls or Black Temple for grinding.
		.collect 1 Plans: Dirge##23636 |n
		.learn Dirge##29699
	step
		'This is a Random World Drop, from creatures level 61-71 and some dungeons.
		|tip We recommend Sethekk Halls or Black Temple for grinding.
		.collect 1 Plans: Eternium Runed Blade##23635 |n
		.learn Eternium Runed Blade##29698
	step
		'This is a Random World Drop, from creatures level 61-71 and some dungeons.
		|tip We recommend Shadowmoon Valley or Hyjal Summit for grinding.
		.collect 1 Plans: Fel Edged Battleaxe##23631 |n
		.learn Fel Edged Battleaxe##29694
	step
		'This is a Random World Drop, from creatures level 61-71 and some dungeons.
		|tip We recommend Karazhan or Black Temple for grinding.
		.collect 1 Plans: Fel Hardened Maul##23634 |n
		.learn Fel Hardened Maul##29697
	step
		'This is a Random World Drop, from creatures level 61-71 and some dungeons.
		|tip We recommend Netherstorm or Sunwell Plateau for grinding.
		.collect 1 Plans: Felfury Gauntlets##23620 |n
		.learn Felfury Gauntlets##29658
	step
		'This is a Random World Drop, from creatures level 61-71 and some dungeons.
		|tip We recommend Netherstorm or Sunwell Plateau for grinding.
		.collect 1 Plans: Felsteel Longblade##23629 |n
		.learn Felsteel Longblade##23629
	step
		'This is a Random World Drop, from creatures level 61-71 and some dungeons.
		|tip We recommend Netherstorm or Sunwell Plateau for grinding.
		.collect 1 Plans: Felsteel Reaper##23632 |n
		.learn Felsteel Reaper##29695
	step
		'This is a Random World Drop, from creatures level 61-71 and some dungeons.
		|tip We recommend Shadowmoon Valley or Sunwell Plateau for grinding.
		.collect 1 Plans: Gauntlets of the Iron Tower##23621 |n
		.learn Gauntlets of the Iron Tower##29622
	step
		'This is a Random World Drop, from creatures level 61-71 and some dungeons.
		|tip We recommend Shadowmoon Valley or Arcatraz for grinding.
		.collect 1 Plans: Hammer of Righteous Might##33954 |n
		.learn Hammer of Righteous Might##43846
	step
		'This is a Random World Drop, from creatures level 61-71 and some dungeons.
		|tip We recommend The Black Morass or Karazhan for grinding.
		.collect 1 Plans: Hand of Eternity##23637 |n
		.learn Hand of Eternity##29700
	step
		'This is a Random World Drop, from creatures level 61-71 and some dungeons.
		|tip We recommend The Botanica or Magisters' Terrace for grinding.
		.collect 1 Plans: Helm of the Stalwart Defender##23624 |n
		.learn Helm of the Stalwart Defender##29664
	step
		'This is a Random World Drop, from creatures level 61-71 and some dungeons.
		|tip We recommend The Shattered Halls or Karazhan for grinding.
		.collect 1 Plans: Khorium Champion##23630 |n
		.learn Khorium Champion##29693
	step
		'This is a Random World Drop, from creatures level 61-71 and some dungeons.
		|tip We recommend the Black Temple or Karazhan for grinding.
		.collect 1 Plans: Oathkeeper's Helm##23625 |n
		.learn Oathkeeper's Helm##29668
	step
		'This is a Random World Drop, from creatures level 61-71 and some dungeons.
		|tip We recommend the Auchenai Crypts or The Botanica for grinding.
		.collect 1 Plans: Runic Hammer##23633 |n
		.learn Runic Hammer##29696
	step
		'This is a Random World Drop, from creatures level 61-71 and some dungeons.
		|tip We recommend the Mana Tombs or Hyjal Summit for grinding.
		.collect 1 Plans: Steelgrip Gauntlets##23622 |n
		.learn Steelgrip Gauntlets##29662
	step
		'This is a Random World Drop, from creatures level 61-71 and some dungeons.
		|tip We recommend the Mana Tombs or Hyjal Summit for grinding.
		.collect 1 Plans: Storm Helm##23623 |n
		.learn Storm Helm##29663

//OTHER (UNSORTED)
	step
		'These plans are only for Alliance from completing a quest.
		.' You may be able to find these for sale on the Neutral AH.
		.collect 1 Plans: Heavy Copper Longsword##33792 |n
		.learn Heavy Copper Longsword##43549
	step
		'These plans are only for Alliance from completing a quest.
		.' You may be able to find these for sale on the Neutral AH.
		.collect 1 Plans: Ironforge Breastplate##6735 |n
		.learn Ironforge Breastplate##8367

	step
		goto Orgrimmar 76.0,35.4
		.talk Sumi##3356
		.buy 1 Plans: Pyrium Weapon Chain##66103 |n
		.learn Pyrium Weapon Chain##76442
		.buy 1 Plans: Vicious Ornate Pyrium Bracers##66125 |n
		.learn Vicious Ornate Pyrium Bracers##76465
		.buy 1 Plans: Vicious Pyrium Bracers##66117 |n
		.learn Vicious Pyrium Bracers##76456
		.buy 1 Plans: Vicious Ornate Pyrium Gauntlets##66126 |n
		.learn Vicious Ornate Pyrium Gauntlets##76466
		.buy 1 Plans: Vicious Pyrium Gauntlets##66118 |n
		.learn Vicious Pyrium Gauntlets##76457
		.buy 1 Plans: Hardened Elementium Girdle##66105 |n
		.learn Hardened Elementium Girdle##76444
		.buy 1 Plans: Light Elementium Belt##66109 |n
		.learn Light Elementium Belt##76448
		.buy 1 Plans: Vicious Ornate Pyrium Belt##66127 |n
		.learn Vicious Ornate Pyrium Belt##76467
		.buy 1 Plans: Vicious Pyrium Belt##66119 |n
		.learn Vicious Pyrium Belt##76458
		.buy 1 Plans: Elementium Deathplate##66106 |n
		.learn Elementium Deathplate##76445
		.buy 1 Plans: Hardened Elementium Hauberk##66104 |n
		.learn Hardened Elementium Hauberk##76443
		.buy 1 Plans: Light Elementium Chestguard##66108 |n
		.learn Light Elementium Chestguard##76447
		.buy 1 Plans: Elementium Bonesplitter##66113 |n
		.learn Elementium Bonesplitter##76452
		.buy 1 Plans: Elementium Gutslicer##67603 |n
		.learn Elementium Gutslicer##94718
		.buy 1 Plans: Elementium Hammer##66111 |n
		.learn Elementium Hammer##76450
		.buy 1 Plans: Vicious Ornate Pyrium Boots##66128 |n
		.learn Vicious Ornate Pyrium Boots##76468
		.buy 1 Plans: Vicious Pyrium Boots##66120 |n
		.learn Vicious Pyrium Boots##76459
		.buy 1 Plans: Elementium Earthguard##66115 |n
		.learn Elementium Earthguard##76454
		.buy 1 Plans: Elementium Stormshield##66116 |n
		.learn Elementium Stormshield##76455
		.buy 1 Plans: Elementium Poleaxe##66112 |n
		.learn Elementium Poleaxe##76451
		.buy 1 Plans: Elementium Shank##66114 |n
		.learn Elementium Shank##76453
		.buy 1 Plans: Elementium Spellblade##66110 |n
		.learn Elementium Spellblade##76449
		.buy 1 Plans: Forged Elementium Mindcrusher##67606 |n
		.learn Forged Elementium Mindcrusher##94732
		.buy 1 Plans: Vicious Ornate Pyrium Shoulders##66129 |n
		.learn Vicious Ornate Pyrium Shoulders##76469
		.buy 1 Plans: Vicious Pyrium Shoulders##66121 |n
		.learn Vicious Pyrium Shoulders##76461
		.buy 1 Plans: Ebonsteel Belt Buckle##66100 |n
		.learn Ebonsteel Belt Buckle##76439
		.buy 1 Plans: Pyrium Shield Spike##66101 |n
		.learn Pyrium Shield Spike##76440
		.buy 1 Plans: Vicious Ornate Pyrium Breastplate##66132 |n
		.learn Vicious Ornate Pyrium Breastplate##76472
		.buy 1 Plans: Vicious Ornate Pyrium Legguards##66130 |n
		.learn Vicious Ornate Pyrium Legguards##76470
		.buy 1 Plans: Vicious Pyrium Breastplate##66124 |n
		.learn Vicious Pyrium Breastplate##76464
		.buy 1 Plans: Vicious Pyrium Helm##66123 |n
		.learn Vicious Pyrium Helm##76463
		.buy 1 Plans: Vicious Pyrium Legguards##66122 |n
		.learn Vicious Pyrium Legguards##76462
	step
		goto Orgrimmar 75.8,35.2
		.talk Sumi##3356
		.collect 1 Plans: Hardened Iron Shortsword##12162 |n
		.learn Hardened Iron Shortsword##3492
		.' You can also buy them from Punra here: [Orgrimmar 45.0,77.6]
		.' You can also buy them from Zido Helmbreaker here: [Orgrimmar 36.2,83.2]
		'|talk Punra##46359
		'|talk Zido Helmbreaker##45549
	step
		goto Orgrimmar 76.6,37.6
		.talk Orokk Omosh##7790
		.' You will need to complete this quest to gain these Plans:
		|tip This is only a Horde Quest and may sell well on the Neutral AH.
		..accept Barbaric Battlements##2751
		..turnin Barbaric Battlements##2751
		.collect 1 Plans: Barbaric Iron Breastplate##7979 |n
		.learn Barbaric Iron Breastplate##9813
	step
		goto Orgrimmar 76.6,37.6
		.talk Orokk Omosh##7790
		.' You will need to complete this quest to gain these Plans:
		|tip This is only a Horde Quest and may sell well on the Neutral AH.
		..accept On Iron Pauldrons##2752
		..turnin On Iron Pauldrons##2752
		.collect 1 Plans: Barbaric Iron Shoulders##7978 |n
		.learn Barbaric Iron Shoulders##9811
	step
		goto Orgrimmar 76.6,37.6
		.talk Orokk Omosh##7790
		.' You will need to complete this quest to gain these Plans:
		|tip This is only a Horde Quest and may sell well on the Neutral AH.
		..accept Horns of Frenzy##2754
		..turnin Horns of Frenzy##2754
		.collect 1 Plans: Barbaric Iron Helm##7980 |n
		.learn Barbaric Iron Helm##9814
	step
		goto Orgrimmar 76.6,37.6
		.talk Orokk Omosh##7790
		.' You will need to complete this quest to gain these Plans:
		|tip This is only a Horde Quest and may sell well on the Neutral AH.
		..accept Trampled Under Foot##2753
		..turnin Trampled Under Foot##2753
		.collect 1 Plans: Barbaric Iron Boots##7981 |n
		.learn Barbaric Iron Boots##9818
	step
		goto Orgrimmar 76.6,37.6
		.talk Orokk Omosh##7790
		.' You will need to complete this quest to gain these Plans:
		|tip This is only a Horde Quest and may sell well on the Neutral AH.
		..accept Joys of Omosh##2755
		..turnin Joys of Omosh##2755
		.collect 1 Plans: Barbaric Iron Gloves##7982 |n
		.learn Barbaric Iron Gloves##9820



	step
		'This can only be obtained during the Feast of Winter Veil Holiday Event. This is from December 15 - Janurary 2.
		.collect 1 Smokywood Pastures Special Gift##17726 |n
		.' Open your Smokywood Pastures Special Gift |use Smokywood Pastures Special Gift##17726
		.' Or 
		.collect 1 Ticking Present##21327 |n
		.' Open your Ticking Present |use Ticking Present##21327
		.collect 1 Plans: Edge of Winter##17706 |n
		.learn Edge of Winter##21913


	step
		goto Molten Front 47.0,90.6
		.talk Damek Bloombeard##53214
		.buy 1 Plans: Brainsplinter##70166 |n
		.learn Brainsplinter##99652
		.buy 1 Plans: Elementium-Edged Scalper##70169 |n
		.learn Elementium-Edged Scalper##99655
		.buy 1 Plans: Lightforged Elementium Hammer##70168 |n
		.learn Lightforged Elementium Hammer##99654
		.buy 1 Plans: Masterwork Elementium Deathblade##70172 |n
		.learn Masterwork Elementium Deathblade##99658
		.buy 1 Plans: Masterwork Elementium Spellblade##70167 |n
		.learn Masterwork Elementium Spellblade##99653
		.buy 1 Plans: Pyrium Spellward##70170 |n
		.learn Pyrium Spellward##99656
		.buy 1 Plans: Unbreakable Guardian##70171 |n
		.learn Unbreakable Guardian##99657
		.buy 1 Plans: Witch-Hunter's Harvester##70173 |n
		.learn Witch-Hunter's Harvester##99660




	step
		goto Desolace 55.8,56.6
		.talk Muuran##8878
		.buy 1 Plans: Solid Iron Maul##10858 |n
		.learn Solid Iron Maul##3494












	step
		goto The Cape of Stranglethorn 43.0,70.6
		.talk Zarena Cromwind##2482
		.buy 1 Plans: Moonsteel Broadsword##12163 |n
		.learn Moonsteel Broadsword##3496


	step
		goto Northern Stranglethorn 43.6,23.0
		.talk Jaquilina Dramet##2483
		.buy 1 Plans: Massive Iron Axe##12164 |n
		.learn Massive Iron Axe##3498
		.' You can also purchase this from Vharr here: [Northern Stranglethorn 38.6,49.0]


	step
		goto Tanaris 51.2,30.2
		.talk Krinkle Goodsteel##5411
		.buy 1 Plans: Golden Scale Coif##6047 |n
		.learn Golden Scale Coif##3503


	step
		'These Plans are crafted by _Gnomish Engineers_. You will have to purchase this off the AH or ask to purchase in Trade Chat.
		.collect 1 Plans: Inlaid Mithril Cylinder##10713 |n
		.learn Inlaid Mithril Cylinder##11454

	step	
		goto Dustwallow Marsh 77.0,18.6
		.from Strashaz Myrmidon##4368+
		.collect 1 Plans: Runic Breastplate##12718 |n
		.learn Runic Breastplate##16731

	step
		goto Swamp of Sorrows 47.2,52.2
		.talk Gharash##8176
		.buy 1 Plans: Mithril Scale Bracers##7995 |n
		.learn Mithril Scale Bracers##9937

	step
		goto Western Plaguelands 68.0,77.6
		.talk Magnus Frostwake##11278
		.buy 1 Plans: Storm Gauntlets##12703 |n
		.learn Storm Gauntlets##16661
		.buy 1 Plans: Ebon Shiv##8030 |n
		.learn Ebon Shiv##10013


	step
		goto Burning Steppes 20.2,41.2
		.from Volchan##10119
		|tip He is a Rare Elite but doesn't path far, so you may not find him on your first visit.
		.collect 1 Plans: Volcanic Hammer##12828 |n
		.learn Volcanic Hammer##16984





	step
		goto Stratholme 25.2,45.6
		.from Risen Defender##10421, Risen Initiate##10420, Risen Priest##10423
		.collect 1 Plans: Serenity##12827 |n
		.learn Serenity##16983
	step
		goto Stratholme 59.0,44.6
		.from Shrieking Banshee##10463, Wailing Banshee##10464
		.collect 1 Plans: Phantom Blade##74274 |n
		.learn Phantom Blade##10007
	step
		goto Stratholme/2 68.8,26.2
		.from Ghoul Ravener##10406
		.collect 1 Plans: Corruption##12830 |n
		.learn Corruption##16985
	step
		goto Stratholme/2 67.8,20.4
		.from Maleki the Pallid##10438
		.collect 1 Plans: Hammer of the Titans##12833 |n
		.learn Hammer of the Titans##16988
	step
		goto Stratholme/1 4.4,51.8
		.from Willey Hopebreaker##10997
		.collect 1 Plans: Heartseeker##12839 |n
		.learn Heartseeker##16995

	step
		goto Tirisfal Glades 83.2,68.0
		.talk Argent Quartermaster Hasana##10856
		|tip You must be Honored with the Argent Dawn to purchase this Plan.
		.buy 1 Plans: Girdle of the Dawn##19203 |n
		.learn Girdle of the Dawn##23632
		.' You can also purchase this Plan from Quartermaster Miranda Breechlock here: [Eastern Plaguelands 75.8,54.0]
		'|talk Quartermaster Miranda Breechlock##11536
	step
		goto Felwood 64.8,5.2
		.talk Meilosh##11557
		|tip You must be Honored with Timbermaw Hold to purchase this Plan. 
		.collect 1 Plans: Heavy Timbermaw Belt##19202 |n
		.learn Heavy Timbermaw Belt##23628













	step
		goto Blackrock Depths 50.6,62.8
		.talk Grizzle##9028
		.collect 1 Plans: Dark Iron Pulverizer##11610 |n
		.learn Dark Iron Pulverizer##15292
	step
		goto Blackrock Depths 37.8,70.8
		.from Weapon Technician##8920
		.collect 1 Plans: Dark Iron Mail##11614 |n
		.learn Dark Iron Mail##15293
	step
		goto Blackrock Depths/2 53.4,62.4
		.from Hammered Patron##9554
		.collect 1 Plans: Dark Iron Sunderer##11611 |n
		.learn Dark Iron Sunderer##15294
	step
		goto Blackrock Depths/2 36.8,66.0
		.click Plans: Dark Iron Shoulders##525
		.collect 1 Plans: Dark Iron Shoulders##11615 |n
		.learn Dark Iron Shoulders##15295
	step
		goto Blackrock Depths/2 49.0,61.8
		.from Ribbly Screwspigot##9543
		.collect 1 Plans: Dark Iron Plate##11612 |n
		.learn Dark Iron Plate##15296
	step
		goto Blackrock Depths/2 50.6,59.2
		.talk Lokhtos Darkbargainer##12944
		|tip You need to be Exalted with the Thorium Brotherhood to purchase this Plan.
		.buy 1 Plans: Blackguard##19211 |n
		.learn Blackguard##23652
		.buy 1 Plans: Dark Iron Leggings##17052 |n
		.learn Dark Iron Leggings##20876
		.buy 1 Plans: Ebon Hand##19210 |n
		.learn Ebon Hand##23650
		.buy 1 Plans: Dark Iron Boots##20040 |n
		.learn Dark Iron Boots##24399
		.buy 1 Plans: Nightfall##19212 |n
		.learn Nightfall##23653
	step
		goto Blackrock Depths/2 50.6,59.2
		.talk Lokhtos Darkbargainer##12944
		|tip You need to be Revered with the Thorium Brotherhood to purchase this Plan.
		.buy 1 Plans: Fiery Chain Shoulders##17053 |n
		.learn Fiery Chain Shoulders##20873
		.buy 1 Plans: Dark Iron Gauntlets##19207 |n
		.learn Dark Iron Gauntlets##23637
		.buy 1 Plans: Blackfury##19209 |n
		.learn Blackfury##23639
		.buy 1 Plans: Black Amnesty##19208 |n
		.learn Black Amnesty##23638
	step
		goto Blackrock Depths/2 50.6,59.2
		.talk Lokhtos Darkbargainer##12944
		|tip You need to be Honored with the Thorium Brotherhood to purchase this Plan.
		.buy 1 Plans: Dark Iron Destroyer##17060 |n
		.learn Dark Iron Destroyer##20897
		.buy 1 Plans: Dark Iron Helm##19206 |n
		.learn Dark Iron Helm##23636
		.buy 1 Plans: Dark Iron Reaver##17059 |n
		.learn Dark Iron Reaver##20890
		.buy 1 Plans: Fiery Chain Girdle##17049 |n
		.learn Fiery Chain Girdle##20872
	step
		goto Blackrock Depths/2 50.6,59.2
		.talk Lokhtos Darkbargainer##12944
		|tip You need to be Friendly with the Thorium Brotherhood to purchase this Plan.
		.buy 1 Plans: Dark Iron Bracers##17051 |n
		.learn Dark Iron Bracers##20874
	step
		.' You must have a Sulfuron Ingot in your inventory to pick up this quest.
		goto Blackrock Depths/2 50.3,58.5
		.talk Lokhtos Darkbargainer##12944
		.' Tell him: Hrm, I'm listening.
		.collect Thorium Brotherhood Contract##18628 |use Thorium Brotherhood Contract##18628
		..accept A Binding Contract##7604
		..turnin A Binding Contract##7604
		.collect 1 Plans: Sulfuron Hammer##18592 |n
		.learn Sulfuron Hammer##21161


	step
		goto Blackrock Spire/5 53.8,84.8
		.from Quartermaster Zigris##9736+
		.collect 1 Plans: Annihilator##12835 |n
		.learn Annihilator##16991
	step
		goto Blackrock Spire/7 29.1,26.4
		.from Goraluk Anvilcrack##10899
		.collect 1 Plans: Arcanite Champion##12834 |n
		.learn Arcanite Champion##16990
	step
		goto Blackrock Spire/7 29.1,26.4
		.from Goraluk Anvilcrack##10899
		.buy 1 Plans: Masterwork Stormhammer##12837 |n
		.learn Masterwork Stormhammer##16993
	step
		goto Blackrock Spire/1 48.7,51.8
		.from Bannok Grimaxe##9596
		|tip He is a rare spawn, you may have to reset the dungeon a few times before you will find him.
		.collect 1 Plans: Arcanite Reaper##12838 |n
		.learn Arcanite Reaper##16994






	step
		goto Ruins of Ahn'Qiraj 31.6,37.6
		.from Moam##15340
		.collect 1 Plans: Black Grasp of the Destroyer##22220 |n
		.learn Black Grasp of the Destroyer##27589
	step
		goto Ruins of Ahn'Qiraj 57.6,39.4
		.talk Lieutenant General Andorov##15471
		.buy 1 Plans: Jagged Obsidian Shield##22219 |n
		.learn Jagged Obsidian Shield##27586
	step
		goto Ruins of Ahn'Qiraj 57.6,39.4
		.talk Lieutenant General Andorov##15471
		|tip You must keep him alive during the boss fight to purchase from him.
		.buy 1 Plans: Obsidian Mail Tunic##22221 |n
		.learn Obsidian Mail Tunic##27590
	step
		goto Ahn'Qiraj/2 44.8,46.6
		.from The Prophet Skeram##15263+
		.collect 1 Plans: Thick Obsidian Breastplate##22222 |n
		.learn Thick Obsidian Breastplate##27587











	step
		goto Winterspring 58.0,63.8
		.talk Daleohm##50129
		.buy 1 Plans: Frostguard##12836 |n
		.learn Frostguard##16992
	step
		goto Tirisfal Glades 83.2,68.0
		.talk Argent Quartermaster Hasana##10856
		.buy 1 Plans: Gloves of the Dawn##19205 |n
		.learn Gloves of the Dawn##23633
		.' You can also purchase this Plan from Quartermaster Miranda Breechlock here [Eastern Plaguelands 75.8,54.0]
		'|talk Quartermaster Miranda Breechlock##11536


	step
		goto Felwood 64.8,5.2
		.talk Meilosh##11557
		|tip You must be Revered with Timbermaw Hold to purchase this Plan.
		.buy 1 Plans: Heavy Timbermaw Boots##19204 |n
		.learn Heavy Timbermaw Boots##23629




	step
		.' To obtain this bag with a chance to drop this recipe, you will need to first use our Leveling Guide of Silithus.
		.' Do all the quests of Hermit Ortell until you can do the following quest. Once completed you can turn in Twilight Text's for the Clippings.
		goto Silithus 68.6,63.0
		.talk Hermit Ortell##15194
		..accept True Believers##8323
		..turnin True Believers##8323
		.collect 1 Decoded True Believer Clippings##20469 |n
		.' Open the Decoded True Believer Clippings in your bags |use Decoded True Believer Clippings##20469
		.collect 1 Plans: Darkrune Breastplate##20554 |n
		.learn Darkrune Breastplate##24914
	step
		.' To obtain this bag with a chance to drop this recipe, you will need to first use our Leveling Guide of Silithus.
		.' Do all the quests of Hermit Ortell until you can do the following quest. Once completed you can turn in Twilight Text's for the Clippings.
		goto Silithus 68.6,63.0
		.talk Hermit Ortell##15194
		..accept True Believers##8323
		..turnin True Believers##8323
		.collect 1 Decoded True Believer Clippings##20469 |n
		.' Open the Decoded True Believer Clippings in your bags |use Decoded True Believer Clippings##20469
		.collect 1 Plans: Darkrune Gauntlets##20553 |n
		.learn Darkrune Gauntlets##24912
	step
		.' To obtain this bag with a chance to drop this recipe, you will need to first use our Leveling Guide of Silithus.
		.' Do all the quests of Hermit Ortell until you can do the following quest. Once completed you can turn in Twilight Text's for the Clippings.
		goto Silithus 68.6,63.0
		.talk Hermit Ortell##15194
		..accept True Believers##8323
		..turnin True Believers##8323
		.collect 1 Decoded True Believer Clippings##20469 |n
		.' Open the Decoded True Believer Clippings in your bags |use Decoded True Believer Clippings##20469
		.collect 1 Plans: Darkrune Helm##20555 |n
		.learn Darkrune Helm##24913
	step
		goto Silithus 54.8,36.6
		.talk Vargus##15176
		.buy 1 Plans: Ironvine Belt##22768 |n
		.learn Ironvine Belt##28463
	step
		goto Silithus 54.8,36.6
		.talk Vargus##15176
		.buy 1 Plans: Ironvine Breastplate##22766 |n
		.learn Ironvine Breastplate##28461
	step
		goto Silithus 54.8,36.6
		.talk Vargus##15176
		.buy 1 Plans: Ironvine Gloves##22767 |n
		.learn Ironvine Gloves##28462
	step
		goto Silithus 54.8,36.6
		.talk Vargus##15176
		.buy 1 Plans: Light Obsidian Belt##22214 |n
		.learn Light Obsidian Belt##27588
	step
		goto Silithus 54.8,36.6
		.talk Vargus##15176
		.buy 1 Plans: Heavy Obsidian Belt##22209 |n
		.learn Heavy Obsidian Belt##27585






	step
		goto Un'Goro Crater 43.4,41.6
		.talk Dramm Riverhorn##38561
		.buy 1 Plans: Runic Plate Boots##12707 |n
		.learn Runic Plate Boots##16665
	step
		goto Un'Goro Crater 43.4,41.6
		.talk Dramm Riverhorn ##38561
		.buy 1 Plans: Runic Plate Helm##12714 |n
		.learn Runic Plate Helm##16726
	step
		goto Un'Goro Crater 43.4,41.6
		.talk Dramm Riverhorn ##38561
		.buy 1 Plans: Runic Plate Leggings##12719 |n
		.learn Runic Plate Leggings##16732
	step
		goto Un'Goro Crater 43.4,41.6
		.talk Dramm Riverhorn ##38561
		.buy 1 Plans: Runic Plate Shoulders##12706 |n
		.learn Runic Plate Shoulders##16664

//OUTLAND
	step
		goto Shattrath City 64.0,71.6
		.talk Aaron Hollman##19662
		.buy 1 Plans: Adamantite Cleaver##23591 |n
		.learn Adamantite Cleaver##29568
		.buy 1 Plans: Adamantite Dagger##23592 |n
		.learn Adamantite Dagger##29569
		.buy 1 Plans: Adamantite Rapier##23593 |n
		.learn Adamantite Rapier##29571
		.buy 1 Plans: Adamantite Maul##23590 |n
		.learn Adamantite Maul##29566
		.' You can also purchase this Plan from Eriden here [Silvermoon City 80.6,37.0]
		'|talk Eriden##16670
	step
		goto Magisters' Terrace 8.6,50.6
		.talk Kael'thas Sunstrider##24664
		.collect 1 Plans: Adamantite Weapon Chain##35296 |n
		.learn Adamantite Weapon Chain##42688
	step
		goto Shadowmoon Valley 29.2,31.0
		.talk Krek Cragcrush##19342
		.buy 1 Plans: Adamantite Plate Bracers##23594 |n
		.learn Adamantite Plate Bracers##29603
		.buy 1 Plans: Adamantite Plate Gloves##23595 |n
		.learn Adamantite Plate Gloves##29605
	step
		goto Hellfire Peninsula 53.2,38.2
		.talk Rohok##16583
		.buy 1 Plans: Lesser Ward of Shielding##23638 |n
		.learn Lesser Ward of Shielding##29728

	step
		goto Shadowmoon Valley 29.2,31.0
		.talk Krek Cragcrush##19342
		.buy 1 Plans: Adamantite Breastplate##23596 |n
		.learn Adamantite Breastplate##29606
	step
		goto Zangarmarsh 79.2,63.8
		.talk Fedryen Swiftspear##17904
		.buy 1 Plans: Adamantite Sharpening Stone##23618 |n
		.learn Adamantite Sharpening Stone##29656
		.buy 1 Plans: Adamantite Weightstone##28632 |n
		.learn Adamantite Weightstone##34608
		.buy 1 Plans: Greater Rune of Warding##25526 |n
		.learn Greater Rune of Warding##32285

	step
		goto Shattrath City 48.0,26.6
		.talk Quartermaster Endarin ##19321
		|tip You must be Friendly with The Aldor to purchase this Plan.
		.buy 1 Plans: Flamebane Bracers##23601 |n
		.learn Flamebane Bracers##29614

	step
		goto Shattrath City 60.6,64.2
		.talk Quartermaster Enuril##19331
		|tip You must be Friendly with The Scryers to purchase this Plan.
		.buy 1 Plans: Enchanted Adamantite Belt##23597 |n
		.learn Enchanted Adamantite Belt##29608
	step
		goto Shattrath City 60.6,64.2
		.talk Quartermaster Enuril##19331
		|tip You must be Exalted with The Scryers to purchase this Plan.
		.buy 1 Plans: Enchanted Adamantite Boots##23598 |n
		.learn Enchanted Adamantite Boots##29611
		.buy 1 Plans: Enchanted Adamantite Leggings##23600 |n
		.learn Enchanted Adamantite Leggings##29613
	step
		goto Shattrath City 48.0,26.6
		.talk Quartermaster Endarin##19321
		|tip You must be Exalted with The Aldor to purchase this Plan.
		.buy 1 Plans: Flamebane Helm##23602 |n
		.learn Flamebane Helm##29615
	step
		goto Shattrath City 48.0,26.6
		.talk Quartermaster Endarin##19321
		|tip You must be Revered with The Aldor to purchase this Plan.
		.buy 1 Plans: Flamebane Breastplate##23604 |n
		.learn Flamebane Breastplate##29617
	step
		goto Shattrath City 60.6,64.2
		.talk Quartermaster Enuril##19331
		|tip You must be Revered with The Scryers to purchase this Plan.
		.buy 1 Plans: Enchanted Adamantite Breastplate##23599 |n
		.learn Enchanted Adamantite Breastplate##29610
	step
		goto Shattrath City 48.0,26.6
		.talk Quartermaster Endarin##19321
		|tip You must be Honored with The Aldor to purchase this Plan.
		.buy 1 Plans: Flamebane Gloves##23603 |n
		.learn Flamebane Gloves##29616
	step
		goto Auchenai Crypts/2 44.8,19.4
		.from Auchenai Monk##18497
		.collect 1 Plans: Felsteel Gloves##23605 |n
		.learn Felsteel Gloves##29619
	step
		goto The Arcatraz/3 52.4,30.8
		.from Unchained Doombringer##20900
		.collect 1 Plans: Felsteel Leggings##23606 |n
		.learn Felsteel Leggings##29620
	step
		goto Nagrand 33.2,44.4
		.from Murkblood Raider##18203
		.collect 1 Plans: Khorium Belt##23608 |n
		.learn Khorium Belt##29628
	step
		goto Shadowmoon Valley 39.8,38.6
		.from Deathforge Guardian##20878
		.collect 1 Plans: Khorium Pants##23609 |n
		.learn Khorium Pants##29629
	step
		goto Hellfire Peninsula 54.8,37.8
		.talk Quartermaster Urgronn##17585
		.buy 1 Plans: Felsteel Shield Spike##24002 |n
		.learn Felsteel Shield Spike##29657


	step
		goto Netherstorm 34.0,52.8
		.from Disembodied Protector##18873
		.collect 1 Plans: Khorium Boots##23610 |n
		.learn Khorium Boots##29630
	step
		goto Nagrand 51.4,57.4
		.from Boulderfist Warrior##17136
		.collect 1 Plans: Ragesteel Gloves##23611 |n
		.learn Ragesteel Gloves##29642
		.' You can find more Ogres here [40.8,31.4]
	step
		goto Shadowmoon Valley 49.0,48.0
		.from Enraged Earth Spirit##21050+, Enraged Fire Spirit##21061+
		.collect 1 Plans: Ragesteel Shoulders##33174 |n
		.learn Ragesteel Shoulders##42662

	step
		goto The Botanica 25.8,24.8
		.from High Botanist Freywinn##17975
		.collect 1 Plans: Earthpeace Breastplate##23617 |n
		.learn Earthpeace Breastplate##29649
	step
		goto Shadowmoon Valley 73.4,88.2
		.from Ashtongue Warrior##21454+, Crazed Murkblood Foreman##23305+, Crazed Murkblood Miner##23324+
		.collect 1 Plans: Ragesteel Breastplate##23613 |n
		.learn Ragesteel Breastplate##29645
	step
		goto Mana-Tombs 54.4,87.2
		.from Nexus Stalker##18314+
		.collect 1 Plans: Swiftsteel Gloves##23615 |n
		.learn Swiftsteel Gloves##29648
	step	
		goto Netherstorm 26.8,68.2
		.from Sunfury Bloodwarder##18853
		.collect 1 Plans: Greater Ward of Shielding##23639 |n
		.learn Greater Ward of Shielding##29729


	step
		goto Karazhan 43.0,75.2
		.talk Koren##16388
		.buy 1 Plans: Iceguard Breastplate##31393 |n
		.learn ceguard Breastplate##38477
		.buy 1 Plans: Iceguard Helm##31395 |n
		.learn Iceguard Helm##38479
		.buy 1 Plans: Iceguard Leggings##31394 |n
		.learn Iceguard Leggings##38478

	step
		goto Black Temple 61.6,51.0
		.talk Okuno##23159
		|tip You must be Friendly with Ashtongue Deathsworn to purchase this Plan.
		.buy 1 Plans: Shadesteel Bracers##32442 |n
		.learn Shadesteel Bracers##40034
		.buy 1 Plans: Shadesteel Girdle##32444 |n
		.learn Shadesteel Girdle##40036
	step
		goto Black Temple 61.6,51.0
		.talk Okuno##23159
		|tip You must be Honored with Ashtongue Deathsworn to purchase this Plan.
		.buy 1 Plans: Shadesteel Greaves##32443 |n
		.learn Shadesteel Greaves##40035
		.buy 1 Plans: Shadesteel Sabots##32441 |n
		.learn Shadesteel Sabots##40033

	step
		goto Zangarmarsh 79.2,63.8
		.talk Fedryen Swiftspear##17904
		|tip You must be Exalted with Cenarion Expedition to purchase this Plan.
		.buy 1 Plans: Wildguard Breastplate##31390 |n
		.learn Wildguard Breastplate##38473
	step
		goto Zangarmarsh 79.2,63.8
		.talk Fedryen Swiftspear##17904
		|tip You must be Revered with Cenarion Expedition to purchase this Plan.
		.buy 1 Plans: Wildguard Helm##31392 |n
		.learn Wildguard Helm##38476
		.buy 1 Plans: Wildguard Leggings##31391 |n
		.learn Wildguard Leggings##38475

//NORTHREND
	step
		goto Dragonblight 86.0,35.8
		.from Onslaught Mason##27333
		.collect 1 Plans: Reinforced Cobalt Shoulders##41124 |n
		.learn Reinforced Cobalt Shoulders##54978
	step
		goto Grizzly Hills 68.4,16.0
		.from Iron Rune-Shaper##26270
		.collect 1 Plans: Reinforced Cobalt Helm##41123 |n
		.learn Reinforced Cobalt Helm##54979
	step
		goto Zul'Drak 75.8,33.6
		.from Gundrak Savage##29235
		.collect 1 Plans: Reinforced Cobalt Legplates##41120 |n
		.learn Reinforced Cobalt Legplates##54980
	step
		goto Sholazar Basin 35.6,48.6
		.from Venture Co. Excavator##28123
		.collect 1 Plans: Reinforced Cobalt Chestpiece##41122 |n
		.learn Reinforced Cobalt Chestpiece##54981
	step
		goto Borean Tundra 41.4,53.6
		.talk Gara Skullcrush##32565
		|tip You must be Exalted with the Warsong Offensive to purchase this Plan.
		.buy 1 Plans: Titanium Plating##44938 |n
		.learn Titanium Plating##62202
		.' You can also purchase this from Sebastian Crane here [Howling Fjord 79.0,30.0]
		|tip You must be Exalted with The Hand of Vengeance to purchase this Plan.



	step
		goto Icecrown Citadel/1 36.8,20.6
		.talk Alchemist Finklestein##37687
		|tip You must be Revered with The Ashen Verdict to purchase this Plan.
		.buy 1 Plans: Legplates of Painful Death##49971 |n
		.learn Legplates of Painful Death##70565
		.buy 1 Plans: Pillars of Might##49973 |n
		.learn Pillars of Might##70567
	step
		goto Icecrown Citadel/1 36.8,20.6
		.talk Alchemist Finklestein##37687
		|tip You must be Honored with The Ashen Verdict to purchase this Plan.
		.buy 1 Plans: Protectors of Life##49970 |n
		.learn Protectors of Life##70563
		.buy 1 Plans: Puresteel Legplates##49969 |n
		.learn Puresteel Legplates##70562

//PANDARIA
	step
		goto Shrine of Two Moons 59.0,14.6
		.talk Jorunga Stonehoof##64058
		.buy 1 Plans: Contender's Revenant Belt##84158 |n
		.learn Contender's Revenant Belt##122623
		.buy 1 Plans: Contender's Revenant Boots##84159 |n
		.learn Contender's Revenant Boots##122622
		.buy 1 Plans: Contender's Revenant Bracers##84160 |n
		.learn Contender's Revenant Bracers##122621
		.buy 1 Plans: Contender's Revenant Breastplate##84161 |n
		.learn Contender's Revenant Breastplate##122618
		.buy 1 Plans: Contender's Revenant Gauntlets##84162 |n
		.learn Contender's Revenant Gauntlets##122619
		.buy 1 Plans: Contender's Revenant Helm##84163 |n
		.learn Contender's Revenant Helm##122616
		.buy 1 Plans: Contender's Revenant Legplates##84164 |n
		.learn Contender's Revenant Legplates##122620
		.buy 1 Plans: Contender's Revenant Shoulders##84165 |n
		.learn Contender's Revenant Shoulders##122617
		.buy 1 Plans: Contender's Spirit Belt##84166 |n
		.learn Contender's Spirit Belt##122631
		.buy 1 Plans: Contender's Spirit Boots##84167 |n
		.learn Contender's Spirit Boots##122630
		.buy 1 Plans: Contender's Spirit Bracers##84168 |n
		.learn Contender's Spirit Bracers##122629
		.buy 1 Plans: Contender's Spirit Breastplate##84169 |n
		.learn Contender's Spirit Breastplate##122626
		.buy 1 Plans: Contender's Spirit Gauntlets##84170 |n
		.learn Contender's Spirit Gauntlets##122627
		.buy 1 Plans: Contender's Spirit Helm##84171 |n
		.learn Contender's Spirit Helm##122624
		.buy 1 Plans: Contender's Spirit Legplates##84172 |n
		.learn Contender's Spirit Legplates##122628
		.buy 1 Plans: Contender's Spirit Shoulders##84173 |n
		.learn Contender's Spirit Shoulders##122625
		.buy 1 Plans: Masterwork Spiritguard Belt##84219 |n
		.learn Masterwork Spiritguard Belt##122599
		.buy 1 Plans: Masterwork Spiritguard Boots##84220 |n
		.learn Masterwork Spiritguard Boots##122598
		.buy 1 Plans: Masterwork Spiritguard Bracers##84221 |n
		.learn Masterwork Spiritguard Bracers##122597
		.buy 1 Plans: Masterwork Spiritguard Breastplate##84222 |n
		.learn Masterwork Spiritguard Breastplate##122594
		.buy 1 Plans: Masterwork Spiritguard Gauntlets##84223 |n
		.learn Masterwork Spiritguard Gauntlets##122595
		.buy 1 Plans: Masterwork Spiritguard Helm##84224 |n
		.learn Masterwork Spiritguard Helm##122592
		.buy 1 Plans: Masterwork Spiritguard Legplates##84225 |n
		.learn Masterwork Spiritguard Legplates##122596
		.buy 1 Plans: Masterwork Spiritguard Shoulders##84227 |n
		.learn Masterwork Spiritguard Shoulders##122593
		.buy 1 Plans: Masterwork Forgewire Axe##84197 |n
		.learn Masterwork Forgewire Axe##122644
		.buy 1 Plans: Masterwork Spiritblade Decimator##84218 |n
		.learn Masterwork Spiritblade Decimator##122647
		.buy 1 Plans: Masterwork Spiritguard Shield##84226 |n
		.learn Masterwork Spiritguard Shield##122643
	step
		goto Dread Wastes 55.0,35.6
		.talk Ambersmith Zikk##64599
		.buy 1 Plans: Ghost Iron Shield Spike##90531 |n |tip You must be Honored with The Klaxxi to purchase this Plan.
		.learn Ghost Iron Shield Spike##131928 |tip You must be Honored with The Klaxxi to purchase this Plan.
		.buy 1 Plans: Masterwork Ghost Shard##84198 |n
		.learn Masterwork Ghost Shard##122648
		.buy 1 Plans: Masterwork Ghost-Forged Blade##84200 |n
		.learn Masterwork Ghost-Forged Blade##122645
		.buy 1 Plans: Masterwork Lightsteel Shield##84208 |n
		.learn Masterwork Lightsteel Shield##122642
		.buy 1 Plans: Masterwork Phantasmal Hammer##84217 |n
		.learn Masterwork Phantasmal Hammer##122646
		.buy 1 Plans: Breastplate of Ancient Steel##83791 |n
		.learn Breastplate of Ancient Steel##122653
		.buy 1 Plans: Gauntlets of Ancient Steel##83792 |n
		.learn Gauntlets of Ancient Steel##122654
		.buy 1 Plans: Ghost Reaver's Breastplate##83787 |n
		.learn Ghost Reaver's Breastplate##122649
		.buy 1 Plans: Ghost Reaver's Gauntlets##83788 |n
		.learn Ghost Reaver's Gauntlets##122650
		.buy 1 Plans: Living Steel Breastplate##83789 |n
		.learn Living Steel Breastplate##122651
		.buy 1 Plans: Living Steel Gauntlets##83790 |n
		.learn Living Steel Gauntlets##122652
		.buy 1 Plans: Living Steel Belt Buckle##84196 |n
		.learn Living Steel Belt Buckle##122632

//RAIDS/DUNGEONS
	step
		'This is a Random Raid Drop from creatures level 59-63.
		|tip This will drop in Blackwing Lair, Temple of Ahn'Qiraj or Molten Core.
		.collect 1 Plans: Helm of the Great Chief##12716 |n
		.learn Helm of the Great Chief##16728
	step
		'This Plan drops from the Bosses of Molten Core.
		.collect 1 Plans: Elemental Sharpening Stone##18264 |n
		.learn Elemental Sharpening Stone##22757
	step
		'These are random raid drops from Mogu'shan Vaults, Terrace of Endless Spring and Heart of Fear.
		|tip These are MoP Raids.
		.collect 1 Plans: Bloodforged Warfists##87411 |n
		.learn Bloodforged Warfists##126853
	step
		'These are random raid drops from Mogu'shan Vaults, Terrace of Endless Spring and Heart of Fear.
		|tip These are MoP Raids.
		.collect 1 Plans: Chestplate of Limitless Faith##87412 |n
		.learn Chestplate of Limitless Faith##126854
	step
		'These are random raid drops from Mogu'shan Vaults, Terrace of Endless Spring and Heart of Fear.
		|tip These are MoP Raids.
		.collect 1 Plans: Gauntlets of Battle Command##87409 |n
		.learn Gauntlets of Battle Command##126851
	step
		'These are random raid drops from Mogu'shan Vaults, Terrace of Endless Spring and Heart of Fear.
		|tip These are MoP Raids.
		.collect 1 Plans: Gauntlets of Unbound Devotion##87413 |n
		.learn Gauntlets of Unbound Devotion##126855
	step
		'These are random raid drops from Mogu'shan Vaults, Terrace of Endless Spring and Heart of Fear.
		|tip These are MoP Raids.
		.collect 1 Plans: Ornate Battleplate of the Master##87410 |n
		.learn Ornate Battleplate of the Master##126852
	step
		'These are random raid drops from Mogu'shan Vaults, Terrace of Endless Spring and Heart of Fear.
		|tip These are MoP Raids.
		.collect 1 Plans: Unyielding Bloodplate##87408 |n
		.learn Unyielding Bloodplate##126850
	step
		'This is a random world drop but only in the Firelands area.
		.collect 1 Plans: Emberforged Elementium Boots##69970 |n
		.learn Emberforged Elementium Boots##99454
	step
		'This is a random world drop but only in the Firelands area.
		.collect 1 Plans: Eternal Elementium Handguards##69958 |n
		.learn Eternal Elementium Handguards##99440
	step
		'This is a random world drop but only in the Firelands area.
		.collect 1 Plans: Fists of Fury##69957 |n
		.learn Fists of Fury##99439
	step
		'This is a random world drop but only in the Firelands area.
		.collect 1 Plans: Holy Flame Gauntlets##69959 |n
		.learn Holy Flame Gauntlets##99441
	step
		'This is a random world drop but only in the Firelands area.
		.collect 1 Plans: Mirrored Boots##69969 |n
		.learn Mirrored Boots##99453
	step
		'This is a random world drop but only in the Firelands area.
		.collect 1 Plans: Warboots of Mighty Lords##69968 |n
		.learn Warboots of Mighty Lords##99452
	step
		'This is a random world drop but only in Dragon Soul.
		.collect 1 Plans: Bracers of Destructive Strength##72015 |n
		.learn Bracers of Destructive Strength##101931
	step
		'This is a random world drop but only in Dragon Soul.
		.collect 1 Plans: Foundations of Courage##72013 |n
		.learn Foundations of Courage##101928
	step
		'This is a random world drop but only in Dragon Soul.
		.collect 1 Plans: Pyrium Legplates of Purified Evil##72001 |n
		.learn Pyrium Legplates of Purified Evil##101924
	step
		'This is a random world drop but only in Dragon Soul.
		.collect 1 Plans: Soul Redeemer Bracers##72014 |n
		.learn Soul Redeemer Bracers##101929
	step
		'This is a random world drop but only in Dragon Soul.
		.collect 1 Plans: Titanguard Wristplates##72016 |n
		.learn Titanguard Wristplates##101932
	step
		'This is a random world drop but only in Dragon Soul.
		.collect 1 Plans: Unstoppable Destroyer's Legplates##72012 |n
		.learn Unstoppable Destroyer's Legplates##101925
	step
		'This Plan is dropped from the Boss NPC's of Trial of the Crusader.
		.collect 1 Plans: Breastplate of the White Knight##47640 |n
		.learn Breastplate of the White Knight##67130
	step	
		'This Plan is dropped from the Boss NPC's of Trial of the Crusader.
		.collect 1 Plans: Saronite Swordbreakers##47641 |n
		.learn Saronite Swordbreakers##67131
	step
		'This Plan is dropped from the Boss NPC's of Trial of the Crusader.
		.collect 1 Plans: Sunforged Bracers##47627 |n
		.learn Sunforged Bracers##67135
	step
		'This Plan is dropped from the Boss NPC's of Trial of the Crusader.
		.collect 1 Plans: Sunforged Breastplate##47643 |n
		.learn Sunforged Breastplate##67134
	step
		'This Plan is dropped from the Boss NPC's of Trial of the Crusader.
		.collect 1 Plans: Titanium Razorplate##67644 |n
		.learn Titanium Razorplate##67132
	step
		'This Plan is dropped from the Boss NPC's of Trial of the Crusader.
		.collect 1 Plans: Titanium Spikeguards##47645 |n
		.learn Titanium Spikeguards##67133
	step
		'This Plan is dropped from the Boss NPC's of Ulduar.
		.collect 1 Plans: Battlelord's Plate Boots##45089 |n
		.learn Battlelord's Plate Boots##63188
	step
		'This Plan is dropped from the Boss NPC's of Ulduar.
		.collect 1 Plans: Belt of the Titans##45088 |n
		.learn Belt of the Titans##63187
	step
		'This Plan is dropped from the Boss NPC's of Ulduar.
		.collect 1 Plans: Indestructible Plate Girdle##45092 |n
		.learn Indestructible Plate Girdle##63191
	step
		'This Plan is dropped from the Boss NPC's of Ulduar.
		.collect 1 Plans: Plate Girdle of Righteousness##45090 |n
		.learn Plate Girdle of Righteousness##63189
	step
		'This Plan is dropped from the Boss NPC's of Ulduar.
		.collect 1 Plans: Spiked Deathdealers##45093 |n
		.learn Spiked Deathdealers##63192
	step
		'This Plan is dropped from the Boss NPC's of Ulduar.
		.collect 1 Plans: Treads of Destiny##45091 |n 
		.learn Treads of Destiny##63190
	step
		'This Plan drops from NPC's in the Sunwell Plateau.
		.collect 1 Plans: Hard Khorium Battlefists##35209 |n
		.learn Hard Khorium Battlefists##46141
	step
		'This Plan drops from NPC's in the Sunwell Plateau.
		.collect 1 Plans: Hard Khorium Battleplate##35211 |n
		.learn Hard Khorium Battleplate##46144
	step
		'This Plan drops from NPC's in the Sunwell Plateau.
		.collect 1 Plans: Sunblessed Breastplate##35210 |n
		.learn Sunblessed Breastplate##46142
	step
		'This Plan drops from NPC's in the Sunwell Plateau.
		.collect 1 Plans: Sunblessed Gauntlets |n
		.learn Sunblessed Gauntlets##46140
	step
		'This Plan is dropped from NPC's in Serpentshrine Cavern.
		.collect 1 Plans: Belt of the Guardian##30321 |n
		.learn Belt of the Guardian##36389
	step
		'This Plan is dropped from NPC's in Serpentshrine Cavern.
		.collect 1 Plans: Boots of the Protector##30323 |n
		.learn Boots of the Protector##36391
	step
		'This Plan is dropped from NPC's in Black Temple.
		.collect 1 Plans: Dawnsteel Bracers##32738 |n
		.learn Dawnsteel Bracers##41134
	step
		'This Plan is dropped from NPC's in Hyjal Summit.
		.collect 1 Plans: Dawnsteel Shoulders##32739 |n
		.learn Dawnsteel Shoulders##41135
	step
		'This Plan is dropped from NPC's in Hyjal Summit.
		.collect 1 Plans: Swiftsteel Bracers##32736 |n
		.learn Swiftsteel Bracers##41132
	step
		'This Plan is dropped from NPC's in Hyjal Summit.
		.collect 1 Plans: Swiftsteel Shoulders##32737 |n
		.learn Swiftsteel Shoulders##41133
	step
		'This Plan is dropped from NPC's in Serpentshrine Cavern.
		.collect 1 Plans: Red Belt of Battle##30322 |n
		.learn Red Belt of Battle##36390
	step
		'This Plan is dropped from NPC's in Serpentshrine Cavern.
		.collect 1 Plans: Red Havoc Boots##30324 |n
		.learn Red Havoc Boots##36392
]])

ZygorGuidesViewer:RegisterInclude("Profession_List_Enchanting",[[
		'You will learn this when you pick up Enchanting
		.learn Runed Copper Rod##7421
	step
		'You will learn this when you pick up Enchanting
		.learn Enchant Bracer - Minor Health##7418
	step
		'You will learn this when you pick up Enchanting
		.learn Enchant Bracer - Minor Dodge##7428
	step
		#include "trainer_Enchanting"
		.learn Lesser Magic Wand##14293
	step
		#include "trainer_Enchanting"
		.learn Enchant Chest - Minor Health##7420
	step
		'This is a Random World Drop, from creatures level 6-20 and some dungeons.
		|tip We recommend Starter Area Humanoids or Ragefire Chasm for grinding.
		.learn Enchant Chest - Minor Mana##7443
	step
		#include "trainer_Enchanting"
		.learn Enchant Chest - Minor Absorption##7426
	step
		goto Orgrimmar 53.2,48.8
		.talk Kithas##3346
		.buy 1 Formula: Minor Wizard Oil##20758 |n
		.learn Minor Wizard Oil##25124
	step
		#include "trainer_Enchanting"
		.learn Enchant Bracer - Minor Stamina##7457
	step
		'This is a Random World Drop, from creatures level 9-25 and some dungeons.
		|tip We recommend Ashenvale or Wailing Caverns for grinding.
		.collect 1 Formula: Enchant Bracer - Minor Spirit##6344 |n
		.learn Enchant Bracer - Minor Spirit##7766
	step
		#include "trainer_Enchanting"
		.learn Enchant Chest - Lesser Health##7748
	step
		#include "trainer_Enchanting"
		.learn Greater Magic Wand##14807
	step
		#include "trainer_Enchanting"
		.learn Enchant Cloak - Minor Protection##7771
	step
		#include "trainer_Enchanting"
		.learn Enchant Bracer - Minor Agility##7779
	step
		'This is a Random World Drop, from creatures level 9-25 and some dungeons.
		|tip We recommend Azshara or Wailing Caverns for grinding.
		.collect 1 Formula: Enchant Bracer - Minor Strength##6347 |n
		.learn Enchant Bracer - Minor Strength##7782
	step
		goto Orgrimmar 53.2,48.8
		.talk Kithas##3346
		.buy 1 Formula: Enchant Chest - Lesser Mana##6346 |n
		.learn Enchant Chest - Lesser Mana##7776
		.' You can also purchase this Formula from Lily here: [Silverpine Forest 46.8,40.6]
		'|talk Lily##5757
	step
		'This is a Random World Drop, from creatures level 9-25 and some dungeons.
		|tip We recommend Azshara or Wailing Caverns for grinding.
		.collect 1 Formula: Enchant Weapon - Minor Beastslayer##6348 |n
		.learn Enchant Weapon - Minor Beastslayer##7786
	step
		#include "trainer_Enchanting"
		.learn Enchant Weapon - Minor Striking##7788
	step
		goto Orgrimmar 53.2,48.8
		.talk Kithas##3346
		.buy 1 Formula: Enchant Chest - Lesser Mana##6346 |n
		.learn Enchant Chest - Lesser Mana##7776
		.' You can also purchase this Formula from Lily here: [Silverpine Forest 46.8,40.6]
		'|talk Lily##5757
	step
		'This is a Random World Drop, from creatures level 11-26 and some dungeons.
		|tip We recommend Azshara or Wailing Caverns for grinding.
		.collect 1 Formula: Enchant Weapon - Minor Beastslayer##6348 |n
		.learn Enchant Weapon - Minor Beastslayer##7786
	step
		'This is a Random World Drop, from creatures level 15-30 and some dungeons.
		|tip We recommend Azshara or Wailing Caverns for grinding.
		.collect 1 Formula: Enchant 2H Weapon - Lesser Spirit##11038 |n
		.learn Enchant 2H Weapon - Lesser Spirit##13380
	step
		goto Orgrimmar 53.2,48.8
		.talk Kithas##3346
		.buy 1 Formula: Enchant 2H Weapon - Lesser Intellect##6349
		.learn Enchant 2H Weapon - Lesser Intellect##7793 |n
		.' You can also purchase this Formula from Leo Sam here: [Silverpine Forest 53.8,82.2]
		.' You can also purchase this Formula from Nata Dawnstrider here: [Thunder Bluff 45.0,38.6]
		'|talk Leo##5758
		'|talk Nata Dawnstrider##3012
	step
		#include "trainer_Enchanting"
		.learn Enchant 2H Weapon - Minor Impact##7745
	step
		#include "trainer_Enchanting"
		.learn Enchant Shield - Minor Stamina##13378
	step
		'This is a Random World Drop, from creatures level 15-30 and some dungeons.
		|tip We recommend Azshara or Blackfathom Deeps for grinding.
		.collect 1 Formula: Enchant 2H Weapon - Lesser Spirit##11038 |n
		.learn Enchant 2H Weapon - Lesser Spirit##13380
	step
		goto Stonetalon Mountains 48.6,61.6
		.talk Kulwia##12043
		.buy 1 Formula: Enchant Cloak - Minor Agility##11039 |n
		.learn Enchant Cloak - Minor Agility##13419
	step
		#include "trainer_Enchanting"
		.learn Enchant Cloak - Lesser Protection##13421
	step
		'This is a Random World Drop, from creatures level 15-30 and some dungeons.
		|tip We recommend Wetlands or Blackfathom Deeps for grinding.
		.collect 1 Formula: Enchant Shield - Lesser Protection##11081 |n
		.learn Enchant Shield - Lesser Protection##13464
	step
		'This is a Random World Drop, from creatures level 15-30 and some dungeons.
		|tip We recommend Azshara or Blackfathom Deeps for grinding.
		.collect 1 Formula: Enchant Bracer - Lesser Spirit##6375 |n
		.learn Enchant Bracer - Lesser Spirit##7859
	step
		#include "trainer_Enchanting"
		.learn Enchant Chest - Health##7857
	step
		#include "trainer_Enchanting"
		.learn Enchant Boots - Minor Stamina##7863
	step
		goto Thunder Bluff 45.0,38.6
		.talk Nata Dawnstrider##3012
		.buy 1 Formula: Enchant Boots - Minor Agility##6377 |n
		.learn Enchant Boots - Minor Agility##7867
	step
		#include "trainer_Enchanting"
		.learn Enchant Bracer - Lesser Stamina##13501
	step
		#include "trainer_Enchanting"
		.learn Enchant Shield - Lesser Spirit##13485
	step
		goto Stonetalon Mountains 48.6,61.6
		.talk Kulwia##12043
		.collect 1 Formula: Enchant Bracer - Lesser Strength##11101 |n
		.learn Enchant Bracer - Lesser Strength##13536
	step
		#include "trainer_Enchanting"
		.learn Enchant Chest - Lesser Absorption##13538
	step
		#include "trainer_Enchanting"
		.learn Enchant Weapon - Lesser Striking##13503
	step
		#include "trainer_Enchanting"
		.learn Enchant 2H Weapon - Lesser Impact##13529
	step
		#include "trainer_Enchanting"
		.learn Enchant Chest - Mana##13607
	step
		goto Hillsbrad Foothills 35.6,81.8
		.from Torn Fin Tidehunter##2377, Torn Fin Oracle##2376, Torn Fin Coastrunner##2375, Torn Fin Muckdweller##2374
		.collect 1 Formula: Enchant Gloves - Fishing##11152 |n
		.learn Enchant Gloves - Fishing##13620
	step
		'This is a Random Drop from Ashenvale. Creatures level 19-25 have a chance of dropping this Formula.
		.collect 1 Formula: Enchant Gloves - Herbalism##78343 |n
		.learn Enchant Gloves - Herbalism##13617
	step
		'This Formula may no longer be in the game however it used to drop off these mobs.
		|tip You might be able to find this on the AH.
		.from Dark Iron Demolitionist##1054, Dark Iron Tunneler##1053, Dark Iron Saboteur##1052, Dark Iron Dwarf##1051
		.collect 1 Formula: Enchant Gloves - Mining##11150 |n
		.learn Enchant Gloves - Mining##13612
	step
		goto Orgrimmar 53.2,48.8
		.talk Kithas##3346
		.collect 1 Formula: Minor Mana Oil##20752 |n
		.learn Minor Mana Oil##25125
	step
		#include "trainer_Enchanting"
		.learn Enchant Bracer - Lesser Intellect##13622
	step
		#include "trainer_Enchanting"
		.learn Enchant Chest - Minor Stats##13626
	step
		#include "trainer_Enchanting"
		.learn Lesser Mystic Wand##14809
	step
		#include "trainer_Enchanting"
		.learn Enchant Cloak - Defense##13635
	step
		#include "trainer_Enchanting"
		.learn Enchant Shield - Lesser Stamina##13631
	step
		#include "trainer_Enchanting"
		.learn Enchant Boots - Lesser Agility##13637
	step
		#include "trainer_Enchanting"
		.learn Enchant Chest - Greater Health##13640
	step
		#include "trainer_Enchanting"
		.learn Enchant Bracer - Spirit##13642
	step
		#include "trainer_Enchanting"
		.learn Enchant Boots - Lesser Stamina##13644
	step
		#include "trainer_Enchanting"
		.learn Enchant Bracer - Lesser Dodge##13646
	step
		#include "trainer_Enchanting"
		.learn Enchant Bracer - Stamina##13648
	step
		#include "trainer_Enchanting"
		.learn Greater Mystic Wand##14810
	step
		'This is a Random World Drop, from creatures level 25-40 and some dungeons.
		|tip We recommend Maraudon or Uldaman for grinding.
		.collect 1 Formula: Enchant Weapon - Lesser Beastslayer##11164 |n
		.learn Enchant Weapon - Lesser Beastslayer##13653
	step
		'This is a Random World Drop, from creatures level 25-40 and some dungeons.
		|tip We recommend Maraudon or Uldaman for grinding.
		.collect 1 Formula: Enchant Weapon - Lesser Elemental Slayer##11165 |n
		.learn Enchant Weapon - Lesser Elemental Slayer##13655
	step
		#include "trainer_Enchanting"
		.learn Enchant Bracer - Strength##133661
	step
		#include "trainer_Enchanting"
		.learn Enchant Shield - Spirit##13659
	step
		#include "trainer_Enchanting"
		.learn Enchant Chest - Greater Mana##13663
	step
		'This is a Random World Drop, from creatures level 31-46 and some dungeons.
		|tip We recommend Eastern Plaguelands or Uldaman for grinding.
		.collect 1 Formula: Enchant Boots - Lesser Spirit##11167 |n
		.learn Enchant Boots - Lesser Spirit##13687
	step
		'This can only be obtained during the Feast of Winter Veil Holiday Event. This is from December 15 - Janurary 2.
		.collect 1 Smokywood Pastures Special Gift##17726 |n
		.' Open your Smokywood Pastures Special Gift |use Smokywood Pastures Special Gift##17726
		.' Or 
		.collect 1 Ticking Present##21327 |n
		.' Open your Ticking Present |use Ticking Present##21327
		.collect 1 Formula: Enchant Weapon - Winter's Might##17725 |n
		.learn Enchant Weapon - Winter's Might##21931
	step
		'This is a Random World Drop, from creatures level 31-45 and some dungeons.
		|tip We recommend Eastern Plaguelands or Dire Maul for grinding.
		.collect 1 Formula: Enchant Shield - Lesser Parry##11168 |n
		.learn Enchant Shield - Lesser Parry##13689
	step
		#include "trainer_Enchanting"
		.learn Enchant Weapon - Striking##13693
	step
		goto Orgrimmar 53.2,48.8
		.talk Kithas##3346
		.buy 1 Formula: Lesser Wizard Oil##20753 |n
		.learn Lesser Wizard Oil##25126
	step
		#include "trainer_Enchanting"
		.learn Enchant 2H Weapon - Impact##13695
	step
		#include "trainer_Enchanting"
		.learn Enchant Chest - Lesser Stats##13700
	step
		goto Arathi Highlands 63.6,84.2
		.from Witherbark Headhunter##2556, Witherbark Berserker##2558, Witherbark Shadow Hunter##2557
		.collect 1 Formula: Enchant Gloves - Skinning##11166 |n
		.learn Enchant Gloves - Skinning##13698
	step
		#include "trainer_Enchanting"
		.learn Enchant Cloak - Greater Defense##13746
	step
		#include "trainer_Enchanting"
		.learn Enchant Bracer - Intellect##13822
	step
		#include "trainer_Enchanting"
		.learn Enchant Gloves - Agility##13815
	step
		'This is a Random World Drop, from creatures level 31-51 and some dungeons.
		|tip We recommend Dire Maul and Razorfen Downs for grinding.
		.collect 1 Formula: Enchant Shield - Stamina##11202 |n
		.learn Enchant Shield - Stamina##13817
	step
		#include "trainer_Enchanting"
		.learn Enchant Boots - Stamina##13836
	step	
		goto Northern Stranglethorn 54.0,75.6
		.from Venture Co. Strip Miner##674
		.collect 1 Formula: Enchant Gloves - Advanced Mining##11203 |n
		.learn Enchant Gloves - Advanced Mining##13841
	step
		'This is a Random World Drop, from creatures level 28-50 and some dungeons.
		|tip We recommend Strathoolme and Eastern Plaguelands for grinding.
		.collect 1 Formula: Enchant Bracer - Greater Spirit##11204 |n
		.learn Enchant Bracer - Greater Spirit##13846
	step
		#include "trainer_Enchanting"
		.learn Enchant Chest - Superior Health##13858
	step
		#include "trainer_Enchanting"
		.learn Enchant Boots - Lesser Accuracy##63746
	step
		#include "trainer_Enchanting"
		.learn Enchant Boots - Minor Speed##13890
	step
		'This is a Random drop from NPC's in Tanaris from creatures level 44-50.
		.collect 1 Formula: Enchant Cloak - Lesser Agility##71714 |n
		.learn Enchant Cloak - Lesser Agility##13882
	step
		'This Formula is rumored to not drop anymore, but it used to drop from random NPC's in Swamp of Sarrows.
		.collect 1 Formula: Enchant Gloves - Advanced Herbalism##11205 |n
		.learn Enchant Gloves - Advanced Herbalism##13868
	step
		#include "trainer_Enchanting"
		.learn Enchant Gloves - Strength##13887
	step
		#include "trainer_Enchanting"
		.learn Enchant Chest - Superior Mana##13917
	step
		#include "trainer_Enchanting"
		.learn Enchant Shield - Greater Spirit##13905
	step
		'This is a Random World Drop, from creatures level 33-55 and some dungeons.
		|tip We recommend Tanaris or Zul'Farrak for grinding.
		.collect 1 Formula: Enchant Weapon - Demonslaying##11208 |n
		.learn Enchant Weapon - Demonslaying##13915
	step
		#include "trainer_Enchanting"
		.learn Enchant Boots - Agility##13935
	step
		goto Swamp of Sorrows 46.6,57.0
		.talk Banalash##989
		.collect 1 Formula: Enchant Bracer - Dodge##11223 |n
		.learn Enchant Bracer - Dodge##13931
	step
		#include "trainer_Enchanting"
		.learn Enchant 2H Weapon - Greater Impact##13937
	step
		#include "trainer_Enchanting"
		.learn Enchant Bracer - Greater Strength##13939
	step
		'This is a Random World Drop, from creatures level 40-55 and some dungeons.
		|tip We recommend Blackrock Depths or Zul'Farrak for grinding.
		.collect 1 Formula: Enchant Bracer - Greater Stamina##11225 |n
		.learn Enchant Bracer - Greater Stamina##13945
	step
		#include "trainer_Enchanting"
		.learn Enchant Chest - Stats##13941
	step
		#include "trainer_Enchanting"
		.learn Enchant Weapon - Greater Striking##13943
	step
		#include "trainer_Enchanting"
		.learn Enchanted Leather##17181
	step
		#include "trainer_Enchanting"
		.learn Enchanted Thorium Bar##17180
	step
		goto Silithus 55.6,37.0
		.talk Kania##15419
		.buy 1 Formula: Lesser Mana Oil##20754 |n
		.learn Lesser Mana Oil##25127
	step
		#include "trainer_Enchanting"
		.learn Enchant Gloves - Minor Haste##13948
	step
		'This is a Random World Drop, from creatures level 41-56 and some dungeons.
		|tip We recommend Blackrock Depths or Blackwing Lair for grinding.
		.collect 1 Formula: Enchant Gloves - Riding Skill##11226 |n
		.learn Enchant Gloves - Riding Skill##13947
	step
		#include "trainer_Enchanting"
		.learn Enchant Bracer - Greater Intellect##20008
	step
		'This is a Random World Drop, from creatures level 46-60 and some dungeons.
		|tip We recommend Silithus or Sunken Temple for grinding.
		.collect 1 Formula: Enchant Boots - Greater Stamina##16215 |n
		.learn Enchant Boots - Greater Stamina##20020
	step
		goto Blackrock Depths/1 56.6,60.6
		.talk Lord Roccor##9025
		.collect 1 Formula: Smoking Heart of the Mountain##45050 |n
		.learn Smoking Heart of the Mountain##15596
	step
		goto Undercity 64.8,38.2
		.talk Daniel Bartlett##4561
		.buy 1 Formula: Enchant Shield - Greater Stamina##16217 |n
		.learn Enchant Shield - Greater Stamina##20017
	step
		goto Blackrock Depths 54.6,95.8
		.talk Pyromancer Loregrain##9024
		.collect 1 Formula: Enchant Weapon - Fiery Weapon##11207 |n
		.learn Enchant Weapon - Fiery Weapon##13898
	step
		'This is a Random World Drop, from creatures level 45-60 and some dungeons.
		|tip We recommend Felwood or Blackrock Depths for grinding.
		.collect 1 Formula: Enchant Bracer - Superior Spirit##16218 |n
		.learn Enchant Bracer - Superior Spirit##20009
	step
		#include "trainer_Enchanting"
		.learn Enchant Gloves - Greater Agility##20012
	step
		goto Silithus 55.6,37.0
		.talk Kania##15419
		.buy 1 Formula: Wizard Oil##20755 |n
		.learn Wizard Oil##25128
	step
		'This is a Random World Drop, from creatures level 45-60 and some dungeons.
		|tip We recommend Azshara or Sunken Temple for grinding.
		.collect 1 Formula: Enchant Boots - Spirit##16220 |n
		.learn Enchant Boots - Spirit##20024
	step
		goto Winterspring 59.6,49.2
		.talk Qia##11189
		.buy 1 Formula: Enchant Chest - Major Health##16221 |n
		.learn Enchant Chest - Major Health##20026
	step
		#include "trainer_Enchanting"
		.learn Enchant Shield - Vitality##20016
	step
		goto Moonglade 48.6,40.2
		.talk Lorelae Wintersong##12022
		.buy 1 Formula: Enchant Cloak - Superior Defense##16224 |n
		.learn Enchant Cloak - Superior Defense##20015
	step
		goto Winterspring 50.6,53.2
		.from Anguished Highborne##7524
		.collect 1 Formula: Enchant Weapon - Icy Chill##16223 |n
		.learn Enchant Weapon - Icy Chill##20029
	step
		goto Felwood 64.8,5.2
		.talk Meilosh##11557
		|tip You must be Friendly with Timbermaw Hold to purchase this Formula.
		.buy 1 Formula: Enchant 2H Weapon - Agility##22392 |n
		.learn Enchant 2H Weapon - Agility##27837
	step
		goto Felwood 64.8,5.2
		.talk Meilosh##11557
		|tip You must be Honored with Timbermaw Hold to purchase this Formula.
		.buy 1 Formula: Enchant Weapon - Agility##19445 |n
		.learn Enchant Weapon - Agility##23800
	step
		goto 75.8,54.0
		.talk Quartermaster Miranda Breechlock##11536
		|tip You must be Honored with Argent Crusade to purchase this Formula.
		.buy 1 Formula: Enchant Bracer - Mana Regeneration##19446 |n
		.learn Enchant Bracer - Mana Regeneration##23801
		.' You can also purchase this Plan from Argent Quartermaster Lightspark here: [Western Plaguelands 42.8,83.8]
		'|talk Argent Quartermaster Lightspark##10857
	step
		#include "trainer_Enchanting"
		.learn Enchant Chest - Major Mana##20028
	step
		goto Blackrock Depths/2 50.6,59.2
		.talk Lokhtos Darkbargainer##12944
		.buy 1 Formula: Enchant Weapon - Strength##19444 |n
		.learn Enchant Weapon - Strength##23799
	step
		'This is a drop from Blackhand Elite in Upper Blackrock Spire
		.from Blackhand Elite##10317
		.collect 1 Formula: Enchant 2H Weapon - Superior Impact##16247 |n
		.learn Enchant 2H Weapon - Superior Impact##20030
	step
		#include "trainer_Enchanting"
		.learn Enchant Boots - Greater Agility##20023
	step
		goto Deadwind Pass 63.4,74.8
		.from Deadwind Warlock##7372
		.collect 1 Formula: Enchant Bracer - Superior Strength##16246 |n
		.learn Enchant Bracer - Superior Strength##20010
	step
		#include "trainer_Enchanting"
		.learn Enchant Gloves - Greater Strength##20013
	step
		goto Stratholme/2 65.0,48.6
		.from Thuzadin Shadowcaster##10398
		.collect 1 Formula: Enchant Weapon - Unholy##16248 |n
		.learn Enchant Weapon - Unholy Weapon##20033
		.' You can also get this from Bonechewers in Terokkar here: [Terokkar Forest 67.6,53.6]
		'|from Bonechewer Backbreaker##16810
	step
		#include "trainer_Enchanting"
		.learn Nexus Transformation##42613
	step
		'This plan is not available in the game anymore.
		.learn Brilliant Mana Oil##25130
	step
		'This plan is not available in the game anymore.
		.learn Brilliant Wizard Oil##25129
	step
		goto Stratholme/1 21.6,57.6
		.from Risen Sorcerer##10422
		.collect 1 Formula: Enchant 2H Weapon - Major Intellect##16249 |n
		.learn Enchant 2H Weapon - Major Intellect##20036
	step
		goto Scholomance 55.4,59.4
		.from Scholomance Acolyte##58757, Scholomance Adept##10469
		.collect 1 Formula: Enchant 2H Weapon - Major Spirit##16255 |n
		.learn Enchant 2H Weapon - Major Spirit##20035
	step
		goto Tirisfal Glades 83.2,68.0
		.talk Argent Quartermaster Hasana##10856
		.buy 1 Formula: Enchant Bracer - Healing Power##19447 |n
		.learn Enchant Bracer - Healing Power##23802
		.' You can also purchase this from Quartermaster Miranda Breechlock here: [Eastern Plaguelands 75.8,54.0]
		'|talk Quartermaster Miranda Breechlock##11536
	step
		#include "trainer_Enchanting"
		.learn Enchant Bracer - Lesser Assault##84002
	step
		'This is a Random World Drop, from creatures level 40-63 and some dungeons.
		|tip We recommend Eastern Plaguelands or Molten Core for grinding.
		.collect 1 Formula: Enchant Bracer - Superior Stamina##16251 |n
		.learn Enchant Bracer - Superior Stamina##20011
	step
		'This is a Random World Drop, from creatures level 60-72 and some dungeons.
		|tip We recommend Terokkar Forest or Sunwell Plateau for grinding.
		.collect 1 Formula: Enchant Chest - Greater Stats##16253 |n
		.learn Enchant Chest - Greater Stats##20025
	step
		#include "trainer_Enchanting"
		.learn Enchant Chest - Restore Mana Prime##33991
	step
		goto Shattrath City 62.6,69.0
		.talk Nakodu##21655
		|tip You must be Exalted with Lower City to purchase this Formula.
		.buy 1 Formula: Enchant Cloak - Dodge##33148 |n
		.learn Enchant Cloak - Dodge##25086
	step
		goto Zangarmarsh 79.2,63.8
		.talk Fedryen Swiftspear##17904
		|tip You must be Exalted with Cenarion Expedition to purchase this Forumla.
		.buy 1 Formula: Enchant Cloak - Stealth##33149 |n
		.learn Enchant Cloak - Stealth##25083
	step
		goto Hellfire Peninsula 54.8,37.8
		.talk Quartermaster Urgronn##17585
		|tip You must be Exalted with Thrallmar to purchase this Formula.
		.buy 1 Formula: Enchant Cloak - Subtlety##33151 |n
		.learn Enchant Cloak - Subtlety##25084
	step
		'This is a Boss drop from the Raid Temple of Ahn'Qiraj. 
		.collect 1 Formula: Enchant Gloves - Fire Power##20729 |n
		.learn Enchant Gloves - Fire Power##25078
	step
		'This is a Boss drop from the Raid Temple of Ahn'Qiraj. 
		.collect 1 Formula: Enchant Gloves - Frost Power##20728 |n
		.learn Enchant Gloves - Frost Power##25074
	step
		'This is a Boss drop from the Raid Temple of Ahn'Qiraj. 
		.collect 1 Formula: Enchant Gloves - Healing Power##20730 |n
		.learn Enchant Gloves - Healing Power##25079
	step
		'This is a Boss drop from the Raid Temple of Ahn'Qiraj. 
		.collect 1 Formula: Enchant Gloves - Shadow Power##20727 |n
		.learn Enchant Gloves - Shadow Power##25073
	step
		goto Tanaris 63.0,57.2
		.talk Alurmi##21643
		|tip You must be Exalted with Keepers of Time to purchase this Formula.
		.buy 1 Formula: Enchant Gloves - Superior Agility##33152 |n
		.learn Enchant Gloves - Superior Agility##25080
	step
		goto Shattrath City 51.6,41.6
		.talk Almaador
		.buy 1 Formula: Enchant Gloves - Threat##33153 |n 
		.learn Enchant Gloves - Threat##25072
	step
		goto Eastern Plaguelands 81.6,78.2
		.talk Scarlet Archmage##9451
		.collect 1 Formula: Enchant Weapon - Crusader##16252 |n
		.learn Enchant Weapon - Crusader##20034
	step
		'This is a Boss drop from the Raid Molten Core. 
		.collect 1 Formula: Enchant Weapon - Healing Power##18260 |n
		.learn Enchant Weapon - Healing Power##22750
	step
		'This Formula may not be available through the game anymore.
		.collect 1 Formula: Enchant Weapon - Lifestealing##16254 |n
		.learn Enchant Weapon - Lifestealing##20032
	step
		goto Blackrock Depths/2 50.6,59.2
		.talk Lokhtos Darkbargainer##12944
		.buy 1 Formula: Enchant Weapon - Mighty Intellect##19449 |n
		.learn Enchant Weapon - Mighty Intellect##23804
	step
		goto Blackrock Depths/2 50.6,59.2
		.talk Lokhtos Darkbargainer##12944
		.buy 1 Formula: Enchant Weapon - Mighty Spirit##19448 |n
		.learn Enchant Weapon - Mighty Spirit##23803
	step
		'This is a Boss drop from the Raid Molten Core. 
		.collect 1 Formula: Enchant Weapon - Spellpower##18259 |n
		.learn Enchant Weapon - Spellpower##22749
	step
		goto Blackrock Spire/6 49.7,60.5
		.from Spirestone Warlord##9216+
		.collect 1 Formula: Enchant Weapon - Superior Striking##16250 |n
		.learn Enchant Weapon - Superior Striking##20031
	step
		'This is a Random World Drop, from creatures level 60-72 and some dungeons.
		|tip We recommend Shattered Halls for grinding.
		.collect 1 Formula: Enchant Boots - Vitality##22542 |n
		.learn Enchant Boots - Vitality##27948
	step
		#include "trainer_Enchanting"
		.learn Enchant Bracer - Brawn##27899
	step
		#include "trainer_Enchanting"
		.learn Enchant Bracer - Major Intellect##34001
	step
		#include "trainer_Enchanting"
		.learn Enchant Gloves - Blasting##33993
	step
		goto Silvermoon City 70.0,24.6
		.talk Lyna##16635
		.buy 1 Formula: Superior Mana Oil##22562 |n
		.learn Superior Mana Oil##28016
		.' You can also purchase this Formula from Madame Ruby here: [Shattrath City 63.6,70.0]
		'|talk Madame Ruby##19663
	step
		#include "trainer_Enchanting"
		.learn Enchant Cloak - Greater Agility##34004
	step
		#include "trainer_Enchanting"
		.learn Enchant Cloak - Major Armor##27961
	step
		#include "trainer_Enchanting"
		.learn Enchant Gloves - Assault##33996
	step
		#include "trainer_Enchanting"
		.learn Enchant Shield - Lesser Dodge##27944
	step
		#include "trainer_Enchanting"
		.learn Enchant Bracer - Stats##27905
	step
		#include "trainer_Enchanting"
		.learn Enchant Chest - Exceptional Health##27957
	step
		goto Mana-Tombs 60.4,37.8
		.from Ethereal Priest##18317
		.collect 1 Formula: Enchant Boots - Fortitude##22543 |n
		.learn Enchant Boots - Fortitude##27950
	step
		goto Netherstorm 66.2,48.0
		.from Ethereum Nullifier##22822, Ethereum Jailor##23008
		.collect 1 Formula: Enchant Bracer - Greater Dodge##22530 |n
		.learn Enchant Bracer - Greater Dodge##27906
	step
		#include "trainer_Enchanting"
		.learn Enchant Chest - Major Spirit##33990
	step
		#include "trainer_Enchanting"
		.learn Prismatic Sphere##28027
	step
		goto Hellfire Peninsula 54.8,37.8
		.talk Quartermaster Urgronn##17585
		|tip You must be Friendly with Thrallmar to purchase this Formula.
		.buy 1 Formula: Enchant Bracer - Superior Healing##24000 |n
		.learn Enchant Bracer - Superior Healing##27911
	step
		goto Old Hillsbrad Foothills 39.8,55.8
		.talk Aged Dalaran Wizard##18664
		|tip He walks along this road, some searching may be required.
		.buy 1 Formula: Enchant Shield - Intellect##22539 |n
		.learn Enchant Shield - Intellect##27945
	step
		goto Shattrath City 63.6,70.0
		.talk Madame Ruby##19663
		.buy 1 Formula: Enchant Shield - Major Stamina##28282 |n
		.learn Enchant Shield - Major Stamina##34009
	step
		#include "trainer_Enchanting"
		.learn Enchant Shield - Resilience##44383
	step
		goto Silvermoon City 70.0,24.6
		.talk Lyna##16635
		.buy 1 Formula: Large Prismatic Shard##22565 |n
		.learn Large Prismatic Shard##28022
		.' You can also purchase this Formula from Madame Ruby here: [Shattrath City 63.6,70.0]
		'|talk Madame Ruby##19663
	step
		#include "trainer_Enchanting"
		.learn Small Prismatic Shard##42615
	step
		goto Nagrand 30.5,56.9
		.talk Paulsta'ats##23007
		.buy 1 Formula: Enchant Cloak - PvP Power##28274 |n
		.learn Enchant Cloak - PvP Power##34003
	step
		'This is a Random World Drop, from creatures level 60-72 in some dungeons and raids.
		|tip We recommend Old Hillsbrad Foothils and Black Temple for grinding.
		.collect 1 Formula: Enchant Bracer - Restore Mana Prime##22532 |n
		.learn Enchant Bracer - Restore Mana Prime##21913
	step
		goto Silvermoon City 70.0,24.6
		.talk Lyna##16635
		.buy 1 Formula: Superior Wizard Oil##22563 |n
		.learn Superior Wizard Oil##28019
		.' You can also purchase this Formula from Madame Ruby here: [Shattrath City 63.6,70.0]
		'|talk Madame Ruby##19663
	step
		goto Auchenai Crypts 58.2,88.4
		.from Raging Skeleton##18521
		.collect 1 Formula: Enchant Boots - Dexterity##22544 |n
		.learn Enchant Boots - Dexterity##27951
	step
		#include "trainer_Enchanting"
		.learn Enchant Gloves - Major Strength##33995
	step
		'This is a Random World Drop, from creatures level 60-72 in some dungeons and raids.
		|tip We recommend The Arcatraz and Sunwell Plateau for grinding.
		.collect 1 Formula: Enchant Shield - Parry##22540 |n
		.learn Enchant Shield - Parry##27946
	step
		goto Netherstorm 49.0,81.4
		.from Sunfury Researcher##20136
		.collect 1 Formula: Enchant Weapon - Major Intellect##22551 |n
		.learn Enchant Weapon - Major Intellect##27968
	step
		goto Netherstorm 43.6,34.4
		.talk Karaaz##20242
		|tip You must be Honored with The Consortium to purchase this Formula.
		.buy 1 Formula: Enchant Weapon - Major Striking##22552 |n
		.learn Enchant Weapon - Major Striking##27967
		.' You can also purchase this from Paulsta'ats here: [Nagrand 30.6,57.0]
		'|talk Paulsta'ats##23007
	step
		goto Hellfire Peninsula 54.8,37.8
		.talk Quartermaster Urgronn##17585
		|tip You must be Revered with Thrallmar to purchase this Formula.
		.buy 1 Formula: Enchant Chest - Exceptional Stats##24003 |n
		.learn Enchant Chest - Exceptional Stats##27960
	step
		'This is a Random World Drop, from creatures level 60-72 in some dungeons and raids.
		|tip We recommend Blade's Edge Mountains or Shadow Labyrinth for grinding.
		.collect 1 Formula: Enchant Chest - Major Resilience##28270 |n
		.learn Enchant Chest - Major Resilience##33992
	step
		goto The Slave Pens 30.5,50.5
		.from Ahune##25740
		.click Ice Chest##1387
		.collect 1 Formula: Enchant Weapon - Deathfrost##35498 |n
		.learn Enchant Weapon - Deathfrost##46578
	step
		goto Deadwind Pass 47.0,75.6
		.talk Apprentice Darius##18255
		|tip You must be Exalted with The Violet Eye to purchase this Formula.
		.buy 1 Formula: Enchant Weapon - Greater Agility##33165 |n
		.learn Enchant Weapon - Greater Agility##42620
	step
		#include "trainer_Enchanting"
		.learn Void Sphere##28028
	step
		goto The Shattered Halls 37.6,10.6
		.from Shattered Hand Centurion##17465
		.collect 1 Formula: Enchant 2H Weapon - Savagery##22554 |n
		.learn Enchant 2H Weapon - Savagery##27971
	step
		goto The Steamvault 36.8,24.6
		.from Coilfang Oracle##17803
		.collect 1 Formula: Enchant Bracer - Fortitude##22533 |n
		.learn Enchant Bracer - Fortitude##27914
	step	
		goto Shattrath City 51.6,41.6
		.talk Almaador##21432
		|tip You must be Honored with The Sha'tar to purchase this Formula.
		.buy 1 Formula: Enchant Gloves - Major Healing##28273 |n
		.learn Enchant Gloves - Major Healing##33999
	step
		goto Shattrath City 51.6,41.6
		.talk Almaador##21432
		|tip You must be Honored with The Sha'tar to purchase this Formula.
		.buy 1 Formula: Enchant Weapon - Major Healing##28281 |n
		.learn Enchant Weapon - Major Healing##34010
	step
		goto Blade's Edge Mountains 52.8,18.8
		.from Bash'ir Spell-Thief##22242, Bash'ir Arcanist##22243
		.collect 1 Formula: Enchant Weapon - Major Spellpower##22555 |n
		.learn Enchant Weapon - Major Spellpower##27975
	step
		'This is a Random World Drop, from creatures level 60-72 in some dungeons and raids.
		|tip We recommend Shattered Halls or karazhan for grinding.
		.collect 1 Formula: Enchant Weapon - Potency##22553 |n
		.learn Enchant Weapon - Potency##27972
	step
		#include "trainer_Enchanting"
		.learn Enchant Chest - Exceptional Mana##27958
	step
		#include "trainer_Enchanting"
		.learn Enchant Cloak - Speed##60609
	step
		goto The Arcatraz 33.4,29.6
		.from Eredar Deathbringer##20880
		.collect 1 Formula: Enchant 2H Weapon - Major Agility##22556 |n
		.learn Enchant 2H Weapon - Major Agility##27977
	step
		'This is a Random World Drop, from creatures level 60-72 in some dungeons and raids.
		|tip We recommend Karazhan or Black Temple for grinding.
		.collect 1 Formula: Enchant Boots - Boar's Speed##28280 |n
		.learn Enchant Boots - Boar's Speed##34008
	step
		'This is a Random World Drop, from creatures level 60-72 in some dungeons and raids.
		|tip We recommend Serpentshrine Cavern or Black Temple for grinding.
		.collect 1 Formula: Enchant Boots - Cat's Swiftness##28279 |n
		.learn Enchant Boots - Cat's Swiftness##34007
	step
		goto Tanaris 63.0,57.2
		.talk Alurmi##21643
		|tip You must be Honored with Keepers of Time to purchase this Formula.
		.buy 1 Formula: Enchant Gloves - Major Spellpower##28272 |n
		.learn Enchant Gloves - Major Spellpower##33997
	step
		goto Zangarmarsh 79.2,63.8
		.talk Fedryen Swiftspear##17904
		|tip You must be Revered with Cenarion Expedition to purchase this Formula.
		.buy 1 Formula: Enchant Gloves - Precise Strikes##28271 |n
		.learn Enchant Gloves - Precise Strikes##33994
	step
		goto Tanaris 63.0,57.2
		.talk Alurmi##21643
		|tip You must be Honored with Keepers of Time to purchase this Formula.
		.buy 1 Formula: Enchant Ring - Minor Intellect##22536 |n
		.learn Enchant Ring - Minor Intellect##27924
	step
		goto Karazhan/12 43.6,26.6
		.talk Ythyar##17518
		.buy 1 Formula: Enchant Ring - Striking##22535 |n
		.learn Enchant Ring - Striking##27920
	step
		'This is a Random World Drop, from creatures level 60-72 in some dungeons and raids.
		|tip We recommend Shattered Halls or Black Temple for grinding.
		.collect 1 Formula: Enchant Weapon - Battlemaster##22557 |n
		.learn Enchant Weapon - Battlemaster##28004
	step
		'This is a Random World Drop, from creatures level 60-72 in some dungeons and raids.
		|tip We recommend The Mechanar or Black Temple for grinding.
		.collect 1 Formula: Enchant Weapon - Spellsurge##22558 |n
		.learn Enchant Weapon - Spellsurge##28003
	step
		goto Blade's Edge Mountains 47.2,78.0
		.from Bloodmaul Geomancer##19952
		.collect 1 Formula: Enchant Bracer - Spellpower##22534 |n
		.learn Enchant Bracer - Spellpower##27917
	step
		goto Isle of Quel'Danas 47.2,30.6
		.talk Eldara Dawnrunner##25032
		|tip You must be Honored with Shattered Sun Offensive.
		.buy 1 Formula: Enchant Chest - Dodge##35500 |n
		.learn Enchant Chest - Dodge##46594
	step
		#include "trainer_Enchanting"
		.learn Enchant Bracer - Assault##60616
	step
		#include "trainer_Enchanting"
		.learn Enchant Gloves - Exceptional Spellpower##44592
	step
		goto Karazhan/4 12.6,30.2
		.from Phantom Stagehand##16472
		.collect 1 1 Formula: Enchant Boots - Surefooted##22545 |n
		.learn Enchant Boots - Surefooted##27954
	step
		#include "trainer_Enchanting"
		.learn Enchant Chest - Super Stats##44623
	step
		goto Isle of Quel'Danas 47.2,30.6
		.talk Eldara Dawnrunner##25032
		|tip You must be Honored with Shattered Sun Offensive.
		.buy 1 Formula: Void Shatter##34872 |n
		.learn Void Shatter##45765
	step
		goto Karazhan/10 70.8,28.8
		.from Shade of Aran##16524
		.collect 1 Formula: Enchant Weapon - Sunfire##22560 |n
		.learn Enchant Weapon - Sunfire##27981
	step
		goto Magisters' Terrace 40.8,56.6
		.from Priestess Delrissa##14560
		.collect 1 Formula: Enchant Cloak - Greater Dodge##35756 |n
		.learn Enchant Cloak - Greater Dodge##47051
	step
		goto Shattrath City 62.6,69.0
		.talk Nakodu##21655
		|tip You must be Honored with Lower City to purchase this Formula.
		.buy 1 Formula: Enchant Ring - Stats##22538 |n
		.learn Enchant Ring - Stats##27927
	step
		goto Netherstorm 44.0,36.6
		.talk Dealer Jadyan##19536
		.buy 1 Formula: Enchant Weapon - Executioner##78348 |n
		.learn Enchant Weapon - Executioner##42974
	step
		goto Karazhan/3 27.8,63.8
		.from Moroes##15687
		.collect 1 Formula: Enchant Weapon - Mongoose##22559 |n
		.learn Enchant Weapon - Mongoose##27984
	step
		goto Karazhan/11 54.6,74.2
		.from Terestian Illhoof##15688
		.collect 1 Formula: Enchant Weapon - Soulfrost##22561 |n
		.learn Enchant Weapon - Soulfrost##27982
	step
		#include "trainer_Enchanting"
		.learn Enchant Bracer - Exceptional Intellect##44555
	step
		goto Dragonblight 39.2,65.8
		.from Indu'le Warrior##26344, Indu'le Mystic##26336, Indu'le Fisherman##26343
		.collect 1 Formula: Enchant Gloves - Angler##50406 |n
		.learn Enchant Gloves - Angler##71692
	step
		#include "trainer_Enchanting"
		.learn Enchant Boots - Assault##60606
	step
		#include "trainer_Enchanting"
		.learn Enchant Gloves - Gatherer##44506
	step
		#include "trainer_Enchanting"
		.learn Enchant Weapon - Greater Potency##60621
	step
		#include "trainer_Enchanting"
		.learn Enchant Boots - Icewalker##60623
	step
		#include "trainer_Enchanting"
		.learn Enchant Staff - Spellpower##62959
	step
		#include "trainer_Enchanting"
		.learn Enchant Boots - Greater Fortitude##44528
	step
		#include "trainer_Enchanting"
		.learn Enchant 2H Weapon - Greater Savagery##44630
	step
		#include "trainer_Enchanting"
		.learn Enchant Cloak - Minor Power##44582
	step
		#include "trainer_Enchanting"
		.learn Enchant Bracer - Greater Spellpower##44635
	step
		#include "trainer_Enchanting"
		.learn Enchant Chest - Mighty Health##44492
	step
		#include "trainer_Enchanting"
		.learn Enchant Cloak - Superior Agility##44500
	step
		#include "trainer_Enchanting"
		.learn Enchant Gloves - Greater Assault##44513
	step
		#include "trainer_Enchanting"
		.learn Enchant Shield - Greater Intellect##60653
	step
		#include "trainer_Enchanting"
		.learn Enchant Weapon - Exceptional Spellpower##44629
	step
		#include "trainer_Enchanting"
		.learn Enchant Ring - Assault##44645
	step
		#include "trainer_Enchanting"
		.learn Enchant Ring - Lesser Intellect##44636
	step
		#include "trainer_Enchanting"
		.learn Enchant Ring - Lesser Stamina##59636
	step
		#include "trainer_Enchanting"
		.learn Enchant Bracer - Greater Stats##44616
	step
		#include "trainer_Enchanting"
		.learn Enchant Chest - Greater Dodge##47766
	step
		#include "trainer_Enchanting"
		.learn Enchant Boots - Greater Vitality##44584
	step
		#include "trainer_Enchanting"
		.learn Enchant Gloves - Expertise##44484
	step
		#include "trainer_Enchanting"
		.learn Enchant Boots - Greater Spirit##44508
	step
		#include "trainer_Enchanting"
		.learn Enchant Gloves - Precision##44488
	step
		#include "trainer_Enchanting"
		.learn Enchant Weapon - Exceptional Agility##44633
	step
		#include "trainer_Enchanting"
		.learn Enchant Weapon - Exceptional Spirit##44510
	step
		goto Dalaran 38.8,40.8
		.talk Vanessa Sellers##32514
		.buy 1 Formula: Enchant Chest - Exceptional Resilience##37340 |n
		.learn Enchant Chest - Exceptional Resilience##44588
	step
		#include "trainer_Enchanting"
		.learn Enchant Boots - Superior Agility##44589
	step
		#include "trainer_Enchanting"
		.learn Enchant Bracer - Expertise##44598
	step
		#include "trainer_Enchanting"
		.learn Enchant Gloves - Major Agility##44529
	step
		#include "trainer_Enchanting"
		.learn Enchant Bracer - Major Spirit##44593
	step
		#include "trainer_Enchanting"
		.learn Enchant Chest - Greater Mana Restoration##44509
	step
		#include "trainer_Enchanting"
		.learn Enchant Cloak - Major Agility##60663
	step
		#include "trainer_Enchanting"
		.learn Enchant Shield - Dodge##44489
	step
		#include "trainer_Enchanting"
		.learn Enchant Chest - Super Health##47900
	step
		#include "trainer_Enchanting"
		.learn Enchant Gloves - Crusher##60668
	step
		goto Dalaran 39.6,41.4
		.talk Vanessa Sellers##32514
		.buy 1 Formula: Enchant Weapon - Icebreaker##37344 |n
		.learn Enchant Weapon - Icebreaker##44524
	step
		goto Dalaran 39.6,41.4
		.talk Vanessa Sellers##32514
		.buy 1 Formula: Enchant Weapon - Lifeward##44494 |n
		.learn Enchant Weapon - Lifeward##44576
	step
		#include "trainer_Enchanting"
		.learn Enchant Boots - Earthen Vitality##74189
	step
		#include "trainer_Enchanting"
		.learn Enchant Chest - Mighty Stats##74191
	step
		#include "trainer_Enchanting"
		.learn Enchant Gloves - Mastey##74132
	step
		goto Dalaran 39.6,41.4
		.talk Vanessa Sellers##32514
		.collect 1 Formula: Enchant 2H Weapon - Massacre##44483 |n
		.learn Enchant 2H Weapon - Massacre##60691
	step
		goto Dalaran 39.6,41.4
		.talk Vanessa Sellers##32514
		.buy 1 Formula: Enchant Weapon - Scourgebane##44473 |n
		.learn Enchant 2H Weapon - Scourgebane##44595
	step
		goto Dalaran 39.6,41.4
		.talk Vanessa Sellers##32514
		.buy 1 Formula: Enchant Bracer - Greater Assault##44484 |n
		.learn Enchant Bracer - Greater Assault##44575
	step
		goto Dalaran 39.6,41.4
		.talk Vanessa Sellers##32514
		.buy 1 Formula: Enchant Cloak - Greater Speed##44472 |n
		.learn Enchant Cloak - Greater Speed##47898
	step
		goto Dalaran 39.6,41.4
		.talk Vanessa Sellers##32514
		.buy 1 Formula: Enchant Cloak - Mighty Stamina##44471 |n
		.learn Enchant Cloak - Mighty Stamina##47672
	step
		goto Dalaran 39.6,41.4
		.talk Vanessa Sellers##32514
		.buy 1 Formula: Enchant Weapon - Giant Slayer##37339 |n
		.learn Enchant Weapon - Giant Slayer##44621
	step
		goto Dalaran 39.6,41.4
		.talk Vanessa Sellers##32514
		.buy 1 Formula: Enchant Cloak - Superior Dodge##37347 |n
		.learn Enchant Cloak - Superior Dodge##44591
	step
		goto Dalaran 39.6,41.4
		.talk Vanessa Sellers##32514
		.buy 1 Formula: Enchant Gloves - Armsman##44485 |n
		.learn Enchant Gloves - Armsman##44625
	step
		goto Dalaran 39.6,41.4
		.talk Vanessa Sellers##32514
		.buy 1 Formula: Enchant Weapon - Mighty Spellpower##44487 |n
		.learn Enchant Weapon - Mighty Spellpower##60714
	step
		goto Dalaran 39.6,41.4
		.talk Vanessa Sellers##32514
		.buy 1 Formula: Enchant Weapon - Superior Potency##44486 |n
		.learn Enchant Weapon - Superior Potency##60707
	step
		#include "trainer_Enchanting"
		.learn Enchant Bracer - Speed##74193
	step
		#include "trainer_Enchanting"
		.learn Enchant Cloak - Lesser Power##74192
	step
		goto Dalaran 39.6,41.4
		.talk Vanessa Sellers##32514
		.buy 1 Formula: Enchant Boots - Greater Assault##44490 |n
		.learn Enchant Boots - Greater Assault##60763
	step
		goto Dalaran 39.6,41.4
		.talk Vanessa Sellers##32514
		.buy 1 Formula: Enchant Boots - Tuskarr's Vitality##44491 |n
		.learn Enchant Boots - Tuskarr's Vitality##47901
	step
		goto Dalaran 39.6,41.4
		.talk Vanessa Sellers##32514
		.buy 1 Formula: Enchant Bracer - Superior Spellpower##44498 |n
		.learn Enchant Bracer - Superior Spellpower##60767
	step
		goto Dalaran 39.6,41.4
		.talk Vanessa Sellers##32514
		.buy 1 Formula: Enchant Chest - Powerful Stats##44489 |n
		.learn Enchant Chest - Powerful Stats##60692
	step
		goto Dalaran 39.6,41.4
		.talk Vanessa Sellers##32514
		.buy 1 Formula: Enchant Cloak - Shadow Armor##37349 |n
		.learn Enchant Cloak - Shadow Armor##44631
	step
		goto Dalaran 39.6,41.4
		.talk Vanessa Sellers##32514
		.buy 1 Formula: Enchant Cloak - Wisdom##44488 |n
		.learn Enchant Cloak - Wisdom##47899
	step
		goto Dalaran 39.6,41.4
		.talk Vanessa Sellers##32514
		.buy 1 Formula: Enchant Weapon - Accuracy##44496 |n
		.learn Enchant Weapon - Accuracy##59619
	step
		goto Dalaran 39.6,41.4
		.talk Vanessa Sellers##32514
		.buy 1 Formula: Enchant Weapon - Berserking##44492 |n
		.learn Enchant Weapon - Berserking##59621
	step
		goto Dalaran 39.6,41.4
		.talk Vanessa Sellers##32514
		.buy 1 Formula: Enchant Weapon - Black Magic##44495 |n
		.learn Enchant Weapon - Black Magic##59625
	step
		#include "trainer_Enchanting"
		.learn Abyssal Shatter##69412
	step
		goto Dalaran 39.6,41.4
		.talk Vanessa Sellers##32514
		.buy 1 Formula: Enchant Staff - Greater Spellpower##45059 |n
		.learn Enchant Staff - Greater Spellpower##62948
	step
		'This Plan is dropped from the Boss NPC's of Ulduar.
		.collect 1 Formula: Enchant Weapon - Blade Ward##46027 |n
		.learn Enchant Weapon - Blade Ward##64441
	step
		'This Plan is dropped from the Boss NPC's of Ulduar.
		.collect 1 Formula: Enchant Weapon - Blood Draining##46348 |n
		.learn Enchant Weapon - Blood Draining##64579
	step
		#include "trainer_Enchanting"
		.learn Enchant Weapon - Avalanche##74197
	step
		#include "trainer_Enchanting"
		.learn Enchant Weapon - Mending##74195
	step
		goto Dalaran 39.6,41.4
		.talk Vanessa Sellers##32514
		.buy 1 Formula: Enchant Bracer - Major Stamina##44944 |n
		.learn Enchant Bracer - Major Stamina##62256
	step
		#include "trainer_Enchanting"
		.learn Enchant Boots - Haste
	step
		#include "trainer_Enchanting"
		.learn Enchant Gloves - Haste##74198
	step
		#include "trainer_Enchanting"
		.learn Enchant Bracer - Critical Strike##74201
	step
		#include "trainer_Enchanting"
		.learn Enchant Chest - Stamina##74200
	step
		#include "trainer_Enchanting"
		.learn Enchant Cloak - Intellect##74202
	step
		#include "trainer_Enchanting"
		.learn Enchant Shield - Protection##74207
	step
		#include "trainer_Enchanting"
		.learn Enchant 2H Weapon - Mighty Agility##95471
	step
		#include "trainer_Enchanting"
		.learn Enchant Gloves - Exceptional Strength##74212
	step
		#include "trainer_Enchanting"
		.learn Enchant Weapon - Elemental Slayer##74211
	step
		#include "trainer_Enchanting"
		.learn Enchant Ring - Agility##74216
	step
		#include "trainer_Enchanting"
		.learn Enchant Ring - Intellect##74217
	step
		#include "trainer_Enchanting"
		.learn Enchant Ring - Stamina##74218
	step
		#include "trainer_Enchanting"
		.learn Enchant Ring - Strength##74215
	step
		#include "trainer_Enchanting"
		.learn Enchant Boots - Major Agility##74213
	step
		#include "trainer_Enchanting"
		.learn Enchant Chest - Mighty Resilience##74214
	step
		#include "trainer_Enchanting"
		.learn Enchant Gloves - Greater Expertise##74220
	step
		#include "trainer_Enchanting"
		.learn Enchant Weapon - Hurricane##74223
	step
		#include "trainer_Enchanting"
		.learn Enchant Shield - Mastery##74226
	step
		#include "trainer_Enchanting"
		.learn Enchant Weapon - Heartsong##74225
	step
		#include "trainer_Enchanting"
		.learn Enchant Bracer - Superior Dodge##74229
	step
		#include "trainer_Enchanting"
		.learn Enchant Cloak - Critical Strike##74230
	step
		#include "trainer_Enchanting"
		.learn Enchant Bracer - Precision##74232
	step
		#include "trainer_Enchanting"
		.learn Enchant Chest - Exceptional Spirit##74231
	step
		#include "trainer_Enchanting"
		.learn Mysterious Essence##116497
	step
		#include "trainer_Enchanting"
		.learn Enchant Cloak - Protection##74234
	step
		#include "trainer_Enchanting"
		.learn Enchant Off-Hand - Superior Intellect##74235
	step
		#include "trainer_Enchanting"
		.learn Enchant Bracer - Mastery##104338
	step
		#include "trainer_Enchanting"
		.learn Enchant Cloak - Superior Critical Strike##104404
	step
		#include "trainer_Enchanting"
		.learn Enchant Boots - Precision##74236
	step
		#include "trainer_Enchanting"
		.learn Enchant Bracer - Exceptional Spirit##74237
	step
		#include "trainer_Enchanting"
		.learn Enchant Boots - Mastery##74238
	step
		#include "trainer_Enchanting"
		.learn Enchant Bracer - Greater Expertise##74239
	step
		#include "trainer_Enchanting"
		.learn Enchant Cloak - Greater Intellect##74240
	step
		#include "trainer_Enchanting"
		.learn Maelstrom Shatter##104698
	step
		'This is a Random World Drop, from creatures level 80-90 in some dungeons and raids.
		|tip We recommend Uldum and Twilight Highlands for grinding.
		.collect 1 Formula: Enchant Bracer - Agility##68787 |n
		.learn Enchant Bracer - Agility##96264
	step
		'This is a Random World Drop, from creatures level 80-90 in some dungeons and raids.
		|tip We recommend Mount Hyjal and Twilight Highlands for grinding.
		.collect 1 Formula: Enchant Bracer - Major Strength##68788 |n
		.learn Enchant Bracer - Major Strength##96261
	step
		'This is a Random World Drop, from creatures level 80-90 in some dungeons and raids.
		|tip We recommend Mount Hyjal and Twilight Highlands for grinding.
		.collect 1 Formula: Enchant Bracer - Mighty Intellect##68789 |n
		.learn Enchant Bracer - Mighty Intellect##96262
	step
		goto Orgrimmar 53.2,48.8
		.talk Kithas##3346
		|tip This is a Horde only Formula and may sell well on the Neutral AH.
		.buy 1 Formula: Enchanted Lantern##67308 |n
		.learn Enchanted Lantern##93841
	step
		'This is an Alliance only Formula.
		|tip You may be able to purchase this from the Neutral AH.
		.buy 1 Formula: Magic Lamp##67312 |n
		.learn Magic Lamp##93843 |n
		|confirm
	step
		goto Orgrimmar 53.2,48.8
		.talk Kithas##3346
		.buy 1 Formula: Enchant Boots - Assassin's Step##64411 |n
		.learn Enchant Boots - Assassin's Step##74252
	step
		goto Orgrimmar 53.2,48.8
		.talk Kithas##3346
		.buy 1 Formula: Enchant Boots - Lavawalker##64412 |n
		.learn Enchant Boots - Lavawalker##74253
	step
		goto Orgrimmar 53.2,48.8
		.talk Kithas##3346
		.buy 1 Formula: Enchant Bracer - Greater Critical Strike##52738 |n
		.learn Enchant Bracer - Greater Critical Strike##74248
	step
		goto Orgrimmar 53.2,48.8
		.talk Kithas##3346
		.buy 1 Formula: Enchant Bracer - Greater Speed##64413 |n
		.learn Enchant Bracer - Greater Speed##74256
	step
		goto Orgrimmar 53.2,48.8
		.talk Kithas##3346
		.buy 1 Formula: Enchant Chest - Greater Stamina##52740 |n
		.learn Enchant Chest - Greater Stamina##74251
	step
		goto Orgrimmar 53.2,48.8
		.talk Kithas##3346
		.buy 1 Formula: Enchant Chest - Peerless Stats##52739 |n
		.learn Enchant Chest - Peerless Stats##74250
	step
		goto Orgrimmar 53.2,48.8
		.talk Kithas##3346
		.buy 1 Formula: Enchant Cloak - Greater Critical Strike##52737 |n
		.learn Enchant Cloak - Greater Critical Strike##74247
	step
		goto Orgrimmar 53.2,48.8
		.talk Kithas##3346
		.buy 1 Formula: Enchant Gloves - Greater Mastery##64414 |n
		.learn Enchant Gloves - Greater Mastery##74255
	step
		goto Orgrimmar 53.2,48.8
		.talk Kithas##3346
		.buy 1 Formula: Enchant Gloves - Mighty Strength##64415 |n
		.learn Enchant Gloves - Mighty Strength##74254
	step
		goto Orgrimmar 53.2,48.8
		.talk Kithas##3346
		.buy 1 Formula: Enchant Weapon - Landslide##52736 |n
		.learn Enchant Weapon - Landslide##74246
	step
		goto Orgrimmar 53.2,48.8
		.talk Kithas##3346
		.buy 1 Formula: Enchant Weapon - Power Torrent##52733 |n
		.learn Enchant Weapon - Power Torrent##74242
	step
		goto Orgrimmar 53.2,48.8
		.talk Kithas##3346
		.buy 1 Formula: Enchant Weapon - Windwalk##52735 |n
		.learn Enchant Weapon - Windwalk##74244
	step
		#include "trainer_Enchanting"
		.learn Enchant Boots - Greater Precision##104408
	step
		#include "trainer_Enchanting"
		.learn Enchant Bracer - Major Dodge##104385
	step
		#include "trainer_Enchanting"
		.learn Enchant Chest - Mighty Spirit##104393
	step
		#include "trainer_Enchanting"
		.learn Enchant Chest - Super Resilience##104392
	step
		#include "trainer_Enchanting"
		.learn Enchant Cloak - Superior Intellect##104403
	step
		#include "trainer_Enchanting"
		.learn Enchant Gloves - Greater Haste##104416
	step
		#include "trainer_Enchanting"
		.learn Enchant Weapon - Elemental Force##104430
	step
		#include "trainer_Enchanting"
		.learn Ethereal Shard##116498
	step
		#include "trainer_Enchanting"
		.learn Enchant Ring - Greater Agility##103461
	step
		#include "trainer_Enchanting"
		.learn Enchant Ring - Greater Intellect##103462
	step
		#include "trainer_Enchanting"
		.learn Enchant Ring - Greater Stamina##103463
	step
		#include "trainer_Enchanting"
		.learn Enchant Ring - Greater Strength##103465
	step
		#include "trainer_Enchanting"
		.learn Enchant Boots - Blurred Speed##104409
	step
		#include "trainer_Enchanting"
		.learn Enchant Boots - Greater Haste##104407
	step
		#include "trainer_Enchanting"
		.learn Enchant Chest - Superior Stamina##104397
	step
		#include "trainer_Enchanting"
		.learn Enchant Cloak - Accuracy##104398
	step
		#include "trainer_Enchanting"
		.learn Enchant Gloves - Superior Expertise##104417
	step
		#include "trainer_Enchanting"
		.learn Enchant Weapon - Windsong##104425
	step
		#include "trainer_Enchanting"
		.learn Enchant Boots - Pandaren's Step##10414
	step
		#include "trainer_Enchanting"
		.learn Enchant Chest - Glorious Stats##104395
	step
		#include "trainer_Enchanting"
		.learn Enchant Cloak - Greater Protection##104401
	step
		#include "trainer_Enchanting"
		.learn Enchant Gloves - Super Strength##104419
	step
		#include "trainer_Enchanting"
		.learn Enchant Gloves - Superior Mastery##104420
	step
		#include "trainer_Enchanting"
		.learn Enchant Off-Hand - Major Intellect##104445
	step
		#include "trainer_Enchanting"
		.learn Enchant Shield - Greater Parry##130758
	step
		#include "trainer_Enchanting"
		.learn Enchant Weapon - Colossus##104440
	step
		#include "trainer_Enchanting"
		.learn Ethereal Shatter##118238
	step
		#include "trainer_Enchanting"
		.learn Sha Crystal##116499
	step
		#include "trainer_Enchanting"
		.learn Sha Shatter##118239
	step
		#include "trainer_Enchanting"
		.learn Enchant Bracer - Exceptional Strength##104390
	step
		goto Shrine of Two Moons 62.6,23.2
		.talk Sage Lotusbloom##64001
		|tip You must be Revered with The August Celestials to purchase this Formula.
		.buy 1 Formula: Enchant Bracer - Exceptional Strength##84561 |n
		.learn Enchant Bracer - Exceptional Strength##104390
	step
		goto Shrine of Two Moons 62.6,23.2
		.talk Sage Lotusbloom##64001
		|tip You must be Revered with The August Celestials to purchase this Formula.
		.buy 1 Formula: Enchant Bracer - Greater Agility##84557 |n
		.learn Enchant Bracer - Greater Agility##104391
	step
		goto Shrine of Two Moons 62.6,23.2
		.talk Sage Lotusbloom##64001
		|tip You must be Revered with The August Celestials to purchase this Formula.
		.buy 1 Formula: Enchant Bracer - Super Intellect##84559 |n
		.learn Enchant Bracer - Super Intellect##104389
	step
		goto Townlong Steppes 48.8,70.6
		.talk Rushi the Fox##64595
		|tip You must be Revered with Shado-Pan to purchase this Formula.
		.buy 1 Formula: Enchant Weapon - Dancing Steel##84584 |n
		.learn Enchant Weapon - Dancing Steel##104434
	step
		goto Townlong Steppes 48.8,70.6
		.talk Rushi the Fox##64595
		|tip You must be Revered with Shado-Pan to purchase this Formula.
		.buy 1 Formula: Enchant Weapon - Jade Spirit##84583 |n
		.learn Enchant Weapon - Jade Spirit##104427
	step
		goto Townlong Steppes 48.8,70.6
		.talk Rushi the Fox##64595
		|tip You must be Revered with Shado-Pan to purchase this Formula.
		.buy 1 Formula: Enchant Weapon - River's Song##84580 |n
		.learn Enchant Weapon - River's Song##104442
]])

ZygorGuidesViewer:RegisterInclude("Profession_List_Cooking",[[
		'This Recipe is learned by learning the Cooking Skill.
		.learn Charred Wolf Meat##2538
	step
		'This Recipe is learned by learning the Cooking Skill.
		.learn Herb Baked Egg##8604
	step
		'This Recipe is learned by learning the Cooking Skill.
		.learn Roasted Boar Meat##2540
	step
		#include "trainer_Cooking_MoP"
		.learn Sliced Peaches##125117
	step
		'This can only be obtained during the Day of the Dead Holiday Event. This is from October 1 - October 2
		goto Stormwind City 47.0,25.4
		.talk Chapman##34382
		.buy Recipe: Bread of the Dead##46710 |n
		.learn Bread of the Dead##65454
	step
		#include "trainer_Cooking"
		.learn Spice Bread##37836
	step
		goto Undercity 81.8,30.6
		.talk Lizbeth Cromwell##4574
		.buy Recipe: Brilliant Smallfish##6325 |n
		.learn Brilliant Smallfish##7751
	step
		goto Tirisfal Glades 61.0,51.0
		|tip This is only a Horde Recipe and may sell well on the Neutral AH.
		.talk Abigail Shiel##2118
		.buy Recipe: Crispy Bat Wing##12226 |n
		.learn Crispy Bat Wing##15935
	step
		'This can only be obtained during the Feast of Winter Veil Holiday Event. This is from December 15 - Janurary 2.
		goto Orgrimmar 52.6,77.6
		.talk Penney Copperpinch##13420
		.buy Recipe: Gingerbread Cookie##17200 |n
		.learn Gingerbread Cookie##21143
	step  
		goto Eversong Woods 49.0,47.0
		.talk Landraelanis##16262
		.buy Recipe: Lynx Steak##27685 |n
		.learn Lynx Steak##33276
	step
		'This is a reward from a quest available only to Alliance.
		.' You may be able to find this on the Neutral AH.
		.collect Recipe: Roasted Moongraze Tenderloin##27686 |n
		.learn Roasted Moongraze Tenderloin##33277
	step
		goto Durotar 57.4,77.0
		.talk Zansoa##5942
		.buy Recipe: Slitherskin Mackerel##6326 |n
		.learn Slitherskin Mackerel##7752
	step
		'This is a reward from doing Cooking and Fishing Dailies in Shattrath
		goto Shattrath City 61.6,16.6
		.talk The Rokk##24393
		.collect Crate of Meat##33857 |n
		.collect Barrel of Fish##33844 |n
		.collect Small Spice Bag##44113 |n
		.' Open the Crate, Barrel or Spice Bag
		.collect Recipe: Delicious Chocolate Cake##33925 |n
		.learn Delicious Chocolate Cake##43779
	step
		'This can only be obtained during the Pilgrim's Bounty Holiday Event. This is from November 24 - November 30.
		goto Durotar 46.6,13.8
		.clicknpc Bountiful Barrel##35342
		.buy Bountiful Cookbook##46810 |n
		.collect Recipe: Spice Bread Stuffing##46803 |n
		.learn Spice Bread Stuffing##66038
	step
		goto Northern Barrens 55.4,61.2
		.talk Grub##3443
		.buy Recipe: Dig Rat Stew##44977 |n
		.learn Dig Rat Stew##6417
	step
		'This recipe is no longer in the game due to a quest that no longer exists.
		.collect Recipe: Big Bear Steak##3734 |n
		.learn Big Bear Steak##3397
	step
		#include "trainer_Cooking"
		.learn Kaldorei Spider Kabob##6412
	step
		#include "trainer_Cooking"
		.learn Spiced Wolf Meat##2539
	step
		'This is available only to Alliance.
		.' You may be able to find this on the Neutral AH.
		.collect Recipe: Beer Basted Boar Ribs##2889 |n
		.learn Beer Basted Boar Ribs##2795
	step
		goto Durotar 50.8,42.8
		.talk Grimtak##3881
		|tip This is only available to Horde and may sell well on the Neutral AH.
		.buy Recipe: Scorpid Surprise##5483 |n
		.learn Scorpid Surprise##6413
	step
		#include "trainer_Cooking_MoP"
		.learn Perfectly Cooked Instant Noodles##125067
	step
		'This can only be obtained during the Feast of Winter Veil Holiday Event. This is from December 15 - Janurary 2.
		goto Orgrimmar 52.6,77.6
		.talk Penney Copperpinch##13420
		.buy Recipe: Egg Nog##17201 |n
		.learn Egg Nog##21144
	step
		goto Mulgore 46.4,57.8
		.talk Wunna Darkmane##3081
		|tip This is only available to Horde and may sell well on the Neutral AH.
		.buy Recipe: Roasted Kodo Meat##5484 |n
		.learn Roasted Kodo Meat##6414
	step	
		goto Silverpine Forest 43.2,40.6
		.talk Andrew Hilbert##3556
		.buy Recipe: Smoked Bear Meat##6892 |n
		.learn Smoked Bear Meat##8607
	step
		#include "trainer_Cooking"
		.learn Venison Jerky##93741
	step
		goto Ghostlands 48.4,31.0
		.talk Master Chef Mouldier##16253
		|tip This is only available to Horde and may sell well on the Neutral AH.
		.buy Recipe: Bat Bites##27687 |n
		.learn Bat Bites##33278
	step
		#include "trainer_Cooking"
		.learn Boiled Clams##6499
	step
		#include "trainer_Cooking"
		.learn Coyote Steak##2541
	step
		#include "trainer_Cooking"
		.learn Fillet of Frenzy##6415
	step
		'This is Available only to Alliance.
		.' You may be able to find this on the Neutral AH.
		.buy Recipe: Goretusk Liver Pie##2697 |n
		.learn Goretusk Liver Pie##2542
	step
		'This is Available only to Alliance.
		.' You may be able to find this on the Neutral AH.
		.buy Recipe: Loch Frenzy Delight##6329 |n
		.learn Loch Frenzy Delight##7754
	step
		goto Undercity 81.8,30.6
		.talk Lizbeth Cromwell##4574
		.buy Recipe: Longjaw Mud Snapper##6328 |n
		.learn Longjaw Mud Snapper##7753
	step
		goto Northern Barrens 68.6,72.6
		.talk Kilxx##3497
		.buy Recipe: Rainbow Fin Albacore##6368 |n
		.learn Rainbow Fin Albacore
	step
		goto Northern Barrens 49.0,58.2
		.talk Tari'qa##3482
		|tip This is only available to Horde and may sell well on the Neutral AH.
		.buy Recipe: Strider Stew##5486 |n
		.learn Strider Stew##6416
	step
		'This is a Random World Drop, from creatures level 9-15 and in some dungeons.
		|tip We recommend Westfall and The Deadmines for grinding.
		.collect Recipe: Westfall Stew##728 |n
		.learn Westfall Stew##2543
	step
		#include "trainer_Cooking_MoP"
		.learn Toasted Fish Jerky##124225
	step
		'This is a reward from a quest available only to Alliance.
		.' You may be able to find this on the Neutral AH.
		.collect Recipe: Blood Sausage |n
		.learn Blood Sausage##3371
	step
		'This is a reward from doing the quest Thelsamar Blood Sausages.
		goto Ghostlands 48.4,31.0
		.talk Master Chef Mouldier##16253
		|tip This quest is only available to Horde and may sell well on the Neutral AH.
		..accept Culinary Crunch##9171
		..turnin Culinary Crunch##9171
		.collect Recipe: Crunchy Spider Surprise##22647 |n
		.learn Crunchy Spider Surprise##28267
	step
		goto Hillsbrad Foothills 71.0,45.8
		.talk Smudge Thunderwood##6779
		.buy Recipe: Thistle Tea##18160 |n
		.learn Thistle Tea##9513
	step
		#include "trainer_Cooking"
		.learn Crab Cake
	step
		'This is Available only to Alliance.
		.' You may be able to find this on the Neutral AH.
		.buy Recipe: Crocolisk Steak##3678 |n
		.learn Crocolisk Steak##3370
	step
		#include "trainer_Cooking"
		.learn Dry Pork Ribs##2546
	step
		goto Orgrimmar 39.0,85.6
		.talk Karizi Porkpatty##45551
		.buy Recipe: Smoked Sagefish##21099 |n
		.learn Smoked Sagefish##25704
	step
		goto Stormwind City 76.6,53.6
		.talk Kendor Kabonka##340
		.buy Recipe: Cooked Crab Claw##2698 |n
		.learn Cooked Crab Claw##2545
	step
		'This is a Random World Drop, from creatures level 9-15 and in some dungeons.
		.collect Recipe: Savory Deviate Delight##6661 |n
		.learn Savory Deviate Delight##8238
	step
		#include "trainer_Cooking_MoP"
		.learn Dried Needle Mushrooms##124227
	step
		'This is Available only to Alliance.
		.' You may be able to find this on the Neutral AH.
		.buy Recipe: Clam Chowder##5528 |n
		.learn Clam Chowder##6501
	step
		'This is Available only to Alliance.
		.' You may be able to find this on the Neutral AH.
		.buy Recipe: Murloc Fin Soup##3680 |n
		.learn Murloc Fin Soup##3372
	step
		goto Westfall 54.6,49.8
		.from Riverpaw Bandit##54371
		|tip You can also obtain this through items by fishing.
		.collect Recipe: Captain Rumsey's Lager##34834 |n
		.learn Captain Rumsey's Lager##45695
	step
		'This is Available only to Alliance.
		.' You may be able to find this on the Neutral AH.
		.buy Recipe: Redridge Goulash##2699 |n
		.learn Redridge Goulash##2547
	step
		goto Northern Barrens 68.6,72.6
		.talk Kilxx##3497
		.buy Recipe: Bristle Whisker Catfish##6330 |n |use Recipe: Bristle Whisker Catfish##6330
		.learn Bristle Whisker Catfish##7755
	step
		goto Northern Barrens 49.0,58.2
		.talk Tari'qa##3482
		|tip This is only available to Horde and may sell well on the Neutral AH.
		.buy Recipe: Crispy Lizard Tail##5488 |n
		.learn Crispy Lizard Tail##6418
	step
		'This is a reward from a quest available only to Alliance.
		.' You may be able to find this on the Neutral AH.
		.collect Recipe: Seasoned Wolf Kabob##2701 |n
		.learn Seasoned Wolf Kabob##2549
	step
		'This can only be obtained during the Pilgrim's Bounty Holiday Event. This is from November 24 - November 30.
		goto Durotar 46.6,13.8
		.clicknpc Bountiful Barrel##35342
		.buy Bountiful Cookbook##46810 |n
		.collect Recipe: Pumpkin Pie##46804 |n
		.learn Pumpkin Pie##66036
	step
		'This is a Random World Drop, from creatures level 11-19 in Loch Modan.
		.collect Recipe: Succulent Pork Ribs##2700 |n
		.learn Succulent Pork Ribs##2548
	step
		'This is a reward from a quest available only to Alliance.
		.' You may be able to find this on the Neutral AH.
		.collect Recipe: Gooey Spider Cake##3683 |n
		.learn Gooey Spider Cake##3377
	step
		'This recipe is no longer in the game due to a quest that no longer exists.
		.collect Recipe: Lean Venison##5489 |n
		.learn Lean Venison##6419
	step
		#include "trainer_Cooking_MoP"
		.learn Pounded Rice Cake##124223
	step
		'This is Available only to Alliance.
		.' You may be able to find this on the Neutral AH.
		.buy Recipe: Crocolisk Gumbo##3681 |n
		.learn Crocolisk Gumbo##3373
	step
		#include "trainer_Cooking"
		.learn Goblin Deviled Clams##6500
	step
		'This recipe is no longer in the game due to a quest that no longer exists.
		.collect Recipe: Lean Wolf Steak##12227 |n
		.learn Lean Wolf Steak##15853
	step
		goto Northern Barrens 50.6,57.8
		.talk Zargh##3489
		|tip This is only available to Horde and may sell well on the Neutral AH.
		.buy Recipe: Hot Lion Chops##3735 |n
		.learn Hot Lion Chops##3398
	step
		goto Northern Stranglethorn 39.2,51.0
		.talk Nerrist##1148
		.buy Recipe: Curiously Tasty Omelet##3682 |n
		.learn Curiously Tasty Omelet##3376
	step
		goto Dustwallow Marsh 36.6,31.0
		.talk Ogg'marr##4879
		|tip This is only available to Horde and may sell well on the Neutral AH.
		.buy Recipe: Heavy Crocolisk Stew##20075 |n
		.learn Heavy Crocolisk Stew##24418
	step
		#include "trainer_Cooking_MoP"
		.learn Yak Cheese Curds##124224
	step
		#include "trainer_Cooking"
		.learn Tasty Lion Steak##3399
	step
		'This can only be obtained during the Pilgrim's Bounty Holiday Event. This is from November 24 - November 30.
		goto Durotar 46.6,13.8
		.clicknpc Bountiful Barrel##35342
		.buy Bountiful Cookbook##46810 |n
		.collect Recipe: Cranberry Chutney##46805 |n
		.learn Cranberry Chutney##66035
	step
		goto Razorfen Downs 80.6,17.0
		.talk Henry Stern##8696
		.learn Goldthorn Tea##13028
	step
		goto The Cape of Stranglethorn 42.8,69.0
		.talk Kelsey Yance##2664
		.buy Recipe: Rockscale Cod##6369 |n
		.learn Rockscale Cod##7828
	step
		#include "trainer_Cooking"
		.learn Barbecued Buzzard Wing##4094
	step
		goto Swamp of Sorrows 46.6,57.0
		.talk Banalash##989
		|tip This is only available to Horde and may sell well on the Neutral AH.
		.buy Recipe: Carrion Surprise##12232 |n
		.learn Carrion Surprise##15863
		.' You can also purchase this from Kireena here: [Desolace 51.0,53.4]
		'|talk Kireena##9636
	step
		goto The Cape of Stranglethorn 42.8,69.0
		.talk Kelsey Yance##2664
		.buy Recipe: Giant Clam Scorcho##6039 |n
		.learn Giant Clam Scorcho##7213
	step	
		goto Feralas 74.6,42.8
		.talk Sheendra Tallgrass##8145
		.buy Recipe: Hot Wolf Ribs##12229 |n
		.learn Hot Wolf Ribs##15856
	step
		goto Northern Stranglethorn 39.2,51.0
		.talk Nerrist##1148
		.buy Recipe: Jungle Stew##12231 |n
		.learn Jungle Stew##15861
	step
		goto The Cape of Stranglethorn 42.8,69.0
		.talk Kelsey Yance##2664
		.buy Recipe: Mithril Head Trout##17062 |n
		.learn Mithril Head Trout##20916
	step
		goto Dustwallow Marsh 66.4,51.4
		.talk Helenia Olden##4897
		.buy Recipe: Mystery Stew##12233 |n
		.learn Mystery Stew##15865
	step
		goto Northern Stranglethorn 39.2,51.0
		.talk Nerrist##1148
		.buy Recipe: Roast Raptor##12228 |n
		.learn Roast Raptor##15855
	step
		goto Shattrath City 63.6,68.6
		.talk Jim Saltit##19195
		.buy Recipe: Sagefish Delight##21219 |n
		.learn Sagefish Delight##25954
	step
		#include "trainer_Cooking"
		.learn Soothing Turtle Bisque##3400
	step
		#include "trainer_Cooking_MoP"
		.learn Dried Peaches##124226
	step
		goto Dustwallow Marsh 36.6,31.0
		.talk Ogg'marr##4879
		.buy Recipe: Dragonbreath Chili##12239 |n
		.learn Dragonbreath Chili##15906
	step
		goto Desolace 51.0,53.4
		.talk Kireena##9636
		.buy Recipe: Heavy Kodo Stew##12240 |n
		.learn Heavy Kodo Stew##15910
	step
		#include "trainer_Cooking"
		.learn Spider Sausage##21175
	step
		#include "trainer_Cooking_MoP"
		.learn Boiled Silkworm Pupa##124228
	step
		'This can only be obtained during the Pilgrim's Bounty Holiday Event. This is from November 24 - November 30.
		goto Durotar 46.6,13.8
		.clicknpc Bountiful Barrel##35342
		.buy Bountiful Cookbook##46810 |n
		.collect Recipe: Candied Sweet Potato##46806 |n
		.learn Candied Sweet Potato##66034
	step
		goto The Cape of Stranglethorn 42.8,69.0
		.talk Kelsey Yance##2664
		.buy Recipe: Cooked Glossy Mightfish##13940 |n
		.learn Cooked Glossy Mightfish##18239
	step
		goto The Cape of Stranglethorn 42.8,69.0
		.talk Kelsey Yance##2664
		.buy Recipe: Filet of Redgill##13941 |n
		.learn Filet of Redgill##18241
	step
		goto Winterspring 59.8,51.6
		.talk Himmik##11187
		.buy Recipe: Monster Omelet##16110 |n
		.learn Monster Omelet##15933
	step
		goto Northern Stranglethorn 37.6,49.2
		.talk Uthok##1149
		.buy Recipe: Spiced Chili Crab##16111 |n
		.learn Spiced Chili Crab##15915
	step
		#include "trainer_Cooking"
		.learn Spotted Yellowtail##18238
	step
		goto Tanaris 52.6,29.0
		.talk Dirge Quikcleave##40589
		.buy Recipe: Tender Wolf Steak##18046 |n
		.learn Tender Wolf Steak##22480
	step
		goto The Cape of Stranglethorn 42.6,72.8
		.talk Mrs. Gant##54232
		.buy Recipe: Undermine Clam Chowder##16767 |n
		.learn Undermine Clam Chowder##20626
	step
		#include "trainer_Cooking"
		.learn Grilled Squid##18240
	step
		goto The Cape of Stranglethorn 42.8,69.0
		.talk Kelsey Yance##2664
		.buy Recipe: Hot Smoked Bass##13943 |n
		.learn Hot Smoked Bass##18242
	step
		#include "trainer_Cooking_MoP"
		.learn Roasted Barley Tea##125078
	step
		'This Recipe is learned by completing the quest Clamlette Surprise.
		goto Tanaris 52.6,29.0
		.talk Dirge Quikcleave##40589
		..accept Clamlette Surprise##6610
		..turnin Clamlette Surprise##6610
		.learn Clamlette Magnifique##64054
	step
		#include "trainer_Cooking"
		.learn Charred Bear Kabobs##46684
	step
		#include "trainer_Cooking"
		.learn Juicy Bear Burger##46688
	step
		#include "trainer_Cooking"
		.learn Nightfin Soup##18243
	step
		#include "trainer_Cooking"
		.learn Poached Sunscale Salmon##18244
	step
		goto Feralas 74.6,42.8
		.talk Sheendra Tallgrass##8145
		.buy Recipe: Baked Salmon##13949 |n
		.learn Baked Salmon##18247
	step
		goto Feralas 74.6,42.8
		.talk Sheendra Tallgrass##8145
		.buy Recipe: Lobster Stew##13947 |n
		.learn Lobster Stew##18245
	step
		goto The Cape of Stranglethorn 42.8,69.0
		.talk Kelsey Yance##2664
		.buy Recipe: Mightfish Steak##13948 |n
		.learn Mightfish Steak##18246
	step
		goto Dire Maul/5 75.6,44.8
		.from Pusillin##14354
		.collect Recipe: Runn Tum Tuber Surprise##18267 |n
		.learn Runn Tum Tuber Surprise##22761
	step
		'This can only be obtained during the Pilgrim's Bounty Holiday Event. This is from November 24 - November 30.
		goto Durotar 46.6,13.8
		.clicknpc Bountiful Barrel##35342
		.buy Bountiful Cookbook##46810 |n
		.collect Recipe: Slow-Roasted Turkey##46807 |n
		.learn Slow-Roasted Turkey##66037
	step
		goto Silithus 55.5,36.8
		.talk Calandrath##15174
		..accept Desert Recipe##8307
		goto Silithus 43.6,42.0
		.click Sandy Cookbook##470
		..turnin Desert Recipe##8307
		..accept Sharing the Knowledge##8313
		goto Silithus 55.5,36.8
		.talk Calandrath##15174
		..turnin Sharing the Knowledge##8313
		.learn Smoked Desert Dumplings##24801
	step
		goto Zangarmarsh 31.6,49.2
		.talk Gambarinka##18015
		.buy Recipe: Blackened Trout##27694 |n
		.learn Blackened Trout##33290
	step
		'This is a reward from doing Fishing Dailies in Shattrath
		goto Shattrath City 61.6,16.6
		.talk The Rokk##24393
		.collect Barrel of Fish##33844 |n
		.' Open the Barrel in your bags |use Barrel of Fish##33844
		.collect Recipe: Broiled Bloodfin##33869 |n
		.learn Broiled Bloodfin##43761
	step
		goto Hellfire Peninsula 49.2,74.8
		.talk Legassi##19344
		..accept Smooth as Butter##9356
		..turnin Smooth as Butter##9356
		.collect Recipe: Buzzard Bites##27684 |n
		.learn Buzzard Bites##33279
	step
		goto Zangarmarsh 17.8,51.2
		.talk Mycah##18382
		.buy Recipe: Clam Bar##30156 |n
		.learn Clam Bar##36210
	step
		goto Zangarmarsh 85.2,54.6
		.talk Zurai##18011
		.buy Recipe: Feltail Delight##27695 |n
		.learn Feltail Delight##33291
	step
		goto Hellfire Peninsula 54.6,41.0
		.talk Cookie One-Eye##16585
		.buy Recipe: Ravager Dog##27688 |n
		.learn Ravager Dog##33284
	step
		'This is a reward from doing Cooking and Fishing Dailies in Shattrath
		goto Shattrath City 61.6,16.6
		.talk The Rokk##24393
		.collect Crate of Meat##33857 |n
		.collect Barrel of Fish##33844 |n
		.collect Small Spice Bag##44113 |n
		.' Open the Crate, Barrel or Spice Bag
		.collect Recipe: Stormchops##33871 |n
		.learn Stormchops##43758
	step
		'This Recipe is no longer in the game due to a quest that has been taken out.
		.collect Recipe: Dirge's Kickin' Chimaerok Chops##21025 |n
		.learn Dirge's Kickin' Chimaerok Chops##25659
	step
		'This is a reward from doing Cooking and Fishing Dailies in Shattrath
		goto Shattrath City 61.6,16.6
		.talk The Rokk##24393
		.collect Crate of Meat##33857 |n
		.collect Barrel of Fish##33844 |n
		.' Open the Crate or the Barrel
		.collect Recipe: Kibler's Bits##33875 |n
		.learn Kibler's Bits##43772
	step
		goto Zangarmarsh 78.0,66.0
		.talk Juno Dufrain##18911
		.buy Recipe: Blackened Sporefish##27696 |n
		.learn Blackened Sporefish##33292
	step
		goto Terokkar Forest 48.8,45.0
		.talk Innkeeper Grilka##18957
		.collect Recipe: Blackened Basilisk##27690 |n
		.learn Blackened Basilisk##33286
	step
		#include "trainer_Cooking"
		.learn Stewed Trout##42296
	step
		goto Nagrand 58.0,35.6
		.talk Nula the Butcher##20097
		.buy Recipe: Grilled Mudfish##27697 |n
		.learn Grilled Mudfish##33293
	step
		goto Nagrand 58.0,35.6
		.talk Nula the Butcher##20097
		.buy Recipe: Poached Bluefish##27698 |n
		.learn Poached Bluefish##33294
	step
		goto Orgrimmar 52.6,77.6
		.talk Penney Copperpinch##13420
		.buy Recipe: Hot Apple Cider##34413 |n
		.learn Hot Apple Cider##45022
	step
		'This is a reward from doing Cooking and Fishing Dailies in Shattrath
		goto Shattrath City 61.6,16.6
		.talk The Rokk##24393
		.collect Barrel of Fish##33844 |n
		.' Open the Barrel in your bags |use Barrel of Fish##33844
		.collect Recipe: Skullfish Soup##33870 |n
		.learn Skullfish Soup##43707
	step
		'This is a reward from doing Cooking and Fishing Dailies in Shattrath
		goto Shattrath City 61.6,16.6
		.talk The Rokk##24393
		.collect Crate of Meat##33857 |n
		.' Open the Crate in your bags |use Crate of Meat##33857
		.collect Recipe: Spicy Hot Talbuk##33873 |n
		.learn Spicy Hot Talbuk##43765
	step
		goto Terokkar Forest 48.8,46.0
		.talk Rungor##18960
		.buy Recipe: Golden Fish Sticks##27699 |n
		.learn Golden Fish Sticks##33295
	step
		goto Nagrand 58.0,35.6
		.talk Nula the Butcher##20097
		.buy Recipe: Roasted Clefthoof##27691 |n
		.learn Roasted Clefthoof##33287
	step
		goto Nagrand 58.0,35.6
		.talk Nula the Butcher##20097
		.buy Recipe: Talbuk Steak##27693 |n
		.learn Talbuk Steak##33289
	step
		goto Terokkar Forest 48.8,45.0
		.talk Innkeeper Grilka##18957
		.buy Recipe: Warp Burger##27692 |n
		.learn Warp Burger##33288
	step
		#include "trainer_Cooking_MoP"
		.learn Blanched Needle Mushrooms##124233
	step
		goto Blade's Edge Mountains 62.4,40.2
		.talk Xerintha Ravenoak##20916
		.buy Recipe: Crunchy Serpent##31674 |n
		.learn Crunchy Serpent##38868
	step
		goto Blade's Edge Mountains 62.4,40.2
		.talk Xerintha Ravenoak##20916
		.buy Recipe: Mok'Nathal Shortribs##31675 |n
		.learn Mok'Nathal Shortribs##38867
	step
		'This is a Random World Drop, from creatures level 68-82 in some dungeons and raids.
		|tip We recommend Icecrown Citadel or Ulduar for grinding.
		.collect Recipe: Bad Clams##43509 |n
		.learn Bad Clams##58523
	step
		'This is a Random World Drop, from creatures level 68-82 in some dungeons and raids.
		|tip We recommend Icecrown Citadel or Ulduar for grinding.
		.collect Recipe: Haunted Herring##43510 |n
		.learn Haunted Herring##58525
	step
		'This is a Random World Drop, from creatures level 68-82 in some dungeons and raids.
		|tip We recommend Icecrown Citadel or Ulduar for grinding.
		.collect Recipe: Last Week's Mammoth##43508 |n
		.learn Last Week's Mammoth##58521
	step
		'This is a Random World Drop, from creatures level 68-82 in some dungeons and raids.
		|tip We recommend Icecrown Citadel or Ulduar for grinding.
		.collect Recipe: Tasty Cupcake##43507 |n
		.learn Tasty Cupcake##58512
	step
		#include "trainer_Cooking"
		.learn Grilled Bonescale##45561
	step
		'This Recipe is acquired by doing the quest Northern Cooking
		goto Borean Tundra 42.0,54.2
		.talk Orn Tenderhoof##26972
		..accept Northern Cooking##13090
		..turnin Northern Cooking##13090
		.learn Northern Stew##57421
	step
		#include "trainer_Cooking"
		.learn Sauteed Goby##45562
	step
		#include "trainer_Cooking"
		.learn Smoked Rockfin##45560
	step
		#include "trainer_Cooking"
		.learn Baked Manta Ray##45569
	step
		#include "trainer_Cooking"
		.learn Dalaran Clam Chowder##58065
	step
		#include "trainer_Cooking"
		.learn Grilled Sculpin##45563
	step
		#include "trainer_Cooking"
		.learn Mammoth Meal##45549
	step
		#include "trainer_Cooking"
		.learn Pickled Fangtooth##45566
	step
		#include "trainer_Cooking"
		.learn Poached Nettlefish##45565
	step
		#include "trainer_Cooking"
		.learn Rhino Dogs##45533
	step
		#include "trainer_Cooking"
		.learn Roasted Worg##45552
	step
		#include "trainer_Cooking"
		.learn Shoveltusk Steak##45550
	step
		#include "trainer_Cooking"
		.learn Smoked Salmon##45564
	step
		#include "trainer_Cooking"
		.learn Worm Delight##45551
	step
		goto Terokkar Forest 48.8,46.0
		.talk Rungor##18960
		.buy Recipe: Spicy Crawdad##27700 |n
		.learn Spicy Crawdad##33296
	step
		#include "trainer_Cooking"
		.learn Fisherman's Feast##42302
	step
		#include "trainer_Cooking"
		.learn Hot Buttered Trout##42305
	step
		'This Recipe is acquired by completing the quest Fletcher's Lost and Found.
		goto Dalaran/2 44.2,25.6
		.talk Washed-Up Mage##32516
		..accept Fletcher's Lost and Found##13571
		..turnin Fletcher's Lost and Found##13571
		.collect Recipe: Kungaloosh##19644 |n
		.learn Kungaloosh##53056
	step
		#include "trainer_Cooking_MoP"
		.learn Red Bean Bun##124229
	step
		#include "trainer_Cooking"
		.learn Great Feast##45554
	step
		#include "trainer_Cooking_MoP"
		.learn Skewered Peanut Chicken##124234
	step
		goto Icecrown 72.4,20.8
		.talk Mera Mistrunner##33595
		.buy Recipe: Worg Tartare##44954 |n
		.learn Worg Tartare##62350
	step
		#include "trainer_Cooking"
		.learn Black Jelly##64358
	step
		goto Dalaran 70.2,37.2
		.talk Misensi##31031
		.buy Recipe: Blackened Dragonfin##43035 |n
		.learn Blackened Dragonfin##57441
	step
		goto Dalaran 70.2,37.2
		.talk Misensi##31031
		.buy Recipe: Blackened Worg Steak##43032 |n
		.learn Blackened Worg Steak##57438
	step
		goto Dalaran 70.2,37.2
		.talk Misensi##31031
		.buy Recipe: Critter Bites##43029 |n
		.learn Critter Bites##57435
	step
		goto Dalaran 70.2,37.2
		.talk Misensi##31031
		.buy Recipe: Cuttlesteak##43033 |n
		.learn Cuttlesteak##57439
	step
		goto Dalaran 70.2,37.2
		.talk Misensi##31031
		.buy Recipe: Dragonfin Filet##43036 |n
		.learn Dragonfin Filet##57442
	step
		goto Dalaran 70.2,37.2
		.talk Misensi##31031
		.buy Recipe: Firecracker Salmon##43024 |n
		.learn Firecracker Salmon##45568
	step
		goto Dalaran 70.2,37.2
		.talk Misensi##31031
		.buy Recipe: Hearty Rhino##43030 |n
		.learn Hearty Rhino##57436
	step
		goto Dalaran 70.2,37.2
		.talk Misensi##31031
		.buy Recipe: Imperial Manta Steak##43026 |n
		.learn Imperial Manta Steak##45570
	step
		goto Dalaran 70.2,37.2
		.talk Misensi##31031
		.buy Recipe: Mega Mammoth Meal##43018 |n
		.learn Mega Mammoth Meal##45555
	step
		goto Dalaran 70.2,37.2
		.talk Misensi##31031
		.buy Recipe: Mighty Rhino Dogs##43022 |n
		.learn Mighty Rhino Dogs##45559
	step
		goto Dalaran 70.2,37.2
		.talk Misensi##31031
		.buy Recipe: Poached Northern Sculpin##43023 |n
		.learn Poached Northern Sculpin##45567
	step
		goto Dalaran 70.2,37.2
		.talk Misensi##31031
		.buy Recipe: Rhinolicious Wormsteak##43028 |n
		.learn Rhinolicious Wormsteak##57434
	step
		goto Dalaran 70.2,37.2
		.talk Misensi##31031
		.buy Recipe: Snapper Extreme##43031 |n
		.learn Snapper Extreme##57437
	step
		goto Dalaran 70.2,37.2
		.talk Misensi##31031
		.buy Recipe: Spiced Mammoth Treats##43034 |n
		.learn Spiced Mammoth Treats##57440
	step
		goto Dalaran 70.2,37.2
		.talk Misensi##31031
		.buy Recipe: Spiced Worm Burger##43020 |n
		.learn Spiced Worm Burger##45557
	step
		goto Dalaran 70.2,37.2
		.talk Misensi##31031
		.buy Recipe: Spicy Blue Nettlefish##43025 |n
		.learn Spicy Blue Nettlefish##45571
	step
		goto Dalaran 70.2,37.2
		.talk Misensi##31031
		.buy Recipe: Spicy Fried Herring##43027 |n
		.learn Spicy Fried Herring##57433
	step
		goto Dalaran 70.2,37.2
		.talk Misensi##31031
		.buy Recipe: Tender Shoveltusk Steak##43019 |n
		.learn Tender Shoveltusk Steak##45556
	step
		goto Dalaran 70.2,37.2
		.talk Misensi##31031
		.buy Recipe: Tracker Snacks##43037 |n
		.learn Tracker Snacks##57443
	step
		goto Dalaran 70.2,37.2
		.talk Misensi##31031
		.buy Recipe: Very Burnt Worg##43021 |n
		.learn Very Burnt Worg##45558
	step
		#include "trainer_Cooking"
		.learn Darkbrew Lager##88015
	step
		#include "trainer_Cooking_MoP"
		.learn Green Curry Fish##124231
	step
		goto Dalaran 70.2,37.2
		.talk Misensi##31031
		.buy Recipe: Small Feast##43506 |n
		.learn Small Feast##58528
	step
		goto Dalaran 70.2,37.2
		.talk Misensi##31031
		.buy Recipe: Gigantic Feast##43505 |n
		.learn Gigantic Feast##58527
	step
		#include "trainer_Cooking"
		.learn Blackened Surprise##88006
	step
		goto Orgrimmar 56.8,62.6
		.talk Shazdar##49737
		.buy Recipe: Feathered Lure##65408 |n
		.learn Feathered Lure##88017
	step
		goto Dalaran 70.2,37.2
		.talk Misensi##31031
		.buy Recipe: Fish Feast##43017 |n
		.learn Fish Feast##43015
	step
		goto Orgrimmar 56.8,62.6
		.talk Shazdar##49737
		.buy Recipe: Highland Spirits##65415 |n
		.learn Highland Spirits##88022
	step
		goto Orgrimmar 56.8,62.6
		.talk Shazdar##49737
		.buy Recipe: Starfire Espresso##65414 |n
		.learn Starfire Espresso##88045
	step
		goto Orgrimmar 56.8,62.6
		.talk Shazdar##49737
		.buy Recipe: Broiled Mountain Trout##65411 |n
		.learn Broiled Mountain Trout##88012
	step
		goto Orgrimmar 56.8,62.6
		.talk Shazdar##49737
		.buy Recipe: Lavascale Fillet##65407 |n
		.learn Lavascale Fillet##88024
	step
		goto Orgrimmar 56.8,62.6
		.talk Shazdar##49737
		.buy Recipe: Lightly Fried Lurker##65412 |n
		.learn Lightly Fried Lurker##88028
	step
		goto Orgrimmar 56.8,62.6
		.talk Shazdar##49737
		.buy Recipe: Lurker Lunch##65416 |n
		.learn Lurker Lunch##88030
	step
		goto Orgrimmar 56.8,62.6
		.talk Shazdar##49737
		.buy Recipe: Salted Eye##65410 |n
		.learn Salted Eye##88035
	step
		goto Orgrimmar 56.8,62.6
		.talk Shazdar##49737
		.buy Recipe: Seasoned Crab##65413 |n
		.learn Seasoned Crab##88037
	step
		goto Orgrimmar 56.8,62.6
		.talk Shazdar##49737
		.buy Recipe: Whitecrest Gumbo##65406 |n
		.learn Whitecrest Gumbo##88047
	step
		#include "trainer_Cooking_MoP"
		.learn Peach Pie##124232
	step
		goto Orgrimmar 56.8,62.6
		.talk Shazdar##49737
		.buy Recipe: Hearty Seafood Soup##65418 |n
		.learn Hearty Seafood Soup##88021
	step
		goto Orgrimmar 56.8,62.6
		.talk Shazdar##49737
		.buy Recipe: Pickled Guppy##65417 |n
		.learn Pickled Guppy##88033
	step
		goto Orgrimmar 56.8,62.6
		.talk Shazdar##49737
		.buy Recipe: Tender Baked Turtle##65419 |n
		.learn Tender Baked Turtle##88046
	step
		goto Orgrimmar 56.8,62.6
		.talk Shazdar##49737
		.buy Recipe: Fish Fry##65423 |n
		.learn Fish Fry##88018
	step
		#include "trainer_Cooking_MoP"
		.learn Tangy Yogurt##124230
	step
		#include "trainer_Cooking_MoP"
		.learn Pearl Milk Tea##125080
	step
		#include "trainer_Cooking"
		.learn Fish Cake##104297
	step
		#include "trainer_Cooking"
		.learn Golden Carp Consomme##104237
	step
		goto Orgrimmar 48.5,75.6
		.talk Goram##46572
		.buy Recipe: Broiled Dragon Feast##62799 |n
		.learn Broiled Dragon Feast##88011
	step
		goto Valley of the Four Winds 53.2,51.6
		.talk Gina Mudclaw##58706
		.buy Recipe: Spicy Salmon##74657 |n
		.learn Spicy Salmon##125120
	step
		goto Valley of the Four Winds 53.2,51.6
		.talk Gina Mudclaw##58706
		.buy Recipe: Spicy Vegetable Chips##74658 |n
		.learn Spicy Vegetable Chips##125123
	step
		goto Orgrimmar 56.8,62.6
		.talk Shazdar##49737
		.buy Recipe: Scalding Murglesnout##68688 |n
		.learn Scalding Murglesnout##96133
	step
		goto Orgrimmar 56.8,62.6
		.talk Shazdar##49737
		.buy Recipe: Baked Rockfish##65426 |n
		.learn Baked Rockfish##88003
	step
		goto Orgrimmar 56.8,62.6
		.talk Shazdar##49737
		.buy Recipe: Basilisk Liverdog##65427 |n
		.learn Basilisk Liverdog##88004
	step
		goto Orgrimmar 56.8,62.6
		.talk Shazdar##49737
		.buy Recipe: Beer-Basted Crocolisk##65429 |n
		.learn Beer-Basted Crocolisk##88005
	step
		goto Orgrimmar 56.8,62.6
		.talk Shazdar##49737
		.buy Recipe: Blackbelly Sushi##65424 |n
		.learn Blackbelly Sushi##88034
	step
		goto Orgrimmar 56.8,62.6
		.talk Shazdar##49737
		.buy Recipe: Crocolisk Au Gratin##65430 |n
		.learn Crocolisk Au Gratin##88014
	step
		goto Orgrimmar 56.8,62.6
		.talk Shazdar##49737
		.buy Recipe: Delicious Sagefish Tail##65422 |n
		.learn Delicious Sagefish Tail##88016
	step
		goto Orgrimmar 56.8,62.6
		.talk Shazdar##49737
		.buy Recipe: Grilled Dragon##65428 |n
		.learn Grilled Dragon##88020
	step
		goto Orgrimmar 56.8,62.6
		.talk Shazdar##49737
		.buy Recipe: Lavascale Minestrone##65409 |n
		.learn Lavascale Minestrone##88025
	step
		goto Orgrimmar 56.8,62.6
		.talk Shazdar##49737
		.buy Recipe: Mushroom Sauce Mudfish##65420 |n
		.learn Mushroom Sauce Mudfish##88031
	step
		goto Orgrimmar 56.8,62.6
		.talk Shazdar##49737
		.buy Recipe: Severed Sagefish Head##65421 |n
		.learn Severed Sagefish Head##88039
	step
		goto Orgrimmar 56.8,62.6
		.talk Shazdar##49737
		.buy Recipe: Skewered Eel##65425 |n
		.learn Skewered Eel##88042
	step
		goto Orgrimmar 56.8,62.6
		.talk Shazdar##49737
		.buy Recipe: Chocolate Cookie##65431 |n
		.learn Chocolate Cookie##88013
	step
		#include "trainer_Cooking_MoP"
		.learn Wildfowl Ginseng Soup##125121
	step
		#include "trainer_Cooking_MoP"
		.learn Rice Pudding##125122
	step
		goto Orgrimmar 56.8,62.6
		.talk Shazdar##49737
		.buy Recipe: Fortune Cookie##65432 |n
		.learn Fortune Cookie##88019
	step
		goto Orgrimmar 48.5,75.6
		.talk Goram##46572
		.buy Recipe: Seafood Magnifique Feast##62800 |n
		.learn Seafood Magnifique Feast##88036
	step
		goto Orgrimmar 56.8,62.6
		.talk Shazdar##49737
		.buy Recipe: South Island Iced Tea##65433 |n
		.learn South Island Iced Tea##88044
	step
		goto Krasarang Wilds 68.4,43.4
		.talk Nat Pagle##637721
		.buy Recipe: Krasarang Fritters##85505 |n
		.learn Krasarang Fritters##124032
	step	
		goto Krasarang Wilds 68.4,43.4
		.talk Nat Pagle##637721
		.buy Recipe: Viseclaw Soup##85502 |n
		.learn Viseclaw Soup##124029
	step
		.talk Kol Ironpaw##58712
		.learn Charbroiled Tiger Steak##104298
	step
		.talk Bobo Ironpaw##58717
		.learn Ginseng Tea##124052
	step
		.talk Anthea Ironpaw##58713
		.learn Sauteed Carrots##104301
	step
		.talk Yan Ironpaw##58715
		.learn Shrimp Dumplings##104307
	step
		.talk Mei Mei Ironpaw##58714
		.learn Swirling Mist Soup##104304
	step
		.talk Jian Ironpaw##58716
		.learn Wildfowl Roast##104310
	step
		.talk Mei Mei Ironpaw##58714
		.learn Braised Turtle##104305
	step
		.talk Kol Ironpaw##58712
		.learn Eternal Blossom Fish##104299
	step
		.talk Yan Ironpaw##58715
		.learn Fire Spirit Salmon##104308
	step
		.talk Bobo Ironpaw##58717
		.learn Jade Witch Brew##124053
	step
		.talk Jian Ironpaw##58716
		.learn Twin Fish Platter##104311
	step
		.talk Anthea Ironpaw##58713
		.learn Valley Stir Fry##104302
	step
		.talk Bobo Ironpaw##58717
		.learn Banquet of the Brew##125602
	step
		.talk Kol Ironpaw##58712
		.learn Banquet of the Grill##125141
	step
		.talk Jian Ironpaw##58716
		.learn Banquet of the Oven##125600
	step
		.talk Mei Mei Ironpaw##58714
		.learn Banquet of the Pot##125596
	step
		.talk Yan Ironpaw##58715
		.learn Banquet of the Steamer##125598
	step
		.talk Anthea Ironpaw##58713
		.learn Banquet of the Wok##125594
	step
		.talk Bobo Ironpaw##58717
		.learn Great Banquet of the Brew##125603
	step
		.talk Kol Ironpaw##58712
		.learn Great Banquet of the Grill##125142
	step
		.talk Jian Ironpaw##58716
		.learn Great Banquet of the Oven##125601
	step
		.talk Mei Mei Ironpaw##58714
		.learn Great Banquet of the Pot##125597
	step
		.talk Yan Ironpaw##58715
		.learn Great Banquet of the Steamer##125599
	step
		.talk Anthea Ironpaw##58713
		.learn Great Banquet of the Wok##125595
	step
		.talk Kol Ironpaw##58712
		.learn Black Pepper Ribs and Shrimp##104300
	step
		.talk Jian Ironpaw##58716
		.learn Chun Tian Spring Rolls##104312
	step
		goto Krasarang Wilds 52.3,88.7
		.click Barrel of Banana Infused Rum##288
		.collect Recipe: Banana Infused Rum##87266 |n
		.learn Banana Infused Rum##126655
	step
		goto Kun-Lai Summit 44.7,52.3
		.click Tablet of Ren Yun##5
		.collect Tablet of Ren Yun##86393 |n
		.learn Four Senses Brew##126654
]])

ZygorGuidesViewer:RegisterInclude("Profession_List_Engineering",[[
		'This Recipe is learned by learning the Engineering Skill.
		.learn Rough Blasting Powder
	step
		'This Recipe is learned by learning the Engineering Skill.
		.learn Rough Dynamite##3919
	step	
		#include "trainer_Engineering"
		.learn Handful of Copper Bolts##3922
	step
		#include "trainer_Engineering"
		.learn Rough Copper Bomb##3923
	step
		#include "trainer_Engineering"
		.learn Arclight Spanner##7430
	step
		#include "trainer_Engineering"
		.learn Rough Boomstick##3925
	step
		#include "trainer_Engineering"
		.learn Crude Scope##3977
	step
		#include "trainer_Engineering"
		.learn Coarse Blasting Powder##3929
	step
		#include "trainer_Engineering"
		.learn Coarse Dynamite##3931
	step
		'This is a Random World Drop, from creatures level 6-20 and in some dungeons.
		|tip We recommend Gnomeregan or Elwynn Forest for grinding.
		.collect Schematic: Mechanical Squirrel Box##4408 |n
		.learn Mechanical Squirrel Box##3928
	step
		#include "trainer_Engineering"
		.learn Target Dummy##3932
	step
		#include "trainer_Engineering"
		.learn Silver Contact##3973
	step
		#include "trainer_Engineering"
		.learn Clockwork Box##8334
	step
		'This is a Random World Drop, from creatures level 9-26 and in some dungeons.
		|tip We recommend Gnomeregan or Northern Barrens for grinding.
		.collect Schematic: EZ-Thro Dynamite##6716 |n
		.learn EZ-Thro Dynamite##8339
	step
		#include "trainer_Engineering"
		.learn Flying Tiger Goggles##3934
	step
		'This is a Random World Drop, from creatures level 9-25 and in some dungeons.
		|tip We recommend Gnomeregan or Ragefire Chasm for grinding.
		.collect Schematic: Small Seaforium Charge##4409 |n
		.learn Small Seaforium Charge##3933
	step
		#include "trainer_Engineering"
		.learn Bronze Tube##3938
	step
		#include "trainer_Engineering"
		.learn Large Copper Bomb##3937
	step
		#include "trainer_Engineering"
		.learn Deadly Blunderbuss##3936
	step
		#include "trainer_Engineering"
		.learn Standard Scope##3978
	step
		#include "trainer_Engineering"
		.learn Small Bronze Bomb##3941
	step
		#include "trainer_Engineering"
		.learn Lovingly Crafted Boomstick##3939
	step
		'This is a Random World Drop, from creatures level 16-30 and in some dungeons.
		|tip We recommend Gnomeregan or Blackfathom Deeps for grinding.
		.collect Schematic: Shadow Goggles##4410 |n
		.learn Shadow Goggles##3940
	step
		#include "trainer_Engineering"
		.learn Heavy Blasting Powder##3945
	step
		#include "trainer_Engineering"
		.learn Heavy Dynamite##3946
	step
		goto Moonglade 54.0,35.0
		.talk Fariel Starsong##15909
		|tip You can only purchase this from her during the Lunar Festival. This is at the end of Janurary.
		.buy Small Rocket Recipes##21740 |n
		.' Open your Small Rocket Recipes |use Small Rocket Recipes##21740
		.collect Flame Deflector##3944 |n
		.collect Small Red Rocket##26418 |n
		.collect Small Green Rocket##26417 |n
		.collect Schematic: Small Blue Rocket##21724 |n
		.learn Small Blue Rocket##26416
	step
		goto Gnomeregan/4 31.2,31.0
		.from Mekgineer Thermaplugg##7800
		|tip This has a very low drop rate.
		.collect Schematic: Flame Deflector##4411 |n
		.learn Flame Deflector##3944
	step
		#include "trainer_Engineering"
		.learn Whirring Bronze Gizmo##3942
	step
		goto Gnomeregan 31.2,31.0
		.from Mekgineer Thermaplugg##7800
		.collect Schematic: Gnomish Universal Remote##7560 |n
		.learn Gnomish Universal Remote##9269
	step
		#include "trainer_Engineering"
		.learn Silver-plated Shotgun##3949
	step
		#include "trainer_Engineering"
		.learn Ornate Spyglass##6458
	step
		#include "trainer_Engineering"
		.learn Big Bronze Bomb##3950
	step
		goto Northern Barrens 68.4,69.2
		.talk Gagsprocket##3495
		.collect Schematic: Minor Recombobulator##14639 |n
		.learn Minor Recombobulator##3952
	step
		#include "trainer_Engineering"
		.learn Bronze Framework##3953
	step
		'This is a Random World Drop, from creatures level 20-45 and in some dungeons.
		|tip We recommend Gnomeregan for grinding.
		.learn Schematic: Moonsight Rifle##4412 |n
		.learn Moonsight Rifle##3954
	step
		#include "trainer_Engineering"
		.learn Aquadynamic Fish Attractor##9271
	step
		goto Badlands 91.0,38.4
		.talk Buckslappy##49918
		.buy Schematic: Blue Firework##18649 |n
		.learn Blue Firework##23067
	step	
		goto Northern Barrens 68.4,69.2
		.talk Gagsprocket##3495
		.buy Schematic: Green Firework##18648 |n
		.learn Green Firework##23068
		.' You can also purchase this from Buckslappy here: [Badlands 91.0,38.4]
		'|talk Buckslappy##49918
	step
		goto Badlands 91.0,38.4
		.talk Buckslappy##49918
		.buy Schematic: Red Firework##18647 |n
		.learn Red Firework##23066
		.' You can also purchase this from Sovik here: [Orgrimmar 56.0,56.0]
		'|talk Sovik##3413
	step
		#include "trainer_Engineering"
		.learn Gold Power Core##12584
	step
		#include "trainer_Engineering"
		.learn Green Tinted Goggles##3956
	step
		#include "trainer_Engineering"
		.learn Explosive Sheep##3955
	step
		'This Schematic may no longer be in game. 
		.collect Schematic: Ice Deflector##13308 |n
		.learn Ice Deflector##3957
	step
		#include "trainer_Engineering"
		.learn Iron Strut##3958
	step
		goto Gnomeregan 31.2,31.0
		.from Mekgineer Thermaplugg##7800
		.collect Schematic: Discombobulator Ray##4413 |n
		.learn Discombobulator Ray##3959
	step
		goto Gnomeregan 31.2,31.0
		.from Mekgineer Thermaplugg##7800
		.collect Schematic: Goblin Jumper Cables##7561 |n
		.learn Goblin Jumper Cables##9273
	step
		'This is a Random World Drop, from creatures level 20-40 and in some dungeons.
		|tip We recommend Gnomeregan for grinding.
		.collect Schematic: Portable Bronze Mortar##4414 |n
		.learn Portable Bronze Mortar##3960
	step
		#include "trainer_Engineering"
		.learn Gyrochronatom##3961
	step
		#include "trainer_Engineering"
		.learn Solid Blasting Powder##12585
	step
		#include "trainer_Engineering"
		.learn Solid Dynamite##12586
	step
		goto Moonglade 54.0,35.0
		.talk Fariel Starsong##15909
		|tip You can only purchase this from her during the Lunar Festival. This is at the end of Janurary.
		.buy Large Rocket Recipes##21742 |n
		.' Open the Large Rocket Recipes |use Large Rocket Recipes##21742
		.collect Schematic: Large Red Rocket##21729 |n
		.collect Schematic: Large Green Rocket##21728 |n
		.collect Schematic: Large Blue Rocket##21727 |n
		.learn Large Red Rocket##26422
	step
		.learn Compact Harvest Reaper Kit##3963
	step
		.learn Gyromatic Micro-Adjustor##12590
	step
		.learn Iron Grenade##3962
	step
		'This is a Random World Drop, from creatures level 25-40 and in some dungeons.
		|tip We recommend Southern Barrens or Maraudon for grinding.
		.collect Schematic: Bright-Eye Goggles##10601 |n
		.learn Bright-Eye Goggles##12587
	step
		#include "trainer_Engineering"
		.learn Accurate Scope##3979
	step
		#include "trainer_Engineering"
		.learn Advanced Target Dummy##3965
	step
		goto Gnomeregan 31.2,31.0
		.from Mekgineer Thermaplugg##7800
		.collect Schematic: Flash Bomb##6672 |n
		.learn Flash Bomb##8243
	step
		'This is a Random World Drop, from creatures level 30-45 and in some dungeons.
		|tip We recommend Gnomeregan or Uldaman for grinding.
		.collect Schematic: Craftsman's Monocle##4415 |n
		.learn Craftsman's Monocle##3966
	step
		#include "trainer_Engineering"
		.learn Big Iron Bomb##3967
	step
		'This can only be obtained during the Feast of Winter Veil Holiday Event. This is from December 15 - Janurary 2.
		.collect 1 Smokywood Pastures Special Gift##17726 |n
		.' Open your Smokywood Pastures Special Gift |use Smokywood Pastures Special Gift##17726
		.' Or 
		.collect 1 Ticking Present##21327 |n
		.' Open your Ticking Present |use Ticking Present##21327
		.collect Schematic: Snowmaster 9000##17720 |n
		.learn Snowmaster 9000##21940
	step
		#include "trainer_Engineering"
		.learn Mithril Tube##12589
	step
		'This is a Random World Drop, from creatures level 30-45 and in some dungeons.
		|tip We recommend Gnomeregan or Uldaman for grinding.
		.collect Schematic: Goblin Land Mine##4416 |n
		.learn Goblin Land Mine##3968
	step
		goto Tanaris 50.6,28.6
		.talk Blizrik Buckshot##8131
		.buy Schematic: EZ-Thro Dynamite II##18650 |n
		.learn EZ-Thro Dynamite II##23069
		.' You can also purchase this from Buckslappy here: [Badlands 91.0,38.4]
		'|talk Buckslappy##49918
	step
		'This is a Random World Drop, from creatures level 30-45 and in some dungeons.
		|tip We recommend Gnomeregan or Maraudon for grinding.
		.collect Schematic: Large Seaforium Charge##4417
		.learn Large Seaforium Charge##3972
	step
		#include "trainer_Engineering"
		.learn Mechanical Repair Kit##15255
	step
		#include "trainer_Engineering"
		.learn Unstable Trigger##12591
	step
		goto Gnomeregan 31.2,31.0
		.from Mekgineer Thermaplugg##7800
		.collect Schematic: Gnomish Cloaking Device##7742 |n
		.learn Gnomish Cloaking Device##3971
	step	
		goto Northern Stranglethorn 67.6,61.0
		.talk Gnaz Blunderflame##2687
		.buy Schematic: Mechanical Dragonling##13311 |n
		.learn Mechanical Dragonling##3969
		.' You can also purchase this from Kaye Toogie here: [Dalaran 34.0,35.6]
		'|talk Kaye Toogie##35826
	step
		'This Schematic may no longer be in the game.
		.learn The Mortar: Reloaded##13240
	step
		#include "trainer_Engineering"
		.learn Goblin Rocket Fuel Recipe##12715
	step
		#include "trainer_Engineering"
		.learn Inlaid Mithril Cylinder Plans##12895
	step
		'This drops from the Bosses in Gnomeregan
		.collect Schematic: Lil Smoky##11827##11827 |n
		.learn Lil Smoky##15633
	step
		goto Gnomeregan 31.2,31.0
		.from Mekgineer Thermaplugg##7800
		.collect Schematic: Pet Bombling##11828 |n
		.learn Pet Bombling##15628
	step
		#include "trainer_Engineering"
		.learn Goblin Sapper Charge##12760
	step
		#include "trainer_Engineering"
		.learn Fire Goggles##12594
	step
		#include "trainer_Engineering"
		.learn Gnomish Shrink Ray##12899
	step
		#include "trainer_Engineering"
		.learn Goblin Construction Helmet##12718
	step
		#include "trainer_Engineering"
		.learn Goblin Mining Helmet##12717
	step
		#include "trainer_Engineering"
		.learn Goblin Mortar##12716
	step
		#include "trainer_Engineering"
		.learn Mithril Blunderbuss##12595
	step
		#include "trainer_Engineering"
		.learn Gnomish Net-o-Matic Projector##12902
	step
		goto Northern Stranglethorn 67.6,61.0
		.talk Knaz Blunderflame##8679
		.buy Schematic: Deadly Scope##10602 |n
		.learn Deadly Scope##12597
		.' You can also purchase this from Yuka Screwspigot here: [Blackrock Depths 37.2,79.6]
		'|talk Yuka Screwspigot##45843
	step
		#include "trainer_Engineering"
		.learn Gnomish Rocket Boots##12905
	step
		#include "trainer_Engineering"
		.learn Mithril Casing##12599
	step
		#include "trainer_Engineering"
		.learn Mithril Frag Bomb##12603
	step
		#include "trainer_Engineering"
		.learn Gnomish Goggles##12897
	step
		#include "trainer_Engineering"
		.learn Gnomish Harm Prevention Belt##12903
	step
		'This is a Random World Drop, from creatures level 28-52 and in some dungeons.
		|tip We recommend Dire Maul or Eastern Plaguelands for grinding.
		.collect Schematic: Catseye Ultra Goggles##10603 |n
		.learn Catseye Ultra Goggles##12607
	step
		'This is a Random World Drop, from creatures level 28-52 and in some dungeons.
		|tip We recommend Razorfen Downs or Dire Maul for grinding.
		.collect Schematic: Mithril Heavy-Bore Rifle##10604 |n
		.learn Mithril Heavy-bore Rifle##12614
	step
		goto Moonglade 54.0,35.0
		.talk Fariel Starsong##15909
		|tip You can only purchase this from her during the Lunar Festival. This is at the end of Janurary.
		.buy Cluster Rocket Recipes##21741 |n
		.' Open the Large Rocket Recipes |use Large Rocket Recipes##21742
		.collect Schematic: Red Rocket Cluster##21732 |n
		.collect Schematic: Blue Rocket Cluster##21730 |n
		.collect Schematic: Green Rocket Cluster##21731 |n
		.learn Red Rocket Cluster##26425
		.learn Blue Rocket Cluster##26423
		.learn Green Rocket Cluster##26424
	step
		#include "trainer_Engineering"
		.learn Goblin Rocket Boots##8895
	step
		'This is a Random World Drop, from creatures level 35-52 and in some dungeons.
		|tip We recommend Fellwood or Dire Maul for grinding.
		.collect Schematic: Parachute Cloak##10606 |n
		.learn Parachute Cloak##12616
	step
		#include "trainer_Engineering"
		.learn Spellpower Goggles Xtreme##12615
	step
		goto Moonglade 54.0,35.0
		.talk Fariel Starsong##15909
		|tip You can only purchase this from her during the Lunar Festival. This is at the end of Janurary.
		.buy Schematic: Firework Launcher##44919 |n
		.learn Firework Launcher##26442
	step
		#include "trainer_Engineering"
		.learn Goblin Bomb Dispenser##12755
	step
		#include "trainer_Engineering"
		.learn Deepdive Helmet##12617
	step
		#include "trainer_Engineering"
		.learn Rose Colored Goggles##12618
	step
		#include "trainer_Engineering"
		.learn Gnomish Battle Chicken##12906
	step
		#include "trainer_Engineering"
		.learn Hi-Explosive Bomb##12619
	step
		#include "trainer_Engineering"
		.learn The Big One##12754
	step
		#include "trainer_Engineering"
		.learn Gnomish Mind Control Cap##12907
	step
		#include "trainer_Engineering"
		.learn Gnomish Death Ray##12759
	step
		#include "trainer_Engineering"
		.learn Goblin Dragon Gun##12908
	step
		'This is a Random World Drop, from creatures level 28-52 and in some dungeons.
		|tip We recommend Blackwing Lair or Dire Maul for grinding.
		.collect Schematic: Sniper Scope##10608 |n
		.learn Sniper Scope##12620
	step
		#include "trainer_Engineering"
		.learn Green Lens##12622
	step
		#include "trainer_Engineering"
		.learn Goblin Rocket Helmet##12758
	step
		#include "trainer_Engineering"
		.learn Dense Blasting Powder##19788
	step
		#include "trainer_Engineering"
		.learn Dense Dynamite##23070
	step
		goto Feralas 48.6,44.8
		.talk Zorbin Fandazzle##14637
		|tip You may have to do 2 quest's before you can purchase this Schematic.
		.buy Schematic: Snake Burst Firework##19027 |n
		.learn Snake Burst Firework##23507
	step
		#include "trainer_Engineering"
		.learn High-powered Flashlight##63750
	step
		goto Dalaran 34.0,35.6
		.talk Kaye Toogie##35826
		.buy Schematic: Mithril Mechanical Dragonling##10609 |n
		.learn Mithril Mechanical Dragonling##12624
		.' You can also purchase this from Ruppo Zipcoil here: [The HInterlands 34.2,37.8]
		'|talk Ruppo Zipcoil##2688
	step	
		#include "trainer_Engineering"
		.learn Salt Shaker##19567
	step
		'This Schematic is obtained by doing the quest A Yeti of Your Own.
		goto Winterspring 59.2,49.8
		.talk Umi Rumplesnicker##10305
		..accept A Yeti of Your Own##8798
		..turnin A Yeti of Your Own##8798
		.learn Tranquil Mechanical Yeti##26011
	step
		goto Blackrock Depths/2 37.8,73.0
		.from Weapon Technician##8920
		.collect Schematic: World Enlarger##18661 |n
		.learn World Enlarger##23129
	step
		#include "trainer_Engineering"
		.learn Truesilver Transformer##23071
	step
		goto Winterspring 59.2,50.8
		.talk Xizzer Fizzbolt##11185
		.buy Schematic: Gyrofreeze Ice Reflector##18652 |n
		.learn Gyrofreeze Ice Reflector##23077
	step
		.learn Thorium Rifle##19792
	step
		.learn Thorium Grenade##19790
	step
		.learn Thorium Widget##19791
	step
		'This Schematic is learned by choosing Goblin Engineering.
		.learn Dimensional Ripper - Everlook##23486
	step
		'This Schematic is learned by choosing Gnomish Engineering.
		.learn Ultrasafe Transporter - Gadgetzan##23489
	step
		goto Blackrock Depths/2 37.8,73.0
		.from Weapon Technician
		.collect Schematic: Gnomish Alarm-o-Bot##18654 |n
		.learn Gnomish Alarm-o-Bot##23096
	step	
		goto Blackrock Depths 50.0,61.6
		.from Plugger Spazzring##9499
		.collect Schematic: Goblin Jumper Cables XL##18653 |n
		.learn Goblin Jumper Cables XL##23078
	step
		'This is a Random World Drop, from creatures level 28-52 and in some dungeons.
		|tip We recommend Blackwing Lair or Dire Maul for grinding.
		.collect Schematic: Lifelike Mechanical Toad##16044 |n
		.learn Lifelike Mechanical Toad##19793
	step
		.learn Spellpower Goggles Xtreme Plus##19794
	step
		.learn Fused Wiring##39895
	step
		goto Moonglade 54.0,35.0
		.talk Fariel Starsong##15909
		|tip You can only purchase this from her during the Lunar Festival. This is at the end of Janurary.
		.buy Large Cluster Rocket Recipes##21743 |n
		.' Open the Large Cluster Rocket Recipes |use Large Cluster Rocket Recipes##21743 |n
		.collect Schematic: Large Blue Rocket Cluster##21733 |n
		.collect Schematic: Large Green Rocket Cluster##21734 |n
		.collect Schematic: Large Red Rocket Cluster##21735 |n
		.learn Large Blue Rocket Cluster##26426
		.learn Large Green Rocket Cluster##26427
		.learn Large Red Rocket Cluster##26428
	step
		goto Orgrimmar 56.0,56.0
		.talk Sovik##3413
		.buy Schematic: Steam Tonk Controller##22729 |n
		.learn Steam Tonk Controller##28327
	step
		goto Winterspring 59.2,50.8
		.talk Xizzer Fizzbolt##11185
		.buy Schematic: Powerful Seaforium Charge##18